/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.CatalogTestUtils;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalog;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogSuite;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.hive.HiveExternalCatalog;
import org.apache.spark.sql.hive.HiveExternalCatalog$;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Q2Aa\u0002\u0005\u0001'!)A\u0004\u0001C\u0001;!9\u0001\u0005\u0001b\u0001\n\u0013\t\u0003BB\u0013\u0001A\u0003%!\u0005C\u0004'\u0001\t\u0007I\u0011K\u0014\t\r-\u0002\u0001\u0015!\u0003)\u0011\u0015a\u0003\u0001\"\u0015.\u0005aA\u0015N^3FqR,'O\\1m\u0007\u0006$\u0018\r\\8h'VLG/\u001a\u0006\u0003\u0013)\tA\u0001[5wK*\u00111\u0002D\u0001\u0004gFd'BA\u0007\u000f\u0003\u0015\u0019\b/\u0019:l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ii\u0011A\u0006\u0006\u0003/a\tqaY1uC2|wM\u0003\u0002\u001a\u0015\u0005A1-\u0019;bYf\u001cH/\u0003\u0002\u001c-\t!R\t\u001f;fe:\fGnQ1uC2|wmU;ji\u0016\fa\u0001P5oSRtD#\u0001\u0010\u0011\u0005}\u0001Q\"\u0001\u0005\u0002\u001f\u0015DH/\u001a:oC2\u001c\u0015\r^1m_\u001e,\u0012A\t\t\u0003?\rJ!\u0001\n\u0005\u0003'!Kg/Z#yi\u0016\u0014h.\u00197DCR\fGn\\4\u0002!\u0015DH/\u001a:oC2\u001c\u0015\r^1m_\u001e\u0004\u0013!B;uS2\u001cX#\u0001\u0015\u0011\u0005UI\u0013B\u0001\u0016\u0017\u0005A\u0019\u0015\r^1m_\u001e$Vm\u001d;Vi&d7/\u0001\u0004vi&d7\u000fI\u0001\u000be\u0016\u001cX\r^*uCR,G#\u0001\u0018\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0003E\nQa]2bY\u0006L!a\r\u0019\u0003\tUs\u0017\u000e\u001e")
public class HiveExternalCatalogSuite
extends ExternalCatalogSuite {
    private final HiveExternalCatalog org$apache$spark$sql$hive$HiveExternalCatalogSuite$$externalCatalog;
    private final CatalogTestUtils utils;

    public HiveExternalCatalog org$apache$spark$sql$hive$HiveExternalCatalogSuite$$externalCatalog() {
        return this.org$apache$spark$sql$hive$HiveExternalCatalogSuite$$externalCatalog;
    }

    public CatalogTestUtils utils() {
        return this.utils;
    }

    public void resetState() {
        this.org$apache$spark$sql$hive$HiveExternalCatalogSuite$$externalCatalog().client().reset();
    }

    /*
     * WARNING - void declaration
     */
    public HiveExternalCatalogSuite() {
        void var1_1;
        HiveExternalCatalog catalog = new HiveExternalCatalog(new SparkConf(), new Configuration());
        catalog.client().reset();
        this.org$apache$spark$sql$hive$HiveExternalCatalogSuite$$externalCatalog = var1_1;
        this.utils = new CatalogTestUtils(this){
            private final String tableInputFormat;
            private final String tableOutputFormat;
            private final String defaultProvider;
            private final /* synthetic */ HiveExternalCatalogSuite $outer;

            public String tableInputFormat() {
                return this.tableInputFormat;
            }

            public String tableOutputFormat() {
                return this.tableOutputFormat;
            }

            public ExternalCatalog newEmptyCatalog() {
                return this.$outer.org$apache$spark$sql$hive$HiveExternalCatalogSuite$$externalCatalog();
            }

            public String defaultProvider() {
                return this.defaultProvider;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tableInputFormat = "org.apache.hadoop.mapred.SequenceFileInputFormat";
                this.tableOutputFormat = "org.apache.hadoop.mapred.SequenceFileOutputFormat";
                this.defaultProvider = "hive";
            }
        };
        this.test("SPARK-18647: do not put provider in table properties for Hive serde table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            CatalogTable hiveTable = new CatalogTable(new TableIdentifier("hive_tbl", (Option)new Some((Object)"db1")), CatalogTableType$.MODULE$.MANAGED(), this.utils().storageFormat(), new StructType().add("col1", "int").add("col2", "string"), (Option)new Some((Object)"hive"), CatalogTable$.MODULE$.apply$default$6(), CatalogTable$.MODULE$.apply$default$7(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19());
            catalog.createTable(hiveTable, false);
            CatalogTable rawTable = this.org$apache$spark$sql$hive$HiveExternalCatalogSuite$$externalCatalog().client().getTable("db1", "hive_tbl");
            Map $org_scalatest_assert_macro_left = rawTable.properties();
            String $org_scalatest_assert_macro_right = HiveExternalCatalog$.MODULE$.DATASOURCE_PROVIDER();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(DDLUtils$.MODULE$.isHiveTable(this.org$apache$spark$sql$hive$HiveExternalCatalogSuite$$externalCatalog().getTable("db1", "hive_tbl")), "org.apache.spark.sql.execution.command.DDLUtils.isHiveTable(HiveExternalCatalogSuite.this.externalCatalog.getTable(\"db1\", \"hive_tbl\"))", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        }, new Position("HiveExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"parquet", "hive"}))).foreach((Function1 & Serializable & scala.Serializable)format -> {
            this.test(new StringBuilder(74).append("Partition columns should be put at the end of table schema for the format ").append(format).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                ExternalCatalog catalog = $this.utils().newBasicCatalog();
                StructType newSchema = new StructType().add("col1", "int").add("col2", "string").add("partCol1", "int").add("partCol2", "string");
                CatalogTable table = new CatalogTable(new TableIdentifier("tbl", (Option)new Some((Object)"db1")), CatalogTableType$.MODULE$.MANAGED(), CatalogStorageFormat$.MODULE$.empty(), new StructType().add("col1", "int").add("partCol1", "int").add("partCol2", "string").add("col2", "string"), (Option)new Some((Object)format), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partCol1", "partCol2"})), CatalogTable$.MODULE$.apply$default$7(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19());
                catalog.createTable(table, false);
                CatalogTable restoredTable = $this.org$apache$spark$sql$hive$HiveExternalCatalogSuite$$externalCatalog().getTable("db1", "tbl");
                StructType $org_scalatest_assert_macro_left = restoredTable.schema();
                StructType $org_scalatest_assert_macro_right = newSchema;
                StructType structType = $org_scalatest_assert_macro_left;
                StructType structType2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
                return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
            }, new Position("HiveExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
            return BoxedUnit.UNIT;
        });
        this.test("SPARK-22306: alter table schema should not erase the bucketing metadata at hive side", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String bucketString;
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            this.org$apache$spark$sql$hive$HiveExternalCatalogSuite$$externalCatalog().client().runSqlHive(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE db1.t(a string, b string)\n        |CLUSTERED BY (a, b) SORTED BY (a, b) INTO 10 BUCKETS\n        |STORED AS PARQUET\n      ")).stripMargin());
            StructType newSchema = new StructType().add("a", "string").add("b", "string").add("c", "string");
            catalog.alterTableDataSchema("db1", "t", newSchema);
            StructType $org_scalatest_assert_macro_left = catalog.getTable("db1", "t").schema();
            StructType $org_scalatest_assert_macro_right = newSchema;
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
            String $org_scalatest_assert_macro_left2 = bucketString = (String)((IterableLike)this.org$apache$spark$sql$hive$HiveExternalCatalogSuite$$externalCatalog().client().runSqlHive("DESC FORMATTED db1.t").filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.contains("Num Buckets")))).head();
            String $org_scalatest_assert_macro_right2 = "10";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
        }, new Position("HiveExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        this.test("SPARK-23001: NullPointerException when running desc database", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            CatalogDatabase qual$1 = this.utils().newDb("dbWithNullDesc");
            Object x$1 = null;
            String x$2 = qual$1.copy$default$1();
            URI x$3 = qual$1.copy$default$3();
            Map x$4 = qual$1.copy$default$4();
            catalog.createDatabase(qual$1.copy(x$2, null, x$3, x$4), false);
            String $org_scalatest_assert_macro_left = catalog.getDatabase("dbWithNullDesc").description();
            String $org_scalatest_assert_macro_right = "";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        }, new Position("HiveExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
    }
}

