/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.QueryTest;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.columnar.InMemoryRelation;
import org.apache.spark.sql.execution.columnar.InMemoryTableScanExec;
import org.apache.spark.sql.execution.datasources.CatalogFileIndex;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.test.TestHiveContext;
import org.apache.spark.sql.hive.test.TestHiveSingleton;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.test.SQLTestData;
import org.apache.spark.sql.test.SQLTestData$internalImplicits$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.test.SQLTestUtilsBase;
import org.apache.spark.sql.test.SQLTestUtilsBase$testImplicits$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockResult;
import org.apache.spark.storage.RDDBlockId;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.AbstractPatienceConfiguration$PatienceConfig$;
import org.scalatest.concurrent.Eventually;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.concurrent.ScaledTimeSpans;
import org.scalatest.time.Span;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00013A\u0001B\u0003\u0001!!)\u0001\u0005\u0001C\u0001C!)A\u0005\u0001C\u0001K!)\u0011\b\u0001C\u0001u\t\u00012)Y2iK\u0012$\u0016M\u00197f'VLG/\u001a\u0006\u0003\r\u001d\tA\u0001[5wK*\u0011\u0001\"C\u0001\u0004gFd'B\u0001\u0006\f\u0003\u0015\u0019\b/\u0019:l\u0015\taQ\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001d\u0005\u0019qN]4\u0004\u0001M!\u0001!E\u000b\u001c!\t\u00112#D\u0001\b\u0013\t!rAA\u0005Rk\u0016\u0014\u0018\u0010V3tiB\u0011a#G\u0007\u0002/)\u0011\u0001dB\u0001\u0005i\u0016\u001cH/\u0003\u0002\u001b/\ta1+\u0015'UKN$X\u000b^5mgB\u0011ADH\u0007\u0002;)\u0011\u0001$B\u0005\u0003?u\u0011\u0011\u0003V3ti\"Kg/Z*j]\u001edW\r^8o\u0003\u0019a\u0014N\\5u}Q\t!\u0005\u0005\u0002$\u00015\tQ!A\u0004sI\u0012LEm\u00144\u0015\u0005\u0019b\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#aA%oi\")QF\u0001a\u0001]\u0005IA/\u00192mK:\u000bW.\u001a\t\u0003_Yr!\u0001\r\u001b\u0011\u0005EBS\"\u0001\u001a\u000b\u0005Mz\u0011A\u0002\u001fs_>$h(\u0003\u00026Q\u00051\u0001K]3eK\u001aL!a\u000e\u001d\u0003\rM#(/\u001b8h\u0015\t)\u0004&\u0001\bjg6\u000bG/\u001a:jC2L'0\u001a3\u0015\u0005mr\u0004CA\u0014=\u0013\ti\u0004FA\u0004C_>dW-\u00198\t\u000b}\u001a\u0001\u0019\u0001\u0014\u0002\u000bI$G-\u00133")
public class CachedTableSuite
extends QueryTest
implements SQLTestUtils,
TestHiveSingleton {
    private final boolean enableAutoThreadAudit;
    private final SparkSession spark;
    private final TestHiveContext hiveContext;
    private final HiveClient hiveClient;
    private boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    private Function1<String, Dataset<Row>> sql;
    private volatile SQLTestUtilsBase$testImplicits$ testImplicits$module;
    private volatile SQLTestData$internalImplicits$ internalImplicits$module;
    private Dataset<Row> emptyTestData;
    private Dataset<Row> testData;
    private Dataset<Row> testData2;
    private Dataset<Row> testData3;
    private Dataset<Row> negativeData;
    private Dataset<Row> largeAndSmallInts;
    private Dataset<Row> decimalData;
    private Dataset<Row> binaryData;
    private Dataset<Row> upperCaseData;
    private Dataset<Row> lowerCaseData;
    private Dataset<Row> lowerCaseDataWithDuplicates;
    private RDD<SQLTestData.ArrayData> arrayData;
    private RDD<SQLTestData.MapData> mapData;
    private RDD<SQLTestData.StringData> repeatedData;
    private RDD<SQLTestData.StringData> nullableRepeatedData;
    private Dataset<Row> nullInts;
    private Dataset<Row> allNulls;
    private Dataset<Row> nullStrings;
    private Dataset<Row> tableName;
    private RDD<String> unparsedStrings;
    private RDD<SQLTestData.IntField> withEmptyParts;
    private Dataset<Row> person;
    private Dataset<Row> salary;
    private Dataset<Row> complexData;
    private Dataset<Row> courseSales;
    private Dataset<Row> trainingSales;
    private final AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    private volatile AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig$module;
    private volatile int bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$test$TestHiveSingleton$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public void afterAll() {
        TestHiveSingleton.afterAll$(this);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$beforeAll() {
        super.beforeAll();
    }

    public void beforeAll() {
        SQLTestUtils.beforeAll$((SQLTestUtils)this);
    }

    public void setupTestData() {
        SQLTestUtils.setupTestData$((SQLTestUtils)this);
    }

    public void testQuietly(String name, Function0<BoxedUnit> f) {
        SQLTestUtils.testQuietly$((SQLTestUtils)this, (String)name, f);
    }

    public void testWithUninterruptibleThread(String name, boolean quietly, Function0<BoxedUnit> body) {
        SQLTestUtils.testWithUninterruptibleThread$((SQLTestUtils)this, (String)name, (boolean)quietly, body);
    }

    public boolean testWithUninterruptibleThread$default$2() {
        return SQLTestUtils.testWithUninterruptibleThread$default$2$((SQLTestUtils)this);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtilsBase$$super$withSQLConf(Seq pairs, Function0 f) {
        PlanTestBase.withSQLConf$((PlanTestBase)this, (Seq)pairs, (Function0)f);
    }

    public SparkContext sparkContext() {
        return SQLTestUtilsBase.sparkContext$((SQLTestUtilsBase)this);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withSQLConf$((SQLTestUtilsBase)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLTestUtilsBase.withTempPath$((SQLTestUtilsBase)this, f);
    }

    public void withResourceTempPath(String resourcePath, Function1<File, BoxedUnit> f) {
        SQLTestUtilsBase.withResourceTempPath$((SQLTestUtilsBase)this, (String)resourcePath, f);
    }

    public void waitForTasksToFinish() {
        SQLTestUtilsBase.waitForTasksToFinish$((SQLTestUtilsBase)this);
    }

    public void withTempDir(Function1<File, BoxedUnit> f) {
        SQLTestUtilsBase.withTempDir$((SQLTestUtilsBase)this, f);
    }

    public void withTempPaths(int numPaths, Function1<Seq<File>, BoxedUnit> f) {
        SQLTestUtilsBase.withTempPaths$((SQLTestUtilsBase)this, (int)numPaths, f);
    }

    public void withUserDefinedFunction(Seq<Tuple2<String, Object>> functions, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withUserDefinedFunction$((SQLTestUtilsBase)this, functions, f);
    }

    public void withTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTempView$((SQLTestUtilsBase)this, viewNames, f);
    }

    public void withGlobalTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withGlobalTempView$((SQLTestUtilsBase)this, viewNames, f);
    }

    public void withTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTable$((SQLTestUtilsBase)this, tableNames, f);
    }

    public void withView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withView$((SQLTestUtilsBase)this, viewNames, f);
    }

    public void withTempDatabase(Function1<String, BoxedUnit> f) {
        SQLTestUtilsBase.withTempDatabase$((SQLTestUtilsBase)this, f);
    }

    public void withDatabase(Seq<String> dbNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withDatabase$((SQLTestUtilsBase)this, dbNames, f);
    }

    public void withLocale(String language, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withLocale$((SQLTestUtilsBase)this, (String)language, f);
    }

    public void activateDatabase(String db, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.activateDatabase$((SQLTestUtilsBase)this, (String)db, f);
    }

    public Dataset<Row> stripSparkFilter(Dataset<Row> df) {
        return SQLTestUtilsBase.stripSparkFilter$((SQLTestUtilsBase)this, df);
    }

    public Dataset<Row> logicalPlanToSparkQuery(LogicalPlan plan) {
        return SQLTestUtilsBase.logicalPlanToSparkQuery$((SQLTestUtilsBase)this, (LogicalPlan)plan);
    }

    public URI makeQualifiedPath(String path) {
        return SQLTestUtilsBase.makeQualifiedPath$((SQLTestUtilsBase)this, (String)path);
    }

    public String testFile(String fileName) {
        return SQLTestUtilsBase.testFile$((SQLTestUtilsBase)this, (String)fileName);
    }

    public void loadTestData() {
        SQLTestData.loadTestData$((SQLTestData)this);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, PatienceConfiguration.Interval interval, Function0<T> fun, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, (PatienceConfiguration.Interval)interval, fun, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, fun, (AbstractPatienceConfiguration.PatienceConfig)config, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Interval interval, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Interval)interval, fun, (AbstractPatienceConfiguration.PatienceConfig)config, (Position)pos);
    }

    public <T> T eventually(Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, fun, (AbstractPatienceConfiguration.PatienceConfig)config, (Position)pos);
    }

    public AbstractPatienceConfiguration.PatienceConfig patienceConfig() {
        return PatienceConfiguration.patienceConfig$((PatienceConfiguration)this);
    }

    public PatienceConfiguration.Timeout timeout(Span value) {
        return PatienceConfiguration.timeout$((PatienceConfiguration)this, (Span)value);
    }

    public PatienceConfiguration.Interval interval(Span value) {
        return PatienceConfiguration.interval$((PatienceConfiguration)this, (Span)value);
    }

    public final Span scaled(Span span) {
        return ScaledTimeSpans.scaled$((ScaledTimeSpans)this, (Span)span);
    }

    public double spanScaleFactor() {
        return ScaledTimeSpans.spanScaleFactor$((ScaledTimeSpans)this);
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public TestHiveContext hiveContext() {
        return this.hiveContext;
    }

    @Override
    public HiveClient hiveClient() {
        return this.hiveClient;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveContext_$eq(TestHiveContext x$1) {
        this.hiveContext = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveClient_$eq(HiveClient x$1) {
        this.hiveClient = x$1;
    }

    public boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests() {
        return this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    }

    public void org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests_$eq(boolean x$1) {
        this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests = x$1;
    }

    private Function1<String, Dataset<Row>> sql$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 1) == 0) {
                this.sql = SQLTestUtilsBase.sql$((SQLTestUtilsBase)this);
                this.bitmap$0 |= 1;
            }
        }
        return this.sql;
    }

    public Function1<String, Dataset<Row>> sql() {
        return (this.bitmap$0 & 1) == 0 ? this.sql$lzycompute() : this.sql;
    }

    public SQLTestUtilsBase$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    public SQLTestData$internalImplicits$ org$apache$spark$sql$test$SQLTestData$$internalImplicits() {
        if (this.internalImplicits$module == null) {
            this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1();
        }
        return this.internalImplicits$module;
    }

    private Dataset<Row> emptyTestData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 2) == 0) {
                this.emptyTestData = SQLTestData.emptyTestData$((SQLTestData)this);
                this.bitmap$0 |= 2;
            }
        }
        return this.emptyTestData;
    }

    public Dataset<Row> emptyTestData() {
        return (this.bitmap$0 & 2) == 0 ? this.emptyTestData$lzycompute() : this.emptyTestData;
    }

    private Dataset<Row> testData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 4) == 0) {
                this.testData = SQLTestData.testData$((SQLTestData)this);
                this.bitmap$0 |= 4;
            }
        }
        return this.testData;
    }

    public Dataset<Row> testData() {
        return (this.bitmap$0 & 4) == 0 ? this.testData$lzycompute() : this.testData;
    }

    private Dataset<Row> testData2$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 8) == 0) {
                this.testData2 = SQLTestData.testData2$((SQLTestData)this);
                this.bitmap$0 |= 8;
            }
        }
        return this.testData2;
    }

    public Dataset<Row> testData2() {
        return (this.bitmap$0 & 8) == 0 ? this.testData2$lzycompute() : this.testData2;
    }

    private Dataset<Row> testData3$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.testData3 = SQLTestData.testData3$((SQLTestData)this);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.testData3;
    }

    public Dataset<Row> testData3() {
        return (this.bitmap$0 & 0x10) == 0 ? this.testData3$lzycompute() : this.testData3;
    }

    private Dataset<Row> negativeData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.negativeData = SQLTestData.negativeData$((SQLTestData)this);
                this.bitmap$0 |= 0x20;
            }
        }
        return this.negativeData;
    }

    public Dataset<Row> negativeData() {
        return (this.bitmap$0 & 0x20) == 0 ? this.negativeData$lzycompute() : this.negativeData;
    }

    private Dataset<Row> largeAndSmallInts$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.largeAndSmallInts = SQLTestData.largeAndSmallInts$((SQLTestData)this);
                this.bitmap$0 |= 0x40;
            }
        }
        return this.largeAndSmallInts;
    }

    public Dataset<Row> largeAndSmallInts() {
        return (this.bitmap$0 & 0x40) == 0 ? this.largeAndSmallInts$lzycompute() : this.largeAndSmallInts;
    }

    private Dataset<Row> decimalData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.decimalData = SQLTestData.decimalData$((SQLTestData)this);
                this.bitmap$0 |= 0x80;
            }
        }
        return this.decimalData;
    }

    public Dataset<Row> decimalData() {
        return (this.bitmap$0 & 0x80) == 0 ? this.decimalData$lzycompute() : this.decimalData;
    }

    private Dataset<Row> binaryData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.binaryData = SQLTestData.binaryData$((SQLTestData)this);
                this.bitmap$0 |= 0x100;
            }
        }
        return this.binaryData;
    }

    public Dataset<Row> binaryData() {
        return (this.bitmap$0 & 0x100) == 0 ? this.binaryData$lzycompute() : this.binaryData;
    }

    private Dataset<Row> upperCaseData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.upperCaseData = SQLTestData.upperCaseData$((SQLTestData)this);
                this.bitmap$0 |= 0x200;
            }
        }
        return this.upperCaseData;
    }

    public Dataset<Row> upperCaseData() {
        return (this.bitmap$0 & 0x200) == 0 ? this.upperCaseData$lzycompute() : this.upperCaseData;
    }

    private Dataset<Row> lowerCaseData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.lowerCaseData = SQLTestData.lowerCaseData$((SQLTestData)this);
                this.bitmap$0 |= 0x400;
            }
        }
        return this.lowerCaseData;
    }

    public Dataset<Row> lowerCaseData() {
        return (this.bitmap$0 & 0x400) == 0 ? this.lowerCaseData$lzycompute() : this.lowerCaseData;
    }

    private Dataset<Row> lowerCaseDataWithDuplicates$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.lowerCaseDataWithDuplicates = SQLTestData.lowerCaseDataWithDuplicates$((SQLTestData)this);
                this.bitmap$0 |= 0x800;
            }
        }
        return this.lowerCaseDataWithDuplicates;
    }

    public Dataset<Row> lowerCaseDataWithDuplicates() {
        return (this.bitmap$0 & 0x800) == 0 ? this.lowerCaseDataWithDuplicates$lzycompute() : this.lowerCaseDataWithDuplicates;
    }

    private RDD<SQLTestData.ArrayData> arrayData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.arrayData = SQLTestData.arrayData$((SQLTestData)this);
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.arrayData;
    }

    public RDD<SQLTestData.ArrayData> arrayData() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.arrayData$lzycompute() : this.arrayData;
    }

    private RDD<SQLTestData.MapData> mapData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.mapData = SQLTestData.mapData$((SQLTestData)this);
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.mapData;
    }

    public RDD<SQLTestData.MapData> mapData() {
        return (this.bitmap$0 & 0x2000) == 0 ? this.mapData$lzycompute() : this.mapData;
    }

    private RDD<SQLTestData.StringData> repeatedData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                this.repeatedData = SQLTestData.repeatedData$((SQLTestData)this);
                this.bitmap$0 |= 0x4000;
            }
        }
        return this.repeatedData;
    }

    public RDD<SQLTestData.StringData> repeatedData() {
        return (this.bitmap$0 & 0x4000) == 0 ? this.repeatedData$lzycompute() : this.repeatedData;
    }

    private RDD<SQLTestData.StringData> nullableRepeatedData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x8000) == 0) {
                this.nullableRepeatedData = SQLTestData.nullableRepeatedData$((SQLTestData)this);
                this.bitmap$0 |= 0x8000;
            }
        }
        return this.nullableRepeatedData;
    }

    public RDD<SQLTestData.StringData> nullableRepeatedData() {
        return (this.bitmap$0 & 0x8000) == 0 ? this.nullableRepeatedData$lzycompute() : this.nullableRepeatedData;
    }

    private Dataset<Row> nullInts$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x10000) == 0) {
                this.nullInts = SQLTestData.nullInts$((SQLTestData)this);
                this.bitmap$0 |= 0x10000;
            }
        }
        return this.nullInts;
    }

    public Dataset<Row> nullInts() {
        return (this.bitmap$0 & 0x10000) == 0 ? this.nullInts$lzycompute() : this.nullInts;
    }

    private Dataset<Row> allNulls$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x20000) == 0) {
                this.allNulls = SQLTestData.allNulls$((SQLTestData)this);
                this.bitmap$0 |= 0x20000;
            }
        }
        return this.allNulls;
    }

    public Dataset<Row> allNulls() {
        return (this.bitmap$0 & 0x20000) == 0 ? this.allNulls$lzycompute() : this.allNulls;
    }

    private Dataset<Row> nullStrings$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x40000) == 0) {
                this.nullStrings = SQLTestData.nullStrings$((SQLTestData)this);
                this.bitmap$0 |= 0x40000;
            }
        }
        return this.nullStrings;
    }

    public Dataset<Row> nullStrings() {
        return (this.bitmap$0 & 0x40000) == 0 ? this.nullStrings$lzycompute() : this.nullStrings;
    }

    private Dataset<Row> tableName$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x80000) == 0) {
                this.tableName = SQLTestData.tableName$((SQLTestData)this);
                this.bitmap$0 |= 0x80000;
            }
        }
        return this.tableName;
    }

    public Dataset<Row> tableName() {
        return (this.bitmap$0 & 0x80000) == 0 ? this.tableName$lzycompute() : this.tableName;
    }

    private RDD<String> unparsedStrings$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x100000) == 0) {
                this.unparsedStrings = SQLTestData.unparsedStrings$((SQLTestData)this);
                this.bitmap$0 |= 0x100000;
            }
        }
        return this.unparsedStrings;
    }

    public RDD<String> unparsedStrings() {
        return (this.bitmap$0 & 0x100000) == 0 ? this.unparsedStrings$lzycompute() : this.unparsedStrings;
    }

    private RDD<SQLTestData.IntField> withEmptyParts$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x200000) == 0) {
                this.withEmptyParts = SQLTestData.withEmptyParts$((SQLTestData)this);
                this.bitmap$0 |= 0x200000;
            }
        }
        return this.withEmptyParts;
    }

    public RDD<SQLTestData.IntField> withEmptyParts() {
        return (this.bitmap$0 & 0x200000) == 0 ? this.withEmptyParts$lzycompute() : this.withEmptyParts;
    }

    private Dataset<Row> person$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x400000) == 0) {
                this.person = SQLTestData.person$((SQLTestData)this);
                this.bitmap$0 |= 0x400000;
            }
        }
        return this.person;
    }

    public Dataset<Row> person() {
        return (this.bitmap$0 & 0x400000) == 0 ? this.person$lzycompute() : this.person;
    }

    private Dataset<Row> salary$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x800000) == 0) {
                this.salary = SQLTestData.salary$((SQLTestData)this);
                this.bitmap$0 |= 0x800000;
            }
        }
        return this.salary;
    }

    public Dataset<Row> salary() {
        return (this.bitmap$0 & 0x800000) == 0 ? this.salary$lzycompute() : this.salary;
    }

    private Dataset<Row> complexData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x1000000) == 0) {
                this.complexData = SQLTestData.complexData$((SQLTestData)this);
                this.bitmap$0 |= 0x1000000;
            }
        }
        return this.complexData;
    }

    public Dataset<Row> complexData() {
        return (this.bitmap$0 & 0x1000000) == 0 ? this.complexData$lzycompute() : this.complexData;
    }

    private Dataset<Row> courseSales$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x2000000) == 0) {
                this.courseSales = SQLTestData.courseSales$((SQLTestData)this);
                this.bitmap$0 |= 0x2000000;
            }
        }
        return this.courseSales;
    }

    public Dataset<Row> courseSales() {
        return (this.bitmap$0 & 0x2000000) == 0 ? this.courseSales$lzycompute() : this.courseSales;
    }

    private Dataset<Row> trainingSales$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x4000000) == 0) {
                this.trainingSales = SQLTestData.trainingSales$((SQLTestData)this);
                this.bitmap$0 |= 0x4000000;
            }
        }
        return this.trainingSales;
    }

    public Dataset<Row> trainingSales() {
        return (this.bitmap$0 & 0x4000000) == 0 ? this.trainingSales$lzycompute() : this.trainingSales;
    }

    public AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig() {
        return this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    }

    public final void org$scalatest$concurrent$PatienceConfiguration$_setter_$org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig_$eq(AbstractPatienceConfiguration.PatienceConfig x$1) {
        this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig = x$1;
    }

    public AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig() {
        if (this.PatienceConfig$module == null) {
            this.PatienceConfig$lzycompute$1();
        }
        return this.PatienceConfig$module;
    }

    public int rddIdOf(String tableName) {
        SparkPlan plan = this.hiveContext().table(tableName).queryExecution().sparkPlan();
        return BoxesRunTime.unboxToInt((Object)plan.collect((PartialFunction)new scala.Serializable(this, tableName, plan){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;
            private final String tableName$1;
            private final SparkPlan plan$1;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (!(A1 instanceof InMemoryTableScanExec)) {
                    throw this.$outer.fail(new StringBuilder(21).append("Table ").append(this.tableName$1).append(" is not cached\n").append(this.plan$1).toString(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
                }
                InMemoryTableScanExec inMemoryTableScanExec = (InMemoryTableScanExec)A1;
                InMemoryRelation relation = inMemoryTableScanExec.relation();
                Integer n = BoxesRunTime.boxToInteger((int)relation.cacheBuilder().cachedColumnBuffers().id());
                return (B1)n;
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan = x1;
                boolean bl = sparkPlan instanceof InMemoryTableScanExec ? true : true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tableName$1 = tableName$1;
                this.plan$1 = plan$1;
            }
        }).head());
    }

    public boolean isMaterialized(int rddId) {
        Option maybeBlock = this.sparkContext().env().blockManager().get((BlockId)new RDDBlockId(rddId, 0), ClassTag$.MODULE$.Nothing());
        maybeBlock.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            CachedTableSuite.$anonfun$isMaterialized$1(this, rddId, x$1);
            return BoxedUnit.UNIT;
        });
        return maybeBlock.nonEmpty();
    }

    private final void testImplicits$lzycompute$1() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new SQLTestUtilsBase$testImplicits$((SQLTestUtilsBase)this);
            }
        }
    }

    private final void org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if (this.internalImplicits$module == null) {
                this.internalImplicits$module = new SQLTestData$internalImplicits$((SQLTestData)this);
            }
        }
    }

    private final void PatienceConfig$lzycompute$1() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if (this.PatienceConfig$module == null) {
                this.PatienceConfig$module = new AbstractPatienceConfiguration$PatienceConfig$((AbstractPatienceConfiguration)this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$isMaterialized$1(CachedTableSuite $this, int rddId$1, BlockResult x$1) {
        BlockManager qual$1 = $this.sparkContext().env().blockManager();
        RDDBlockId x$12 = new RDDBlockId(rddId$1, 0);
        Option x$2 = qual$1.releaseLock$default$2();
        qual$1.releaseLock((BlockId)x$12, x$2);
    }

    public static final /* synthetic */ boolean $anonfun$new$44(CatalogTable tableMeta$1, StructField f) {
        return tableMeta$1.partitionColumnNames().contains((Object)f.name());
    }

    public CachedTableSuite() {
        ScaledTimeSpans.$init$((ScaledTimeSpans)this);
        AbstractPatienceConfiguration.$init$((AbstractPatienceConfiguration)this);
        PatienceConfiguration.$init$((PatienceConfiguration)this);
        Eventually.$init$((Eventually)this);
        SQLTestData.$init$((SQLTestData)this);
        SQLTestUtilsBase.$init$((SQLTestUtilsBase)this);
        SQLTestUtils.$init$((SQLTestUtils)this);
        TestHiveSingleton.$init$(this);
        this.test("cache table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq preCacheResults = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((Dataset)this.sql().apply((Object)"SELECT * FROM src")).collect())).toSeq();
            this.hiveContext().cacheTable("src");
            this.assertCached((Dataset)this.sql().apply((Object)"SELECT * FROM src"), this.assertCached$default$2());
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM src"), preCacheResults);
            this.assertCached((Dataset)this.sql().apply((Object)"SELECT * FROM src s"), this.assertCached$default$2());
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM src s"), preCacheResults);
            this.hiveContext().uncacheTable("src");
            this.assertCached((Dataset)this.sql().apply((Object)"SELECT * FROM src"), 0);
        }, new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        this.test("cache invalidation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE cachedTable(key INT, value STRING)");
            this.sql().apply((Object)"INSERT INTO TABLE cachedTable SELECT * FROM src");
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM cachedTable"), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.hiveContext().table("src").collect())).toSeq());
            this.hiveContext().cacheTable("cachedTable");
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM cachedTable"), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.hiveContext().table("src").collect())).toSeq());
            this.sql().apply((Object)"INSERT INTO TABLE cachedTable SELECT * FROM src");
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM cachedTable"), (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.hiveContext().table("src").collect())).toSeq().$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.hiveContext().table("src").collect())).toSeq(), Seq$.MODULE$.canBuildFrom()));
            return (Dataset)this.sql().apply((Object)"DROP TABLE cachedTable");
        }, new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        this.test("Drop cached table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE cachedTableTest(a INT)");
            this.hiveContext().cacheTable("cachedTableTest");
            ((Dataset)this.sql().apply((Object)"SELECT * FROM cachedTableTest")).collect();
            this.sql().apply((Object)"DROP TABLE cachedTableTest");
            return (AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Row[])((Dataset)this.sql().apply((Object)"SELECT * FROM cachedTableTest")).collect(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
        }, new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        this.test("DROP nonexistent table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"DROP TABLE IF EXISTS nonexistentTable"), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        this.test("uncache of nonexistent tables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String e;
            String expectedErrorMsg = "Table or view not found: nonexistentTable";
            String $org_scalatest_assert_macro_left = e = ((AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.spark().table("nonexistentTable"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106))).getMessage();
            String $org_scalatest_assert_macro_right = expectedErrorMsg;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
            String $org_scalatest_assert_macro_left2 = e = ((AnalysisException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.spark().catalog().uncacheTable("nonexistentTable"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108))).getMessage();
            String $org_scalatest_assert_macro_right2 = expectedErrorMsg;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
            String $org_scalatest_assert_macro_left3 = e = ((AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"UNCACHE TABLE nonexistentTable"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112))).getMessage();
            String $org_scalatest_assert_macro_right3 = expectedErrorMsg;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
            return (Dataset)this.sql().apply((Object)"UNCACHE TABLE IF EXISTS nonexistentTable");
        }, new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.test("no error on uncache of non-cached table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tableName = "newTable";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(20).append("CREATE TABLE ").append(tableName).append("(a INT)").toString());
                this.spark().catalog().uncacheTable(tableName);
                this.sql().apply((Object)"UNCACHE TABLE newTable");
                this.hiveContext().sparkSession().table(tableName).unpersist();
            });
        }, new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
        this.test("'CACHE TABLE' and 'UNCACHE TABLE' HiveQL statement", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CACHE TABLE src");
            this.assertCached(this.hiveContext().table("src"), this.assertCached$default$2());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.spark().catalog().isCached("src"), "CachedTableSuite.this.spark.catalog.isCached(\"src\")", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Table 'src' should be cached", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
            this.sql().apply((Object)"UNCACHE TABLE src");
            this.assertCached(this.hiveContext().table("src"), 0);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.spark().catalog().isCached("src"), "CachedTableSuite.this.spark.catalog.isCached(\"src\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Table 'src' should not be cached", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
        }, new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        this.test("CACHE TABLE tableName AS SELECT * FROM anotherTable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testCacheTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CACHE TABLE testCacheTable AS SELECT * FROM src");
            this.assertCached(this.hiveContext().table("testCacheTable"), this.assertCached$default$2());
            int rddId = this.rddIdOf("testCacheTable");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.isMaterialized(rddId), "CachedTableSuite.this.isMaterialized(rddId)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Eagerly cached in-memory table should have already been materialized", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
            this.hiveContext().uncacheTable("testCacheTable");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.isMaterialized(rddId), "CachedTableSuite.this.isMaterialized(rddId)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Uncached in-memory table should have been unpersisted", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
        }), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        this.test("CACHE TABLE tableName AS SELECT ...", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testCacheTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CACHE TABLE testCacheTable AS SELECT key FROM src LIMIT 10");
            this.assertCached(this.hiveContext().table("testCacheTable"), this.assertCached$default$2());
            int rddId = this.rddIdOf("testCacheTable");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.isMaterialized(rddId), "CachedTableSuite.this.isMaterialized(rddId)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Eagerly cached in-memory table should have already been materialized", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
            this.hiveContext().uncacheTable("testCacheTable");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.isMaterialized(rddId), "CachedTableSuite.this.isMaterialized(rddId)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Uncached in-memory table should have been unpersisted", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
        }), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
        this.test("CACHE LAZY TABLE tableName", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CACHE LAZY TABLE src");
            this.assertCached(this.hiveContext().table("src"), this.assertCached$default$2());
            int rddId = this.rddIdOf("src");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.isMaterialized(rddId), "CachedTableSuite.this.isMaterialized(rddId)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Lazily cached in-memory table shouldn't be materialized eagerly", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
            ((Dataset)this.sql().apply((Object)"SELECT COUNT(*) FROM src")).collect();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.isMaterialized(rddId), "CachedTableSuite.this.isMaterialized(rddId)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Lazily cached in-memory table should have been materialized", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
            this.hiveContext().uncacheTable("src");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.isMaterialized(rddId), "CachedTableSuite.this.isMaterialized(rddId)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"Uncached in-memory table should have been unpersisted", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
        }, new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
        this.test("CACHE TABLE with Hive UDF", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"udfTest"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CACHE TABLE udfTest AS SELECT * FROM src WHERE floor(key) = 1");
            this.assertCached(this.hiveContext().table("udfTest"), this.assertCached$default$2());
            this.hiveContext().uncacheTable("udfTest");
        }), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
        this.test("REFRESH TABLE also needs to recache the data (data source tables)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            File tempPath = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            tempPath.delete();
            this.hiveContext().table("src").write().mode(SaveMode.Overwrite).parquet(tempPath.toString());
            this.sql().apply((Object)"DROP TABLE IF EXISTS refreshTable");
            this.hiveContext().sparkSession().catalog().createTable("refreshTable", tempPath.toString(), "parquet");
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.hiveContext().table("refreshTable"), this.hiveContext().table("src"));
            this.sql().apply((Object)"CACHE TABLE refreshTable");
            this.assertCached(this.hiveContext().table("refreshTable"), this.assertCached$default$2());
            this.hiveContext().table("src").write().mode(SaveMode.Append).parquet(tempPath.toString());
            this.assertCached(this.hiveContext().table("refreshTable"), this.assertCached$default$2());
            this.assertCached(this.hiveContext().table("refreshTable"), this.assertCached$default$2());
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.hiveContext().table("refreshTable"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])this.hiveContext().table("src").union(this.hiveContext().table("src")).collect()));
            this.sql().apply((Object)"DROP TABLE refreshTable");
            this.hiveContext().sparkSession().catalog().createExternalTable("refreshTable", tempPath.toString(), "parquet");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.hiveContext().isCached("refreshTable"), "CachedTableSuite.this.hiveContext.isCached(\"refreshTable\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"refreshTable should not be cached.", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
            this.sql().apply((Object)"REFRESH TABLE refreshTable");
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.hiveContext().table("refreshTable"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])this.hiveContext().table("src").union(this.hiveContext().table("src")).collect()));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.hiveContext().isCached("refreshTable"), "CachedTableSuite.this.hiveContext.isCached(\"refreshTable\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"refreshTable should not be cached.", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
            this.sql().apply((Object)"DROP TABLE refreshTable");
            Utils$.MODULE$.deleteRecursively(tempPath);
        }, new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
        this.test("SPARK-15678: REFRESH PATH", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            File tempPath = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            tempPath.delete();
            this.hiveContext().table("src").write().mode(SaveMode.Overwrite).parquet(tempPath.toString());
            this.sql().apply((Object)"DROP TABLE IF EXISTS refreshTable");
            this.hiveContext().sparkSession().catalog().createExternalTable("refreshTable", tempPath.toString(), "parquet");
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.hiveContext().table("refreshTable"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])this.hiveContext().table("src").collect()));
            this.sql().apply((Object)"CACHE TABLE refreshTable");
            this.assertCached(this.hiveContext().table("refreshTable"), this.assertCached$default$2());
            this.hiveContext().table("src").write().mode(SaveMode.Append).parquet(tempPath.toString());
            this.assertCached(this.hiveContext().table("refreshTable"), this.assertCached$default$2());
            this.assertCached(this.hiveContext().table("refreshTable"), this.assertCached$default$2());
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.hiveContext().table("refreshTable"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])this.hiveContext().table("src").union(this.hiveContext().table("src")).collect()));
            this.sql().apply((Object)"DROP TABLE refreshTable");
            this.hiveContext().sparkSession().catalog().createExternalTable("refreshTable", tempPath.toString(), "parquet");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.hiveContext().isCached("refreshTable"), "CachedTableSuite.this.hiveContext.isCached(\"refreshTable\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"refreshTable should not be cached.", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
            this.sql().apply((Object)new StringBuilder(8).append("REFRESH ").append(tempPath.toString()).toString());
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.hiveContext().table("refreshTable"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])this.hiveContext().table("src").union(this.hiveContext().table("src")).collect()));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.hiveContext().isCached("refreshTable"), "CachedTableSuite.this.hiveContext.isCached(\"refreshTable\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"refreshTable should not be cached.", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
            this.sql().apply((Object)"DROP TABLE refreshTable");
            Utils$.MODULE$.deleteRecursively(tempPath);
        }, new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
        this.test("Cache/Uncache Qualified Tables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDatabase((Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)db -> {
            this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cachedTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringBuilder(55).append("CREATE TABLE ").append(db).append(".cachedTable STORED AS PARQUET AS SELECT 1").toString());
                $this.sql().apply((Object)new StringBuilder(24).append("CACHE TABLE ").append(db).append(".cachedTable").toString());
                $this.assertCached($this.spark().table(new StringBuilder(12).append(db).append(".cachedTable").toString()), $this.assertCached$default$2());
                $this.activateDatabase(db, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    $this.assertCached($this.spark().table("cachedTable"), $this.assertCached$default$2());
                    $this.sql().apply((Object)"UNCACHE TABLE cachedTable");
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.spark().catalog().isCached("cachedTable"), "CachedTableSuite.this.spark.catalog.isCached(\"cachedTable\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                    $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Table 'cachedTable' should not be cached", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284));
                    $this.sql().apply((Object)"CACHE TABLE cachedTable");
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool($this.spark().catalog().isCached("cachedTable"), "CachedTableSuite.this.spark.catalog.isCached(\"cachedTable\")", Prettifier$.MODULE$.default());
                    $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Table 'cachedTable' should be cached", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
                });
                $this.sql().apply((Object)new StringBuilder(26).append("UNCACHE TABLE ").append(db).append(".cachedTable").toString());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.spark().catalog().isCached(new StringBuilder(12).append(db).append(".cachedTable").toString()), "CachedTableSuite.this.spark.catalog.isCached(scala.StringContext.apply(\"\", \".cachedTable\").s(db))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Table 'cachedTable' should not be cached", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 290));
            });
            return BoxedUnit.UNIT;
        }), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
        this.test("Cache Table As Select - having database name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDatabase((Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)db -> {
            this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cachedTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Bool bool;
                String $org_scalatest_assert_macro_right;
                String e = ((ParseException)$this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(36).append("CACHE TABLE ").append(db).append(".cachedTable AS SELECT 1").toString()), ClassTag$.MODULE$.apply(ParseException.class), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299))).getMessage();
                String $org_scalatest_assert_macro_left = e;
                Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)($org_scalatest_assert_macro_right = "It is not allowed to add database prefix "), $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left2.value()) {
                    String $org_scalatest_assert_macro_left3 = e;
                    String $org_scalatest_assert_macro_right2 = "to the table name in CACHE TABLE AS SELECT";
                    bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                } else {
                    bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right3 = bool;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 302));
            });
            return BoxedUnit.UNIT;
        }), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296));
        this.test("SPARK-11246 cache parquet table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE cachedTable STORED AS PARQUET AS SELECT 1");
            this.hiveContext().cacheTable("cachedTable");
            SparkPlan sparkPlan = ((Dataset)this.sql().apply((Object)"SELECT * FROM cachedTable")).queryExecution().sparkPlan();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)sparkPlan.collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    InMemoryTableScanExec inMemoryTableScanExec;
                    A1 A1 = x1;
                    Object object = A1 instanceof InMemoryTableScanExec ? (inMemoryTableScanExec = (InMemoryTableScanExec)A1) : function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(SparkPlan x1) {
                    SparkPlan sparkPlan = x1;
                    boolean bl = sparkPlan instanceof InMemoryTableScanExec;
                    return bl;
                }
            }).size()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 313));
            return (Dataset)this.sql().apply((Object)"DROP TABLE cachedTable");
        }, new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 308));
        this.test("cache a table using CatalogFileIndex", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE test(i int) PARTITIONED BY (p int) STORED AS parquet");
            CatalogTable tableMeta = this.spark().sharedState().externalCatalog().getTable("default", "test");
            CatalogFileIndex catalogFileIndex = new CatalogFileIndex(this.spark(), tableMeta, 0L);
            StructType dataSchema = StructType$.MODULE$.apply((Seq)tableMeta.schema().filterNot((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)CachedTableSuite.$anonfun$new$44(tableMeta, f))));
            HadoopFsRelation relation = new HadoopFsRelation((FileIndex)catalogFileIndex, tableMeta.partitionSchema(), dataSchema, (Option)None$.MODULE$, (FileFormat)new ParquetFileFormat(), Predef$.MODULE$.Map().empty(), this.spark());
            LogicalRelation plan = LogicalRelation$.MODULE$.apply((BaseRelation)relation, tableMeta);
            this.spark().sharedState().cacheManager().cacheQuery(Dataset$.MODULE$.ofRows(this.spark(), (LogicalPlan)plan), this.spark().sharedState().cacheManager().cacheQuery$default$2(), this.spark().sharedState().cacheManager().cacheQuery$default$3());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.spark().sharedState().cacheManager().lookupCachedData((LogicalPlan)plan).isDefined(), "CachedTableSuite.this.spark.sharedState.cacheManager.lookupCachedData(plan).isDefined", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 338));
            CatalogFileIndex sameCatalog = new CatalogFileIndex(this.spark(), tableMeta, 0L);
            HadoopFsRelation sameRelation = new HadoopFsRelation((FileIndex)sameCatalog, tableMeta.partitionSchema(), dataSchema, (Option)None$.MODULE$, (FileFormat)new ParquetFileFormat(), Predef$.MODULE$.Map().empty(), this.spark());
            LogicalRelation samePlan = LogicalRelation$.MODULE$.apply((BaseRelation)sameRelation, tableMeta);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.spark().sharedState().cacheManager().lookupCachedData((LogicalPlan)samePlan).isDefined(), "CachedTableSuite.this.spark.sharedState.cacheManager.lookupCachedData(samePlan).isDefined", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 350));
        }), new Position("CachedTableSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
    }
}

