/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst;

import java.io.Serializable;
import java.sql.Timestamp;
import org.apache.spark.sql.QueryTest;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.CurrentRow$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.FrameType;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RangeFrame$;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SpecifiedWindowFrame;
import org.apache.spark.sql.catalyst.expressions.TimeAdd;
import org.apache.spark.sql.catalyst.expressions.TimeAdd$;
import org.apache.spark.sql.catalyst.expressions.TimeSub;
import org.apache.spark.sql.catalyst.expressions.TimeSub$;
import org.apache.spark.sql.catalyst.expressions.UnboundedPreceding$;
import org.apache.spark.sql.catalyst.expressions.WindowFrame;
import org.apache.spark.sql.catalyst.expressions.WindowSpecDefinition;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hive.test.TestHiveContext;
import org.apache.spark.sql.hive.test.TestHiveSingleton;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001u2Aa\u0001\u0003\u0001\u001f!)A\u0004\u0001C\u0001;!)\u0001\u0005\u0001C\tC\tIR\t\u001f9sKN\u001c\u0018n\u001c8T#2\u0013U/\u001b7eKJ\u001cV/\u001b;f\u0015\t)a!\u0001\u0005dCR\fG._:u\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001\u0003\u0006\t\u0003#Ii\u0011AB\u0005\u0003'\u0019\u0011\u0011\"U;fef$Vm\u001d;\u0011\u0005UQR\"\u0001\f\u000b\u0005]A\u0012\u0001\u0002;fgRT!!\u0007\u0004\u0002\t!Lg/Z\u0005\u00037Y\u0011\u0011\u0003V3ti\"Kg/Z*j]\u001edW\r^8o\u0003\u0019a\u0014N\\5u}Q\ta\u0004\u0005\u0002 \u00015\tA!\u0001\u0005dQ\u0016\u001c7nU)M)\r\u0011\u0003\u0006\r\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0005+:LG\u000fC\u0003*\u0005\u0001\u0007!&A\u0001f!\tYc&D\u0001-\u0015\tiC!A\u0006fqB\u0014Xm]:j_:\u001c\u0018BA\u0018-\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\u0006c\t\u0001\rAM\u0001\fKb\u0004Xm\u0019;fIN\u000bF\n\u0005\u00024u9\u0011A\u0007\u000f\t\u0003k\u0011j\u0011A\u000e\u0006\u0003o9\ta\u0001\u0010:p_Rt\u0014BA\u001d%\u0003\u0019\u0001&/\u001a3fM&\u00111\b\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005e\"\u0003")
public class ExpressionSQLBuilderSuite
extends QueryTest
implements TestHiveSingleton {
    private final boolean enableAutoThreadAudit;
    private final SparkSession spark;
    private final TestHiveContext hiveContext;
    private final HiveClient hiveClient;

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$test$TestHiveSingleton$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public void afterAll() {
        TestHiveSingleton.afterAll$(this);
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public TestHiveContext hiveContext() {
        return this.hiveContext;
    }

    @Override
    public HiveClient hiveClient() {
        return this.hiveClient;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveContext_$eq(TestHiveContext x$1) {
        this.hiveContext = x$1;
    }

    @Override
    public void org$apache$spark$sql$hive$test$TestHiveSingleton$_setter_$hiveClient_$eq(HiveClient x$1) {
        this.hiveClient = x$1;
    }

    public void checkSQL(Expression e, String expectedSQL) {
        String actualSQL = e.sql();
        try {
            String $org_scalatest_assert_macro_left = actualSQL;
            String $org_scalatest_assert_macro_right = expectedSQL;
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionSQLBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32));
        }
        catch (Throwable cause) {
            throw this.fail(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(121).append("Wrong SQL generated for the following expression:\n             |\n             |").append(e.prettyName()).append("\n             |\n             |").append(cause).append("\n           ").toString())).stripMargin(), new Position("ExpressionSQLBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35));
        }
    }

    public static final /* synthetic */ byte $anonfun$new$2(int x$1) {
        return (byte)x$1;
    }

    public ExpressionSQLBuilderSuite() {
        TestHiveSingleton.$init$(this);
        this.test("literal", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkSQL((Expression)Literal$.MODULE$.apply((Object)"foo"), "'foo'");
            this.checkSQL((Expression)Literal$.MODULE$.apply((Object)"\"foo\""), "'\"foo\"'");
            this.checkSQL((Expression)Literal$.MODULE$.apply((Object)"'foo'"), "'\\'foo\\''");
            this.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToByte((byte)1)), "1Y");
            this.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)2)), "2S");
            this.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4)), "4");
            this.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)8L)), "8L");
            this.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)1.5f)), "CAST(1.5 AS FLOAT)");
            this.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)Float.POSITIVE_INFINITY)), "CAST('Infinity' AS FLOAT)");
            this.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)Float.NEGATIVE_INFINITY)), "CAST('-Infinity' AS FLOAT)");
            this.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)Float.NaN)), "CAST('NaN' AS FLOAT)");
            this.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)2.5)), "2.5D");
            this.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY)), "CAST('Infinity' AS DOUBLE)");
            this.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)Double.NEGATIVE_INFINITY)), "CAST('-Infinity' AS DOUBLE)");
            this.checkSQL((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)Double.NaN)), "CAST('NaN' AS DOUBLE)");
            this.checkSQL((Expression)Literal$.MODULE$.apply((Object)package$.MODULE$.BigDecimal().apply("10.0000000").underlying()), "10.0000000BD");
            this.checkSQL((Expression)Literal$.MODULE$.apply(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{1, 163})).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToByte((byte)ExpressionSQLBuilderSuite.$anonfun$new$2(BoxesRunTime.unboxToInt((Object)x$1))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()))), "X'01A3'");
            this.checkSQL((Expression)Literal$.MODULE$.apply((Object)Timestamp.valueOf("2016-01-01 00:00:00")), "TIMESTAMP('2016-01-01 00:00:00.0')");
        }, new Position("ExpressionSQLBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        this.test("attributes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkSQL((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int(), "`a`");
            this.checkSQL((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "foo bar")).int(), "`foo bar`");
            this.checkSQL((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "int")).int(), "`int`");
        }, new Position("ExpressionSQLBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        this.test("binary comparisons", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).$eq$eq$eq((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()), "(`a` = `b`)");
            this.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).$less$eq$greater((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()), "(`a` <=> `b`)");
            this.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).$eq$bang$eq((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()), "(NOT (`a` = `b`))");
            this.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).$less((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()), "(`a` < `b`)");
            this.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).$less$eq((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()), "(`a` <= `b`)");
            this.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).$greater((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()), "(`a` > `b`)");
            this.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).$greater$eq((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()), "(`a` >= `b`)");
            this.checkSQL(package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).int()})), "(`a` IN (`b`, `c`))");
            this.checkSQL(package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).in((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.intToLiteral(1), package.expressions$.MODULE$.intToLiteral(2)})), "(`a` IN (1, 2))");
            this.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).isNull(), "(`a` IS NULL)");
            this.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).isNotNull(), "(`a` IS NOT NULL)");
        }, new Position("ExpressionSQLBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        this.test("logical operators", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).boolean()).$amp$amp((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).boolean()), "(`a` AND `b`)");
            this.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).boolean()).$bar$bar((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).boolean()), "(`a` OR `b`)");
            this.checkSQL((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).boolean()).unary_$bang(), "(NOT `a`)");
            this.checkSQL((Expression)new If((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).boolean(), (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int(), (Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).int()), "(IF(`a`, `b`, `c`))");
        }, new Position("ExpressionSQLBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        this.test("arithmetic expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkSQL(package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).$plus((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()), "(`a` + `b`)");
            this.checkSQL(package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).$minus((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()), "(`a` - `b`)");
            this.checkSQL(package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).$times((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()), "(`a` * `b`)");
            this.checkSQL(package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).$div((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()), "(`a` / `b`)");
            this.checkSQL(package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).$percent((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int()), "(`a` % `b`)");
            this.checkSQL(package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).unary_$minus(), "(- `a`)");
            this.checkSQL(package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).$plus((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).int())).unary_$minus(), "(- (`a` + `b`))");
        }, new Position("ExpressionSQLBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        this.test("window specification", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SpecifiedWindowFrame frame = new SpecifiedWindowFrame((FrameType)RangeFrame$.MODULE$, (Expression)UnboundedPreceding$.MODULE$, (Expression)CurrentRow$.MODULE$);
            AttributeReference attributeReference = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int();
            this.checkSQL((Expression)new WindowSpecDefinition((Seq)Nil$.MODULE$.$colon$colon((Object)attributeReference), (Seq)Nil$.MODULE$, (WindowFrame)frame), new StringBuilder(19).append("(PARTITION BY `a` ").append(frame.sql()).append(")").toString());
            AttributeReference attributeReference2 = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int();
            AttributeReference attributeReference3 = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).string();
            this.checkSQL((Expression)new WindowSpecDefinition((Seq)Nil$.MODULE$.$colon$colon((Object)attributeReference3).$colon$colon((Object)attributeReference2), (Seq)Nil$.MODULE$, (WindowFrame)frame), new StringBuilder(24).append("(PARTITION BY `a`, `b` ").append(frame.sql()).append(")").toString());
            SortOrder sortOrder = package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).asc();
            this.checkSQL((Expression)new WindowSpecDefinition((Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder), (WindowFrame)frame), new StringBuilder(31).append("(ORDER BY `a` ASC NULLS FIRST ").append(frame.sql()).append(")").toString());
            SortOrder sortOrder2 = package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int()).asc();
            SortOrder sortOrder3 = package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).string()).desc();
            this.checkSQL((Expression)new WindowSpecDefinition((Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder3).$colon$colon((Object)sortOrder2), (WindowFrame)frame), new StringBuilder(52).append("(ORDER BY `a` ASC NULLS FIRST, `b` DESC NULLS LAST ").append(frame.sql()).append(")").toString());
            AttributeReference attributeReference4 = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).int();
            AttributeReference attributeReference5 = package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "b")).string();
            SortOrder sortOrder4 = package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "c")).int()).asc();
            SortOrder sortOrder5 = package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "d")).string()).desc();
            this.checkSQL((Expression)new WindowSpecDefinition((Seq)Nil$.MODULE$.$colon$colon((Object)attributeReference5).$colon$colon((Object)attributeReference4), (Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder5).$colon$colon((Object)sortOrder4), (WindowFrame)frame), new StringBuilder(74).append("(PARTITION BY `a`, `b` ORDER BY `c` ASC NULLS FIRST, `d` DESC NULLS LAST ").append(frame.sql()).append(")").toString());
        }, new Position("ExpressionSQLBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        this.test("interval arithmetic", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Literal interval = Literal$.MODULE$.apply((Object)new CalendarInterval(0, 86400000000L));
            this.checkSQL((Expression)new TimeAdd((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)interval, TimeAdd$.MODULE$.apply$default$3()), "`a` + interval 1 days");
            this.checkSQL((Expression)new TimeSub((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)interval, TimeSub$.MODULE$.apply$default$3()), "`a` - interval 1 days");
        }, new Position("ExpressionSQLBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
    }
}

