/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.recipes.nodes.PersistentEphemeralNode;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JvmPauseMonitor;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.util.ZooKeeperHiveHelper;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.common.util.HiveStringUtils;
import org.apache.hive.service.CompositeService;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.thrift.ThriftBinaryCLIService;
import org.apache.hive.service.cli.thrift.ThriftCLIService;
import org.apache.hive.service.cli.thrift.ThriftHttpCLIService;
import org.apache.spark.util.ShutdownHookManager;
import org.apache.spark.util.SparkExitCode;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.runtime.AbstractFunction0;
import scala.runtime.BoxedUnit;

public class HiveServer2
extends CompositeService {
    private static final Logger LOG = LoggerFactory.getLogger(HiveServer2.class);
    private CLIService cliService;
    private ThriftCLIService thriftCLIService;
    private CuratorFramework zooKeeperClient;
    private PersistentEphemeralNode znode;
    private String znodePath;
    private final ACLProvider zooKeeperAclProvider = new ACLProvider(){
        List<ACL> nodeAcls = new ArrayList<ACL>();

        public List<ACL> getDefaultAcl() {
            if (UserGroupInformation.isSecurityEnabled()) {
                this.nodeAcls.addAll(ZooDefs.Ids.READ_ACL_UNSAFE);
                this.nodeAcls.add(new ACL(31, ZooDefs.Ids.AUTH_IDS));
            } else {
                this.nodeAcls.addAll(ZooDefs.Ids.OPEN_ACL_UNSAFE);
            }
            return this.nodeAcls;
        }

        public List<ACL> getAclForPath(String path) {
            return this.getDefaultAcl();
        }
    };

    public HiveServer2() {
        super(HiveServer2.class.getSimpleName());
        HiveConf.setLoadHiveServer2Config((boolean)true);
    }

    @Override
    public synchronized void init(HiveConf hiveConf) {
        this.cliService = new CLIService(this);
        this.addService(this.cliService);
        this.thriftCLIService = HiveServer2.isHTTPTransportMode(hiveConf) ? new ThriftHttpCLIService(this.cliService) : new ThriftBinaryCLIService(this.cliService);
        this.addService(this.thriftCLIService);
        super.init(hiveConf);
        ShutdownHookManager.addShutdownHook((Function0)new AbstractFunction0<BoxedUnit>(){

            public BoxedUnit apply() {
                try {
                    LOG.info("Hive Server Shutdown hook invoked");
                    HiveServer2.this.stop();
                }
                catch (Throwable e) {
                    LOG.warn("Ignoring Exception while stopping Hive Server from shutdown hook", e);
                }
                return BoxedUnit.UNIT;
            }
        });
    }

    public static boolean isHTTPTransportMode(HiveConf hiveConf) {
        String transportMode = System.getenv("HIVE_SERVER2_TRANSPORT_MODE");
        if (transportMode == null) {
            transportMode = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_TRANSPORT_MODE);
        }
        return transportMode != null && transportMode.equalsIgnoreCase("http");
    }

    @Override
    public synchronized void start() {
        super.start();
        HiveConf hiveConf = new HiveConf();
        String zooKeeperEnsemble = ZooKeeperHiveHelper.getQuorumServers((HiveConf)hiveConf);
        LOG.info("Zookeeper ensemble: " + zooKeeperEnsemble);
        LOG.info("Hive config: " + hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_SUPPORT_DYNAMIC_SERVICE_DISCOVERY));
        if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_SUPPORT_DYNAMIC_SERVICE_DISCOVERY)) {
            try {
                this.addServerInstanceToZooKeeper(hiveConf);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private String getServerInstanceURI() throws Exception {
        if (this.thriftCLIService == null || this.thriftCLIService.getServerIPAddress() == null) {
            throw new Exception("Unable to get the server address; it hasn't been initialized yet.");
        }
        return this.thriftCLIService.getServerIPAddress().getHostName() + ":" + this.thriftCLIService.getPortNumber();
    }

    private void addConfsToPublish(HiveConf hiveConf, Map<String, String> confsToPublish) throws UnknownHostException {
        confsToPublish.put(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_BIND_HOST.varname, InetAddress.getLocalHost().getCanonicalHostName());
        confsToPublish.put(HiveConf.ConfVars.HIVE_SERVER2_TRANSPORT_MODE.varname, hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_TRANSPORT_MODE));
        if (HiveServer2.isHTTPTransportMode(hiveConf)) {
            confsToPublish.put(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_PORT.varname, hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_PORT));
            confsToPublish.put(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_PATH.varname, hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_PATH));
        } else {
            confsToPublish.put(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT.varname, hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT));
            confsToPublish.put(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_SASL_QOP.varname, hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_SASL_QOP));
        }
        confsToPublish.put(HiveConf.ConfVars.HIVE_SERVER2_AUTHENTICATION.varname, hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_AUTHENTICATION));
        confsToPublish.put(HiveConf.ConfVars.HIVE_SERVER2_USE_SSL.varname, hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_USE_SSL));
    }

    private void addServerInstanceToZooKeeper(HiveConf hiveConf) throws Exception {
        HashMap<String, String> confsToPublish;
        String instanceURI;
        String rootNamespace;
        block7: {
            String zooKeeperEnsemble = ZooKeeperHiveHelper.getQuorumServers((HiveConf)hiveConf);
            LOG.info("Register on zookeeper: " + zooKeeperEnsemble);
            rootNamespace = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_ZOOKEEPER_NAMESPACE);
            instanceURI = this.getServerInstanceURI();
            confsToPublish = new HashMap<String, String>();
            this.addConfsToPublish(hiveConf, confsToPublish);
            int sessionTimeout = (int)hiveConf.getTimeVar(HiveConf.ConfVars.HIVE_ZOOKEEPER_SESSION_TIMEOUT, TimeUnit.MILLISECONDS);
            int baseSleepTime = (int)hiveConf.getTimeVar(HiveConf.ConfVars.HIVE_ZOOKEEPER_CONNECTION_BASESLEEPTIME, TimeUnit.MILLISECONDS);
            int maxRetries = hiveConf.getIntVar(HiveConf.ConfVars.HIVE_ZOOKEEPER_CONNECTION_MAX_RETRIES);
            this.zooKeeperClient = CuratorFrameworkFactory.builder().connectString(zooKeeperEnsemble).sessionTimeoutMs(sessionTimeout).aclProvider(this.zooKeeperAclProvider).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(baseSleepTime, maxRetries)).build();
            LOG.info("hive server: start thrift server");
            this.zooKeeperClient.start();
            try {
                ((ACLBackgroundPathAndBytesable)this.zooKeeperClient.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath("/" + rootNamespace);
                LOG.info("Created the root name space: " + rootNamespace + " on ZooKeeper for HiveServer2");
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.NODEEXISTS) break block7;
                LOG.error("Unable to create HiveServer2 namespace: " + rootNamespace + " on ZooKeeper", (Throwable)e);
                throw e;
            }
        }
        try {
            String pathPrefix = "/" + rootNamespace + "/" + "serverUri=" + instanceURI + ";version=;sequence=";
            String znodeData = (String)confsToPublish.get(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_BIND_HOST.varname) + ":" + (String)confsToPublish.get(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT.varname);
            byte[] znodeDataUTF8 = znodeData.getBytes(StandardCharsets.UTF_8);
            this.znode = new PersistentEphemeralNode(this.zooKeeperClient, PersistentEphemeralNode.Mode.EPHEMERAL_SEQUENTIAL, pathPrefix, znodeDataUTF8);
            this.znode.start();
            long znodeCreationTimeout = 120L;
            if (!this.znode.waitForInitialCreate(znodeCreationTimeout, TimeUnit.SECONDS)) {
                throw new Exception("Max znode creation wait time: " + znodeCreationTimeout + "s exhausted");
            }
            this.setRegisteredWithZooKeeper();
            this.znodePath = this.znode.getActualPath();
            if (((BackgroundPathable)this.zooKeeperClient.checkExists().usingWatcher((Watcher)new DeRegisterWatcher())).forPath(this.znodePath) == null) {
                throw new Exception("Unable to create znode for this HiveServer2 instance on ZooKeeper.");
            }
            LOG.info("Created a znode on ZooKeeper for HiveServer2 uri: " + instanceURI);
        }
        catch (Exception e) {
            LOG.error("Unable to create a znode for this server instance", (Throwable)e);
            if (this.znode != null) {
                this.znode.close();
            }
            throw e;
        }
    }

    private void setRegisteredWithZooKeeper() {
    }

    @Override
    public synchronized void stop() {
        LOG.info("Shutting down HiveServer2");
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startHiveServer2() {
        long attempts = 0L;
        long maxAttempts = 1L;
        while (true) {
            LOG.info("Starting HiveServer2");
            HiveConf hiveConf = new HiveConf();
            maxAttempts = hiveConf.getLongVar(HiveConf.ConfVars.HIVE_SERVER2_MAX_START_ATTEMPTS);
            HiveServer2 server = null;
            try {
                server = new HiveServer2();
                server.init(hiveConf);
                server.start();
                try {
                    JvmPauseMonitor pauseMonitor = new JvmPauseMonitor((Configuration)hiveConf);
                    pauseMonitor.start();
                }
                catch (Throwable t) {
                    LOG.warn("Could not initiate the JvmPauseMonitor thread.", t);
                }
            }
            catch (Throwable throwable) {
                if (server != null) {
                    try {
                        server.stop();
                    }
                    catch (Throwable t) {
                        LOG.info("Exception caught when calling stop of HiveServer2 before retrying start", t);
                    }
                }
                if (++attempts >= maxAttempts) {
                    throw new Error("Max start attempts " + maxAttempts + " exhausted", throwable);
                }
                LOG.warn("Error starting HiveServer2 on attempt " + attempts + ", will retry in 60 seconds", throwable);
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) {
        HiveConf.setLoadHiveServer2Config((boolean)true);
        ServerOptionsProcessor oproc = new ServerOptionsProcessor("hiveserver2");
        ServerOptionsProcessorResponse oprocResponse = oproc.parse(args);
        HiveStringUtils.startupShutdownMessage(HiveServer2.class, (String[])args, (Logger)LOG);
        oprocResponse.getServerOptionsExecutor().execute();
    }

    static class StartOptionExecutor
    implements ServerOptionsExecutor {
        StartOptionExecutor() {
        }

        @Override
        public void execute() {
            try {
                HiveServer2.startHiveServer2();
            }
            catch (Throwable t) {
                LOG.error("Error starting HiveServer2", t);
                System.exit(-1);
            }
        }
    }

    static class HelpOptionExecutor
    implements ServerOptionsExecutor {
        private final Options options;
        private final String serverName;

        HelpOptionExecutor(String serverName, Options options) {
            this.options = options;
            this.serverName = serverName;
        }

        @Override
        public void execute() {
            new HelpFormatter().printHelp(this.serverName, this.options);
            System.exit(SparkExitCode.EXIT_SUCCESS());
        }
    }

    static interface ServerOptionsExecutor {
        public void execute();
    }

    static class ServerOptionsProcessorResponse {
        private final ServerOptionsExecutor serverOptionsExecutor;

        ServerOptionsProcessorResponse(ServerOptionsExecutor serverOptionsExecutor) {
            this.serverOptionsExecutor = serverOptionsExecutor;
        }

        ServerOptionsExecutor getServerOptionsExecutor() {
            return this.serverOptionsExecutor;
        }
    }

    public static class ServerOptionsProcessor {
        private final Options options = new Options();
        private CommandLine commandLine;
        private final String serverName;
        private final StringBuilder debugMessage = new StringBuilder();

        public ServerOptionsProcessor(String serverName) {
            this.serverName = serverName;
            OptionBuilder.withValueSeparator();
            OptionBuilder.hasArgs((int)2);
            OptionBuilder.withArgName((String)"property=value");
            OptionBuilder.withLongOpt((String)"hiveconf");
            OptionBuilder.withDescription((String)"Use value for given property");
            this.options.addOption(OptionBuilder.create());
            this.options.addOption(new Option("H", "help", false, "Print help information"));
        }

        public ServerOptionsProcessorResponse parse(String[] argv) {
            try {
                this.commandLine = new GnuParser().parse(this.options, argv);
                Properties confProps = this.commandLine.getOptionProperties("hiveconf");
                for (String propKey : confProps.stringPropertyNames()) {
                    this.debugMessage.append("Setting " + propKey + "=" + confProps.getProperty(propKey) + ";\n");
                    System.setProperty(propKey, confProps.getProperty(propKey));
                }
                if (this.commandLine.hasOption('H')) {
                    return new ServerOptionsProcessorResponse(new HelpOptionExecutor(this.serverName, this.options));
                }
            }
            catch (ParseException e) {
                System.err.println("Error starting HiveServer2 with given arguments: ");
                System.err.println(e.getMessage());
                System.exit(-1);
            }
            return new ServerOptionsProcessorResponse(new StartOptionExecutor());
        }
    }

    private class DeRegisterWatcher
    implements Watcher {
        private DeRegisterWatcher() {
        }

        public void process(WatchedEvent event) {
            if (event.getType().equals((Object)Watcher.Event.EventType.NodeDeleted) && HiveServer2.this.znode != null) {
                try {
                    HiveServer2.this.znode.close();
                    LOG.warn("This HiveServer2 instance is now de-registered from ZooKeeper. The server will be shut down after the last client sesssion completes.");
                }
                catch (IOException e) {
                    LOG.error("Failed to close the persistent ephemeral znode", (Throwable)e);
                }
                finally {
                    HiveServer2.this.setRegisteredWithZooKeeper();
                    if (HiveServer2.this.cliService.getSessionManager().getOpenSessionCount() == 0) {
                        LOG.warn("This instance of HiveServer2 has been removed from the list of server instances available for dynamic service discovery. The last client session has ended - will shutdown now.");
                        HiveServer2.this.stop();
                    }
                }
            }
        }
    }

    @InterfaceAudience.Public
    public static class ZooDefs {

        @InterfaceAudience.Public
        public static interface Ids {
            public static final Id ANYONE_ID_UNSAFE = new Id("world", "anyone");
            public static final Id AUTH_IDS = new Id("auth", "");
            @SuppressFBWarnings(value={"MS_MUTABLE_COLLECTION"}, justification="Cannot break API")
            public static final ArrayList<ACL> OPEN_ACL_UNSAFE = new ArrayList<ACL>(Collections.singletonList(new ACL(31, ANYONE_ID_UNSAFE)));
            @SuppressFBWarnings(value={"MS_MUTABLE_COLLECTION"}, justification="Cannot break API")
            public static final ArrayList<ACL> READ_ACL_UNSAFE = new ArrayList<ACL>(Collections.singletonList(new ACL(1, ANYONE_ID_UNSAFE)));
        }

        @InterfaceAudience.Public
        public static interface Perms {
            public static final int READ = 1;
            public static final int WRITE = 2;
            public static final int CREATE = 4;
            public static final int DELETE = 8;
            public static final int ADMIN = 16;
            public static final int ALL = 31;
        }
    }
}

