/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

final class PlainClient
implements SaslClient {
    private boolean completed = false;
    private byte[] pw;
    private final String authorizationID;
    private final String authenticationID;

    PlainClient(String authorizationID, String authenticationID, byte[] pw) throws SaslException {
        if (authenticationID == null || pw == null) {
            throw new SaslException("PLAIN: authorization ID and password must be specified");
        }
        this.authorizationID = authorizationID;
        this.authenticationID = authenticationID;
        this.pw = pw;
    }

    @Override
    public String getMechanismName() {
        return "PLAIN";
    }

    @Override
    public boolean hasInitialResponse() {
        return true;
    }

    @Override
    public void dispose() throws SaslException {
        this.clearPassword();
    }

    @Override
    public byte[] evaluateChallenge(byte[] challengeData) throws SaslException {
        if (this.completed) {
            throw new IllegalStateException("PLAIN authentication already completed");
        }
        this.completed = true;
        byte[] authz = this.authorizationID != null ? this.authorizationID.getBytes(StandardCharsets.UTF_8) : null;
        byte[] auth = this.authenticationID.getBytes(StandardCharsets.UTF_8);
        byte[] answer = new byte[this.pw.length + auth.length + 2 + (authz == null ? 0 : authz.length)];
        int pos = 0;
        if (authz != null) {
            System.arraycopy(authz, 0, answer, 0, authz.length);
            pos = authz.length;
        }
        byte SEP = 0;
        answer[pos++] = SEP;
        System.arraycopy(auth, 0, answer, pos, auth.length);
        pos += auth.length;
        answer[pos++] = SEP;
        System.arraycopy(this.pw, 0, answer, pos, this.pw.length);
        this.clearPassword();
        return answer;
    }

    @Override
    public boolean isComplete() {
        return this.completed;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        if (this.completed) {
            throw new SaslException("PLAIN supports neither integrity nor privacy");
        }
        throw new IllegalStateException("PLAIN authentication not completed");
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        if (this.completed) {
            throw new SaslException("PLAIN supports neither integrity nor privacy");
        }
        throw new IllegalStateException("PLAIN authentication not completed");
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        if (this.completed) {
            return propName.equals("javax.security.sasl.qop") ? "auth" : null;
        }
        throw new IllegalStateException("PLAIN authentication not completed");
    }

    private void clearPassword() {
        if (this.pw != null) {
            Arrays.fill(this.pw, (byte)0);
            this.pw = null;
        }
    }

    protected void finalize() {
        this.clearPassword();
    }
}

