/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.IOException;
import java.util.concurrent.RejectedExecutionException;
import org.apache.hive.service.ServiceException;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationType;
import org.apache.spark.ErrorMessageFormat$;
import org.apache.spark.SparkThrowable;
import org.apache.spark.SparkThrowableHelper$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Serializable;

public final class HiveThriftServerErrors$ {
    public static HiveThriftServerErrors$ MODULE$;

    static {
        new HiveThriftServerErrors$();
    }

    public Throwable taskExecutionRejectedError(RejectedExecutionException rejected) {
        return new HiveSQLException("The background threadpool cannot accept new task for execution, please retry the operation", rejected);
    }

    public Throwable runningQueryError(Throwable e2, Enumeration.Value format) {
        Throwable throwable = e2;
        if (throwable instanceof SparkThrowable) {
            Throwable throwable2 = throwable;
            Enumeration.Value value = format;
            Enumeration.Value value2 = ErrorMessageFormat$.MODULE$.PRETTY();
            if (!(value != null ? !value.equals(value2) : value2 != null)) {
                String errorClassPrefix = (String)Option$.MODULE$.apply((Object)((SparkThrowable)throwable2).getErrorClass()).map((Function1 & java.io.Serializable & Serializable)e -> new StringBuilder(3).append("[").append((String)e).append("] ").toString()).getOrElse((Function0 & java.io.Serializable & Serializable)() -> "");
                return new HiveSQLException(new StringBuilder(21).append("Error running query: ").append(errorClassPrefix).append(throwable2.toString()).toString(), ((SparkThrowable)throwable2).getSqlState(), throwable2);
            }
        }
        if (throwable instanceof SparkThrowable) {
            Throwable throwable3 = throwable;
            return new HiveSQLException(SparkThrowableHelper$.MODULE$.getMessage(throwable3, format), ((SparkThrowable)throwable3).getSqlState(), throwable3);
        }
        return new HiveSQLException(new StringBuilder(21).append("Error running query: ").append(e2.toString()).toString(), e2);
    }

    public Throwable hiveOperatingError(OperationType operationType, Throwable e) {
        return new HiveSQLException(new StringBuilder(17).append("Error operating ").append((Object)operationType).append(" ").append(e.getMessage()).toString(), e);
    }

    public Throwable failedToOpenNewSessionError(Throwable e) {
        return new HiveSQLException(new StringBuilder(28).append("Failed to open new session: ").append(e).toString(), e);
    }

    public Throwable cannotLoginToKerberosError(Throwable e) {
        return new ServiceException("Unable to login to kerberos with given principal/keytab", e);
    }

    public Throwable cannotLoginToSpnegoError(String principal, String keyTabFile, IOException e) {
        return new ServiceException(new StringBuilder(61).append("Unable to login to spnego with given principal ").append(principal).append(" and keytab ").append(keyTabFile).append(": ").append(e).toString(), e);
    }

    public Throwable failedToStartServiceError(String serviceName, Throwable e) {
        return new ServiceException(new StringBuilder(16).append("Failed to Start ").append(serviceName).toString(), e);
    }

    private HiveThriftServerErrors$() {
        MODULE$ = this;
    }
}

