/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import com.google.common.io.Files;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.Locale;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.jdbc.HiveDriver;
import org.apache.spark.ProcessTestUtils;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.hive.thriftserver.HiveThriftServer2$;
import org.apache.spark.sql.hive.thriftserver.ServerMode$;
import org.apache.spark.util.ShutdownHookManager$;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.scalactic.source.Position;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.enablers.Retrying$;
import org.scalatest.time.Span$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Awaitable;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t\u0015d!B A\u0003\u0003i\u0005\"\u00020\u0001\t\u0003y\u0006\"\u00022\u0001\r\u0003\u0019\u0007b\u00028\u0001\u0005\u0004%Ia\u001c\u0005\u0007q\u0002\u0001\u000b\u0011\u00029\t\u000fe\u0004!\u0019!C\u0005u\"9\u00111\u0002\u0001!\u0002\u0013Y\b\u0002CA\u0007\u0001\t\u0007I\u0011\u0003>\t\u000f\u0005=\u0001\u0001)A\u0005w\"A\u0011\u0011\u0003\u0001C\u0002\u0013E!\u0010C\u0004\u0002\u0014\u0001\u0001\u000b\u0011B>\t\u0017\u0005U\u0001\u00011AA\u0002\u0013%\u0011q\u0003\u0005\f\u0003C\u0001\u0001\u0019!a\u0001\n\u0013\t\u0019\u0003C\u0006\u00020\u0001\u0001\r\u0011!Q!\n\u0005e\u0001bBA\u0019\u0001\u0011E\u0011q\u0003\u0005\t\u0003g\u0001!\u0019!C\t_\"9\u0011Q\u0007\u0001!\u0002\u0013\u0001\b\u0002CA\u001c\u0001\t\u0007I\u0011C8\t\u000f\u0005e\u0002\u0001)A\u0005a\"1\u00111\b\u0001\u0005\u0012=D1\"!\u0010\u0001\u0001\u0004\u0005\r\u0011\"\u0005\u0002@!Y\u0011Q\n\u0001A\u0002\u0003\u0007I\u0011CA(\u0011-\t\u0019\u0006\u0001a\u0001\u0002\u0003\u0006K!!\u0011\t\u0017\u0005U\u0003\u00011AA\u0002\u0013E\u0011q\b\u0005\f\u0003/\u0002\u0001\u0019!a\u0001\n#\tI\u0006C\u0006\u0002^\u0001\u0001\r\u0011!Q!\n\u0005\u0005\u0003BBA0\u0001\u0011E!\u0010C\u0005\u0002b\u0001\u0011\r\u0011\"\u0003\u0002@!A\u00111\r\u0001!\u0002\u0013\t\t\u0005C\u0006\u0002f\u0001\u0001\r\u00111A\u0005\u0012\u0005}\u0002bCA4\u0001\u0001\u0007\t\u0019!C\t\u0003SB1\"!\u001c\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002B!Y\u0011q\u000e\u0001A\u0002\u0003\u0007I\u0011CA \u0011-\t\t\b\u0001a\u0001\u0002\u0004%\t\"a\u001d\t\u0017\u0005]\u0004\u00011A\u0001B\u0003&\u0011\u0011\t\u0005\f\u0003s\u0002\u0001\u0019!a\u0001\n#\ty\u0004C\u0006\u0002|\u0001\u0001\r\u00111A\u0005\u0012\u0005u\u0004bCAA\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u0003B1\"a!\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0006\"Y\u0011Q\u0012\u0001A\u0002\u0003\u0007I\u0011BAH\u0011-\t\u0019\n\u0001a\u0001\u0002\u0003\u0006K!a\"\t\u0013\u0005U\u0005\u00011A\u0005\n\u0005]\u0005\"CAU\u0001\u0001\u0007I\u0011BAV\u0011!\ty\u000b\u0001Q!\n\u0005e\u0005bBAY\u0001\u0011E\u00111\u0017\u0005\b\u0003\u000f\u0004A\u0011CAe\u0011!\tY\r\u0001b\u0001\n\u0003y\u0007bBAg\u0001\u0001\u0006I\u0001\u001d\u0005\t\u0003\u001f\u0004!\u0019!C\u0001_\"9\u0011\u0011\u001b\u0001!\u0002\u0013\u0001\b\"CAj\u0001\t\u0007I\u0011AAk\u0011!\t9\u000f\u0001Q\u0001\n\u0005]\u0007bBAu\u0001\u0011%\u00111\u001e\u0005\b\u0003c\u0004A\u0011BAz\u0011\u001d\t)\u0010\u0001C\u0005\u0003gDq!a>\u0001\t#\n\u0019\u0010C\u0004\u0002z\u0002!\t&a=\t\u000f\u0005m\b\u0001\"\u0005\u0002~\"I!1\u0001\u0001\u0012\u0002\u0013E!Q\u0001\u0005\b\u00057\u0001A\u0011\u0002B\u000f\u0011\u001d\u0011I\u0003\u0001C\u0001\u0005WAqAa\u0014\u0001\t\u0003\u0011\t\u0006C\u0004\u0003\\\u0001!\tA!\u0018\u00033!Kg/\u001a+ie&4GoU3sm\u0016\u0014(\u0007V3ti\n\u000b7/\u001a\u0006\u0003\u0003\n\u000bA\u0002\u001e5sS\u001a$8/\u001a:wKJT!a\u0011#\u0002\t!Lg/\u001a\u0006\u0003\u000b\u001a\u000b1a]9m\u0015\t9\u0005*A\u0003ta\u0006\u00148N\u0003\u0002J\u0015\u00061\u0011\r]1dQ\u0016T\u0011aS\u0001\u0004_J<7\u0001A\n\u0005\u00019\u0013\u0006\f\u0005\u0002P!6\ta)\u0003\u0002R\r\ni1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"a\u0015,\u000e\u0003QS!!\u0016&\u0002\u0013M\u001c\u0017\r\\1uKN$\u0018BA,U\u0005E\u0011UMZ8sK\u0006sG-\u00114uKJ\fE\u000e\u001c\t\u00033rk\u0011A\u0017\u0006\u00037\u001a\u000b\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003;j\u0013q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002AB\u0011\u0011\rA\u0007\u0002\u0001\u0006!Qn\u001c3f+\u0005!\u0007CA3i\u001d\t\tg-\u0003\u0002h\u0001\u0006Q1+\u001a:wKJlu\u000eZ3\n\u0005%T'!\u0002,bYV,\u0017BA6m\u0005-)e.^7fe\u0006$\u0018n\u001c8\u000b\u00035\fQa]2bY\u0006\f!b\u0011'B'N{f*Q'F+\u0005\u0001\bCA9w\u001b\u0005\u0011(BA:u\u0003\u0011a\u0017M\\4\u000b\u0003U\fAA[1wC&\u0011qO\u001d\u0002\u0007'R\u0014\u0018N\\4\u0002\u0017\rc\u0015iU*`\u001d\u0006kU\tI\u0001\u000e\u0019>;uLR%M\u000b~k\u0015IU&\u0016\u0003m\u00042\u0001`A\u0004\u001d\ri\u00181\u0001\t\u0003}2l\u0011a \u0006\u0004\u0003\u0003a\u0015A\u0002\u001fs_>$h(C\u0002\u0002\u00061\fa\u0001\u0015:fI\u00164\u0017bA<\u0002\n)\u0019\u0011Q\u00017\u0002\u001d1{ui\u0018$J\u0019\u0016{V*\u0011*LA\u0005Y1\u000f^1siN\u001b'/\u001b9u\u00031\u0019H/\u0019:u'\u000e\u0014\u0018\u000e\u001d;!\u0003)\u0019Ho\u001c9TGJL\u0007\u000f^\u0001\fgR|\u0007oU2sSB$\b%A\u0007mSN$XM\\5oOB{'\u000f^\u000b\u0003\u00033\u0001B!a\u0007\u0002\u001e5\tA.C\u0002\u0002 1\u00141!\u00138u\u0003Ea\u0017n\u001d;f]&tw\rU8si~#S-\u001d\u000b\u0005\u0003K\tY\u0003\u0005\u0003\u0002\u001c\u0005\u001d\u0012bAA\u0015Y\n!QK\\5u\u0011%\ti\u0003DA\u0001\u0002\u0004\tI\"A\u0002yIE\na\u0002\\5ti\u0016t\u0017N\\4Q_J$\b%\u0001\u0006tKJ4XM\u001d)peR\fA\u0002[5wK\u000e{gN\u001a'jgR\fQ\u0002[5wK\u000e{gN\u001a'jgR\u0004\u0013a\u00035jm\u00164\u0016M\u001d'jgR\fA\u0002[5wKZ\u000b'\u000fT5ti\u0002\nA!^:fe\u0006iq/\u0019:fQ>,8/\u001a)bi\",\"!!\u0011\u0011\t\u0005\r\u0013\u0011J\u0007\u0003\u0003\u000bR1!a\u0012u\u0003\tIw.\u0003\u0003\u0002L\u0005\u0015#\u0001\u0002$jY\u0016\f\u0011c^1sK\"|Wo]3QCRDw\fJ3r)\u0011\t)#!\u0015\t\u0013\u00055R#!AA\u0002\u0005\u0005\u0013AD<be\u0016Dw.^:f!\u0006$\b\u000eI\u0001\u000e[\u0016$\u0018m\u001d;pe\u0016\u0004\u0016\r\u001e5\u0002#5,G/Y:u_J,\u0007+\u0019;i?\u0012*\u0017\u000f\u0006\u0003\u0002&\u0005m\u0003\"CA\u00171\u0005\u0005\t\u0019AA!\u00039iW\r^1ti>\u0014X\rU1uQ\u0002\n\u0001#\\3uCN$xN]3KI\n\u001cWK]5\u0002\rALG\rR5s\u0003\u001d\u0001\u0018\u000e\u001a#je\u0002\nq\u0001\\8h!\u0006$\b.A\u0006m_\u001e\u0004\u0016\r\u001e5`I\u0015\fH\u0003BA\u0013\u0003WB\u0011\"!\f\u001f\u0003\u0003\u0005\r!!\u0011\u0002\u00111|w\rU1uQ\u0002\n\u0001c\u001c9fe\u0006$\u0018n\u001c8M_\u001e\u0004\u0016\r\u001e5\u0002)=\u0004XM]1uS>tGj\\4QCRDw\fJ3r)\u0011\t)#!\u001e\t\u0013\u00055\u0012%!AA\u0002\u0005\u0005\u0013!E8qKJ\fG/[8o\u0019><\u0007+\u0019;iA\u0005YAnU2sCR\u001c\u0007\u000eR5s\u0003=a7k\u0019:bi\u000eDG)\u001b:`I\u0015\fH\u0003BA\u0013\u0003\u007fB\u0011\"!\f%\u0003\u0003\u0005\r!!\u0011\u0002\u00191\u001c6M]1uG\"$\u0015N\u001d\u0011\u0002#1|w\rV1jY&tw\r\u0015:pG\u0016\u001c8/\u0006\u0002\u0002\bB\u0019\u0011/!#\n\u0007\u0005-%OA\u0004Qe>\u001cWm]:\u0002+1|w\rV1jY&tw\r\u0015:pG\u0016\u001c8o\u0018\u0013fcR!\u0011QEAI\u0011%\ticJA\u0001\u0002\u0004\t9)\u0001\nm_\u001e$\u0016-\u001b7j]\u001e\u0004&o\\2fgN\u0004\u0013a\u00043jC\u001etwn]5t\u0005V4g-\u001a:\u0016\u0005\u0005e\u0005#BAN\u0003K[XBAAO\u0015\u0011\ty*!)\u0002\u000f5,H/\u00192mK*\u0019\u00111\u00157\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002(\u0006u%aC!se\u0006L()\u001e4gKJ\f1\u0003Z5bO:|7/[:Ck\u001a4WM]0%KF$B!!\n\u0002.\"I\u0011Q\u0006\u0016\u0002\u0002\u0003\u0007\u0011\u0011T\u0001\u0011I&\fwM\\8tSN\u0014UO\u001a4fe\u0002\n\u0011\"\u001a=ue\u0006\u001cuN\u001c4\u0016\u0005\u0005U\u0006#BA\\\u0003\u0003\\h\u0002BA]\u0003{s1A`A^\u0013\u0005i\u0017bAA`Y\u00069\u0001/Y2lC\u001e,\u0017\u0002BAb\u0003\u000b\u00141aU3r\u0015\r\ty\f\\\u0001\u0013g\u0016\u0014h/\u001a:Ti\u0006\u0014HoQ8n[\u0006tG\r\u0006\u0002\u00026\u0006QB\u000b\u0013*J\rR{&)\u0013(B%f{6+\u0012*W\u0013\u000e+u\fT%W\u000b\u0006YB\u000b\u0013*J\rR{&)\u0013(B%f{6+\u0012*W\u0013\u000e+u\fT%W\u000b\u0002\n\u0001\u0004\u0016%S\u0013\u001a#v\f\u0013+U!~\u001bVI\u0015,J\u0007\u0016{F*\u0013,F\u0003e!\u0006JU%G)~CE\u000b\u0016)`'\u0016\u0013f+S\"F?2Ke+\u0012\u0011\u0002-M+%KV#S?N#\u0016I\u0015+V!~#\u0016*T#P+R+\"!a6\u0011\t\u0005e\u00171]\u0007\u0003\u00037TA!!8\u0002`\u0006AA-\u001e:bi&|gNC\u0002\u0002b2\f!bY8oGV\u0014(/\u001a8u\u0013\u0011\t)/a7\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\u000692+\u0012*W\u000bJ{6\u000bV!S)V\u0003v\fV%N\u000b>+F\u000bI\u0001\u0012gR\f'\u000f\u001e+ie&4GoU3sm\u0016\u0014H\u0003BA\u0013\u0003[Dq!a<5\u0001\u0004\tI\"A\u0004biR,W\u000e\u001d;\u0002!M$x\u000e\u001d+ie&4GoU3sm\u0016\u0014HCAA\u0013\u0003!!W/\u001c9M_\u001e\u001c\u0018!\u00032fM>\u0014X-\u00117m\u0003!\tg\r^3s\u00032d\u0017a\u00026eE\u000e,&/\u001b\u000b\u0004w\u0006}\b\u0002\u0003B\u0001sA\u0005\t\u0019A>\u0002\u0011\u0011\fG/\u00192bg\u0016\f\u0011C\u001b3cGV\u0013\u0018\u000e\n3fM\u0006,H\u000e\u001e\u00132+\t\u00119AK\u0002|\u0005\u0013Y#Aa\u0003\u0011\t\t5!qC\u0007\u0003\u0005\u001fQAA!\u0005\u0003\u0014\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005+a\u0017AC1o]>$\u0018\r^5p]&!!\u0011\u0004B\b\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0011iJL8)\u00199ukJ,7+_:M_\u001e$B!!\n\u0003 !A!\u0011E\u001e\u0005\u0002\u0004\u0011\u0019#A\u0001g!\u0019\tYB!\n\u0002&%\u0019!q\u00057\u0003\u0011q\u0012\u0017P\\1nKz\n1e^5uQ6+H\u000e^5qY\u0016\u001cuN\u001c8fGRLwN\u001c&eE\u000e\u001cF/\u0019;f[\u0016tG\u000f\u0006\u0003\u0003.\t%C\u0003BA\u0013\u0005_AqA!\r=\u0001\u0004\u0011\u0019$\u0001\u0002ggB1\u00111\u0004B\u001b\u0005sI1Aa\u000em\u0005)a$/\u001a9fCR,GM\u0010\t\t\u00037\u0011YDa\u0010\u0002&%\u0019!Q\b7\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003\u0002B!\u0005\u000bj!Aa\u0011\u000b\u0005\u0015#\u0018\u0002\u0002B$\u0005\u0007\u0012\u0011b\u0015;bi\u0016lWM\u001c;\t\u000f\t-C\b1\u0001\u0003N\u0005QA/\u00192mK:\u000bW.Z:\u0011\u000b\u0005m!QG>\u0002\u0019]LG\u000f\u001b#bi\u0006\u0014\u0017m]3\u0015\t\tM#q\u000b\u000b\u0005\u0003K\u0011)\u0006C\u0004\u00032u\u0002\rAa\r\t\u000f\teS\b1\u0001\u0003N\u00059AM\u0019(b[\u0016\u001c\u0018!E<ji\"TEMY2Ti\u0006$X-\\3oiR!!q\fB2)\u0011\t)C!\u0019\t\u000f\t\u0005b\b1\u0001\u0003:!9!1\n A\u0002\t5\u0003")
public abstract class HiveThriftServer2TestBase
extends SparkFunSuite {
    private final String CLASS_NAME = new StringOps(Predef$.MODULE$.augmentString(HiveThriftServer2$.MODULE$.getClass().getCanonicalName())).stripSuffix("$");
    private final String org$apache$spark$sql$hive$thriftserver$HiveThriftServer2TestBase$$LOG_FILE_MARK = new StringBuilder(22).append("starting ").append(this.CLASS_NAME()).append(", logging to ").toString();
    private final String startScript = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])"../../sbin/start-thriftserver.sh".split("/"))).mkString(File.separator);
    private final String stopScript = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])"../../sbin/stop-thriftserver.sh".split("/"))).mkString(File.separator);
    private int listeningPort;
    private final String hiveConfList;
    private final String hiveVarList;
    private File warehousePath;
    private File metastorePath;
    private final File pidDir;
    private File logPath;
    private File operationLogPath;
    private File lScratchDir;
    private Process logTailingProcess;
    private ArrayBuffer<String> diagnosisBuffer;
    private final String THRIFT_BINARY_SERVICE_LIVE;
    private final String THRIFT_HTTP_SERVICE_LIVE;
    private final FiniteDuration SERVER_STARTUP_TIMEOUT;

    public abstract Enumeration.Value mode();

    private String CLASS_NAME() {
        return this.CLASS_NAME;
    }

    public String org$apache$spark$sql$hive$thriftserver$HiveThriftServer2TestBase$$LOG_FILE_MARK() {
        return this.org$apache$spark$sql$hive$thriftserver$HiveThriftServer2TestBase$$LOG_FILE_MARK;
    }

    public String startScript() {
        return this.startScript;
    }

    public String stopScript() {
        return this.stopScript;
    }

    private int listeningPort() {
        return this.listeningPort;
    }

    private void listeningPort_$eq(int x$1) {
        this.listeningPort = x$1;
    }

    public int serverPort() {
        return this.listeningPort();
    }

    public String hiveConfList() {
        return this.hiveConfList;
    }

    public String hiveVarList() {
        return this.hiveVarList;
    }

    public String user() {
        return System.getProperty("user.name");
    }

    public File warehousePath() {
        return this.warehousePath;
    }

    public void warehousePath_$eq(File x$1) {
        this.warehousePath = x$1;
    }

    public File metastorePath() {
        return this.metastorePath;
    }

    public void metastorePath_$eq(File x$1) {
        this.metastorePath = x$1;
    }

    public String metastoreJdbcUri() {
        return new StringBuilder(37).append("jdbc:derby:;databaseName=").append(this.metastorePath()).append(";create=true").toString();
    }

    private File pidDir() {
        return this.pidDir;
    }

    public File logPath() {
        return this.logPath;
    }

    public void logPath_$eq(File x$1) {
        this.logPath = x$1;
    }

    public File operationLogPath() {
        return this.operationLogPath;
    }

    public void operationLogPath_$eq(File x$1) {
        this.operationLogPath = x$1;
    }

    public File lScratchDir() {
        return this.lScratchDir;
    }

    public void lScratchDir_$eq(File x$1) {
        this.lScratchDir = x$1;
    }

    private Process logTailingProcess() {
        return this.logTailingProcess;
    }

    private void logTailingProcess_$eq(Process x$1) {
        this.logTailingProcess = x$1;
    }

    private ArrayBuffer<String> diagnosisBuffer() {
        return this.diagnosisBuffer;
    }

    private void diagnosisBuffer_$eq(ArrayBuffer<String> x$1) {
        this.diagnosisBuffer = x$1;
    }

    public Seq<String> extraConf() {
        return Nil$.MODULE$;
    }

    public Seq<String> serverStartCommand() {
        Enumeration.Value value = this.mode();
        Enumeration.Value value2 = ServerMode$.MODULE$.binary();
        HiveConf.ConfVars portConf = !(value != null ? !value.equals(value2) : value2 != null) ? HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT : HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_PORT;
        String tempLog4jConf = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getCanonicalPath();
        Files.write((CharSequence)new StringOps(Predef$.MODULE$.augmentString("rootLogger.level = info\n          |rootLogger.appenderRef.stdout.ref = console\n          |appender.console.type = Console\n          |appender.console.name = console\n          |appender.console.target = SYSTEM_ERR\n          |appender.console.layout.type = PatternLayout\n          |appender.console.layout.pattern = %d{yy/MM/dd HH:mm:ss} %p %c{1}: %m%n%ex\n        ")).stripMargin(), (File)new File(new StringBuilder(18).append(tempLog4jConf).append("/log4j2.properties").toString()), (Charset)StandardCharsets.UTF_8);
        String driverClassPath = tempLog4jConf;
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(331).append(this.startScript()).append("\n       |  --master local\n       |  --hiveconf ").append(HiveConf.ConfVars.METASTORECONNECTURLKEY).append("=").append(this.metastoreJdbcUri()).append("\n       |  --hiveconf ").append(HiveConf.ConfVars.METASTOREWAREHOUSE).append("=").append(this.warehousePath()).append("\n       |  --hiveconf ").append(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_BIND_HOST).append("=localhost\n       |  --hiveconf ").append(HiveConf.ConfVars.HIVE_SERVER2_TRANSPORT_MODE).append("=").append(this.mode()).append("\n       |  --hiveconf ").append(HiveConf.ConfVars.HIVE_SERVER2_LOGGING_OPERATION_LOG_LOCATION).append("=").append(this.operationLogPath()).append("\n       |  --hiveconf ").append(HiveConf.ConfVars.LOCALSCRATCHDIR).append("=").append(this.lScratchDir()).append("\n       |  --hiveconf ").append(portConf).append("=0\n       |  --driver-class-path ").append(driverClassPath).append("\n       |  --driver-java-options -Dlog4j2.debug\n       |  --conf spark.ui.enabled=false\n       |  ").append(this.extraConf().mkString("\n")).append("\n     ").toString())).stripMargin().split("\\s+"))).toSeq();
    }

    public String THRIFT_BINARY_SERVICE_LIVE() {
        return this.THRIFT_BINARY_SERVICE_LIVE;
    }

    public String THRIFT_HTTP_SERVICE_LIVE() {
        return this.THRIFT_HTTP_SERVICE_LIVE;
    }

    public FiniteDuration SERVER_STARTUP_TIMEOUT() {
        return this.SERVER_STARTUP_TIMEOUT;
    }

    private void startThriftServer(int attempt) {
        this.warehousePath_$eq(Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()));
        this.warehousePath().delete();
        this.metastorePath_$eq(Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()));
        this.metastorePath().delete();
        this.operationLogPath_$eq(Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()));
        this.operationLogPath().delete();
        this.lScratchDir_$eq(Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()));
        this.lScratchDir().delete();
        this.logPath_$eq(null);
        this.logTailingProcess_$eq(null);
        Seq<String> command = this.serverStartCommand();
        this.diagnosisBuffer().$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(130).append("\n         |### Attempt ").append(attempt).append(" ###\n         |HiveThriftServer2 command line: ").append(command).append("\n         |Listening port: 0\n         |System user: ").append(this.user()).append("\n       ").toString())).stripMargin().split("\n"))));
        Seq<String> x$1 = command;
        scala.collection.immutable.Map x$2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SPARK_TESTING"), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SPARK_SQL_TESTING"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SPARK_PID_DIR"), (Object)this.pidDir().getCanonicalPath())}));
        boolean x$3 = true;
        File x$4 = Utils$.MODULE$.executeAndGetOutput$default$2();
        String lines = Utils$.MODULE$.executeAndGetOutput(x$1, x$4, (Map)x$2, x$3);
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(9).append("COMMAND: ").append(command).toString());
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(8).append("OUTPUT: ").append(lines).toString());
        this.logPath_$eq((File)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lines.split("\n"))).collectFirst((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HiveThriftServer2TestBase $outer;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = A1.contains(this.$outer.org$apache$spark$sql$hive$thriftserver$HiveThriftServer2TestBase$$LOG_FILE_MARK()) ? new File((String)new StringOps(Predef$.MODULE$.augmentString(A1)).drop(this.$outer.org$apache$spark$sql$hive$thriftserver$HiveThriftServer2TestBase$$LOG_FILE_MARK().length())) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(String x1) {
                String string = x1;
                boolean bl = string.contains(this.$outer.org$apache$spark$sql$hive$thriftserver$HiveThriftServer2TestBase$$LOG_FILE_MARK());
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new RuntimeException("Failed to find HiveThriftServer2 log file.");
        }));
        Promise serverStarted = Promise$.MODULE$.apply();
        this.logPath().createNewFile();
        Enumeration.Value value = this.mode();
        Enumeration.Value value2 = ServerMode$.MODULE$.http();
        String successLine = !(value != null ? !value.equals(value2) : value2 != null) ? this.THRIFT_HTTP_SERVICE_LIVE() : this.THRIFT_BINARY_SERVICE_LIVE();
        String[] command2 = new StringBuilder(27).append("/usr/bin/env tail -n +0 -f ").append(this.logPath().getCanonicalPath()).toString().split(" ");
        ProcessBuilder builder = new ProcessBuilder(command2);
        Function1 & Serializable & scala.Serializable captureOutput = (Function1 & Serializable & scala.Serializable)line -> {
            HiveThriftServer2TestBase.$anonfun$startThriftServer$5(this, successLine, attempt, serverStarted, line);
            return BoxedUnit.UNIT;
        };
        Process process = builder.start();
        new ProcessTestUtils.ProcessOutputCapturer(process.getInputStream(), (Function1)captureOutput).start();
        new ProcessTestUtils.ProcessOutputCapturer(process.getErrorStream(), (Function1)captureOutput).start();
        this.logTailingProcess_$eq(process);
        ShutdownHookManager$.MODULE$.addShutdownHook((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.stopThriftServer());
        ThreadUtils$.MODULE$.awaitResult((Awaitable)serverStarted.future(), (Duration)this.SERVER_STARTUP_TIMEOUT());
    }

    private void stopThriftServer() {
        block0: {
            if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.pidDir().list())).nonEmpty()) break block0;
            Seq x$1 = (Seq)new .colon.colon((Object)this.stopScript(), (List)Nil$.MODULE$);
            scala.collection.immutable.Map x$2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SPARK_PID_DIR"), (Object)this.pidDir().getCanonicalPath())}));
            File x$3 = Utils$.MODULE$.executeAndGetOutput$default$2();
            boolean x$4 = Utils$.MODULE$.executeAndGetOutput$default$4();
            Utils$.MODULE$.executeAndGetOutput(x$1, x$3, (Map)x$2, x$4);
            Thread.sleep(new package.DurationInt(package$.MODULE$.DurationInt(3)).seconds().toMillis());
            this.warehousePath().delete();
            this.warehousePath_$eq(null);
            this.metastorePath().delete();
            this.metastorePath_$eq(null);
            this.operationLogPath().delete();
            this.operationLogPath_$eq(null);
            this.lScratchDir().delete();
            this.lScratchDir_$eq(null);
            Option$.MODULE$.apply((Object)this.logPath()).foreach((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.delete()));
            this.logPath_$eq(null);
            Option$.MODULE$.apply((Object)this.logTailingProcess()).foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                x$7.destroy();
                return BoxedUnit.UNIT;
            });
            this.logTailingProcess_$eq(null);
        }
    }

    public void org$apache$spark$sql$hive$thriftserver$HiveThriftServer2TestBase$$dumpLogs() {
        this.logError((Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(319).append("\n         |=====================================\n         |HiveThriftServer2Suite failure output\n         |=====================================\n         |").append(this.diagnosisBuffer().mkString("\n")).append("\n         |=========================================\n         |End HiveThriftServer2Suite failure output\n         |=========================================\n       ").toString())).stripMargin());
    }

    public void beforeAll() {
        super.beforeAll();
        this.diagnosisBuffer().clear();
        ((Try)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).foldLeft((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.startThriftServer(0)), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> HiveThriftServer2TestBase.$anonfun$beforeAll$2(this, x0$1, BoxesRunTime.unboxToInt((Object)x1$1)))).recover((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HiveThriftServer2TestBase $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    A1 A12 = A1;
                    this.$outer.org$apache$spark$sql$hive$thriftserver$HiveThriftServer2TestBase$$dumpLogs();
                    throw A12;
                }
                Object object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable != null;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get();
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> "HiveThriftServer2 started successfully");
    }

    public void afterAll() {
        try {
            this.stopThriftServer();
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> "HiveThriftServer2 stopped");
        }
        finally {
            super.afterAll();
        }
    }

    public String jdbcUri(String database) {
        Enumeration.Value value = this.mode();
        Enumeration.Value value2 = ServerMode$.MODULE$.http();
        return !(value != null ? !value.equals(value2) : value2 != null) ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(142).append("jdbc:hive2://localhost:").append(this.serverPort()).append("/\n       |").append(database).append("?\n       |hive.server2.transport.mode=http;\n       |hive.server2.thrift.http.path=cliservice;\n       |").append(this.hiveConfList()).append("#").append(this.hiveVarList()).append("\n     ").toString())).stripMargin().split("\n"))).mkString().trim() : new StringBuilder(26).append("jdbc:hive2://localhost:").append(this.serverPort()).append("/").append(database).append("?").append(this.hiveConfList()).append("#").append(this.hiveVarList()).toString();
    }

    public String jdbcUri$default$1() {
        return "default";
    }

    private void tryCaptureSysLog(Function0<BoxedUnit> f) {
        try {
            f.apply$mcV$sp();
        }
        catch (Exception e) {
            this.org$apache$spark$sql$hive$thriftserver$HiveThriftServer2TestBase$$dumpLogs();
            throw e;
        }
    }

    public void withMultipleConnectionJdbcStatement(Seq<String> tableNames, Seq<Function1<Statement, BoxedUnit>> fs) {
        this.tryCaptureSysLog((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String user = System.getProperty("user.name");
            Seq connections = (Seq)fs.map((Function1 & Serializable & scala.Serializable)x$9 -> DriverManager.getConnection(this.jdbcUri(this.jdbcUri$default$1()), user, ""), Seq$.MODULE$.canBuildFrom());
            Seq statements = (Seq)connections.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.createStatement(), Seq$.MODULE$.canBuildFrom());
            try {
                ((IterableLike)statements.zip((GenIterable)fs, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    HiveThriftServer2TestBase.$anonfun$withMultipleConnectionJdbcStatement$4(x0$1);
                    return BoxedUnit.UNIT;
                });
            }
            finally {
                tableNames.foreach((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)HiveThriftServer2TestBase.$anonfun$withMultipleConnectionJdbcStatement$5(statements, name)));
                statements.foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
                    x$11.close();
                    return BoxedUnit.UNIT;
                });
                connections.foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
                    x$12.close();
                    return BoxedUnit.UNIT;
                });
            }
        });
    }

    public void withDatabase(Seq<String> dbNames, Seq<Function1<Statement, BoxedUnit>> fs) {
        this.tryCaptureSysLog((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String user = System.getProperty("user.name");
            Seq connections = (Seq)fs.map((Function1 & Serializable & scala.Serializable)x$13 -> DriverManager.getConnection(this.jdbcUri(this.jdbcUri$default$1()), user, ""), Seq$.MODULE$.canBuildFrom());
            Seq statements = (Seq)connections.map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.createStatement(), Seq$.MODULE$.canBuildFrom());
            try {
                ((IterableLike)statements.zip((GenIterable)fs, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    HiveThriftServer2TestBase.$anonfun$withDatabase$4(x0$1);
                    return BoxedUnit.UNIT;
                });
            }
            finally {
                dbNames.foreach((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)HiveThriftServer2TestBase.$anonfun$withDatabase$5(statements, name)));
                statements.foreach((Function1 & Serializable & scala.Serializable)x$15 -> {
                    x$15.close();
                    return BoxedUnit.UNIT;
                });
                connections.foreach((Function1 & Serializable & scala.Serializable)x$16 -> {
                    x$16.close();
                    return BoxedUnit.UNIT;
                });
            }
        });
    }

    public void withJdbcStatement(Seq<String> tableNames, Function1<Statement, BoxedUnit> f) {
        this.withMultipleConnectionJdbcStatement(tableNames, (Seq<Function1<Statement, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{f}));
    }

    public static final /* synthetic */ void $anonfun$startThriftServer$5(HiveThriftServer2TestBase $this, String successLine$1, int attempt$1, Promise serverStarted$1, String line) {
        ArrayBuffer<String> arrayBuffer = $this.diagnosisBuffer();
        synchronized (arrayBuffer) {
            $this.diagnosisBuffer().$plus$eq((Object)line);
            if (line.contains(successLine$1)) {
                $this.listeningPort_$eq(new StringOps(Predef$.MODULE$.augmentString((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(line.split(" on port ")[1])).split(' '))).head())).toInt());
                $this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Started HiveThriftServer2: port=").append($this.listeningPort()).append(", mode=").append($this.mode()).append(", attempt=").append(attempt$1).toString());
                serverStarted$1.trySuccess((Object)BoxedUnit.UNIT);
            }
        }
    }

    public static final /* synthetic */ Try $anonfun$beforeAll$2(HiveThriftServer2TestBase $this, Try x0$1, int x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)BoxesRunTime.boxToInteger((int)x1$1));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Try started = (Try)tuple2._1();
        int attempt = tuple2._2$mcI$sp();
        Try try_ = started.orElse((Function0 & Serializable & scala.Serializable)() -> {
            $this.stopThriftServer();
            return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.startThriftServer(attempt);
                Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds())), Eventually$.MODULE$.interval(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).seconds())), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withJdbcStatement((Seq<String>)Nil$.MODULE$, (Function1<Statement, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$8 -> {
                    x$8.execute("SELECT 1");
                    return BoxedUnit.UNIT;
                }), Retrying$.MODULE$.retryingNatureOfT(), new Position("HiveThriftServer2Suites.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1398));
            });
        });
        return try_;
    }

    public static final /* synthetic */ void $anonfun$withMultipleConnectionJdbcStatement$4(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Statement s = (Statement)tuple2._1();
        Function1 f = (Function1)tuple2._2();
        BoxedUnit boxedUnit = (BoxedUnit)f.apply((Object)s);
    }

    public static final /* synthetic */ boolean $anonfun$withMultipleConnectionJdbcStatement$5(Seq statements$1, String name) {
        return name.toUpperCase(Locale.ROOT).startsWith("VIEW") ? ((Statement)statements$1.apply(0)).execute(new StringBuilder(20).append("DROP VIEW IF EXISTS ").append(name).toString()) : ((Statement)statements$1.apply(0)).execute(new StringBuilder(21).append("DROP TABLE IF EXISTS ").append(name).toString());
    }

    public static final /* synthetic */ void $anonfun$withDatabase$4(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Statement s = (Statement)tuple2._1();
        Function1 f = (Function1)tuple2._2();
        BoxedUnit boxedUnit = (BoxedUnit)f.apply((Object)s);
    }

    public static final /* synthetic */ boolean $anonfun$withDatabase$5(Seq statements$2, String name) {
        return ((Statement)statements$2.apply(0)).execute(new StringBuilder(24).append("DROP DATABASE IF EXISTS ").append(name).toString());
    }

    public HiveThriftServer2TestBase() {
        this.hiveConfList = "a=avalue;b=bvalue";
        this.hiveVarList = "c=cvalue;d=dvalue";
        String x$1 = "thriftserver-pid";
        String x$2 = Utils$.MODULE$.createTempDir$default$1();
        this.pidDir = Utils$.MODULE$.createTempDir(x$2, x$1);
        this.diagnosisBuffer = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        this.THRIFT_BINARY_SERVICE_LIVE = "Starting ThriftBinaryCLIService on port";
        this.THRIFT_HTTP_SERVICE_LIVE = "Started ThriftHttpCLIService in http";
        this.SERVER_STARTUP_TIMEOUT = new package.DurationInt(package$.MODULE$.DurationInt(3)).minutes();
        Utils$.MODULE$.classForName(HiveDriver.class.getCanonicalName(), Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3());
    }
}

