/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.RowSetFactory;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.operation.ExecuteStatementOperation;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.execution.HiveResult;
import org.apache.spark.sql.execution.HiveResult$;
import org.apache.spark.sql.hive.thriftserver.ArrayFetchIterator;
import org.apache.spark.sql.hive.thriftserver.FetchIterator;
import org.apache.spark.sql.hive.thriftserver.HiveThriftServer2$;
import org.apache.spark.sql.hive.thriftserver.HiveThriftServerErrors$;
import org.apache.spark.sql.hive.thriftserver.IterableFetchIterator;
import org.apache.spark.sql.hive.thriftserver.SparkExecuteStatementOperation$;
import org.apache.spark.sql.hive.thriftserver.SparkOperation;
import org.apache.spark.sql.internal.NonClosableMutableURLClassLoader;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.VariableSubstitution;
import org.apache.spark.sql.types.AnsiIntervalType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.IterableView;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Parallel;
import scala.collection.Parallelizable;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.generic.FilterMonadic;
import scala.collection.generic.GenericCompanion;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.Combiner;
import scala.collection.parallel.ParIterable;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t\u0005e!\u0002\u0017.\u0001=J\u0004\u0002C(\u0001\u0005\u000b\u0007I\u0011A)\t\u0011Y\u0003!\u0011!Q\u0001\nIC\u0001b\u0016\u0001\u0003\u0002\u0003\u0006I\u0001\u0017\u0005\t=\u0002\u0011\t\u0011)A\u0005?\"AA\u000e\u0001B\u0001B\u0003%Q\u000e\u0003\u0005v\u0001\t\u0005\t\u0015!\u0003w\u0011!Q\bA!A!\u0002\u0013Y\b\"\u0002@\u0001\t\u0003y\b\"CA\b\u0001\t\u0007I\u0011BA\t\u0011\u001d\t\u0019\u0002\u0001Q\u0001\nmD\u0011\"!\u0006\u0001\u0005\u0004%I!a\u0006\t\u000f\u0005e\u0001\u0001)A\u0005m\"I\u00111\u0004\u0001C\u0002\u0013%\u0011Q\u0004\u0005\b\u0003?\u0001\u0001\u0015!\u0003`\u0011-\t\t\u0003\u0001a\u0001\u0002\u0004%I!a\t\t\u0017\u0005\r\u0003\u00011AA\u0002\u0013%\u0011Q\t\u0005\f\u0003#\u0002\u0001\u0019!A!B\u0013\t)\u0003C\u0006\u0002T\u0001\u0001\r\u00111A\u0005\n\u0005U\u0003bCA2\u0001\u0001\u0007\t\u0019!C\u0005\u0003KB1\"!\u001b\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002X!Y\u00111\u000e\u0001A\u0002\u0003\u0007I\u0011BA7\u0011-\t\t\t\u0001a\u0001\u0002\u0004%I!a!\t\u0017\u0005\u001d\u0005\u00011A\u0001B\u0003&\u0011q\u000e\u0005\u000b\u0003\u0013\u0003\u0001R1A\u0005\n\u0005-\u0005bBAK\u0001\u0011\u0005\u0011q\u0013\u0005\b\u00037\u0004A\u0011AAo\u0011\u001d\t\u0019\u0010\u0001C\u0005\u0003kDq!a?\u0001\t\u0003\ti\u0010C\u0004\u0002\u0000\u0002!\tE!\u0001\t\u000f\t\r\u0001\u0001\"\u0003\u0003\u0002!9!Q\u0001\u0001\u0005\u0002\t\u0005\u0001b\u0002B\u0004\u0001\u0011\u0005#\u0011\u0001\u0005\b\u0005\u0013\u0001A\u0011\u000bB\u0001\u00111\u0011Y\u0001\u0001I\u0001\u0002\u0003\u0005I\u0011\u0001B\u0007\u00111\u00119\u0002\u0001I\u0001\u0002\u0003\u0005I\u0011\u0001B\r\u00111\u0011I\u0003\u0001I\u0001\u0002\u0003\u0005I\u0011\u0001B\u0016\u00111\u0011)\u0004\u0001I\u0001\u0002\u0003\u0005I\u0011\u0001B\u001c\u00111\u00119\u0005\u0001I\u0001\u0002\u0003\u0005I\u0011\u0001B%\u000f!\u0011i%\fE\u0001_\t=ca\u0002\u0017.\u0011\u0003y#\u0011\u000b\u0005\u0007}\"\"\tA!\u0017\t\u000f\tm\u0003\u0006\"\u0001\u0003^!I!\u0011\u000e\u0015\u0012\u0002\u0013\u0005!1\u000e\u0002\u001f'B\f'o[#yK\u000e,H/Z*uCR,W.\u001a8u\u001fB,'/\u0019;j_:T!AL\u0018\u0002\u0019QD'/\u001b4ug\u0016\u0014h/\u001a:\u000b\u0005A\n\u0014\u0001\u00025jm\u0016T!AM\u001a\u0002\u0007M\fHN\u0003\u00025k\u0005)1\u000f]1sW*\u0011agN\u0001\u0007CB\f7\r[3\u000b\u0003a\n1a\u001c:h'\u0011\u0001!(R%\u0011\u0005m\u001aU\"\u0001\u001f\u000b\u0005ur\u0014!C8qKJ\fG/[8o\u0015\ty\u0004)A\u0002dY&T!!\u0011\"\u0002\u000fM,'O^5dK*\u0011\u0001'N\u0005\u0003\tr\u0012\u0011$\u0012=fGV$Xm\u0015;bi\u0016lWM\u001c;Pa\u0016\u0014\u0018\r^5p]B\u0011aiR\u0007\u0002[%\u0011\u0001*\f\u0002\u000f'B\f'o[(qKJ\fG/[8o!\tQU*D\u0001L\u0015\ta5'\u0001\u0005j]R,'O\\1m\u0013\tq5JA\u0004M_\u001e<\u0017N\\4\u0002\u0015M\fHnQ8oi\u0016DHo\u0001\u0001\u0016\u0003I\u0003\"a\u0015+\u000e\u0003EJ!!V\u0019\u0003\u0015M\u000bFjQ8oi\u0016DH/A\u0006tc2\u001cuN\u001c;fqR\u0004\u0013!\u00049be\u0016tGoU3tg&|g\u000e\u0005\u0002Z96\t!L\u0003\u0002\\}\u000591/Z:tS>t\u0017BA/[\u0005-A\u0015N^3TKN\u001c\u0018n\u001c8\u0002\u0013M$\u0018\r^3nK:$\bC\u00011j\u001d\t\tw\r\u0005\u0002cK6\t1M\u0003\u0002e!\u00061AH]8pizR\u0011AZ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0016\fa\u0001\u0015:fI\u00164\u0017B\u00016l\u0005\u0019\u0019FO]5oO*\u0011\u0001.Z\u0001\fG>tgm\u0014<fe2\f\u0017\u0010\u0005\u0003og~{V\"A8\u000b\u0005A\f\u0018\u0001B;uS2T\u0011A]\u0001\u0005U\u00064\u0018-\u0003\u0002u_\n\u0019Q*\u00199\u0002\u001fI,h.\u00138CC\u000e\\wM]8v]\u0012\u0004\"a\u001e=\u000e\u0003\u0015L!!_3\u0003\u000f\t{w\u000e\\3b]\u0006a\u0011/^3ssRKW.Z8viB\u0011q\u000f`\u0005\u0003{\u0016\u0014A\u0001T8oO\u00061A(\u001b8jiz\"b\"!\u0001\u0002\u0004\u0005\u0015\u0011qAA\u0005\u0003\u0017\ti\u0001\u0005\u0002G\u0001!)q\n\u0003a\u0001%\")q\u000b\u0003a\u00011\")a\f\u0003a\u0001?\")A\u000e\u0003a\u0001[\"9Q\u000f\u0003I\u0001\u0002\u00041\b\"\u0002>\t\u0001\u0004Y\u0018a\u0002;j[\u0016|W\u000f^\u000b\u0002w\u0006AA/[7f_V$\b%A\u0006g_J\u001cWmQ1oG\u0016dW#\u0001<\u0002\u0019\u0019|'oY3DC:\u001cW\r\u001c\u0011\u0002)M,(m\u001d;jiV$xN]*uCR,W.\u001a8u+\u0005y\u0016!F:vEN$\u0018\u000e^;u_J\u001cF/\u0019;f[\u0016tG\u000fI\u0001\u0007e\u0016\u001cX\u000f\u001c;\u0016\u0005\u0005\u0015\u0002\u0003BA\u0014\u0003{qA!!\u000b\u0002:9!\u00111FA\u001c\u001d\u0011\ti#!\u000e\u000f\t\u0005=\u00121\u0007\b\u0004E\u0006E\u0012\"\u0001\u001d\n\u0005Y:\u0014B\u0001\u001b6\u0013\t\u00114'C\u0002\u0002<E\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002@\u0005\u0005#!\u0003#bi\u00064%/Y7f\u0015\r\tY$M\u0001\u000be\u0016\u001cX\u000f\u001c;`I\u0015\fH\u0003BA$\u0003\u001b\u00022a^A%\u0013\r\tY%\u001a\u0002\u0005+:LG\u000fC\u0005\u0002PA\t\t\u00111\u0001\u0002&\u0005\u0019\u0001\u0010J\u0019\u0002\u000fI,7/\u001e7uA\u0005!\u0011\u000e^3s+\t\t9\u0006E\u0003G\u00033\ni&C\u0002\u0002\\5\u0012QBR3uG\"LE/\u001a:bi>\u0014\bcA*\u0002`%\u0019\u0011\u0011M\u0019\u0003\u0007I{w/\u0001\u0005ji\u0016\u0014x\fJ3r)\u0011\t9%a\u001a\t\u0013\u0005=3#!AA\u0002\u0005]\u0013!B5uKJ\u0004\u0013!\u00033bi\u0006$\u0016\u0010]3t+\t\ty\u0007E\u0003x\u0003c\n)(C\u0002\u0002t\u0015\u0014Q!\u0011:sCf\u0004B!a\u001e\u0002~5\u0011\u0011\u0011\u0010\u0006\u0004\u0003w\n\u0014!\u0002;za\u0016\u001c\u0018\u0002BA@\u0003s\u0012\u0001\u0002R1uCRK\b/Z\u0001\u000eI\u0006$\u0018\rV=qKN|F%Z9\u0015\t\u0005\u001d\u0013Q\u0011\u0005\n\u0003\u001f2\u0012\u0011!a\u0001\u0003_\n!\u0002Z1uCRK\b/Z:!\u00031\u0011Xm];miN\u001b\u0007.Z7b+\t\ti\t\u0005\u0003\u0002\u0010\u0006EU\"\u0001 \n\u0007\u0005MeHA\u0006UC\ndWmU2iK6\f\u0017!F1eI:{gNT;mY\u000e{G.^7o-\u0006dW/\u001a\u000b\u000b\u0003\u000f\nI*!(\u00028\u0006\u0005\u0007bBAN3\u0001\u0007\u0011QL\u0001\u0005MJ|W\u000eC\u0004\u0002 f\u0001\r!!)\u0002\u0005Q|\u0007CBAR\u0003[\u000b\t,\u0004\u0002\u0002&*!\u0011qUAU\u0003\u001diW\u000f^1cY\u0016T1!a+f\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003_\u000b)KA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bcA<\u00024&\u0019\u0011QW3\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002:f\u0001\r!a/\u0002\u000f=\u0014H-\u001b8bYB\u0019q/!0\n\u0007\u0005}VMA\u0002J]RDq!a1\u001a\u0001\u0004\t)-\u0001\buS6,gi\u001c:nCR$XM]:\u0011\t\u0005\u001d\u0017Q\u001b\b\u0005\u0003\u0013\fyM\u0004\u0003\u0002*\u0005-\u0017bAAgc\u0005IQ\r_3dkRLwN\\\u0005\u0005\u0003#\f\u0019.\u0001\u0006ISZ,'+Z:vYRT1!!42\u0013\u0011\t9.!7\u0003\u001dQKW.\u001a$pe6\fG\u000f^3sg*!\u0011\u0011[Aj\u000359W\r\u001e(fqR\u0014vn^*fiR1\u0011q\\As\u0003_\u0004B!a$\u0002b&\u0019\u00111\u001d \u0003\rI{woU3u\u0011\u001d\t9O\u0007a\u0001\u0003S\fQa\u001c:eKJ\u0004B!a$\u0002l&\u0019\u0011Q\u001e \u0003!\u0019+Go\u00195Pe&,g\u000e^1uS>t\u0007BBAy5\u0001\u000710\u0001\u0005nCb\u0014vn^:M\u0003U9W\r\u001e(fqR\u0014vn^*fi&sG/\u001a:oC2$b!a8\u0002x\u0006e\bbBAt7\u0001\u0007\u0011\u0011\u001e\u0005\u0007\u0003c\\\u0002\u0019A>\u0002%\u001d,GOU3tk2$8+\u001a;TG\",W.\u0019\u000b\u0003\u0003\u001b\u000b1B];o\u0013:$XM\u001d8bYR\u0011\u0011qI\u0001\bKb,7-\u001e;f\u00035!\u0018.\\3pkR\u001c\u0015M\\2fY\u000611-\u00198dK2\fqa\u00197fC:,\b/A\u0015qe>$Xm\u0019;fI\u00122\u0018\r\\5eCR,G)\u001a4bk2$h)\u001a;dQ>\u0013\u0018.\u001a8uCRLwN\u001c\u000b\u0005\u0005\u001f\u0011)\u0002\u0006\u0003\u0002H\tE\u0001b\u0002B\nE\u0001\u0007\u0011\u0011^\u0001\f_JLWM\u001c;bi&|g\u000eC\u0005\u0002P\t\n\t\u00111\u0001\u0002\u0002\u0005)\u0002O]8uK\u000e$X\r\u001a\u0013bgN,'\u000f^*uCR,G\u0003\u0002B\u000e\u0005O!B!a\u0012\u0003\u001e!9!qD\u0012A\u0002\t\u0005\u0012!B:uCR,\u0007\u0003BAH\u0005GI1A!\n?\u00059y\u0005/\u001a:bi&|gn\u0015;bi\u0016D\u0011\"a\u0014$\u0003\u0003\u0005\r!!\u0001\u00023A\u0014x\u000e^3di\u0016$Ge]3u\u0011\u0006\u001c(+Z:vYR\u001cV\r\u001e\u000b\u0005\u0005[\u0011\u0019\u0004\u0006\u0003\u0002H\t=\u0002B\u0002B\u0019I\u0001\u0007a/\u0001\u0007iCN\u0014Vm];miN+G\u000fC\u0005\u0002P\u0011\n\t\u00111\u0001\u0002\u0002\u0005y\u0002O]8uK\u000e$X\r\u001a\u0013tKR|\u0005/\u001a:bi&|g.\u0012=dKB$\u0018n\u001c8\u0015\t\te\"Q\t\u000b\u0005\u0003\u000f\u0012Y\u0004C\u0004\u0003>\u0015\u0002\rAa\u0010\u0002%=\u0004XM]1uS>tW\t_2faRLwN\u001c\t\u0005\u0003\u001f\u0013\t%C\u0002\u0003Dy\u0012\u0001\u0003S5wKN\u000bF*\u0012=dKB$\u0018n\u001c8\t\u0013\u0005=S%!AA\u0002\u0005\u0005\u0011!\n9s_R,7\r^3eII,w-[:uKJ\u001cUO\u001d:f]R|\u0005/\u001a:bi&|g\u000eT8h)\u0011\u0011\tAa\u0013\t\u0013\u0005=c%!AA\u0002\u0005\u0005\u0011AH*qCJ\\W\t_3dkR,7\u000b^1uK6,g\u000e^(qKJ\fG/[8o!\t1\u0005fE\u0002)\u0005'\u00022a\u001eB+\u0013\r\u00119&\u001a\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\t=\u0013AD4fiR\u000b'\r\\3TG\",W.\u0019\u000b\u0005\u0003\u001b\u0013y\u0006C\u0004\u0003b)\u0002\rAa\u0019\u0002\u0015M$(/^2u)f\u0004X\r\u0005\u0003\u0002x\t\u0015\u0014\u0002\u0002B4\u0003s\u0012!b\u0015;sk\u000e$H+\u001f9f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u0011!Q\u000e\u0016\u0004m\n=4F\u0001B9!\u0011\u0011\u0019H! \u000e\u0005\tU$\u0002\u0002B<\u0005s\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tmT-\u0001\u0006b]:|G/\u0019;j_:LAAa \u0003v\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class SparkExecuteStatementOperation
extends ExecuteStatementOperation
implements SparkOperation {
    private TableSchema resultSchema;
    private final SQLContext sqlContext;
    private final HiveSession parentSession;
    private final String statement;
    private final boolean runInBackground;
    private final long org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$timeout;
    private final boolean forceCancel;
    private final String substitutorStatement;
    private Dataset<Row> org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$result;
    private FetchIterator<Row> iter;
    private DataType[] dataTypes;
    private String statementId;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$5() {
        return SparkExecuteStatementOperation$.MODULE$.$lessinit$greater$default$5();
    }

    public static TableSchema getTableSchema(StructType structType) {
        return SparkExecuteStatementOperation$.MODULE$.getTableSchema(structType);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$thriftserver$SparkOperation$$super$run() {
        super.run();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$thriftserver$SparkOperation$$super$close() {
        super.close();
    }

    @Override
    public /* synthetic */ OperationState org$apache$spark$sql$hive$thriftserver$SparkOperation$$super$setState(OperationState newState) {
        return super.setState(newState);
    }

    @Override
    public void run() {
        SparkOperation.run$(this);
    }

    @Override
    public void close() {
        SparkOperation.close$(this);
    }

    @Override
    public <T> T withLocalProperties(Function0<T> f) {
        return (T)SparkOperation.withLocalProperties$(this, f);
    }

    @Override
    public String tableTypeString(CatalogTableType tableType) {
        return SparkOperation.tableTypeString$(this, tableType);
    }

    @Override
    public PartialFunction<Throwable, BoxedUnit> onError() {
        return SparkOperation.onError$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public String statementId() {
        return this.statementId;
    }

    @Override
    public void statementId_$eq(String x$1) {
        this.statementId = x$1;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public /* synthetic */ void protected$validateDefaultFetchOrientation(SparkExecuteStatementOperation x$1, FetchOrientation orientation) {
        x$1.validateDefaultFetchOrientation(orientation);
    }

    public /* synthetic */ void protected$assertState(SparkExecuteStatementOperation x$1, OperationState state) {
        x$1.assertState(state);
    }

    public /* synthetic */ void protected$setHasResultSet(SparkExecuteStatementOperation x$1, boolean hasResultSet) {
        x$1.setHasResultSet(hasResultSet);
    }

    public /* synthetic */ void protected$setOperationException(SparkExecuteStatementOperation x$1, HiveSQLException operationException) {
        x$1.setOperationException(operationException);
    }

    public /* synthetic */ void protected$registerCurrentOperationLog(SparkExecuteStatementOperation x$1) {
        x$1.registerCurrentOperationLog();
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public long org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$timeout() {
        return this.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$timeout;
    }

    private boolean forceCancel() {
        return this.forceCancel;
    }

    private String substitutorStatement() {
        return this.substitutorStatement;
    }

    public Dataset<Row> org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$result() {
        return this.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$result;
    }

    private void org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$result_$eq(Dataset<Row> x$1) {
        this.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$result = x$1;
    }

    private FetchIterator<Row> iter() {
        return this.iter;
    }

    private void iter_$eq(FetchIterator<Row> x$1) {
        this.iter = x$1;
    }

    private DataType[] dataTypes() {
        return this.dataTypes;
    }

    private void dataTypes_$eq(DataType[] x$1) {
        this.dataTypes = x$1;
    }

    private TableSchema resultSchema$lzycompute() {
        SparkExecuteStatementOperation sparkExecuteStatementOperation = this;
        synchronized (sparkExecuteStatementOperation) {
            if (!this.bitmap$0) {
                TableSchema tableSchema;
                if (this.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$result() == null || this.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$result().schema().isEmpty()) {
                    tableSchema = new TableSchema(Arrays.asList((Object[])new FieldSchema[]{new FieldSchema("Result", "string", "")}));
                } else {
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(15).append("Result Schema: ").append(this.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$result().schema()).toString());
                    tableSchema = SparkExecuteStatementOperation$.MODULE$.getTableSchema(this.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$result().schema());
                }
                this.resultSchema = tableSchema;
                this.bitmap$0 = true;
            }
        }
        return this.resultSchema;
    }

    private TableSchema resultSchema() {
        if (!this.bitmap$0) {
            return this.resultSchema$lzycompute();
        }
        return this.resultSchema;
    }

    public void addNonNullColumnValue(Row from, ArrayBuffer<Object> to, int ordinal, HiveResult.TimeFormatters timeFormatters) {
        DataType dataType = this.dataTypes()[ordinal];
        if (StringType$.MODULE$.equals(dataType)) {
            to.$plus$eq((Object)from.getString(ordinal));
            return;
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            to.$plus$eq((Object)BoxesRunTime.boxToInteger((int)from.getInt(ordinal)));
            return;
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            to.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)from.getBoolean(ordinal)));
            return;
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            to.$plus$eq((Object)BoxesRunTime.boxToDouble((double)from.getDouble(ordinal)));
            return;
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            to.$plus$eq((Object)BoxesRunTime.boxToFloat((float)from.getFloat(ordinal)));
            return;
        }
        if (DecimalType$.MODULE$.unapply(dataType)) {
            to.$plus$eq((Object)from.getDecimal(ordinal));
            return;
        }
        if (LongType$.MODULE$.equals(dataType)) {
            to.$plus$eq((Object)BoxesRunTime.boxToLong((long)from.getLong(ordinal)));
            return;
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            to.$plus$eq((Object)BoxesRunTime.boxToByte((byte)from.getByte(ordinal)));
            return;
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            to.$plus$eq((Object)BoxesRunTime.boxToShort((short)from.getShort(ordinal)));
            return;
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            to.$plus$eq(from.getAs(ordinal));
            return;
        }
        if (dataType instanceof DateType ? true : dataType instanceof TimestampType) {
            to.$plus$eq((Object)HiveResult$.MODULE$.toHiveString(new Tuple2(from.get(ordinal), (Object)this.dataTypes()[ordinal]), false, timeFormatters));
            return;
        }
        if (CalendarIntervalType$.MODULE$.equals(dataType)) {
            to.$plus$eq((Object)HiveResult$.MODULE$.toHiveString(new Tuple2(from.getAs(ordinal), (Object)CalendarIntervalType$.MODULE$), false, timeFormatters));
            return;
        }
        if (dataType instanceof ArrayType ? true : (dataType instanceof StructType ? true : (dataType instanceof MapType ? true : (dataType instanceof UserDefinedType ? true : (dataType instanceof AnsiIntervalType ? true : dataType instanceof TimestampNTZType))))) {
            to.$plus$eq((Object)HiveResult$.MODULE$.toHiveString(new Tuple2(from.get(ordinal), (Object)this.dataTypes()[ordinal]), false, timeFormatters));
            return;
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public RowSet getNextRowSet(FetchOrientation order, long maxRowsL) {
        return (RowSet)this.withLocalProperties((Function0 & Serializable & scala.Serializable)() -> {
            RowSet rowSet;
            try {
                this.sqlContext().sparkContext().setJobGroup(this.statementId(), this.substitutorStatement(), this.forceCancel());
                rowSet = this.getNextRowSetInternal(order, maxRowsL);
            }
            finally {
                this.sqlContext().sparkContext().clearJobGroup();
            }
            return rowSet;
        });
    }

    private RowSet getNextRowSetInternal(FetchOrientation order, long maxRowsL) {
        return (RowSet)this.withLocalProperties((Function0 & Serializable & scala.Serializable)() -> {
            int curRow;
            this.log().info(new java.lang.StringBuilder(57).append("Received getNextRowSet request order=").append((Object)order).append(" and maxRowsL=").append(maxRowsL).append(" ").append("with ").append(this.statementId()).toString());
            this.protected$validateDefaultFetchOrientation(this, order);
            this.protected$assertState(this, OperationState.FINISHED);
            this.protected$setHasResultSet(this, true);
            RowSet resultRowSet = RowSetFactory.create(this.getResultSetSchema(), this.getProtocolVersion(), false);
            if (order.equals((Object)FetchOrientation.FETCH_FIRST)) {
                this.iter().fetchAbsolute(0L);
            } else if (order.equals((Object)FetchOrientation.FETCH_PRIOR)) {
                this.iter().fetchPrior(maxRowsL);
            } else {
                this.iter().fetchNext();
            }
            resultRowSet.setStartOffset(this.iter().getPosition());
            if (!this.iter().hasNext()) {
                return resultRowSet;
            }
            HiveResult.TimeFormatters timeFormatters = HiveResult$.MODULE$.getTimeFormatters();
            int maxRows = (int)maxRowsL;
            for (curRow = 0; curRow < maxRows && this.iter().hasNext(); ++curRow) {
                Row sparkRow = (Row)this.iter().next();
                ArrayBuffer row = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                for (int curCol = 0; curCol < sparkRow.length(); ++curCol) {
                    ArrayBuffer arrayBuffer;
                    if (sparkRow.isNullAt(curCol)) {
                        arrayBuffer = row.$plus$eq(null);
                        continue;
                    }
                    this.addNonNullColumnValue(sparkRow, (ArrayBuffer<Object>)row, curCol, timeFormatters);
                    arrayBuffer = BoxedUnit.UNIT;
                }
                resultRowSet.addRow((Object[])row.toArray(ClassTag$.MODULE$.Any()));
            }
            this.log().info(new java.lang.StringBuilder(55).append("Returning result set with ").append(curRow).append(" rows from offsets ").append("[").append(this.iter().getFetchStart()).append(", ").append(this.iter().getPosition()).append(") with ").append(this.statementId()).toString());
            return resultRowSet;
        });
    }

    @Override
    public TableSchema getResultSetSchema() {
        return this.resultSchema();
    }

    @Override
    public void runInternal() {
        Object object;
        this.setState(OperationState.PENDING);
        String redactedStatement = Utils$.MODULE$.redact(this.sqlContext().conf().stringRedactionPattern(), this.statement);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(25).append("Submitting query '").append(redactedStatement).append("' with ").append(this.statementId()).toString());
        HiveThriftServer2$.MODULE$.eventManager().onStatementStart(this.statementId(), this.parentSession.getSessionHandle().getSessionId().toString(), redactedStatement, this.statementId(), this.parentSession.getUsername());
        this.setHasResultSet(true);
        if (this.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$timeout() > 0L) {
            ScheduledExecutorService timeoutExecutor = Executors.newSingleThreadScheduledExecutor();
            object = timeoutExecutor.schedule(new Runnable(this, timeoutExecutor){
                private final /* synthetic */ SparkExecuteStatementOperation $outer;
                private final ScheduledExecutorService timeoutExecutor$1;

                public void run() {
                    block6: {
                        try {
                            try {
                                this.$outer.timeoutCancel();
                            }
                            catch (Throwable throwable) {
                                Throwable throwable2 = throwable;
                                Option option = NonFatal$.MODULE$.unapply(throwable2);
                                if (!option.isEmpty()) {
                                    Throwable e = (Throwable)option.get();
                                    this.$outer.protected$setOperationException(this.$outer, new HiveSQLException(e));
                                    this.$outer.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(50).append("Error cancelling the query after timeout: ").append($this.$outer.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$timeout()).append(" seconds").toString());
                                    break block6;
                                }
                                throw throwable;
                            }
                        }
                        finally {
                            this.timeoutExecutor$1.shutdown();
                        }
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.timeoutExecutor$1 = timeoutExecutor$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.spark.sql.hive.thriftserver.SparkExecuteStatementOperation$$anon$1 )}, serializedLambda);
                }
            }, this.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$timeout(), TimeUnit.SECONDS);
        } else {
            object = BoxedUnit.UNIT;
        }
        if (!this.runInBackground) {
            this.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$execute();
            return;
        }
        UserGroupInformation sparkServiceUGI = Utils.getUGI();
        Runnable backgroundOperation = new Runnable(this, sparkServiceUGI){
            private final /* synthetic */ SparkExecuteStatementOperation $outer;
            private final UserGroupInformation sparkServiceUGI$1;

            public void run() {
                PrivilegedExceptionAction<BoxedUnit> doAsAction = new PrivilegedExceptionAction<BoxedUnit>(this){
                    private final /* synthetic */ $anon$2 $outer;

                    public void run() {
                        this.$outer.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$anon$$$outer().protected$registerCurrentOperationLog(this.$outer.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$anon$$$outer());
                        try {
                            this.$outer.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$anon$$$outer().withLocalProperties((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.$outer.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$anon$$$outer().org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$execute());
                        }
                        catch (HiveSQLException e) {
                            this.$outer.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$anon$$$outer().protected$setOperationException(this.$outer.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$anon$$$outer(), e);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$2(org.apache.spark.sql.hive.thriftserver.SparkExecuteStatementOperation$$anon$2$$anon$3 )}, serializedLambda);
                    }
                };
                try {
                    this.sparkServiceUGI$1.doAs((PrivilegedExceptionAction)doAsAction);
                }
                catch (Exception e) {
                    this.$outer.protected$setOperationException(this.$outer, new HiveSQLException(e));
                    this.$outer.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(35).append("Error running hive query as user : ").append($this.sparkServiceUGI$1.getShortUserName()).toString(), e);
                }
            }

            public /* synthetic */ SparkExecuteStatementOperation org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sparkServiceUGI$1 = sparkServiceUGI$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$3(org.apache.spark.sql.hive.thriftserver.SparkExecuteStatementOperation$$anon$2 )}, serializedLambda);
            }
        };
        try {
            Future<?> backgroundHandle = this.parentSession.getSessionManager().submitBackgroundOperation(backgroundOperation);
            this.setBackgroundHandle(backgroundHandle);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof RejectedExecutionException) {
                RejectedExecutionException rejectedExecutionException = (RejectedExecutionException)throwable2;
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error submitting query in background, query rejected", rejectedExecutionException);
                this.setState(OperationState.ERROR);
                HiveThriftServer2$.MODULE$.eventManager().onStatementError(this.statementId(), rejectedExecutionException.getMessage(), Utils$.MODULE$.exceptionString((Throwable)rejectedExecutionException));
                throw HiveThriftServerErrors$.MODULE$.taskExecutionRejectedError(rejectedExecutionException);
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error executing query in background", e);
                this.setState(OperationState.ERROR);
                HiveThriftServer2$.MODULE$.eventManager().onStatementError(this.statementId(), e.getMessage(), Utils$.MODULE$.exceptionString(e));
                throw new HiveSQLException(e);
            }
            throw throwable;
        }
    }

    public void org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$execute() {
        block27: {
            block26: {
                try {
                    try {
                        block25: {
                            SparkExecuteStatementOperation sparkExecuteStatementOperation = this;
                            synchronized (sparkExecuteStatementOperation) {
                                block24: {
                                    if (this.getStatus().getState().isTerminal()) {
                                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(55).append("Query with ").append(this.statementId()).append(" in terminal state before it started running").toString());
                                        break block24;
                                    }
                                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(19).append("Running query with ").append(this.statementId()).toString());
                                    this.setState(OperationState.RUNNING);
                                    break block25;
                                }
                                break block26;
                            }
                        }
                        NonClosableMutableURLClassLoader executionHiveClassLoader = this.sqlContext().sharedState().jarClassLoader();
                        Thread.currentThread().setContextClassLoader((ClassLoader)executionHiveClassLoader);
                        if (!this.runInBackground) {
                            this.parentSession.getSessionState().getConf().setClassLoader((ClassLoader)executionHiveClassLoader);
                        }
                        this.sqlContext().sparkContext().setJobGroup(this.statementId(), this.substitutorStatement(), this.forceCancel());
                        this.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$result_$eq((Dataset<Row>)this.sqlContext().sql(this.statement));
                        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> this.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$result().queryExecution().toString());
                        HiveThriftServer2$.MODULE$.eventManager().onStatementParsed(this.statementId(), this.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$result().queryExecution().toString());
                        this.iter_$eq(new StringOps(Predef$.MODULE$.augmentString(this.sqlContext().getConf(SQLConf$.MODULE$.THRIFTSERVER_INCREMENTAL_COLLECT().key()))).toBoolean() ? new IterableFetchIterator<Row>(new Iterable<Row>(this){
                            private final /* synthetic */ SparkExecuteStatementOperation $outer;

                            public GenericCompanion<Iterable> companion() {
                                return Iterable.companion$((Iterable)this);
                            }

                            public Iterable<Row> seq() {
                                return Iterable.seq$((Iterable)this);
                            }

                            public Iterable<Row> thisCollection() {
                                return IterableLike.thisCollection$((IterableLike)this);
                            }

                            public Iterable toCollection(Object repr) {
                                return IterableLike.toCollection$((IterableLike)this, (Object)repr);
                            }

                            public <U> void foreach(Function1<Row, U> f) {
                                IterableLike.foreach$((IterableLike)this, f);
                            }

                            public boolean forall(Function1<Row, Object> p) {
                                return IterableLike.forall$((IterableLike)this, p);
                            }

                            public boolean exists(Function1<Row, Object> p) {
                                return IterableLike.exists$((IterableLike)this, p);
                            }

                            public Option<Row> find(Function1<Row, Object> p) {
                                return IterableLike.find$((IterableLike)this, p);
                            }

                            public boolean isEmpty() {
                                return IterableLike.isEmpty$((IterableLike)this);
                            }

                            public <B> B foldRight(B z, Function2<Row, B, B> op) {
                                return (B)IterableLike.foldRight$((IterableLike)this, z, op);
                            }

                            public <B> B reduceRight(Function2<Row, B, B> op) {
                                return (B)IterableLike.reduceRight$((IterableLike)this, op);
                            }

                            public Iterable<Row> toIterable() {
                                return IterableLike.toIterable$((IterableLike)this);
                            }

                            public Iterator<Row> toIterator() {
                                return IterableLike.toIterator$((IterableLike)this);
                            }

                            public Object head() {
                                return IterableLike.head$((IterableLike)this);
                            }

                            public Object slice(int from, int until) {
                                return IterableLike.slice$((IterableLike)this, (int)from, (int)until);
                            }

                            public Object take(int n) {
                                return IterableLike.take$((IterableLike)this, (int)n);
                            }

                            public Object drop(int n) {
                                return IterableLike.drop$((IterableLike)this, (int)n);
                            }

                            public Object takeWhile(Function1 p) {
                                return IterableLike.takeWhile$((IterableLike)this, (Function1)p);
                            }

                            public Iterator<Iterable<Row>> grouped(int size) {
                                return IterableLike.grouped$((IterableLike)this, (int)size);
                            }

                            public Iterator<Iterable<Row>> sliding(int size) {
                                return IterableLike.sliding$((IterableLike)this, (int)size);
                            }

                            public Iterator<Iterable<Row>> sliding(int size, int step) {
                                return IterableLike.sliding$((IterableLike)this, (int)size, (int)step);
                            }

                            public Object takeRight(int n) {
                                return IterableLike.takeRight$((IterableLike)this, (int)n);
                            }

                            public Object dropRight(int n) {
                                return IterableLike.dropRight$((IterableLike)this, (int)n);
                            }

                            public <B> void copyToArray(Object xs, int start, int len) {
                                IterableLike.copyToArray$((IterableLike)this, (Object)xs, (int)start, (int)len);
                            }

                            public <A1, B, That> That zip(GenIterable<B> that, CanBuildFrom<Iterable<Row>, Tuple2<A1, B>, That> bf) {
                                return (That)IterableLike.zip$((IterableLike)this, that, bf);
                            }

                            public <B, A1, That> That zipAll(GenIterable<B> that, A1 thisElem, B thatElem, CanBuildFrom<Iterable<Row>, Tuple2<A1, B>, That> bf) {
                                return (That)IterableLike.zipAll$((IterableLike)this, that, thisElem, thatElem, bf);
                            }

                            public <A1, That> That zipWithIndex(CanBuildFrom<Iterable<Row>, Tuple2<A1, Object>, That> bf) {
                                return (That)IterableLike.zipWithIndex$((IterableLike)this, bf);
                            }

                            public <B> boolean sameElements(GenIterable<B> that) {
                                return IterableLike.sameElements$((IterableLike)this, that);
                            }

                            public Stream<Row> toStream() {
                                return IterableLike.toStream$((IterableLike)this);
                            }

                            public boolean canEqual(Object that) {
                                return IterableLike.canEqual$((IterableLike)this, (Object)that);
                            }

                            public IterableView<Row, Iterable<Row>> view() {
                                return IterableLike.view$((IterableLike)this);
                            }

                            public IterableView<Row, Iterable<Row>> view(int from, int until) {
                                return IterableLike.view$((IterableLike)this, (int)from, (int)until);
                            }

                            public Builder<Row, Iterable<Row>> newBuilder() {
                                return GenericTraversableTemplate.newBuilder$((GenericTraversableTemplate)this);
                            }

                            public <B> Builder<B, Iterable<B>> genericBuilder() {
                                return GenericTraversableTemplate.genericBuilder$((GenericTraversableTemplate)this);
                            }

                            public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> unzip(Function1<Row, Tuple2<A1, A2>> asPair) {
                                return GenericTraversableTemplate.unzip$((GenericTraversableTemplate)this, asPair);
                            }

                            public <A1, A2, A3> Tuple3<Iterable<A1>, Iterable<A2>, Iterable<A3>> unzip3(Function1<Row, Tuple3<A1, A2, A3>> asTriple) {
                                return GenericTraversableTemplate.unzip3$((GenericTraversableTemplate)this, asTriple);
                            }

                            public GenTraversable flatten(Function1 asTraversable) {
                                return GenericTraversableTemplate.flatten$((GenericTraversableTemplate)this, (Function1)asTraversable);
                            }

                            public GenTraversable transpose(Function1 asTraversable) {
                                return GenericTraversableTemplate.transpose$((GenericTraversableTemplate)this, (Function1)asTraversable);
                            }

                            public Object repr() {
                                return TraversableLike.repr$((TraversableLike)this);
                            }

                            public final boolean isTraversableAgain() {
                                return TraversableLike.isTraversableAgain$((TraversableLike)this);
                            }

                            public Combiner<Row, ParIterable<Row>> parCombiner() {
                                return TraversableLike.parCombiner$((TraversableLike)this);
                            }

                            public boolean hasDefiniteSize() {
                                return TraversableLike.hasDefiniteSize$((TraversableLike)this);
                            }

                            public <B, That> That $plus$plus(GenTraversableOnce<B> that, CanBuildFrom<Iterable<Row>, B, That> bf) {
                                return (That)TraversableLike.$plus$plus$((TraversableLike)this, that, bf);
                            }

                            public <B, That> That $plus$plus$colon(TraversableOnce<B> that, CanBuildFrom<Iterable<Row>, B, That> bf) {
                                return (That)TraversableLike.$plus$plus$colon$((TraversableLike)this, that, bf);
                            }

                            public <B, That> That $plus$plus$colon(Traversable<B> that, CanBuildFrom<Iterable<Row>, B, That> bf) {
                                return (That)TraversableLike.$plus$plus$colon$((TraversableLike)this, that, bf);
                            }

                            public <B, That> That map(Function1<Row, B> f, CanBuildFrom<Iterable<Row>, B, That> bf) {
                                return (That)TraversableLike.map$((TraversableLike)this, f, bf);
                            }

                            public <B, That> That flatMap(Function1<Row, GenTraversableOnce<B>> f, CanBuildFrom<Iterable<Row>, B, That> bf) {
                                return (That)TraversableLike.flatMap$((TraversableLike)this, f, bf);
                            }

                            public Object filterImpl(Function1 p, boolean isFlipped) {
                                return TraversableLike.filterImpl$((TraversableLike)this, (Function1)p, (boolean)isFlipped);
                            }

                            public Object filter(Function1 p) {
                                return TraversableLike.filter$((TraversableLike)this, (Function1)p);
                            }

                            public Object filterNot(Function1 p) {
                                return TraversableLike.filterNot$((TraversableLike)this, (Function1)p);
                            }

                            public <B, That> That collect(PartialFunction<Row, B> pf, CanBuildFrom<Iterable<Row>, B, That> bf) {
                                return (That)TraversableLike.collect$((TraversableLike)this, pf, bf);
                            }

                            public Tuple2<Iterable<Row>, Iterable<Row>> partition(Function1<Row, Object> p) {
                                return TraversableLike.partition$((TraversableLike)this, p);
                            }

                            public <K> scala.collection.immutable.Map<K, Iterable<Row>> groupBy(Function1<Row, K> f) {
                                return TraversableLike.groupBy$((TraversableLike)this, f);
                            }

                            public <B, That> That scan(B z, Function2<B, B, B> op, CanBuildFrom<Iterable<Row>, B, That> cbf) {
                                return (That)TraversableLike.scan$((TraversableLike)this, z, op, cbf);
                            }

                            public <B, That> That scanLeft(B z, Function2<B, Row, B> op, CanBuildFrom<Iterable<Row>, B, That> bf) {
                                return (That)TraversableLike.scanLeft$((TraversableLike)this, z, op, bf);
                            }

                            public <B, That> That scanRight(B z, Function2<Row, B, B> op, CanBuildFrom<Iterable<Row>, B, That> bf) {
                                return (That)TraversableLike.scanRight$((TraversableLike)this, z, op, bf);
                            }

                            public Option<Row> headOption() {
                                return TraversableLike.headOption$((TraversableLike)this);
                            }

                            public Object tail() {
                                return TraversableLike.tail$((TraversableLike)this);
                            }

                            public Object last() {
                                return TraversableLike.last$((TraversableLike)this);
                            }

                            public Option<Row> lastOption() {
                                return TraversableLike.lastOption$((TraversableLike)this);
                            }

                            public Object init() {
                                return TraversableLike.init$((TraversableLike)this);
                            }

                            public Object sliceWithKnownDelta(int from, int until, int delta) {
                                return TraversableLike.sliceWithKnownDelta$((TraversableLike)this, (int)from, (int)until, (int)delta);
                            }

                            public Object sliceWithKnownBound(int from, int until) {
                                return TraversableLike.sliceWithKnownBound$((TraversableLike)this, (int)from, (int)until);
                            }

                            public Object dropWhile(Function1 p) {
                                return TraversableLike.dropWhile$((TraversableLike)this, (Function1)p);
                            }

                            public Tuple2<Iterable<Row>, Iterable<Row>> span(Function1<Row, Object> p) {
                                return TraversableLike.span$((TraversableLike)this, p);
                            }

                            public Tuple2<Iterable<Row>, Iterable<Row>> splitAt(int n) {
                                return TraversableLike.splitAt$((TraversableLike)this, (int)n);
                            }

                            public Iterator<Iterable<Row>> tails() {
                                return TraversableLike.tails$((TraversableLike)this);
                            }

                            public Iterator<Iterable<Row>> inits() {
                                return TraversableLike.inits$((TraversableLike)this);
                            }

                            public Traversable<Row> toTraversable() {
                                return TraversableLike.toTraversable$((TraversableLike)this);
                            }

                            public <Col> Col to(CanBuildFrom<Nothing$, Row, Col> cbf) {
                                return (Col)TraversableLike.to$((TraversableLike)this, cbf);
                            }

                            public String toString() {
                                return TraversableLike.toString$((TraversableLike)this);
                            }

                            public String stringPrefix() {
                                return TraversableLike.stringPrefix$((TraversableLike)this);
                            }

                            public FilterMonadic<Row, Iterable<Row>> withFilter(Function1<Row, Object> p) {
                                return TraversableLike.withFilter$((TraversableLike)this, p);
                            }

                            public Parallel par() {
                                return Parallelizable.par$((Parallelizable)this);
                            }

                            public List<Row> reversed() {
                                return TraversableOnce.reversed$((TraversableOnce)this);
                            }

                            public int size() {
                                return TraversableOnce.size$((TraversableOnce)this);
                            }

                            public boolean nonEmpty() {
                                return TraversableOnce.nonEmpty$((TraversableOnce)this);
                            }

                            public int count(Function1<Row, Object> p) {
                                return TraversableOnce.count$((TraversableOnce)this, p);
                            }

                            public <B> Option<B> collectFirst(PartialFunction<Row, B> pf) {
                                return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
                            }

                            public <B> B $div$colon(B z, Function2<B, Row, B> op) {
                                return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
                            }

                            public <B> B $colon$bslash(B z, Function2<Row, B, B> op) {
                                return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
                            }

                            public <B> B foldLeft(B z, Function2<B, Row, B> op) {
                                return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
                            }

                            public <B> B reduceLeft(Function2<B, Row, B> op) {
                                return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
                            }

                            public <B> Option<B> reduceLeftOption(Function2<B, Row, B> op) {
                                return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
                            }

                            public <B> Option<B> reduceRightOption(Function2<Row, B, B> op) {
                                return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
                            }

                            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                                return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
                            }

                            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                                return TraversableOnce.reduceOption$((TraversableOnce)this, op);
                            }

                            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                                return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
                            }

                            public <B> B aggregate(Function0<B> z, Function2<B, Row, B> seqop, Function2<B, B, B> combop) {
                                return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
                            }

                            public <B> B sum(Numeric<B> num) {
                                return (B)TraversableOnce.sum$((TraversableOnce)this, num);
                            }

                            public <B> B product(Numeric<B> num) {
                                return (B)TraversableOnce.product$((TraversableOnce)this, num);
                            }

                            public Object min(Ordering cmp) {
                                return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
                            }

                            public Object max(Ordering cmp) {
                                return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
                            }

                            public Object maxBy(Function1 f, Ordering cmp) {
                                return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                            }

                            public Object minBy(Function1 f, Ordering cmp) {
                                return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                            }

                            public <B> void copyToBuffer(Buffer<B> dest) {
                                TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
                            }

                            public <B> void copyToArray(Object xs, int start) {
                                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
                            }

                            public <B> void copyToArray(Object xs) {
                                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
                            }

                            public <B> Object toArray(ClassTag<B> evidence$1) {
                                return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
                            }

                            public List<Row> toList() {
                                return TraversableOnce.toList$((TraversableOnce)this);
                            }

                            public Seq<Row> toSeq() {
                                return TraversableOnce.toSeq$((TraversableOnce)this);
                            }

                            public IndexedSeq<Row> toIndexedSeq() {
                                return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
                            }

                            public <B> Buffer<B> toBuffer() {
                                return TraversableOnce.toBuffer$((TraversableOnce)this);
                            }

                            public <B> Set<B> toSet() {
                                return TraversableOnce.toSet$((TraversableOnce)this);
                            }

                            public Vector<Row> toVector() {
                                return TraversableOnce.toVector$((TraversableOnce)this);
                            }

                            public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef.$less$colon$less<Row, Tuple2<T, U>> ev) {
                                return TraversableOnce.toMap$((TraversableOnce)this, ev);
                            }

                            public String mkString(String start, String sep, String end) {
                                return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
                            }

                            public String mkString(String sep) {
                                return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
                            }

                            public String mkString() {
                                return TraversableOnce.mkString$((TraversableOnce)this);
                            }

                            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                            }

                            public StringBuilder addString(StringBuilder b, String sep) {
                                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
                            }

                            public StringBuilder addString(StringBuilder b) {
                                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
                            }

                            public int sizeHintIfCheap() {
                                return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
                            }

                            public Iterator<Row> iterator() {
                                return (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(this.$outer.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$result().toLocalIterator()).asScala();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                GenTraversableOnce.$init$((GenTraversableOnce)this);
                                TraversableOnce.$init$((TraversableOnce)this);
                                Parallelizable.$init$((Parallelizable)this);
                                TraversableLike.$init$((TraversableLike)this);
                                GenericTraversableTemplate.$init$((GenericTraversableTemplate)this);
                                GenTraversable.$init$((GenTraversable)this);
                                Traversable.$init$((Traversable)this);
                                GenIterable.$init$((GenIterable)this);
                                IterableLike.$init$((IterableLike)this);
                                Iterable.$init$((Iterable)this);
                            }
                        }) : new ArrayFetchIterator(this.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$result().collect()));
                        this.dataTypes_$eq((DataType[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$result().schema().fields())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.dataType(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class))));
                        break block27;
                    }
                    catch (Throwable e) {
                        OperationState currentState;
                        if (this.statementId() != null) {
                            this.sqlContext().sparkContext().cancelJobGroup(this.statementId());
                        }
                        if ((currentState = this.getStatus().getState()).isTerminal()) {
                            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(42).append("Ignore exception in terminal state with ").append(this.statementId()).append(": ").append(e).toString());
                            break block27;
                        }
                        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(44).append("Error executing query with ").append(this.statementId()).append(", currentState ").append((Object)currentState).append(", ").toString(), e);
                        this.setState(OperationState.ERROR);
                        HiveThriftServer2$.MODULE$.eventManager().onStatementError(this.statementId(), e.getMessage(), Utils$.MODULE$.exceptionString(e));
                        Throwable throwable = e;
                        if (throwable instanceof HiveSQLException) {
                            throw e;
                        }
                        throw HiveThriftServerErrors$.MODULE$.runningQueryError(e);
                    }
                }
                catch (Throwable throwable) {
                    SparkExecuteStatementOperation sparkExecuteStatementOperation = this;
                    synchronized (sparkExecuteStatementOperation) {
                        if (!this.getStatus().getState().isTerminal()) {
                            this.setState(OperationState.FINISHED);
                            HiveThriftServer2$.MODULE$.eventManager().onStatementFinish(this.statementId());
                        }
                    }
                    this.sqlContext().sparkContext().clearJobGroup();
                    throw throwable;
                }
            }
            SparkExecuteStatementOperation sparkExecuteStatementOperation = this;
            synchronized (sparkExecuteStatementOperation) {
                if (!this.getStatus().getState().isTerminal()) {
                    this.setState(OperationState.FINISHED);
                    HiveThriftServer2$.MODULE$.eventManager().onStatementFinish(this.statementId());
                }
            }
            this.sqlContext().sparkContext().clearJobGroup();
            return;
        }
        SparkExecuteStatementOperation sparkExecuteStatementOperation = this;
        synchronized (sparkExecuteStatementOperation) {
            if (!this.getStatus().getState().isTerminal()) {
                this.setState(OperationState.FINISHED);
                HiveThriftServer2$.MODULE$.eventManager().onStatementFinish(this.statementId());
            }
        }
        this.sqlContext().sparkContext().clearJobGroup();
    }

    public synchronized void timeoutCancel() {
        if (!this.getStatus().getState().isTerminal()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(36).append("Query with ").append(this.statementId()).append(" timed out after ").append(this.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$timeout()).append(" seconds").toString());
            this.setState(OperationState.TIMEDOUT);
            this.cleanup();
            HiveThriftServer2$.MODULE$.eventManager().onStatementTimeout(this.statementId());
            return;
        }
    }

    @Override
    public synchronized void cancel() {
        if (!this.getStatus().getState().isTerminal()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(18).append("Cancel query with ").append(this.statementId()).toString());
            this.setState(OperationState.CANCELED);
            this.cleanup();
            HiveThriftServer2$.MODULE$.eventManager().onStatementCanceled(this.statementId());
            return;
        }
    }

    @Override
    public void cleanup() {
        Future<?> backgroundHandle;
        Object object = this.runInBackground ? ((backgroundHandle = this.getBackgroundHandle()) != null ? BoxesRunTime.boxToBoolean((boolean)backgroundHandle.cancel(true)) : BoxedUnit.UNIT) : BoxedUnit.UNIT;
        if (this.statementId() != null) {
            this.sqlContext().sparkContext().cancelJobGroup(this.statementId());
            return;
        }
    }

    public SparkExecuteStatementOperation(SQLContext sqlContext, HiveSession parentSession, String statement, Map<String, String> confOverlay, boolean runInBackground, long queryTimeout) {
        this.sqlContext = sqlContext;
        this.parentSession = parentSession;
        this.statement = statement;
        this.runInBackground = runInBackground;
        super(parentSession, statement, confOverlay, runInBackground);
        Logging.$init$((Logging)this);
        SparkOperation.$init$(this);
        long globalTimeout = BoxesRunTime.unboxToLong((Object)sqlContext.conf().getConf(SQLConf$.MODULE$.THRIFTSERVER_QUERY_TIMEOUT()));
        this.org$apache$spark$sql$hive$thriftserver$SparkExecuteStatementOperation$$timeout = globalTimeout > 0L && (queryTimeout <= 0L || globalTimeout < queryTimeout) ? globalTimeout : queryTimeout;
        this.forceCancel = BoxesRunTime.unboxToBoolean((Object)sqlContext.conf().getConf(SQLConf$.MODULE$.THRIFTSERVER_FORCE_CANCEL()));
        this.substitutorStatement = (String)SQLConf$.MODULE$.withExistingConf(sqlContext.conf(), (Function0 & Serializable & scala.Serializable)() -> new VariableSubstitution().substitute($this.statement));
    }
}

