/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver.ui;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.scheduler.SparkListenerJobStart$;
import org.apache.spark.sql.hive.thriftserver.HiveThriftServer2;
import org.apache.spark.sql.hive.thriftserver.ui.HiveThriftServer2AppStatusStore;
import org.apache.spark.sql.hive.thriftserver.ui.HiveThriftServer2Listener;
import org.apache.spark.sql.hive.thriftserver.ui.HiveThriftServer2Listener$;
import org.apache.spark.sql.hive.thriftserver.ui.SparkListenerThriftServerOperationClosed;
import org.apache.spark.sql.hive.thriftserver.ui.SparkListenerThriftServerOperationFinish;
import org.apache.spark.sql.hive.thriftserver.ui.SparkListenerThriftServerOperationParsed;
import org.apache.spark.sql.hive.thriftserver.ui.SparkListenerThriftServerOperationStart;
import org.apache.spark.sql.hive.thriftserver.ui.SparkListenerThriftServerSessionClosed;
import org.apache.spark.sql.hive.thriftserver.ui.SparkListenerThriftServerSessionCreated;
import org.apache.spark.sql.hive.thriftserver.ui.ThriftServerPage;
import org.apache.spark.sql.hive.thriftserver.ui.ThriftServerSessionPage;
import org.apache.spark.sql.hive.thriftserver.ui.ThriftServerTab;
import org.apache.spark.status.ElementTrackingStore;
import org.apache.spark.util.kvstore.InMemoryStore;
import org.apache.spark.util.kvstore.KVStore;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001u2AAB\u0004\u0001-!)\u0011\u0005\u0001C\u0001E!IQ\u0005\u0001a\u0001\u0002\u0004%IA\n\u0005\n[\u0001\u0001\r\u00111A\u0005\n9B\u0011b\u000e\u0001A\u0002\u0003\u0005\u000b\u0015B\u0014\t\u000ba\u0002A\u0011B\u001d\u0003+QC'/\u001b4u'\u0016\u0014h/\u001a:QC\u001e,7+^5uK*\u0011\u0001\"C\u0001\u0003k&T!AC\u0006\u0002\u0019QD'/\u001b4ug\u0016\u0014h/\u001a:\u000b\u00051i\u0011\u0001\u00025jm\u0016T!AD\b\u0002\u0007M\fHN\u0003\u0002\u0011#\u0005)1\u000f]1sW*\u0011!cE\u0001\u0007CB\f7\r[3\u000b\u0003Q\t1a\u001c:h\u0007\u0001\u00192\u0001A\f\u001c!\tA\u0012$D\u0001\u0010\u0013\tQrBA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u00039}i\u0011!\b\u0006\u0003=M\t\u0011b]2bY\u0006$Xm\u001d;\n\u0005\u0001j\"A\u0004\"fM>\u0014X-\u00118e\u0003\u001a$XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\r\u0002\"\u0001\n\u0001\u000e\u0003\u001d\tqa\u001b<ti>\u0014X-F\u0001(!\tA3&D\u0001*\u0015\tQs\"\u0001\u0004ti\u0006$Xo]\u0005\u0003Y%\u0012A#\u00127f[\u0016tG\u000f\u0016:bG.LgnZ*u_J,\u0017aC6wgR|'/Z0%KF$\"aL\u001b\u0011\u0005A\u001aT\"A\u0019\u000b\u0003I\nQa]2bY\u0006L!\u0001N\u0019\u0003\tUs\u0017\u000e\u001e\u0005\bm\r\t\t\u00111\u0001(\u0003\rAH%M\u0001\tWZ\u001cHo\u001c:fA\u0005qq-\u001a;Ti\u0006$Xo]*u_J,W#\u0001\u001e\u0011\u0005\u0011Z\u0014B\u0001\u001f\b\u0005}A\u0015N^3UQJLg\r^*feZ,'OM!qaN#\u0018\r^;t'R|'/\u001a")
public class ThriftServerPageSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private ElementTrackingStore kvstore;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    private ElementTrackingStore kvstore() {
        return this.kvstore;
    }

    private void kvstore_$eq(ElementTrackingStore x$1) {
        this.kvstore = x$1;
    }

    private HiveThriftServer2AppStatusStore getStatusStore() {
        this.kvstore_$eq(new ElementTrackingStore((KVStore)new InMemoryStore(), new SparkConf()));
        HiveThriftServer2 server = (HiveThriftServer2)Mockito.mock(HiveThriftServer2.class, (Answer)Mockito.RETURNS_SMART_NULLS);
        SparkConf sparkConf = new SparkConf();
        HiveThriftServer2Listener listener = new HiveThriftServer2Listener(this.kvstore(), sparkConf, (Option)new Some((Object)server), HiveThriftServer2Listener$.MODULE$.$lessinit$greater$default$4());
        HiveThriftServer2AppStatusStore statusStore = new HiveThriftServer2AppStatusStore((KVStore)this.kvstore());
        listener.onOtherEvent((SparkListenerEvent)new SparkListenerThriftServerSessionCreated("localhost", "sessionid", "user", System.currentTimeMillis()));
        listener.onOtherEvent((SparkListenerEvent)new SparkListenerThriftServerOperationStart("id", "sessionid", "dummy query", "groupid", System.currentTimeMillis(), "user"));
        listener.onOtherEvent((SparkListenerEvent)new SparkListenerThriftServerOperationParsed("id", "dummy plan"));
        listener.onOtherEvent((SparkListenerEvent)new SparkListenerJobStart(0, System.currentTimeMillis(), (Seq)Nil$.MODULE$, SparkListenerJobStart$.MODULE$.apply$default$4()));
        listener.onOtherEvent((SparkListenerEvent)new SparkListenerThriftServerOperationFinish("id", System.currentTimeMillis()));
        listener.onOtherEvent((SparkListenerEvent)new SparkListenerThriftServerOperationClosed("id", System.currentTimeMillis()));
        listener.onOtherEvent((SparkListenerEvent)new SparkListenerThriftServerSessionClosed("sessionid", System.currentTimeMillis()));
        return statusStore;
    }

    public ThriftServerPageSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.after((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            if (this.kvstore() != null) {
                this.kvstore().close();
                this.kvstore_$eq(null);
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        }, new Position("ThriftServerPageSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
        this.test("thriftserver page should load successfully", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String html;
            HiveThriftServer2AppStatusStore store = this.getStatusStore();
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            ThriftServerTab tab = (ThriftServerTab)Mockito.mock(ThriftServerTab.class, (Answer)Mockito.RETURNS_SMART_NULLS);
            Mockito.when((Object)tab.startTime()).thenReturn((Object)Calendar.getInstance().getTime());
            Mockito.when((Object)tab.store()).thenReturn((Object)store);
            Mockito.when((Object)tab.appName()).thenReturn((Object)"testing");
            Mockito.when((Object)tab.headerTabs()).thenReturn((Object)Nil$.MODULE$);
            ThriftServerPage page = new ThriftServerPage(tab);
            String $org_scalatest_assert_macro_left = html = page.render(request).toString().toLowerCase(Locale.ROOT);
            String $org_scalatest_assert_macro_right = "session statistics (1)";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ThriftServerPageSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            String $org_scalatest_assert_macro_left2 = html;
            String $org_scalatest_assert_macro_right2 = "sql statistics (1)";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ThriftServerPageSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            String $org_scalatest_assert_macro_left3 = html;
            String $org_scalatest_assert_macro_right3 = "dummy query";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ThriftServerPageSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
            String $org_scalatest_assert_macro_left4 = html;
            String $org_scalatest_assert_macro_right4 = "dummy plan";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ThriftServerPageSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
            String $org_scalatest_assert_macro_left5 = html;
            String $org_scalatest_assert_macro_right5 = "<label>1 pages. jump to</label>";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.contains($org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ThriftServerPageSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
            String $org_scalatest_assert_macro_left6 = html;
            String $org_scalatest_assert_macro_right6 = "class=\"collapse-aggregated-sessionstat collapse-table\" onclick=\"collapsetable";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "contains", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.contains($org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ThriftServerPageSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        }, new Position("ThriftServerPageSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        this.test("thriftserver session page should load successfully", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String html;
            HiveThriftServer2AppStatusStore store = this.getStatusStore();
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getParameter("id")).thenReturn((Object)"sessionid");
            ThriftServerTab tab = (ThriftServerTab)Mockito.mock(ThriftServerTab.class, (Answer)Mockito.RETURNS_SMART_NULLS);
            Mockito.when((Object)tab.startTime()).thenReturn((Object)Calendar.getInstance().getTime());
            Mockito.when((Object)tab.store()).thenReturn((Object)store);
            Mockito.when((Object)tab.appName()).thenReturn((Object)"testing");
            Mockito.when((Object)tab.headerTabs()).thenReturn((Object)Nil$.MODULE$);
            ThriftServerSessionPage page = new ThriftServerSessionPage(tab);
            String $org_scalatest_assert_macro_left = html = page.render(request).toString().toLowerCase(Locale.ROOT);
            String $org_scalatest_assert_macro_right = "sql statistics";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ThriftServerPageSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
            String $org_scalatest_assert_macro_left2 = html;
            String $org_scalatest_assert_macro_right2 = "user";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ThriftServerPageSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
            String $org_scalatest_assert_macro_left3 = html;
            String $org_scalatest_assert_macro_right3 = "groupid";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ThriftServerPageSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
            String $org_scalatest_assert_macro_left4 = html;
            String $org_scalatest_assert_macro_right4 = "<label>1 pages. jump to</label>";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ThriftServerPageSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
            String $org_scalatest_assert_macro_left5 = html;
            String $org_scalatest_assert_macro_right5 = "collapse-aggregated-sqlsessionstat collapse-table\" onclick=\"collapsetable";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.contains($org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ThriftServerPageSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
        }, new Position("ThriftServerPageSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
    }
}

