/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.graphx.util;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.graphx.Edge;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.Graph$;
import org.apache.spark.graphx.util.PeriodicGraphCheckpointerSuite;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.CanEqual;
import org.scalactic.Equality;
import org.scalactic.Equivalence;
import org.scalactic.Prettifier;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEquals;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.Null$;

public final class PeriodicGraphCheckpointerSuite$
implements Assertions,
scala.Serializable {
    public static PeriodicGraphCheckpointerSuite$ MODULE$;
    private final StorageLevel defaultStorageLevel;
    private final Seq<Edge<Object>> edges;
    private final Assertion succeed;

    static {
        new PeriodicGraphCheckpointerSuite$();
    }

    public Throwable newAssertionFailedException(Option<String> optionalMessage, Option<Throwable> optionalCause, Position pos, IndexedSeq<String> analysis) {
        return Assertions.newAssertionFailedException$((Assertions)this, optionalMessage, optionalCause, (Position)pos, analysis);
    }

    public Throwable newTestCanceledException(Option<String> optionalMessage, Option<Throwable> optionalCause, Position pos) {
        return Assertions.newTestCanceledException$((Assertions)this, optionalMessage, optionalCause, (Position)pos);
    }

    public <T> T intercept(Function0<Object> f, ClassTag<T> classTag, Position pos) {
        return (T)Assertions.intercept$((Assertions)this, f, classTag, (Position)pos);
    }

    public <T> Assertion assertThrows(Function0<Object> f, ClassTag<T> classTag, Position pos) {
        return Assertions.assertThrows$((Assertions)this, f, classTag, (Position)pos);
    }

    public Assertion assertResult(Object expected, Object clue, Object actual, Prettifier prettifier, Position pos) {
        return Assertions.assertResult$((Assertions)this, (Object)expected, (Object)clue, (Object)actual, (Prettifier)prettifier, (Position)pos);
    }

    public Assertion assertResult(Object expected, Object actual, Prettifier prettifier, Position pos) {
        return Assertions.assertResult$((Assertions)this, (Object)expected, (Object)actual, (Prettifier)prettifier, (Position)pos);
    }

    public Nothing$ fail(Position pos) {
        return Assertions.fail$((Assertions)this, (Position)pos);
    }

    public Nothing$ fail(String message, Position pos) {
        return Assertions.fail$((Assertions)this, (String)message, (Position)pos);
    }

    public Nothing$ fail(String message, Throwable cause, Position pos) {
        return Assertions.fail$((Assertions)this, (String)message, (Throwable)cause, (Position)pos);
    }

    public Nothing$ fail(Throwable cause, Position pos) {
        return Assertions.fail$((Assertions)this, (Throwable)cause, (Position)pos);
    }

    public Nothing$ cancel(Position pos) {
        return Assertions.cancel$((Assertions)this, (Position)pos);
    }

    public Nothing$ cancel(String message, Position pos) {
        return Assertions.cancel$((Assertions)this, (String)message, (Position)pos);
    }

    public Nothing$ cancel(String message, Throwable cause, Position pos) {
        return Assertions.cancel$((Assertions)this, (String)message, (Throwable)cause, (Position)pos);
    }

    public Nothing$ cancel(Throwable cause, Position pos) {
        return Assertions.cancel$((Assertions)this, (Throwable)cause, (Position)pos);
    }

    public <T> T withClue(Object clue, Function0<T> fun) {
        return (T)Assertions.withClue$((Assertions)this, (Object)clue, fun);
    }

    public Assertion pending() {
        return Assertions.pending$((Assertions)this);
    }

    public Assertion pendingUntilFixed(Function0<BoxedUnit> f, Position pos) {
        return Assertions.pendingUntilFixed$((Assertions)this, f, (Position)pos);
    }

    public <T> TripleEqualsSupport.Equalizer<T> convertToEqualizer(T left) {
        return TripleEquals.convertToEqualizer$((TripleEquals)this, left);
    }

    public <T> TripleEqualsSupport.CheckingEqualizer<T> convertToCheckingEqualizer(T left) {
        return TripleEquals.convertToCheckingEqualizer$((TripleEquals)this, left);
    }

    public <A, B> CanEqual<A, B> unconstrainedEquality(Equality<A> equalityOfA) {
        return TripleEquals.unconstrainedEquality$((TripleEquals)this, equalityOfA);
    }

    public <A, B> CanEqual<A, B> lowPriorityTypeCheckedConstraint(Equivalence<B> equivalenceOfB, Predef$.less.colon.less<A, B> ev) {
        return TripleEquals.lowPriorityTypeCheckedConstraint$((TripleEquals)this, equivalenceOfB, ev);
    }

    public <A, B> CanEqual<A, B> convertEquivalenceToAToBConstraint(Equivalence<B> equivalenceOfB, Predef$.less.colon.less<A, B> ev) {
        return TripleEquals.convertEquivalenceToAToBConstraint$((TripleEquals)this, equivalenceOfB, ev);
    }

    public <A, B> CanEqual<A, B> typeCheckedConstraint(Equivalence<A> equivalenceOfA, Predef$.less.colon.less<B, A> ev) {
        return TripleEquals.typeCheckedConstraint$((TripleEquals)this, equivalenceOfA, ev);
    }

    public <A, B> CanEqual<A, B> convertEquivalenceToBToAConstraint(Equivalence<A> equivalenceOfA, Predef$.less.colon.less<B, A> ev) {
        return TripleEquals.convertEquivalenceToBToAConstraint$((TripleEquals)this, equivalenceOfA, ev);
    }

    public <A, B> CanEqual<A, B> lowPriorityConversionCheckedConstraint(Equivalence<B> equivalenceOfB, Function1<A, B> cnv) {
        return TripleEquals.lowPriorityConversionCheckedConstraint$((TripleEquals)this, equivalenceOfB, cnv);
    }

    public <A, B> CanEqual<A, B> convertEquivalenceToAToBConversionConstraint(Equivalence<B> equivalenceOfB, Function1<A, B> ev) {
        return TripleEquals.convertEquivalenceToAToBConversionConstraint$((TripleEquals)this, equivalenceOfB, ev);
    }

    public <A, B> CanEqual<A, B> conversionCheckedConstraint(Equivalence<A> equivalenceOfA, Function1<B, A> cnv) {
        return TripleEquals.conversionCheckedConstraint$((TripleEquals)this, equivalenceOfA, cnv);
    }

    public <A, B> CanEqual<A, B> convertEquivalenceToBToAConversionConstraint(Equivalence<A> equivalenceOfA, Function1<B, A> ev) {
        return TripleEquals.convertEquivalenceToBToAConversionConstraint$((TripleEquals)this, equivalenceOfA, ev);
    }

    public <A> Equality<A> defaultEquality() {
        return TripleEqualsSupport.defaultEquality$((TripleEqualsSupport)this);
    }

    public <T> TripleEqualsSupport.TripleEqualsInvocation<T> $eq$eq$eq(T right) {
        return TripleEqualsSupport.$eq$eq$eq$((TripleEqualsSupport)this, right);
    }

    public <T> TripleEqualsSupport.TripleEqualsInvocation<T> $bang$eq$eq(T right) {
        return TripleEqualsSupport.$bang$eq$eq$((TripleEqualsSupport)this, right);
    }

    public TripleEqualsSupport.TripleEqualsInvocation<Null$> $eq$eq$eq(Null$ right) {
        return TripleEqualsSupport.$eq$eq$eq$((TripleEqualsSupport)this, (Null$)right);
    }

    public TripleEqualsSupport.TripleEqualsInvocation<Null$> $bang$eq$eq(Null$ right) {
        return TripleEqualsSupport.$bang$eq$eq$((TripleEqualsSupport)this, (Null$)right);
    }

    public <T> TripleEqualsSupport.TripleEqualsInvocationOnSpread<T> $eq$eq$eq(TripleEqualsSupport.Spread<T> right) {
        return TripleEqualsSupport.$eq$eq$eq$((TripleEqualsSupport)this, right);
    }

    public <T> TripleEqualsSupport.TripleEqualsInvocationOnSpread<T> $bang$eq$eq(TripleEqualsSupport.Spread<T> right) {
        return TripleEqualsSupport.$bang$eq$eq$((TripleEqualsSupport)this, right);
    }

    public final Assertion succeed() {
        return this.succeed;
    }

    public final void org$scalatest$Assertions$_setter_$succeed_$eq(Assertion x$1) {
        this.succeed = x$1;
    }

    private StorageLevel defaultStorageLevel() {
        return this.defaultStorageLevel;
    }

    public Seq<Edge<Object>> edges() {
        return this.edges;
    }

    public Graph<Object, Object> createGraph(SparkContext sc) {
        return Graph$.MODULE$.fromEdges(sc.parallelize(this.edges(), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Edge.class)), (Object)BoxesRunTime.boxToDouble((double)0.0), this.defaultStorageLevel(), this.defaultStorageLevel(), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Double());
    }

    public void checkPersistence(Seq<PeriodicGraphCheckpointerSuite.GraphToCheck> graphs, int iteration) {
        graphs.foreach((Function1 & Serializable & scala.Serializable)g -> {
            PeriodicGraphCheckpointerSuite$.MODULE$.checkPersistence(g.graph(), g.gIndex(), iteration);
            return BoxedUnit.UNIT;
        });
    }

    public void checkPersistence(Graph<?, ?> graph, int gIndex, int iteration) {
        try {
            if (gIndex + 2 < iteration) {
                StorageLevel $org_scalatest_assert_macro_left = graph.vertices().getStorageLevel();
                StorageLevel $org_scalatest_assert_macro_right = StorageLevel$.MODULE$.NONE();
                StorageLevel storageLevel = $org_scalatest_assert_macro_left;
                StorageLevel storageLevel2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PeriodicGraphCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
                StorageLevel $org_scalatest_assert_macro_left2 = graph.edges().getStorageLevel();
                StorageLevel $org_scalatest_assert_macro_right2 = StorageLevel$.MODULE$.NONE();
                StorageLevel storageLevel3 = $org_scalatest_assert_macro_left2;
                StorageLevel storageLevel4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(storageLevel3 != null ? !storageLevel3.equals(storageLevel4) : storageLevel4 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PeriodicGraphCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
            } else {
                StorageLevel $org_scalatest_assert_macro_left = graph.vertices().getStorageLevel();
                StorageLevel $org_scalatest_assert_macro_right = this.defaultStorageLevel();
                StorageLevel storageLevel = $org_scalatest_assert_macro_left;
                StorageLevel storageLevel5 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(storageLevel != null ? !storageLevel.equals(storageLevel5) : storageLevel5 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PeriodicGraphCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
                StorageLevel $org_scalatest_assert_macro_left3 = graph.edges().getStorageLevel();
                StorageLevel $org_scalatest_assert_macro_right3 = this.defaultStorageLevel();
                StorageLevel storageLevel6 = $org_scalatest_assert_macro_left3;
                StorageLevel storageLevel7 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(storageLevel6 != null ? !storageLevel6.equals(storageLevel7) : storageLevel7 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PeriodicGraphCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
            }
        }
        catch (AssertionError assertionError) {
            throw new Exception(new StringBuilder(157).append("PeriodicGraphCheckpointerSuite.checkPersistence failed with:\n").append("\t gIndex = ").append(gIndex).append("\n").append("\t iteration = ").append(iteration).append("\n").append("\t graph.vertices.getStorageLevel = ").append(graph.vertices().getStorageLevel()).append("\n").append("\t graph.edges.getStorageLevel = ").append(graph.edges().getStorageLevel()).append("\n").toString());
        }
    }

    public void checkCheckpoint(Seq<PeriodicGraphCheckpointerSuite.GraphToCheck> graphs, int iteration, int checkpointInterval) {
        ((IterableLike)graphs.reverse()).foreach((Function1 & Serializable & scala.Serializable)g -> {
            PeriodicGraphCheckpointerSuite$.MODULE$.checkCheckpoint(g.graph(), g.gIndex(), iteration, checkpointInterval);
            return BoxedUnit.UNIT;
        });
    }

    public void confirmCheckpointRemoved(Graph<?, ?> graph) {
        Configuration hadoopConf = graph.vertices().sparkContext().hadoopConfiguration();
        graph.getCheckpointFiles().foreach((Function1 & Serializable & scala.Serializable)checkpointFile -> {
            Path path = new Path(checkpointFile);
            FileSystem fs = path.getFileSystem(hadoopConf);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(fs.exists(path), "fs.exists(path)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Graph checkpoint file should have been removed", Prettifier$.MODULE$.default(), new Position("PeriodicGraphCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
        });
    }

    public void checkCheckpoint(Graph<?, ?> graph, int gIndex, int iteration, int checkpointInterval) {
        try {
            if (gIndex % checkpointInterval == 0) {
                if (iteration - 2 * checkpointInterval < gIndex && gIndex <= iteration) {
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(graph.isCheckpointed(), "graph.isCheckpointed", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Graph should be checkpointed", Prettifier$.MODULE$.default(), new Position("PeriodicGraphCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
                    Seq $org_scalatest_assert_macro_left = graph.getCheckpointFiles();
                    int $org_scalatest_assert_macro_right = 2;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Graph should have 2 checkpoint files", Prettifier$.MODULE$.default(), new Position("PeriodicGraphCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
                } else {
                    this.confirmCheckpointRemoved(graph);
                }
            } else {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(graph.isCheckpointed(), "graph.isCheckpointed", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Graph should never have been checkpointed", Prettifier$.MODULE$.default(), new Position("PeriodicGraphCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
                Seq $org_scalatest_assert_macro_left = graph.getCheckpointFiles();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"Graph should not have any checkpoint files", Prettifier$.MODULE$.default(), new Position("PeriodicGraphCheckpointerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
            }
        }
        catch (AssertionError e) {
            throw new Exception(new StringBuilder(193).append("PeriodicGraphCheckpointerSuite.checkCheckpoint failed with:\n").append("\t gIndex = ").append(gIndex).append("\n").append("\t iteration = ").append(iteration).append("\n").append("\t checkpointInterval = ").append(checkpointInterval).append("\n").append("\t graph.isCheckpointed = ").append(graph.isCheckpointed()).append("\n").append("\t graph.getCheckpointFiles = ").append(graph.getCheckpointFiles().mkString(", ")).append("\n").append("  AssertionError message: ").append(((Throwable)((Object)e)).getMessage()).toString());
        }
    }

    private Object readResolve() {
        return MODULE$;
    }

    private PeriodicGraphCheckpointerSuite$() {
        MODULE$ = this;
        TripleEqualsSupport.$init$((TripleEqualsSupport)this);
        TripleEquals.$init$((TripleEquals)this);
        Assertions.$init$((Assertions)this);
        this.defaultStorageLevel = StorageLevel$.MODULE$.MEMORY_ONLY_SER();
        this.edges = (Seq)new .colon.colon((Object)new Edge.mcD.sp(0L, 1L, 0.0), (List)new .colon.colon((Object)new Edge.mcD.sp(1L, 2L, 0.0), (List)new .colon.colon((Object)new Edge.mcD.sp(2L, 3L, 0.0), (List)new .colon.colon((Object)new Edge.mcD.sp(3L, 4L, 0.0), (List)Nil$.MODULE$))));
    }
}

