/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.graphx;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.graphx.Edge;
import org.apache.spark.graphx.EdgeRDD$;
import org.apache.spark.graphx.LocalSparkContext;
import org.apache.spark.graphx.impl.EdgeRDDImpl;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001a1AAA\u0002\u0001\u0019!)Q\u0003\u0001C\u0001-\taQ\tZ4f%\u0012#5+^5uK*\u0011A!B\u0001\u0007OJ\f\u0007\u000f\u001b=\u000b\u0005\u00199\u0011!B:qCJ\\'B\u0001\u0005\n\u0003\u0019\t\u0007/Y2iK*\t!\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001bE\u0001\"AD\b\u000e\u0003\u0015I!\u0001E\u0003\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t\u00112#D\u0001\u0004\u0013\t!2AA\tM_\u000e\fGn\u00159be.\u001cuN\u001c;fqR\fa\u0001P5oSRtD#A\f\u0011\u0005I\u0001\u0001")
public class EdgeRDDSuite
extends SparkFunSuite
implements LocalSparkContext {
    @Override
    public <T> T withSpark(Function1<SparkContext, T> f) {
        return (T)LocalSparkContext.withSpark$(this, f);
    }

    public EdgeRDDSuite() {
        LocalSparkContext.$init$(this);
        this.test("cache, getStorageLevel", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (Assertion)this.withSpark((Function1 & Serializable & scala.Serializable)sc -> {
            RDD verts = sc.parallelize((Seq)new .colon.colon((Object)new Tuple2.mcJI.sp(0L, 0), (List)new .colon.colon((Object)new Tuple2.mcJI.sp(1L, 1), (List)new .colon.colon((Object)new Tuple2.mcJI.sp(1L, 2), (List)new .colon.colon((Object)new Tuple2.mcJI.sp(2L, 3), (List)new .colon.colon((Object)new Tuple2.mcJI.sp(2L, 3), (List)new .colon.colon((Object)new Tuple2.mcJI.sp(2L, 3), (List)Nil$.MODULE$)))))), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
            EdgeRDDImpl edges = EdgeRDD$.MODULE$.fromEdges(sc.parallelize((Seq)List$.MODULE$.empty(), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Edge.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Nothing());
            StorageLevel $org_scalatest_assert_macro_left = edges.getStorageLevel();
            StorageLevel $org_scalatest_assert_macro_right = StorageLevel$.MODULE$.NONE();
            StorageLevel storageLevel = $org_scalatest_assert_macro_left;
            StorageLevel storageLevel2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("EdgeRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 31));
            edges.cache();
            StorageLevel $org_scalatest_assert_macro_left2 = edges.getStorageLevel();
            StorageLevel $org_scalatest_assert_macro_right2 = StorageLevel$.MODULE$.MEMORY_ONLY();
            StorageLevel storageLevel3 = $org_scalatest_assert_macro_left2;
            StorageLevel storageLevel4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(storageLevel3 != null ? !storageLevel3.equals(storageLevel4) : storageLevel4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("EdgeRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 33));
        }), new Position("EdgeRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 26));
        this.test("checkpointing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (Assertion)this.withSpark((Function1 & Serializable & scala.Serializable)sc -> {
            RDD verts = sc.parallelize((Seq)new .colon.colon((Object)new Tuple2.mcJI.sp(0L, 0), (List)new .colon.colon((Object)new Tuple2.mcJI.sp(1L, 1), (List)new .colon.colon((Object)new Tuple2.mcJI.sp(1L, 2), (List)new .colon.colon((Object)new Tuple2.mcJI.sp(2L, 3), (List)new .colon.colon((Object)new Tuple2.mcJI.sp(2L, 3), (List)new .colon.colon((Object)new Tuple2.mcJI.sp(2L, 3), (List)Nil$.MODULE$)))))), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
            EdgeRDDImpl edges = EdgeRDD$.MODULE$.fromEdges(sc.parallelize((Seq)List$.MODULE$.empty(), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Edge.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Nothing());
            sc.setCheckpointDir(Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getCanonicalPath());
            edges.checkpoint();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(edges.isCheckpointed(), "edges.isCheckpointed", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("EdgeRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(edges.isCheckpointedAndMaterialized(), "edges.isCheckpointedAndMaterialized", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("EdgeRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(edges.partitionsRDD().isCheckpointed(), "edges.partitionsRDD.isCheckpointed", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("EdgeRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(edges.partitionsRDD().isCheckpointedAndMaterialized(), "edges.partitionsRDD.isCheckpointedAndMaterialized", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("EdgeRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
            Seq data = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])edges.collect())).toSeq();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(edges.isCheckpointed(), "edges.isCheckpointed", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("EdgeRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(edges.isCheckpointedAndMaterialized(), "edges.isCheckpointedAndMaterialized", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("EdgeRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(edges.partitionsRDD().isCheckpointed(), "edges.partitionsRDD.isCheckpointed", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("EdgeRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(edges.partitionsRDD().isCheckpointedAndMaterialized(), "edges.partitionsRDD.isCheckpointedAndMaterialized", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("EdgeRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])edges.collect())).toSeq());
            Seq $org_scalatest_assert_macro_right = data;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("EdgeRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
        }), new Position("EdgeRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
        this.test("count", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (Assertion)this.withSpark((Function1 & Serializable & scala.Serializable)sc -> {
            EdgeRDDImpl empty = EdgeRDD$.MODULE$.fromEdges(sc.emptyRDD(ClassTag$.MODULE$.apply(Edge.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Nothing());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)empty.count()));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("EdgeRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
            .colon.colon edges = new .colon.colon((Object)new Edge(0L, 1L, (Object)BoxedUnit.UNIT), (List)new .colon.colon((Object)new Edge(1L, 2L, (Object)BoxedUnit.UNIT), (List)new .colon.colon((Object)new Edge(2L, 0L, (Object)BoxedUnit.UNIT), (List)Nil$.MODULE$)));
            EdgeRDDImpl nonempty = EdgeRDD$.MODULE$.fromEdges(sc.parallelize((Seq)edges, sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Edge.class)), ClassTag$.MODULE$.Unit(), ClassTag$.MODULE$.Nothing());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)nonempty.count()));
            int $org_scalatest_assert_macro_right2 = edges.size();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("EdgeRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        }), new Position("EdgeRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
    }
}

