/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.graphx.util;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.graphx.Edge;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.Graph$;
import org.apache.spark.graphx.util.PeriodicGraphCheckpointerSuite;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class PeriodicGraphCheckpointerSuite$
implements scala.Serializable {
    public static PeriodicGraphCheckpointerSuite$ MODULE$;
    private final StorageLevel defaultStorageLevel;
    private final Seq<Edge<Object>> edges;

    static {
        new PeriodicGraphCheckpointerSuite$();
    }

    private StorageLevel defaultStorageLevel() {
        return this.defaultStorageLevel;
    }

    public Seq<Edge<Object>> edges() {
        return this.edges;
    }

    public Graph<Object, Object> createGraph(SparkContext sc) {
        return Graph$.MODULE$.fromEdges(sc.parallelize(this.edges(), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Edge.class)), (Object)BoxesRunTime.boxToDouble((double)0.0), this.defaultStorageLevel(), this.defaultStorageLevel(), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Double());
    }

    public void checkPersistence(Seq<PeriodicGraphCheckpointerSuite.GraphToCheck> graphs, int iteration) {
        graphs.foreach((Function1 & Serializable & scala.Serializable)g -> {
            PeriodicGraphCheckpointerSuite$.MODULE$.checkPersistence(g.graph(), g.gIndex(), iteration);
            return BoxedUnit.UNIT;
        });
    }

    public void checkPersistence(Graph<?, ?> graph, int gIndex, int iteration) {
        try {
            if (gIndex + 2 < iteration) {
                StorageLevel storageLevel = graph.vertices().getStorageLevel();
                StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
                Predef$.MODULE$.assert(!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null));
                StorageLevel storageLevel3 = graph.edges().getStorageLevel();
                StorageLevel storageLevel4 = StorageLevel$.MODULE$.NONE();
                Predef$.MODULE$.assert(!(storageLevel3 != null ? !storageLevel3.equals(storageLevel4) : storageLevel4 != null));
            } else {
                StorageLevel storageLevel = graph.vertices().getStorageLevel();
                StorageLevel storageLevel5 = this.defaultStorageLevel();
                Predef$.MODULE$.assert(!(storageLevel != null ? !storageLevel.equals(storageLevel5) : storageLevel5 != null));
                StorageLevel storageLevel6 = graph.edges().getStorageLevel();
                StorageLevel storageLevel7 = this.defaultStorageLevel();
                Predef$.MODULE$.assert(!(storageLevel6 != null ? !storageLevel6.equals(storageLevel7) : storageLevel7 != null));
            }
        }
        catch (AssertionError assertionError) {
            throw new Exception(new StringBuilder(157).append("PeriodicGraphCheckpointerSuite.checkPersistence failed with:\n").append("\t gIndex = ").append(gIndex).append("\n").append("\t iteration = ").append(iteration).append("\n").append("\t graph.vertices.getStorageLevel = ").append(graph.vertices().getStorageLevel()).append("\n").append("\t graph.edges.getStorageLevel = ").append(graph.edges().getStorageLevel()).append("\n").toString());
        }
    }

    public void checkCheckpoint(Seq<PeriodicGraphCheckpointerSuite.GraphToCheck> graphs, int iteration, int checkpointInterval) {
        ((IterableLike)graphs.reverse()).foreach((Function1 & Serializable & scala.Serializable)g -> {
            PeriodicGraphCheckpointerSuite$.MODULE$.checkCheckpoint(g.graph(), g.gIndex(), iteration, checkpointInterval);
            return BoxedUnit.UNIT;
        });
    }

    public void confirmCheckpointRemoved(Graph<?, ?> graph) {
        Configuration hadoopConf = graph.vertices().sparkContext().hadoopConfiguration();
        graph.getCheckpointFiles().foreach((Function1 & Serializable & scala.Serializable)checkpointFile -> {
            PeriodicGraphCheckpointerSuite$.$anonfun$confirmCheckpointRemoved$1(hadoopConf, checkpointFile);
            return BoxedUnit.UNIT;
        });
    }

    public void checkCheckpoint(Graph<?, ?> graph, int gIndex, int iteration, int checkpointInterval) {
        try {
            if (gIndex % checkpointInterval == 0) {
                if (iteration - 2 * checkpointInterval < gIndex && gIndex <= iteration) {
                    Predef$.MODULE$.assert(graph.isCheckpointed(), (Function0 & Serializable & scala.Serializable)() -> "Graph should be checkpointed");
                    Predef$.MODULE$.assert(graph.getCheckpointFiles().length() == 2, (Function0 & Serializable & scala.Serializable)() -> "Graph should have 2 checkpoint files");
                } else {
                    this.confirmCheckpointRemoved(graph);
                }
            } else {
                Predef$.MODULE$.assert(!graph.isCheckpointed(), (Function0 & Serializable & scala.Serializable)() -> "Graph should never have been checkpointed");
                Predef$.MODULE$.assert(graph.getCheckpointFiles().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Graph should not have any checkpoint files");
            }
        }
        catch (AssertionError e) {
            throw new Exception(new StringBuilder(193).append("PeriodicGraphCheckpointerSuite.checkCheckpoint failed with:\n").append("\t gIndex = ").append(gIndex).append("\n").append("\t iteration = ").append(iteration).append("\n").append("\t checkpointInterval = ").append(checkpointInterval).append("\n").append("\t graph.isCheckpointed = ").append(graph.isCheckpointed()).append("\n").append("\t graph.getCheckpointFiles = ").append(graph.getCheckpointFiles().mkString(", ")).append("\n").append("  AssertionError message: ").append(((Throwable)((Object)e)).getMessage()).toString());
        }
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$confirmCheckpointRemoved$1(Configuration hadoopConf$1, String checkpointFile) {
        Path path = new Path(checkpointFile);
        FileSystem fs = path.getFileSystem(hadoopConf$1);
        Predef$.MODULE$.assert(!fs.exists(path), (Function0 & Serializable & scala.Serializable)() -> "Graph checkpoint file should have been removed");
    }

    private PeriodicGraphCheckpointerSuite$() {
        MODULE$ = this;
        this.defaultStorageLevel = StorageLevel$.MODULE$.MEMORY_ONLY_SER();
        this.edges = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Edge[]{new Edge.mcD.sp(0L, 1L, 0.0), new Edge.mcD.sp(1L, 2L, 0.0), new Edge.mcD.sp(2L, 3L, 0.0), new Edge.mcD.sp(3L, 4L, 0.0)}));
    }
}

