/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.utils;

import com.google.protobuf.Any;
import io.grpc.protobuf.StatusProto;
import io.grpc.stub.StreamObserver;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.SparkThrowable;
import org.apache.spark.api.python.PythonException;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connect.config.Connect$;
import org.apache.spark.sql.connect.service.ExecuteEventsManager;
import org.apache.spark.sql.connect.service.SparkConnectService$;
import org.apache.spark.sql.internal.SQLConf$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import org.json4s.jackson.JsonMethods$;
import org.slf4j.Logger;
import org.sparkproject.connect.google_protos.rpc.ErrorInfo;
import org.sparkproject.connect.google_protos.rpc.Status;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.util.control.NonFatal$;

public final class ErrorUtils$
implements Logging {
    public static ErrorUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ErrorUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Seq<Class<?>> allClasses(Class<?> cl) {
        ArrayBuffer classes = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        if (cl != null && !cl.equals(Object.class)) {
            classes.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{cl}));
        }
        this.appendSuperClasses$1(cl, classes);
        return classes.toSeq();
    }

    public Status org$apache$spark$sql$connect$utils$ErrorUtils$$buildStatusFromThrowable(Throwable st, boolean stackTraceEnabled) {
        ErrorInfo.Builder builder;
        LazyRef stackTrace$lzy = new LazyRef();
        JsonAST.JArray x$12 = JsonDSL$.MODULE$.seq2jvalue((Iterable)this.allClasses(st.getClass()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getName(), Seq$.MODULE$.canBuildFrom()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x));
        Formats x$2 = JsonMethods$.MODULE$.render$default$2((JsonAST.JValue)x$12);
        ErrorInfo.Builder errorInfo = ErrorInfo.newBuilder().setReason(st.getClass().getName()).setDomain("org.apache.spark").putMetadata("classes", JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)x$12, x$2)));
        if (stackTraceEnabled && ErrorUtils$.stackTrace$1(stackTrace$lzy, st).nonEmpty()) {
            int maxSize = BoxesRunTime.unboxToInt((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_JVM_STACK_TRACE_MAX_SIZE()));
            builder = errorInfo.putMetadata("stackTrace", StringUtils.abbreviate((String)((String)ErrorUtils$.stackTrace$1(stackTrace$lzy, st).get()), (int)maxSize));
        } else {
            builder = errorInfo;
        }
        ErrorInfo.Builder withStackTrace = builder;
        return Status.newBuilder().setCode(13).addDetails(Any.pack(withStackTrace.build())).setMessage(SparkConnectService$.MODULE$.extractErrorMessage(st)).build();
    }

    public boolean org$apache$spark$sql$connect$utils$ErrorUtils$$isPythonExecutionException(SparkException se) {
        return se.getCause() != null && se.getCause() instanceof PythonException && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])se.getCause().getStackTrace())).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ErrorUtils$.$anonfun$isPythonExecutionException$1(x$2)));
    }

    public <V> PartialFunction<Throwable, BoxedUnit> handleError(String opType, StreamObserver<V> observer, String userId, String sessionId, Option<ExecuteEventsManager> events, boolean isInterrupted) {
        SparkSession session = SparkConnectService$.MODULE$.getOrCreateIsolatedSession(userId, sessionId).session();
        boolean stackTraceEnabled = BoxesRunTime.unboxToBoolean((Object)session.conf().get(SQLConf$.MODULE$.PYSPARK_JVM_STACKTRACE_ENABLED()));
        scala.Serializable partial = new scala.Serializable(stackTraceEnabled){
            public static final long serialVersionUID = 0L;
            private final boolean stackTraceEnabled$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1;
                SparkException sparkException;
                A1 A12 = x1;
                if (A12 instanceof SparkException && ErrorUtils$.MODULE$.org$apache$spark$sql$connect$utils$ErrorUtils$$isPythonExecutionException(sparkException = (SparkException)A12)) {
                    return (B1)new Tuple2((Object)sparkException, (Object)StatusProto.toStatusRuntimeException(ErrorUtils$.MODULE$.org$apache$spark$sql$connect$utils$ErrorUtils$$buildStatusFromThrowable(sparkException.getCause(), this.stackTraceEnabled$1)));
                }
                if (A12 != null && ((A1 = A12) instanceof SparkThrowable || NonFatal$.MODULE$.apply(A1))) {
                    return (B1)new Tuple2(A1, (Object)StatusProto.toStatusRuntimeException(ErrorUtils$.MODULE$.org$apache$spark$sql$connect$utils$ErrorUtils$$buildStatusFromThrowable(A1, this.stackTraceEnabled$1)));
                }
                if (A12 != null) {
                    A1 A13 = A12;
                    return (B1)new Tuple2(A13, (Object)io.grpc.Status.UNKNOWN.withCause(A13).withDescription(StringUtils.abbreviate((String)A13.getMessage(), (int)2048)).asRuntimeException());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable;
                SparkException sparkException;
                Throwable throwable2 = x1;
                if (throwable2 instanceof SparkException && ErrorUtils$.MODULE$.org$apache$spark$sql$connect$utils$ErrorUtils$$isPythonExecutionException(sparkException = (SparkException)throwable2)) {
                    return true;
                }
                if (throwable2 != null && ((throwable = throwable2) instanceof SparkThrowable || NonFatal$.MODULE$.apply(throwable))) {
                    return true;
                }
                return throwable2 != null;
            }
            {
                this.stackTraceEnabled$1 = stackTraceEnabled$1;
            }
        };
        return partial.andThen((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ErrorUtils$.$anonfun$handleError$1(events, opType, userId, sessionId, isInterrupted, observer, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public <V> Option<ExecuteEventsManager> handleError$default$5() {
        return None$.MODULE$;
    }

    public <V> boolean handleError$default$6() {
        return false;
    }

    private final void appendSuperClasses$1(Class clazz, ArrayBuffer classes$1) {
        while (clazz != null && !clazz.equals(Object.class)) {
            classes$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{clazz.getSuperclass()}));
            clazz = clazz.getSuperclass();
        }
        return;
    }

    private static final /* synthetic */ Option stackTrace$lzycompute$1(LazyRef stackTrace$lzy$1, Throwable st$1) {
        Option option;
        LazyRef lazyRef = stackTrace$lzy$1;
        synchronized (lazyRef) {
            option = stackTrace$lzy$1.initialized() ? (Option)stackTrace$lzy$1.value() : (Option)stackTrace$lzy$1.initialize((Object)Option$.MODULE$.apply((Object)ExceptionUtils.getStackTrace((Throwable)st$1)));
        }
        return option;
    }

    private static final Option stackTrace$1(LazyRef stackTrace$lzy$1, Throwable st$1) {
        if (stackTrace$lzy$1.initialized()) {
            return (Option)stackTrace$lzy$1.value();
        }
        return ErrorUtils$.stackTrace$lzycompute$1(stackTrace$lzy$1, st$1);
    }

    public static final /* synthetic */ boolean $anonfun$isPythonExecutionException$1(StackTraceElement x$2) {
        return x$2.toString().contains("org.apache.spark.sql.execution.python");
    }

    public static final /* synthetic */ void $anonfun$handleError$4(boolean isInterrupted$1, Throwable wrapped$1, ExecuteEventsManager executeEventsManager) {
        if (isInterrupted$1) {
            executeEventsManager.postCanceled();
            return;
        }
        executeEventsManager.postFailed(wrapped$1.getMessage());
    }

    public static final /* synthetic */ void $anonfun$handleError$1(Option events$1, String opType$1, String userId$1, String sessionId$1, boolean isInterrupted$1, StreamObserver observer$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Throwable original = (Throwable)tuple2._1();
            Throwable wrapped = (Throwable)tuple2._2();
            if (events$1.isDefined()) {
                MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Spark Connect error ").append("during: ").append(opType$1).append(". UserId: ").append(userId$1).append(". SessionId: ").append(sessionId$1).append(".").toString(), original);
            } else {
                MODULE$.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Spark Connect RPC error ").append("during: ").append(opType$1).append(". UserId: ").append(userId$1).append(". SessionId: ").append(sessionId$1).append(".").toString(), original);
            }
            events$1.foreach((Function1 & Serializable & scala.Serializable)executeEventsManager -> {
                ErrorUtils$.$anonfun$handleError$4(isInterrupted$1, wrapped, executeEventsManager);
                return BoxedUnit.UNIT;
            });
            observer$1.onError(wrapped);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private ErrorUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

