/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.service;

import com.google.common.io.CountingOutputStream;
import io.grpc.stub.StreamObserver;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import org.apache.spark.connect.proto.AddArtifactsRequest;
import org.apache.spark.connect.proto.AddArtifactsResponse;
import org.apache.spark.sql.connect.artifact.SparkConnectArtifactManager$;
import org.apache.spark.sql.connect.artifact.util.ArtifactUtils$;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.sql.connect.service.SparkConnectService$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\teh\u0001\u0002%J\u0001YC\u0001\u0002\u001d\u0001\u0003\u0006\u0004%\t!\u001d\u0005\tm\u0002\u0011\t\u0011)A\u0005e\")q\u000f\u0001C\u0001q\"9A\u0010\u0001b\u0001\n#i\bbBA\u0007\u0001\u0001\u0006IA \u0005\n\u0003\u001f\u0001!\u0019!C\t\u0003#A\u0001B!\u0013\u0001A\u0003%\u00111\u0003\u0005\f\u0005\u0017\u0002\u0001\u0019!a\u0001\n\u0013\u0011i\u0005C\u0006\u0003\u0012\u0002\u0001\r\u00111A\u0005\n\tM\u0005b\u0003BL\u0001\u0001\u0007\t\u0011)Q\u0005\u0005\u001fB1B!'\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003\u001c\"Y!1\u0015\u0001A\u0002\u0003\u0007I\u0011\u0002BS\u0011-\u0011I\u000b\u0001a\u0001\u0002\u0003\u0006KA!(\t\u000f\t-\u0006\u0001\"\u0011\u0003.\"9!1\u0017\u0001\u0005B\tU\u0006b\u0002Bg\u0001\u0011E!q\u001a\u0005\b\u0005+\u0004A\u0011\u0003Bl\u0011\u001d\u0011y\u000e\u0001C\t\u0005\u0007BqA!9\u0001\t\u0003\u0012\u0019\u0005C\u0004\u0003d\u0002!IA!:\t\u000f\t\r\b\u0001\"\u0003\u0003p\u001a1\u00111\u0006\u0001\u0001\u0003[A!\"a\u000e\u0017\u0005\u000b\u0007I\u0011AA\u001d\u0011)\t\tF\u0006B\u0001B\u0003%\u00111\b\u0005\u0007oZ!\t!a\u0015\t\u0019\u0005]c\u0003%A\u0001\u0004\u0003\u0006I!!\u0017\t\u0013\u0005%dC1A\u0005\u0002\u0005e\u0002\u0002CA6-\u0001\u0006I!a\u000f\t\u0013\u00055dC1A\u0005\u0002\u0005=\u0004\u0002CA:-\u0001\u0006I!!\u001d\t\u0011\u0005UdC1A\u0005\u0002uDq!a\u001e\u0017A\u0003%a\u0010\u0003\u0005\u0002zY\u0011\r\u0011\"\u0001~\u0011\u001d\tYH\u0006Q\u0001\nyD\u0011\"! \u0017\u0005\u0004%I!a \t\u0011\u0005-e\u0003)A\u0005\u0003\u0003C\u0011\"!$\u0017\u0005\u0004%I!a$\t\u0011\u0005\u001df\u0003)A\u0005\u0003#C\u0011\"!+\u0017\u0005\u0004%I!a+\t\u0011\u0005uf\u0003)A\u0005\u0003[C\u0011\"a0\u0017\u0005\u0004%I!!1\t\u0011\u00055h\u0003)A\u0005\u0003\u0007D1\"a<\u0017\u0001\u0004\u0005\r\u0011\"\u0003\u0002r\"Y\u0011\u0011 \fA\u0002\u0003\u0007I\u0011BA~\u0011-\u0011)A\u0006a\u0001\u0002\u0003\u0006K!a=\t\u0017\t\u001da\u00031AA\u0002\u0013E!\u0011\u0002\u0005\f\u0005#1\u0002\u0019!a\u0001\n#\u0011\u0019\u0002C\u0006\u0003\u0018Y\u0001\r\u0011!Q!\n\t-\u0001b\u0002B\r-\u0011E!1\u0004\u0005\b\u0005C1B\u0011\u0001B\u0012\u0011\u001d\u00119C\u0006C\u0001\u0005SAqA!\u0011\u0017\t\u0003\u0011\u0019\u0005C\u0004\u0003FY!\tAa\u0012\u0007\r\tE\u0003\u0001\u0001B*\u0011-\t9D\u000eB\u0001B\u0003%\u00111H\f\t\u0015\tUcG!A!\u0002\u0013\u00119\u0006\u0003\u0006\u0003^Y\u0012\t\u0011)A\u0005\u0005/Baa\u001e\u001c\u0005\u0002\t}\u0003\"\u0003B4m\u0001\u0007I\u0011\u0002B5\u0011%\u0011YG\u000ea\u0001\n\u0013\u0011i\u0007\u0003\u0005\u0003rY\u0002\u000b\u0015\u0002B,\u0011%\u0011\u0019H\u000ea\u0001\n\u0013\u0011I\u0007C\u0005\u0003vY\u0002\r\u0011\"\u0003\u0003x!A!1\u0010\u001c!B\u0013\u00119\u0006C\u0005\u0003~Y\u0002\r\u0011\"\u0003\u0003\n!I!q\u0010\u001cA\u0002\u0013%!\u0011\u0011\u0005\t\u0005\u000b3\u0004\u0015)\u0003\u0003\f!9!q\u0011\u001c\u0005\u0002\t%\u0001b\u0002B\rm\u0011E#\u0011\u0012\u0005\b\u0005O1D\u0011\tBG\u0011\u001d\u0011\tE\u000eC!\u0005\u0007\u0012qd\u00159be.\u001cuN\u001c8fGR\fE\rZ!si&4\u0017m\u0019;t\u0011\u0006tG\r\\3s\u0015\tQ5*A\u0004tKJ4\u0018nY3\u000b\u00051k\u0015aB2p]:,7\r\u001e\u0006\u0003\u001d>\u000b1a]9m\u0015\t\u0001\u0016+A\u0003ta\u0006\u00148N\u0003\u0002S'\u00061\u0011\r]1dQ\u0016T\u0011\u0001V\u0001\u0004_J<7\u0001A\n\u0004\u0001]{\u0006C\u0001-^\u001b\u0005I&B\u0001.\\\u0003\u0011a\u0017M\\4\u000b\u0003q\u000bAA[1wC&\u0011a,\u0017\u0002\u0007\u001f\nTWm\u0019;\u0011\u0007\u0001<\u0017.D\u0001b\u0015\t\u00117-\u0001\u0003tiV\u0014'B\u00013f\u0003\u00119'\u000f]2\u000b\u0003\u0019\f!![8\n\u0005!\f'AD*ue\u0016\fWn\u00142tKJ4XM\u001d\t\u0003U:l\u0011a\u001b\u0006\u0003Y6\fQ\u0001\u001d:pi>T!\u0001T(\n\u0005=\\'aE!eI\u0006\u0013H/\u001b4bGR\u001c(+Z9vKN$\u0018\u0001\u0005:fgB|gn]3PEN,'O^3s+\u0005\u0011\bc\u00011hgB\u0011!\u000e^\u0005\u0003k.\u0014A#\u00113e\u0003J$\u0018NZ1diN\u0014Vm\u001d9p]N,\u0017!\u0005:fgB|gn]3PEN,'O^3sA\u00051A(\u001b8jiz\"\"!_>\u0011\u0005i\u0004Q\"A%\t\u000bA\u001c\u0001\u0019\u0001:\u0002\u0015M$\u0018mZ5oO\u0012K'/F\u0001\u007f!\ry\u0018\u0011B\u0007\u0003\u0003\u0003QA!a\u0001\u0002\u0006\u0005!a-\u001b7f\u0015\r\t9aW\u0001\u0004]&|\u0017\u0002BA\u0006\u0003\u0003\u0011A\u0001U1uQ\u0006Y1\u000f^1hS:<G)\u001b:!\u0003=\u0019H/Y4fI\u0006\u0013H/\u001b4bGR\u001cXCAA\n!\u0019\t)\"a\t\u0002(5\u0011\u0011q\u0003\u0006\u0005\u00033\tY\"A\u0004nkR\f'\r\\3\u000b\t\u0005u\u0011qD\u0001\u000bG>dG.Z2uS>t'BAA\u0011\u0003\u0015\u00198-\u00197b\u0013\u0011\t)#a\u0006\u0003\r\t+hMZ3s!\r\tICF\u0007\u0002\u0001\tq1\u000b^1hK\u0012\f%\u000f^5gC\u000e$8c\u0001\f\u00020A!\u0011\u0011GA\u001a\u001b\t\ty\"\u0003\u0003\u00026\u0005}!AB!osJ+g-\u0001\u0003oC6,WCAA\u001e!\u0011\ti$a\u0013\u000f\t\u0005}\u0012q\t\t\u0005\u0003\u0003\ny\"\u0004\u0002\u0002D)\u0019\u0011QI+\u0002\rq\u0012xn\u001c;?\u0013\u0011\tI%a\b\u0002\rA\u0013X\rZ3g\u0013\u0011\ti%a\u0014\u0003\rM#(/\u001b8h\u0015\u0011\tI%a\b\u0002\u000b9\fW.\u001a\u0011\u0015\t\u0005\u001d\u0012Q\u000b\u0005\b\u0003oI\u0002\u0019AA\u001e\u0003\rAH%\r\t\t\u0003c\tY&a\u0018\u0002d%!\u0011QLA\u0010\u0005\u0019!V\u000f\u001d7feA\u0019\u0001,!\u0019\n\u0007\u00055\u0013\f\u0005\u0004\u00022\u0005\u0015\u0014qL\u0005\u0005\u0003O\nyB\u0001\u0004PaRLwN\\\u0001\u0012G\u0006twN\\5dC24\u0015\u000e\\3OC6,\u0017AE2b]>t\u0017nY1m\r&dWMT1nK\u0002\n\u0001B\u001a:bO6,g\u000e^\u000b\u0003\u0003c\u0002b!!\r\u0002f\u0005m\u0012!\u00034sC\u001elWM\u001c;!\u0003\u0011\u0001\u0018\r\u001e5\u0002\u000bA\fG\u000f\u001b\u0011\u0002\u0015M$\u0018mZ3e!\u0006$\b.A\u0006ti\u0006<W\r\u001a)bi\"\u0004\u0013a\u00024jY\u0016|U\u000f^\u000b\u0003\u0003\u0003\u0003B!a!\u0002\b6\u0011\u0011Q\u0011\u0006\u0003MnKA!!#\u0002\u0006\naq*\u001e;qkR\u001cFO]3b[\u0006Aa-\u001b7f\u001fV$\b%A\u0006d_VtG/\u001b8h\u001fV$XCAAI!\u0011\t\u0019*a)\u000e\u0005\u0005U%b\u00014\u0002\u0018*!\u0011\u0011TAN\u0003\u0019\u0019w.\\7p]*!\u0011QTAP\u0003\u00199wn\\4mK*\u0011\u0011\u0011U\u0001\u0004G>l\u0017\u0002BAS\u0003+\u0013AcQ8v]RLgnZ(viB,Ho\u0015;sK\u0006l\u0017\u0001D2pk:$\u0018N\\4PkR\u0004\u0013aC2iK\u000e\\7/^7PkR,\"!!,\u0011\t\u0005=\u0016\u0011X\u0007\u0003\u0003cSA!a-\u00026\u0006\u0019!0\u001b9\u000b\u0007\u0005]6,\u0001\u0003vi&d\u0017\u0002BA^\u0003c\u00131c\u00115fG.,GmT;uaV$8\u000b\u001e:fC6\fAb\u00195fG.\u001cX/\\(vi\u0002\nqAY;jY\u0012,'/\u0006\u0002\u0002DB!\u0011QYAt\u001d\u0011\t9-!9\u000f\t\u0005%\u0017Q\u001c\b\u0005\u0003\u0017\fYN\u0004\u0003\u0002N\u0006eg\u0002BAh\u0003/tA!!5\u0002V:!\u0011\u0011IAj\u0013\u0005!\u0016B\u0001*T\u0013\t\u0001\u0016+\u0003\u0002M\u001f&\u0011A.\\\u0005\u0004\u0003?\\\u0017\u0001F!eI\u0006\u0013H/\u001b4bGR\u001c(+Z:q_:\u001cX-\u0003\u0003\u0002d\u0006\u0015\u0018aD!si&4\u0017m\u0019;Tk6l\u0017M]=\u000b\u0007\u0005}7.\u0003\u0003\u0002j\u0006-(a\u0002\"vS2$WM\u001d\u0006\u0005\u0003G\f)/\u0001\u0005ck&dG-\u001a:!\u0003=\t'\u000f^5gC\u000e$8+^7nCJLXCAAz!\u0011\t9-!>\n\t\u0005]\u0018Q\u001d\u0002\u0010\u0003J$\u0018NZ1diN+X.\\1ss\u0006\u0019\u0012M\u001d;jM\u0006\u001cGoU;n[\u0006\u0014\u0018p\u0018\u0013fcR!\u0011Q B\u0002!\u0011\t\t$a@\n\t\t\u0005\u0011q\u0004\u0002\u0005+:LG\u000fC\u0005\u0002X1\n\t\u00111\u0001\u0002t\u0006\u0001\u0012M\u001d;jM\u0006\u001cGoU;n[\u0006\u0014\u0018\u0010I\u0001\rSN\u001c%oY*vG\u000e,7o]\u000b\u0003\u0005\u0017\u0001B!!\r\u0003\u000e%!!qBA\u0010\u0005\u001d\u0011un\u001c7fC:\f\u0001#[:De\u000e\u001cVoY2fgN|F%Z9\u0015\t\u0005u(Q\u0003\u0005\n\u0003/z\u0013\u0011!a\u0001\u0005\u0017\tQ\"[:De\u000e\u001cVoY2fgN\u0004\u0013!C;qI\u0006$Xm\u0011:d)\u0011\tiP!\b\t\u000f\t}\u0011\u00071\u0001\u0003\f\u0005I\u0011n]*vG\u000e,7o]\u0001\rO\u0016$8I]2Ti\u0006$Xo]\u000b\u0003\u0005K\u0001b!!\r\u0002f\t-\u0011!B<sSR,G\u0003BA\u007f\u0005WAqA!\f4\u0001\u0004\u0011y#A\u0005eCR\f7\t[;oWB!!\u0011\u0007B\u001e\u001d\u0011\u0011\u0019Da\u000e\u000f\t\tU\u00121\\\u0007\u0002[&\u0019!\u0011H6\u0002'\u0005#G-\u0011:uS\u001a\f7\r^:SKF,Xm\u001d;\n\t\tu\"q\b\u0002\u000e\u0003J$\u0018NZ1di\u000eCWO\\6\u000b\u0007\te2.A\u0003dY>\u001cX\r\u0006\u0002\u0002~\u000691/^7nCJLHCAAz\u0003A\u0019H/Y4fI\u0006\u0013H/\u001b4bGR\u001c\b%A\bdQVt7.\u001a3BeRLg-Y2u+\t\u0011y\u0005E\u0002\u0002*Y\u0012Qc\u0015;bO\u0016$7\t[;oW\u0016$\u0017I\u001d;jM\u0006\u001cGoE\u00027\u0003O\t\u0011B\\;n\u0007\",hn[:\u0011\t\u0005E\"\u0011L\u0005\u0005\u00057\nyB\u0001\u0003M_:<\u0017A\u0003;pi\u0006d')\u001f;fgRA!q\nB1\u0005G\u0012)\u0007C\u0004\u00028i\u0002\r!a\u000f\t\u000f\tU#\b1\u0001\u0003X!9!Q\f\u001eA\u0002\t]\u0013a\u0004:f[\u0006Lg.\u001b8h\u0007\",hn[:\u0016\u0005\t]\u0013a\u0005:f[\u0006Lg.\u001b8h\u0007\",hn[:`I\u0015\fH\u0003BA\u007f\u0005_B\u0011\"a\u0016=\u0003\u0003\u0005\rAa\u0016\u0002!I,W.Y5oS:<7\t[;oWN\u0004\u0013a\u0005;pi\u0006d')\u001f;fgB\u0013xnY3tg\u0016$\u0017a\u0006;pi\u0006d')\u001f;fgB\u0013xnY3tg\u0016$w\fJ3r)\u0011\tiP!\u001f\t\u0013\u0005]s(!AA\u0002\t]\u0013\u0001\u0006;pi\u0006d')\u001f;fgB\u0013xnY3tg\u0016$\u0007%\u0001\tjg\u001aK'o\u001d;De\u000e,\u0006\u000fZ1uK\u0006!\u0012n\u001d$jeN$8I]2Va\u0012\fG/Z0%KF$B!!@\u0003\u0004\"I\u0011q\u000b\"\u0002\u0002\u0003\u0007!1B\u0001\u0012SN4\u0015N]:u\u0007J\u001cW\u000b\u001d3bi\u0016\u0004\u0013AC5t\r&t\u0017n\u001d5fIR!\u0011Q BF\u0011\u001d\u0011y\"\u0012a\u0001\u0005\u0017!B!!@\u0003\u0010\"9!Q\u0006$A\u0002\t=\u0012aE2ik:\\W\rZ!si&4\u0017m\u0019;`I\u0015\fH\u0003BA\u007f\u0005+C\u0011\"a\u0016\n\u0003\u0003\u0005\rAa\u0014\u0002!\rDWO\\6fI\u0006\u0013H/\u001b4bGR\u0004\u0013A\u00025pY\u0012,'/\u0006\u0002\u0003\u001eB\u0019!Pa(\n\u0007\t\u0005\u0016JA\u0007TKN\u001c\u0018n\u001c8I_2$WM]\u0001\u000bQ>dG-\u001a:`I\u0015\fH\u0003BA\u007f\u0005OC\u0011\"a\u0016\r\u0003\u0003\u0005\rA!(\u0002\u000f!|G\u000eZ3sA\u00051qN\u001c(fqR$B!!@\u00030\"1!\u0011\u0017\bA\u0002%\f1A]3r\u0003\u001dyg.\u0012:s_J$B!!@\u00038\"9!\u0011X\bA\u0002\tm\u0016!\u0003;ie><\u0018M\u00197f!\u0011\u0011iLa2\u000f\t\t}&1\u0019\b\u0005\u0003\u0003\u0012\t-\u0003\u0002\u0002\"%!!QYA\u0010\u0003\u001d\u0001\u0018mY6bO\u0016LAA!3\u0003L\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0005\u0005\u000b\fy\"\u0001\u0012bI\u0012\u001cF/Y4fI\u0006\u0013H/\u001b4bGR$v.\u0011:uS\u001a\f7\r^'b]\u0006<WM\u001d\u000b\u0005\u0003{\u0014\t\u000eC\u0004\u0003TB\u0001\r!a\n\u0002\u0011\u0005\u0014H/\u001b4bGR\fAC\u001a7vg\"\u001cF/Y4fI\u0006\u0013H/\u001b4bGR\u001cHC\u0001Bm!\u0019\u0011iLa7\u0002t&!!Q\u001cBf\u0005\r\u0019V-]\u0001\u0017G2,\u0017M\\+q'R\fw-\u001a3BeRLg-Y2ug\u0006YqN\\\"p[BdW\r^3e\u0003M9(/\u001b;f\u0003J$\u0018NZ1diR{g)\u001b7f)\u0011\t9Ca:\t\u000f\tMG\u00031\u0001\u0003jB!!\u0011\u0007Bv\u0013\u0011\u0011iOa\u0010\u0003'MKgn\u001a7f\u0007\",hn[!si&4\u0017m\u0019;\u0015\t\t=#\u0011\u001f\u0005\b\u0005',\u0002\u0019\u0001Bz!\u0011\u0011\tD!>\n\t\t](q\b\u0002\u0015\u0005\u0016<\u0017N\\\"ik:\\W\rZ!si&4\u0017m\u0019;")
public class SparkConnectAddArtifactsHandler
implements StreamObserver<AddArtifactsRequest> {
    private final StreamObserver<AddArtifactsResponse> responseObserver;
    private final Path stagingDir;
    private final Buffer<StagedArtifact> stagedArtifacts;
    private StagedChunkedArtifact chunkedArtifact;
    private SessionHolder holder;

    public StreamObserver<AddArtifactsResponse> responseObserver() {
        return this.responseObserver;
    }

    public Path stagingDir() {
        return this.stagingDir;
    }

    public Buffer<StagedArtifact> stagedArtifacts() {
        return this.stagedArtifacts;
    }

    private StagedChunkedArtifact chunkedArtifact() {
        return this.chunkedArtifact;
    }

    private void chunkedArtifact_$eq(StagedChunkedArtifact x$1) {
        this.chunkedArtifact = x$1;
    }

    private SessionHolder holder() {
        return this.holder;
    }

    private void holder_$eq(SessionHolder x$1) {
        this.holder = x$1;
    }

    @Override
    public void onNext(AddArtifactsRequest req) {
        if (this.holder() == null) {
            this.holder_$eq(SparkConnectService$.MODULE$.getOrCreateIsolatedSession(req.getUserContext().getUserId(), req.getSessionId()));
        }
        if (req.hasBeginChunk()) {
            Predef$.MODULE$.require(this.chunkedArtifact() == null);
            this.chunkedArtifact_$eq(this.writeArtifactToFile(req.getBeginChunk()));
            return;
        }
        if (req.hasChunk()) {
            Predef$.MODULE$.require(this.chunkedArtifact() != null && !this.chunkedArtifact().isFinished());
            this.chunkedArtifact().write(req.getChunk());
            if (this.chunkedArtifact().isFinished()) {
                this.chunkedArtifact().close();
                this.chunkedArtifact_$eq(null);
                return;
            }
            return;
        }
        if (req.hasBatch()) {
            req.getBatch().getArtifactsList().forEach(artifact -> this.writeArtifactToFile((AddArtifactsRequest.SingleChunkArtifact)artifact).close());
            return;
        }
        throw new UnsupportedOperationException(new StringBuilder(35).append("Unsupported data transfer request: ").append(req).toString());
    }

    @Override
    public void onError(Throwable throwable) {
        Utils$.MODULE$.deleteRecursively(this.stagingDir().toFile());
        this.responseObserver().onError(throwable);
    }

    public void addStagedArtifactToArtifactManager(StagedArtifact artifact) {
        Predef$.MODULE$.require(this.holder() != null);
        this.holder().addArtifact(artifact.path(), artifact.stagedPath(), artifact.fragment());
    }

    public Seq<AddArtifactsResponse.ArtifactSummary> flushStagedArtifacts() {
        return ((SeqLike)this.stagedArtifacts().map((Function1 & Serializable & scala.Serializable)artifact -> {
            block2: {
                if (!artifact.getCrcStatus().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) break block2;
                if (artifact.path().startsWith(new StringBuilder(0).append(SparkConnectArtifactManager$.MODULE$.forwardToFSPrefix()).append(File.separator).toString())) {
                    this.holder().artifactManager().uploadArtifactToFs(artifact.path(), artifact.stagedPath());
                } else {
                    this.addStagedArtifactToArtifactManager((StagedArtifact)artifact);
                }
            }
            return artifact.summary();
        }, Buffer$.MODULE$.canBuildFrom())).toSeq();
    }

    public void cleanUpStagedArtifacts() {
        Utils$.MODULE$.deleteRecursively(this.stagingDir().toFile());
    }

    @Override
    public void onCompleted() {
        Seq<AddArtifactsResponse.ArtifactSummary> artifactSummaries = this.flushStagedArtifacts();
        AddArtifactsResponse.Builder builder = AddArtifactsResponse.newBuilder();
        artifactSummaries.foreach((Function1 & Serializable & scala.Serializable)summary -> builder.addArtifacts((AddArtifactsResponse.ArtifactSummary)summary));
        this.cleanUpStagedArtifacts();
        this.responseObserver().onNext(builder.build());
        this.responseObserver().onCompleted();
    }

    private StagedArtifact writeArtifactToFile(AddArtifactsRequest.SingleChunkArtifact artifact) {
        StagedArtifact stagedDep = new StagedArtifact(this, artifact.getName());
        this.stagedArtifacts().$plus$eq((Object)stagedDep);
        stagedDep.write(artifact.getData());
        return stagedDep;
    }

    private StagedChunkedArtifact writeArtifactToFile(AddArtifactsRequest.BeginChunkedArtifact artifact) {
        StagedChunkedArtifact stagedChunkedArtifact = new StagedChunkedArtifact(this, artifact.getName(), artifact.getNumChunks(), artifact.getTotalBytes());
        this.stagedArtifacts().$plus$eq((Object)stagedChunkedArtifact);
        stagedChunkedArtifact.write(artifact.getInitialChunk());
        return stagedChunkedArtifact;
    }

    public SparkConnectAddArtifactsHandler(StreamObserver<AddArtifactsResponse> responseObserver) {
        this.responseObserver = responseObserver;
        this.stagingDir = Utils$.MODULE$.createTempDir().toPath();
        this.stagedArtifacts = (Buffer)Buffer$.MODULE$.empty();
    }

    public class StagedArtifact {
        private final String name;
        private final /* synthetic */ Tuple2 x$1;
        private final String canonicalFileName;
        private final Option<String> fragment;
        private final Path path;
        private final Path stagedPath;
        private final OutputStream fileOut;
        private final CountingOutputStream countingOut;
        private final CheckedOutputStream checksumOut;
        private final AddArtifactsResponse.ArtifactSummary.Builder builder;
        private AddArtifactsResponse.ArtifactSummary artifactSummary;
        private boolean isCrcSuccess;
        public final /* synthetic */ SparkConnectAddArtifactsHandler $outer;

        public String name() {
            return this.name;
        }

        public String canonicalFileName() {
            return this.canonicalFileName;
        }

        public Option<String> fragment() {
            return this.fragment;
        }

        public Path path() {
            return this.path;
        }

        public Path stagedPath() {
            return this.stagedPath;
        }

        private OutputStream fileOut() {
            return this.fileOut;
        }

        private CountingOutputStream countingOut() {
            return this.countingOut;
        }

        private CheckedOutputStream checksumOut() {
            return this.checksumOut;
        }

        private AddArtifactsResponse.ArtifactSummary.Builder builder() {
            return this.builder;
        }

        private AddArtifactsResponse.ArtifactSummary artifactSummary() {
            return this.artifactSummary;
        }

        private void artifactSummary_$eq(AddArtifactsResponse.ArtifactSummary x$1) {
            this.artifactSummary = x$1;
        }

        public boolean isCrcSuccess() {
            return this.isCrcSuccess;
        }

        public void isCrcSuccess_$eq(boolean x$1) {
            this.isCrcSuccess = x$1;
        }

        public void updateCrc(boolean isSuccess) {
            this.isCrcSuccess_$eq(isSuccess);
        }

        public Option<Object> getCrcStatus() {
            return Option$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.isCrcSuccess()));
        }

        public void write(AddArtifactsRequest.ArtifactChunk dataChunk) {
            try {
                dataChunk.getData().writeTo(this.checksumOut());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    this.close();
                    throw e;
                }
                throw throwable;
            }
            this.updateCrc(this.checksumOut().getChecksum().getValue() == dataChunk.getCrc());
            this.checksumOut().getChecksum().reset();
        }

        public void close() {
            if (this.artifactSummary() == null) {
                this.checksumOut().close();
                this.artifactSummary_$eq(this.builder().setName(this.name()).setIsCrcSuccessful(BoxesRunTime.unboxToBoolean((Object)this.getCrcStatus().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false))).build());
                return;
            }
        }

        public AddArtifactsResponse.ArtifactSummary summary() {
            Predef$.MODULE$.require(this.artifactSummary() != null);
            return this.artifactSummary();
        }

        public /* synthetic */ SparkConnectAddArtifactsHandler org$apache$spark$sql$connect$service$SparkConnectAddArtifactsHandler$StagedArtifact$$$outer() {
            return this.$outer;
        }

        private final /* synthetic */ Path liftedTree1$1() {
            Path path;
            try {
                path = ArtifactUtils$.MODULE$.concatenatePaths(this.org$apache$spark$sql$connect$service$SparkConnectAddArtifactsHandler$StagedArtifact$$$outer().stagingDir(), this.path());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof IllegalArgumentException) {
                    throw new IllegalArgumentException(new StringBuilder(123).append("Artifact with name: ").append(this.name()).append(" is invalid. The `name` ").append("must be a relative path and cannot reference parent/sibling/nephew directories.").toString());
                }
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    throw e;
                }
                throw throwable;
            }
            return path;
        }

        public StagedArtifact(SparkConnectAddArtifactsHandler $outer, String name) {
            String string;
            Option fragment;
            block7: {
                Tuple2 tuple2;
                block6: {
                    Tuple2 tuple22;
                    this.name = name;
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    if (name.startsWith(new StringBuilder(8).append("archives").append(File.separator).toString())) {
                        String[] splits = name.split("#");
                        Predef$.MODULE$.assert(splits.length <= 2, (Function0 & Serializable & scala.Serializable)() -> "'#' in the path is not supported for adding an archive.");
                        tuple22 = splits.length == 2 ? new Tuple2((Object)splits[0], (Object)new Some((Object)splits[1])) : new Tuple2((Object)splits[0], (Object)None$.MODULE$);
                    } else {
                        tuple22 = tuple2 = new Tuple2((Object)name, (Object)None$.MODULE$);
                    }
                    if (tuple2 == null) break block6;
                    String canonicalFileName = (String)tuple2._1();
                    fragment = (Option)tuple2._2();
                    if (canonicalFileName == null) break block6;
                    string = canonicalFileName;
                    if (fragment != null) break block7;
                }
                throw new MatchError((Object)tuple2);
            }
            Option option = fragment;
            this.x$1 = new Tuple2((Object)string, (Object)option);
            this.canonicalFileName = (String)this.x$1._1();
            this.fragment = (Option)this.x$1._2();
            this.path = Paths.get(this.canonicalFileName(), new String[0]);
            this.stagedPath = this.liftedTree1$1();
            Files.createDirectories(this.stagedPath().getParent(), new FileAttribute[0]);
            this.fileOut = Files.newOutputStream(this.stagedPath(), new OpenOption[0]);
            this.countingOut = new CountingOutputStream(this.fileOut());
            this.checksumOut = new CheckedOutputStream(this.countingOut(), new CRC32());
            this.builder = AddArtifactsResponse.ArtifactSummary.newBuilder().setName(name);
        }
    }

    public class StagedChunkedArtifact
    extends StagedArtifact {
        private final long numChunks;
        private final long totalBytes;
        private long remainingChunks;
        private long totalBytesProcessed;
        private boolean isFirstCrcUpdate;

        private long remainingChunks() {
            return this.remainingChunks;
        }

        private void remainingChunks_$eq(long x$1) {
            this.remainingChunks = x$1;
        }

        private long totalBytesProcessed() {
            return this.totalBytesProcessed;
        }

        private void totalBytesProcessed_$eq(long x$1) {
            this.totalBytesProcessed = x$1;
        }

        private boolean isFirstCrcUpdate() {
            return this.isFirstCrcUpdate;
        }

        private void isFirstCrcUpdate_$eq(boolean x$1) {
            this.isFirstCrcUpdate = x$1;
        }

        public boolean isFinished() {
            return this.remainingChunks() == 0L;
        }

        @Override
        public void updateCrc(boolean isSuccess) {
            this.isCrcSuccess_$eq(isSuccess && (this.isCrcSuccess() || this.isFirstCrcUpdate()));
            this.isFirstCrcUpdate_$eq(false);
        }

        @Override
        public void write(AddArtifactsRequest.ArtifactChunk dataChunk) {
            if (this.remainingChunks() == 0L) {
                throw new RuntimeException(new StringBuilder(96).append("Excessive data chunks for artifact: ").append(super.name()).append(", ").append("expected ").append(this.numChunks).append(" chunks in total. Processed ").append(this.totalBytesProcessed()).append(" bytes out of").append(" ").append(this.totalBytes).append(" bytes.").toString());
            }
            super.write(dataChunk);
            this.totalBytesProcessed_$eq(this.totalBytesProcessed() + (long)dataChunk.getData().size());
            this.remainingChunks_$eq(this.remainingChunks() - 1L);
        }

        @Override
        public void close() {
            if (this.remainingChunks() != 0L || this.totalBytesProcessed() != this.totalBytes) {
                throw new RuntimeException(new StringBuilder(106).append("Missing data chunks for artifact: ").append(super.name()).append(". Expected ").append(this.numChunks).append(" chunks and received ").append(this.numChunks - this.remainingChunks()).append(" chunks. Processed").append(" ").append(this.totalBytesProcessed()).append(" bytes out of ").append(this.totalBytes).append(" bytes.").toString());
            }
            super.close();
        }

        public /* synthetic */ SparkConnectAddArtifactsHandler org$apache$spark$sql$connect$service$SparkConnectAddArtifactsHandler$StagedChunkedArtifact$$$outer() {
            return this.$outer;
        }

        public StagedChunkedArtifact(SparkConnectAddArtifactsHandler $outer, String name, long numChunks, long totalBytes) {
            this.numChunks = numChunks;
            this.totalBytes = totalBytes;
            super($outer, name);
            this.remainingChunks = numChunks;
            this.totalBytesProcessed = 0L;
            this.isFirstCrcUpdate = true;
        }
    }
}

