/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.protobuf;

import com.google.common.base.Preconditions;
import io.grpc.ExperimentalApi;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import io.grpc.protobuf.lite.ProtoLiteUtils;
import javax.annotation.Nullable;
import org.sparkproject.connect.google_protos.rpc.Status;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4695")
public final class StatusProto {
    private static final Metadata.Key<org.sparkproject.connect.google_protos.rpc.Status> STATUS_DETAILS_KEY = Metadata.Key.of("grpc-status-details-bin", ProtoLiteUtils.metadataMarshaller(org.sparkproject.connect.google_protos.rpc.Status.getDefaultInstance()));

    private StatusProto() {
    }

    public static StatusRuntimeException toStatusRuntimeException(org.sparkproject.connect.google_protos.rpc.Status statusProto) {
        return StatusProto.toStatus(statusProto).asRuntimeException(StatusProto.toMetadata(statusProto));
    }

    public static StatusRuntimeException toStatusRuntimeException(org.sparkproject.connect.google_protos.rpc.Status statusProto, Metadata metadata) {
        return StatusProto.toStatus(statusProto).asRuntimeException(StatusProto.toMetadata(statusProto, metadata));
    }

    public static StatusException toStatusException(org.sparkproject.connect.google_protos.rpc.Status statusProto) {
        return StatusProto.toStatus(statusProto).asException(StatusProto.toMetadata(statusProto));
    }

    public static StatusException toStatusException(org.sparkproject.connect.google_protos.rpc.Status statusProto, Metadata metadata) {
        return StatusProto.toStatus(statusProto).asException(StatusProto.toMetadata(statusProto, metadata));
    }

    private static Status toStatus(org.sparkproject.connect.google_protos.rpc.Status statusProto) {
        Status status = Status.fromCodeValue(statusProto.getCode());
        Preconditions.checkArgument(status.getCode().value() == statusProto.getCode(), "invalid status code");
        return status.withDescription(statusProto.getMessage());
    }

    private static Metadata toMetadata(org.sparkproject.connect.google_protos.rpc.Status statusProto) {
        Metadata metadata = new Metadata();
        metadata.put(STATUS_DETAILS_KEY, statusProto);
        return metadata;
    }

    private static Metadata toMetadata(org.sparkproject.connect.google_protos.rpc.Status statusProto, Metadata metadata) {
        Preconditions.checkNotNull(metadata, "metadata must not be null");
        metadata.discardAll(STATUS_DETAILS_KEY);
        metadata.put(STATUS_DETAILS_KEY, statusProto);
        return metadata;
    }

    @Nullable
    public static org.sparkproject.connect.google_protos.rpc.Status fromThrowable(Throwable t2) {
        for (Throwable cause = Preconditions.checkNotNull(t2, "t"); cause != null; cause = cause.getCause()) {
            if (cause instanceof StatusException) {
                StatusException e = (StatusException)cause;
                return StatusProto.fromStatusAndTrailers(e.getStatus(), e.getTrailers());
            }
            if (!(cause instanceof StatusRuntimeException)) continue;
            StatusRuntimeException e = (StatusRuntimeException)cause;
            return StatusProto.fromStatusAndTrailers(e.getStatus(), e.getTrailers());
        }
        return null;
    }

    public static org.sparkproject.connect.google_protos.rpc.Status fromStatusAndTrailers(Status status, @Nullable Metadata trailers) {
        org.sparkproject.connect.google_protos.rpc.Status statusProto;
        Preconditions.checkNotNull(status, "status");
        if (trailers != null && (statusProto = trailers.get(STATUS_DETAILS_KEY)) != null) {
            Preconditions.checkArgument(status.getCode().value() == statusProto.getCode(), "org.sparkproject.connect.google_protos.rpc.Status code must match gRPC status code");
            return statusProto;
        }
        Status.Builder statusBuilder = org.sparkproject.connect.google_protos.rpc.Status.newBuilder().setCode(status.getCode().value());
        if (status.getDescription() != null) {
            statusBuilder.setMessage(status.getDescription());
        }
        return statusBuilder.build();
    }
}

