/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.inprocess;

import com.google.common.base.Preconditions;
import io.grpc.Deadline;
import io.grpc.ExperimentalApi;
import io.grpc.Internal;
import io.grpc.ServerBuilder;
import io.grpc.ServerStreamTracer;
import io.grpc.inprocess.InProcessServer;
import io.grpc.inprocess.InProcessSocketAddress;
import io.grpc.internal.AbstractServerImplBuilder;
import io.grpc.internal.FixedObjectPool;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.InternalServer;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.ServerImplBuilder;
import io.grpc.internal.SharedResourcePool;
import java.io.File;
import java.net.SocketAddress;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.sparkproject.connect.errorprone_annotations.DoNotCall;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1783")
public final class InProcessServerBuilder
extends AbstractServerImplBuilder<InProcessServerBuilder> {
    private final ServerImplBuilder serverImplBuilder;
    final SocketAddress listenAddress;
    int maxInboundMetadataSize = Integer.MAX_VALUE;
    ObjectPool<ScheduledExecutorService> schedulerPool = SharedResourcePool.forResource(GrpcUtil.TIMER_SERVICE);

    public static InProcessServerBuilder forName(String name) {
        return InProcessServerBuilder.forAddress(new InProcessSocketAddress(Preconditions.checkNotNull(name, "name")));
    }

    public static InProcessServerBuilder forAddress(SocketAddress listenAddress) {
        return new InProcessServerBuilder(listenAddress);
    }

    @DoNotCall(value="Unsupported. Use forName() instead")
    public static InProcessServerBuilder forPort(int port) {
        throw new UnsupportedOperationException("call forName() instead");
    }

    public static String generateName() {
        return UUID.randomUUID().toString();
    }

    private InProcessServerBuilder(SocketAddress listenAddress) {
        this.listenAddress = Preconditions.checkNotNull(listenAddress, "listenAddress");
        final class InProcessClientTransportServersBuilder
        implements ServerImplBuilder.ClientTransportServersBuilder {
            InProcessClientTransportServersBuilder() {
            }

            @Override
            public InternalServer buildClientTransportServers(List<? extends ServerStreamTracer.Factory> streamTracerFactories) {
                return InProcessServerBuilder.this.buildTransportServers(streamTracerFactories);
            }
        }
        this.serverImplBuilder = new ServerImplBuilder(new InProcessClientTransportServersBuilder());
        this.serverImplBuilder.setStatsRecordStartedRpcs(false);
        this.serverImplBuilder.setStatsRecordFinishedRpcs(false);
        this.handshakeTimeout(Long.MAX_VALUE, TimeUnit.SECONDS);
    }

    @Override
    @Internal
    protected ServerBuilder<?> delegate() {
        return this.serverImplBuilder;
    }

    public InProcessServerBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.schedulerPool = new FixedObjectPool<ScheduledExecutorService>(Preconditions.checkNotNull(scheduledExecutorService, "scheduledExecutorService"));
        return this;
    }

    public InProcessServerBuilder deadlineTicker(Deadline.Ticker ticker) {
        this.serverImplBuilder.setDeadlineTicker(ticker);
        return this;
    }

    @Override
    public InProcessServerBuilder maxInboundMetadataSize(int bytes) {
        Preconditions.checkArgument(bytes > 0, "maxInboundMetadataSize must be > 0");
        this.maxInboundMetadataSize = bytes;
        return this;
    }

    InProcessServer buildTransportServers(List<? extends ServerStreamTracer.Factory> streamTracerFactories) {
        return new InProcessServer(this, streamTracerFactories);
    }

    @Override
    public InProcessServerBuilder useTransportSecurity(File certChain, File privateKey) {
        throw new UnsupportedOperationException("TLS not supported in InProcessServer");
    }

    void setStatsEnabled(boolean value) {
        this.serverImplBuilder.setStatsEnabled(value);
    }
}

