/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.plugin;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.sql.connect.config.Connect$;
import org.apache.spark.sql.connect.plugin.CommandPlugin;
import org.apache.spark.sql.connect.plugin.ExpressionPlugin;
import org.apache.spark.sql.connect.plugin.RelationPlugin;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;

public final class SparkConnectPluginRegistry$ {
    public static SparkConnectPluginRegistry$ MODULE$;
    private Seq<Function0<RelationPlugin>> relationPluginChain;
    private Seq<Function0<ExpressionPlugin>> expressionPluginChain;
    private Seq<Function0<CommandPlugin>> commandPluginChain;
    private boolean initialized;
    private Seq<RelationPlugin> relationRegistryCache;
    private Seq<ExpressionPlugin> expressionRegistryCache;
    private Seq<CommandPlugin> commandRegistryCache;
    private volatile byte bitmap$0;

    static {
        new SparkConnectPluginRegistry$();
    }

    private Seq<Function0<RelationPlugin>> relationPluginChain$lzycompute() {
        SparkConnectPluginRegistry$ sparkConnectPluginRegistry$ = this;
        synchronized (sparkConnectPluginRegistry$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.relationPluginChain = (Seq)Nil$.MODULE$;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.relationPluginChain;
    }

    private Seq<Function0<RelationPlugin>> relationPluginChain() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.relationPluginChain$lzycompute();
        }
        return this.relationPluginChain;
    }

    private Seq<Function0<ExpressionPlugin>> expressionPluginChain$lzycompute() {
        SparkConnectPluginRegistry$ sparkConnectPluginRegistry$ = this;
        synchronized (sparkConnectPluginRegistry$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.expressionPluginChain = (Seq)Nil$.MODULE$;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.expressionPluginChain;
    }

    private Seq<Function0<ExpressionPlugin>> expressionPluginChain() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.expressionPluginChain$lzycompute();
        }
        return this.expressionPluginChain;
    }

    private Seq<Function0<CommandPlugin>> commandPluginChain$lzycompute() {
        SparkConnectPluginRegistry$ sparkConnectPluginRegistry$ = this;
        synchronized (sparkConnectPluginRegistry$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.commandPluginChain = (Seq)Nil$.MODULE$;
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.commandPluginChain;
    }

    private Seq<Function0<CommandPlugin>> commandPluginChain() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.commandPluginChain$lzycompute();
        }
        return this.commandPluginChain;
    }

    private boolean initialized() {
        return this.initialized;
    }

    private void initialized_$eq(boolean x$1) {
        this.initialized = x$1;
    }

    private Seq<RelationPlugin> relationRegistryCache() {
        return this.relationRegistryCache;
    }

    private void relationRegistryCache_$eq(Seq<RelationPlugin> x$1) {
        this.relationRegistryCache = x$1;
    }

    private Seq<ExpressionPlugin> expressionRegistryCache() {
        return this.expressionRegistryCache;
    }

    private void expressionRegistryCache_$eq(Seq<ExpressionPlugin> x$1) {
        this.expressionRegistryCache = x$1;
    }

    private Seq<CommandPlugin> commandRegistryCache() {
        return this.commandRegistryCache;
    }

    private void commandRegistryCache_$eq(Seq<CommandPlugin> x$1) {
        this.commandRegistryCache = x$1;
    }

    public Seq<RelationPlugin> relationRegistry() {
        return this.withInitialize((Function0 & Serializable & scala.Serializable)() -> MODULE$.relationRegistryCache());
    }

    public Seq<ExpressionPlugin> expressionRegistry() {
        return this.withInitialize((Function0 & Serializable & scala.Serializable)() -> MODULE$.expressionRegistryCache());
    }

    public Seq<CommandPlugin> commandRegistry() {
        return this.withInitialize((Function0 & Serializable & scala.Serializable)() -> MODULE$.commandRegistryCache());
    }

    private <T> Seq<T> withInitialize(Function0<Seq<T>> f) {
        SparkConnectPluginRegistry$ sparkConnectPluginRegistry$ = this;
        synchronized (sparkConnectPluginRegistry$) {
            if (!this.initialized()) {
                this.relationRegistryCache_$eq(this.loadRelationPlugins());
                this.expressionRegistryCache_$eq(this.loadExpressionPlugins());
                this.commandRegistryCache_$eq(this.loadCommandPlugins());
                this.initialized_$eq(true);
            }
        }
        return (Seq)f.apply();
    }

    public synchronized void reset() {
        this.initialized_$eq(false);
    }

    public Seq<RelationPlugin> loadRelationPlugins() {
        return (Seq)((TraversableLike)this.relationPluginChain().map((Function1 & Serializable & scala.Serializable)x -> (RelationPlugin)x.apply(), Seq$.MODULE$.canBuildFrom())).$plus$plus(this.createConfiguredPlugins((Seq<String>)((Seq)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_EXTENSIONS_RELATION_CLASSES()))), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<ExpressionPlugin> loadExpressionPlugins() {
        return (Seq)((TraversableLike)this.expressionPluginChain().map((Function1 & Serializable & scala.Serializable)x -> (ExpressionPlugin)x.apply(), Seq$.MODULE$.canBuildFrom())).$plus$plus(this.createConfiguredPlugins((Seq<String>)((Seq)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_EXTENSIONS_EXPRESSION_CLASSES()))), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<CommandPlugin> loadCommandPlugins() {
        return (Seq)((TraversableLike)this.commandPluginChain().map((Function1 & Serializable & scala.Serializable)x -> (CommandPlugin)x.apply(), Seq$.MODULE$.canBuildFrom())).$plus$plus(this.createConfiguredPlugins((Seq<String>)((Seq)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_EXTENSIONS_COMMAND_CLASSES()))), Seq$.MODULE$.canBuildFrom());
    }

    public <T> Seq<T> createConfiguredPlugins(Seq<String> values) {
        if (values.nonEmpty()) {
            return (Seq)((TraversableLike)((TraversableLike)((TraversableLike)values.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.trim(), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectPluginRegistry$.$anonfun$createConfiguredPlugins$2(x$2)))).map((Function1 & Serializable & scala.Serializable)x$3 -> Utils$.MODULE$.classForName(x$3, Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3()), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$4 -> MODULE$.createInstance((Class)x$4), Seq$.MODULE$.canBuildFrom());
        }
        return (Seq)Nil$.MODULE$;
    }

    private <B, T extends B> B createInstance(Class<T> cls) {
        Object t2;
        Option ctorOpt = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cls.getConstructors())).find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectPluginRegistry$.$anonfun$createInstance$1(x$5)));
        if (ctorOpt.isEmpty()) {
            throw new SparkException("CONNECT.PLUGIN_CTOR_MISSING", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cls"), (Object)cls.getName())})), null);
        }
        try {
            t2 = ((Constructor)ctorOpt.get()).newInstance(new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new SparkException("CONNECT.PLUGIN_RUNTIME_ERROR", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), (Object)e.getTargetException().getMessage())})), (Throwable)e);
        }
        catch (Exception e) {
            throw new SparkException("CONNECT.PLUGIN_RUNTIME_ERROR", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), (Object)e.getMessage())})), (Throwable)e);
        }
        return (B)t2;
    }

    public <T extends RelationPlugin> Function0<RelationPlugin> relation(Class<T> cls) {
        return (Function0 & Serializable & scala.Serializable)() -> (RelationPlugin)MODULE$.createInstance(cls);
    }

    public <T extends ExpressionPlugin> Function0<ExpressionPlugin> expression(Class<T> cls) {
        return (Function0 & Serializable & scala.Serializable)() -> (ExpressionPlugin)MODULE$.createInstance(cls);
    }

    public <T extends CommandPlugin> Function0<CommandPlugin> command(Class<T> cls) {
        return (Function0 & Serializable & scala.Serializable)() -> (CommandPlugin)MODULE$.createInstance(cls);
    }

    public static final /* synthetic */ boolean $anonfun$createConfiguredPlugins$2(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$createInstance$1(Constructor x$5) {
        return x$5.getParameterCount() == 0;
    }

    private SparkConnectPluginRegistry$() {
        MODULE$ = this;
        this.initialized = false;
        this.relationRegistryCache = (Seq)Nil$.MODULE$;
        this.expressionRegistryCache = (Seq)Nil$.MODULE$;
        this.commandRegistryCache = (Seq)Nil$.MODULE$;
    }
}

