/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.time.Period;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.util.MathUtils$;
import org.apache.spark.sql.catalyst.util.SparkIntervalUtils;
import org.apache.spark.sql.catalyst.util.SparkIntervalUtils$ParseState$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichDouble$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class IntervalUtils$
implements SparkIntervalUtils {
    public static IntervalUtils$ MODULE$;
    private final String yearMonthPatternString;
    private final Regex yearMonthRegex;
    private final Regex yearMonthLiteralRegex;
    private final String yearMonthIndividualPatternString;
    private final Regex yearMonthIndividualRegex;
    private final Regex yearMonthIndividualLiteralRegex;
    private final Map<Tuple3<String, Object, Object>, Seq<String>> supportedFormat;
    private final String normalPattern;
    private final String dayBoundPattern;
    private final String hourBoundPattern;
    private final String minuteBoundPattern;
    private final String secondBoundPattern;
    private final String microPattern;
    private final String dayHourPatternString;
    private final Regex dayHourRegex;
    private final Regex dayHourLiteralRegex;
    private final String dayMinutePatternString;
    private final Regex dayMinuteRegex;
    private final Regex dayMinuteLiteralRegex;
    private final String daySecondPatternString;
    private final Regex daySecondRegex;
    private final Regex daySecondLiteralRegex;
    private final String hourMinutePatternString;
    private final Regex hourMinuteRegex;
    private final Regex hourMinuteLiteralRegex;
    private final String hourSecondPatternString;
    private final Regex hourSecondRegex;
    private final Regex hourSecondLiteralRegex;
    private final String minuteSecondPatternString;
    private final Regex minuteSecondRegex;
    private final Regex minuteSecondLiteralRegex;
    private final String dayTimeIndividualPatternString;
    private final Regex dayTimeIndividualRegex;
    private final Regex dayTimeIndividualLiteralRegex;
    private final Regex dayTimePatternLegacy;
    private final String fallbackNotice;
    private final long MAX_DAY;
    private final long MAX_HOUR;
    private final long MAX_MINUTE;
    private final long MAX_SECOND;
    private final long MIN_SECOND;
    private final long org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$minDurationSeconds;
    private final UTF8String intervalStr;
    private final UTF8String yearStr;
    private final UTF8String monthStr;
    private final UTF8String weekStr;
    private final UTF8String dayStr;
    private final UTF8String hourStr;
    private final UTF8String minuteStr;
    private final UTF8String secondStr;
    private final UTF8String millisStr;
    private final UTF8String microsStr;
    private final UTF8String nanosStr;
    private volatile SparkIntervalUtils$ParseState$ ParseState$module;

    static {
        new IntervalUtils$();
    }

    public long durationToMicros(Duration duration) {
        return SparkIntervalUtils.durationToMicros$((SparkIntervalUtils)this, (Duration)duration);
    }

    public long durationToMicros(Duration duration, byte endField) {
        return SparkIntervalUtils.durationToMicros$((SparkIntervalUtils)this, (Duration)duration, (byte)endField);
    }

    public int periodToMonths(Period period) {
        return SparkIntervalUtils.periodToMonths$((SparkIntervalUtils)this, (Period)period);
    }

    public int periodToMonths(Period period, byte endField) {
        return SparkIntervalUtils.periodToMonths$((SparkIntervalUtils)this, (Period)period, (byte)endField);
    }

    public Duration microsToDuration(long micros) {
        return SparkIntervalUtils.microsToDuration$((SparkIntervalUtils)this, (long)micros);
    }

    public Period monthsToPeriod(int months) {
        return SparkIntervalUtils.monthsToPeriod$((SparkIntervalUtils)this, (int)months);
    }

    public CalendarInterval stringToInterval(UTF8String input) {
        return SparkIntervalUtils.stringToInterval$((SparkIntervalUtils)this, (UTF8String)input);
    }

    public String toYearMonthIntervalString(int months, Enumeration.Value style, byte startField, byte endField) {
        return SparkIntervalUtils.toYearMonthIntervalString$((SparkIntervalUtils)this, (int)months, (Enumeration.Value)style, (byte)startField, (byte)endField);
    }

    public String toDayTimeIntervalString(long micros, Enumeration.Value style, byte startField, byte endField) {
        return SparkIntervalUtils.toDayTimeIntervalString$((SparkIntervalUtils)this, (long)micros, (Enumeration.Value)style, (byte)startField, (byte)endField);
    }

    public UTF8String unitToUtf8(String unit) {
        return SparkIntervalUtils.unitToUtf8$((SparkIntervalUtils)this, (String)unit);
    }

    public long MAX_DAY() {
        return this.MAX_DAY;
    }

    public long MAX_HOUR() {
        return this.MAX_HOUR;
    }

    public long MAX_MINUTE() {
        return this.MAX_MINUTE;
    }

    public long MAX_SECOND() {
        return this.MAX_SECOND;
    }

    public long MIN_SECOND() {
        return this.MIN_SECOND;
    }

    public final long org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$minDurationSeconds() {
        return this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$minDurationSeconds;
    }

    public UTF8String intervalStr() {
        return this.intervalStr;
    }

    public UTF8String yearStr() {
        return this.yearStr;
    }

    public UTF8String monthStr() {
        return this.monthStr;
    }

    public UTF8String weekStr() {
        return this.weekStr;
    }

    public UTF8String dayStr() {
        return this.dayStr;
    }

    public UTF8String hourStr() {
        return this.hourStr;
    }

    public UTF8String minuteStr() {
        return this.minuteStr;
    }

    public UTF8String secondStr() {
        return this.secondStr;
    }

    public UTF8String millisStr() {
        return this.millisStr;
    }

    public UTF8String microsStr() {
        return this.microsStr;
    }

    public UTF8String nanosStr() {
        return this.nanosStr;
    }

    public SparkIntervalUtils$ParseState$ org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$ParseState() {
        if (this.ParseState$module == null) {
            this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$ParseState$lzycompute$1();
        }
        return this.ParseState$module;
    }

    public void org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$MAX_DAY_$eq(long x$1) {
        this.MAX_DAY = x$1;
    }

    public void org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$MAX_HOUR_$eq(long x$1) {
        this.MAX_HOUR = x$1;
    }

    public void org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$MAX_MINUTE_$eq(long x$1) {
        this.MAX_MINUTE = x$1;
    }

    public void org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$MAX_SECOND_$eq(long x$1) {
        this.MAX_SECOND = x$1;
    }

    public void org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$MIN_SECOND_$eq(long x$1) {
        this.MIN_SECOND = x$1;
    }

    public final void org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$minDurationSeconds_$eq(long x$1) {
        this.org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$minDurationSeconds = x$1;
    }

    public void org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$intervalStr_$eq(UTF8String x$1) {
        this.intervalStr = x$1;
    }

    public void org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$yearStr_$eq(UTF8String x$1) {
        this.yearStr = x$1;
    }

    public void org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$monthStr_$eq(UTF8String x$1) {
        this.monthStr = x$1;
    }

    public void org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$weekStr_$eq(UTF8String x$1) {
        this.weekStr = x$1;
    }

    public void org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$dayStr_$eq(UTF8String x$1) {
        this.dayStr = x$1;
    }

    public void org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$hourStr_$eq(UTF8String x$1) {
        this.hourStr = x$1;
    }

    public void org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$minuteStr_$eq(UTF8String x$1) {
        this.minuteStr = x$1;
    }

    public void org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$secondStr_$eq(UTF8String x$1) {
        this.secondStr = x$1;
    }

    public void org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$millisStr_$eq(UTF8String x$1) {
        this.millisStr = x$1;
    }

    public void org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$microsStr_$eq(UTF8String x$1) {
        this.microsStr = x$1;
    }

    public void org$apache$spark$sql$catalyst$util$SparkIntervalUtils$_setter_$nanosStr_$eq(UTF8String x$1) {
        this.nanosStr = x$1;
    }

    public int getYears(int months) {
        return months / 12;
    }

    public int getYears(CalendarInterval interval) {
        return this.getYears(interval.months);
    }

    public byte getMonths(int months) {
        return (byte)(months % 12);
    }

    public byte getMonths(CalendarInterval interval) {
        return this.getMonths(interval.months);
    }

    public int getDays(long microseconds) {
        return (int)(microseconds / 86400000000L);
    }

    public int getDays(CalendarInterval interval) {
        int daysInMicroseconds = this.getDays(interval.microseconds);
        return Math.addExact(interval.days, daysInMicroseconds);
    }

    public byte getHours(long microseconds) {
        return (byte)(microseconds % 86400000000L / 3600000000L);
    }

    public byte getHours(CalendarInterval interval) {
        return this.getHours(interval.microseconds);
    }

    public byte getMinutes(long microseconds) {
        return (byte)(microseconds % 3600000000L / 60000000L);
    }

    public byte getMinutes(CalendarInterval interval) {
        return this.getMinutes(interval.microseconds);
    }

    public Decimal getSeconds(long microseconds) {
        return Decimal$.MODULE$.apply(microseconds % 60000000L, 8, 6);
    }

    public Decimal getSeconds(CalendarInterval interval) {
        return this.getSeconds(interval.microseconds);
    }

    private long toLongWithRange(UTF8String fieldName, String s, long minValue, long maxValue) {
        long result = s == null ? 0L : new StringOps(Predef$.MODULE$.augmentString(s)).toLong();
        Predef$.MODULE$.require(minValue <= result && result <= maxValue, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append(fieldName).append(" ").append(result).append(" outside range [").append(minValue).append(", ").append(maxValue).append("]").toString());
        return result;
    }

    private String yearMonthPatternString() {
        return this.yearMonthPatternString;
    }

    private Regex yearMonthRegex() {
        return this.yearMonthRegex;
    }

    private Regex yearMonthLiteralRegex() {
        return this.yearMonthLiteralRegex;
    }

    private String yearMonthIndividualPatternString() {
        return this.yearMonthIndividualPatternString;
    }

    private Regex yearMonthIndividualRegex() {
        return this.yearMonthIndividualRegex;
    }

    private Regex yearMonthIndividualLiteralRegex() {
        return this.yearMonthIndividualLiteralRegex;
    }

    private int finalSign(String firstSign, String secondSign) {
        String string;
        String string2;
        Tuple2 tuple2 = new Tuple2((Object)firstSign, (Object)secondSign);
        if (tuple2 != null) {
            String string3 = (String)tuple2._1();
            String string4 = (String)tuple2._2();
            if ("-".equals(string3) && "-".equals(string4)) {
                return 1;
            }
        }
        if (tuple2 != null && "-".equals(string2 = (String)tuple2._1())) {
            return -1;
        }
        if (tuple2 != null && "-".equals(string = (String)tuple2._2())) {
            return -1;
        }
        if (tuple2 != null) {
            return 1;
        }
        throw new MatchError((Object)tuple2);
    }

    private String finalSign$default$2() {
        return null;
    }

    private Nothing$ throwIllegalIntervalFormatException(UTF8String input, byte startFiled, byte endField, String intervalStr, String typeName, Option<String> fallBackNotice) {
        throw new IllegalArgumentException(new StringBuilder(58).append("Interval string does not match ").append(intervalStr).append(" format of ").append(((TraversableOnce)((TraversableLike)this.supportedFormat().apply((Object)new Tuple3((Object)intervalStr, (Object)BoxesRunTime.boxToByte((byte)startFiled), (Object)BoxesRunTime.boxToByte((byte)endField)))).map((Function1 & Serializable & scala.Serializable)format -> new StringBuilder(2).append("`").append((String)format).append("`").toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append(" ").append("when cast to ").append(typeName).append(": ").append(input.toString()).append(fallBackNotice.map((Function1 & Serializable & scala.Serializable)s -> new StringBuilder(2).append(", ").append((String)s).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString());
    }

    private Option<String> throwIllegalIntervalFormatException$default$6() {
        return None$.MODULE$;
    }

    public Map<Tuple3<String, Object, Object>, Seq<String>> supportedFormat() {
        return this.supportedFormat;
    }

    public int castStringToYMInterval(UTF8String input, byte startField, byte endField) {
        Option option;
        Option option2;
        String string = input.trimAll().toString();
        Option option3 = this.yearMonthRegex().unapplySeq((CharSequence)string);
        if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(3) == 0) {
            String sign = (String)((LinearSeqOptimized)option3.get()).apply(0);
            String year = (String)((LinearSeqOptimized)option3.get()).apply(1);
            String month = (String)((LinearSeqOptimized)option3.get()).apply(2);
            if (IntervalUtils$.checkTargetType$1(YearMonthIntervalType$.MODULE$.YEAR(), YearMonthIntervalType$.MODULE$.MONTH(), startField, endField)) {
                return this.toYMInterval(year, month, this.finalSign(sign, this.finalSign$default$2()));
            }
        }
        if (!(option2 = this.yearMonthLiteralRegex().unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(4) == 0) {
            String firstSign = (String)((LinearSeqOptimized)option2.get()).apply(0);
            String secondSign = (String)((LinearSeqOptimized)option2.get()).apply(1);
            String year = (String)((LinearSeqOptimized)option2.get()).apply(2);
            String month = (String)((LinearSeqOptimized)option2.get()).apply(3);
            if (IntervalUtils$.checkTargetType$1(YearMonthIntervalType$.MODULE$.YEAR(), YearMonthIntervalType$.MODULE$.MONTH(), startField, endField)) {
                return this.toYMInterval(year, month, this.finalSign(firstSign, secondSign));
            }
        }
        if (!(option = this.yearMonthIndividualRegex().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
            String firstSign = (String)((LinearSeqOptimized)option.get()).apply(0);
            String value = (String)((LinearSeqOptimized)option.get()).apply(1);
            return BoxesRunTime.unboxToInt(this.safeToInterval("year-month", (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
                int sign = MODULE$.finalSign(firstSign, MODULE$.finalSign$default$2());
                if (endField == YearMonthIntervalType$.MODULE$.YEAR()) {
                    return sign * Math.toIntExact(new StringOps(Predef$.MODULE$.augmentString(value)).toLong() * 12L);
                }
                if (startField == YearMonthIntervalType$.MODULE$.MONTH()) {
                    return Math.toIntExact((long)sign * new StringOps(Predef$.MODULE$.augmentString(value)).toLong());
                }
                throw MODULE$.throwIllegalIntervalFormatException(input, startField, endField, "year-month", new YearMonthIntervalType(startField, endField).typeName(), MODULE$.throwIllegalIntervalFormatException$default$6());
            }));
        }
        Option option4 = this.yearMonthIndividualLiteralRegex().unapplySeq((CharSequence)string);
        if (!option4.isEmpty() && option4.get() != null && ((LinearSeqOptimized)option4.get()).lengthCompare(4) == 0) {
            String firstSign = (String)((LinearSeqOptimized)option4.get()).apply(0);
            String secondSign = (String)((LinearSeqOptimized)option4.get()).apply(1);
            String value = (String)((LinearSeqOptimized)option4.get()).apply(2);
            String unit = (String)((LinearSeqOptimized)option4.get()).apply(3);
            return BoxesRunTime.unboxToInt(this.safeToInterval("year-month", (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
                int sign = MODULE$.finalSign(firstSign, secondSign);
                String string = unit.toUpperCase(Locale.ROOT);
                if ("YEAR".equals(string) && IntervalUtils$.checkTargetType$1(YearMonthIntervalType$.MODULE$.YEAR(), YearMonthIntervalType$.MODULE$.YEAR(), startField, endField)) {
                    return sign * Math.toIntExact(new StringOps(Predef$.MODULE$.augmentString(value)).toLong() * 12L);
                }
                if ("MONTH".equals(string) && IntervalUtils$.checkTargetType$1(YearMonthIntervalType$.MODULE$.MONTH(), YearMonthIntervalType$.MODULE$.MONTH(), startField, endField)) {
                    return Math.toIntExact((long)sign * new StringOps(Predef$.MODULE$.augmentString(value)).toLong());
                }
                throw MODULE$.throwIllegalIntervalFormatException(input, startField, endField, "year-month", new YearMonthIntervalType(startField, endField).typeName(), MODULE$.throwIllegalIntervalFormatException$default$6());
            }));
        }
        throw this.throwIllegalIntervalFormatException(input, startField, endField, "year-month", new YearMonthIntervalType(startField, endField).typeName(), this.throwIllegalIntervalFormatException$default$6());
    }

    public CalendarInterval fromYearMonthString(String input) {
        return this.fromYearMonthString(input, YearMonthIntervalType$.MODULE$.YEAR(), YearMonthIntervalType$.MODULE$.MONTH());
    }

    public CalendarInterval fromYearMonthString(String input, byte startField, byte endField) {
        Predef$.MODULE$.require(input != null, (Function0 & Serializable & scala.Serializable)() -> "Interval year-month string must be not null");
        int months = this.castStringToYMInterval(UTF8String.fromString((String)input), startField, endField);
        return new CalendarInterval(months, 0, 0L);
    }

    private <T> T safeToInterval(String interval, Function0<T> f) {
        Object object;
        try {
            object = f.apply();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw new IllegalArgumentException(new StringBuilder(32).append("Error parsing interval ").append(interval).append(" string: ").append(e.getMessage()).toString(), e);
            }
            throw throwable;
        }
        return (T)object;
    }

    private int toYMInterval(String year, String month, int sign) {
        return BoxesRunTime.unboxToInt(this.safeToInterval("year-month", (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            long years = MODULE$.toLongWithRange(MODULE$.yearStr(), year, 0L, 0xAAAAAAAL);
            long totalMonths = (long)sign * (years * 12L + MODULE$.toLongWithRange(MODULE$.monthStr(), month, 0L, 11L));
            return Math.toIntExact(totalMonths);
        }));
    }

    private String normalPattern() {
        return this.normalPattern;
    }

    private String dayBoundPattern() {
        return this.dayBoundPattern;
    }

    private String hourBoundPattern() {
        return this.hourBoundPattern;
    }

    private String minuteBoundPattern() {
        return this.minuteBoundPattern;
    }

    private String secondBoundPattern() {
        return this.secondBoundPattern;
    }

    private String microPattern() {
        return this.microPattern;
    }

    private String dayHourPatternString() {
        return this.dayHourPatternString;
    }

    private Regex dayHourRegex() {
        return this.dayHourRegex;
    }

    private Regex dayHourLiteralRegex() {
        return this.dayHourLiteralRegex;
    }

    private String dayMinutePatternString() {
        return this.dayMinutePatternString;
    }

    private Regex dayMinuteRegex() {
        return this.dayMinuteRegex;
    }

    private Regex dayMinuteLiteralRegex() {
        return this.dayMinuteLiteralRegex;
    }

    private String daySecondPatternString() {
        return this.daySecondPatternString;
    }

    private Regex daySecondRegex() {
        return this.daySecondRegex;
    }

    private Regex daySecondLiteralRegex() {
        return this.daySecondLiteralRegex;
    }

    private String hourMinutePatternString() {
        return this.hourMinutePatternString;
    }

    private Regex hourMinuteRegex() {
        return this.hourMinuteRegex;
    }

    private Regex hourMinuteLiteralRegex() {
        return this.hourMinuteLiteralRegex;
    }

    private String hourSecondPatternString() {
        return this.hourSecondPatternString;
    }

    private Regex hourSecondRegex() {
        return this.hourSecondRegex;
    }

    private Regex hourSecondLiteralRegex() {
        return this.hourSecondLiteralRegex;
    }

    private String minuteSecondPatternString() {
        return this.minuteSecondPatternString;
    }

    private Regex minuteSecondRegex() {
        return this.minuteSecondRegex;
    }

    private Regex minuteSecondLiteralRegex() {
        return this.minuteSecondLiteralRegex;
    }

    private String dayTimeIndividualPatternString() {
        return this.dayTimeIndividualPatternString;
    }

    private Regex dayTimeIndividualRegex() {
        return this.dayTimeIndividualRegex;
    }

    private Regex dayTimeIndividualLiteralRegex() {
        return this.dayTimeIndividualLiteralRegex;
    }

    public long castStringToDTInterval(UTF8String input, byte startField, byte endField) {
        Option option;
        Option option2;
        Option option3;
        Option option4;
        Option option5;
        Option option6;
        Option option7;
        Option option8;
        Option option9;
        Option option10;
        Option option11;
        Option option12;
        String string = input.trimAll().toString();
        Option option13 = this.dayHourRegex().unapplySeq((CharSequence)string);
        if (!option13.isEmpty() && option13.get() != null && ((LinearSeqOptimized)option13.get()).lengthCompare(3) == 0) {
            String sign = (String)((LinearSeqOptimized)option13.get()).apply(0);
            String day = (String)((LinearSeqOptimized)option13.get()).apply(1);
            String hour = (String)((LinearSeqOptimized)option13.get()).apply(2);
            if (IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.HOUR(), startField, endField)) {
                return this.toDTInterval(day, hour, "0", "0", this.finalSign(sign, this.finalSign$default$2()));
            }
        }
        if (!(option12 = this.dayHourLiteralRegex().unapplySeq((CharSequence)string)).isEmpty() && option12.get() != null && ((LinearSeqOptimized)option12.get()).lengthCompare(4) == 0) {
            String firstSign = (String)((LinearSeqOptimized)option12.get()).apply(0);
            String secondSign = (String)((LinearSeqOptimized)option12.get()).apply(1);
            String day = (String)((LinearSeqOptimized)option12.get()).apply(2);
            String hour = (String)((LinearSeqOptimized)option12.get()).apply(3);
            if (IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.HOUR(), startField, endField)) {
                return this.toDTInterval(day, hour, "0", "0", this.finalSign(firstSign, secondSign));
            }
        }
        if (!(option11 = this.dayMinuteRegex().unapplySeq((CharSequence)string)).isEmpty() && option11.get() != null && ((LinearSeqOptimized)option11.get()).lengthCompare(4) == 0) {
            String sign = (String)((LinearSeqOptimized)option11.get()).apply(0);
            String day = (String)((LinearSeqOptimized)option11.get()).apply(1);
            String hour = (String)((LinearSeqOptimized)option11.get()).apply(2);
            String minute = (String)((LinearSeqOptimized)option11.get()).apply(3);
            if (IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.MINUTE(), startField, endField)) {
                return this.toDTInterval(day, hour, minute, "0", this.finalSign(sign, this.finalSign$default$2()));
            }
        }
        if (!(option10 = this.dayMinuteLiteralRegex().unapplySeq((CharSequence)string)).isEmpty() && option10.get() != null && ((LinearSeqOptimized)option10.get()).lengthCompare(5) == 0) {
            String firstSign = (String)((LinearSeqOptimized)option10.get()).apply(0);
            String secondSign = (String)((LinearSeqOptimized)option10.get()).apply(1);
            String day = (String)((LinearSeqOptimized)option10.get()).apply(2);
            String hour = (String)((LinearSeqOptimized)option10.get()).apply(3);
            String minute = (String)((LinearSeqOptimized)option10.get()).apply(4);
            if (IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.MINUTE(), startField, endField)) {
                return this.toDTInterval(day, hour, minute, "0", this.finalSign(firstSign, secondSign));
            }
        }
        if (!(option9 = this.daySecondRegex().unapplySeq((CharSequence)string)).isEmpty() && option9.get() != null && ((LinearSeqOptimized)option9.get()).lengthCompare(6) == 0) {
            String sign = (String)((LinearSeqOptimized)option9.get()).apply(0);
            String day = (String)((LinearSeqOptimized)option9.get()).apply(1);
            String hour = (String)((LinearSeqOptimized)option9.get()).apply(2);
            String minute = (String)((LinearSeqOptimized)option9.get()).apply(3);
            String second = (String)((LinearSeqOptimized)option9.get()).apply(4);
            String micro = (String)((LinearSeqOptimized)option9.get()).apply(5);
            if (IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.SECOND(), startField, endField)) {
                return this.toDTInterval(day, hour, minute, IntervalUtils$.secondAndMicro$1(second, micro), this.finalSign(sign, this.finalSign$default$2()));
            }
        }
        if (!(option8 = this.daySecondLiteralRegex().unapplySeq((CharSequence)string)).isEmpty() && option8.get() != null && ((LinearSeqOptimized)option8.get()).lengthCompare(7) == 0) {
            String firstSign = (String)((LinearSeqOptimized)option8.get()).apply(0);
            String secondSign = (String)((LinearSeqOptimized)option8.get()).apply(1);
            String day = (String)((LinearSeqOptimized)option8.get()).apply(2);
            String hour = (String)((LinearSeqOptimized)option8.get()).apply(3);
            String minute = (String)((LinearSeqOptimized)option8.get()).apply(4);
            String second = (String)((LinearSeqOptimized)option8.get()).apply(5);
            String micro = (String)((LinearSeqOptimized)option8.get()).apply(6);
            if (IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.SECOND(), startField, endField)) {
                return this.toDTInterval(day, hour, minute, IntervalUtils$.secondAndMicro$1(second, micro), this.finalSign(firstSign, secondSign));
            }
        }
        if (!(option7 = this.hourMinuteRegex().unapplySeq((CharSequence)string)).isEmpty() && option7.get() != null && ((LinearSeqOptimized)option7.get()).lengthCompare(3) == 0) {
            String sign = (String)((LinearSeqOptimized)option7.get()).apply(0);
            String hour = (String)((LinearSeqOptimized)option7.get()).apply(1);
            String minute = (String)((LinearSeqOptimized)option7.get()).apply(2);
            if (IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.MINUTE(), startField, endField)) {
                return this.toDTInterval(hour, minute, "0", this.finalSign(sign, this.finalSign$default$2()));
            }
        }
        if (!(option6 = this.hourMinuteLiteralRegex().unapplySeq((CharSequence)string)).isEmpty() && option6.get() != null && ((LinearSeqOptimized)option6.get()).lengthCompare(4) == 0) {
            String firstSign = (String)((LinearSeqOptimized)option6.get()).apply(0);
            String secondSign = (String)((LinearSeqOptimized)option6.get()).apply(1);
            String hour = (String)((LinearSeqOptimized)option6.get()).apply(2);
            String minute = (String)((LinearSeqOptimized)option6.get()).apply(3);
            if (IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.MINUTE(), startField, endField)) {
                return this.toDTInterval(hour, minute, "0", this.finalSign(firstSign, secondSign));
            }
        }
        if (!(option5 = this.hourSecondRegex().unapplySeq((CharSequence)string)).isEmpty() && option5.get() != null && ((LinearSeqOptimized)option5.get()).lengthCompare(5) == 0) {
            String sign = (String)((LinearSeqOptimized)option5.get()).apply(0);
            String hour = (String)((LinearSeqOptimized)option5.get()).apply(1);
            String minute = (String)((LinearSeqOptimized)option5.get()).apply(2);
            String second = (String)((LinearSeqOptimized)option5.get()).apply(3);
            String micro = (String)((LinearSeqOptimized)option5.get()).apply(4);
            if (IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.SECOND(), startField, endField)) {
                return this.toDTInterval(hour, minute, IntervalUtils$.secondAndMicro$1(second, micro), this.finalSign(sign, this.finalSign$default$2()));
            }
        }
        if (!(option4 = this.hourSecondLiteralRegex().unapplySeq((CharSequence)string)).isEmpty() && option4.get() != null && ((LinearSeqOptimized)option4.get()).lengthCompare(6) == 0) {
            String firstSign = (String)((LinearSeqOptimized)option4.get()).apply(0);
            String secondSign = (String)((LinearSeqOptimized)option4.get()).apply(1);
            String hour = (String)((LinearSeqOptimized)option4.get()).apply(2);
            String minute = (String)((LinearSeqOptimized)option4.get()).apply(3);
            String second = (String)((LinearSeqOptimized)option4.get()).apply(4);
            String micro = (String)((LinearSeqOptimized)option4.get()).apply(5);
            if (IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.SECOND(), startField, endField)) {
                return this.toDTInterval(hour, minute, IntervalUtils$.secondAndMicro$1(second, micro), this.finalSign(firstSign, secondSign));
            }
        }
        if (!(option3 = this.minuteSecondRegex().unapplySeq((CharSequence)string)).isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(4) == 0) {
            String sign = (String)((LinearSeqOptimized)option3.get()).apply(0);
            String minute = (String)((LinearSeqOptimized)option3.get()).apply(1);
            String second = (String)((LinearSeqOptimized)option3.get()).apply(2);
            String micro = (String)((LinearSeqOptimized)option3.get()).apply(3);
            if (IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.MINUTE(), DayTimeIntervalType$.MODULE$.SECOND(), startField, endField)) {
                return this.toDTInterval(minute, IntervalUtils$.secondAndMicro$1(second, micro), this.finalSign(sign, this.finalSign$default$2()));
            }
        }
        if (!(option2 = this.minuteSecondLiteralRegex().unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(5) == 0) {
            String firstSign = (String)((LinearSeqOptimized)option2.get()).apply(0);
            String secondSign = (String)((LinearSeqOptimized)option2.get()).apply(1);
            String minute = (String)((LinearSeqOptimized)option2.get()).apply(2);
            String second = (String)((LinearSeqOptimized)option2.get()).apply(3);
            String micro = (String)((LinearSeqOptimized)option2.get()).apply(4);
            if (IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.MINUTE(), DayTimeIntervalType$.MODULE$.SECOND(), startField, endField)) {
                return this.toDTInterval(minute, IntervalUtils$.secondAndMicro$1(second, micro), this.finalSign(firstSign, secondSign));
            }
        }
        if (!(option = this.dayTimeIndividualRegex().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(3) == 0) {
            String firstSign = (String)((LinearSeqOptimized)option.get()).apply(0);
            String value = (String)((LinearSeqOptimized)option.get()).apply(1);
            String suffix = (String)((LinearSeqOptimized)option.get()).apply(2);
            return BoxesRunTime.unboxToLong(this.safeToInterval("day-time", (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> {
                int sign = MODULE$.finalSign(firstSign, MODULE$.finalSign$default$2());
                Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToByte((byte)startField), (Object)BoxesRunTime.boxToByte((byte)endField));
                if (tuple2 != null) {
                    byte by = BoxesRunTime.unboxToByte((Object)tuple2._1());
                    byte by2 = BoxesRunTime.unboxToByte((Object)tuple2._2());
                    if (DayTimeIntervalType$.MODULE$.DAY() == by && DayTimeIntervalType$.MODULE$.DAY() == by2 && suffix == null && value.length() <= 9) {
                        return (long)sign * new StringOps(Predef$.MODULE$.augmentString(value)).toLong() * 86400000000L;
                    }
                }
                if (tuple2 != null) {
                    byte by = BoxesRunTime.unboxToByte((Object)tuple2._1());
                    byte by3 = BoxesRunTime.unboxToByte((Object)tuple2._2());
                    if (DayTimeIntervalType$.MODULE$.HOUR() == by && DayTimeIntervalType$.MODULE$.HOUR() == by3 && suffix == null && value.length() <= 10) {
                        return (long)sign * new StringOps(Predef$.MODULE$.augmentString(value)).toLong() * 3600000000L;
                    }
                }
                if (tuple2 != null) {
                    byte by = BoxesRunTime.unboxToByte((Object)tuple2._1());
                    byte by4 = BoxesRunTime.unboxToByte((Object)tuple2._2());
                    if (DayTimeIntervalType$.MODULE$.MINUTE() == by && DayTimeIntervalType$.MODULE$.MINUTE() == by4 && suffix == null && value.length() <= 12) {
                        return (long)sign * new StringOps(Predef$.MODULE$.augmentString(value)).toLong() * 60000000L;
                    }
                }
                if (tuple2 != null) {
                    byte by = BoxesRunTime.unboxToByte((Object)tuple2._1());
                    byte by5 = BoxesRunTime.unboxToByte((Object)tuple2._2());
                    if (DayTimeIntervalType$.MODULE$.SECOND() == by && DayTimeIntervalType$.MODULE$.SECOND() == by5 && value.length() <= 13) {
                        int n = sign;
                        switch (n) {
                            case 1: {
                                return MODULE$.parseSecondNano(IntervalUtils$.secondAndMicro$1(value, suffix), MODULE$.parseSecondNano$default$2(), MODULE$.parseSecondNano$default$3());
                            }
                            case -1: {
                                return MODULE$.parseSecondNano(new StringBuilder(1).append("-").append(IntervalUtils$.secondAndMicro$1(value, suffix)).toString(), MODULE$.parseSecondNano$default$2(), MODULE$.parseSecondNano$default$3());
                            }
                        }
                        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                    }
                }
                if (tuple2 != null) {
                    throw MODULE$.throwIllegalIntervalFormatException(input, startField, endField, "day-time", new DayTimeIntervalType(startField, endField).typeName(), (Option<String>)new Some((Object)MODULE$.fallbackNotice()));
                }
                throw new MatchError((Object)tuple2);
            }));
        }
        Option option14 = this.dayTimeIndividualLiteralRegex().unapplySeq((CharSequence)string);
        if (!option14.isEmpty() && option14.get() != null && ((LinearSeqOptimized)option14.get()).lengthCompare(5) == 0) {
            String firstSign = (String)((LinearSeqOptimized)option14.get()).apply(0);
            String secondSign = (String)((LinearSeqOptimized)option14.get()).apply(1);
            String value = (String)((LinearSeqOptimized)option14.get()).apply(2);
            String suffix = (String)((LinearSeqOptimized)option14.get()).apply(3);
            String unit = (String)((LinearSeqOptimized)option14.get()).apply(4);
            return BoxesRunTime.unboxToLong(this.safeToInterval("day-time", (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> {
                int sign = MODULE$.finalSign(firstSign, secondSign);
                String string = unit.toUpperCase(Locale.ROOT);
                if ("DAY".equals(string) && suffix == null && value.length() <= 9 && IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.DAY(), startField, endField)) {
                    return (long)sign * new StringOps(Predef$.MODULE$.augmentString(value)).toLong() * 86400000000L;
                }
                if ("HOUR".equals(string) && suffix == null && value.length() <= 10 && IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.HOUR(), startField, endField)) {
                    return (long)sign * new StringOps(Predef$.MODULE$.augmentString(value)).toLong() * 3600000000L;
                }
                if ("MINUTE".equals(string) && suffix == null && value.length() <= 12 && IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.MINUTE(), DayTimeIntervalType$.MODULE$.MINUTE(), startField, endField)) {
                    return (long)sign * new StringOps(Predef$.MODULE$.augmentString(value)).toLong() * 60000000L;
                }
                if ("SECOND".equals(string) && value.length() <= 13 && IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.SECOND(), DayTimeIntervalType$.MODULE$.SECOND(), startField, endField)) {
                    int n = sign;
                    switch (n) {
                        case 1: {
                            return MODULE$.parseSecondNano(IntervalUtils$.secondAndMicro$1(value, suffix), MODULE$.parseSecondNano$default$2(), MODULE$.parseSecondNano$default$3());
                        }
                        case -1: {
                            return MODULE$.parseSecondNano(new StringBuilder(1).append("-").append(IntervalUtils$.secondAndMicro$1(value, suffix)).toString(), MODULE$.parseSecondNano$default$2(), MODULE$.parseSecondNano$default$3());
                        }
                    }
                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                }
                throw MODULE$.throwIllegalIntervalFormatException(input, startField, endField, "day-time", new DayTimeIntervalType(startField, endField).typeName(), (Option<String>)new Some((Object)MODULE$.fallbackNotice()));
            }));
        }
        throw this.throwIllegalIntervalFormatException(input, startField, endField, "day-time", new DayTimeIntervalType(startField, endField).typeName(), (Option<String>)new Some((Object)this.fallbackNotice()));
    }

    public long toDTInterval(String day, String hour, String minute, String second, int sign) {
        long micros = 0L;
        int days = (int)this.toLongWithRange(this.dayStr(), day, 0L, this.MAX_DAY());
        micros = Math.addExact(micros, (long)(sign * days) * 86400000000L);
        long hours = this.toLongWithRange(this.hourStr(), hour, 0L, 23L);
        micros = Math.addExact(micros, (long)sign * hours * 3600000000L);
        long minutes = this.toLongWithRange(this.minuteStr(), minute, 0L, 59L);
        micros = Math.addExact(micros, (long)sign * minutes * 60000000L);
        micros = Math.addExact(micros, (long)sign * this.parseSecondNano(second, 0L, 59L));
        return micros;
    }

    public long toDTInterval(String hour, String minute, String second, int sign) {
        long micros = 0L;
        long hours = this.toLongWithRange(this.hourStr(), hour, 0L, this.MAX_HOUR());
        micros = Math.addExact(micros, (long)sign * hours * 3600000000L);
        long minutes = this.toLongWithRange(this.minuteStr(), minute, 0L, 59L);
        micros = Math.addExact(micros, (long)sign * minutes * 60000000L);
        micros = Math.addExact(micros, (long)sign * this.parseSecondNano(second, 0L, 59L));
        return micros;
    }

    public long toDTInterval(String minute, String second, int sign) {
        long micros = 0L;
        long minutes = this.toLongWithRange(this.minuteStr(), minute, 0L, this.MAX_MINUTE());
        micros = Math.addExact(micros, (long)sign * minutes * 60000000L);
        micros = Math.addExact(micros, (long)sign * this.parseSecondNano(second, 0L, 59L));
        return micros;
    }

    public CalendarInterval castDayTimeStringToInterval(String input, byte startField, byte endField) {
        long micros = this.castStringToDTInterval(UTF8String.fromString((String)input), startField, endField);
        return new CalendarInterval(0, (int)(micros / 86400000000L), micros % 86400000000L);
    }

    public CalendarInterval fromDayTimeString(String s) {
        return this.fromDayTimeString(s, DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.SECOND());
    }

    public CalendarInterval fromDayTimeString(String input, byte from, byte to) {
        Predef$.MODULE$.require(input != null, (Function0 & Serializable & scala.Serializable)() -> "Interval day-time string must be not null");
        if (BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_FROM_DAYTIME_STRING()))) {
            return this.parseDayTimeLegacy(input, from, to);
        }
        return this.castDayTimeStringToInterval(input, from, to);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CalendarInterval fromIntervalString(String input) {
        try {
            Object micros;
            CalendarInterval calendarInterval;
            if (!input.toLowerCase(Locale.ROOT).trim().startsWith("interval")) {
                calendarInterval = this.stringToInterval(UTF8String.fromString((String)input));
                return calendarInterval;
            }
            boolean bl = false;
            Literal literal = null;
            Expression expression = CatalystSqlParser$.MODULE$.parseExpression(input);
            if (expression instanceof Literal) {
                bl = true;
                literal = (Literal)expression;
                Object months = literal.value();
                if (months instanceof Integer) {
                    int n = BoxesRunTime.unboxToInt((Object)months);
                    if (literal.dataType() instanceof YearMonthIntervalType) {
                        calendarInterval = new CalendarInterval(n, 0, 0L);
                        return calendarInterval;
                    }
                }
            }
            if (bl && (micros = literal.value()) instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)micros);
                if (literal.dataType() instanceof DayTimeIntervalType) {
                    calendarInterval = new CalendarInterval(0, 0, l);
                    return calendarInterval;
                }
            }
            if (!bl) throw new MatchError((Object)expression);
            Object cal = literal.value();
            DataType dataType = literal.dataType();
            if (!(cal instanceof CalendarInterval)) throw new MatchError((Object)expression);
            CalendarInterval calendarInterval2 = (CalendarInterval)cal;
            if (!CalendarIntervalType$.MODULE$.equals(dataType)) throw new MatchError((Object)expression);
            calendarInterval = calendarInterval2;
            return calendarInterval;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) throw throwable;
            Throwable e = (Throwable)option.get();
            throw QueryCompilationErrors$.MODULE$.cannotParseIntervalError(input, e);
        }
    }

    private Regex dayTimePatternLegacy() {
        return this.dayTimePatternLegacy;
    }

    private String fallbackNotice() {
        return this.fallbackNotice;
    }

    /*
     * Unable to fully structure code
     */
    private CalendarInterval parseDayTimeLegacy(String input, byte from, byte to) {
        Predef$.MODULE$.assert(input.length() == input.trim().length());
        m = this.dayTimePatternLegacy().pattern().matcher(input);
        Predef$.MODULE$.require(m.matches(), (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$parseDayTimeLegacy$1(java.lang.String ), ()Ljava/lang/String;)((String)input));
        try {
            if (m.group(1) == null) ** GOTO lbl-1000
            v0 = m.group(1);
            var7_5 = "-";
            if (!(v0 != null ? v0.equals(var7_5) == false : var7_5 != null)) {
                v1 = -1;
            } else lbl-1000:
            // 2 sources

            {
                v1 = 1;
            }
            sign = v1;
            days = m.group(2) == null ? 0 : (int)this.toLongWithRange(this.dayStr(), m.group(3), 0L, 0x7FFFFFFFL);
            hours = 0L;
            minutes = 0L;
            seconds = 0L;
            if (m.group(5) != null || from == DayTimeIntervalType$.MODULE$.MINUTE()) {
                hours = this.toLongWithRange(this.hourStr(), m.group(5), 0L, 23L);
                minutes = this.toLongWithRange(this.minuteStr(), m.group(6), 0L, 59L);
                seconds = this.toLongWithRange(this.secondStr(), m.group(7), 0L, 59L);
            } else if (m.group(8) != null) {
                minutes = this.toLongWithRange(this.minuteStr(), m.group(6), 0L, 59L);
                seconds = this.toLongWithRange(this.secondStr(), m.group(7), 0L, 59L);
            } else {
                hours = this.toLongWithRange(this.hourStr(), m.group(6), 0L, 23L);
                minutes = this.toLongWithRange(this.secondStr(), m.group(7), 0L, 59L);
            }
            secondsFraction = this.parseNanos(m.group(9), seconds < 0L);
            var17_12 = to;
            if (DayTimeIntervalType$.MODULE$.HOUR() == var17_12) {
                minutes = 0L;
                seconds = 0L;
                secondsFraction = 0L;
            } else if (DayTimeIntervalType$.MODULE$.MINUTE() == var17_12) {
                seconds = 0L;
                secondsFraction = 0L;
            } else if (DayTimeIntervalType$.MODULE$.SECOND() == var17_12) {
            } else {
                throw new IllegalArgumentException(new StringBuilder(44).append("Cannot support (").append("interval '").append(input).append("' ").append(DayTimeIntervalType$.MODULE$.fieldToString(from)).append(" to ").append(DayTimeIntervalType$.MODULE$.fieldToString(to)).append(") expression").toString());
            }
            micros = secondsFraction;
            micros = Math.addExact(micros, Math.multiplyExact(hours, 3600000000L));
            micros = Math.addExact(micros, Math.multiplyExact(minutes, 60000000L));
            micros = Math.addExact(micros, Math.multiplyExact(seconds, 1000000L));
            v2 = new CalendarInterval(0, sign * days, (long)sign * micros);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(new StringBuilder(40).append("Error parsing interval day-time string: ").append(e.getMessage()).toString(), e);
        }
        return v2;
    }

    private long parseNanos(String nanos, boolean isNegative) {
        if (nanos != null) {
            int maxNanosLen = 9;
            String alignedStr = nanos.length() < maxNanosLen ? new StringBuilder(9).append(nanos).append("000000000").toString().substring(0, maxNanosLen) : nanos;
            long nanoSecond = this.toLongWithRange(this.nanosStr(), alignedStr, 0L, 999999999L);
            long microSecond = nanoSecond / 1000L;
            if (isNegative) {
                return -microSecond;
            }
            return microSecond;
        }
        return 0L;
    }

    private long parseSecondNano(String secondNano, long minSecond, long maxSecond) {
        Option option;
        String[] stringArray = secondNano.split("\\.");
        Option option2 = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option2.isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(1) == 0) {
            String secondsStr = (String)((SeqLike)option2.get()).apply(0);
            return this.parseSeconds$1(secondsStr, minSecond, maxSecond);
        }
        Option option3 = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option3.isEmpty() && option3.get() != null && ((SeqLike)option3.get()).lengthCompare(2) == 0) {
            String string = (String)((SeqLike)option3.get()).apply(0);
            String nanosStr = (String)((SeqLike)option3.get()).apply(1);
            if ("".equals(string)) {
                return this.parseNanos(nanosStr, false);
            }
        }
        if (!(option = Array$.MODULE$.unapplySeq((Object)stringArray)).isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
            long seconds;
            String secondsStr = (String)((SeqLike)option.get()).apply(0);
            String nanosStr = (String)((SeqLike)option.get()).apply(1);
            return Math.addExact(seconds, this.parseNanos(nanosStr, (seconds = this.parseSeconds$1(secondsStr, minSecond, maxSecond)) < 0L));
        }
        throw new IllegalArgumentException("Interval string does not match second-nano format of ss.nnnnnnnnn");
    }

    private long parseSecondNano$default$2() {
        return this.MIN_SECOND();
    }

    private long parseSecondNano$default$3() {
        return this.MAX_SECOND();
    }

    public long getDuration(CalendarInterval interval, TimeUnit targetUnit, int daysPerMonth) {
        long monthsDuration = Math.multiplyExact((long)daysPerMonth * 86400000000L, interval.months);
        long daysDuration = Math.multiplyExact(86400000000L, interval.days);
        long result = Math.addExact(interval.microseconds, Math.addExact(daysDuration, monthsDuration));
        return targetUnit.convert(result, TimeUnit.MICROSECONDS);
    }

    public int getDuration$default$3() {
        return 31;
    }

    public boolean isNegative(CalendarInterval interval, int daysPerMonth) {
        return this.getDuration(interval, TimeUnit.MICROSECONDS, daysPerMonth) < 0L;
    }

    public int isNegative$default$2() {
        return 31;
    }

    private CalendarInterval fromDoubles(double monthsWithFraction, double daysWithFraction, double microsWithFraction) {
        int truncatedMonths = MathUtils$.MODULE$.toIntExact((long)monthsWithFraction);
        int truncatedDays = MathUtils$.MODULE$.toIntExact((long)daysWithFraction);
        double micros = microsWithFraction + (double)86400000000L * (daysWithFraction - (double)truncatedDays);
        return new CalendarInterval(truncatedMonths, truncatedDays, RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(micros)));
    }

    private CalendarInterval safeFromDoubles(double monthsWithFraction, double daysWithFraction, double microsWithFraction) {
        int truncatedDays = (int)daysWithFraction;
        double micros = microsWithFraction + (double)86400000000L * (daysWithFraction - (double)truncatedDays);
        return new CalendarInterval((int)monthsWithFraction, truncatedDays, RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(micros)));
    }

    public CalendarInterval negateExact(CalendarInterval interval) {
        int months = MathUtils$.MODULE$.negateExact(interval.months);
        int days = MathUtils$.MODULE$.negateExact(interval.days);
        long microseconds = MathUtils$.MODULE$.negateExact(interval.microseconds);
        return new CalendarInterval(months, days, microseconds);
    }

    public CalendarInterval negate(CalendarInterval interval) {
        return new CalendarInterval(-interval.months, -interval.days, -interval.microseconds);
    }

    public CalendarInterval addExact(CalendarInterval left, CalendarInterval right) {
        int months = MathUtils$.MODULE$.addExact(left.months, right.months);
        int days = MathUtils$.MODULE$.addExact(left.days, right.days);
        long microseconds = MathUtils$.MODULE$.addExact(left.microseconds, right.microseconds);
        return new CalendarInterval(months, days, microseconds);
    }

    public CalendarInterval add(CalendarInterval left, CalendarInterval right) {
        int months = left.months + right.months;
        int days = left.days + right.days;
        long microseconds = left.microseconds + right.microseconds;
        return new CalendarInterval(months, days, microseconds);
    }

    public CalendarInterval subtractExact(CalendarInterval left, CalendarInterval right) {
        int months = MathUtils$.MODULE$.subtractExact(left.months, right.months);
        int days = MathUtils$.MODULE$.subtractExact(left.days, right.days);
        long microseconds = MathUtils$.MODULE$.subtractExact(left.microseconds, right.microseconds);
        return new CalendarInterval(months, days, microseconds);
    }

    public CalendarInterval subtract(CalendarInterval left, CalendarInterval right) {
        int months = left.months - right.months;
        int days = left.days - right.days;
        long microseconds = left.microseconds - right.microseconds;
        return new CalendarInterval(months, days, microseconds);
    }

    public CalendarInterval multiply(CalendarInterval interval, double num) {
        return this.safeFromDoubles(num * (double)interval.months, num * (double)interval.days, num * (double)interval.microseconds);
    }

    public CalendarInterval multiplyExact(CalendarInterval interval, double num) {
        return this.fromDoubles(num * (double)interval.months, num * (double)interval.days, num * (double)interval.microseconds);
    }

    public CalendarInterval divide(CalendarInterval interval, double num) {
        if (num == 0.0) {
            return null;
        }
        return this.safeFromDoubles((double)interval.months / num, (double)interval.days / num, (double)interval.microseconds / num);
    }

    public CalendarInterval divideExact(CalendarInterval interval, double num) {
        if (num == 0.0) {
            throw QueryExecutionErrors$.MODULE$.intervalDividedByZeroError(null);
        }
        return this.fromDoubles((double)interval.months / num, (double)interval.days / num, (double)interval.microseconds / num);
    }

    public CalendarInterval safeStringToInterval(UTF8String input) {
        CalendarInterval calendarInterval;
        try {
            calendarInterval = this.stringToInterval(input);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            calendarInterval = null;
        }
        return calendarInterval;
    }

    public CalendarInterval makeInterval(int years, int months, int weeks, int days, int hours, int mins, Decimal secs) {
        int totalMonths = Math.addExact(months, Math.multiplyExact(years, 12));
        int totalDays = Math.addExact(days, Math.multiplyExact(weeks, 7));
        Predef$.MODULE$.assert(secs.scale() == 6, (Function0 & Serializable & scala.Serializable)() -> "Seconds fractional must have 6 digits for microseconds");
        long micros = secs.toUnscaledLong();
        micros = Math.addExact(micros, Math.multiplyExact((long)hours, 3600000000L));
        micros = Math.addExact(micros, Math.multiplyExact((long)mins, 60000000L));
        return new CalendarInterval(totalMonths, totalDays, micros);
    }

    public long makeDayTimeInterval(int days, int hours, int mins, Decimal secs) {
        Predef$.MODULE$.assert(secs.scale() == 6, (Function0 & Serializable & scala.Serializable)() -> "Seconds fractional must have 6 digits for microseconds");
        long micros = secs.toUnscaledLong();
        micros = Math.addExact(micros, Math.multiplyExact((long)days, 86400000000L));
        micros = Math.addExact(micros, Math.multiplyExact((long)hours, 3600000000L));
        micros = Math.addExact(micros, Math.multiplyExact((long)mins, 60000000L));
        return micros;
    }

    public int intToYearMonthInterval(int v, byte startField, byte endField) {
        byte by = endField;
        if (YearMonthIntervalType$.MODULE$.YEAR() == by) {
            int n;
            try {
                n = Math.multiplyExact(v, 12);
            }
            catch (ArithmeticException arithmeticException) {
                throw QueryExecutionErrors$.MODULE$.castingCauseOverflowError(BoxesRunTime.boxToInteger((int)v), (DataType)IntegerType$.MODULE$, (DataType)new YearMonthIntervalType(startField, endField));
            }
            return n;
        }
        if (YearMonthIntervalType$.MODULE$.MONTH() == by) {
            return v;
        }
        throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
    }

    public int longToYearMonthInterval(long v, byte startField, byte endField) {
        int vInt = (int)v;
        if (v != (long)vInt) {
            throw QueryExecutionErrors$.MODULE$.castingCauseOverflowError(BoxesRunTime.boxToLong((long)v), (DataType)LongType$.MODULE$, (DataType)new YearMonthIntervalType(startField, endField));
        }
        return this.intToYearMonthInterval(vInt, startField, endField);
    }

    public int decimalToYearMonthInterval(Decimal d, int p, int s, byte startField, byte endField) {
        int n;
        try {
            BigDecimal months = endField == YearMonthIntervalType$.MODULE$.YEAR() ? d.toBigDecimal().$times(BigDecimal$.MODULE$.int2bigDecimal(12)) : d.toBigDecimal();
            n = months.setScale(0, BigDecimal.RoundingMode$.MODULE$.HALF_UP()).toIntExact();
        }
        catch (ArithmeticException arithmeticException) {
            throw QueryExecutionErrors$.MODULE$.castingCauseOverflowError(d, (DataType)new DecimalType(p, s), (DataType)new YearMonthIntervalType(startField, endField));
        }
        return n;
    }

    public int yearMonthIntervalToInt(int v, byte startField, byte endField) {
        byte by = endField;
        if (YearMonthIntervalType$.MODULE$.YEAR() == by) {
            return v / 12;
        }
        if (YearMonthIntervalType$.MODULE$.MONTH() == by) {
            return v;
        }
        throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
    }

    public short yearMonthIntervalToShort(int v, byte startField, byte endField) {
        short vShort;
        int vInt = this.yearMonthIntervalToInt(v, startField, endField);
        if (vInt != (vShort = (short)vInt)) {
            throw QueryExecutionErrors$.MODULE$.castingCauseOverflowError(BoxesRunTime.boxToInteger((int)v), (DataType)new YearMonthIntervalType(startField, endField), (DataType)ShortType$.MODULE$);
        }
        return vShort;
    }

    public byte yearMonthIntervalToByte(int v, byte startField, byte endField) {
        byte vByte;
        int vInt = this.yearMonthIntervalToInt(v, startField, endField);
        if (vInt != (vByte = (byte)vInt)) {
            throw QueryExecutionErrors$.MODULE$.castingCauseOverflowError(BoxesRunTime.boxToInteger((int)v), (DataType)new YearMonthIntervalType(startField, endField), (DataType)ByteType$.MODULE$);
        }
        return vByte;
    }

    public long intToDayTimeInterval(int v, byte startField, byte endField) {
        byte by = endField;
        if (DayTimeIntervalType$.MODULE$.DAY() == by) {
            long l;
            try {
                l = Math.multiplyExact((long)v, 86400000000L);
            }
            catch (ArithmeticException arithmeticException) {
                throw QueryExecutionErrors$.MODULE$.castingCauseOverflowError(BoxesRunTime.boxToInteger((int)v), (DataType)IntegerType$.MODULE$, (DataType)new DayTimeIntervalType(startField, endField));
            }
            return l;
        }
        if (DayTimeIntervalType$.MODULE$.HOUR() == by) {
            return (long)v * 3600000000L;
        }
        if (DayTimeIntervalType$.MODULE$.MINUTE() == by) {
            return (long)v * 60000000L;
        }
        if (DayTimeIntervalType$.MODULE$.SECOND() == by) {
            return (long)v * 1000000L;
        }
        throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
    }

    public long longToDayTimeInterval(long v, byte startField, byte endField) {
        long l;
        block6: {
            try {
                byte by = endField;
                if (DayTimeIntervalType$.MODULE$.DAY() == by) {
                    l = Math.multiplyExact(v, 86400000000L);
                    break block6;
                }
                if (DayTimeIntervalType$.MODULE$.HOUR() == by) {
                    l = Math.multiplyExact(v, 3600000000L);
                    break block6;
                }
                if (DayTimeIntervalType$.MODULE$.MINUTE() == by) {
                    l = Math.multiplyExact(v, 60000000L);
                    break block6;
                }
                if (DayTimeIntervalType$.MODULE$.SECOND() == by) {
                    l = Math.multiplyExact(v, 1000000L);
                    break block6;
                }
                throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
            }
            catch (ArithmeticException arithmeticException) {
                throw QueryExecutionErrors$.MODULE$.castingCauseOverflowError(BoxesRunTime.boxToLong((long)v), (DataType)LongType$.MODULE$, (DataType)new DayTimeIntervalType(startField, endField));
            }
        }
        return l;
    }

    public long dayTimeIntervalToLong(long v, byte startField, byte endField) {
        byte by = endField;
        if (DayTimeIntervalType$.MODULE$.DAY() == by) {
            return v / 86400000000L;
        }
        if (DayTimeIntervalType$.MODULE$.HOUR() == by) {
            return v / 3600000000L;
        }
        if (DayTimeIntervalType$.MODULE$.MINUTE() == by) {
            return v / 60000000L;
        }
        if (DayTimeIntervalType$.MODULE$.SECOND() == by) {
            return v / 1000000L;
        }
        throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
    }

    public Decimal dayTimeIntervalToDecimal(long v, byte endField) {
        byte by = endField;
        if (DayTimeIntervalType$.MODULE$.DAY() == by) {
            return Decimal$.MODULE$.apply(v / 86400000000L);
        }
        if (DayTimeIntervalType$.MODULE$.HOUR() == by) {
            return Decimal$.MODULE$.apply(v / 3600000000L);
        }
        if (DayTimeIntervalType$.MODULE$.MINUTE() == by) {
            return Decimal$.MODULE$.apply(v / 60000000L);
        }
        if (DayTimeIntervalType$.MODULE$.SECOND() == by) {
            return Decimal$.MODULE$.apply(v, Decimal$.MODULE$.MAX_LONG_DIGITS(), 6);
        }
        throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
    }

    public long decimalToDayTimeInterval(Decimal d, int p, int s, byte startField, byte endField) {
        long l;
        try {
            BigDecimal bigDecimal;
            byte by = endField;
            if (DayTimeIntervalType$.MODULE$.DAY() == by) {
                bigDecimal = d.toBigDecimal().$times(BigDecimal$.MODULE$.long2bigDecimal(86400000000L));
            } else if (DayTimeIntervalType$.MODULE$.HOUR() == by) {
                bigDecimal = d.toBigDecimal().$times(BigDecimal$.MODULE$.long2bigDecimal(3600000000L));
            } else if (DayTimeIntervalType$.MODULE$.MINUTE() == by) {
                bigDecimal = d.toBigDecimal().$times(BigDecimal$.MODULE$.long2bigDecimal(60000000L));
            } else if (DayTimeIntervalType$.MODULE$.SECOND() == by) {
                bigDecimal = d.toBigDecimal().$times(BigDecimal$.MODULE$.long2bigDecimal(1000000L));
            } else {
                throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
            }
            BigDecimal micros = bigDecimal;
            l = micros.setScale(0, BigDecimal.RoundingMode$.MODULE$.HALF_UP()).toLongExact();
        }
        catch (ArithmeticException arithmeticException) {
            throw QueryExecutionErrors$.MODULE$.castingCauseOverflowError(d, (DataType)new DecimalType(p, s), (DataType)new DayTimeIntervalType(startField, endField));
        }
        return l;
    }

    public int dayTimeIntervalToInt(long v, byte startField, byte endField) {
        int vInt;
        long vLong = this.dayTimeIntervalToLong(v, startField, endField);
        if (vLong != (long)(vInt = (int)vLong)) {
            throw QueryExecutionErrors$.MODULE$.castingCauseOverflowError(BoxesRunTime.boxToLong((long)v), (DataType)new DayTimeIntervalType(startField, endField), (DataType)IntegerType$.MODULE$);
        }
        return vInt;
    }

    public short dayTimeIntervalToShort(long v, byte startField, byte endField) {
        short vShort;
        long vLong = this.dayTimeIntervalToLong(v, startField, endField);
        if (vLong != (long)(vShort = (short)vLong)) {
            throw QueryExecutionErrors$.MODULE$.castingCauseOverflowError(BoxesRunTime.boxToLong((long)v), (DataType)new DayTimeIntervalType(startField, endField), (DataType)ShortType$.MODULE$);
        }
        return vShort;
    }

    public byte dayTimeIntervalToByte(long v, byte startField, byte endField) {
        byte vByte;
        long vLong = this.dayTimeIntervalToLong(v, startField, endField);
        if (vLong != (long)(vByte = (byte)vLong)) {
            throw QueryExecutionErrors$.MODULE$.castingCauseOverflowError(BoxesRunTime.boxToLong((long)v), (DataType)new DayTimeIntervalType(startField, endField), (DataType)ByteType$.MODULE$);
        }
        return vByte;
    }

    private final void org$apache$spark$sql$catalyst$util$SparkIntervalUtils$$ParseState$lzycompute$1() {
        IntervalUtils$ intervalUtils$ = this;
        synchronized (intervalUtils$) {
            if (this.ParseState$module == null) {
                this.ParseState$module = new SparkIntervalUtils$ParseState$((SparkIntervalUtils)this);
            }
        }
    }

    private static final boolean checkTargetType$1(byte targetStartField, byte targetEndField, byte startField$1, byte endField$1) {
        return startField$1 == targetStartField && endField$1 == targetEndField;
    }

    private static final String secondAndMicro$1(String second, String micro) {
        if (micro != null) {
            return new StringBuilder(0).append(second).append(micro).toString();
        }
        return second;
    }

    private static final boolean checkTargetType$2(byte targetStartField, byte targetEndField, byte startField$2, byte endField$2) {
        return startField$2 == targetStartField && endField$2 == targetEndField;
    }

    public static final /* synthetic */ String $anonfun$parseDayTimeLegacy$1(String input$3) {
        return new StringBuilder(61).append("Interval string must match day-time format of 'd h:m:s.n': ").append(input$3).append(", ").append(MODULE$.fallbackNotice()).toString();
    }

    private final long parseSeconds$1(String secondsStr, long minSecond$1, long maxSecond$1) {
        return this.toLongWithRange(this.secondStr(), secondsStr, minSecond$1, maxSecond$1) * 1000000L;
    }

    private IntervalUtils$() {
        MODULE$ = this;
        SparkIntervalUtils.$init$((SparkIntervalUtils)this);
        this.yearMonthPatternString = "([+|-])?(\\d+)-(\\d+)";
        this.yearMonthRegex = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(2).append("^").append(this.yearMonthPatternString()).append("$").toString())).r();
        this.yearMonthLiteralRegex = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(47).append("(?i)^INTERVAL\\s+([+|-])?'").append(this.yearMonthPatternString()).append("'\\s+YEAR\\s+TO\\s+MONTH$").toString())).r();
        this.yearMonthIndividualPatternString = "([+|-])?(\\d+)";
        this.yearMonthIndividualRegex = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(2).append("^").append(this.yearMonthIndividualPatternString()).append("$").toString())).r();
        this.yearMonthIndividualLiteralRegex = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(42).append("(?i)^INTERVAL\\s+([+|-])?'").append(this.yearMonthIndividualPatternString()).append("'\\s+(YEAR|MONTH)$").toString())).r();
        this.supportedFormat = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"year-month", (Object)BoxesRunTime.boxToByte((byte)YearMonthIntervalType$.MODULE$.YEAR()), (Object)BoxesRunTime.boxToByte((byte)YearMonthIntervalType$.MODULE$.MONTH()))), (Object)new .colon.colon((Object)"[+|-]y-m", (List)new .colon.colon((Object)"INTERVAL [+|-]'[+|-]y-m' YEAR TO MONTH", (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"year-month", (Object)BoxesRunTime.boxToByte((byte)YearMonthIntervalType$.MODULE$.YEAR()), (Object)BoxesRunTime.boxToByte((byte)YearMonthIntervalType$.MODULE$.YEAR()))), (Object)new .colon.colon((Object)"[+|-]y", (List)new .colon.colon((Object)"INTERVAL [+|-]'[+|-]y' YEAR", (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"year-month", (Object)BoxesRunTime.boxToByte((byte)YearMonthIntervalType$.MODULE$.MONTH()), (Object)BoxesRunTime.boxToByte((byte)YearMonthIntervalType$.MODULE$.MONTH()))), (Object)new .colon.colon((Object)"[+|-]m", (List)new .colon.colon((Object)"INTERVAL [+|-]'[+|-]m' MONTH", (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"day-time", (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.DAY()), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.DAY()))), (Object)new .colon.colon((Object)"[+|-]d", (List)new .colon.colon((Object)"INTERVAL [+|-]'[+|-]d' DAY", (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"day-time", (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.DAY()), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.HOUR()))), (Object)new .colon.colon((Object)"[+|-]d h", (List)new .colon.colon((Object)"INTERVAL [+|-]'[+|-]d h' DAY TO HOUR", (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"day-time", (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.DAY()), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.MINUTE()))), (Object)new .colon.colon((Object)"[+|-]d h:m", (List)new .colon.colon((Object)"INTERVAL [+|-]'[+|-]d h:m' DAY TO MINUTE", (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"day-time", (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.DAY()), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.SECOND()))), (Object)new .colon.colon((Object)"[+|-]d h:m:s.n", (List)new .colon.colon((Object)"INTERVAL [+|-]'[+|-]d h:m:s.n' DAY TO SECOND", (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"day-time", (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.HOUR()), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.HOUR()))), (Object)new .colon.colon((Object)"[+|-]h", (List)new .colon.colon((Object)"INTERVAL [+|-]'[+|-]h' HOUR", (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"day-time", (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.HOUR()), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.MINUTE()))), (Object)new .colon.colon((Object)"[+|-]h:m", (List)new .colon.colon((Object)"INTERVAL [+|-]'[+|-]h:m' HOUR TO MINUTE", (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"day-time", (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.HOUR()), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.SECOND()))), (Object)new .colon.colon((Object)"[+|-]h:m:s.n", (List)new .colon.colon((Object)"INTERVAL [+|-]'[+|-]h:m:s.n' HOUR TO SECOND", (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"day-time", (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.MINUTE()), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.MINUTE()))), (Object)new .colon.colon((Object)"[+|-]m", (List)new .colon.colon((Object)"INTERVAL [+|-]'[+|-]m' MINUTE", (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"day-time", (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.MINUTE()), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.SECOND()))), (Object)new .colon.colon((Object)"[+|-]m:s.n", (List)new .colon.colon((Object)"INTERVAL [+|-]'[+|-]m:s.n' MINUTE TO SECOND", (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"day-time", (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.SECOND()), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.SECOND()))), (Object)new .colon.colon((Object)"[+|-]s.n", (List)new .colon.colon((Object)"INTERVAL [+|-]'[+|-]s.n' SECOND", (List)Nil$.MODULE$)))}));
        this.normalPattern = "(\\d{1,2})";
        this.dayBoundPattern = "(\\d{1,9})";
        this.hourBoundPattern = "(\\d{1,10})";
        this.minuteBoundPattern = "(\\d{1,12})";
        this.secondBoundPattern = "(\\d{1,13})";
        this.microPattern = "(\\.\\d{1,9})";
        this.dayHourPatternString = new StringBuilder(9).append("([+|-])?").append(this.dayBoundPattern()).append(" ").append(this.normalPattern()).toString();
        this.dayHourRegex = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(2).append("^").append(this.dayHourPatternString()).append("$").toString())).r();
        this.dayHourLiteralRegex = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(47).append("(?i)^INTERVAL\\s+([+|-])?\\'").append(this.dayHourPatternString()).append("\\'\\s+DAY\\s+TO\\s+HOUR$").toString())).r();
        this.dayMinutePatternString = new StringBuilder(10).append("([+|-])?").append(this.dayBoundPattern()).append(" ").append(this.normalPattern()).append(":").append(this.normalPattern()).toString();
        this.dayMinuteRegex = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(2).append("^").append(this.dayMinutePatternString()).append("$").toString())).r();
        this.dayMinuteLiteralRegex = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(49).append("(?i)^INTERVAL\\s+([+|-])?\\'").append(this.dayMinutePatternString()).append("\\'\\s+DAY\\s+TO\\s+MINUTE$").toString())).r();
        this.daySecondPatternString = new StringBuilder(12).append("([+|-])?").append(this.dayBoundPattern()).append(" ").append(this.normalPattern()).append(":").append(this.normalPattern()).append(":").append(this.normalPattern()).append(this.microPattern()).append("?").toString();
        this.daySecondRegex = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(2).append("^").append(this.daySecondPatternString()).append("$").toString())).r();
        this.daySecondLiteralRegex = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(49).append("(?i)^INTERVAL\\s+([+|-])?\\'").append(this.daySecondPatternString()).append("\\'\\s+DAY\\s+TO\\s+SECOND$").toString())).r();
        this.hourMinutePatternString = new StringBuilder(9).append("([+|-])?").append(this.hourBoundPattern()).append(":").append(this.normalPattern()).toString();
        this.hourMinuteRegex = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(2).append("^").append(this.hourMinutePatternString()).append("$").toString())).r();
        this.hourMinuteLiteralRegex = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(50).append("(?i)^INTERVAL\\s+([+|-])?\\'").append(this.hourMinutePatternString()).append("\\'\\s+HOUR\\s+TO\\s+MINUTE$").toString())).r();
        this.hourSecondPatternString = new StringBuilder(11).append("([+|-])?").append(this.hourBoundPattern()).append(":").append(this.normalPattern()).append(":").append(this.normalPattern()).append(this.microPattern()).append("?").toString();
        this.hourSecondRegex = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(2).append("^").append(this.hourSecondPatternString()).append("$").toString())).r();
        this.hourSecondLiteralRegex = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(50).append("(?i)^INTERVAL\\s+([+|-])?\\'").append(this.hourSecondPatternString()).append("\\'\\s+HOUR\\s+TO\\s+SECOND$").toString())).r();
        this.minuteSecondPatternString = new StringBuilder(10).append("([+|-])?").append(this.minuteBoundPattern()).append(":").append(this.normalPattern()).append(this.microPattern()).append("?").toString();
        this.minuteSecondRegex = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(2).append("^").append(this.minuteSecondPatternString()).append("$").toString())).r();
        this.minuteSecondLiteralRegex = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(52).append("(?i)^INTERVAL\\s+([+|-])?\\'").append(this.minuteSecondPatternString()).append("\\'\\s+MINUTE\\s+TO\\s+SECOND$").toString())).r();
        this.dayTimeIndividualPatternString = new StringBuilder(20).append("([+|-])?").append(this.secondBoundPattern()).append("(\\.\\d{1,9})?").toString();
        this.dayTimeIndividualRegex = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(2).append("^").append(this.dayTimeIndividualPatternString()).append("$").toString())).r();
        this.dayTimeIndividualLiteralRegex = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(54).append("(?i)^INTERVAL\\s+([+|-])?'").append(this.dayTimeIndividualPatternString()).append("'\\s+(DAY|HOUR|MINUTE|SECOND)$").toString())).r();
        this.dayTimePatternLegacy = new StringOps(Predef$.MODULE$.augmentString("^([+|-])?((\\d+) )?((\\d+):)?(\\d+):(\\d+)(\\.(\\d+))?$")).r();
        this.fallbackNotice = new StringBuilder(54).append("set ").append(SQLConf$.MODULE$.LEGACY_FROM_DAYTIME_STRING().key()).append(" to true ").append("to restore the behavior before Spark 3.0.").toString();
    }
}

