/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.encoders;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoder;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ObjectType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;

public final class EncoderUtils$ {
    public static EncoderUtils$ MODULE$;
    private final Map<DataType, Class<?>> typeJavaMapping;
    private final Map<DataType, Class<?>> typeBoxedJavaMapping;

    static {
        new EncoderUtils$();
    }

    public DataType externalDataTypeFor(AgnosticEncoder<?> enc) {
        return this.externalDataTypeFor(enc, false);
    }

    public DataType lenientExternalDataTypeFor(AgnosticEncoder<?> enc) {
        return this.externalDataTypeFor(enc, enc.lenientSerialization());
    }

    private DataType externalDataTypeFor(AgnosticEncoder<?> enc, boolean lenientSerialization) {
        if (this.isNativeEncoder(enc)) {
            return enc.dataType();
        }
        if (lenientSerialization) {
            return new ObjectType(Object.class);
        }
        return new ObjectType(enc.clsTag().runtimeClass());
    }

    public boolean isNativeEncoder(AgnosticEncoder<?> enc) {
        AgnosticEncoder<?> agnosticEncoder = enc;
        if (AgnosticEncoders.PrimitiveBooleanEncoder$.MODULE$.equals(agnosticEncoder)) {
            return true;
        }
        if (AgnosticEncoders.PrimitiveByteEncoder$.MODULE$.equals(agnosticEncoder)) {
            return true;
        }
        if (AgnosticEncoders.PrimitiveShortEncoder$.MODULE$.equals(agnosticEncoder)) {
            return true;
        }
        if (AgnosticEncoders.PrimitiveIntEncoder$.MODULE$.equals(agnosticEncoder)) {
            return true;
        }
        if (AgnosticEncoders.PrimitiveLongEncoder$.MODULE$.equals(agnosticEncoder)) {
            return true;
        }
        if (AgnosticEncoders.PrimitiveFloatEncoder$.MODULE$.equals(agnosticEncoder)) {
            return true;
        }
        if (AgnosticEncoders.PrimitiveDoubleEncoder$.MODULE$.equals(agnosticEncoder)) {
            return true;
        }
        if (AgnosticEncoders.NullEncoder$.MODULE$.equals(agnosticEncoder)) {
            return true;
        }
        if (AgnosticEncoders.CalendarIntervalEncoder$.MODULE$.equals(agnosticEncoder)) {
            return true;
        }
        if (AgnosticEncoders.BinaryEncoder$.MODULE$.equals(agnosticEncoder)) {
            return true;
        }
        return agnosticEncoder instanceof AgnosticEncoders.SparkDecimalEncoder;
    }

    public Class<?> dataTypeJavaClass(DataType dt) {
        DataType dataType = dt;
        if (dataType instanceof DecimalType) {
            return Decimal.class;
        }
        if (dataType instanceof DayTimeIntervalType) {
            return Long.TYPE;
        }
        if (dataType instanceof YearMonthIntervalType) {
            return Integer.TYPE;
        }
        if (dataType instanceof StructType) {
            return InternalRow.class;
        }
        if (dataType instanceof ArrayType) {
            return ArrayData.class;
        }
        if (dataType instanceof MapType) {
            return MapData.class;
        }
        if (dataType instanceof ObjectType) {
            ObjectType objectType = (ObjectType)dataType;
            Class cls = objectType.cls();
            return cls;
        }
        return (Class)this.typeJavaMapping().getOrElse((Object)dt, (Function0 & Serializable & scala.Serializable)() -> Object.class);
    }

    public Class<?> javaBoxedType(DataType dt) {
        DataType dataType;
        while (true) {
            if ((dataType = dt) instanceof DecimalType) {
                return Decimal.class;
            }
            if (dataType instanceof DayTimeIntervalType) {
                return Long.class;
            }
            if (dataType instanceof YearMonthIntervalType) {
                return Integer.class;
            }
            if (BinaryType$.MODULE$.equals(dataType)) {
                return byte[].class;
            }
            if (StringType$.MODULE$.equals(dataType)) {
                return UTF8String.class;
            }
            if (CalendarIntervalType$.MODULE$.equals(dataType)) {
                return CalendarInterval.class;
            }
            if (dataType instanceof StructType) {
                return InternalRow.class;
            }
            if (dataType instanceof ArrayType) {
                return ArrayData.class;
            }
            if (dataType instanceof MapType) {
                return MapData.class;
            }
            if (!(dataType instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType;
            dt = userDefinedType.sqlType();
        }
        if (dataType instanceof ObjectType) {
            ObjectType objectType = (ObjectType)dataType;
            Class cls = objectType.cls();
            return cls;
        }
        return (Class)this.typeBoxedJavaMapping().getOrElse((Object)dt, (Function0 & Serializable & scala.Serializable)() -> Object.class);
    }

    public Seq<Class<?>> expressionJavaClasses(Seq<Expression> arguments) {
        Seq<Expression> seq = arguments;
        Nil$ nil$ = Nil$.MODULE$;
        if (seq == null ? nil$ != null : !seq.equals((Object)nil$)) {
            return (Seq)arguments.map((Function1 & Serializable & scala.Serializable)e -> MODULE$.dataTypeJavaClass(e.dataType()), Seq$.MODULE$.canBuildFrom());
        }
        return (Seq)Nil$.MODULE$;
    }

    public Map<DataType, Class<?>> typeJavaMapping() {
        return this.typeJavaMapping;
    }

    public Map<DataType, Class<?>> typeBoxedJavaMapping() {
        return this.typeBoxedJavaMapping;
    }

    private EncoderUtils$() {
        MODULE$ = this;
        this.typeJavaMapping = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BooleanType$.MODULE$), Boolean.TYPE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ByteType$.MODULE$), Byte.TYPE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ShortType$.MODULE$), Short.TYPE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)IntegerType$.MODULE$), Integer.TYPE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LongType$.MODULE$), Long.TYPE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)FloatType$.MODULE$), Float.TYPE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DoubleType$.MODULE$), Double.TYPE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StringType$.MODULE$), UTF8String.class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DateType$.MODULE$), Integer.TYPE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TimestampType$.MODULE$), Long.TYPE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TimestampNTZType$.MODULE$), Long.TYPE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BinaryType$.MODULE$), byte[].class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)CalendarIntervalType$.MODULE$), CalendarInterval.class)}));
        this.typeBoxedJavaMapping = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BooleanType$.MODULE$), Boolean.class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ByteType$.MODULE$), Byte.class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ShortType$.MODULE$), Short.class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)IntegerType$.MODULE$), Integer.class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LongType$.MODULE$), Long.class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)FloatType$.MODULE$), Float.class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DoubleType$.MODULE$), Double.class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DateType$.MODULE$), Integer.class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TimestampType$.MODULE$), Long.class), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TimestampNTZType$.MODULE$), Long.class)}));
    }
}

