/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.BitmapExpressionUtils;
import org.apache.spark.sql.catalyst.expressions.BitmapOrAgg$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ImperativeAggregate;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ExpressionDescription(usage="\n    _FUNC_(child) - Returns a bitmap that is the bitwise OR of all of the bitmaps from the child\n    expression. The input should be bitmaps created from bitmap_construct_agg().\n  ", examples="\n    Examples:\n      > SELECT substring(hex(_FUNC_(col)), 0, 6) FROM VALUES (X '10'), (X '20'), (X '40') AS tab(col);\n       700000\n      > SELECT substring(hex(_FUNC_(col)), 0, 6) FROM VALUES (X '10'), (X '10'), (X '10') AS tab(col);\n       100000\n  ", since="3.5.0", group="agg_funcs")
@ScalaSignature(bytes="\u0006\u0001\tEd\u0001\u0002\u00192\u0001zB\u0001\u0002\u0017\u0001\u0003\u0016\u0004%\t!\u0017\u0005\t5\u0002\u0011\t\u0012)A\u0005\u0017\"A1\f\u0001BK\u0002\u0013\u0005A\f\u0003\u0005a\u0001\tE\t\u0015!\u0003^\u0011!\t\u0007A!f\u0001\n\u0003a\u0006\u0002\u00032\u0001\u0005#\u0005\u000b\u0011B/\t\u000b\r\u0004A\u0011\u00013\t\u000b\r\u0004A\u0011A5\t\u000b-\u0004A\u0011\t7\t\u000bM\u0004A\u0011\t;\t\u000bm\u0004A\u0011\t?\t\u000f\u0005E\u0001\u0001\"\u0015\u0002\u0014!9\u0011\u0011\u0004\u0001\u0005B\u0005m\u0001bBA\u0011\u0001\u0011\u0005\u00131\u0005\u0005\b\u0003S\u0001A\u0011IA\u0016\u0011\u001d\t\u0019\u0004\u0001C!\u0003kA\u0011\"!\u0010\u0001\u0005\u0004%I!a\u0010\t\u0011\u0005\u001d\u0003\u0001)A\u0005\u0003\u0003Bq!!\u0013\u0001\t\u0003\nY\u0005C\u0004\u0002`\u0001!\t%!\u0019\t\u0013\u0005=\u0004A1A\u0005B\u0005-\u0003\u0002CA9\u0001\u0001\u0006I!!\u0014\t\u000f\u0005M\u0004\u0001\"\u0011\u0002v!9\u0011\u0011\u0012\u0001\u0005B\u0005-\u0005bBAJ\u0001\u0011\u0005\u0013Q\u0013\u0005\b\u0003?\u0003A\u0011IAQ\u0011%\tY\u000bAA\u0001\n\u0003\ti\u000bC\u0005\u00026\u0002\t\n\u0011\"\u0001\u00028\"I\u0011Q\u001a\u0001\u0012\u0002\u0013\u0005\u0011q\u001a\u0005\n\u0003'\u0004\u0011\u0013!C\u0001\u0003\u001fD\u0011\"!6\u0001\u0003\u0003%\t%a6\t\u0011\u0005\u001d\b!!A\u0005\u0002qC\u0011\"!;\u0001\u0003\u0003%\t!a;\t\u0013\u0005E\b!!A\u0005B\u0005M\b\"\u0003B\u0001\u0001\u0005\u0005I\u0011\u0001B\u0002\u0011%\u00119\u0001AA\u0001\n\u0003\u0012IaB\u0005\u0003.E\n\t\u0011#\u0001\u00030\u0019A\u0001'MA\u0001\u0012\u0003\u0011\t\u0004\u0003\u0004dM\u0011\u0005!q\b\u0005\n\u0005\u00032\u0013\u0011!C#\u0005\u0007B\u0011B!\u0012'\u0003\u0003%\tIa\u0012\t\u0013\t=c%%A\u0005\u0002\u0005=\u0007\"\u0003B)ME\u0005I\u0011AAh\u0011%\u0011\u0019FJA\u0001\n\u0003\u0013)\u0006C\u0005\u0003d\u0019\n\n\u0011\"\u0001\u0002P\"I!Q\r\u0014\u0012\u0002\u0013\u0005\u0011q\u001a\u0005\n\u0005O2\u0013\u0011!C\u0005\u0005S\u00121BQ5u[\u0006\u0004xJ]!hO*\u0011!gM\u0001\fKb\u0004(/Z:tS>t7O\u0003\u00025k\u0005A1-\u0019;bYf\u001cHO\u0003\u00027o\u0005\u00191/\u001d7\u000b\u0005aJ\u0014!B:qCJ\\'B\u0001\u001e<\u0003\u0019\t\u0007/Y2iK*\tA(A\u0002pe\u001e\u001c\u0001aE\u0003\u0001\u007f\u0015{U\u000b\u0005\u0002A\u00076\t\u0011I\u0003\u0002Cc\u0005I\u0011mZ4sK\u001e\fG/Z\u0005\u0003\t\u0006\u00131#S7qKJ\fG/\u001b<f\u0003\u001e<'/Z4bi\u0016\u00042AR%L\u001b\u00059%B\u0001%4\u0003\u0015!(/Z3t\u0013\tQuIA\u0005V]\u0006\u0014\u0018\u0010T5lKB\u0011A*T\u0007\u0002c%\u0011a*\r\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007C\u0001)T\u001b\u0005\t&\"\u0001*\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\u000b&a\u0002)s_\u0012,8\r\u001e\t\u0003!ZK!aV)\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u0003-\u000baa\u00195jY\u0012\u0004\u0013AF7vi\u0006\u0014G.Z!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0016\u0003u\u0003\"\u0001\u00150\n\u0005}\u000b&aA%oi\u00069R.\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G\u000fI\u0001\u0015S:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0002+%t\u0007/\u001e;BO\u001e\u0014UO\u001a4fe>3gm]3uA\u00051A(\u001b8jiz\"B!\u001a4hQB\u0011A\n\u0001\u0005\u00061\u001e\u0001\ra\u0013\u0005\b7\u001e\u0001\n\u00111\u0001^\u0011\u001d\tw\u0001%AA\u0002u#\"!\u001a6\t\u000baC\u0001\u0019A&\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u00035\u0004\"A\\9\u000e\u0003=T!\u0001]\u001a\u0002\u0011\u0005t\u0017\r\\=tSNL!A]8\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYR\f\u0001\u0002Z1uCRK\b/Z\u000b\u0002kB\u0011a/_\u0007\u0002o*\u0011\u00010N\u0001\u0006if\u0004Xm]\u0005\u0003u^\u0014\u0001\u0002R1uCRK\b/Z\u0001\u000baJ,G\u000f^=OC6,W#A?\u0011\u0007y\fYAD\u0002\u0000\u0003\u000f\u00012!!\u0001R\u001b\t\t\u0019AC\u0002\u0002\u0006u\na\u0001\u0010:p_Rt\u0014bAA\u0005#\u00061\u0001K]3eK\u001aLA!!\u0004\u0002\u0010\t11\u000b\u001e:j]\u001eT1!!\u0003R\u0003Q9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7e\u0013:$XM\u001d8bYR\u0019Q-!\u0006\t\r\u0005]A\u00021\u0001L\u0003!qWm^\"iS2$\u0017!H<ji\"tUm^'vi\u0006\u0014G.Z!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0015\u0007}\ni\u0002\u0003\u0004\u0002 5\u0001\r!X\u0001\u001a]\u0016<X*\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G/A\u000exSRDg*Z<J]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u000b\u0004\u007f\u0005\u0015\u0002BBA\u0014\u001d\u0001\u0007Q,A\foK^Le\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fi\u0006Aa.\u001e7mC\ndW-\u0006\u0002\u0002.A\u0019\u0001+a\f\n\u0007\u0005E\u0012KA\u0004C_>dW-\u00198\u0002\u001f\u0005<wMQ;gM\u0016\u00148k\u00195f[\u0006,\"!a\u000e\u0011\u0007Y\fI$C\u0002\u0002<]\u0014!b\u0015;sk\u000e$H+\u001f9f\u0003)\u0011\u0017\u000e^7ba\u0006#HO]\u000b\u0003\u0003\u0003\u00022\u0001TA\"\u0013\r\t)%\r\u0002\u0013\u0003R$(/\u001b2vi\u0016\u0014VMZ3sK:\u001cW-A\u0006cSRl\u0017\r]!uiJ\u0004\u0013aE1hO\n+hMZ3s\u0003R$(/\u001b2vi\u0016\u001cXCAA'!\u0019\ty%!\u0017\u0002B9!\u0011\u0011KA+\u001d\u0011\t\t!a\u0015\n\u0003IK1!a\u0016R\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0017\u0002^\t\u00191+Z9\u000b\u0007\u0005]\u0013+A\u0007eK\u001a\fW\u000f\u001c;SKN,H\u000e^\u000b\u0003\u0003G\u0002R\u0001UA3\u0003SJ1!a\u001aR\u0005\u0019y\u0005\u000f^5p]B\u0019A*a\u001b\n\u0007\u00055\u0014GA\u0004MSR,'/\u00197\u00021%t\u0007/\u001e;BO\u001e\u0014UO\u001a4fe\u0006#HO]5ckR,7/A\rj]B,H/Q4h\u0005V4g-\u001a:BiR\u0014\u0018NY;uKN\u0004\u0013AC5oSRL\u0017\r\\5{KR!\u0011qOA?!\r\u0001\u0016\u0011P\u0005\u0004\u0003w\n&\u0001B+oSRDq!a \u0018\u0001\u0004\t\t)\u0001\u0004ck\u001a4WM\u001d\t\u0005\u0003\u0007\u000b))D\u00014\u0013\r\t9i\r\u0002\f\u0013:$XM\u001d8bYJ{w/\u0001\u0004va\u0012\fG/\u001a\u000b\u0007\u0003o\ni)a$\t\u000f\u0005}\u0004\u00041\u0001\u0002\u0002\"9\u0011\u0011\u0013\rA\u0002\u0005\u0005\u0015!B5oaV$\u0018!B7fe\u001e,GCBA<\u0003/\u000bY\nC\u0004\u0002\u001af\u0001\r!!!\u0002\u000f\t,hMZ3sc!9\u0011QT\rA\u0002\u0005\u0005\u0015a\u00022vM\u001a,'OM\u0001\u0005KZ\fG\u000e\u0006\u0003\u0002$\u0006%\u0006c\u0001)\u0002&&\u0019\u0011qU)\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002\u0000i\u0001\n\u00111\u0001\u0002\u0002\u0006!1m\u001c9z)\u001d)\u0017qVAY\u0003gCq\u0001W\u000e\u0011\u0002\u0003\u00071\nC\u0004\\7A\u0005\t\u0019A/\t\u000f\u0005\\\u0002\u0013!a\u0001;\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA]U\rY\u00151X\u0016\u0003\u0003{\u0003B!a0\u0002J6\u0011\u0011\u0011\u0019\u0006\u0005\u0003\u0007\f)-A\u0005v]\u000eDWmY6fI*\u0019\u0011qY)\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002L\u0006\u0005'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAAiU\ri\u00161X\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\u001c\t\u0005\u00037\f)/\u0004\u0002\u0002^*!\u0011q\\Aq\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\r\u0018\u0001\u00026bm\u0006LA!!\u0004\u0002^\u0006a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAR\u0003[D\u0001\"a<\"\u0003\u0003\u0005\r!X\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005U\bCBA|\u0003{\f\u0019+\u0004\u0002\u0002z*\u0019\u00111`)\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0000\u0006e(\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!\f\u0003\u0006!I\u0011q^\u0012\u0002\u0002\u0003\u0007\u00111U\u0001\u0007KF,\u0018\r\\:\u0015\t\u00055\"1\u0002\u0005\n\u0003_$\u0013\u0011!a\u0001\u0003GC3\u0003\u0001B\b\u0005+\u00119Ba\u0007\u0003\u001e\t\u0005\"1\u0005B\u0014\u0005S\u00012\u0001\u0014B\t\u0013\r\u0011\u0019\"\r\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\u0011I\"AA6\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK2iS2$\u0017\u0006I\u0017!%\u0016$XO\u001d8tA\u0005\u0004#-\u001b;nCB\u0004C\u000f[1uA%\u001c\b\u0005\u001e5fA\tLGo^5tK\u0002z%\u000bI8gA\u0005dG\u000eI8gAQDW\r\t2ji6\f\u0007o\u001d\u0011ge>l\u0007\u0005\u001e5fA\rD\u0017\u000e\u001c3\u000bA\u0001\u0002\u0003%\u001a=qe\u0016\u001c8/[8o]\u0001\"\u0006.\u001a\u0011j]B,H\u000fI:i_VdG\r\t2fA\tLG/\\1qg\u0002\u001a'/Z1uK\u0012\u0004cM]8nA\tLG/\\1q?\u000e|gn\u001d;sk\u000e$x,Y4hQ%r#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#Aa\b\u0002\u0003oT\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e];cgR\u0014\u0018N\\4)Q\u0016D\bf\u0018$V\u001d\u000e{\u0006fY8mS%b\u0003\u0005\r\u0017!m%\u0002cIU(NAY\u000bE*V#TA!B\u0006eJ\u00191O%b\u0003\u0005\u000b-!OI\u0002t%\u000b\u0017!Qa\u0003s\u0005\u000e\u0019(S\u0001\n5\u000b\t;bE\"\u001aw\u000e\\\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A]\u0002\u0004\u0007\r\u00191\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\u001aXOY:ue&tw\r\u000b5fq\"zf)\u0016(D?\"\u001aw\u000e\\\u0015*Y\u0001\u0002D\u0006\t\u001c*A\u0019\u0013v*\u0014\u0011W\u00032+Vi\u0015\u0011)1\u0002:\u0013\u0007M\u0014*Y\u0001B\u0003\fI\u00142a\u001dJC\u0006\t\u0015YA\u001d\n\u0004gJ\u0015!\u0003N\u0003C/\u00192)G>d\u0017f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112aA\u0002\u0004\u0007\r\u0006!A\u0005)1/\u001b8dK\u0006\u0012!QE\u0001\u0006g9*d\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0005W\t\u0011\"Y4h?\u001a,hnY:\u0002\u0017\tKG/\\1q\u001fJ\fum\u001a\t\u0003\u0019\u001a\u001aBA\nB\u001a+BA!Q\u0007B\u001e\u0017vkV-\u0004\u0002\u00038)\u0019!\u0011H)\u0002\u000fI,h\u000e^5nK&!!Q\bB\u001c\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u0005_\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u00033\fQ!\u00199qYf$r!\u001aB%\u0005\u0017\u0012i\u0005C\u0003YS\u0001\u00071\nC\u0004\\SA\u0005\t\u0019A/\t\u000f\u0005L\u0003\u0013!a\u0001;\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$#'A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0003\u001d)h.\u00199qYf$BAa\u0016\u0003`A)\u0001+!\u001a\u0003ZA1\u0001Ka\u0017L;vK1A!\u0018R\u0005\u0019!V\u000f\u001d7fg!A!\u0011\r\u0017\u0002\u0002\u0003\u0007Q-A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B6!\u0011\tYN!\u001c\n\t\t=\u0014Q\u001c\u0002\u0007\u001f\nTWm\u0019;")
public class BitmapOrAgg
extends ImperativeAggregate
implements UnaryLike<Expression>,
scala.Serializable {
    private final Expression child;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private final AttributeReference bitmapAttr;
    private final Seq<AttributeReference> inputAggBufferAttributes;
    private transient Seq<Expression> children;
    private volatile transient boolean bitmap$trans$0;

    public static int $lessinit$greater$default$3() {
        return BitmapOrAgg$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$2() {
        return BitmapOrAgg$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple3<Expression, Object, Object>> unapply(BitmapOrAgg bitmapOrAgg) {
        return BitmapOrAgg$.MODULE$.unapply(bitmapOrAgg);
    }

    public static int apply$default$3() {
        return BitmapOrAgg$.MODULE$.apply$default$3();
    }

    public static int apply$default$2() {
        return BitmapOrAgg$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple3<Expression, Object, Object>, BitmapOrAgg> tupled() {
        return BitmapOrAgg$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Object, Function1<Object, BitmapOrAgg>>> curried() {
        return BitmapOrAgg$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        BitmapOrAgg bitmapOrAgg = this;
        synchronized (bitmapOrAgg) {
            if (!this.bitmap$trans$0) {
                this.children = UnaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType dataType = this.child().dataType();
        BinaryType$ binaryType$ = BinaryType$.MODULE$;
        if (dataType == null ? binaryType$ != null : !dataType.equals(binaryType$)) {
            return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)TypeUtils$.MODULE$.toSQLType((AbstractDataType)BinaryType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)TypeUtils$.MODULE$.toSQLExpr(this.child())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)TypeUtils$.MODULE$.toSQLType((AbstractDataType)this.child().dataType()))}))));
        }
        return TypeCheckResult$TypeCheckSuccess$.MODULE$;
    }

    @Override
    public DataType dataType() {
        return BinaryType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "bitmap_or_agg";
    }

    @Override
    public BitmapOrAgg withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2(), this.copy$default$3());
    }

    @Override
    public ImperativeAggregate withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        int x$3 = this.copy$default$3();
        return this.copy(x$2, x$1, x$3);
    }

    @Override
    public ImperativeAggregate withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        int x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, x$1);
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public StructType aggBufferSchema() {
        return DataTypeUtils$.MODULE$.fromAttributes(this.aggBufferAttributes());
    }

    private AttributeReference bitmapAttr() {
        return this.bitmapAttr;
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        AttributeReference attributeReference = this.bitmapAttr();
        return Nil$.MODULE$.$colon$colon((Object)attributeReference);
    }

    @Override
    public Option<Literal> defaultResult() {
        return Option$.MODULE$.apply((Object)Literal$.MODULE$.apply(Array$.MODULE$.fill(BitmapExpressionUtils.NUM_BYTES, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Byte())));
    }

    @Override
    public Seq<AttributeReference> inputAggBufferAttributes() {
        return this.inputAggBufferAttributes;
    }

    @Override
    public void initialize(InternalRow buffer) {
        buffer.update(this.mutableAggBufferOffset(), Array$.MODULE$.fill(BitmapExpressionUtils.NUM_BYTES, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Byte()));
    }

    @Override
    public void update(InternalRow buffer, InternalRow input) {
        byte[] input_bitmap = (byte[])this.child().eval(input);
        if (input_bitmap != null) {
            byte[] bitmap = buffer.getBinary(this.mutableAggBufferOffset());
            BitmapExpressionUtils.bitmapMerge(bitmap, input_bitmap);
            return;
        }
    }

    @Override
    public void merge(InternalRow buffer1, InternalRow buffer2) {
        byte[] bitmap1 = buffer1.getBinary(this.mutableAggBufferOffset());
        byte[] bitmap2 = buffer2.getBinary(this.inputAggBufferOffset());
        BitmapExpressionUtils.bitmapMerge(bitmap1, bitmap2);
    }

    @Override
    public Object eval(InternalRow buffer) {
        return buffer.getBinary(this.mutableAggBufferOffset());
    }

    public BitmapOrAgg copy(Expression child, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new BitmapOrAgg(child, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public int copy$default$2() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$3() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "BitmapOrAgg";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BitmapOrAgg;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BitmapOrAgg)) return false;
        boolean bl = true;
        if (!bl) return false;
        BitmapOrAgg bitmapOrAgg = (BitmapOrAgg)x$1;
        Expression expression = this.child();
        Expression expression2 = bitmapOrAgg.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (this.mutableAggBufferOffset() != bitmapOrAgg.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != bitmapOrAgg.inputAggBufferOffset()) return false;
        if (!bitmapOrAgg.canEqual(this)) return false;
        return true;
    }

    public BitmapOrAgg(Expression child, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        UnaryLike.$init$(this);
        String x$1 = "bitmap";
        BinaryType$ x$2 = BinaryType$.MODULE$;
        boolean x$3 = false;
        Metadata x$42 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, (DataType)x$2, x$3, x$42);
        Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, (DataType)x$2, x$3, x$42);
        this.bitmapAttr = new AttributeReference(x$1, (DataType)x$2, x$3, x$42, x$5, x$6);
        this.inputAggBufferAttributes = (Seq)this.aggBufferAttributes().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.newInstance(), Seq$.MODULE$.canBuildFrom());
    }

    public BitmapOrAgg(Expression child) {
        this(child, 0, 0);
    }
}

