/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.ParseUrl$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(url, partToExtract[, key]) - Extracts a part from a URL.", examples="\n    Examples:\n      > SELECT _FUNC_('http://spark.apache.org/path?query=1', 'HOST');\n       spark.apache.org\n      > SELECT _FUNC_('http://spark.apache.org/path?query=1', 'QUERY');\n       query=1\n      > SELECT _FUNC_('http://spark.apache.org/path?query=1', 'QUERY', 'query');\n       1\n  ", since="2.0.0", group="url_funcs")
@ScalaSignature(bytes="\u0006\u0001\t}v!\u0002\u001f>\u0011\u0003Qe!\u0002'>\u0011\u0003i\u0005\"B,\u0002\t\u0003A\u0006bB-\u0002\u0005\u0004%IA\u0017\u0005\u0007G\u0006\u0001\u000b\u0011B.\t\u000f\u0011\f!\u0019!C\u00055\"1Q-\u0001Q\u0001\nmCqAZ\u0001C\u0002\u0013%!\f\u0003\u0004h\u0003\u0001\u0006Ia\u0017\u0005\bQ\u0006\u0011\r\u0011\"\u0003[\u0011\u0019I\u0017\u0001)A\u00057\"9!.\u0001b\u0001\n\u0013Q\u0006BB6\u0002A\u0003%1\fC\u0004m\u0003\t\u0007I\u0011\u0002.\t\r5\f\u0001\u0015!\u0003\\\u0011\u001dq\u0017A1A\u0005\niCaa\\\u0001!\u0002\u0013Y\u0006b\u00029\u0002\u0005\u0004%IA\u0017\u0005\u0007c\u0006\u0001\u000b\u0011B.\t\u000fI\f!\u0019!C\u0005g\"1A0\u0001Q\u0001\nQDq!`\u0001C\u0002\u0013%1\u000f\u0003\u0004\u007f\u0003\u0001\u0006I\u0001\u001e\u0005\t\u007f\u0006\t\t\u0011\"!\u0002\u0002!I!QT\u0001\u0012\u0002\u0013\u0005!Q\t\u0005\n\u0005?\u000b\u0011\u0011!CA\u0005CC\u0011Ba-\u0002#\u0003%\tA!\u0012\t\u0013\tU\u0016!!A\u0005\n\t]f!\u0002'>\u0001\u0006\u0015\u0001BCA\u00139\tU\r\u0011\"\u0001\u0002(!Q\u0011\u0011\t\u000f\u0003\u0012\u0003\u0006I!!\u000b\t\u0015\u0005\rCD!f\u0001\n\u0003\t)\u0005\u0003\u0006\u0002Nq\u0011\t\u0012)A\u0005\u0003\u000fBaa\u0016\u000f\u0005\u0002\u0005=\u0003BB,\u001d\t\u0003\t)\u0006C\u0004\u0002Zq!\t%!\u0012\t\u000f\u0005mC\u0004\"\u0011\u0002^!9\u00111\u000e\u000f\u0005B\u00055\u0004bBA89\u0011\u0005\u0013\u0011\u000f\u0005\u000b\u0003\u0003c\u0002R1A\u0005\n\u0005\r\u0005BCAM9!\u0015\r\u0011\"\u0003\u0002\u001c\"Q\u0011q\u0016\u000f\t\u0006\u0004%I!!-\t\u000f\u0005mF\u0004\"\u0011\u0002>\"9\u00111\u001a\u000f\u0005\n\u00055\u0007bBAj9\u0011%\u0011Q\u001b\u0005\b\u00037dB\u0011BAo\u0011\u001d\t\u0019\u000f\bC\u0005\u0003KDq!a<\u001d\t\u0013\t\t\u0010C\u0004\u0002xr!I!!?\t\u000f\u0005}H\u0004\"\u0011\u0003\u0002!9!Q\u0003\u000f\u0005R\t]\u0001\"\u0003B\u00129\u0005\u0005I\u0011\u0001B\u0013\u0011%\u0011Y\u0003HI\u0001\n\u0003\u0011i\u0003C\u0005\u0003Dq\t\n\u0011\"\u0001\u0003F!A!\u0011\n\u000f\u0002\u0002\u0013\u00053\u000fC\u0005\u0003Lq\t\t\u0011\"\u0001\u0003N!I!Q\u000b\u000f\u0002\u0002\u0013\u0005!q\u000b\u0005\n\u0005;b\u0012\u0011!C!\u0005?B\u0011B!\u001c\u001d\u0003\u0003%\tAa\u001c\t\u0013\tMD$!A\u0005B\tU\u0014\u0001\u0003)beN,WK\u001d7\u000b\u0005yz\u0014aC3yaJ,7o]5p]NT!\u0001Q!\u0002\u0011\r\fG/\u00197zgRT!AQ\"\u0002\u0007M\fHN\u0003\u0002E\u000b\u0006)1\u000f]1sW*\u0011aiR\u0001\u0007CB\f7\r[3\u000b\u0003!\u000b1a\u001c:h\u0007\u0001\u0001\"aS\u0001\u000e\u0003u\u0012\u0001\u0002U1sg\u0016,&\u000f\\\n\u0004\u00039#\u0006CA(S\u001b\u0005\u0001&\"A)\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0003&AB!osJ+g\r\u0005\u0002P+&\u0011a\u000b\u0015\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003)\u000bA\u0001S(T)V\t1\f\u0005\u0002]C6\tQL\u0003\u0002_?\u0006)A/\u001f9fg*\u0011\u0001mQ\u0001\u0007k:\u001c\u0018MZ3\n\u0005\tl&AC+U\rb\u001aFO]5oO\u0006)\u0001jT*UA\u0005!\u0001+\u0011+I\u0003\u0015\u0001\u0016\t\u0016%!\u0003\u0015\tV+\u0012*Z\u0003\u0019\tV+\u0012*ZA\u0005\u0019!+\u0012$\u0002\tI+e\tI\u0001\t!J{EkT\"P\u0019\u0006I\u0001KU(U\u001f\u000e{E\nI\u0001\u0005\r&cU)A\u0003G\u00132+\u0005%A\u0005B+RCuJU%U3\u0006Q\u0011)\u0016+I\u001fJKE+\u0017\u0011\u0002\u0011U\u001bVIU%O\r>\u000b\u0011\"V*F%&sei\u0014\u0011\u0002\u0017I+u)\u0012-Q%\u00163\u0015\nW\u000b\u0002iB\u0011QO_\u0007\u0002m*\u0011q\u000f_\u0001\u0005Y\u0006twMC\u0001z\u0003\u0011Q\u0017M^1\n\u0005m4(AB*ue&tw-\u0001\u0007S\u000b\u001e+\u0005\f\u0015*F\r&C\u0006%A\u0006S\u000b\u001e+\u0005lU+C\r&C\u0016\u0001\u0004*F\u000f\u0016C6+\u0016\"G\u0013b\u0003\u0013!B1qa2LHCBA\u0002\u00053\u0013Y\n\u0005\u0002L9MQA$a\u0002\u0002\u000e\u0005M\u0011q\u0004+\u0011\u0007-\u000bI!C\u0002\u0002\fu\u0012!\"\u0012=qe\u0016\u001c8/[8o!\rY\u0015qB\u0005\u0004\u0003#i$!E#ya\u0016\u001cGo]%oaV$H+\u001f9fgB!\u0011QCA\u000e\u001b\t\t9BC\u0002\u0002\u001au\nqaY8eK\u001e,g.\u0003\u0003\u0002\u001e\u0005]!aD\"pI\u0016<WM\u001c$bY2\u0014\u0017mY6\u0011\u0007=\u000b\t#C\u0002\u0002$A\u0013q\u0001\u0015:pIV\u001cG/\u0001\u0005dQ&dGM]3o+\t\tI\u0003\u0005\u0004\u0002,\u0005m\u0012q\u0001\b\u0005\u0003[\t9D\u0004\u0003\u00020\u0005URBAA\u0019\u0015\r\t\u0019$S\u0001\u0007yI|w\u000e\u001e \n\u0003EK1!!\u000fQ\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0010\u0002@\t\u00191+Z9\u000b\u0007\u0005e\u0002+A\u0005dQ&dGM]3oA\u0005Ya-Y5m\u001f:,%O]8s+\t\t9\u0005E\u0002P\u0003\u0013J1!a\u0013Q\u0005\u001d\u0011un\u001c7fC:\fABZ1jY>sWI\u001d:pe\u0002\"b!a\u0001\u0002R\u0005M\u0003bBA\u0013C\u0001\u0007\u0011\u0011\u0006\u0005\n\u0003\u0007\n\u0003\u0013!a\u0001\u0003\u000f\"B!a\u0001\u0002X!9\u0011Q\u0005\u0012A\u0002\u0005%\u0012\u0001\u00038vY2\f'\r\\3\u0002\u0015%t\u0007/\u001e;UsB,7/\u0006\u0002\u0002`A1\u00111FA\u001e\u0003C\u0002B!a\u0019\u0002h5\u0011\u0011Q\r\u0006\u0003=\u0006KA!!\u001b\u0002f\tAA)\u0019;b)f\u0004X-\u0001\u0005eCR\fG+\u001f9f+\t\t\t'\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!a\u001d\u0011\t\u0005U\u0014Q\u0010\b\u0005\u0003o\nI\bE\u0002\u00020AK1!a\u001fQ\u0003\u0019\u0001&/\u001a3fM&\u001910a \u000b\u0007\u0005m\u0004+A\u0005dC\u000eDW\rZ+sYV\u0011\u0011Q\u0011\t\u0005\u0003\u000f\u000bi)\u0004\u0002\u0002\n*\u0019\u00111\u0012=\u0002\u00079,G/\u0003\u0003\u0002\u0010\u0006%%aA+S\u0013\"\u001aq%a%\u0011\u0007=\u000b)*C\u0002\u0002\u0018B\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u001b\r\f7\r[3e!\u0006$H/\u001a:o+\t\ti\n\u0005\u0003\u0002 \u0006%VBAAQ\u0015\u0011\t\u0019+!*\u0002\u000bI,w-\u001a=\u000b\u0007\u0005\u001d\u00060\u0001\u0003vi&d\u0017\u0002BAV\u0003C\u0013q\u0001U1ui\u0016\u0014h\u000eK\u0002)\u0003'\u000bQcY1dQ\u0016$W\t\u001f;sC\u000e$\b+\u0019:u\rVt7-\u0006\u0002\u00024B9q*!.\u0002\u0006\u0006M\u0014bAA\\!\nIa)\u001e8di&|g.\r\u0015\u0004S\u0005M\u0015aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cHCAA`!\u0011\t\t-a2\u000e\u0005\u0005\r'bAAc\u007f\u0005A\u0011M\\1msNL7/\u0003\u0003\u0002J\u0006\r'a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\u0002\u0015\u001d,G\u000fU1ui\u0016\u0014h\u000e\u0006\u0003\u0002\u001e\u0006=\u0007BBAiW\u0001\u00071,A\u0002lKf\faaZ3u+JdG\u0003BAC\u0003/Da!!7-\u0001\u0004Y\u0016aA;sY\u0006\u0011r-\u001a;FqR\u0014\u0018m\u0019;QCJ$h)\u001e8d)\u0011\t\u0019,a8\t\r\u0005\u0005X\u00061\u0001\\\u00035\u0001\u0018M\u001d;U_\u0016CHO]1di\u0006)R\r\u001f;sC\u000e$h+\u00197vK\u001a\u0013x.\\)vKJLH#B.\u0002h\u0006-\bBBAu]\u0001\u00071,A\u0003rk\u0016\u0014\u0018\u0010C\u0004\u0002n:\u0002\r!!(\u0002\u000fA\fG\u000f^3s]\u0006qQ\r\u001f;sC\u000e$hI]8n+JdG#B.\u0002t\u0006U\bbBAm_\u0001\u0007\u0011Q\u0011\u0005\u0007\u0003C|\u0003\u0019A.\u0002%A\f'o]3Ve2<\u0016\u000e\u001e5pkR\\U-\u001f\u000b\u00067\u0006m\u0018Q \u0005\u0007\u00033\u0004\u0004\u0019A.\t\r\u0005\u0005\b\u00071\u0001\\\u0003\u0011)g/\u00197\u0015\t\t\r!\u0011\u0002\t\u0004\u001f\n\u0015\u0011b\u0001B\u0004!\n\u0019\u0011I\\=\t\u0013\t-\u0011\u0007%AA\u0002\t5\u0011!B5oaV$\b\u0003\u0002B\b\u0005#i\u0011aP\u0005\u0004\u0005'y$aC%oi\u0016\u0014h.\u00197S_^\fqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\t\u0005\r!\u0011\u0004\u0005\b\u00057\u0011\u0004\u0019\u0001B\u000f\u0003-qWm^\"iS2$'/\u001a8\u0011\r\u0005-\"qDA\u0004\u0013\u0011\u0011\t#a\u0010\u0003\u0015%sG-\u001a=fIN+\u0017/\u0001\u0003d_BLHCBA\u0002\u0005O\u0011I\u0003C\u0005\u0002&M\u0002\n\u00111\u0001\u0002*!I\u00111I\u001a\u0011\u0002\u0003\u0007\u0011qI\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011yC\u000b\u0003\u0002*\tE2F\u0001B\u001a!\u0011\u0011)Da\u0010\u000e\u0005\t]\"\u0002\u0002B\u001d\u0005w\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tu\u0002+\u0001\u0006b]:|G/\u0019;j_:LAA!\u0011\u00038\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!q\t\u0016\u0005\u0003\u000f\u0012\t$A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0005\u001f\u00022a\u0014B)\u0013\r\u0011\u0019\u0006\u0015\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005\u0007\u0011I\u0006C\u0005\u0003\\a\n\t\u00111\u0001\u0003P\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!\u0019\u0011\r\t\r$\u0011\u000eB\u0002\u001b\t\u0011)GC\u0002\u0003hA\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011YG!\u001a\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u000f\u0012\t\bC\u0005\u0003\\i\n\t\u00111\u0001\u0003\u0004\u00051Q-];bYN$B!a\u0012\u0003x!I!1L\u001e\u0002\u0002\u0003\u0007!1\u0001\u0015\u00149\tm$\u0011\u0011BB\u0005\u000f\u0013II!$\u0003\u0010\nM%Q\u0013\t\u0004\u0017\nu\u0014b\u0001B@{\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017E\u0001BC\u0003}zf)\u0016(D?\"*(\u000f\u001c\u0017!a\u0006\u0014H\u000fV8FqR\u0014\u0018m\u0019;\\Y\u0001ZW-_/*A5\u0002S\t\u001f;sC\u000e$8\u000fI1!a\u0006\u0014H\u000f\t4s_6\u0004\u0013\rI+S\u0019:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0005\u0017\u000b!1\t\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O!$H\u000f\u001d\u001e0_M\u0004\u0018M]6/CB\f7\r[3/_J<w\u0006]1uQ~\nX/\u001a:z{E:C\u0006I\u0014I\u001fN#v%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!gB\f'o\u001b\u0018ba\u0006\u001c\u0007.\u001a\u0018pe\u001eT\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006f\n5uiBTtfL:qCJ\\g&\u00199bG\",gf\u001c:h_A\fG\u000f[ rk\u0016\u0014\u00180P\u0019(Y\u0001:\u0013+V#S3\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I9vKJLX(\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O!$H\u000f\u001d\u001e0_M\u0004\u0018M]6/CB\f7\r[3/_J<w\u0006]1uQ~\nX/\u001a:z{E:C\u0006I\u0014R+\u0016\u0013\u0016l\n\u0017!OE,XM]=(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013G\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\u0011\t*A\u00033]Ar\u0003'A\u0003he>,\b/\t\u0002\u0003\u0018\u0006IQO\u001d7`MVt7m\u001d\u0005\b\u0003K9\u0002\u0019AA\u0015\u0011%\t\u0019e\u0006I\u0001\u0002\u0004\t9%A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0003\u001d)h.\u00199qYf$BAa)\u00030B)qJ!*\u0003*&\u0019!q\u0015)\u0003\r=\u0003H/[8o!\u001dy%1VA\u0015\u0003\u000fJ1A!,Q\u0005\u0019!V\u000f\u001d7fe!I!\u0011W\r\u0002\u0002\u0003\u0007\u00111A\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B]!\r)(1X\u0005\u0004\u0005{3(AB(cU\u0016\u001cG\u000f")
public class ParseUrl
extends Expression
implements ExpectsInputTypes,
CodegenFallback,
scala.Serializable {
    private transient URI cachedUrl;
    private transient Pattern cachedPattern;
    private transient Function1<URI, String> cachedExtractPartFunc;
    private final Seq<Expression> children;
    private final boolean failOnError;
    private volatile transient byte bitmap$trans$0;

    public static boolean $lessinit$greater$default$2() {
        return ParseUrl$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Seq<Expression>, Object>> unapply(ParseUrl parseUrl) {
        return ParseUrl$.MODULE$.unapply(parseUrl);
    }

    public static boolean apply$default$2() {
        return ParseUrl$.MODULE$.apply$default$2();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.fill(this.children().size(), (Function0 & Serializable & scala.Serializable)() -> StringType$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "parse_url";
    }

    private URI cachedUrl$lzycompute() {
        ParseUrl parseUrl = this;
        synchronized (parseUrl) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                UTF8String uTF8String;
                Literal literal;
                Object url;
                Expression expression = (Expression)this.children().apply(0);
                this.cachedUrl = expression instanceof Literal && (url = (literal = (Literal)expression).value()) instanceof UTF8String && (uTF8String = (UTF8String)url) != null ? this.getUrl(uTF8String) : null;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.cachedUrl;
    }

    private URI cachedUrl() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.cachedUrl$lzycompute();
        }
        return this.cachedUrl;
    }

    private Pattern cachedPattern$lzycompute() {
        ParseUrl parseUrl = this;
        synchronized (parseUrl) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                UTF8String uTF8String;
                Literal literal;
                Object key;
                Expression expression = (Expression)this.children().apply(2);
                this.cachedPattern = expression instanceof Literal && (key = (literal = (Literal)expression).value()) instanceof UTF8String && (uTF8String = (UTF8String)key) != null ? this.getPattern(uTF8String) : null;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.cachedPattern;
    }

    private Pattern cachedPattern() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.cachedPattern$lzycompute();
        }
        return this.cachedPattern;
    }

    private Function1<URI, String> cachedExtractPartFunc$lzycompute() {
        ParseUrl parseUrl = this;
        synchronized (parseUrl) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                Function1<URI, String> function1;
                Literal literal;
                Object part;
                Expression expression = (Expression)this.children().apply(1);
                if (expression instanceof Literal && (part = (literal = (Literal)expression).value()) instanceof UTF8String) {
                    UTF8String uTF8String = (UTF8String)part;
                    function1 = this.getExtractPartFunc(uTF8String);
                } else {
                    function1 = null;
                }
                this.cachedExtractPartFunc = function1;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.cachedExtractPartFunc;
    }

    private Function1<URI, String> cachedExtractPartFunc() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.cachedExtractPartFunc$lzycompute();
        }
        return this.cachedExtractPartFunc;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        if (this.children().size() > 3 || this.children().size() < 2) {
            throw QueryCompilationErrors$.MODULE$.wrongNumArgsError(Cast$.MODULE$.toSQLId(this.prettyName()), (Seq<Object>)((Seq)new .colon.colon((Object)"[2, 3]", (List)Nil$.MODULE$)), this.children().length(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$4(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$5(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$6());
        }
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private Pattern getPattern(UTF8String key) {
        return Pattern.compile(new StringBuilder(0).append(ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$REGEXPREFIX()).append(key.toString()).append(ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$REGEXSUBFIX()).toString());
    }

    private URI getUrl(UTF8String url) {
        URI uRI;
        try {
            uRI = new URI(url.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            if (this.failOnError()) {
                throw QueryExecutionErrors$.MODULE$.invalidUrlError(url, uRISyntaxException);
            }
            uRI = null;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return uRI;
    }

    private Function1<URI, String> getExtractPartFunc(UTF8String partToExtract) {
        UTF8String uTF8String = partToExtract;
        UTF8String uTF8String2 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$HOST();
        UTF8String uTF8String3 = uTF8String;
        if (!(uTF8String2 != null ? !uTF8String2.equals(uTF8String3) : uTF8String3 != null)) {
            return (Function1 & Serializable & scala.Serializable)x$1 -> x$1.getHost();
        }
        UTF8String uTF8String4 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$PATH();
        UTF8String uTF8String5 = uTF8String;
        if (!(uTF8String4 != null ? !uTF8String4.equals(uTF8String5) : uTF8String5 != null)) {
            return (Function1 & Serializable & scala.Serializable)x$2 -> x$2.getRawPath();
        }
        UTF8String uTF8String6 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$QUERY();
        UTF8String uTF8String7 = uTF8String;
        if (!(uTF8String6 != null ? !uTF8String6.equals(uTF8String7) : uTF8String7 != null)) {
            return (Function1 & Serializable & scala.Serializable)x$3 -> x$3.getRawQuery();
        }
        UTF8String uTF8String8 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$REF();
        UTF8String uTF8String9 = uTF8String;
        if (!(uTF8String8 != null ? !uTF8String8.equals(uTF8String9) : uTF8String9 != null)) {
            return (Function1 & Serializable & scala.Serializable)x$4 -> x$4.getRawFragment();
        }
        UTF8String uTF8String10 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$PROTOCOL();
        UTF8String uTF8String11 = uTF8String;
        if (!(uTF8String10 != null ? !uTF8String10.equals(uTF8String11) : uTF8String11 != null)) {
            return (Function1 & Serializable & scala.Serializable)x$5 -> x$5.getScheme();
        }
        UTF8String uTF8String12 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$FILE();
        UTF8String uTF8String13 = uTF8String;
        if (!(uTF8String12 != null ? !uTF8String12.equals(uTF8String13) : uTF8String13 != null)) {
            return (Function1 & Serializable & scala.Serializable)url -> {
                if (url.getRawQuery() != null) {
                    return new StringBuilder(1).append(url.getRawPath()).append("?").append(url.getRawQuery()).toString();
                }
                return url.getRawPath();
            };
        }
        UTF8String uTF8String14 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$AUTHORITY();
        UTF8String uTF8String15 = uTF8String;
        if (!(uTF8String14 != null ? !uTF8String14.equals(uTF8String15) : uTF8String15 != null)) {
            return (Function1 & Serializable & scala.Serializable)x$6 -> x$6.getRawAuthority();
        }
        UTF8String uTF8String16 = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$USERINFO();
        UTF8String uTF8String17 = uTF8String;
        if (!(uTF8String16 != null ? !uTF8String16.equals(uTF8String17) : uTF8String17 != null)) {
            return (Function1 & Serializable & scala.Serializable)x$7 -> x$7.getRawUserInfo();
        }
        return (Function1 & Serializable & scala.Serializable)url -> null;
    }

    private UTF8String extractValueFromQuery(UTF8String query, Pattern pattern) {
        Matcher m = pattern.matcher(query.toString());
        if (m.find()) {
            return UTF8String.fromString((String)m.group(2));
        }
        return null;
    }

    private UTF8String extractFromUrl(URI url, UTF8String partToExtract) {
        if (this.cachedExtractPartFunc() != null) {
            return UTF8String.fromString((String)((String)this.cachedExtractPartFunc().apply((Object)url)));
        }
        return UTF8String.fromString((String)((String)this.getExtractPartFunc(partToExtract).apply((Object)url)));
    }

    private UTF8String parseUrlWithoutKey(UTF8String url, UTF8String partToExtract) {
        if (this.cachedUrl() != null) {
            return this.extractFromUrl(this.cachedUrl(), partToExtract);
        }
        URI currentUrl = this.getUrl(url);
        if (currentUrl != null) {
            return this.extractFromUrl(currentUrl, partToExtract);
        }
        return null;
    }

    @Override
    public Object eval(InternalRow input) {
        Seq evaluated = (Seq)this.children().map((Function1 & Serializable & scala.Serializable)e -> (UTF8String)e.eval(input), Seq$.MODULE$.canBuildFrom());
        if (evaluated.contains(null)) {
            return null;
        }
        if (evaluated.size() == 2) {
            return this.parseUrlWithoutKey((UTF8String)evaluated.apply(0), (UTF8String)evaluated.apply(1));
        }
        Predef$.MODULE$.assert(evaluated.size() == 3);
        Object object = evaluated.apply(1);
        UTF8String uTF8String = ParseUrl$.MODULE$.org$apache$spark$sql$catalyst$expressions$ParseUrl$$QUERY();
        if (object == null ? uTF8String != null : !object.equals(uTF8String)) {
            return null;
        }
        UTF8String query = this.parseUrlWithoutKey((UTF8String)evaluated.apply(0), (UTF8String)evaluated.apply(1));
        if (query == null) {
            return null;
        }
        if (this.cachedPattern() != null) {
            return this.extractValueFromQuery(query, this.cachedPattern());
        }
        return this.extractValueFromQuery(query, this.getPattern((UTF8String)evaluated.apply(2)));
    }

    @Override
    public ParseUrl withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Seq<Expression>)newChildren, this.copy$default$2());
    }

    public ParseUrl copy(Seq<Expression> children2, boolean failOnError) {
        return new ParseUrl(children2, failOnError);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    public boolean copy$default$2() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "ParseUrl";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.children();
            }
            case 1: {
                return BoxesRunTime.boxToBoolean((boolean)this.failOnError());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ParseUrl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ParseUrl)) return false;
        boolean bl = true;
        if (!bl) return false;
        ParseUrl parseUrl = (ParseUrl)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = parseUrl.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (this.failOnError() != parseUrl.failOnError()) return false;
        if (!parseUrl.canEqual(this)) return false;
        return true;
    }

    public ParseUrl(Seq<Expression> children2, boolean failOnError) {
        this.children = children2;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
        CodegenFallback.$init$(this);
    }

    public ParseUrl(Seq<Expression> children2) {
        this(children2, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

