/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.EndsWith;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.StringBinaryPredicateExpressionBuilderBase;
import org.apache.spark.sql.catalyst.plans.logical.FunctionBuilderBase;
import org.apache.spark.sql.catalyst.plans.logical.FunctionSignature;
import scala.Option;
import scala.collection.Seq;

@ExpressionDescription(usage="\n    _FUNC_(left, right) - Returns a boolean. The value is True if left ends with right.\n    Returns NULL if either input expression is NULL. Otherwise, returns False.\n    Both left or right must be of STRING or BINARY type.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('Spark SQL', 'SQL');\n       true\n      > SELECT _FUNC_('Spark SQL', 'Spark');\n       false\n      > SELECT _FUNC_('Spark SQL', null);\n       NULL\n      > SELECT _FUNC_(x'537061726b2053514c', x'537061726b');\n       false\n      > SELECT _FUNC_(x'537061726b2053514c', x'53514c');\n       true\n  ", since="3.3.0", group="string_funcs")
public final class EndsWithExpressionBuilder$
implements StringBinaryPredicateExpressionBuilderBase {
    public static EndsWithExpressionBuilder$ MODULE$;

    static {
        new EndsWithExpressionBuilder$();
    }

    @Override
    public Expression build(String funcName, Seq<Expression> expressions) {
        return StringBinaryPredicateExpressionBuilderBase.build$(this, funcName, expressions);
    }

    @Override
    public Option<FunctionSignature> functionSignature() {
        return FunctionBuilderBase.functionSignature$(this);
    }

    @Override
    public Seq<Expression> rearrange(FunctionSignature expectedSignature, Seq<Expression> providedArguments, String functionName) {
        return FunctionBuilderBase.rearrange$(this, expectedSignature, providedArguments, functionName);
    }

    @Override
    public Expression createStringPredicate(Expression left, Expression right) {
        return new EndsWith(left, right);
    }

    private EndsWithExpressionBuilder$() {
        MODULE$ = this;
        FunctionBuilderBase.$init$(this);
        StringBinaryPredicateExpressionBuilderBase.$init$(this);
    }
}

