/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ElementAt;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.SplitPart$;
import org.apache.spark.sql.catalyst.expressions.StringSplitSQL;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str, delimiter, partNum) - Splits `str` by delimiter and return\n      requested part of the split (1-based). If any input is null, returns null.\n      if `partNum` is out of range of split parts, returns empty string. If `partNum` is 0,\n      throws an error. If `partNum` is negative, the parts are counted backward from the\n      end of the string. If the `delimiter` is an empty string, the `str` is not split.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('11.12.13', '.', 3);\n       13\n  ", since="3.3.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005}f\u0001\u0002\u0010 \u00012B\u0001\u0002\u0011\u0001\u0003\u0016\u0004%\t!\u0011\u0005\t\u0005\u0002\u0011\t\u0012)A\u0005[!A1\t\u0001BK\u0002\u0013\u0005\u0011\t\u0003\u0005E\u0001\tE\t\u0015!\u0003.\u0011!)\u0005A!f\u0001\n\u0003\t\u0005\u0002\u0003$\u0001\u0005#\u0005\u000b\u0011B\u0017\t\u000b\u001d\u0003A\u0011\u0001%\t\u00115\u0003\u0001R1A\u0005B\u0005CQA\u0014\u0001\u0005B=CQa\u0017\u0001\u0005BqCQ\u0001\u001c\u0001\u0005\u00025DQa\u001c\u0001\u0005\u0012ADqA\u001e\u0001\u0002\u0002\u0013\u0005q\u000fC\u0004|\u0001E\u0005I\u0011\u0001?\t\u0011\u0005=\u0001!%A\u0005\u0002qD\u0001\"!\u0005\u0001#\u0003%\t\u0001 \u0005\n\u0003'\u0001\u0011\u0011!C!\u0003+A\u0011\"!\n\u0001\u0003\u0003%\t!a\n\t\u0013\u0005=\u0002!!A\u0005\u0002\u0005E\u0002\"CA\u001f\u0001\u0005\u0005I\u0011IA \u0011%\ti\u0005AA\u0001\n\u0003\ty\u0005C\u0005\u0002Z\u0001\t\t\u0011\"\u0011\u0002\\\u001dI\u0011qP\u0010\u0002\u0002#\u0005\u0011\u0011\u0011\u0004\t=}\t\t\u0011#\u0001\u0002\u0004\"1q\t\u0007C\u0001\u0003#C\u0011\"a%\u0019\u0003\u0003%)%!&\t\u0013\u0005]\u0005$!A\u0005\u0002\u0006e\u0005\"CAQ1\u0005\u0005I\u0011QAR\u0011%\t)\fGA\u0001\n\u0013\t9LA\u0005Ta2LG\u000fU1si*\u0011\u0001%I\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002#G\u0005A1-\u0019;bYf\u001cHO\u0003\u0002%K\u0005\u00191/\u001d7\u000b\u0005\u0019:\u0013!B:qCJ\\'B\u0001\u0015*\u0003\u0019\t\u0007/Y2iK*\t!&A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001[E\"t'\u0010\t\u0003]=j\u0011aH\u0005\u0003a}\u0011!\"\u0012=qe\u0016\u001c8/[8o!\tq#'\u0003\u00024?\t\u0011\"+\u001e8uS6,'+\u001a9mC\u000e,\u0017M\u00197f!\tqS'\u0003\u00027?\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u00029w5\t\u0011HC\u0001;\u0003\u0015\u00198-\u00197b\u0013\ta\u0014HA\u0004Qe>$Wo\u0019;\u0011\u0005ar\u0014BA :\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\r\u0019HO]\u000b\u0002[\u0005!1\u000f\u001e:!\u0003%!W\r\\5nSR,'/\u0001\u0006eK2LW.\u001b;fe\u0002\nq\u0001]1si:+X.\u0001\u0005qCJ$h*^7!\u0003\u0019a\u0014N\\5u}Q!\u0011JS&M!\tq\u0003\u0001C\u0003A\u000f\u0001\u0007Q\u0006C\u0003D\u000f\u0001\u0007Q\u0006C\u0003F\u000f\u0001\u0007Q&A\u0006sKBd\u0017mY3nK:$\u0018\u0001\u00038pI\u0016t\u0015-\\3\u0016\u0003A\u0003\"!\u0015-\u000f\u0005I3\u0006CA*:\u001b\u0005!&BA+,\u0003\u0019a$o\\8u}%\u0011q+O\u0001\u0007!J,G-\u001a4\n\u0005eS&AB*ue&twM\u0003\u0002Xs\u0005Q\u0011N\u001c9viRK\b/Z:\u0016\u0003u\u00032AX2g\u001d\ty\u0016M\u0004\u0002TA&\t!(\u0003\u0002cs\u00059\u0001/Y2lC\u001e,\u0017B\u00013f\u0005\r\u0019V-\u001d\u0006\u0003Ef\u0002\"a\u001a6\u000e\u0003!T!![\u0012\u0002\u000bQL\b/Z:\n\u0005-D'\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0011\rD\u0017\u000e\u001c3sK:,\u0012A\u001c\t\u0004=\u000el\u0013aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\ti\u0013\u000fC\u0003s\u0019\u0001\u00071/A\u0006oK^\u001c\u0005.\u001b7ee\u0016t\u0007c\u00010u[%\u0011Q/\u001a\u0002\u000b\u0013:$W\r_3e'\u0016\f\u0018\u0001B2paf$B!\u0013=zu\"9\u0001)\u0004I\u0001\u0002\u0004i\u0003bB\"\u000e!\u0003\u0005\r!\f\u0005\b\u000b6\u0001\n\u00111\u0001.\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012! \u0016\u0003[y\\\u0013a \t\u0005\u0003\u0003\tY!\u0004\u0002\u0002\u0004)!\u0011QAA\u0004\u0003%)hn\u00195fG.,GMC\u0002\u0002\ne\n!\"\u00198o_R\fG/[8o\u0013\u0011\ti!a\u0001\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0006\u0011\t\u0005e\u00111E\u0007\u0003\u00037QA!!\b\u0002 \u0005!A.\u00198h\u0015\t\t\t#\u0001\u0003kCZ\f\u0017bA-\u0002\u001c\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\u0006\t\u0004q\u0005-\u0012bAA\u0017s\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111GA\u001d!\rA\u0014QG\u0005\u0004\u0003oI$aA!os\"I\u00111H\n\u0002\u0002\u0003\u0007\u0011\u0011F\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u0005\u0003CBA\"\u0003\u0013\n\u0019$\u0004\u0002\u0002F)\u0019\u0011qI\u001d\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002L\u0005\u0015#\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!\u0015\u0002XA\u0019\u0001(a\u0015\n\u0007\u0005U\u0013HA\u0004C_>dW-\u00198\t\u0013\u0005mR#!AA\u0002\u0005M\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0002R\u0005u\u0003\"CA\u001e-\u0005\u0005\t\u0019AA\u001aQM\u0001\u0011\u0011MA4\u0003S\ni'a\u001c\u0002t\u0005U\u0014\u0011PA>!\rq\u00131M\u0005\u0004\u0003Kz\"!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003W\n1\u0011\f\u0006!A\u0001\u0002sLR+O\u0007~C3\u000f\u001e:-A\u0011,G.[7ji\u0016\u0014H\u0006\t9beRtU/\\\u0015![\u0001\u001a\u0006\u000f\\5ug\u0002\u00027\u000f\u001e:aA\tL\b\u0005Z3mS6LG/\u001a:!C:$\u0007E]3ukJt'\u0002\t\u0011!A\u0001\u0002#/Z9vKN$X\r\u001a\u0011qCJ$\be\u001c4!i\",\u0007e\u001d9mSR\u0004\u0003&M\u0017cCN,G-\u000b\u0018!\u0013\u001a\u0004\u0013M\\=!S:\u0004X\u000f\u001e\u0011jg\u0002rW\u000f\u001c7-AI,G/\u001e:og\u0002rW\u000f\u001c7/\u0015\u0001\u0002\u0003\u0005\t\u0011!S\u001a\u0004\u0003\r]1si:+X\u000e\u0019\u0011jg\u0002zW\u000f\u001e\u0011pM\u0002\u0012\u0018M\\4fA=4\u0007e\u001d9mSR\u0004\u0003/\u0019:ug2\u0002#/\u001a;ve:\u001c\b%Z7qif\u00043\u000f\u001e:j]\u001et\u0003%\u00134!AB\f'\u000f\u001e(v[\u0002\u0004\u0013n\u001d\u00111Y)\u0001\u0003\u0005\t\u0011!AQD'o\\<tA\u0005t\u0007%\u001a:s_Jt\u0003%\u00134!AB\f'\u000f\u001e(v[\u0002\u0004\u0013n\u001d\u0011oK\u001e\fG/\u001b<fY\u0001\"\b.\u001a\u0011qCJ$8\u000fI1sK\u0002\u001aw.\u001e8uK\u0012\u0004#-Y2lo\u0006\u0014H\r\t4s_6\u0004C\u000f[3\u000bA\u0001\u0002\u0003\u0005\t\u0011f]\u0012\u0004sN\u001a\u0011uQ\u0016\u00043\u000f\u001e:j]\u001et\u0003%\u00134!i\",\u0007\u0005\u00193fY&l\u0017\u000e^3sA\u0002J7\u000fI1oA\u0015l\u0007\u000f^=!gR\u0014\u0018N\\4-AQDW\r\t1tiJ\u0004\u0007%[:!]>$\be\u001d9mSRt#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!\u001d\u0002\r*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs%M\u0019/cIr\u0013gM\u0014-A\u001drs\u0005\f\u00114SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013g\r\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011qO\u0001\u0006g9\u001ad\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003{\nAb\u001d;sS:<wLZ;oGN\f\u0011b\u00159mSR\u0004\u0016M\u001d;\u0011\u00059B2\u0003\u0002\r\u0002\u0006v\u0002\u0002\"a\"\u0002\u000e6jS&S\u0007\u0003\u0003\u0013S1!a#:\u0003\u001d\u0011XO\u001c;j[\u0016LA!a$\u0002\n\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0015\u0005\u0005\u0005\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005]\u0011!B1qa2LHcB%\u0002\u001c\u0006u\u0015q\u0014\u0005\u0006\u0001n\u0001\r!\f\u0005\u0006\u0007n\u0001\r!\f\u0005\u0006\u000bn\u0001\r!L\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t)+!-\u0011\u000ba\n9+a+\n\u0007\u0005%\u0016H\u0001\u0004PaRLwN\u001c\t\u0007q\u00055V&L\u0017\n\u0007\u0005=\u0016H\u0001\u0004UkBdWm\r\u0005\t\u0003gc\u0012\u0011!a\u0001\u0013\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003s\u0003B!!\u0007\u0002<&!\u0011QXA\u000e\u0005\u0019y%M[3di\u0002")
public class SplitPart
extends Expression
implements RuntimeReplaceable,
ImplicitCastInputTypes,
Serializable {
    private Expression replacement;
    private final Expression str;
    private final Expression delimiter;
    private final Expression partNum;
    private final Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile byte bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(SplitPart splitPart) {
        return SplitPart$.MODULE$.unapply(splitPart);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, SplitPart> tupled() {
        return SplitPart$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, SplitPart>>> curried() {
        return SplitPart$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        SplitPart splitPart = this;
        synchronized (splitPart) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression str() {
        return this.str;
    }

    public Expression delimiter() {
        return this.delimiter;
    }

    public Expression partNum() {
        return this.partNum;
    }

    private Expression replacement$lzycompute() {
        SplitPart splitPart = this;
        synchronized (splitPart) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.replacement = new ElementAt(new StringSplitSQL(this.str(), this.delimiter()), this.partNum(), (Option<Literal>)new Some((Object)Literal$.MODULE$.create("", StringType$.MODULE$)), false);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.replacement$lzycompute() : this.replacement;
    }

    @Override
    public String nodeName() {
        return "split_part";
    }

    public Seq<DataType> inputTypes() {
        return (Seq)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)new .colon.colon((Object)this.str(), (List)new .colon.colon((Object)this.delimiter(), (List)new .colon.colon((Object)this.partNum(), (List)Nil$.MODULE$)));
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1), (Expression)newChildren.apply(2));
    }

    public SplitPart copy(Expression str, Expression delimiter, Expression partNum) {
        return new SplitPart(str, delimiter, partNum);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.delimiter();
    }

    public Expression copy$default$3() {
        return this.partNum();
    }

    @Override
    public String productPrefix() {
        return "SplitPart";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.str();
                break;
            }
            case 1: {
                expression = this.delimiter();
                break;
            }
            case 2: {
                expression = this.partNum();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SplitPart;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SplitPart)) return false;
        boolean bl = true;
        if (!bl) return false;
        SplitPart splitPart = (SplitPart)x$1;
        Expression expression = this.str();
        Expression expression2 = splitPart.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.delimiter();
        Expression expression4 = splitPart.delimiter();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.partNum();
        Expression expression6 = splitPart.partNum();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!splitPart.canEqual(this)) return false;
        return true;
    }

    public SplitPart(Expression str, Expression delimiter, Expression partNum) {
        this.str = str;
        this.delimiter = delimiter;
        this.partNum = partNum;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
    }
}

