/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.statsEstimation;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeMap$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.plans.logical.Statistics$;
import org.apache.spark.sql.catalyst.statsEstimation.StatsEstimationTestBase;
import org.apache.spark.sql.catalyst.statsEstimation.StatsTestPlan;
import org.apache.spark.sql.catalyst.statsEstimation.StatsTestPlan$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001)3Aa\u0001\u0003\u0001#!)!\u0004\u0001C\u00017!)Q\u0004\u0001C\u0005=\t1\u0002K]8kK\u000e$Xi\u001d;j[\u0006$\u0018n\u001c8Tk&$XM\u0003\u0002\u0006\r\u0005y1\u000f^1ug\u0016\u001bH/[7bi&|gN\u0003\u0002\b\u0011\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001%Y\u0001\"a\u0005\u000b\u000e\u0003)I!!\u0006\u0006\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t9\u0002$D\u0001\u0005\u0013\tIBAA\fTi\u0006$8/R:uS6\fG/[8o)\u0016\u001cHOQ1tK\u00061A(\u001b8jiz\"\u0012\u0001\b\t\u0003/\u0001\t\u0011c\u00195fG.\u0004&o\u001c6fGR\u001cF/\u0019;t)\u0015yRe\f\u001eI!\t\u00013%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0005\u0011)f.\u001b;\t\u000b\u0019\u0012\u0001\u0019A\u0014\u0002\u000b\rD\u0017\u000e\u001c3\u0011\u0005!jS\"A\u0015\u000b\u0005)Z\u0013a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003Y\u0019\tQ\u0001\u001d7b]NL!AL\u0015\u0003\u00171{w-[2bYBc\u0017M\u001c\u0005\u0006a\t\u0001\r!M\u0001\u000faJ|'.Z2u\u0003R$(/T1q!\r\u0011TgN\u0007\u0002g)\u0011AGB\u0001\fKb\u0004(/Z:tS>t7/\u0003\u00027g\ta\u0011\t\u001e;sS\n,H/Z'baB\u0011\u0001\u0006O\u0005\u0003s%\u0012!bQ8mk6t7\u000b^1u\u0011\u0015Y$\u00011\u0001=\u00031)\u0007\u0010]3di\u0016$7+\u001b>f!\tiTI\u0004\u0002?\u0007:\u0011qHQ\u0007\u0002\u0001*\u0011\u0011\tE\u0001\u0007yI|w\u000e\u001e \n\u0003\tJ!\u0001R\u0011\u0002\u000fA\f7m[1hK&\u0011ai\u0012\u0002\u0007\u0005&<\u0017J\u001c;\u000b\u0005\u0011\u000b\u0003\"B%\u0003\u0001\u0004a\u0014\u0001E3ya\u0016\u001cG/\u001a3S_^\u001cu.\u001e8u\u0001")
public class ProjectEstimationSuite
extends SparkFunSuite
implements StatsEstimationTestBase {
    private boolean originalCBOValue;
    private boolean originalPlanStatsValue;

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$statsEstimation$StatsEstimationTestBase$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$statsEstimation$StatsEstimationTestBase$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public void beforeAll() {
        StatsEstimationTestBase.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        StatsEstimationTestBase.afterAll$(this);
    }

    @Override
    public long getColSize(Attribute attribute, ColumnStat colStat) {
        return StatsEstimationTestBase.getColSize$(this, attribute, colStat);
    }

    @Override
    public AttributeReference attr(String colName) {
        return StatsEstimationTestBase.attr$(this, colName);
    }

    @Override
    public AttributeMap<ColumnStat> toAttributeMap(Seq<Tuple2<String, ColumnStat>> colStats, LogicalPlan plan) {
        return StatsEstimationTestBase.toAttributeMap$(this, colStats, plan);
    }

    @Override
    public ColumnStat rangeColumnStat(int distinctCount, int nullCount) {
        return StatsEstimationTestBase.rangeColumnStat$(this, distinctCount, nullCount);
    }

    @Override
    public boolean originalCBOValue() {
        return this.originalCBOValue;
    }

    @Override
    public void originalCBOValue_$eq(boolean x$1) {
        this.originalCBOValue = x$1;
    }

    @Override
    public boolean originalPlanStatsValue() {
        return this.originalPlanStatsValue;
    }

    @Override
    public void originalPlanStatsValue_$eq(boolean x$1) {
        this.originalPlanStatsValue = x$1;
    }

    private void checkProjectStats(LogicalPlan child, AttributeMap<ColumnStat> projectAttrMap, BigInt expectedSize, BigInt expectedRowCount) {
        Project proj = new Project(projectAttrMap.keys().toSeq(), child);
        Statistics expectedStats = new Statistics(expectedSize, (Option)new Some((Object)expectedRowCount), projectAttrMap, Statistics$.MODULE$.apply$default$4());
        Statistics $org_scalatest_assert_macro_left = proj.stats();
        Statistics $org_scalatest_assert_macro_right = expectedStats;
        Statistics statistics = $org_scalatest_assert_macro_left;
        Statistics statistics2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(statistics != null ? !statistics.equals(statistics2) : statistics2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ProjectEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
    }

    public ProjectEstimationSuite() {
        StatsEstimationTestBase.$init$(this);
        this.test("project with alias", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2 = new Tuple2((Object)this.attr("key1"), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8()));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            AttributeReference ar1 = (AttributeReference)tuple2._1();
            ColumnStat colStat1 = (ColumnStat)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)ar1, (Object)colStat1);
            Tuple2 tuple23 = tuple22;
            AttributeReference ar12 = (AttributeReference)tuple23._1();
            ColumnStat colStat12 = (ColumnStat)tuple23._2();
            Tuple2 tuple24 = new Tuple2((Object)this.attr("key2"), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)10)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)10)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8()));
            if (tuple24 == null) {
                throw new MatchError((Object)tuple24);
            }
            AttributeReference ar2 = (AttributeReference)tuple24._1();
            ColumnStat colStat2 = (ColumnStat)tuple24._2();
            Tuple2 tuple25 = new Tuple2((Object)ar2, (Object)colStat2);
            Tuple2 tuple26 = tuple25;
            AttributeReference ar22 = (AttributeReference)tuple26._1();
            ColumnStat colStat22 = (ColumnStat)tuple26._2();
            StatsTestPlan child = new StatsTestPlan((Seq<Attribute>)((Seq)new .colon.colon((Object)ar12, (List)new .colon.colon((Object)ar22, (List)Nil$.MODULE$))), BigInt$.MODULE$.int2bigInt(2), (AttributeMap<ColumnStat>)AttributeMap$.MODULE$.apply((Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ar12), (Object)colStat12), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ar22), (Object)colStat22), (List)Nil$.MODULE$))), StatsTestPlan$.MODULE$.apply$default$4());
            AttributeReference x$1 = ar22;
            String x$2 = "abc";
            ExprId x$3 = Alias$.MODULE$.apply$default$3((Expression)x$1, x$2);
            Seq x$4 = Alias$.MODULE$.apply$default$4((Expression)x$1, x$2);
            Option x$5 = Alias$.MODULE$.apply$default$5((Expression)x$1, x$2);
            Seq x$6 = Alias$.MODULE$.apply$default$6((Expression)x$1, x$2);
            Project proj = new Project((Seq)new .colon.colon((Object)ar12, (List)new .colon.colon((Object)new Alias((Expression)x$1, x$2, x$3, x$4, x$5, x$6), (List)Nil$.MODULE$)), (LogicalPlan)child);
            Seq expectedColStats = (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key1"), (Object)colStat12), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"abc"), (Object)colStat22), (List)Nil$.MODULE$));
            AttributeMap<ColumnStat> expectedAttrStats = this.toAttributeMap((Seq<Tuple2<String, ColumnStat>>)expectedColStats, (LogicalPlan)proj);
            Statistics expectedStats = new Statistics(BigInt$.MODULE$.int2bigInt(32), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), expectedAttrStats, Statistics$.MODULE$.apply$default$4());
            Statistics $org_scalatest_assert_macro_left = proj.stats();
            Statistics $org_scalatest_assert_macro_right = expectedStats;
            Statistics statistics = $org_scalatest_assert_macro_left;
            Statistics statistics2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(statistics != null ? !statistics.equals(statistics2) : statistics2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ProjectEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
        }, new Position("ProjectEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30));
        this.test("project on empty table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2 = new Tuple2((Object)this.attr("key1"), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8()));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            AttributeReference ar1 = (AttributeReference)tuple2._1();
            ColumnStat colStat1 = (ColumnStat)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)ar1, (Object)colStat1);
            Tuple2 tuple23 = tuple22;
            AttributeReference ar12 = (AttributeReference)tuple23._1();
            ColumnStat colStat12 = (ColumnStat)tuple23._2();
            StatsTestPlan child = new StatsTestPlan((Seq<Attribute>)((Seq)new .colon.colon((Object)ar12, (List)Nil$.MODULE$)), BigInt$.MODULE$.int2bigInt(0), (AttributeMap<ColumnStat>)AttributeMap$.MODULE$.apply((Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ar12), (Object)colStat12), (List)Nil$.MODULE$)), StatsTestPlan$.MODULE$.apply$default$4());
            this.checkProjectStats(child, child.attributeStats(), BigInt$.MODULE$.int2bigInt(1), BigInt$.MODULE$.int2bigInt(0));
        }, new Position("ProjectEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
        this.test("test row size estimation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Decimal dec1 = Decimal$.MODULE$.apply("1.000000000000000000");
            Decimal dec2 = Decimal$.MODULE$.apply("8.000000000000000000");
            int d1 = DateTimeUtils$.MODULE$.fromJavaDate(Date.valueOf("2016-05-08"));
            int d2 = DateTimeUtils$.MODULE$.fromJavaDate(Date.valueOf("2016-05-09"));
            long t1 = DateTimeUtils$.MODULE$.fromJavaTimestamp(Timestamp.valueOf("2016-05-08 00:00:01"));
            long t2 = DateTimeUtils$.MODULE$.fromJavaTimestamp(Timestamp.valueOf("2016-05-09 00:00:02"));
            Tuple2[] tuple2Array = new Tuple2[12];
            String x$7 = "cbool";
            BooleanType$ x$8 = BooleanType$.MODULE$;
            boolean x$9 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$10 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$11 = AttributeReference$.MODULE$.apply$default$5(x$7, (DataType)x$8, x$9, x$10);
            Seq x$12 = AttributeReference$.MODULE$.apply$default$6(x$7, (DataType)x$8, x$9, x$10);
            tuple2Array[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new AttributeReference(x$7, (DataType)x$8, x$9, x$10, x$11, x$12)), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)), (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8()));
            String x$13 = "cbyte";
            ByteType$ x$14 = ByteType$.MODULE$;
            boolean x$15 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$16 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$17 = AttributeReference$.MODULE$.apply$default$5(x$13, (DataType)x$14, x$15, x$16);
            Seq x$18 = AttributeReference$.MODULE$.apply$default$6(x$13, (DataType)x$14, x$15, x$16);
            tuple2Array[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new AttributeReference(x$13, (DataType)x$14, x$15, x$16, x$17, x$18)), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8()));
            String x$19 = "cshort";
            ShortType$ x$20 = ShortType$.MODULE$;
            boolean x$21 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$22 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$23 = AttributeReference$.MODULE$.apply$default$5(x$19, (DataType)x$20, x$21, x$22);
            Seq x$24 = AttributeReference$.MODULE$.apply$default$6(x$19, (DataType)x$20, x$21, x$22);
            tuple2Array[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new AttributeReference(x$19, (DataType)x$20, x$21, x$22, x$23, x$24)), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)2L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8()));
            String x$25 = "cint";
            IntegerType$ x$26 = IntegerType$.MODULE$;
            boolean x$27 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$28 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$29 = AttributeReference$.MODULE$.apply$default$5(x$25, (DataType)x$26, x$27, x$28);
            Seq x$30 = AttributeReference$.MODULE$.apply$default$6(x$25, (DataType)x$26, x$27, x$28);
            tuple2Array[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new AttributeReference(x$25, (DataType)x$26, x$27, x$28, x$29, x$30)), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)4)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8()));
            String x$31 = "clong";
            LongType$ x$32 = LongType$.MODULE$;
            boolean x$33 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$34 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$35 = AttributeReference$.MODULE$.apply$default$5(x$31, (DataType)x$32, x$33, x$34);
            Seq x$36 = AttributeReference$.MODULE$.apply$default$6(x$31, (DataType)x$32, x$33, x$34);
            tuple2Array[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new AttributeReference(x$31, (DataType)x$32, x$33, x$34, x$35, x$36)), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)5)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)8L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)8L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8()));
            String x$37 = "cdouble";
            DoubleType$ x$38 = DoubleType$.MODULE$;
            boolean x$39 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$40 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$41 = AttributeReference$.MODULE$.apply$default$5(x$37, (DataType)x$38, x$39, x$40);
            Seq x$42 = AttributeReference$.MODULE$.apply$default$6(x$37, (DataType)x$38, x$39, x$40);
            tuple2Array[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new AttributeReference(x$37, (DataType)x$38, x$39, x$40, x$41, x$42)), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), (Option)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Option)new Some((Object)BoxesRunTime.boxToDouble((double)6.0)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)8L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)8L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8()));
            String x$43 = "cfloat";
            FloatType$ x$44 = FloatType$.MODULE$;
            boolean x$45 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$46 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$47 = AttributeReference$.MODULE$.apply$default$5(x$43, (DataType)x$44, x$45, x$46);
            Seq x$48 = AttributeReference$.MODULE$.apply$default$6(x$43, (DataType)x$44, x$45, x$46);
            tuple2Array[6] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new AttributeReference(x$43, (DataType)x$44, x$45, x$46, x$47, x$48)), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), (Option)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Option)new Some((Object)BoxesRunTime.boxToDouble((double)7.0)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8()));
            String x$49 = "cdecimal";
            DecimalType x$50 = DecimalType$.MODULE$.SYSTEM_DEFAULT();
            boolean x$51 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$52 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$53 = AttributeReference$.MODULE$.apply$default$5(x$49, (DataType)x$50, x$51, x$52);
            Seq x$54 = AttributeReference$.MODULE$.apply$default$6(x$49, (DataType)x$50, x$51, x$52);
            tuple2Array[7] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new AttributeReference(x$49, (DataType)x$50, x$51, x$52, x$53, x$54)), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), (Option)new Some((Object)dec1), (Option)new Some((Object)dec2), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)16L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)16L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8()));
            String x$55 = "cstring";
            StringType$ x$56 = StringType$.MODULE$;
            boolean x$57 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$58 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$59 = AttributeReference$.MODULE$.apply$default$5(x$55, (DataType)x$56, x$57, x$58);
            Seq x$60 = AttributeReference$.MODULE$.apply$default$6(x$55, (DataType)x$56, x$57, x$58);
            tuple2Array[8] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new AttributeReference(x$55, (DataType)x$56, x$57, x$58, x$59, x$60)), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8()));
            String x$61 = "cbinary";
            BinaryType$ x$62 = BinaryType$.MODULE$;
            boolean x$63 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$64 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$65 = AttributeReference$.MODULE$.apply$default$5(x$61, (DataType)x$62, x$63, x$64);
            Seq x$66 = AttributeReference$.MODULE$.apply$default$6(x$61, (DataType)x$62, x$63, x$64);
            tuple2Array[9] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new AttributeReference(x$61, (DataType)x$62, x$63, x$64, x$65, x$66)), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8()));
            String x$67 = "cdate";
            DateType$ x$68 = DateType$.MODULE$;
            boolean x$69 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$70 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$71 = AttributeReference$.MODULE$.apply$default$5(x$67, (DataType)x$68, x$69, x$70);
            Seq x$72 = AttributeReference$.MODULE$.apply$default$6(x$67, (DataType)x$68, x$69, x$70);
            tuple2Array[10] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new AttributeReference(x$67, (DataType)x$68, x$69, x$70, x$71, x$72)), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)d1)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)d2)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8()));
            String x$73 = "ctimestamp";
            TimestampType$ x$74 = TimestampType$.MODULE$;
            boolean x$75 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$76 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$77 = AttributeReference$.MODULE$.apply$default$5(x$73, (DataType)x$74, x$75, x$76);
            Seq x$78 = AttributeReference$.MODULE$.apply$default$6(x$73, (DataType)x$74, x$75, x$76);
            tuple2Array[11] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new AttributeReference(x$73, (DataType)x$74, x$75, x$76, x$77, x$78)), (Object)new ColumnStat((Option)new Some((Object)BigInt$.MODULE$.int2bigInt(2)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)t1)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)t2)), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)8L)), (Option)new Some((Object)BoxesRunTime.boxToLong((long)8L)), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8()));
            AttributeMap columnInfo = AttributeMap$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
            Map columnSizes = (Map)columnInfo.map((Function1 & Serializable & scala.Serializable)kv -> new Tuple2(kv._1(), (Object)BoxesRunTime.boxToLong((long)this.getColSize((Attribute)kv._1(), (ColumnStat)kv._2()))), Map$.MODULE$.canBuildFrom());
            StatsTestPlan child = new StatsTestPlan((Seq<Attribute>)columnInfo.keys().toSeq(), BigInt$.MODULE$.int2bigInt(2), (AttributeMap<ColumnStat>)columnInfo, StatsTestPlan$.MODULE$.apply$default$4());
            columnInfo.keys().foreach((Function1 & Serializable & scala.Serializable)attr -> {
                this.withClue(new StringBuilder(14).append("For data type ").append(attr.dataType()).toString(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)attr), columnInfo$1.apply((Object)attr));
                    $this.checkProjectStats(child$1, (AttributeMap<ColumnStat>)AttributeMap$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)tuple2)), BigInt$.MODULE$.long2bigInt(2L * (8L + BoxesRunTime.unboxToLong((Object)columnSizes$1.apply((Object)attr)))), BigInt$.MODULE$.int2bigInt(2));
                });
                return BoxedUnit.UNIT;
            });
            this.checkProjectStats(child, (AttributeMap<ColumnStat>)columnInfo, BigInt$.MODULE$.long2bigInt(2L * (8L + BoxesRunTime.unboxToLong((Object)columnSizes.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$)))), BigInt$.MODULE$.int2bigInt(2));
        }, new Position("ProjectEstimationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
    }
}

