/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.util;

import java.io.Serializable;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.IntervalUnit;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$Fixed$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;

public final class ArrowUtils$ {
    public static ArrowUtils$ MODULE$;
    private final RootAllocator rootAllocator;

    static {
        new ArrowUtils$();
    }

    public RootAllocator rootAllocator() {
        return this.rootAllocator;
    }

    public ArrowType toArrowType(DataType dt, String timeZoneId) {
        DecimalType decimalType;
        Option<Tuple2<Object, Object>> option;
        boolean bl = false;
        DataType dataType = null;
        DataType dataType2 = dt;
        if (BooleanType$.MODULE$.equals(dataType2)) {
            return ArrowType.Bool.INSTANCE;
        }
        if (ByteType$.MODULE$.equals(dataType2)) {
            return new ArrowType.Int(8, true);
        }
        if (ShortType$.MODULE$.equals(dataType2)) {
            return new ArrowType.Int(16, true);
        }
        if (IntegerType$.MODULE$.equals(dataType2)) {
            return new ArrowType.Int(32, true);
        }
        if (LongType$.MODULE$.equals(dataType2)) {
            return new ArrowType.Int(64, true);
        }
        if (FloatType$.MODULE$.equals(dataType2)) {
            return new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE);
        }
        if (DoubleType$.MODULE$.equals(dataType2)) {
            return new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE);
        }
        if (StringType$.MODULE$.equals(dataType2)) {
            return ArrowType.Utf8.INSTANCE;
        }
        if (BinaryType$.MODULE$.equals(dataType2)) {
            return ArrowType.Binary.INSTANCE;
        }
        if (dataType2 instanceof DecimalType && !(option = DecimalType$Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType2)).isEmpty()) {
            int precision = ((Tuple2)option.get())._1$mcI$sp();
            int scale = ((Tuple2)option.get())._2$mcI$sp();
            return new ArrowType.Decimal(precision, scale);
        }
        if (DateType$.MODULE$.equals(dataType2)) {
            return new ArrowType.Date(DateUnit.DAY);
        }
        if (TimestampType$.MODULE$.equals(dataType2)) {
            bl = true;
            dataType = dataType2;
            if (timeZoneId == null) {
                throw new IllegalStateException("Missing timezoneId where it is mandatory.");
            }
        }
        if (bl) {
            return new ArrowType.Timestamp(TimeUnit.MICROSECOND, timeZoneId);
        }
        if (TimestampNTZType$.MODULE$.equals(dataType2)) {
            return new ArrowType.Timestamp(TimeUnit.MICROSECOND, null);
        }
        if (NullType$.MODULE$.equals(dataType2)) {
            return ArrowType.Null.INSTANCE;
        }
        if (dataType2 instanceof YearMonthIntervalType) {
            return new ArrowType.Interval(IntervalUnit.YEAR_MONTH);
        }
        if (dataType2 instanceof DayTimeIntervalType) {
            return new ArrowType.Duration(TimeUnit.MICROSECOND);
        }
        throw QueryExecutionErrors$.MODULE$.unsupportedDataTypeError(dt.catalogString());
    }

    public DataType fromArrowType(ArrowType dt) {
        boolean bl = false;
        ArrowType.Int intVal = null;
        boolean bl2 = false;
        ArrowType.FloatingPoint floatingPoint = null;
        boolean bl3 = false;
        ArrowType.Timestamp timestamp = null;
        ArrowType arrowType = dt;
        ArrowType.Bool bool = ArrowType.Bool.INSTANCE;
        ArrowType arrowType2 = arrowType;
        if (!(bool != null ? !bool.equals(arrowType2) : arrowType2 != null)) {
            return BooleanType$.MODULE$;
        }
        if (arrowType instanceof ArrowType.Int) {
            bl = true;
            intVal = (ArrowType.Int)arrowType;
            if (intVal.getIsSigned() && intVal.getBitWidth() == 8) {
                return ByteType$.MODULE$;
            }
        }
        if (bl && intVal.getIsSigned() && intVal.getBitWidth() == 16) {
            return ShortType$.MODULE$;
        }
        if (bl && intVal.getIsSigned() && intVal.getBitWidth() == 32) {
            return IntegerType$.MODULE$;
        }
        if (bl && intVal.getIsSigned() && intVal.getBitWidth() == 64) {
            return LongType$.MODULE$;
        }
        if (arrowType instanceof ArrowType.FloatingPoint) {
            bl2 = true;
            floatingPoint = (ArrowType.FloatingPoint)arrowType;
            FloatingPointPrecision floatingPointPrecision = floatingPoint.getPrecision();
            FloatingPointPrecision floatingPointPrecision2 = FloatingPointPrecision.SINGLE;
            if (!(floatingPointPrecision != null ? !floatingPointPrecision.equals(floatingPointPrecision2) : floatingPointPrecision2 != null)) {
                return FloatType$.MODULE$;
            }
        }
        if (bl2) {
            FloatingPointPrecision floatingPointPrecision = floatingPoint.getPrecision();
            FloatingPointPrecision floatingPointPrecision3 = FloatingPointPrecision.DOUBLE;
            if (!(floatingPointPrecision != null ? !floatingPointPrecision.equals(floatingPointPrecision3) : floatingPointPrecision3 != null)) {
                return DoubleType$.MODULE$;
            }
        }
        ArrowType.Utf8 utf8 = ArrowType.Utf8.INSTANCE;
        ArrowType arrowType3 = arrowType;
        if (!(utf8 != null ? !utf8.equals(arrowType3) : arrowType3 != null)) {
            return StringType$.MODULE$;
        }
        ArrowType.Binary binary = ArrowType.Binary.INSTANCE;
        ArrowType arrowType4 = arrowType;
        if (!(binary != null ? !binary.equals(arrowType4) : arrowType4 != null)) {
            return BinaryType$.MODULE$;
        }
        if (arrowType instanceof ArrowType.Decimal) {
            ArrowType.Decimal decimal = (ArrowType.Decimal)arrowType;
            return new DecimalType(decimal.getPrecision(), decimal.getScale());
        }
        if (arrowType instanceof ArrowType.Date) {
            ArrowType.Date date = (ArrowType.Date)arrowType;
            DateUnit dateUnit = date.getUnit();
            DateUnit dateUnit2 = DateUnit.DAY;
            if (!(dateUnit != null ? !dateUnit.equals(dateUnit2) : dateUnit2 != null)) {
                return DateType$.MODULE$;
            }
        }
        if (arrowType instanceof ArrowType.Timestamp) {
            bl3 = true;
            timestamp = (ArrowType.Timestamp)arrowType;
            TimeUnit timeUnit = timestamp.getUnit();
            TimeUnit timeUnit2 = TimeUnit.MICROSECOND;
            if (!(timeUnit != null ? !timeUnit.equals(timeUnit2) : timeUnit2 != null) && timestamp.getTimezone() == null) {
                return TimestampNTZType$.MODULE$;
            }
        }
        if (bl3) {
            TimeUnit timeUnit = timestamp.getUnit();
            TimeUnit timeUnit3 = TimeUnit.MICROSECOND;
            if (!(timeUnit != null ? !timeUnit.equals(timeUnit3) : timeUnit3 != null)) {
                return TimestampType$.MODULE$;
            }
        }
        ArrowType.Null nullVal = ArrowType.Null.INSTANCE;
        ArrowType arrowType5 = arrowType;
        if (!(nullVal != null ? !nullVal.equals(arrowType5) : arrowType5 != null)) {
            return NullType$.MODULE$;
        }
        if (arrowType instanceof ArrowType.Interval) {
            ArrowType.Interval interval = (ArrowType.Interval)arrowType;
            IntervalUnit intervalUnit = interval.getUnit();
            IntervalUnit intervalUnit2 = IntervalUnit.YEAR_MONTH;
            if (!(intervalUnit != null ? !intervalUnit.equals(intervalUnit2) : intervalUnit2 != null)) {
                return YearMonthIntervalType$.MODULE$.apply();
            }
        }
        if (arrowType instanceof ArrowType.Duration) {
            ArrowType.Duration duration = (ArrowType.Duration)arrowType;
            TimeUnit timeUnit = duration.getUnit();
            TimeUnit timeUnit4 = TimeUnit.MICROSECOND;
            if (!(timeUnit != null ? !timeUnit.equals(timeUnit4) : timeUnit4 != null)) {
                return DayTimeIntervalType$.MODULE$.apply();
            }
        }
        throw QueryExecutionErrors$.MODULE$.unsupportedDataTypeError(dt.toString());
    }

    public Field toArrowField(String name, DataType dt, boolean nullable, String timeZoneId) {
        DataType dataType = dt;
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType elementType = arrayType.elementType();
            boolean containsNull = arrayType.containsNull();
            FieldType fieldType = new FieldType(nullable, (ArrowType)ArrowType.List.INSTANCE, null);
            return new Field(name, fieldType, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.toArrowField("element", elementType, containsNull, timeZoneId), (List)Nil$.MODULE$)).asJava());
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            FieldType fieldType = new FieldType(nullable, (ArrowType)ArrowType.Struct.INSTANCE, null);
            return new Field(name, fieldType, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).map((Function1 & Serializable & scala.Serializable)field -> MODULE$.toArrowField(field.name(), field.dataType(), field.nullable(), timeZoneId), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Field.class))))).toSeq()).asJava());
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            FieldType mapType2 = new FieldType(nullable, (ArrowType)new ArrowType.Map(false), null);
            return new Field(name, mapType2, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.toArrowField("entries", new StructType().add("key", keyType, false).add("value", valueType, valueContainsNull), false, timeZoneId), (List)Nil$.MODULE$)).asJava());
        }
        FieldType fieldType = new FieldType(nullable, this.toArrowType(dataType, timeZoneId), null);
        return new Field(name, fieldType, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava());
    }

    public DataType fromArrowField(Field field) {
        ArrowType arrowType = field.getType();
        if (arrowType instanceof ArrowType.Map) {
            Field elementField = (Field)field.getChildren().get(0);
            DataType keyType = this.fromArrowField((Field)elementField.getChildren().get(0));
            DataType valueType = this.fromArrowField((Field)elementField.getChildren().get(1));
            return new MapType(keyType, valueType, ((Field)elementField.getChildren().get(1)).isNullable());
        }
        ArrowType.List list = ArrowType.List.INSTANCE;
        ArrowType arrowType2 = arrowType;
        if (!(list != null ? !list.equals(arrowType2) : arrowType2 != null)) {
            Field elementField = (Field)field.getChildren().get(0);
            DataType elementType = this.fromArrowField(elementField);
            return new ArrayType(elementType, elementField.isNullable());
        }
        ArrowType.Struct struct = ArrowType.Struct.INSTANCE;
        ArrowType arrowType3 = arrowType;
        if (!(struct != null ? !struct.equals(arrowType3) : arrowType3 != null)) {
            Buffer fields = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(field.getChildren()).asScala()).map((Function1 & Serializable & scala.Serializable)child -> {
                DataType dt = MODULE$.fromArrowField((Field)child);
                return new StructField(child.getName(), dt, child.isNullable(), StructField$.MODULE$.apply$default$4());
            }, Buffer$.MODULE$.canBuildFrom());
            return StructType$.MODULE$.apply((Seq<StructField>)fields.toSeq());
        }
        return this.fromArrowType(arrowType);
    }

    public Schema toArrowSchema(StructType schema, String timeZoneId) {
        return new Schema((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)schema.map((Function1 & Serializable & scala.Serializable)field -> MODULE$.toArrowField(field.name(), field.dataType(), field.nullable(), timeZoneId), Seq$.MODULE$.canBuildFrom())).asJava());
    }

    public StructType fromArrowSchema(Schema schema) {
        return StructType$.MODULE$.apply((Seq<StructField>)((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(schema.getFields()).asScala()).map((Function1 & Serializable & scala.Serializable)field -> {
            DataType dt = MODULE$.fromArrowField((Field)field);
            return new StructField(field.getName(), dt, field.isNullable(), StructField$.MODULE$.apply$default$4());
        }, Buffer$.MODULE$.canBuildFrom())).toSeq());
    }

    public Map<String, String> getPythonRunnerConfMap(SQLConf conf) {
        Seq timeZoneConf = (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()), (Object)conf.sessionLocalTimeZone()), (List)Nil$.MODULE$);
        Seq pandasColsByName = (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PANDAS_GROUPED_MAP_ASSIGN_COLUMNS_BY_NAME().key()), (Object)Boolean.toString(conf.pandasGroupedMapAssignColumnsByName())), (List)Nil$.MODULE$);
        Seq arrowSafeTypeCheck = (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PANDAS_ARROW_SAFE_TYPE_CONVERSION().key()), (Object)Boolean.toString(conf.arrowSafeTypeConversion())), (List)Nil$.MODULE$);
        return (Map)Predef$.MODULE$.Map().apply((Seq)((TraversableLike)timeZoneConf.$plus$plus((GenTraversableOnce)pandasColsByName, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)arrowSafeTypeCheck, Seq$.MODULE$.canBuildFrom()));
    }

    private ArrowUtils$() {
        MODULE$ = this;
        this.rootAllocator = new RootAllocator(Long.MAX_VALUE);
    }
}

