/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.errors;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.text.ParseException;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.spark.Partition;
import org.apache.spark.SparkArithmeticException;
import org.apache.spark.SparkArithmeticException$;
import org.apache.spark.SparkArrayIndexOutOfBoundsException;
import org.apache.spark.SparkClassNotFoundException;
import org.apache.spark.SparkConcurrentModificationException;
import org.apache.spark.SparkConcurrentModificationException$;
import org.apache.spark.SparkDateTimeException;
import org.apache.spark.SparkDateTimeException$;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFileAlreadyExistsException;
import org.apache.spark.SparkFileNotFoundException;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.SparkIndexOutOfBoundsException;
import org.apache.spark.SparkNoSuchElementException;
import org.apache.spark.SparkNoSuchMethodException;
import org.apache.spark.SparkNumberFormatException;
import org.apache.spark.SparkRuntimeException;
import org.apache.spark.SparkRuntimeException$;
import org.apache.spark.SparkSQLException;
import org.apache.spark.SparkSQLFeatureNotSupportedException;
import org.apache.spark.SparkSecurityException;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.SparkUpgradeException;
import org.apache.spark.executor.CommitDeniedException;
import org.apache.spark.memory.SparkOutOfMemoryError;
import org.apache.spark.sql.catalyst.ScalaReflection;
import org.apache.spark.sql.catalyst.WalkedTypePath;
import org.apache.spark.sql.catalyst.analysis.UnresolvedGenerator;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.logical.DomainJoin;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.ValueInterval;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.BadRecordException;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.connector.catalog.CatalogNotFoundException;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.execution.QueryExecutionException;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.SQLConf$MapKeyDedupPolicy$;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.CircularBuffer;
import org.apache.spark.util.Utils$;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.janino.InternalCompilerException;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class QueryExecutionErrors$
implements QueryErrorsBase {
    public static QueryExecutionErrors$ MODULE$;
    private final String aesFuncName;

    static {
        new QueryExecutionErrors$();
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String toSQLStmt(String text) {
        return QueryErrorsBase.toSQLStmt$(this, text);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return QueryErrorsBase.toSQLId$((QueryErrorsBase)this, parts);
    }

    @Override
    public String toSQLId(String parts) {
        return QueryErrorsBase.toSQLId$((QueryErrorsBase)this, parts);
    }

    @Override
    public String toSQLType(DataType t) {
        return QueryErrorsBase.toSQLType$((QueryErrorsBase)this, t);
    }

    @Override
    public String toSQLType(String text) {
        return QueryErrorsBase.toSQLType$((QueryErrorsBase)this, text);
    }

    @Override
    public String toSQLConf(String conf) {
        return QueryErrorsBase.toSQLConf$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    public Throwable cannotEvaluateExpressionError(Expression expression) {
        return new SparkUnsupportedOperationException("INTERNAL_ERROR", (String[])((Object[])new String[]{new StringBuilder(28).append("Cannot evaluate expression: ").append(expression).toString()}));
    }

    public Throwable cannotGenerateCodeForExpressionError(Expression expression) {
        return new SparkUnsupportedOperationException("INTERNAL_ERROR", (String[])((Object[])new String[]{new StringBuilder(37).append("Cannot generate code for expression: ").append(expression).toString()}));
    }

    public Throwable cannotTerminateGeneratorError(UnresolvedGenerator generator) {
        return new SparkUnsupportedOperationException("INTERNAL_ERROR", (String[])((Object[])new String[]{new StringBuilder(29).append("Cannot terminate expression: ").append(generator).toString()}));
    }

    public ArithmeticException castingCauseOverflowError(Object t, DataType from, DataType to) {
        return new SparkArithmeticException("CAST_OVERFLOW", (String[])((Object[])new String[]{this.toSQLValue(t, from), this.toSQLType(from), this.toSQLType(to), this.toSQLConf(SQLConf$.MODULE$.ANSI_ENABLED().key())}), SparkArithmeticException$.MODULE$.$lessinit$greater$default$3());
    }

    public ArithmeticException castingCauseOverflowErrorInTableInsert(DataType from, DataType to, String columnName) {
        return new SparkArithmeticException("CAST_OVERFLOW_IN_TABLE_INSERT", (String[])((Object[])new String[]{this.toSQLType(from), this.toSQLType(to), this.toSQLId(columnName)}), SparkArithmeticException$.MODULE$.$lessinit$greater$default$3());
    }

    public ArithmeticException cannotChangeDecimalPrecisionError(Decimal value, int decimalPrecision, int decimalScale, String context) {
        return new SparkArithmeticException("CANNOT_CHANGE_DECIMAL_PRECISION", (String[])((Object[])new String[]{value.toDebugString(), Integer.toString(decimalPrecision), Integer.toString(decimalScale), this.toSQLConf(SQLConf$.MODULE$.ANSI_ENABLED().key())}), context);
    }

    public Throwable invalidInputInCastToDatetimeError(Object value, DataType from, DataType to, String errorContext) {
        return new SparkDateTimeException("CAST_INVALID_INPUT", (String[])((Object[])new String[]{this.toSQLValue(value, from), this.toSQLType(from), this.toSQLType(to), this.toSQLConf(SQLConf$.MODULE$.ANSI_ENABLED().key())}), errorContext);
    }

    public SparkRuntimeException invalidInputSyntaxForBooleanError(UTF8String s, String errorContext) {
        String x$1 = "CAST_INVALID_INPUT";
        String[] x$2 = (String[])((Object[])new String[]{this.toSQLValue(s, StringType$.MODULE$), this.toSQLType(StringType$.MODULE$), this.toSQLType(BooleanType$.MODULE$), this.toSQLConf(SQLConf$.MODULE$.ANSI_ENABLED().key())});
        String x$3 = errorContext;
        Throwable x$4 = SparkRuntimeException$.MODULE$.$lessinit$greater$default$3();
        return new SparkRuntimeException(x$1, x$2, x$4, x$3);
    }

    public SparkNumberFormatException invalidInputInCastToNumberError(DataType to, UTF8String s, String errorContext) {
        return new SparkNumberFormatException("CAST_INVALID_INPUT", (String[])((Object[])new String[]{this.toSQLValue(s, StringType$.MODULE$), this.toSQLType(StringType$.MODULE$), this.toSQLType(to), this.toSQLConf(SQLConf$.MODULE$.ANSI_ENABLED().key())}), errorContext);
    }

    public Throwable cannotCastFromNullTypeError(DataType to) {
        return new SparkException("CANNOT_CAST_DATATYPE", (String[])((Object[])new String[]{NullType$.MODULE$.typeName(), to.typeName()}), null);
    }

    public Throwable cannotCastError(DataType from, DataType to) {
        return new SparkException("CANNOT_CAST_DATATYPE", (String[])((Object[])new String[]{from.typeName(), to.typeName()}), null);
    }

    public Throwable cannotParseDecimalError() {
        return new SparkRuntimeException("CANNOT_PARSE_DECIMAL", (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4());
    }

    public Throwable dataTypeUnsupportedError(String dataType, String failure) {
        return new SparkIllegalArgumentException("UNSUPPORTED_DATATYPE", (String[])((Object[])new String[]{new StringBuilder(0).append(dataType).append(failure).toString()}));
    }

    public Throwable failedExecuteUserDefinedFunctionError(String funcCls, String inputTypes, String outputType, Throwable e) {
        return new SparkException("FAILED_EXECUTE_UDF", (String[])((Object[])new String[]{funcCls, inputTypes, outputType}), e);
    }

    public ArithmeticException divideByZeroError(String context) {
        return new SparkArithmeticException("DIVIDE_BY_ZERO", (String[])((Object[])new String[]{this.toSQLConf(SQLConf$.MODULE$.ANSI_ENABLED().key())}), context);
    }

    public ArrayIndexOutOfBoundsException invalidArrayIndexError(int index, int numElements) {
        return this.invalidArrayIndexErrorInternal(index, numElements, SQLConf$.MODULE$.ANSI_ENABLED().key());
    }

    public ArrayIndexOutOfBoundsException invalidInputIndexError(int index, int numElements) {
        return this.invalidArrayIndexErrorInternal(index, numElements, SQLConf$.MODULE$.ANSI_ENABLED().key());
    }

    private ArrayIndexOutOfBoundsException invalidArrayIndexErrorInternal(int index, int numElements, String key) {
        return new SparkArrayIndexOutOfBoundsException("INVALID_ARRAY_INDEX", (String[])((Object[])new String[]{this.toSQLValue(BoxesRunTime.boxToInteger((int)index), IntegerType$.MODULE$), this.toSQLValue(BoxesRunTime.boxToInteger((int)numElements), IntegerType$.MODULE$), this.toSQLConf(key)}));
    }

    public ArrayIndexOutOfBoundsException invalidElementAtIndexError(int index, int numElements) {
        return new SparkArrayIndexOutOfBoundsException("INVALID_ARRAY_INDEX_IN_ELEMENT_AT", (String[])((Object[])new String[]{this.toSQLValue(BoxesRunTime.boxToInteger((int)index), IntegerType$.MODULE$), this.toSQLValue(BoxesRunTime.boxToInteger((int)numElements), IntegerType$.MODULE$), this.toSQLConf(SQLConf$.MODULE$.ANSI_ENABLED().key())}));
    }

    public NoSuchElementException mapKeyNotExistError(Object key, DataType dataType, String context) {
        return new SparkNoSuchElementException("MAP_KEY_DOES_NOT_EXIST", (String[])((Object[])new String[]{this.toSQLValue(key, dataType), this.toSQLConf(SQLConf$.MODULE$.ANSI_ENABLED().key())}), context);
    }

    public Throwable inputTypeUnsupportedError(DataType dataType) {
        return new IllegalArgumentException(new StringBuilder(23).append("Unsupported input type ").append(dataType.catalogString()).toString());
    }

    public DateTimeException invalidFractionOfSecondError() {
        return new SparkDateTimeException("INVALID_FRACTION_OF_SECOND", (String[])((Object[])new String[]{this.toSQLConf(SQLConf$.MODULE$.ANSI_ENABLED().key())}), SparkDateTimeException$.MODULE$.$lessinit$greater$default$3());
    }

    public DateTimeParseException ansiDateTimeParseError(DateTimeParseException e) {
        String newMessage = new StringBuilder(50).append(e.getMessage()).append(". ").append("If necessary set ").append(SQLConf$.MODULE$.ANSI_ENABLED().key()).append(" to false to bypass this error.").toString();
        return new DateTimeParseException(newMessage, e.getParsedString(), e.getErrorIndex(), e.getCause());
    }

    public DateTimeException ansiDateTimeError(DateTimeException e) {
        String newMessage = new StringBuilder(50).append(e.getMessage()).append(". ").append("If necessary set ").append(SQLConf$.MODULE$.ANSI_ENABLED().key()).append(" to false to bypass this error.").toString();
        return new DateTimeException(newMessage, e.getCause());
    }

    public ParseException ansiParseError(ParseException e) {
        String newMessage = new StringBuilder(50).append(e.getMessage()).append(". ").append("If necessary set ").append(SQLConf$.MODULE$.ANSI_ENABLED().key()).append(" to false to bypass this error.").toString();
        return new ParseException(newMessage, e.getErrorOffset());
    }

    public IllegalArgumentException ansiIllegalArgumentError(String message) {
        String newMessage = new StringBuilder(50).append(message).append(". If necessary set ").append(SQLConf$.MODULE$.ANSI_ENABLED().key()).append(" ").append("to false to bypass this error.").toString();
        return new IllegalArgumentException(newMessage);
    }

    public IllegalArgumentException ansiIllegalArgumentError(IllegalArgumentException e) {
        return this.ansiIllegalArgumentError(e.getMessage());
    }

    public ArithmeticException overflowInSumOfDecimalError(String context) {
        String x$1 = "Overflow in sum of decimals";
        String x$2 = context;
        String x$3 = this.arithmeticOverflowError$default$2();
        return this.arithmeticOverflowError(x$1, x$3, x$2);
    }

    public ArithmeticException overflowInIntegralDivideError(String context) {
        return this.arithmeticOverflowError("Overflow in integral divide", "try_divide", context);
    }

    public RuntimeException mapSizeExceedArraySizeWhenZipMapError(int size) {
        return new RuntimeException(new StringBuilder(86).append("Unsuccessful try to zip maps with ").append(size).append(" ").append("unique keys due to exceeding the array size limit ").append(0x7FFFFFF0).append(".").toString());
    }

    public Throwable copyNullFieldNotAllowedError() {
        return new IllegalStateException("Do not attempt to copy a null field");
    }

    public RuntimeException literalTypeUnsupportedError(Object v) {
        return new SparkRuntimeException("UNSUPPORTED_FEATURE", (String[])((Object[])new String[]{new StringBuilder(19).append("literal for '").append(v.toString()).append("' of ").append(v.getClass().toString()).append(".").toString()}), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4());
    }

    public RuntimeException pivotColumnUnsupportedError(Object v, DataType dataType) {
        return new SparkRuntimeException("UNSUPPORTED_FEATURE", (String[])((Object[])new String[]{new StringBuilder(50).append("pivoting by the value '").append(v.toString()).append("' of the column data type ").append(this.toSQLType(dataType)).append(".").toString()}), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4());
    }

    public RuntimeException noDefaultForDataTypeError(DataType dataType) {
        return new RuntimeException(new StringBuilder(20).append("no default for type ").append(dataType).toString());
    }

    public Throwable doGenCodeOfAliasShouldNotBeCalledError() {
        return new IllegalStateException("Alias.doGenCode should not be called.");
    }

    public Throwable orderedOperationUnsupportedByDataTypeError(DataType dataType) {
        return new IllegalArgumentException(new StringBuilder(41).append("Type ").append(dataType).append(" does not support ordered operations").toString());
    }

    public Throwable regexGroupIndexLessThanZeroError() {
        return new IllegalArgumentException("The specified group index cannot be less than zero");
    }

    public Throwable regexGroupIndexExceedGroupCountError(int groupCount, int groupIndex) {
        return new IllegalArgumentException(new StringBuilder(56).append("Regex group count is ").append(groupCount).append(", but the specified group index is ").append(groupIndex).toString());
    }

    public Throwable invalidUrlError(UTF8String url, URISyntaxException e) {
        return new IllegalArgumentException(new StringBuilder(77).append("Find an invalid url string ").append(url.toString()).append(". ").append("If necessary set ").append(SQLConf$.MODULE$.ANSI_ENABLED().key()).append(" to false to bypass this error.").toString(), e);
    }

    public Throwable dataTypeOperationUnsupportedError() {
        return new UnsupportedOperationException("dataType");
    }

    public Throwable mergeUnsupportedByWindowFunctionError() {
        return new UnsupportedOperationException("Window Functions do not support merging.");
    }

    public Throwable dataTypeUnexpectedError(DataType dataType) {
        return new UnsupportedOperationException(new StringBuilder(21).append("Unexpected data type ").append(dataType.catalogString()).toString());
    }

    public Throwable typeUnsupportedError(DataType dataType) {
        return new IllegalArgumentException(new StringBuilder(16).append("Unexpected type ").append(dataType).toString());
    }

    public Throwable negativeValueUnexpectedError(Expression frequencyExpression) {
        return new SparkException(new StringBuilder(25).append("Negative values found in ").append(frequencyExpression.sql()).toString());
    }

    public Throwable addNewFunctionMismatchedWithFunctionError(String funcName) {
        return new IllegalArgumentException(new StringBuilder(33).append(funcName).append(" is not matched at addNewFunction").toString());
    }

    public Throwable cannotGenerateCodeForUncomparableTypeError(String codeType, DataType dataType) {
        return new IllegalArgumentException(new StringBuilder(46).append("cannot generate ").append(codeType).append(" code for un-comparable type: ").append(dataType.catalogString()).toString());
    }

    public Throwable cannotGenerateCodeForUnsupportedTypeError(DataType dataType) {
        return new IllegalArgumentException(new StringBuilder(43).append("cannot generate code for unsupported type: ").append(dataType).toString());
    }

    public Throwable cannotInterpolateClassIntoCodeBlockError(Object arg) {
        return new IllegalArgumentException(new StringBuilder(37).append("Can not interpolate ").append(arg.getClass().getName()).append(" into code block.").toString());
    }

    public Throwable customCollectionClsNotResolvedError() {
        return new UnsupportedOperationException("not resolved");
    }

    public RuntimeException classUnsupportedByMapObjectsError(Class<?> cls) {
        return new RuntimeException(new StringBuilder(66).append("class `").append(cls.getName()).append("` is not supported by `MapObjects` as ").append("resulting collection.").toString());
    }

    public RuntimeException nullAsMapKeyNotAllowedError() {
        return new RuntimeException("Cannot use null as map key!");
    }

    public Throwable methodNotDeclaredError(String name) {
        return new SparkNoSuchMethodException("INTERNAL_ERROR", (String[])((Object[])new String[]{new StringBuilder(74).append("A method named \"").append(name).append("\" is not declared in any enclosing class nor any supertype").toString()}));
    }

    public Throwable constructorNotFoundError(String cls) {
        return new RuntimeException(new StringBuilder(37).append("Couldn't find a valid constructor on ").append(cls).toString());
    }

    public Throwable primaryConstructorNotFoundError(Class<?> cls) {
        return new RuntimeException(new StringBuilder(39).append("Couldn't find a primary constructor on ").append(cls).toString());
    }

    public Throwable unsupportedNaturalJoinTypeError(JoinType joinType) {
        return new RuntimeException(new StringBuilder(30).append("Unsupported natural join type ").append(joinType).toString());
    }

    public Throwable notExpectedUnresolvedEncoderError(AttributeReference attr) {
        return new RuntimeException(new StringBuilder(44).append("Unresolved encoder expected, but ").append(attr).append(" was found.").toString());
    }

    public Throwable unsupportedEncoderError() {
        return new RuntimeException("Only expression encoders are supported for now.");
    }

    public Throwable notOverrideExpectedMethodsError(String className, String m1, String m2) {
        return new RuntimeException(new StringBuilder(26).append(className).append(" must override either ").append(m1).append(" or ").append(m2).toString());
    }

    public Throwable failToConvertValueToJsonError(Object value, Class<?> cls, DataType dataType) {
        return new RuntimeException(new StringBuilder(63).append("Failed to convert value ").append(value).append(" (class of ").append(cls).append(") ").append("with the type of ").append(dataType).append(" to JSON.").toString());
    }

    public Throwable unexpectedOperatorInCorrelatedSubquery(LogicalPlan op, String pos) {
        return new RuntimeException(new StringBuilder(43).append("Unexpected operator ").append(op).append(" in correlated subquery").append(pos).toString());
    }

    public String unexpectedOperatorInCorrelatedSubquery$default$2() {
        return "";
    }

    public Throwable unreachableError(String err) {
        return new RuntimeException(new StringBuilder(31).append("This line should be unreachable").append(err).toString());
    }

    public String unreachableError$default$1() {
        return "";
    }

    public Throwable unsupportedRoundingMode(Enumeration.Value roundMode) {
        return new RuntimeException(new StringBuilder(29).append("Not supported rounding mode: ").append(roundMode).toString());
    }

    public Throwable resolveCannotHandleNestedSchema(LogicalPlan plan2) {
        return new RuntimeException(new StringBuilder(42).append("Can not handle nested schema yet...  plan ").append(plan2).toString());
    }

    public RuntimeException inputExternalRowCannotBeNullError() {
        return new RuntimeException("The input external row cannot be null.");
    }

    public String fieldCannotBeNullMsg(int index, String fieldName) {
        return new StringBuilder(44).append("The ").append(index).append("th field '").append(fieldName).append("' of input row cannot be null.").toString();
    }

    public RuntimeException fieldCannotBeNullError(int index, String fieldName) {
        return new RuntimeException(this.fieldCannotBeNullMsg(index, fieldName));
    }

    public Throwable unableToCreateDatabaseAsFailedToCreateDirectoryError(CatalogDatabase dbDefinition, IOException e) {
        return new SparkException(new StringBuilder(61).append("Unable to create database ").append(dbDefinition.name()).append(" as failed ").append("to create its directory ").append(dbDefinition.locationUri()).toString(), (Throwable)e);
    }

    public Throwable unableToDropDatabaseAsFailedToDeleteDirectoryError(CatalogDatabase dbDefinition, IOException e) {
        return new SparkException(new StringBuilder(59).append("Unable to drop database ").append(dbDefinition.name()).append(" as failed ").append("to delete its directory ").append(dbDefinition.locationUri()).toString(), (Throwable)e);
    }

    public Throwable unableToCreateTableAsFailedToCreateDirectoryError(String table, Path defaultTableLocation, IOException e) {
        return new SparkException(new StringBuilder(58).append("Unable to create table ").append(table).append(" as failed ").append("to create its directory ").append(defaultTableLocation).toString(), (Throwable)e);
    }

    public Throwable unableToDeletePartitionPathError(Path partitionPath, IOException e) {
        return new SparkException(new StringBuilder(32).append("Unable to delete partition path ").append(partitionPath).toString(), (Throwable)e);
    }

    public Throwable unableToDropTableAsFailedToDeleteDirectoryError(String table, Path dir, IOException e) {
        return new SparkException(new StringBuilder(56).append("Unable to drop table ").append(table).append(" as failed ").append("to delete its directory ").append(dir).toString(), (Throwable)e);
    }

    public Throwable unableToRenameTableAsFailedToRenameDirectoryError(String oldName, String newName, Path oldDir, IOException e) {
        return new SparkException(new StringBuilder(62).append("Unable to rename table ").append(oldName).append(" to ").append(newName).append(" as failed ").append("to rename its directory ").append(oldDir).toString(), (Throwable)e);
    }

    public Throwable unableToCreatePartitionPathError(Path partitionPath, IOException e) {
        return new SparkException(new StringBuilder(32).append("Unable to create partition path ").append(partitionPath).toString(), (Throwable)e);
    }

    public Throwable unableToRenamePartitionPathError(Path oldPartPath, IOException e) {
        return new SparkException(new StringBuilder(32).append("Unable to rename partition path ").append(oldPartPath).toString(), (Throwable)e);
    }

    public Throwable methodNotImplementedError(String methodName) {
        return new UnsupportedOperationException(new StringBuilder(19).append(methodName).append(" is not implemented").toString());
    }

    public Throwable tableStatsNotSpecifiedError() {
        return new IllegalStateException("table stats must be specified.");
    }

    public ArithmeticException arithmeticOverflowError(ArithmeticException e) {
        return new ArithmeticException(new StringBuilder(50).append(e.getMessage()).append(". If necessary set ").append(SQLConf$.MODULE$.ANSI_ENABLED().key()).append(" ").append("to false to bypass this error.").toString());
    }

    public ArithmeticException arithmeticOverflowError(String message, String hint, String errorContext) {
        String alternative = new StringOps(Predef$.MODULE$.augmentString(hint)).nonEmpty() ? new StringBuilder(53).append(" Use '").append(hint).append("' to tolerate overflow and return NULL instead.").toString() : "";
        return new SparkArithmeticException("ARITHMETIC_OVERFLOW", (String[])((Object[])new String[]{message, alternative, SQLConf$.MODULE$.ANSI_ENABLED().key()}), errorContext);
    }

    public String arithmeticOverflowError$default$2() {
        return "";
    }

    public String arithmeticOverflowError$default$3() {
        return "";
    }

    public ArithmeticException unaryMinusCauseOverflowError(int originValue) {
        return this.arithmeticOverflowError(new StringBuilder(18).append("- ").append(this.toSQLValue(BoxesRunTime.boxToInteger((int)originValue), IntegerType$.MODULE$)).append(" caused overflow").toString(), this.arithmeticOverflowError$default$2(), this.arithmeticOverflowError$default$3());
    }

    public ArithmeticException binaryArithmeticCauseOverflowError(short eval1, String symbol, short eval2) {
        return this.arithmeticOverflowError(new StringBuilder(18).append(this.toSQLValue(BoxesRunTime.boxToShort((short)eval1), ShortType$.MODULE$)).append(" ").append(symbol).append(" ").append(this.toSQLValue(BoxesRunTime.boxToShort((short)eval2), ShortType$.MODULE$)).append(" caused overflow").toString(), this.arithmeticOverflowError$default$2(), this.arithmeticOverflowError$default$3());
    }

    public String failedSplitSubExpressionMsg(int length) {
        return new StringBuilder(141).append("Failed to split subexpression code into small functions because ").append("the parameter length of at least one split function went over the JVM limit: ").append(length).toString();
    }

    public Throwable failedSplitSubExpressionError(int length) {
        return new IllegalStateException(this.failedSplitSubExpressionMsg(length));
    }

    public String failedToCompileMsg(Exception e) {
        return new StringBuilder(19).append("failed to compile: ").append(e).toString();
    }

    public Throwable internalCompilerError(InternalCompilerException e) {
        return new InternalCompilerException(this.failedToCompileMsg((Exception)((Object)e)), (Throwable)e);
    }

    public Throwable compilerError(CompileException e) {
        return new CompileException(this.failedToCompileMsg((Exception)((Object)e)), e.getLocation());
    }

    public Throwable unsupportedTableChangeError(IllegalArgumentException e) {
        return new SparkException(new StringBuilder(26).append("Unsupported table change: ").append(e.getMessage()).toString(), (Throwable)e);
    }

    public Throwable notADatasourceRDDPartitionError(Partition split) {
        return new SparkException(new StringBuilder(36).append("[BUG] Not a DataSourceRDDPartition: ").append(split).toString());
    }

    public Throwable dataPathNotSpecifiedError() {
        return new IllegalArgumentException("'path' is not specified");
    }

    public Throwable createStreamingSourceNotSpecifySchemaError() {
        return new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("\n         |Schema must be specified when creating a streaming source DataFrame. If some\n         |files already exist in the directory, then depending on the file format you\n         |may be able to create a static DataFrame on that directory with\n         |'spark.read.load(directory)' and infer schema from it.\n       ")).stripMargin());
    }

    public Throwable streamedOperatorUnsupportedByDataSourceError(String className, String operator) {
        return new UnsupportedOperationException(new StringBuilder(39).append("Data source ").append(className).append(" does not support streamed ").append(operator).toString());
    }

    public Throwable multiplePathsSpecifiedError(Seq<String> allPaths) {
        return new IllegalArgumentException(new StringBuilder(52).append("Expected exactly one path to be specified, but ").append("got: ").append(allPaths.mkString(", ")).toString());
    }

    public Throwable failedToFindDataSourceError(String provider, Throwable error) {
        return new ClassNotFoundException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(133).append("\n         |Failed to find data source: ").append(provider).append(". Please find packages at\n         |https://spark.apache.org/third-party-projects.html\n       ").toString())).stripMargin(), error);
    }

    public Throwable removedClassInSpark2Error(String className, Throwable e) {
        return new ClassNotFoundException(new StringBuilder(84).append(className).append(" was removed in Spark 2.0. ").append("Please check if your library is compatible with Spark 2.0").toString(), e);
    }

    public Throwable incompatibleDataSourceRegisterError(Throwable e) {
        return new SparkClassNotFoundException("INCOMPATIBLE_DATASOURCE_REGISTER", (String[])((Object[])new String[]{e.getMessage()}), e);
    }

    public Throwable unrecognizedFileFormatError(String format) {
        return new IllegalStateException(new StringBuilder(20).append("unrecognized format ").append(format).toString());
    }

    public SparkUpgradeException sparkUpgradeInReadingDatesError(String format, String config, String option) {
        return new SparkUpgradeException("INCONSISTENT_BEHAVIOR_CROSS_VERSION", (String[])((Object[])new String[]{"3.0", new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(672).append("\n           |reading dates before 1582-10-15 or timestamps before 1900-01-01T00:00:00Z\n           |from ").append(format).append(" files can be ambiguous, as the files may be written by\n           |Spark 2.x or legacy versions of Hive, which uses a legacy hybrid calendar\n           |that is different from Spark 3.0+'s Proleptic Gregorian calendar.\n           |See more details in SPARK-31404. You can set the SQL config ").append(this.toSQLConf(config)).append(" or\n           |the datasource option ").append(this.toDSOption(option)).append(" to \"LEGACY\" to rebase the datetime values\n           |w.r.t. the calendar difference during reading. To read the datetime values\n           |as it is, set the SQL config ").append(this.toSQLConf(config)).append(" or the datasource option ").append(this.toDSOption(option)).append("\n           |to \"CORRECTED\".\n           |").toString())).stripMargin()}), null);
    }

    public SparkUpgradeException sparkUpgradeInWritingDatesError(String format, String config) {
        return new SparkUpgradeException("INCONSISTENT_BEHAVIOR_CROSS_VERSION", (String[])((Object[])new String[]{"3.0", new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(751).append("\n          |writing dates before 1582-10-15 or timestamps before 1900-01-01T00:00:00Z\n          |into ").append(format).append(" files can be dangerous, as the files may be read by Spark 2.x\n          |or legacy versions of Hive later, which uses a legacy hybrid calendar that\n          |is different from Spark 3.0+'s Proleptic Gregorian calendar. See more\n          |details in SPARK-31404. You can set ").append(this.toSQLConf(config)).append(" to \"LEGACY\" to rebase the\n          |datetime values w.r.t. the calendar difference during writing, to get maximum\n          |interoperability. Or set ").append(this.toSQLConf(config)).append(" to \"CORRECTED\" to write the datetime\n          |values as it is, if you are 100% sure that the written files will only be read by\n          |Spark 3.0+ or other systems that use Proleptic Gregorian calendar.\n          |").toString())).stripMargin()}), null);
    }

    public Throwable buildReaderUnsupportedForFileFormatError(String format) {
        return new UnsupportedOperationException(new StringBuilder(33).append("buildReader is not supported for ").append(format).toString());
    }

    public Throwable jobAbortedError(Throwable cause) {
        return new SparkException("Job aborted.", cause);
    }

    public Throwable taskFailedWhileWritingRowsError(Throwable cause) {
        return new SparkException("Task failed while writing rows.", cause);
    }

    public Throwable readCurrentFileNotFoundError(FileNotFoundException e) {
        return new FileNotFoundException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(255).append("\n         |").append(e.getMessage()).append("\n\n         |It is possible the underlying files have been updated. You can explicitly invalidate\n         |the cache in Spark by running 'REFRESH TABLE tableName' command in SQL or by\n         |recreating the Dataset/DataFrame involved.\n       ").toString())).stripMargin());
    }

    public Throwable saveModeUnsupportedError(Object saveMode, boolean pathExists) {
        boolean bl = pathExists;
        if (bl) {
            return new SparkIllegalArgumentException("UNSUPPORTED_SAVE_MODE", (String[])((Object[])new String[]{"EXISTENT_PATH", this.toSQLValue(saveMode, StringType$.MODULE$)}));
        }
        return new SparkIllegalArgumentException("UNSUPPORTED_SAVE_MODE", (String[])((Object[])new String[]{"NON_EXISTENT_PATH", this.toSQLValue(saveMode, StringType$.MODULE$)}));
    }

    public Throwable cannotClearOutputDirectoryError(Path staticPrefixPath) {
        return new IOException(new StringBuilder(56).append("Unable to clear output directory ").append(staticPrefixPath).append(" prior to writing to it").toString());
    }

    public Throwable cannotClearPartitionDirectoryError(Path path) {
        return new IOException(new StringBuilder(59).append("Unable to clear partition directory ").append(path).append(" prior to writing to it").toString());
    }

    public Throwable failedToCastValueToDataTypeForPartitionColumnError(String value, DataType dataType, String columnName) {
        return new RuntimeException(new StringBuilder(53).append("Failed to cast value `").append(value).append("` to ").append("`").append(dataType).append("` for partition column `").append(columnName).append("`").toString());
    }

    public Throwable endOfStreamError() {
        return new NoSuchElementException("End of stream");
    }

    public Throwable fallbackV1RelationReportsInconsistentSchemaError(StructType v2Schema, StructType v1Schema) {
        return new IllegalArgumentException(new StringBuilder(101).append("The fallback v1 relation reports inconsistent schema:\nSchema of v2 scan:     ").append(v2Schema).append("\n").append("Schema of v1 relation: ").append(v1Schema).toString());
    }

    public Throwable noRecordsFromEmptyDataReaderError() {
        return new IOException("No records should be returned from EmptyDataReader");
    }

    public Throwable fileNotFoundError(FileNotFoundException e) {
        return new FileNotFoundException(new StringBuilder(150).append(e.getMessage()).append("\n").append("It is possible the underlying files have been updated. ").append("You can explicitly invalidate the cache in Spark by ").append("recreating the Dataset/DataFrame involved.").toString());
    }

    public Throwable unsupportedSchemaColumnConvertError(String filePath, String column, String logicalType, String physicalType, Exception e) {
        String message = new StringBuilder(74).append("Parquet column cannot be converted in ").append("file ").append(filePath).append(". Column: ").append(column).append(", ").append("Expected: ").append(logicalType).append(", Found: ").append(physicalType).toString();
        return new QueryExecutionException(message, e);
    }

    public Throwable cannotReadFilesError(Throwable e, String path) {
        String message = new StringBuilder(48).append("Encountered error while reading file ").append(path).append(". Details: ").toString();
        return new QueryExecutionException(message, e);
    }

    public Throwable cannotCreateColumnarReaderError() {
        return new UnsupportedOperationException("Cannot create columnar reader.");
    }

    public Throwable invalidNamespaceNameError(String[] namespace) {
        return new IllegalArgumentException(new StringBuilder(24).append("Invalid namespace name: ").append(CatalogV2Implicits$.MODULE$.NamespaceHelper(namespace).quoted()).toString());
    }

    public Throwable unsupportedPartitionTransformError(Transform transform2) {
        return new UnsupportedOperationException(new StringBuilder(33).append("Unsupported partition transform: ").append(transform2).toString());
    }

    public Throwable missingDatabaseLocationError() {
        return new IllegalArgumentException("Missing database location");
    }

    public Throwable cannotRemoveReservedPropertyError(String property) {
        return new UnsupportedOperationException(new StringBuilder(33).append("Cannot remove reserved property: ").append(property).toString());
    }

    public Throwable namespaceNotEmptyError(String[] namespace) {
        return new IllegalStateException(new StringBuilder(23).append("Namespace ").append(CatalogV2Implicits$.MODULE$.NamespaceHelper(namespace).quoted()).append(" is not empty").toString());
    }

    public Throwable writingJobFailedError(Throwable cause) {
        return new SparkException("Writing job failed.", cause);
    }

    public Throwable writingJobAbortedError(Throwable e) {
        return new SparkException("WRITING_JOB_ABORTED", (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), e);
    }

    public Throwable commitDeniedError(int partId, long taskId, int attemptId, int stageId, int stageAttempt) {
        String message = new StringBuilder(55).append("Commit denied for partition ").append(partId).append(" (task ").append(taskId).append(", attempt ").append(attemptId).append(", ").append("stage ").append(stageId).append(".").append(stageAttempt).append(")").toString();
        return new CommitDeniedException(message, stageId, partId, attemptId);
    }

    public Throwable unsupportedTableWritesError(Identifier ident) {
        return new SparkException(new StringBuilder(46).append("Table implementation does not support writes: ").append(CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).quoted()).toString());
    }

    public Throwable cannotCreateJDBCTableWithPartitionsError() {
        return new UnsupportedOperationException("Cannot create JDBC table with partition");
    }

    public Throwable unsupportedUserSpecifiedSchemaError() {
        return new UnsupportedOperationException("user-specified schema");
    }

    public Throwable writeUnsupportedForBinaryFileDataSourceError() {
        return new UnsupportedOperationException("Write is not supported for binary file data source");
    }

    public Throwable fileLengthExceedsMaxLengthError(FileStatus status, int maxLength) {
        return new SparkException(new StringBuilder(59).append("The length of ").append(status.getPath()).append(" is ").append(status.getLen()).append(", ").append("which exceeds the max length allowed: ").append(maxLength).append(".").toString());
    }

    public Throwable unsupportedFieldNameError(String fieldName) {
        return new RuntimeException(new StringBuilder(24).append("Unsupported field name: ").append(fieldName).toString());
    }

    public Throwable cannotSpecifyBothJdbcTableNameAndQueryError(String jdbcTableName, String jdbcQueryString) {
        return new IllegalArgumentException(new StringBuilder(53).append("Both '").append(jdbcTableName).append("' and '").append(jdbcQueryString).append("' can not be specified at the same time.").toString());
    }

    public Throwable missingJdbcTableNameAndQueryError(String jdbcTableName, String jdbcQueryString) {
        return new IllegalArgumentException(new StringBuilder(28).append("Option '").append(jdbcTableName).append("' or '").append(jdbcQueryString).append("' is required.").toString());
    }

    public Throwable emptyOptionError(String optionName) {
        return new IllegalArgumentException(new StringBuilder(27).append("Option `").append(optionName).append("` can not be empty.").toString());
    }

    public Throwable invalidJdbcTxnIsolationLevelError(String jdbcTxnIsolationLevel, String value) {
        return new IllegalArgumentException(new StringBuilder(129).append("Invalid value `").append(value).append("` for parameter `").append(jdbcTxnIsolationLevel).append("`. This can be ").append("`NONE`, `READ_UNCOMMITTED`, `READ_COMMITTED`, `REPEATABLE_READ` or `SERIALIZABLE`.").toString());
    }

    public Throwable cannotGetJdbcTypeError(DataType dt) {
        return new IllegalArgumentException(new StringBuilder(24).append("Can't get JDBC type for ").append(dt.catalogString()).toString());
    }

    public Throwable unrecognizedSqlTypeError(int sqlType) {
        return new SparkSQLException("UNRECOGNIZED_SQL_TYPE", (String[])((Object[])new String[]{Integer.toString(sqlType)}));
    }

    public Throwable unsupportedJdbcTypeError(String content) {
        return new SQLException(new StringBuilder(17).append("Unsupported type ").append(content).toString());
    }

    public Throwable unsupportedArrayElementTypeBasedOnBinaryError(DataType dt) {
        return new IllegalArgumentException(new StringBuilder(47).append("Unsupported array element ").append("type ").append(dt.catalogString()).append(" based on binary").toString());
    }

    public Throwable nestedArraysUnsupportedError() {
        return new IllegalArgumentException("Nested arrays unsupported");
    }

    public Throwable cannotTranslateNonNullValueForFieldError(int pos) {
        return new IllegalArgumentException(new StringBuilder(41).append("Can't translate non-null value for field ").append(pos).toString());
    }

    public Throwable invalidJdbcNumPartitionsError(int n, String jdbcNumPartitions) {
        return new IllegalArgumentException(new StringBuilder(84).append("Invalid value `").append(n).append("` for parameter `").append(jdbcNumPartitions).append("` in table writing ").append("via JDBC. The minimum value is 1.").toString());
    }

    public Throwable transactionUnsupportedByJdbcServerError() {
        return new SparkSQLFeatureNotSupportedException("UNSUPPORTED_FEATURE", (String[])((Object[])new String[]{"the target JDBC server does not support transaction and can only support ALTER TABLE with a single action."}));
    }

    public Throwable dataTypeUnsupportedYetError(DataType dataType) {
        return new UnsupportedOperationException(new StringBuilder(22).append(dataType).append(" is not supported yet.").toString());
    }

    public Throwable unsupportedOperationForDataTypeError(DataType dataType) {
        return new UnsupportedOperationException(new StringBuilder(10).append("DataType: ").append(dataType.catalogString()).toString());
    }

    public Throwable inputFilterNotFullyConvertibleError(String owner) {
        return new SparkException(new StringBuilder(49).append("The input filter of ").append(owner).append(" should be fully convertible.").toString());
    }

    public Throwable cannotReadFooterForFileError(Path file, IOException e) {
        return new SparkException(new StringBuilder(32).append("Could not read footer for file: ").append(file).toString(), (Throwable)e);
    }

    public Throwable cannotReadFooterForFileError(FileStatus file, RuntimeException e) {
        return new IOException(new StringBuilder(32).append("Could not read footer for file: ").append(file).toString(), e);
    }

    public Throwable foundDuplicateFieldInCaseInsensitiveModeError(String requiredFieldName, String matchedOrcFields) {
        return new RuntimeException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(83).append("\n         |Found duplicate field(s) \"").append(requiredFieldName).append("\": ").append(matchedOrcFields).append("\n         |in case-insensitive mode\n       ").toString())).stripMargin().replaceAll("\n", " "));
    }

    public Throwable foundDuplicateFieldInFieldIdLookupModeError(int requiredId, String matchedFields) {
        return new RuntimeException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(77).append("\n         |Found duplicate field(s) \"").append(requiredId).append("\": ").append(matchedFields).append("\n         |in id mapping mode\n       ").toString())).stripMargin().replaceAll("\n", " "));
    }

    public Throwable failedToMergeIncompatibleSchemasError(StructType left, StructType right, Throwable e) {
        return new SparkException(new StringBuilder(42).append("Failed to merge incompatible schemas ").append(left).append(" and ").append(right).toString(), e);
    }

    public Throwable ddlUnsupportedTemporarilyError(String ddl) {
        return new UnsupportedOperationException(new StringBuilder(30).append(ddl).append(" is not supported temporarily.").toString());
    }

    public Throwable operatingOnCanonicalizationPlanError() {
        return new IllegalStateException("operating on canonicalization plan");
    }

    public Throwable executeBroadcastTimeoutError(long timeout, Option<TimeoutException> ex) {
        return new SparkException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(169).append("\n         |Could not execute broadcast in ").append(timeout).append(" secs. You can increase the timeout\n         |for broadcasts via ").append(SQLConf$.MODULE$.BROADCAST_TIMEOUT().key()).append(" or disable broadcast join\n         |by setting ").append(SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key()).append(" to -1\n       ").toString())).stripMargin().replaceAll("\n", " "), (Throwable)ex.getOrElse((Function0 & Serializable & scala.Serializable)() -> null));
    }

    public Throwable cannotCompareCostWithTargetCostError(String cost) {
        return new IllegalArgumentException(new StringBuilder(28).append("Could not compare cost with ").append(cost).toString());
    }

    public Throwable unsupportedDataTypeError(String dt) {
        return new UnsupportedOperationException(new StringBuilder(23).append("Unsupported data type: ").append(dt).toString());
    }

    public Throwable notSupportTypeError(DataType dataType) {
        return new Exception(new StringBuilder(18).append("not support type: ").append(dataType).toString());
    }

    public Throwable notSupportNonPrimitiveTypeError() {
        return new RuntimeException("Not support non-primitive type now");
    }

    public Throwable unsupportedTypeError(DataType dataType) {
        return new Exception(new StringBuilder(18).append("Unsupported type: ").append(dataType.catalogString()).toString());
    }

    public Throwable useDictionaryEncodingWhenDictionaryOverflowError() {
        return new IllegalStateException("Dictionary encoding should not be used because of dictionary overflow.");
    }

    public Throwable endOfIteratorError() {
        return new NoSuchElementException("End of the iterator");
    }

    public Throwable cannotAllocateMemoryToGrowBytesToBytesMapError() {
        return new IOException("Could not allocate memory to grow BytesToBytesMap");
    }

    public Throwable cannotAcquireMemoryToBuildLongHashedRelationError(long size, long got) {
        return new SparkException(new StringBuilder(62).append("Can't acquire ").append(size).append(" bytes memory to build hash relation, ").append("got ").append(got).append(" bytes").toString());
    }

    public Throwable cannotAcquireMemoryToBuildUnsafeHashedRelationError() {
        return new SparkOutOfMemoryError("There is not enough memory to build hash map");
    }

    public Throwable rowLargerThan256MUnsupportedError() {
        return new UnsupportedOperationException("Does not support row that is larger than 256M");
    }

    public Throwable cannotBuildHashedRelationWithUniqueKeysExceededError() {
        return new UnsupportedOperationException("Cannot build HashedRelation with more than 1/3 billions unique keys");
    }

    public Throwable cannotBuildHashedRelationLargerThan8GError() {
        return new UnsupportedOperationException("Can not build a HashedRelation that is larger than 8G");
    }

    public Throwable failedToPushRowIntoRowQueueError(String rowQueue) {
        return new SparkException(new StringBuilder(26).append("failed to push a row into ").append(rowQueue).toString());
    }

    public Throwable unexpectedWindowFunctionFrameError(String frame) {
        return new RuntimeException(new StringBuilder(34).append("Unexpected window function frame ").append(frame).append(".").toString());
    }

    public Throwable cannotParseStatisticAsPercentileError(String stats, NumberFormatException e) {
        return new IllegalArgumentException(new StringBuilder(32).append("Unable to parse ").append(stats).append(" as a percentile").toString(), e);
    }

    public Throwable statisticNotRecognizedError(String stats) {
        return new IllegalArgumentException(new StringBuilder(30).append(stats).append(" is not a recognised statistic").toString());
    }

    public Throwable unknownColumnError(String unknownColumn) {
        return new IllegalArgumentException(new StringBuilder(16).append("Unknown column: ").append(unknownColumn).toString());
    }

    public Throwable unexpectedAccumulableUpdateValueError(Object o) {
        return new IllegalArgumentException(new StringBuilder(12).append("Unexpected: ").append(o).toString());
    }

    public Throwable unscaledValueTooLargeForPrecisionError() {
        return new ArithmeticException(new StringBuilder(88).append("Unscaled value too large for precision. ").append("If necessary set ").append(SQLConf$.MODULE$.ANSI_ENABLED().key()).append(" to false to bypass this error.").toString());
    }

    public Throwable decimalPrecisionExceedsMaxPrecisionError(int precision, int maxPrecision) {
        return new ArithmeticException(new StringBuilder(41).append("Decimal precision ").append(precision).append(" exceeds max precision ").append(maxPrecision).toString());
    }

    public Throwable outOfDecimalTypeRangeError(UTF8String str) {
        return new ArithmeticException(new StringBuilder(27).append("out of decimal type range: ").append(str).toString());
    }

    public Throwable unsupportedArrayTypeError(Class<?> clazz) {
        return new RuntimeException(new StringBuilder(30).append("Do not support array of type ").append(clazz).append(".").toString());
    }

    public Throwable unsupportedJavaTypeError(Class<?> clazz) {
        return new RuntimeException(new StringBuilder(21).append("Do not support type ").append(clazz).append(".").toString());
    }

    public Throwable failedParsingStructTypeError(String raw) {
        return new RuntimeException(new StringBuilder(17).append("Failed parsing ").append(StructType$.MODULE$.simpleString()).append(": ").append(raw).toString());
    }

    public Throwable failedMergingFieldsError(String leftName, String rightName, Throwable e) {
        return new SparkException(new StringBuilder(34).append("Failed to merge fields '").append(leftName).append("' and '").append(rightName).append("'. ").append(e.getMessage()).toString());
    }

    public Throwable cannotMergeDecimalTypesWithIncompatiblePrecisionAndScaleError(int leftPrecision, int rightPrecision, int leftScale, int rightScale) {
        return new SparkException(new StringBuilder(77).append("Failed to merge decimal types with incompatible ").append("precision ").append(leftPrecision).append(" and ").append(rightPrecision).append(" & scale ").append(leftScale).append(" and ").append(rightScale).toString());
    }

    public Throwable cannotMergeDecimalTypesWithIncompatiblePrecisionError(int leftPrecision, int rightPrecision) {
        return new SparkException(new StringBuilder(63).append("Failed to merge decimal types with incompatible ").append("precision ").append(leftPrecision).append(" and ").append(rightPrecision).toString());
    }

    public Throwable cannotMergeDecimalTypesWithIncompatibleScaleError(int leftScale, int rightScale) {
        return new SparkException(new StringBuilder(59).append("Failed to merge decimal types with incompatible ").append("scale ").append(leftScale).append(" and ").append(rightScale).toString());
    }

    public Throwable cannotMergeIncompatibleDataTypesError(DataType left, DataType right) {
        return new SparkException(new StringBuilder(45).append("Failed to merge incompatible data types ").append(left.catalogString()).append(" and ").append(right.catalogString()).toString());
    }

    public Throwable exceedMapSizeLimitError(int size) {
        return new RuntimeException(new StringBuilder(87).append("Unsuccessful attempt to build maps with ").append(size).append(" elements ").append("due to exceeding the map size limit ").append(0x7FFFFFF0).append(".").toString());
    }

    public Throwable duplicateMapKeyFoundError(Object key) {
        return new RuntimeException(new StringBuilder(169).append("Duplicate map key ").append(key).append(" was found, please check the input ").append("data. If you want to remove the duplicated keys, you can set ").append(SQLConf$.MODULE$.MAP_KEY_DEDUP_POLICY().key()).append(" to ").append(SQLConf$MapKeyDedupPolicy$.MODULE$.LAST_WIN()).append(" so that ").append("the key inserted at last takes precedence.").toString());
    }

    public Throwable mapDataKeyArrayLengthDiffersFromValueArrayLengthError() {
        return new RuntimeException("The key array and value array of MapData must have the same length.");
    }

    public Throwable fieldDiffersFromDerivedLocalDateError(ChronoField field, int actual, int expected, LocalDate candidate) {
        return new DateTimeException(new StringBuilder(52).append("Conflict found: Field ").append(field).append(" ").append(actual).append(" differs from").append(" ").append(field).append(" ").append(expected).append(" derived from ").append(candidate).toString());
    }

    public Throwable failToParseDateTimeInNewParserError(String s, Throwable e) {
        return new SparkUpgradeException("3.0", new StringBuilder(164).append("Fail to parse '").append(s).append("' in the new parser. You can ").append("set ").append(SQLConf$.MODULE$.LEGACY_TIME_PARSER_POLICY().key()).append(" to LEGACY to restore the behavior ").append("before Spark 3.0, or set to CORRECTED and treat it as an invalid datetime string.").toString(), e);
    }

    public Throwable failToFormatDateTimeInNewFormatterError(String resultCandidate, Throwable e) {
        return new SparkUpgradeException("3.0", new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(213).append("\n         |Fail to format it to '").append(resultCandidate).append("' in the new formatter. You can set\n         |").append(SQLConf$.MODULE$.LEGACY_TIME_PARSER_POLICY().key()).append(" to LEGACY to restore the behavior before\n         |Spark 3.0, or set to CORRECTED and treat it as an invalid datetime string.\n       ").toString())).stripMargin().replaceAll("\n", " "), e);
    }

    public Throwable failToRecognizePatternAfterUpgradeError(String pattern, Throwable e) {
        return new SparkUpgradeException("3.0", new StringBuilder(250).append("Fail to recognize '").append(pattern).append("' pattern in the").append(" DateTimeFormatter. 1) You can set ").append(SQLConf$.MODULE$.LEGACY_TIME_PARSER_POLICY().key()).append(" to LEGACY").append(" to restore the behavior before Spark 3.0. 2) You can form a valid datetime pattern").append(" with the guide from https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html").toString(), e);
    }

    public Throwable failToRecognizePatternError(String pattern, Throwable e) {
        return new RuntimeException(new StringBuilder(179).append("Fail to recognize '").append(pattern).append("' pattern in the").append(" DateTimeFormatter. You can form a valid datetime pattern").append(" with the guide from https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html").toString(), e);
    }

    public Throwable cannotCastToDateTimeError(Object value, DataType from, DataType to, String errorContext) {
        String valueString = this.toSQLValue(value, from);
        return new DateTimeException(new StringBuilder(150).append("Invalid input syntax for type ").append(this.toSQLType(to)).append(": ").append(valueString).append(". ").append("Use `try_cast` to tolerate malformed input and return NULL instead. ").append("If necessary set ").append(SQLConf$.MODULE$.ANSI_ENABLED().key()).append(" ").append("to false to bypass this error.").append(errorContext).toString());
    }

    public Throwable registeringStreamingQueryListenerError(Exception e) {
        return new SparkException("Exception when registering StreamingQueryListener", (Throwable)e);
    }

    public Throwable concurrentQueryInstanceError() {
        return new SparkConcurrentModificationException("CONCURRENT_QUERY", (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), SparkConcurrentModificationException$.MODULE$.$lessinit$greater$default$3());
    }

    public Throwable cannotParseJsonArraysAsStructsError() {
        return new RuntimeException("Parsing JSON arrays as structs is forbidden.");
    }

    public Throwable cannotParseStringAsDataTypeError(JsonParser parser, JsonToken token, DataType dataType) {
        return new RuntimeException(new StringBuilder(72).append("Cannot parse field name ").append(parser.getCurrentName()).append(", ").append("field value ").append(parser.getText()).append(", ").append("[").append(token).append("] as target spark data type [").append(dataType).append("].").toString());
    }

    public Throwable cannotParseStringAsDataTypeError(String pattern, String value, DataType dataType) {
        return new RuntimeException(new StringBuilder(68).append("Cannot parse field value ").append(this.toSQLValue(value, StringType$.MODULE$)).append(" ").append("for pattern ").append(this.toSQLValue(pattern, StringType$.MODULE$)).append(" ").append("as target spark data type [").append(dataType).append("].").toString());
    }

    public Throwable failToParseEmptyStringForDataTypeError(DataType dataType) {
        return new RuntimeException(new StringBuilder(46).append("Failed to parse an empty string for data type ").append(dataType.catalogString()).toString());
    }

    public Throwable failToParseValueForDataTypeError(JsonParser parser, JsonToken token, DataType dataType) {
        return new RuntimeException(new StringBuilder(75).append("Failed to parse field name ").append(parser.getCurrentName()).append(", ").append("field value ").append(parser.getText()).append(", ").append("[").append(token).append("] to target spark data type [").append(dataType).append("].").toString());
    }

    public Throwable rootConverterReturnNullError() {
        return new RuntimeException("Root converter returned null");
    }

    public Throwable cannotHaveCircularReferencesInBeanClassError(Class<?> clazz) {
        return new UnsupportedOperationException(new StringBuilder(87).append("Cannot have circular references in bean class, but got the circular reference ").append("of class ").append(clazz).toString());
    }

    public Throwable cannotHaveCircularReferencesInClassError(String t) {
        return new UnsupportedOperationException(new StringBuilder(82).append("cannot have circular references in class, but got the circular reference of class ").append(t).toString());
    }

    public Throwable cannotUseInvalidJavaIdentifierAsFieldNameError(String fieldName, WalkedTypePath walkedTypePath) {
        return new UnsupportedOperationException(new StringBuilder(70).append("`").append(fieldName).append("` is not a valid identifier of ").append("Java and cannot be used as field name\n").append(walkedTypePath).toString());
    }

    public Throwable cannotFindEncoderForTypeError(String tpe, WalkedTypePath walkedTypePath) {
        return new UnsupportedOperationException(new StringBuilder(22).append("No Encoder found for ").append(tpe).append("\n").append(walkedTypePath).toString());
    }

    public Throwable attributesForTypeUnsupportedError(ScalaReflection.Schema schema) {
        return new UnsupportedOperationException(new StringBuilder(37).append("Attributes for type ").append(schema).append(" is not supported").toString());
    }

    public Throwable schemaForTypeUnsupportedError(String tpe) {
        return new UnsupportedOperationException(new StringBuilder(33).append("Schema for type ").append(tpe).append(" is not supported").toString());
    }

    public Throwable cannotFindConstructorForTypeError(String tpe) {
        return new UnsupportedOperationException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(159).append("\n         |Unable to find constructor for ").append(tpe).append(".\n         |This could happen if ").append(tpe).append(" is an interface, or a trait without companion object\n         |constructor.\n       ").toString())).stripMargin().replaceAll("\n", " "));
    }

    public Throwable paramExceedOneCharError(String paramName) {
        return new RuntimeException(new StringBuilder(34).append(paramName).append(" cannot be more than one character").toString());
    }

    public Throwable paramIsNotIntegerError(String paramName, String value) {
        return new RuntimeException(new StringBuilder(29).append(paramName).append(" should be an integer. Found ").append(this.toSQLValue(value, StringType$.MODULE$)).toString());
    }

    public Throwable paramIsNotBooleanValueError(String paramName) {
        return new Exception(new StringBuilder(26).append(paramName).append(" flag can be true or false").toString());
    }

    public Throwable foundNullValueForNotNullableFieldError(String name) {
        return new RuntimeException(new StringBuilder(44).append("null value found but field ").append(name).append(" is not nullable.").toString());
    }

    public Throwable malformedCSVRecordError() {
        return new RuntimeException("Malformed CSV record");
    }

    public Throwable elementsOfTupleExceedLimitError() {
        return new UnsupportedOperationException("Due to Scala's limited support of tuple, tuple with more than 22 elements are not supported.");
    }

    public Throwable expressionDecodingError(Exception e, Seq<Expression> expressions) {
        return new RuntimeException(new StringBuilder(23).append("Error while decoding: ").append(e).append("\n").append(((TraversableOnce)expressions.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.simpleString(SQLConf$.MODULE$.get().maxToStringFields()), Seq$.MODULE$.canBuildFrom())).mkString("\n")).toString(), e);
    }

    public Throwable expressionEncodingError(Exception e, Seq<Expression> expressions) {
        return new RuntimeException(new StringBuilder(23).append("Error while encoding: ").append(e).append("\n").append(((TraversableOnce)expressions.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.simpleString(SQLConf$.MODULE$.get().maxToStringFields()), Seq$.MODULE$.canBuildFrom())).mkString("\n")).toString(), e);
    }

    public Throwable classHasUnexpectedSerializerError(String clsName, Expression objSerializer) {
        return new RuntimeException(new StringBuilder(34).append("class ").append(clsName).append(" has unexpected serializer: ").append(objSerializer).toString());
    }

    public Throwable cannotGetOuterPointerForInnerClassError(Class<?> innerCls) {
        return new RuntimeException(new StringBuilder(32).append("Failed to get outer pointer for ").append(innerCls.getName()).toString());
    }

    public Throwable userDefinedTypeNotAnnotatedAndRegisteredError(UserDefinedType<?> udt) {
        return new SparkException(new StringBuilder(79).append(udt.userClass().getName()).append(" is not annotated with ").append("SQLUserDefinedType nor registered with UDTRegistration.}").toString());
    }

    public Throwable unsupportedOperandTypeForSizeFunctionError(DataType dataType) {
        return new UnsupportedOperationException(new StringBuilder(51).append("The size function doesn't support the operand type ").append(dataType.getClass().getCanonicalName()).toString());
    }

    public RuntimeException unexpectedValueForStartInFunctionError(String prettyName) {
        return new RuntimeException(new StringBuilder(70).append("Unexpected value for start in function ").append(prettyName).append(": SQL array indices start at 1.").toString());
    }

    public RuntimeException unexpectedValueForLengthInFunctionError(String prettyName) {
        return new RuntimeException(new StringBuilder(84).append("Unexpected value for length in function ").append(prettyName).append(": ").append("length must be greater than or equal to 0.").toString());
    }

    public ArrayIndexOutOfBoundsException sqlArrayIndexNotStartAtOneError() {
        return new ArrayIndexOutOfBoundsException("SQL array indices start at 1");
    }

    public Throwable concatArraysWithElementsExceedLimitError(long numberOfElements) {
        return new RuntimeException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(127).append("\n         |Unsuccessful try to concat arrays with ").append(numberOfElements).append("\n         |elements due to exceeding the array size limit\n         |").append(0x7FFFFFF0).append(".\n       ").toString())).stripMargin().replaceAll("\n", " "));
    }

    public Throwable flattenArraysWithElementsExceedLimitError(long numberOfElements) {
        return new RuntimeException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(140).append("\n         |Unsuccessful try to flatten an array of arrays with ").append(numberOfElements).append("\n         |elements due to exceeding the array size limit\n         |").append(0x7FFFFFF0).append(".\n       ").toString())).stripMargin().replaceAll("\n", " "));
    }

    public RuntimeException createArrayWithElementsExceedLimitError(Object count) {
        return new RuntimeException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(126).append("\n         |Unsuccessful try to create array with ").append(count).append(" elements\n         |due to exceeding the array size limit\n         |").append(0x7FFFFFF0).append(".\n       ").toString())).stripMargin().replaceAll("\n", " "));
    }

    public Throwable unionArrayWithElementsExceedLimitError(int length) {
        return new RuntimeException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(126).append("\n         |Unsuccessful try to union arrays with ").append(length).append("\n         |elements due to exceeding the array size limit\n         |").append(0x7FFFFFF0).append(".\n       ").toString())).stripMargin().replaceAll("\n", " "));
    }

    public Throwable initialTypeNotTargetDataTypeError(DataType dataType, String target) {
        return new UnsupportedOperationException(new StringBuilder(24).append("Initial type ").append(dataType.catalogString()).append(" must be a ").append(target).toString());
    }

    public Throwable initialTypeNotTargetDataTypesError(DataType dataType) {
        return new UnsupportedOperationException(new StringBuilder(35).append("Initial type ").append(dataType.catalogString()).append(" must be ").append("an ").append(ArrayType$.MODULE$.simpleString()).append(", a ").append(StructType$.MODULE$.simpleString()).append(" or a ").append(MapType$.MODULE$.simpleString()).toString());
    }

    public Throwable cannotConvertColumnToJSONError(String name, DataType dataType) {
        return new UnsupportedOperationException(new StringBuilder(43).append("Unable to convert column ").append(name).append(" of type ").append(dataType.catalogString()).append(" to JSON.").toString());
    }

    public Throwable malformedRecordsDetectedInSchemaInferenceError(Throwable e) {
        return new SparkException(new StringBuilder(65).append("Malformed records are detected in schema inference. ").append("Parse Mode: ").append(FailFastMode$.MODULE$.name()).append(".").toString(), e);
    }

    public Throwable malformedJSONError() {
        return new SparkException("Malformed JSON");
    }

    public Throwable malformedRecordsDetectedInSchemaInferenceError(DataType dataType) {
        return new SparkException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(191).append("\n         |Malformed records are detected in schema inference.\n         |Parse Mode: ").append(FailFastMode$.MODULE$.name()).append(". Reasons: Failed to infer a common schema.\n         |Struct types are expected, but `").append(dataType.catalogString()).append("` was found.\n       ").toString())).stripMargin().replaceAll("\n", " "));
    }

    public Throwable cannotRewriteDomainJoinWithConditionsError(Seq<Expression> conditions, DomainJoin d) {
        return new IllegalStateException(new StringBuilder(48).append("Unable to rewrite domain join with conditions: ").append(conditions).append("\n").append(d).toString());
    }

    public Throwable decorrelateInnerQueryThroughPlanUnsupportedError(LogicalPlan plan2) {
        return new UnsupportedOperationException(new StringBuilder(50).append("Decorrelate inner query through ").append(plan2.nodeName()).append(" is not supported.").toString());
    }

    public Throwable methodCalledInAnalyzerNotAllowedError() {
        return new RuntimeException("This method should not be called in the analyzer");
    }

    public Throwable cannotSafelyMergeSerdePropertiesError(Map<String, String> props1, Map<String, String> props2, Set<String> conflictKeys) {
        return new UnsupportedOperationException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(110).append("\n         |Cannot safely merge SERDEPROPERTIES:\n         |").append(((TraversableOnce)props1.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new StringBuilder(1).append(k).append("=").append(v).toString();
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom())).mkString("{", ",", "}")).append("\n         |").append(((TraversableOnce)props2.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new StringBuilder(1).append(k).append("=").append(v).toString();
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom())).mkString("{", ",", "}")).append("\n         |The conflict keys: ").append(conflictKeys.mkString(", ")).append("\n         |").toString())).stripMargin());
    }

    public Throwable pairUnsupportedAtFunctionError(ValueInterval r1, ValueInterval r2, String function) {
        return new UnsupportedOperationException(new StringBuilder(28).append("Not supported pair: ").append(r1).append(", ").append(r2).append(" at ").append(function).append("()").toString());
    }

    public <TreeType extends TreeNode<?>> Throwable onceStrategyIdempotenceIsBrokenForBatchError(String batchName, TreeType plan2, TreeType reOptimized) {
        return new RuntimeException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(78).append("\n         |Once strategy's idempotence is broken for batch ").append(batchName).append("\n         |").append(package$.MODULE$.sideBySide(plan2.treeString(), reOptimized.treeString()).mkString("\n")).append("\n       ").toString())).stripMargin());
    }

    public Throwable structuralIntegrityOfInputPlanIsBrokenInClassError(String className) {
        return new RuntimeException(new StringBuilder(57).append("The structural integrity of the input plan is broken in ").append(className).append(".").toString());
    }

    public Throwable structuralIntegrityIsBrokenAfterApplyingRuleError(String ruleName, String batchName) {
        return new RuntimeException(new StringBuilder(79).append("After applying rule ").append(ruleName).append(" in batch ").append(batchName).append(", ").append("the structural integrity of the plan is broken.").toString());
    }

    public Throwable ruleIdNotFoundForRuleError(String ruleName) {
        return new NoSuchElementException(new StringBuilder(22).append("Rule id not found for ").append(ruleName).toString());
    }

    public Throwable cannotCreateArrayWithElementsExceedLimitError(long numElements, String additionalErrorMessage) {
        return new RuntimeException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(144).append("\n         |Cannot create array with ").append(numElements).append("\n         |elements of data due to exceeding the limit\n         |").append(0x7FFFFFF0).append(" elements for ArrayData.\n         |").append(additionalErrorMessage).append("\n       ").toString())).stripMargin().replaceAll("\n", " "));
    }

    public Throwable indexOutOfBoundsOfArrayDataError(int idx) {
        return new SparkIndexOutOfBoundsException("INDEX_OUT_OF_BOUNDS", (String[])((Object[])new String[]{this.toSQLValue(BoxesRunTime.boxToInteger((int)idx), IntegerType$.MODULE$)}));
    }

    public Throwable malformedRecordsDetectedInRecordParsingError(BadRecordException e) {
        return new SparkException(new StringBuilder(155).append("Malformed records are detected in record parsing. ").append("Parse Mode: ").append(FailFastMode$.MODULE$.name()).append(". To process malformed records as null ").append("result, try setting the option 'mode' as 'PERMISSIVE'.").toString(), (Throwable)e);
    }

    public Throwable remoteOperationsUnsupportedError() {
        return new RuntimeException("Remote operations not supported");
    }

    public Throwable invalidKerberosConfigForHiveServer2Error() {
        return new IOException("HiveServer2 Kerberos principal or keytab is not correctly configured");
    }

    public Throwable parentSparkUIToAttachTabNotFoundError() {
        return new SparkException("Parent SparkUI to attach this tab to not found!");
    }

    public Throwable inferSchemaUnsupportedForHiveError() {
        return new UnsupportedOperationException("inferSchema is not supported for hive data source.");
    }

    public Throwable requestedPartitionsMismatchTablePartitionsError(CatalogTable table, Map<String, Option<String>> partition) {
        return new SparkException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(130).append("\n         |Requested partitioning does not match the ").append(table.identifier().table()).append(" table:\n         |Requested partitions: ").append(partition.keys().mkString(",")).append("\n         |Table partitions: ").append(table.partitionColumnNames().mkString(",")).append("\n       ").toString())).stripMargin());
    }

    public Throwable dynamicPartitionKeyNotAmongWrittenPartitionPathsError(String key) {
        return new SparkException(new StringBuilder(60).append("Dynamic partition key ").append(this.toSQLValue(key, StringType$.MODULE$)).append(" is not among written partition paths.").toString());
    }

    public Throwable cannotRemovePartitionDirError(Path partitionPath) {
        return new RuntimeException(new StringBuilder(36).append("Cannot remove partition directory '").append(partitionPath).append("'").toString());
    }

    public Throwable cannotCreateStagingDirError(String message, IOException e) {
        return new RuntimeException(new StringBuilder(33).append("Cannot create staging directory: ").append(message).toString(), e);
    }

    public Throwable serDeInterfaceNotFoundError(NoClassDefFoundError e) {
        return new ClassNotFoundException("The SerDe interface removed since Hive 2.3(HIVE-15167). Please migrate your custom SerDes to Hive 2.3. See HIVE-15167 for more details.", e);
    }

    public Throwable convertHiveTableToCatalogTableError(SparkException e, String dbName, String tableName) {
        return new SparkException(new StringBuilder(15).append(e.getMessage()).append(", db: ").append(dbName).append(", table: ").append(tableName).toString(), (Throwable)e);
    }

    public Throwable cannotRecognizeHiveTypeError(org.apache.spark.sql.catalyst.parser.ParseException e, String fieldType, String fieldName) {
        return new SparkException(new StringBuilder(45).append("Cannot recognize hive type string: ").append(fieldType).append(", column: ").append(fieldName).toString(), (Throwable)e);
    }

    public Throwable getTablesByTypeUnsupportedByHiveVersionError() {
        return new UnsupportedOperationException("Hive 2.2 and lower versions don't support getTablesByType. Please use Hive 2.3 or higher version.");
    }

    public Throwable dropTableWithPurgeUnsupportedError() {
        return new UnsupportedOperationException("DROP TABLE ... PURGE");
    }

    public Throwable alterTableWithDropPartitionAndPurgeUnsupportedError() {
        return new UnsupportedOperationException("ALTER TABLE ... DROP PARTITION ... PURGE");
    }

    public Throwable invalidPartitionFilterError() {
        return new UnsupportedOperationException("Partition filter cannot have both `\"` and `'` characters");
    }

    public Throwable getPartitionMetadataByFilterError(InvocationTargetException e) {
        return new RuntimeException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(339).append("\n         |Caught Hive MetaException attempting to get partition metadata by filter\n         |from Hive. You can set the Spark configuration setting\n         |").append(SQLConf$.MODULE$.HIVE_METASTORE_PARTITION_PRUNING_FALLBACK_ON_EXCEPTION().key()).append(" to true to work\n         |around this problem, however this will result in degraded performance. Please\n         |report a bug: https://issues.apache.org/jira/browse/SPARK\n       ").toString())).stripMargin().replaceAll("\n", " "), e);
    }

    public Throwable unsupportedHiveMetastoreVersionError(String version, String key) {
        return new UnsupportedOperationException(new StringBuilder(72).append("Unsupported Hive Metastore version (").append(version).append("). ").append("Please set ").append(key).append(" with a valid version.").toString());
    }

    public Throwable loadHiveClientCausesNoClassDefFoundError(NoClassDefFoundError cnf, Seq<URL> execJars, String key, InvocationTargetException e) {
        return new ClassNotFoundException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(185).append("\n         |").append(cnf).append(" when creating Hive client using classpath: ").append(execJars.mkString(", ")).append("\n\n         |Please make sure that jars for your version of hive and hadoop are included in the\n         |paths passed to ").append(key).append(".\n       ").toString())).stripMargin().replaceAll("\n", " "), e);
    }

    public Throwable cannotFetchTablesOfDatabaseError(String dbName, Exception e) {
        return new SparkException(new StringBuilder(29).append("Unable to fetch tables of db ").append(dbName).toString(), (Throwable)e);
    }

    public Throwable illegalLocationClauseForViewPartitionError() {
        return new SparkException("LOCATION clause illegal for view partition");
    }

    public Throwable renamePathAsExistsPathError(Path srcPath, Path dstPath) {
        return new SparkFileAlreadyExistsException("FAILED_RENAME_PATH", (String[])((Object[])new String[]{srcPath.toString(), dstPath.toString()}));
    }

    public Throwable renameAsExistsPathError(Path dstPath) {
        return new FileAlreadyExistsException(new StringBuilder(35).append("Failed to rename as ").append(dstPath).append(" already exists").toString());
    }

    public Throwable renameSrcPathNotFoundError(Path srcPath) {
        return new SparkFileNotFoundException("RENAME_SRC_PATH_NOT_FOUND", (String[])((Object[])new String[]{srcPath.toString()}));
    }

    public Throwable failedRenameTempFileError(Path srcPath, Path dstPath) {
        return new IOException(new StringBuilder(56).append("Failed to rename temp file ").append(srcPath).append(" to ").append(dstPath).append(" as rename returned false").toString());
    }

    public Throwable legacyMetadataPathExistsError(Path metadataPath, Path legacyMetadataPath) {
        return new SparkException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(900).append("\n         |Error: we detected a possible problem with the location of your \"_spark_metadata\"\n         |directory and you likely need to move it before restarting this query.\n         |\n         |Earlier version of Spark incorrectly escaped paths when writing out the\n         |\"_spark_metadata\" directory for structured streaming. While this was corrected in\n         |Spark 3.0, it appears that your query was started using an earlier version that\n         |incorrectly handled the \"_spark_metadata\" path.\n         |\n         |Correct \"_spark_metadata\" Directory: ").append(metadataPath).append("\n         |Incorrect \"_spark_metadata\" Directory: ").append(legacyMetadataPath).append("\n         |\n         |Please move the data from the incorrect directory to the correct one, delete the\n         |incorrect directory, and then restart this query. If you believe you are receiving\n         |this message in error, you can disable it with the SQL conf\n         |").append(SQLConf$.MODULE$.STREAMING_CHECKPOINT_ESCAPED_PATH_CHECK_ENABLED().key()).append(".\n       ").toString())).stripMargin());
    }

    public Throwable partitionColumnNotFoundInSchemaError(String col, StructType schema) {
        return new RuntimeException(new StringBuilder(38).append("Partition column ").append(col).append(" not found in schema ").append(schema).toString());
    }

    public Throwable stateNotDefinedOrAlreadyRemovedError() {
        return new NoSuchElementException("State is either not defined or has already been removed");
    }

    public Throwable cannotSetTimeoutDurationError() {
        return new UnsupportedOperationException("Cannot set timeout duration without enabling processing time timeout in [map|flatMap]GroupsWithState");
    }

    public Throwable cannotGetEventTimeWatermarkError() {
        return new UnsupportedOperationException("Cannot get event time watermark timestamp without setting watermark before [map|flatMap]GroupsWithState");
    }

    public Throwable cannotSetTimeoutTimestampError() {
        return new UnsupportedOperationException("Cannot set timeout timestamp without enabling event time timeout in [map|flatMapGroupsWithState");
    }

    public Throwable batchMetadataFileNotFoundError(Path batchMetadataFile) {
        return new FileNotFoundException(new StringBuilder(21).append("Unable to find batch ").append(batchMetadataFile).toString());
    }

    public Throwable multiStreamingQueriesUsingPathConcurrentlyError(String path, FileAlreadyExistsException e) {
        return new ConcurrentModificationException(new StringBuilder(50).append("Multiple streaming queries are concurrently using ").append(path).toString(), (Throwable)e);
    }

    public Throwable addFilesWithAbsolutePathUnsupportedError(String commitProtocol) {
        return new UnsupportedOperationException(new StringBuilder(52).append(commitProtocol).append(" does not support adding files with an absolute path").toString());
    }

    public Throwable microBatchUnsupportedByDataSourceError(String srcName) {
        return new UnsupportedOperationException(new StringBuilder(52).append("Data source ").append(srcName).append(" does not support microbatch processing.").toString());
    }

    public Throwable cannotExecuteStreamingRelationExecError() {
        return new UnsupportedOperationException("StreamingRelationExec cannot be executed");
    }

    public Throwable invalidStreamingOutputModeError(Option<OutputMode> outputMode) {
        return new UnsupportedOperationException(new StringBuilder(21).append("Invalid output mode: ").append(outputMode).toString());
    }

    public Throwable catalogPluginClassNotFoundError(String name) {
        return new CatalogNotFoundException(new StringBuilder(68).append("Catalog '").append(name).append("' plugin class not found: spark.sql.catalog.").append(name).append(" is not defined").toString());
    }

    public Throwable catalogPluginClassNotImplementedError(String name, String pluginClassName) {
        return new SparkException(new StringBuilder(62).append("Plugin class for catalog '").append(name).append("' does not implement CatalogPlugin: ").append(pluginClassName).toString());
    }

    public Throwable catalogPluginClassNotFoundForCatalogError(String name, String pluginClassName, Exception e) {
        return new SparkException(new StringBuilder(49).append("Cannot find catalog plugin class for catalog '").append(name).append("': ").append(pluginClassName).toString(), (Throwable)e);
    }

    public Throwable catalogFailToFindPublicNoArgConstructorError(String name, String pluginClassName, Exception e) {
        return new SparkException(new StringBuilder(58).append("Failed to find public no-arg constructor for catalog '").append(name).append("': ").append(pluginClassName).append(")").toString(), (Throwable)e);
    }

    public Throwable catalogFailToCallPublicNoArgConstructorError(String name, String pluginClassName, Exception e) {
        return new SparkException(new StringBuilder(58).append("Failed to call public no-arg constructor for catalog '").append(name).append("': ").append(pluginClassName).append(")").toString(), (Throwable)e);
    }

    public Throwable cannotInstantiateAbstractCatalogPluginClassError(String name, String pluginClassName, Exception e) {
        return new SparkException(new StringBuilder(65).append("Cannot instantiate abstract catalog plugin class for ").append("catalog '").append(name).append("': ").append(pluginClassName).toString(), e.getCause());
    }

    public Throwable failedToInstantiateConstructorForCatalogError(String name, String pluginClassName, Exception e) {
        return new SparkException(new StringBuilder(56).append("Failed during instantiating constructor for catalog ").append("'").append(name).append("': ").append(pluginClassName).toString(), e.getCause());
    }

    public Throwable noSuchElementExceptionError() {
        return new NoSuchElementException();
    }

    public Throwable noSuchElementExceptionError(String key) {
        return new NoSuchElementException(key);
    }

    public Throwable cannotMutateReadOnlySQLConfError() {
        return new UnsupportedOperationException("Cannot mutate ReadOnlySQLConf.");
    }

    public Throwable cannotCloneOrCopyReadOnlySQLConfError() {
        return new UnsupportedOperationException("Cannot clone/copy ReadOnlySQLConf.");
    }

    public Throwable cannotGetSQLConfInSchedulerEventLoopThreadError() {
        return new RuntimeException("Cannot get SQLConf inside scheduler event loop thread.");
    }

    public Throwable unsupportedOperationExceptionError() {
        return new UnsupportedOperationException();
    }

    public Throwable nullLiteralsCannotBeCastedError(String name) {
        return new UnsupportedOperationException(new StringBuilder(33).append("null literals can't be casted to ").append(name).toString());
    }

    public Throwable notUserDefinedTypeError(String name, String userClass) {
        return new SparkException(new StringBuilder(80).append(name).append(" is not an UserDefinedType. Please make sure registering ").append("an UserDefinedType for ").append(userClass).toString());
    }

    public Throwable cannotLoadUserDefinedTypeError(String name, String userClass) {
        return new SparkException(new StringBuilder(49).append("Can not load in UserDefinedType ").append(name).append(" for user class ").append(userClass).append(".").toString());
    }

    public Throwable timeZoneIdNotSpecifiedForTimestampTypeError() {
        return new SparkUnsupportedOperationException("UNSUPPORTED_OPERATION", (String[])((Object[])new String[]{new StringBuilder(79).append(this.toSQLType(TimestampType$.MODULE$)).append(" must supply timeZoneId parameter ").append("while converting to the arrow timestamp type.").toString()}));
    }

    public Throwable notPublicClassError(String name) {
        return new UnsupportedOperationException(new StringBuilder(58).append(name).append(" is not a public class. Only public classes are supported.").toString());
    }

    public Throwable primitiveTypesNotSupportedError() {
        return new UnsupportedOperationException("Primitive types are not supported.");
    }

    public Throwable fieldIndexOnRowWithoutSchemaError() {
        return new UnsupportedOperationException("fieldIndex on a Row without schema is undefined.");
    }

    public Throwable valueIsNullError(int index) {
        return new NullPointerException(new StringBuilder(23).append("Value at index ").append(this.toSQLValue(BoxesRunTime.boxToInteger((int)index), IntegerType$.MODULE$)).append(" is null").toString());
    }

    public Throwable onlySupportDataSourcesProvidingFileFormatError(String providingClass) {
        return new SparkException(new StringBuilder(54).append("Only Data Sources providing FileFormat are supported: ").append(providingClass).toString());
    }

    public Throwable failToSetOriginalPermissionBackError(FsPermission permission, Path path, Throwable e) {
        return new SparkSecurityException("RESET_PERMISSION_TO_ORIGINAL", (String[])((Object[])new String[]{permission.toString(), path.toString(), e.getMessage()}));
    }

    public Throwable failToSetOriginalACLBackError(String aclEntries, Path path, Throwable e) {
        return new SecurityException(new StringBuilder(67).append("Failed to set original ACL ").append(aclEntries).append(" back to ").append("the created path: ").append(path).append(". Exception: ").append(e.getMessage()).toString());
    }

    public Throwable multiFailuresInStageMaterializationError(Throwable error) {
        return new SparkException("Multiple failures in stage materialization.", error);
    }

    public Throwable unrecognizedCompressionSchemaTypeIDError(int typeId) {
        return new UnsupportedOperationException(new StringBuilder(41).append("Unrecognized compression scheme type ID: ").append(typeId).toString());
    }

    public Throwable getParentLoggerNotImplementedError(String className) {
        return new SQLFeatureNotSupportedException(new StringBuilder(40).append(className).append(".getParentLogger is not yet implemented.").toString());
    }

    public Throwable cannotCreateParquetConverterForTypeError(DecimalType t, String parquetType) {
        return new RuntimeException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(179).append("\n         |Unable to create Parquet converter for ").append(t.typeName()).append("\n         |whose Parquet type is ").append(parquetType).append(" without decimal metadata. Please read this\n         |column/field as Spark BINARY type.\n       ").toString())).stripMargin().replaceAll("\n", " "));
    }

    public Throwable cannotCreateParquetConverterForDecimalTypeError(DecimalType t, String parquetType) {
        return new RuntimeException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(206).append("\n         |Unable to create Parquet converter for decimal type ").append(t.json()).append(" whose Parquet type is\n         |").append(parquetType).append(".  Parquet DECIMAL type can only be backed by INT32, INT64,\n         |FIXED_LEN_BYTE_ARRAY, or BINARY.\n       ").toString())).stripMargin().replaceAll("\n", " "));
    }

    public Throwable cannotCreateParquetConverterForDataTypeError(DataType t, String parquetType) {
        return new RuntimeException(new StringBuilder(72).append("Unable to create Parquet converter for data type ").append(t.json()).append(" ").append("whose Parquet type is ").append(parquetType).toString());
    }

    public Throwable cannotAddMultiPartitionsOnNonatomicPartitionTableError(String tableName) {
        return new UnsupportedOperationException(new StringBuilder(59).append("Nonatomic partition table ").append(tableName).append(" can not add multiple partitions.").toString());
    }

    public Throwable userSpecifiedSchemaUnsupportedByDataSourceError(TableProvider provider) {
        return new UnsupportedOperationException(new StringBuilder(47).append(provider.getClass().getSimpleName()).append(" source does not support user-specified schema.").toString());
    }

    public Throwable cannotDropMultiPartitionsOnNonatomicPartitionTableError(String tableName) {
        return new UnsupportedOperationException(new StringBuilder(60).append("Nonatomic partition table ").append(tableName).append(" can not drop multiple partitions.").toString());
    }

    public Throwable truncateMultiPartitionUnsupportedError(String tableName) {
        return new UnsupportedOperationException(new StringBuilder(61).append("The table ").append(tableName).append(" does not support truncation of multiple partition.").toString());
    }

    public Throwable overwriteTableByUnsupportedExpressionError(Table table) {
        return new SparkException(new StringBuilder(48).append("Table does not support overwrite by expression: ").append(table).toString());
    }

    public Throwable dynamicPartitionOverwriteUnsupportedByTableError(Table table) {
        return new SparkException(new StringBuilder(52).append("Table does not support dynamic partition overwrite: ").append(table).toString());
    }

    public Throwable failedMergingSchemaError(StructType schema, SparkException e) {
        return new SparkException(new StringBuilder(23).append("Failed merging schema:\n").append(schema.treeString()).toString(), (Throwable)e);
    }

    public Throwable cannotBroadcastTableOverMaxTableRowsError(long maxBroadcastTableRows, long numRows) {
        return new SparkException(new StringBuilder(44).append("Cannot broadcast the table over ").append(maxBroadcastTableRows).append(" rows: ").append(numRows).append(" rows").toString());
    }

    public Throwable cannotBroadcastTableOverMaxTableBytesError(long maxBroadcastTableBytes, long dataSize) {
        return new SparkException(new StringBuilder(49).append("Cannot broadcast the table that is larger than").append(" ").append(Utils$.MODULE$.bytesToString(maxBroadcastTableBytes)).append(": ").append(Utils$.MODULE$.bytesToString(dataSize)).toString());
    }

    public Throwable notEnoughMemoryToBuildAndBroadcastTableError(OutOfMemoryError oe) {
        return new OutOfMemoryError(new StringBuilder(225).append("Not enough memory to build and broadcast the table to all worker nodes. As a workaround, you can either disable broadcast by setting ").append(SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key()).append(" to -1 or increase the spark ").append("driver memory by setting ").append("spark.driver.memory").append(" to a higher value.").toString()).initCause(oe.getCause());
    }

    public Throwable executeCodePathUnsupportedError(String execName) {
        return new UnsupportedOperationException(new StringBuilder(42).append(execName).append(" does not support the execute() code path.").toString());
    }

    public Throwable cannotMergeClassWithOtherClassError(String className, String otherClass) {
        return new UnsupportedOperationException(new StringBuilder(19).append("Cannot merge ").append(className).append(" with ").append(otherClass).toString());
    }

    public Throwable continuousProcessingUnsupportedByDataSourceError(String sourceName) {
        return new UnsupportedOperationException(new StringBuilder(52).append("Data source ").append(sourceName).append(" does not support continuous processing.").toString());
    }

    public Throwable failedToReadDataError(Throwable failureReason) {
        return new SparkException("Data read failed", failureReason);
    }

    public Throwable failedToGenerateEpochMarkerError(Throwable failureReason) {
        return new SparkException("Epoch marker generation failed", failureReason);
    }

    public Throwable foreachWriterAbortedDueToTaskFailureError() {
        return new SparkException("Foreach writer has been aborted due to a task failure");
    }

    public Throwable integerOverflowError(String message) {
        return new ArithmeticException(new StringBuilder(18).append("Integer overflow. ").append(message).toString());
    }

    public Throwable failedToReadDeltaFileError(Path fileToRead, String clazz, int keySize) {
        return new IOException(new StringBuilder(50).append("Error reading delta file ").append(fileToRead).append(" of ").append(clazz).append(": key size cannot be ").append(keySize).toString());
    }

    public Throwable failedToReadSnapshotFileError(Path fileToRead, String clazz, String message) {
        return new IOException(new StringBuilder(34).append("Error reading snapshot file ").append(fileToRead).append(" of ").append(clazz).append(": ").append(message).toString());
    }

    public Throwable cannotPurgeAsBreakInternalStateError() {
        return new UnsupportedOperationException("Cannot purge as it might break internal state.");
    }

    public Throwable cleanUpSourceFilesUnsupportedError() {
        return new UnsupportedOperationException("Clean up source files is not supported when reading from the output directory of FileStreamSink.");
    }

    public Throwable latestOffsetNotCalledError() {
        return new UnsupportedOperationException("latestOffset(Offset, ReadLimit) should be called instead of this method");
    }

    public Throwable legacyCheckpointDirectoryExistsError(Path checkpointPath, String legacyCheckpointDir) {
        return new SparkException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(842).append("\n         |Error: we detected a possible problem with the location of your checkpoint and you\n         |likely need to move it before restarting this query.\n         |\n         |Earlier version of Spark incorrectly escaped paths when writing out checkpoints for\n         |structured streaming. While this was corrected in Spark 3.0, it appears that your\n         |query was started using an earlier version that incorrectly handled the checkpoint\n         |path.\n         |\n         |Correct Checkpoint Directory: ").append(checkpointPath).append("\n         |Incorrect Checkpoint Directory: ").append(legacyCheckpointDir).append("\n         |\n         |Please move the data from the incorrect directory to the correct one, delete the\n         |incorrect directory, and then restart this query. If you believe you are receiving\n         |this message in error, you can disable it with the SQL conf\n         |").append(SQLConf$.MODULE$.STREAMING_CHECKPOINT_ESCAPED_PATH_CHECK_ENABLED().key()).append(".\n       ").toString())).stripMargin());
    }

    public Throwable subprocessExitedError(int exitCode, CircularBuffer stderrBuffer, Throwable cause) {
        return new SparkException(new StringBuilder(39).append("Subprocess exited with status ").append(exitCode).append(". ").append("Error: ").append(stderrBuffer.toString()).toString(), cause);
    }

    public Throwable outputDataTypeUnsupportedByNodeWithoutSerdeError(String nodeName, DataType dt) {
        return new SparkException(new StringBuilder(52).append(nodeName).append(" without serde does not support ").append(dt.getClass().getSimpleName()).append(" as output data type").toString());
    }

    public Throwable invalidStartIndexError(int numRows, int startIndex) {
        return new ArrayIndexOutOfBoundsException(new StringBuilder(112).append("Invalid `startIndex` provided for generating iterator over the array. ").append("Total elements: ").append(numRows).append(", requested `startIndex`: ").append(startIndex).toString());
    }

    public Throwable concurrentModificationOnExternalAppendOnlyUnsafeRowArrayError(String className) {
        return new ConcurrentModificationException(new StringBuilder(66).append("The backing ").append(className).append(" has been modified since the creation of this Iterator").toString());
    }

    public Throwable doExecuteBroadcastNotImplementedError(String nodeName) {
        return new UnsupportedOperationException(new StringBuilder(38).append(nodeName).append(" does not implement doExecuteBroadcast").toString());
    }

    public Throwable databaseNameConflictWithSystemPreservedDatabaseError(String globalTempDB) {
        return new SparkException(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(210).append("\n         |").append(globalTempDB).append(" is a system preserved database, please rename your existing database\n         |to resolve the name conflict, or set a different value for\n         |").append(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE().key()).append(", and launch your Spark application again.\n       ").toString())).stripMargin().split("\n"))).mkString(" "));
    }

    public Throwable commentOnTableUnsupportedError() {
        return new SQLFeatureNotSupportedException("comment on table is not supported");
    }

    public Throwable unsupportedUpdateColumnNullabilityError() {
        return new SQLFeatureNotSupportedException("UpdateColumnNullability is not supported");
    }

    public Throwable renameColumnUnsupportedForOlderMySQLError() {
        return new SQLFeatureNotSupportedException("Rename column is only supported for MySQL version 8.0 and above.");
    }

    public QueryExecutionException failedToExecuteQueryError(Throwable e) {
        String message = new StringBuilder(35).append("Hit an error when executing a query").append((Object)(e.getMessage() == null ? "" : new StringBuilder(2).append(": ").append(e.getMessage()).toString())).toString();
        return new QueryExecutionException(message, e);
    }

    public Throwable nestedFieldUnsupportedError(String colName) {
        return new UnsupportedOperationException(new StringBuilder(31).append("Nested field ").append(colName).append(" is not supported.").toString());
    }

    public Throwable transformationsAndActionsNotInvokedByDriverError() {
        return new SparkException(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString("\n        |Dataset transformations and actions can only be invoked by the driver, not inside of\n        |other Dataset transformations; for example, dataset1.map(x => dataset2.values.count()\n        |* x) is invalid because the values transformation and count action cannot be\n        |performed inside of the dataset1.map transformation. For more information,\n        |see SPARK-28702.\n      ")).stripMargin().split("\n"))).mkString(" "));
    }

    public Throwable repeatedPivotsUnsupportedError() {
        return new SparkUnsupportedOperationException("UNSUPPORTED_FEATURE", (String[])((Object[])new String[]{new StringBuilder(11).append("Repeated ").append(this.toSQLStmt("pivot")).append("s.").toString()}));
    }

    public Throwable pivotNotAfterGroupByUnsupportedError() {
        return new SparkUnsupportedOperationException("UNSUPPORTED_FEATURE", (String[])((Object[])new String[]{new StringBuilder(14).append(this.toSQLStmt("pivot")).append(" not after a ").append(this.toSQLStmt("group by")).append(".").toString()}));
    }

    private String aesFuncName() {
        return this.aesFuncName;
    }

    public RuntimeException invalidAesKeyLengthError(int actualLength) {
        return new SparkRuntimeException("INVALID_PARAMETER_VALUE", (String[])((Object[])new String[]{"key", new StringBuilder(13).append("the ").append(this.aesFuncName()).append(" function").toString(), new StringBuilder(63).append("expects a binary value with 16, 24 or 32 bytes, but got ").append(Integer.toString(actualLength)).append(" bytes.").toString()}), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4());
    }

    public RuntimeException aesModeUnsupportedError(String mode, String padding) {
        return new SparkRuntimeException("UNSUPPORTED_FEATURE", (String[])((Object[])new String[]{new StringBuilder(40).append("AES-").append(mode).append(" with the padding ").append(padding).append(" by the ").append(this.aesFuncName()).append(" function.").toString()}), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4());
    }

    public RuntimeException aesCryptoError(String detailMessage) {
        return new SparkRuntimeException("INVALID_PARAMETER_VALUE", (String[])((Object[])new String[]{"expr, key", new StringBuilder(13).append("the ").append(this.aesFuncName()).append(" function").toString(), new StringBuilder(16).append("Detail message: ").append(detailMessage).toString()}), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4());
    }

    public Throwable hiveTableWithAnsiIntervalsError(String tableName) {
        return new UnsupportedOperationException(new StringBuilder(48).append("Hive table ").append(tableName).append(" with ANSI intervals is not supported").toString());
    }

    public Throwable cannotConvertOrcTimestampToTimestampNTZError() {
        return new SparkUnsupportedOperationException("UNSUPPORTED_OPERATION", (String[])((Object[])new String[]{new StringBuilder(40).append("Unable to convert ").append(this.toSQLType(TimestampType$.MODULE$)).append(" of Orc to ").append("data type ").append(this.toSQLType(TimestampNTZType$.MODULE$)).append(".").toString()}));
    }

    public Throwable cannotConvertOrcTimestampNTZToTimestampLTZError() {
        return new SparkUnsupportedOperationException("UNSUPPORTED_OPERATION", (String[])((Object[])new String[]{new StringBuilder(40).append("Unable to convert ").append(this.toSQLType(TimestampNTZType$.MODULE$)).append(" of Orc to ").append("data type ").append(this.toSQLType(TimestampType$.MODULE$)).append(".").toString()}));
    }

    public Throwable writePartitionExceedConfigSizeWhenDynamicPartitionError(int numWrittenParts, int maxDynamicPartitions, String maxDynamicPartitionsKey) {
        return new SparkException(new StringBuilder(102).append("Number of dynamic partitions created is ").append(numWrittenParts).append(", which is more than ").append(maxDynamicPartitions).append(". To solve this try to set ").append(maxDynamicPartitionsKey).append(" to at least ").append(numWrittenParts).append(".").toString());
    }

    public Throwable invalidNumberFormatError(UTF8String input, String format) {
        return new IllegalArgumentException(new StringBuilder(62).append("The input string '").append(input).append("' does not match the given number format: '").append(format).append("'").toString());
    }

    public Throwable multipleBucketTransformsError() {
        return new UnsupportedOperationException("Multiple bucket transforms are not supported.");
    }

    public Throwable unsupportedCreateNamespaceCommentError() {
        return new SQLFeatureNotSupportedException("Create namespace comment is not supported");
    }

    public Throwable unsupportedRemoveNamespaceCommentError() {
        return new SQLFeatureNotSupportedException("Remove namespace comment is not supported");
    }

    public Throwable unsupportedDropNamespaceRestrictError() {
        return new SQLFeatureNotSupportedException("Drop namespace restrict is not supported");
    }

    public ArithmeticException timestampAddOverflowError(long micros, int amount, String unit) {
        return new SparkArithmeticException("DATETIME_OVERFLOW", (String[])((Object[])new String[]{new StringBuilder(9).append("add ").append(this.toSQLValue(BoxesRunTime.boxToInteger((int)amount), IntegerType$.MODULE$)).append(" ").append(unit).append(" to ").append(this.toSQLValue(DateTimeUtils$.MODULE$.microsToInstant(micros), TimestampType$.MODULE$)).toString()}), SparkArithmeticException$.MODULE$.$lessinit$greater$default$3());
    }

    public Throwable nullComparisonResultError() {
        return new SparkException("NULL_COMPARISON_RESULT", (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), null);
    }

    public Throwable invalidBucketFile(String path) {
        return new SparkException("INVALID_BUCKET_FILE", (String[])((Object[])new String[]{path}), null);
    }

    public RuntimeException invalidPatternError(String funcName, String pattern) {
        return new SparkRuntimeException("INVALID_PARAMETER_VALUE", (String[])((Object[])new String[]{"regexp", this.toSQLId(funcName), this.toSQLValue(pattern, StringType$.MODULE$)}), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4());
    }

    private QueryExecutionErrors$() {
        MODULE$ = this;
        QueryErrorsBase.$init$(this);
        this.aesFuncName = new StringBuilder(1).append(this.toSQLId("aes_encrypt")).append("/").append(this.toSQLId("aes_decrypt")).toString();
    }
}

