/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.errors;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.RichFloat$;

@ScalaSignature(bytes="\u0006\u000194\u0001\u0002D\u0007\u0011\u0002\u0007\u0005qb\u0006\u0005\u0006=\u0001!\t\u0001\t\u0005\u0006I\u0001!\t!\n\u0005\u0006}\u0001!Ia\u0010\u0005\u0006\u0005\u0002!\ta\u0011\u0005\u0006\r\u0002!\ta\u0012\u0005\u0006\r\u0002!\ta\u0015\u0005\u0006+\u0002!\tA\u0016\u0005\u0006+\u0002!\t\u0001\u0017\u0005\u00065\u0002!\ta\u0017\u0005\u0006=\u0002!\ta\u0018\u0005\u0006E\u0002!\ta\u0019\u0002\u0010#V,'/_#se>\u00148OQ1tK*\u0011abD\u0001\u0007KJ\u0014xN]:\u000b\u0005A\t\u0012aA:rY*\u0011!cE\u0001\u0006gB\f'o\u001b\u0006\u0003)U\ta!\u00199bG\",'\"\u0001\f\u0002\u0007=\u0014xm\u0005\u0002\u00011A\u0011\u0011\u0004H\u0007\u00025)\t1$A\u0003tG\u0006d\u0017-\u0003\u0002\u001e5\t1\u0011I\\=SK\u001a\fa\u0001J5oSR$3\u0001\u0001\u000b\u0002CA\u0011\u0011DI\u0005\u0003Gi\u0011A!\u00168ji\u0006QAo\\*R\u0019Z\u000bG.^3\u0015\u0007\u0019\nd\u0007\u0005\u0002(]9\u0011\u0001\u0006\f\t\u0003Sii\u0011A\u000b\u0006\u0003W}\ta\u0001\u0010:p_Rt\u0014BA\u0017\u001b\u0003\u0019\u0001&/\u001a3fM&\u0011q\u0006\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u00055R\u0002\"\u0002\u001a\u0003\u0001\u0004\u0019\u0014!\u0001<\u0011\u0005e!\u0014BA\u001b\u001b\u0005\r\te.\u001f\u0005\u0006o\t\u0001\r\u0001O\u0001\u0002iB\u0011\u0011\bP\u0007\u0002u)\u00111hD\u0001\u0006if\u0004Xm]\u0005\u0003{i\u0012\u0001\u0002R1uCRK\b/Z\u0001\u000fcV|G/\u001a\"z\t\u00164\u0017-\u001e7u)\t1\u0003\tC\u0003B\u0007\u0001\u0007a%\u0001\u0003fY\u0016l\u0017!\u0003;p'Fc5\u000b^7u)\t1C\tC\u0003F\t\u0001\u0007a%\u0001\u0003uKb$\u0018a\u0002;p'Fc\u0015\n\u001a\u000b\u0003M!CQ!S\u0003A\u0002)\u000bQ\u0001]1siN\u00042a\u0013)'\u001d\taeJ\u0004\u0002*\u001b&\t1$\u0003\u0002P5\u00059\u0001/Y2lC\u001e,\u0017BA)S\u0005\r\u0019V-\u001d\u0006\u0003\u001fj!\"A\n+\t\u000b%3\u0001\u0019\u0001\u0014\u0002\u0013Q|7+\u0015'UsB,GC\u0001\u0014X\u0011\u00159t\u00011\u00019)\t1\u0013\fC\u0003F\u0011\u0001\u0007a%A\u0005u_N\u000bFjQ8oMR\u0011a\u0005\u0018\u0005\u0006;&\u0001\rAJ\u0001\u0005G>tg-\u0001\u0006u_\u0012\u001bv\n\u001d;j_:$\"A\n1\t\u000b\u0005T\u0001\u0019\u0001\u0014\u0002\r=\u0004H/[8o\u0003%!xnU)M\u000bb\u0004(\u000f\u0006\u0002'I\")Qm\u0003a\u0001M\u0006\tQ\r\u0005\u0002hY6\t\u0001N\u0003\u0002jU\u0006YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tYw\"\u0001\u0005dCR\fG._:u\u0013\ti\u0007N\u0001\u0006FqB\u0014Xm]:j_:\u0004")
public interface QueryErrorsBase {
    public static /* synthetic */ String toSQLValue$(QueryErrorsBase $this, Object v, DataType t) {
        return $this.toSQLValue(v, t);
    }

    default public String toSQLValue(Object v, DataType t) {
        Object object;
        Literal literal = Literal$.MODULE$.create(v, t);
        if (literal != null && (object = literal.value()) == null) {
            return "NULL";
        }
        if (literal != null) {
            Object v2 = literal.value();
            DataType dataType = literal.dataType();
            if (v2 instanceof Float) {
                float f = BoxesRunTime.unboxToFloat((Object)v2);
                if (FloatType$.MODULE$.equals(dataType)) {
                    if (Float.isNaN(f)) {
                        return "NaN";
                    }
                    if (RichFloat$.MODULE$.isPosInfinity$extension(Predef$.MODULE$.floatWrapper(f))) {
                        return "Infinity";
                    }
                    if (RichFloat$.MODULE$.isNegInfinity$extension(Predef$.MODULE$.floatWrapper(f))) {
                        return "-Infinity";
                    }
                    return Float.toString(f);
                }
            }
        }
        if (literal != null) {
            Object v3 = literal.value();
            DataType dataType = literal.dataType();
            if (v3 instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)v3);
                if (DoubleType$.MODULE$.equals(dataType)) {
                    if (Double.isNaN(d)) {
                        return "NaN";
                    }
                    if (RichDouble$.MODULE$.isPosInfinity$extension(Predef$.MODULE$.doubleWrapper(d))) {
                        return "Infinity";
                    }
                    if (RichDouble$.MODULE$.isNegInfinity$extension(Predef$.MODULE$.doubleWrapper(d))) {
                        return "-Infinity";
                    }
                    return literal.sql();
                }
            }
        }
        return literal.sql();
    }

    private String quoteByDefault(String elem) {
        return new StringBuilder(2).append("\"").append(elem).append("\"").toString();
    }

    public static /* synthetic */ String toSQLStmt$(QueryErrorsBase $this, String text) {
        return $this.toSQLStmt(text);
    }

    default public String toSQLStmt(String text) {
        return text.toUpperCase(Locale.ROOT);
    }

    public static /* synthetic */ String toSQLId$(QueryErrorsBase $this, Seq parts) {
        return $this.toSQLId((Seq<String>)parts);
    }

    default public String toSQLId(Seq<String> parts) {
        return ((TraversableOnce)parts.map((Function1 & Serializable & scala.Serializable)name -> package$.MODULE$.quoteIdentifier((String)name), Seq$.MODULE$.canBuildFrom())).mkString(".");
    }

    public static /* synthetic */ String toSQLId$(QueryErrorsBase $this, String parts) {
        return $this.toSQLId(parts);
    }

    default public String toSQLId(String parts) {
        return this.toSQLId((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])parts.split("\\.")));
    }

    public static /* synthetic */ String toSQLType$(QueryErrorsBase $this, DataType t) {
        return $this.toSQLType(t);
    }

    default public String toSQLType(DataType t) {
        return this.quoteByDefault(t.sql());
    }

    public static /* synthetic */ String toSQLType$(QueryErrorsBase $this, String text) {
        return $this.toSQLType(text);
    }

    default public String toSQLType(String text) {
        return this.quoteByDefault(text.toUpperCase(Locale.ROOT));
    }

    public static /* synthetic */ String toSQLConf$(QueryErrorsBase $this, String conf) {
        return $this.toSQLConf(conf);
    }

    default public String toSQLConf(String conf) {
        return this.quoteByDefault(conf);
    }

    public static /* synthetic */ String toDSOption$(QueryErrorsBase $this, String option) {
        return $this.toDSOption(option);
    }

    default public String toDSOption(String option) {
        return this.quoteByDefault(option);
    }

    public static /* synthetic */ String toSQLExpr$(QueryErrorsBase $this, Expression e) {
        return $this.toSQLExpr(e);
    }

    default public String toSQLExpr(Expression e) {
        return this.quoteByDefault(package$.MODULE$.toPrettySQL(e));
    }

    public static void $init$(QueryErrorsBase $this) {
    }
}

