/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.optimizer;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeMap$;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.AttributeSet$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.JoinHint;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.Subquery;
import org.apache.spark.sql.catalyst.plans.logical.Union;
import org.apache.spark.sql.catalyst.plans.logical.Window;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.Metadata$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class RemoveRedundantAliases$
extends Rule<LogicalPlan> {
    public static RemoveRedundantAliases$ MODULE$;

    static {
        new RemoveRedundantAliases$();
    }

    private Seq<Tuple2<Attribute, Attribute>> createAttributeMapping(LogicalPlan current, LogicalPlan next) {
        return (Seq)((TraversableLike)current.output().zip(next.output(), Seq$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)RemoveRedundantAliases$.$anonfun$createAttributeMapping$1(x0$1)));
    }

    private Expression removeRedundantAlias(Expression e, AttributeSet excludeList) {
        Expression expression;
        block5: {
            Attribute attribute;
            String name;
            Alias alias;
            block6: {
                expression = e;
                if (!(expression instanceof Alias)) break block5;
                alias = (Alias)expression;
                Expression attr = alias.child();
                name = alias.name();
                if (!(attr instanceof Attribute)) break block5;
                attribute = (Attribute)attr;
                Metadata metadata = alias.metadata();
                Metadata metadata2 = Metadata$.MODULE$.empty();
                if (!(metadata == null ? metadata2 != null : !((Object)metadata).equals(metadata2))) break block6;
                Metadata metadata3 = alias.metadata();
                Metadata metadata4 = attribute.metadata();
                if (metadata3 != null ? !((Object)metadata3).equals(metadata4) : metadata4 != null) break block5;
            }
            String string = name;
            String string2 = attribute.name();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                if (!excludeList.contains(attribute) && !excludeList.contains(alias)) {
                    return attribute;
                }
            }
        }
        return expression;
    }

    private LogicalPlan removeRedundantAliases(LogicalPlan plan2, AttributeSet excluded) {
        if (!plan2.containsPattern(TreePattern$.MODULE$.ALIAS())) {
            return plan2;
        }
        LogicalPlan logicalPlan = plan2;
        if (logicalPlan instanceof Subquery) {
            Subquery subquery = (Subquery)logicalPlan;
            LogicalPlan child2 = subquery.child();
            boolean correlated = subquery.correlated();
            return new Subquery(this.removeRedundantAliases(child2, excluded.$plus$plus(child2.outputSet())), correlated);
        }
        if (logicalPlan instanceof Join) {
            Join join = (Join)logicalPlan;
            LogicalPlan left = join.left();
            LogicalPlan right = join.right();
            JoinType joinType = join.joinType();
            Option<Expression> condition = join.condition();
            JoinHint hint = join.hint();
            LogicalPlan newLeft = this.removeRedundantAliases(left, excluded.$plus$plus(right.outputSet()));
            LogicalPlan newRight = this.removeRedundantAliases(right, excluded.$plus$plus(newLeft.outputSet()));
            AttributeMap mapping = AttributeMap$.MODULE$.apply((Seq)this.createAttributeMapping(left, newLeft).$plus$plus(this.createAttributeMapping(right, newRight), Seq$.MODULE$.canBuildFrom()));
            Option newCondition = condition.map((Function1 & Serializable & scala.Serializable)x$39 -> (Expression)x$39.transform(new scala.Serializable(mapping){
                public static final long serialVersionUID = 0L;
                private final AttributeMap mapping$1;

                public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof Attribute) {
                        Attribute attribute = (Attribute)A1;
                        return this.mapping$1.getOrElse(attribute, (Function0 & Serializable & scala.Serializable)() -> attribute);
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Expression x1) {
                    Expression expression = x1;
                    return expression instanceof Attribute;
                }
                {
                    this.mapping$1 = mapping$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2(org.apache.spark.sql.catalyst.expressions.Attribute )}, serializedLambda);
                }
            }));
            return new Join(newLeft, newRight, joinType, (Option<Expression>)newCondition, hint);
        }
        if (logicalPlan instanceof Union) {
            Union union = (Union)logicalPlan;
            BooleanRef first = BooleanRef.create((boolean)true);
            return (LogicalPlan)plan2.mapChildren((Function1 & Serializable & scala.Serializable)child -> {
                if (first$1.elem) {
                    first$1.elem = false;
                    return MODULE$.removeRedundantAliases((LogicalPlan)child, excluded.$plus$plus(child.outputSet()));
                }
                return MODULE$.removeRedundantAliases((LogicalPlan)child, excluded.$minus$minus(((QueryPlan)union.children().head()).outputSet()));
            });
        }
        Buffer currentNextAttrPairs = (Buffer)Buffer$.MODULE$.empty();
        LogicalPlan newNode = (LogicalPlan)plan2.mapChildren((Function1 & Serializable & scala.Serializable)child -> {
            LogicalPlan newChild = MODULE$.removeRedundantAliases((LogicalPlan)child, excluded);
            currentNextAttrPairs.$plus$plus$eq(MODULE$.createAttributeMapping((LogicalPlan)child, newChild));
            return newChild;
        });
        AttributeMap mapping = AttributeMap$.MODULE$.apply(currentNextAttrPairs.toSeq());
        LogicalPlan logicalPlan2 = plan2;
        Function1 & Serializable & scala.Serializable clean = logicalPlan2 instanceof Project ? (Function1 & Serializable & scala.Serializable)x$40 -> MODULE$.removeRedundantAlias((Expression)x$40, excluded) : (logicalPlan2 instanceof Aggregate ? (Function1 & Serializable & scala.Serializable)x$41 -> MODULE$.removeRedundantAlias((Expression)x$41, excluded) : (logicalPlan2 instanceof Window ? (Function1 & Serializable & scala.Serializable)x$42 -> MODULE$.removeRedundantAlias((Expression)x$42, excluded) : (Function1 & Serializable & scala.Serializable)x -> (Expression)Predef$.MODULE$.identity(x)));
        return (LogicalPlan)newNode.mapExpressions((Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)expr -> (Expression)clean.apply(expr.transform(new scala.Serializable(mapping){
            public static final long serialVersionUID = 0L;
            private final AttributeMap mapping$2;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 instanceof Attribute) {
                    Attribute attribute = (Attribute)A1;
                    return (B1)this.mapping$2.get(attribute).map((Function1 & Serializable & scala.Serializable)x$43 -> x$43.withName(attribute.name())).getOrElse((Function0 & Serializable & scala.Serializable)() -> attribute);
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Expression x2) {
                Expression expression = x2;
                return expression instanceof Attribute;
            }
            {
                this.mapping$2 = mapping$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3(org.apache.spark.sql.catalyst.expressions.Attribute org.apache.spark.sql.catalyst.expressions.Attribute ), $anonfun$applyOrElse$4(org.apache.spark.sql.catalyst.expressions.Attribute )}, serializedLambda);
            }
        })));
    }

    @Override
    public LogicalPlan apply(LogicalPlan plan2) {
        return this.removeRedundantAliases(plan2, AttributeSet$.MODULE$.empty());
    }

    public static final /* synthetic */ boolean $anonfun$createAttributeMapping$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Attribute a1 = (Attribute)tuple2._1();
            Attribute a2 = (Attribute)tuple2._2();
            return a1.semanticEquals(a2);
        }
        throw new MatchError((Object)tuple2);
    }

    private RemoveRedundantAliases$() {
        MODULE$ = this;
    }
}

