/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.optimizer;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeMap$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.AttributeSet$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExtractValue;
import org.apache.spark.sql.catalyst.expressions.GetArrayStructFields;
import org.apache.spark.sql.catalyst.expressions.GetStructField;
import org.apache.spark.sql.catalyst.expressions.MapKeys;
import org.apache.spark.sql.catalyst.expressions.MapValues;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateFunction;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.Expand;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.GlobalLimit;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.LocalLimit;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.RebalancePartitions;
import org.apache.spark.sql.catalyst.plans.logical.Repartition;
import org.apache.spark.sql.catalyst.plans.logical.RepartitionByExpression;
import org.apache.spark.sql.catalyst.plans.logical.Sample;
import org.apache.spark.sql.catalyst.plans.logical.Sort;
import org.apache.spark.sql.catalyst.plans.logical.Window;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class NestedColumnAliasing$ {
    public static NestedColumnAliasing$ MODULE$;

    static {
        new NestedColumnAliasing$();
    }

    public Option<LogicalPlan> unapply(LogicalPlan plan2) {
        boolean bl = false;
        Project project = null;
        LogicalPlan logicalPlan = plan2;
        if (logicalPlan instanceof Project) {
            bl = true;
            project = (Project)logicalPlan;
            Seq<NamedExpression> projectList = project.projectList();
            LogicalPlan logicalPlan2 = project.child();
            if (logicalPlan2 instanceof Filter) {
                Filter filter = (Filter)logicalPlan2;
                Expression condition = filter.condition();
                LogicalPlan child = filter.child();
                if (SQLConf$.MODULE$.get().nestedSchemaPruningEnabled() && this.canProjectPushThrough(child)) {
                    return this.rewritePlanIfSubsetFieldsUsed(plan2, (Seq<Expression>)((Seq)((TraversableLike)projectList.$plus$plus((GenTraversableOnce)new .colon.colon((Object)condition, (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())).$plus$plus(child.expressions(), Seq$.MODULE$.canBuildFrom())), child.producedAttributes().toSeq());
                }
            }
        }
        if (bl) {
            Seq<NamedExpression> projectList = project.projectList();
            LogicalPlan child = project.child();
            if (SQLConf$.MODULE$.get().nestedSchemaPruningEnabled() && this.canProjectPushThrough(child)) {
                return this.rewritePlanIfSubsetFieldsUsed(plan2, (Seq<Expression>)((Seq)projectList.$plus$plus(child.expressions(), Seq$.MODULE$.canBuildFrom())), child.producedAttributes().toSeq());
            }
        }
        if (SQLConf$.MODULE$.get().nestedSchemaPruningEnabled() && this.canPruneOn(logicalPlan)) {
            return this.rewritePlanIfSubsetFieldsUsed(plan2, logicalPlan.expressions(), logicalPlan.producedAttributes().toSeq());
        }
        return None$.MODULE$;
    }

    public Option<LogicalPlan> rewritePlanIfSubsetFieldsUsed(LogicalPlan plan2, Seq<Expression> exprList, Seq<Attribute> exclusiveAttrs) {
        Map<Attribute, Seq<ExtractValue>> attrToExtractValues = this.getAttributeToExtractValues(exprList, exclusiveAttrs, this.getAttributeToExtractValues$default$3());
        if (attrToExtractValues.isEmpty()) {
            return None$.MODULE$;
        }
        return new Some((Object)this.rewritePlanWithAliases(plan2, attrToExtractValues));
    }

    public LogicalPlan rewritePlanWithAliases(LogicalPlan plan2, Map<Attribute, Seq<ExtractValue>> attributeToExtractValues) {
        Map attributeToExtractValuesAndAliases = (Map)attributeToExtractValues.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Attribute attr = (Attribute)tuple2._1();
                Seq evSeq = (Seq)tuple2._2();
                Seq evAliasSeq = (Seq)evSeq.map((Function1 & Serializable & scala.Serializable)ev -> {
                    String string;
                    ExtractValue extractValue = ev;
                    if (extractValue instanceof GetStructField) {
                        GetStructField getStructField = (GetStructField)extractValue;
                        string = getStructField.extractFieldName();
                    } else if (extractValue instanceof GetArrayStructFields) {
                        GetArrayStructFields getArrayStructFields = (GetArrayStructFields)extractValue;
                        string = getArrayStructFields.field().name();
                    } else {
                        throw new MatchError((Object)extractValue);
                    }
                    String fieldName = string;
                    ExtractValue x$1 = ev;
                    String x$2 = new StringBuilder(9).append("_extract_").append(fieldName).toString();
                    ExprId x$3 = Alias$.MODULE$.apply$default$3((Expression)((Object)x$1), x$2);
                    Seq<String> x$4 = Alias$.MODULE$.apply$default$4((Expression)((Object)x$1), x$2);
                    Option<Metadata> x$5 = Alias$.MODULE$.apply$default$5((Expression)((Object)x$1), x$2);
                    Seq<String> x$6 = Alias$.MODULE$.apply$default$6((Expression)((Object)x$1), x$2);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ev), (Object)new Alias((Expression)((Object)x$1), x$2, x$3, x$4, x$5, x$6));
                }, Seq$.MODULE$.canBuildFrom());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)attr), (Object)evAliasSeq);
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom());
        Map nestedFieldToAlias = ((TraversableOnce)((TraversableLike)attributeToExtractValuesAndAliases.values().flatten((Function1)Predef$.MODULE$.$conforms())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                ExtractValue field = (ExtractValue)tuple2._1();
                Alias alias = (Alias)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((Expression)((Object)field)).canonicalized()), (Object)alias);
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        AttributeMap<Seq<Alias>> attrToAliases = AttributeMap$.MODULE$.apply(attributeToExtractValuesAndAliases.mapValues((Function1 & Serializable & scala.Serializable)x$1 -> (Seq)x$1.map((Function1 & Serializable & scala.Serializable)x$2 -> (Alias)x$2._2(), Seq$.MODULE$.canBuildFrom())).toSeq());
        LogicalPlan logicalPlan = plan2;
        if (logicalPlan instanceof Project) {
            Project project = (Project)logicalPlan;
            Seq<NamedExpression> projectList = project.projectList();
            LogicalPlan child = project.child();
            return new Project(this.getNewProjectList(projectList, (Map<Expression, Alias>)nestedFieldToAlias), this.replaceWithAliases(child, (Map<Expression, Alias>)nestedFieldToAlias, attrToAliases));
        }
        return this.replaceWithAliases(logicalPlan, (Map<Expression, Alias>)nestedFieldToAlias, attrToAliases);
    }

    public Seq<NamedExpression> getNewProjectList(Seq<NamedExpression> projectList, Map<Expression, Alias> nestedFieldToAlias) {
        return (Seq)projectList.map((Function1 & Serializable & scala.Serializable)x$3 -> (NamedExpression)((TreeNode)((Object)x$3)).transform(new scala.Serializable(nestedFieldToAlias){
            public static final long serialVersionUID = 0L;
            private final Map nestedFieldToAlias$1;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                ExtractValue extractValue;
                A1 A1 = x1;
                if (A1 instanceof ExtractValue && this.nestedFieldToAlias$1.contains((Object)((Expression)((Object)(extractValue = (ExtractValue)((Object)A1)))).canonicalized())) {
                    return (B1)((Alias)this.nestedFieldToAlias$1.apply((Object)((Expression)((Object)extractValue)).canonicalized())).toAttribute();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Expression x1) {
                ExtractValue extractValue;
                Expression expression = x1;
                return expression instanceof ExtractValue && this.nestedFieldToAlias$1.contains((Object)((Expression)((Object)(extractValue = (ExtractValue)((Object)expression)))).canonicalized());
            }
            {
                this.nestedFieldToAlias$1 = nestedFieldToAlias$1;
            }
        }), Seq$.MODULE$.canBuildFrom());
    }

    public LogicalPlan replaceWithAliases(LogicalPlan plan3, Map<Expression, Alias> nestedFieldToAlias, AttributeMap<Seq<Alias>> attrToAliases) {
        return (LogicalPlan)((QueryPlan)plan3.withNewChildren((Seq)plan3.children().map((Function1 & Serializable & scala.Serializable)plan2 -> new Project((Seq<NamedExpression>)((Seq)plan2.output().flatMap((Function1 & Serializable & scala.Serializable)a -> (Seq)attrToAliases.getOrElse((Attribute)a, (Function0 & Serializable & scala.Serializable)() -> (Seq)new .colon.colon(a, (List)Nil$.MODULE$)), Seq$.MODULE$.canBuildFrom())), (LogicalPlan)plan2), Seq$.MODULE$.canBuildFrom()))).transformExpressions((PartialFunction<Expression, Expression>)new scala.Serializable(nestedFieldToAlias){
            public static final long serialVersionUID = 0L;
            private final Map nestedFieldToAlias$2;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                ExtractValue extractValue;
                A1 A1 = x1;
                if (A1 instanceof ExtractValue && this.nestedFieldToAlias$2.contains((Object)((Expression)((Object)(extractValue = (ExtractValue)((Object)A1)))).canonicalized())) {
                    return (B1)((Alias)this.nestedFieldToAlias$2.apply((Object)((Expression)((Object)extractValue)).canonicalized())).toAttribute();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Expression x1) {
                ExtractValue extractValue;
                Expression expression = x1;
                return expression instanceof ExtractValue && this.nestedFieldToAlias$2.contains((Object)((Expression)((Object)(extractValue = (ExtractValue)((Object)expression)))).canonicalized());
            }
            {
                this.nestedFieldToAlias$2 = nestedFieldToAlias$2;
            }
        });
    }

    private boolean canPruneOn(LogicalPlan plan2) {
        LogicalPlan logicalPlan = plan2;
        if (logicalPlan instanceof Aggregate) {
            return true;
        }
        return logicalPlan instanceof Expand;
    }

    private boolean canProjectPushThrough(LogicalPlan plan2) {
        LogicalPlan logicalPlan = plan2;
        if (logicalPlan instanceof GlobalLimit) {
            return true;
        }
        if (logicalPlan instanceof LocalLimit) {
            return true;
        }
        if (logicalPlan instanceof Repartition) {
            return true;
        }
        if (logicalPlan instanceof Sample) {
            return true;
        }
        if (logicalPlan instanceof RepartitionByExpression) {
            return true;
        }
        if (logicalPlan instanceof RebalancePartitions) {
            return true;
        }
        if (logicalPlan instanceof Join) {
            return true;
        }
        if (logicalPlan instanceof Window) {
            return true;
        }
        return logicalPlan instanceof Sort;
    }

    private Seq<Expression> collectRootReferenceAndExtractValue(Expression e2) {
        GetArrayStructFields getArrayStructFields;
        GetStructField getStructField;
        Expression expression = e2;
        if (expression instanceof AttributeReference) {
            return (Seq)new .colon.colon((Object)e2, (List)Nil$.MODULE$);
        }
        if (expression instanceof GetStructField && ((getStructField = (GetStructField)expression).child() instanceof ExtractValue ? true : getStructField.child() instanceof AttributeReference)) {
            return (Seq)new .colon.colon((Object)e2, (List)Nil$.MODULE$);
        }
        if (expression instanceof GetArrayStructFields && ((getArrayStructFields = (GetArrayStructFields)expression).child() instanceof MapValues ? true : (getArrayStructFields.child() instanceof MapKeys ? true : (getArrayStructFields.child() instanceof ExtractValue ? true : getArrayStructFields.child() instanceof AttributeReference)))) {
            return (Seq)new .colon.colon((Object)e2, (List)Nil$.MODULE$);
        }
        if (expression.children().nonEmpty()) {
            return (Seq)expression.children().flatMap((Function1 & Serializable & scala.Serializable)e -> MODULE$.collectRootReferenceAndExtractValue((Expression)e), Seq$.MODULE$.canBuildFrom());
        }
        return (Seq)Nil$.MODULE$;
    }

    public Map<Attribute, Seq<ExtractValue>> getAttributeToExtractValues(Seq<Expression> exprList, Seq<Attribute> exclusiveAttrs, Function1<Expression, Seq<Expression>> extractor) {
        ArrayBuffer nestedFieldReferences = new ArrayBuffer();
        ArrayBuffer otherRootReferences = new ArrayBuffer();
        exprList.foreach((Function1 & Serializable & scala.Serializable)e -> {
            NestedColumnAliasing$.$anonfun$getAttributeToExtractValues$1(extractor, nestedFieldReferences, otherRootReferences, e);
            return BoxedUnit.UNIT;
        });
        AttributeSet exclusiveAttrSet = AttributeSet$.MODULE$.apply((Iterable<Expression>)((Iterable)exclusiveAttrs.$plus$plus((GenTraversableOnce)otherRootReferences, Seq$.MODULE$.canBuildFrom())));
        return (Map)((TraversableLike)nestedFieldReferences.filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)NestedColumnAliasing$.$anonfun$getAttributeToExtractValues$4(exclusiveAttrSet, x$5)))).groupBy((Function1 & Serializable & scala.Serializable)x$6 -> (Attribute)((Expression)((Expression)((Object)x$6)).references().head()).canonicalized()).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Attribute attr = (Attribute)tuple2._1();
                ArrayBuffer nestedFields = (ArrayBuffer)tuple2._2();
                if (attr != null) {
                    Attribute attribute = attr;
                    if (nestedFields != null) {
                        ArrayBuffer arrayBuffer = nestedFields;
                        ArrayBuffer dedupNestedFields = (ArrayBuffer)((TraversableLike)((SeqLike)arrayBuffer.filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)NestedColumnAliasing$.$anonfun$getAttributeToExtractValues$8(arrayBuffer, x0$3)))).distinct()).filterNot((Function1 & Serializable & scala.Serializable)ev -> BoxesRunTime.boxToBoolean((boolean)NestedColumnAliasing$.containsAggregateFunction$1(ev)));
                        int numUsedNestedFields = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)((SeqLike)dedupNestedFields.map((Function1 & Serializable & scala.Serializable)x$9 -> ((Expression)((Object)x$9)).canonicalized(), ArrayBuffer$.MODULE$.canBuildFrom())).distinct()).map((Function1 & Serializable & scala.Serializable)nestedField -> BoxesRunTime.boxToInteger((int)NestedColumnAliasing$.MODULE$.totalFieldNum(nestedField.dataType())), ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                        if (dedupNestedFields.nonEmpty() && numUsedNestedFields < MODULE$.totalFieldNum(attribute.dataType())) {
                            return Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2((Object)attribute, (Object)dedupNestedFields.toSeq())));
                        }
                        return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom());
    }

    public Function1<Expression, Seq<Expression>> getAttributeToExtractValues$default$3() {
        return (Function1 & Serializable & scala.Serializable)e -> MODULE$.collectRootReferenceAndExtractValue((Expression)e);
    }

    private int totalFieldNum(DataType dataType) {
        DataType dataType2;
        while (true) {
            DataType elementType;
            if ((dataType2 = dataType) instanceof AtomicType) {
                return 1;
            }
            if (dataType2 instanceof StructType) {
                StructType structType = (StructType)dataType2;
                StructField[] fields = structType.fields();
                return BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).map((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToInteger((int)NestedColumnAliasing$.MODULE$.totalFieldNum(f.dataType())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            }
            if (!(dataType2 instanceof ArrayType)) break;
            ArrayType arrayType = (ArrayType)dataType2;
            dataType = elementType = arrayType.elementType();
        }
        if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            return this.totalFieldNum(keyType) + this.totalFieldNum(valueType);
        }
        return 1;
    }

    public static final /* synthetic */ boolean $anonfun$getAttributeToExtractValues$3(Expression x$4) {
        return x$4 instanceof NamedLambdaVariable;
    }

    public static final /* synthetic */ void $anonfun$getAttributeToExtractValues$2(ArrayBuffer nestedFieldReferences$1, ArrayBuffer otherRootReferences$1, Expression x0$1) {
        ExtractValue extractValue;
        Expression expression = x0$1;
        if (expression instanceof ExtractValue && !((TreeNode)((Object)(extractValue = (ExtractValue)((Object)expression)))).exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)NestedColumnAliasing$.$anonfun$getAttributeToExtractValues$3(x$4)))) {
            if (((Expression)((Object)extractValue)).references().size() == 1) {
                nestedFieldReferences$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExtractValue[]{extractValue}));
                return;
            }
            return;
        }
        if (expression instanceof AttributeReference) {
            AttributeReference attributeReference = (AttributeReference)expression;
            otherRootReferences$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{attributeReference}));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$getAttributeToExtractValues$1(Function1 extractor$1, ArrayBuffer nestedFieldReferences$1, ArrayBuffer otherRootReferences$1, Expression e) {
        ((IterableLike)extractor$1.apply((Object)e)).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            NestedColumnAliasing$.$anonfun$getAttributeToExtractValues$2(nestedFieldReferences$1, otherRootReferences$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getAttributeToExtractValues$4(AttributeSet exclusiveAttrSet$1, ExtractValue x$5) {
        return !((Expression)((Object)x$5)).references().subsetOf(exclusiveAttrSet$1);
    }

    public static final /* synthetic */ boolean $anonfun$getAttributeToExtractValues$7(Expression x$7) {
        return x$7 instanceof AggregateFunction;
    }

    private static final boolean containsAggregateFunction$1(ExtractValue ev) {
        return ((TreeNode)((Object)ev)).exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)NestedColumnAliasing$.$anonfun$getAttributeToExtractValues$7(x$7)));
    }

    public static final /* synthetic */ boolean $anonfun$getAttributeToExtractValues$9(Expression child$1, ExtractValue f) {
        return !child$1.exists((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.semanticEquals((Expression)((Object)f))));
    }

    public static final /* synthetic */ boolean $anonfun$getAttributeToExtractValues$8(ArrayBuffer x3$1, ExtractValue x0$3) {
        ExtractValue extractValue = x0$3;
        if (extractValue instanceof GetStructField ? true : extractValue instanceof GetArrayStructFields) {
            Expression child = (Expression)((TreeNode)((Object)extractValue)).children().head();
            return x3$1.forall((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)NestedColumnAliasing$.$anonfun$getAttributeToExtractValues$9(child, f)));
        }
        return true;
    }

    private NestedColumnAliasing$() {
        MODULE$ = this;
    }
}

