/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Multiply;
import org.apache.spark.sql.catalyst.expressions.Multiply$;
import org.apache.spark.sql.catalyst.expressions.aggregate.BloomFilterAggregate$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.trees.TernaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.util.sketch.BloomFilter;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\tUd\u0001B\u001b7\u0001\u0016C\u0001\"\u001a\u0001\u0003\u0016\u0004%\tA\u001a\u0005\tO\u0002\u0011\t\u0012)A\u00051\"A\u0001\u000e\u0001BK\u0002\u0013\u0005a\r\u0003\u0005j\u0001\tE\t\u0015!\u0003Y\u0011!Q\u0007A!f\u0001\n\u00031\u0007\u0002C6\u0001\u0005#\u0005\u000b\u0011\u0002-\t\u00111\u0004!Q3A\u0005B5D\u0001\"\u001d\u0001\u0003\u0012\u0003\u0006IA\u001c\u0005\te\u0002\u0011)\u001a!C![\"A1\u000f\u0001B\tB\u0003%a\u000eC\u0003u\u0001\u0011\u0005Q\u000fC\u0003u\u0001\u0011\u0005A\u0010\u0003\u0004u\u0001\u0011\u0005\u0011\u0011\u0001\u0005\u0007i\u0002!\t!a\u0002\t\u000f\u0005-\u0001\u0001\"\u0011\u0002\u000e!9\u00111\u0004\u0001\u0005B\u0005u\u0001bBA\u0013\u0001\u0011\u0005\u0013q\u0005\u0005\b\u0003k\u0001A\u0011IA\u001c\u0011)\ty\u0005\u0001EC\u0002\u0013%\u0011\u0011\u000b\u0005\u000b\u00033\u0002\u0001R1A\u0005\n\u0005E\u0003BBA.\u0001\u0011\u0005c\r\u0003\u0004\u0002^\u0001!\tE\u001a\u0005\u0007\u0003?\u0002A\u0011\t4\t\u000f\u0005\u0005\u0004\u0001\"\u0015\u0002d!9\u0011\u0011\u000f\u0001\u0005B\u0005M\u0004bBA;\u0001\u0011\u0005\u0013q\u000f\u0005\b\u0003\u0013\u0003A\u0011IAF\u0011\u001d\t\u0019\n\u0001C!\u0003+Cq!a(\u0001\t\u0003\n\t\u000bC\u0004\u0002(\u0002!\t%!+\t\u000f\u00055\u0006\u0001\"\u0011\u00020\"9\u0011\u0011\u0019\u0001\u0005B\u0005\r\u0007\"CAe\u0001\u0005\u0005I\u0011AAf\u0011%\t9\u000eAI\u0001\n\u0003\tI\u000eC\u0005\u0002p\u0002\t\n\u0011\"\u0001\u0002Z\"I\u0011\u0011\u001f\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u001c\u0005\n\u0003g\u0004\u0011\u0013!C\u0001\u0003kD\u0011\"!?\u0001#\u0003%\t!!>\t\u0013\u0005m\b!!A\u0005B\u0005u\b\u0002\u0003B\u0007\u0001\u0005\u0005I\u0011A7\t\u0013\t=\u0001!!A\u0005\u0002\tE\u0001\"\u0003B\f\u0001\u0005\u0005I\u0011\tB\r\u0011%\u00119\u0003AA\u0001\n\u0003\u0011I\u0003C\u0005\u0003.\u0001\t\t\u0011\"\u0011\u00030\u001d9!1\u0007\u001c\t\u0002\tUbAB\u001b7\u0011\u0003\u00119\u0004\u0003\u0004u]\u0011\u0005!q\b\u0005\b\u0003[sCQ\u0001B!\u0011\u001d\t\tM\fC\u0003\u0005\u000bB\u0011B!\u0013/\u0003\u0003%\tIa\u0013\t\u0013\t]c&!A\u0005\u0002\ne\u0003\"\u0003B6]\u0005\u0005I\u0011\u0002B7\u0005Q\u0011En\\8n\r&dG/\u001a:BO\u001e\u0014XmZ1uK*\u0011q\u0007O\u0001\nC\u001e<'/Z4bi\u0016T!!\u000f\u001e\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003wq\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003{y\n1a]9m\u0015\ty\u0004)A\u0003ta\u0006\u00148N\u0003\u0002B\u0005\u00061\u0011\r]1dQ\u0016T\u0011aQ\u0001\u0004_J<7\u0001A\n\u0006\u0001\u0019\u0013FL\u0019\t\u0004\u000f\"SU\"\u0001\u001c\n\u0005%3$\u0001\u0007+za\u0016$\u0017*\u001c9fe\u0006$\u0018N^3BO\u001e\u0014XmZ1uKB\u00111\nU\u0007\u0002\u0019*\u0011QJT\u0001\u0007g.,Go\u00195\u000b\u0005=s\u0014\u0001B;uS2L!!\u0015'\u0003\u0017\tcwn\\7GS2$XM\u001d\t\u0004'ZCV\"\u0001+\u000b\u0005US\u0014!\u0002;sK\u0016\u001c\u0018BA,U\u0005-!VM\u001d8befd\u0015n[3\u0011\u0005eSV\"\u0001\u001d\n\u0005mC$AC#yaJ,7o]5p]B\u0011Q\fY\u0007\u0002=*\tq,A\u0003tG\u0006d\u0017-\u0003\u0002b=\n9\u0001K]8ek\u000e$\bCA/d\u0013\t!gL\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0003dQ&dG-F\u0001Y\u0003\u0019\u0019\u0007.\u001b7eA\u0005YRm\u001d;j[\u0006$X\r\u001a(v[&#X-\\:FqB\u0014Xm]:j_:\fA$Z:uS6\fG/\u001a3Ok6LE/Z7t\u000bb\u0004(/Z:tS>t\u0007%A\tok6\u0014\u0015\u000e^:FqB\u0014Xm]:j_:\f!C\\;n\u0005&$8/\u0012=qe\u0016\u001c8/[8oA\u00051R.\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G/F\u0001o!\tiv.\u0003\u0002q=\n\u0019\u0011J\u001c;\u0002/5,H/\u00192mK\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\u0004\u0013\u0001F5oaV$\u0018iZ4Ck\u001a4WM](gMN,G/A\u000bj]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u0011\u0002\rqJg.\u001b;?)\u00191x\u000f_={wB\u0011q\t\u0001\u0005\u0006K.\u0001\r\u0001\u0017\u0005\u0006Q.\u0001\r\u0001\u0017\u0005\u0006U.\u0001\r\u0001\u0017\u0005\u0006Y.\u0001\rA\u001c\u0005\u0006e.\u0001\rA\u001c\u000b\u0005mvtx\u0010C\u0003f\u0019\u0001\u0007\u0001\fC\u0003i\u0019\u0001\u0007\u0001\fC\u0003k\u0019\u0001\u0007\u0001\fF\u0003w\u0003\u0007\t)\u0001C\u0003f\u001b\u0001\u0007\u0001\fC\u0003i\u001b\u0001\u0007\u0001\fF\u0002w\u0003\u0013AQ!\u001a\bA\u0002a\u000b1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\"!a\u0004\u0011\t\u0005E\u0011qC\u0007\u0003\u0003'Q1!!\u0006;\u0003!\tg.\u00197zg&\u001c\u0018\u0002BA\r\u0003'\u0011q\u0002V=qK\u000eCWmY6SKN,H\u000e^\u0001\t]VdG.\u00192mKV\u0011\u0011q\u0004\t\u0004;\u0006\u0005\u0012bAA\u0012=\n9!i\\8mK\u0006t\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0005\u0005%\u0002\u0003BA\u0016\u0003ci!!!\f\u000b\u0007\u0005=B(A\u0003usB,7/\u0003\u0003\u00024\u00055\"\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u0002:A!\u00111HA%\u001d\u0011\ti$!\u0012\u0011\u0007\u0005}b,\u0004\u0002\u0002B)\u0019\u00111\t#\u0002\rq\u0012xn\u001c;?\u0013\r\t9EX\u0001\u0007!J,G-\u001a4\n\t\u0005-\u0013Q\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u001dc,A\tfgRLW.\u0019;fI:+X.\u0013;f[N,\"!a\u0015\u0011\u0007u\u000b)&C\u0002\u0002Xy\u0013A\u0001T8oO\u00069a.^7CSR\u001c\u0018!\u00024jeN$\u0018AB:fG>tG-A\u0003uQ&\u0014H-A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR9a/!\u001a\u0002j\u00055\u0004BBA41\u0001\u0007\u0001,\u0001\u0005oK^\u001c\u0005.\u001b7e\u0011\u0019\tY\u0007\u0007a\u00011\u0006qb.Z<FgRLW.\u0019;fI:+X.\u0013;f[N,\u0005\u0010\u001d:fgNLwN\u001c\u0005\u0007\u0003_B\u0002\u0019\u0001-\u0002)9,wOT;n\u0005&$8/\u0012=qe\u0016\u001c8/[8o\u0003]\u0019'/Z1uK\u0006;wM]3hCRLwN\u001c\"vM\u001a,'\u000fF\u0001K\u0003\u0019)\b\u000fZ1uKR)!*!\u001f\u0002~!1\u00111\u0010\u000eA\u0002)\u000baAY;gM\u0016\u0014\bbBA@5\u0001\u0007\u0011\u0011Q\u0001\tS:\u0004X\u000f\u001e*poB!\u00111QAC\u001b\u0005Q\u0014bAADu\tY\u0011J\u001c;fe:\fGNU8x\u0003\u0015iWM]4f)\u0015Q\u0015QRAH\u0011\u0019\tYh\u0007a\u0001\u0015\"1\u0011\u0011S\u000eA\u0002)\u000bQa\u001c;iKJ\fA!\u001a<bYR!\u0011qSAO!\ri\u0016\u0011T\u0005\u0004\u00037s&aA!os\"1\u00111\u0010\u000fA\u0002)\u000bQd^5uQ:+w/T;uC\ndW-Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u000b\u0004m\u0006\r\u0006BBAS;\u0001\u0007a.A\u0005oK^|eMZ:fi\u0006Yr/\u001b;i\u001d\u0016<\u0018J\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR$2A^AV\u0011\u0019\t)K\ba\u0001]\u0006I1/\u001a:jC2L'0\u001a\u000b\u0005\u0003c\u000bi\fE\u0003^\u0003g\u000b9,C\u0002\u00026z\u0013Q!\u0011:sCf\u00042!XA]\u0013\r\tYL\u0018\u0002\u0005\u0005f$X\r\u0003\u0004\u0002@~\u0001\rAS\u0001\u0004_\nT\u0017a\u00033fg\u0016\u0014\u0018.\u00197ju\u0016$2ASAc\u0011\u001d\t9\r\ta\u0001\u0003c\u000bQAY=uKN\fAaY8qsRYa/!4\u0002P\u0006E\u00171[Ak\u0011\u001d)\u0017\u0005%AA\u0002aCq\u0001[\u0011\u0011\u0002\u0003\u0007\u0001\fC\u0004kCA\u0005\t\u0019\u0001-\t\u000f1\f\u0003\u0013!a\u0001]\"9!/\tI\u0001\u0002\u0004q\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u00037T3\u0001WAoW\t\ty\u000e\u0005\u0003\u0002b\u0006-XBAAr\u0015\u0011\t)/a:\u0002\u0013Ut7\r[3dW\u0016$'bAAu=\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u00055\u00181\u001d\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"!a>+\u00079\fi.\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ty\u0010\u0005\u0003\u0003\u0002\t-QB\u0001B\u0002\u0015\u0011\u0011)Aa\u0002\u0002\t1\fgn\u001a\u0006\u0003\u0005\u0013\tAA[1wC&!\u00111\nB\u0002\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a&\u0003\u0014!A!QC\u0015\u0002\u0002\u0003\u0007a.A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u00057\u0001bA!\b\u0003$\u0005]UB\u0001B\u0010\u0015\r\u0011\tCX\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\u0013\u0005?\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011q\u0004B\u0016\u0011%\u0011)bKA\u0001\u0002\u0004\t9*\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003?\u0011\t\u0004C\u0005\u0003\u00161\n\t\u00111\u0001\u0002\u0018\u0006!\"\t\\8p[\u001aKG\u000e^3s\u0003\u001e<'/Z4bi\u0016\u0004\"a\u0012\u0018\u0014\t9\u0012ID\u0019\t\u0004;\nm\u0012b\u0001B\u001f=\n1\u0011I\\=SK\u001a$\"A!\u000e\u0015\t\u0005E&1\t\u0005\u0007\u0003\u007f\u0003\u0004\u0019\u0001&\u0015\u0007)\u00139\u0005C\u0004\u0002HF\u0002\r!!-\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0017Y\u0014iEa\u0014\u0003R\tM#Q\u000b\u0005\u0006KJ\u0002\r\u0001\u0017\u0005\u0006QJ\u0002\r\u0001\u0017\u0005\u0006UJ\u0002\r\u0001\u0017\u0005\u0006YJ\u0002\rA\u001c\u0005\u0006eJ\u0002\rA\\\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011YFa\u001a\u0011\u000bu\u0013iF!\u0019\n\u0007\t}cL\u0001\u0004PaRLwN\u001c\t\t;\n\r\u0004\f\u0017-o]&\u0019!Q\r0\u0003\rQ+\b\u000f\\36\u0011!\u0011IgMA\u0001\u0002\u00041\u0018a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011y\u0007\u0005\u0003\u0003\u0002\tE\u0014\u0002\u0002B:\u0005\u0007\u0011aa\u00142kK\u000e$\b")
public class BloomFilterAggregate
extends TypedImperativeAggregate<BloomFilter>
implements TernaryLike<Expression>,
Serializable {
    private long estimatedNumItems;
    private long numBits;
    private final Expression child;
    private final Expression estimatedNumItemsExpression;
    private final Expression numBitsExpression;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private transient Seq<Expression> children;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple5<Expression, Expression, Expression, Object, Object>> unapply(BloomFilterAggregate bloomFilterAggregate) {
        return BloomFilterAggregate$.MODULE$.unapply(bloomFilterAggregate);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return TernaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return TernaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        BloomFilterAggregate bloomFilterAggregate = this;
        synchronized (bloomFilterAggregate) {
            if (!this.bitmap$trans$0) {
                this.children = TernaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    public Expression child() {
        return this.child;
    }

    public Expression estimatedNumItemsExpression() {
        return this.estimatedNumItemsExpression;
    }

    public Expression numBitsExpression() {
        return this.numBitsExpression;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType dataType;
        DataType dataType2;
        Tuple3 tuple3 = new Tuple3((Object)this.first().dataType(), (Object)this.second().dataType(), (Object)this.third().dataType());
        if (tuple3 != null && NullType$.MODULE$.equals(dataType2 = (DataType)tuple3._2()) ? true : tuple3 != null && NullType$.MODULE$.equals(dataType = (DataType)tuple3._3())) {
            return new TypeCheckResult.TypeCheckFailure("Null typed values cannot be used as size arguments");
        }
        if (tuple3 != null) {
            DataType dataType3 = (DataType)tuple3._1();
            DataType dataType4 = (DataType)tuple3._2();
            DataType dataType5 = (DataType)tuple3._3();
            if (LongType$.MODULE$.equals(dataType3) && LongType$.MODULE$.equals(dataType4) && LongType$.MODULE$.equals(dataType5)) {
                if (!this.estimatedNumItemsExpression().foldable()) {
                    return new TypeCheckResult.TypeCheckFailure("The estimated number of items provided must be a constant literal");
                }
                if (this.estimatedNumItems() <= 0L) {
                    return new TypeCheckResult.TypeCheckFailure(new StringBuilder(74).append("The estimated number of items must be a positive value ").append(" (current value = ").append(this.estimatedNumItems()).append(")").toString());
                }
                if (!this.numBitsExpression().foldable()) {
                    return new TypeCheckResult.TypeCheckFailure("The number of bits provided must be a constant literal");
                }
                if (this.numBits() <= 0L) {
                    return new TypeCheckResult.TypeCheckFailure(new StringBuilder(63).append("The number of bits must be a positive value ").append(" (current value = ").append(this.numBits()).append(")").toString());
                }
                Predef$.MODULE$.require(this.estimatedNumItems() <= BoxesRunTime.unboxToLong((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.RUNTIME_BLOOM_FILTER_MAX_NUM_ITEMS())));
                Predef$.MODULE$.require(this.numBits() <= BoxesRunTime.unboxToLong((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.RUNTIME_BLOOM_FILTER_MAX_NUM_BITS())));
                return TypeCheckResult$TypeCheckSuccess$.MODULE$;
            }
        }
        return new TypeCheckResult.TypeCheckFailure(new StringBuilder(95).append("Input to function ").append(this.prettyName()).append(" should have ").append("been a ").append(LongType$.MODULE$.simpleString()).append(" value followed with two ").append(LongType$.MODULE$.simpleString()).append(" size ").append("arguments, but it's [").append(this.first().dataType().catalogString()).append(", ").append(this.second().dataType().catalogString()).append(", ").append(this.third().dataType().catalogString()).append("]").toString());
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return BinaryType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "bloom_filter_agg";
    }

    private long estimatedNumItems$lzycompute() {
        BloomFilterAggregate bloomFilterAggregate = this;
        synchronized (bloomFilterAggregate) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.estimatedNumItems = Math.min(((Number)this.estimatedNumItemsExpression().eval(this.estimatedNumItemsExpression().eval$default$1())).longValue(), BoxesRunTime.unboxToLong((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.RUNTIME_BLOOM_FILTER_MAX_NUM_ITEMS())));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.estimatedNumItems;
    }

    private long estimatedNumItems() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.estimatedNumItems$lzycompute();
        }
        return this.estimatedNumItems;
    }

    private long numBits$lzycompute() {
        BloomFilterAggregate bloomFilterAggregate = this;
        synchronized (bloomFilterAggregate) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.numBits = Math.min(((Number)this.numBitsExpression().eval(this.numBitsExpression().eval$default$1())).longValue(), BoxesRunTime.unboxToLong((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.RUNTIME_BLOOM_FILTER_MAX_NUM_BITS())));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.numBits;
    }

    private long numBits() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.numBits$lzycompute();
        }
        return this.numBits;
    }

    @Override
    public Expression first() {
        return this.child();
    }

    @Override
    public Expression second() {
        return this.estimatedNumItemsExpression();
    }

    @Override
    public Expression third() {
        return this.numBitsExpression();
    }

    @Override
    public BloomFilterAggregate withNewChildrenInternal(Expression newChild, Expression newEstimatedNumItemsExpression, Expression newNumBitsExpression) {
        return this.copy(newChild, newEstimatedNumItemsExpression, newNumBitsExpression, this.copy$default$4(), this.copy$default$5());
    }

    @Override
    public BloomFilter createAggregationBuffer() {
        return BloomFilter.create((long)this.estimatedNumItems(), (long)this.numBits());
    }

    @Override
    public BloomFilter update(BloomFilter buffer, InternalRow inputRow) {
        Object value = this.child().eval(inputRow);
        if (value == null) {
            return buffer;
        }
        buffer.putLong(BoxesRunTime.unboxToLong((Object)value));
        return buffer;
    }

    @Override
    public BloomFilter merge(BloomFilter buffer, BloomFilter other) {
        return buffer.mergeInPlace(other);
    }

    @Override
    public Object eval(BloomFilter buffer) {
        if (buffer.cardinality() == 0L) {
            return null;
        }
        return this.serialize(buffer);
    }

    @Override
    public BloomFilterAggregate withNewMutableAggBufferOffset(int newOffset) {
        int x$1 = newOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        int x$5 = this.copy$default$5();
        return this.copy(x$2, x$3, x$4, x$1, x$5);
    }

    @Override
    public BloomFilterAggregate withNewInputAggBufferOffset(int newOffset) {
        int x$1 = newOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        int x$5 = this.copy$default$4();
        return this.copy(x$2, x$3, x$4, x$5, x$1);
    }

    @Override
    public byte[] serialize(BloomFilter obj) {
        return BloomFilterAggregate$.MODULE$.serialize(obj);
    }

    @Override
    public BloomFilter deserialize(byte[] bytes) {
        return BloomFilterAggregate$.MODULE$.deserialize(bytes);
    }

    public BloomFilterAggregate copy(Expression child, Expression estimatedNumItemsExpression, Expression numBitsExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new BloomFilterAggregate(child, estimatedNumItemsExpression, numBitsExpression, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Expression copy$default$2() {
        return this.estimatedNumItemsExpression();
    }

    public Expression copy$default$3() {
        return this.numBitsExpression();
    }

    public int copy$default$4() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$5() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "BloomFilterAggregate";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return this.estimatedNumItemsExpression();
            }
            case 2: {
                return this.numBitsExpression();
            }
            case 3: {
                return BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
            }
            case 4: {
                return BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BloomFilterAggregate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BloomFilterAggregate)) return false;
        boolean bl = true;
        if (!bl) return false;
        BloomFilterAggregate bloomFilterAggregate = (BloomFilterAggregate)x$1;
        Expression expression = this.child();
        Expression expression2 = bloomFilterAggregate.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.estimatedNumItemsExpression();
        Expression expression4 = bloomFilterAggregate.estimatedNumItemsExpression();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.numBitsExpression();
        Expression expression6 = bloomFilterAggregate.numBitsExpression();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (this.mutableAggBufferOffset() != bloomFilterAggregate.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != bloomFilterAggregate.inputAggBufferOffset()) return false;
        if (!bloomFilterAggregate.canEqual(this)) return false;
        return true;
    }

    public BloomFilterAggregate(Expression child, Expression estimatedNumItemsExpression, Expression numBitsExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.estimatedNumItemsExpression = estimatedNumItemsExpression;
        this.numBitsExpression = numBitsExpression;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        TernaryLike.$init$(this);
    }

    public BloomFilterAggregate(Expression child, Expression estimatedNumItemsExpression, Expression numBitsExpression) {
        this(child, estimatedNumItemsExpression, numBitsExpression, 0, 0);
    }

    public BloomFilterAggregate(Expression child, Expression estimatedNumItemsExpression) {
        this(child, estimatedNumItemsExpression, new Multiply(estimatedNumItemsExpression, Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)8L)), Multiply$.MODULE$.apply$default$3()));
    }

    public BloomFilterAggregate(Expression child) {
        this(child, Literal$.MODULE$.apply(SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.RUNTIME_BLOOM_FILTER_EXPECTED_NUM_ITEMS())), Literal$.MODULE$.apply(SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.RUNTIME_BLOOM_FILTER_NUM_BITS())));
    }
}

