/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ArraySortLike;
import org.apache.spark.sql.catalyst.expressions.ArraySortLike$NullOrder$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RowOrdering$;
import org.apache.spark.sql.catalyst.expressions.SortArray$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(array[, ascendingOrder]) - Sorts the input array in ascending or descending order\n      according to the natural ordering of the array elements. NaN is greater than any non-NaN\n      elements for double/float type. Null elements will be placed at the beginning of the returned\n      array in ascending order or at the end of the returned array in descending order.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array('b', 'd', null, 'c', 'a'), true);\n       [null,\"a\",\"b\",\"c\",\"d\"]\n  ", group="array_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\t]b\u0001\u0002\u0012$\u0001BB\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t!\u0013\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005\u0015\"Aa\n\u0001BK\u0002\u0013\u0005\u0011\n\u0003\u0005P\u0001\tE\t\u0015!\u0003K\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0011\u0015\u0001\u0006\u0001\"\u0001V\u0011\u0015A\u0006\u0001\"\u0011J\u0011\u0015I\u0006\u0001\"\u0011J\u0011\u0015Q\u0006\u0001\"\u0011\\\u0011\u0015\u0011\u0007\u0001\"\u0011d\u0011\u0015\u0011\b\u0001\"\u0011J\u0011\u0015\u0019\b\u0001\"\u0011u\u0011\u001d\t\t\u0002\u0001C!\u0003'Aq!!\t\u0001\t\u0003\n\u0019\u0003C\u0004\u00024\u0001!\t%!\u000e\t\u000f\u0005E\u0003\u0001\"\u0011\u0002T!9\u0011Q\r\u0001\u0005R\u0005\u001d\u0004\"CA9\u0001\u0005\u0005I\u0011AA:\u0011%\tI\bAI\u0001\n\u0003\tY\bC\u0005\u0002\u0012\u0002\t\n\u0011\"\u0001\u0002|!I\u00111\u0013\u0001\u0002\u0002\u0013\u0005\u0013Q\u0013\u0005\n\u0003K\u0003\u0011\u0011!C\u0001\u0003OC\u0011\"a,\u0001\u0003\u0003%\t!!-\t\u0013\u0005]\u0006!!A\u0005B\u0005e\u0006\"CAd\u0001\u0005\u0005I\u0011AAe\u0011%\t\u0019\u000eAA\u0001\n\u0003\n)nB\u0005\u0002z\u000e\n\t\u0011#\u0001\u0002|\u001aA!eIA\u0001\u0012\u0003\ti\u0010\u0003\u0004Q9\u0011\u0005!1\u0002\u0005\n\u0005\u001ba\u0012\u0011!C#\u0005\u001fA\u0011B!\u0005\u001d\u0003\u0003%\tIa\u0005\t\u0013\teA$!A\u0005\u0002\nm\u0001\"\u0003B\u00179\u0005\u0005I\u0011\u0002B\u0018\u0005%\u0019vN\u001d;BeJ\f\u0017P\u0003\u0002%K\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t1s%\u0001\u0005dCR\fG._:u\u0015\tA\u0013&A\u0002tc2T!AK\u0016\u0002\u000bM\u0004\u0018M]6\u000b\u00051j\u0013AB1qC\u000eDWMC\u0001/\u0003\ry'oZ\u0002\u0001'\u0019\u0001\u0011'\u000e\u001d@\u000bB\u0011!gM\u0007\u0002G%\u0011Ag\t\u0002\u0011\u0005&t\u0017M]=FqB\u0014Xm]:j_:\u0004\"A\r\u001c\n\u0005]\u001a#!D!se\u0006L8k\u001c:u\u0019&\\W\r\u0005\u0002:y9\u0011!GO\u0005\u0003w\r\nq\u0001]1dW\u0006<W-\u0003\u0002>}\tqa*\u001e7m\u0013:$x\u000e\\3sC:$(BA\u001e$!\t\u00015)D\u0001B\u0015\u0005\u0011\u0015!B:dC2\f\u0017B\u0001#B\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u0011$\n\u0005\u001d\u000b%\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001\u00022bg\u0016,\u0012A\u0013\t\u0003e-K!\u0001T\u0012\u0003\u0015\u0015C\bO]3tg&|g.A\u0003cCN,\u0007%\u0001\bbg\u000e,g\u000eZ5oO>\u0013H-\u001a:\u0002\u001f\u0005\u001c8-\u001a8eS:<wJ\u001d3fe\u0002\na\u0001P5oSRtDc\u0001*T)B\u0011!\u0007\u0001\u0005\u0006\u0011\u0016\u0001\rA\u0013\u0005\u0006\u001d\u0016\u0001\rA\u0013\u000b\u0003%ZCQa\u0016\u0004A\u0002)\u000b\u0011!Z\u0001\u0005Y\u00164G/A\u0003sS\u001eDG/\u0001\u0005eCR\fG+\u001f9f+\u0005a\u0006CA/a\u001b\u0005q&BA0(\u0003\u0015!\u0018\u0010]3t\u0013\t\tgL\u0001\u0005ECR\fG+\u001f9f\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0002IB\u0019Q\r\\8\u000f\u0005\u0019\\gBA4k\u001b\u0005A'BA50\u0003\u0019a$o\\8u}%\t!)\u0003\u0002<\u0003&\u0011QN\u001c\u0002\u0004'\u0016\f(BA\u001eB!\ti\u0006/\u0003\u0002r=\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\u0010CJ\u0014\u0018-_#yaJ,7o]5p]\u0006Ia.\u001e7m\u001fJ$WM]\u000b\u0002kB\u0019a/a\u0003\u000f\u0007]\f9AD\u0002y\u0003\u000bq1!_A\u0002\u001d\rQ\u0018\u0011\u0001\b\u0003w~t!\u0001 @\u000f\u0005\u001dl\u0018\"\u0001\u0018\n\u00051j\u0013B\u0001\u0016,\u0013\tA\u0013&\u0003\u0002'O%\u0011A%J\u0005\u0004\u0003\u0013\u0019\u0013!D!se\u0006L8k\u001c:u\u0019&\\W-\u0003\u0003\u0002\u000e\u0005=!!\u0003(vY2|%\u000fZ3s\u0015\r\tIaI\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0003\u0003+\u0001B!a\u0006\u0002\u001e5\u0011\u0011\u0011\u0004\u0006\u0004\u00037)\u0013\u0001C1oC2L8/[:\n\t\u0005}\u0011\u0011\u0004\u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\u0006aa.\u001e7m'\u00064W-\u0012<bYR1\u0011QEA\u0016\u0003_\u00012\u0001QA\u0014\u0013\r\tI#\u0011\u0002\u0004\u0003:L\bbBA\u0017\u001d\u0001\u0007\u0011QE\u0001\u0006CJ\u0014\u0018-\u001f\u0005\b\u0003cq\u0001\u0019AA\u0013\u0003%\t7oY3oI&tw-A\u0005e_\u001e+gnQ8eKR1\u0011qGA\"\u0003\u001b\u0002B!!\u000f\u0002@5\u0011\u00111\b\u0006\u0004\u0003{\u0019\u0013aB2pI\u0016<WM\\\u0005\u0005\u0003\u0003\nYD\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\t)e\u0004a\u0001\u0003\u000f\n1a\u0019;y!\u0011\tI$!\u0013\n\t\u0005-\u00131\b\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\tye\u0004a\u0001\u0003o\t!!\u001a<\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u0002VA!\u0011qKA0\u001d\u0011\tI&a\u0017\u0011\u0005\u001d\f\u0015bAA/\u0003\u00061\u0001K]3eK\u001aLA!!\u0019\u0002d\t11\u000b\u001e:j]\u001eT1!!\u0018B\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0003S\u0003S\ni\u0007\u0003\u0004\u0002lE\u0001\rAS\u0001\b]\u0016<H*\u001a4u\u0011\u0019\ty'\u0005a\u0001\u0015\u0006Aa.Z<SS\u001eDG/\u0001\u0003d_BLH#\u0002*\u0002v\u0005]\u0004b\u0002%\u0013!\u0003\u0005\rA\u0013\u0005\b\u001dJ\u0001\n\u00111\u0001K\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!! +\u0007)\u000byh\u000b\u0002\u0002\u0002B!\u00111QAG\u001b\t\t)I\u0003\u0003\u0002\b\u0006%\u0015!C;oG\",7m[3e\u0015\r\tY)Q\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAH\u0003\u000b\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAL!\u0011\tI*a)\u000e\u0005\u0005m%\u0002BAO\u0003?\u000bA\u0001\\1oO*\u0011\u0011\u0011U\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002b\u0005m\u0015\u0001\u00049s_\u0012,8\r^!sSRLXCAAU!\r\u0001\u00151V\u0005\u0004\u0003[\u000b%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u0013\u0003gC\u0011\"!.\u0018\u0003\u0003\u0005\r!!+\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tY\f\u0005\u0004\u0002>\u0006\r\u0017QE\u0007\u0003\u0003\u007fS1!!1B\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u000b\fyL\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAf\u0003#\u00042\u0001QAg\u0013\r\ty-\u0011\u0002\b\u0005>|G.Z1o\u0011%\t),GA\u0001\u0002\u0004\t)#\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u0017\f9\u000eC\u0005\u00026j\t\t\u00111\u0001\u0002&!\u001a\u0002!a7\u0002b\u0006\r\u0018q]Au\u0003[\fy/a=\u0002vB\u0019!'!8\n\u0007\u0005}7EA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005\u0015\u0018Aa>\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006&\u0019:sCf\\F\u0006I1tG\u0016tG-\u001b8h\u001fJ$WM]/*A5\u00023k\u001c:ug\u0002\"\b.\u001a\u0011j]B,H\u000fI1se\u0006L\b%\u001b8!CN\u001cWM\u001c3j]\u001e\u0004sN\u001d\u0011eKN\u001cWM\u001c3j]\u001e\u0004sN\u001d3fe*\u0001\u0003\u0005\t\u0011!A\u0005\u001c7m\u001c:eS:<\u0007\u0005^8!i\",\u0007E\\1ukJ\fG\u000eI8sI\u0016\u0014\u0018N\\4!_\u001a\u0004C\u000f[3!CJ\u0014\u0018-\u001f\u0011fY\u0016lWM\u001c;t]\u0001r\u0015M\u0014\u0011jg\u0002:'/Z1uKJ\u0004C\u000f[1oA\u0005t\u0017\u0010\t8p]6r\u0015M\u0014\u0006!A\u0001\u0002\u0003\u0005I3mK6,g\u000e^:!M>\u0014\b\u0005Z8vE2,wF\u001a7pCR\u0004C/\u001f9f]\u0001rU\u000f\u001c7!K2,W.\u001a8ug\u0002:\u0018\u000e\u001c7!E\u0016\u0004\u0003\u000f\\1dK\u0012\u0004\u0013\r\u001e\u0011uQ\u0016\u0004#-Z4j]:Lgn\u001a\u0011pM\u0002\"\b.\u001a\u0011sKR,(O\\3e\u0015\u0001\u0002\u0003\u0005\t\u0011!CJ\u0014\u0018-\u001f\u0011j]\u0002\n7oY3oI&tw\rI8sI\u0016\u0014\be\u001c:!CR\u0004C\u000f[3!K:$\u0007e\u001c4!i\",\u0007E]3ukJtW\r\u001a\u0011beJ\f\u0017\u0010I5oA\u0011,7oY3oI&tw\rI8sI\u0016\u0014hF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAv\u00035T\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u0019:sCfDsEY\u0014-A\u001d\"w\u0005\f\u0011ok2dG\u0006I\u0014dO1\u0002s%Y\u0014*Y\u0001\"(/^3*w)\u0001\u0003\u0005\t\u0011!A\u0001Zf.\u001e7mY\t\n'\u0005\f\u0012cE1\u00123M\t\u0017#I\nj&\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005E\u0018aC1se\u0006LxLZ;oGN\fQa]5oG\u0016\f#!a>\u0002\u000bErSG\f\u0019\u0002\u0013M{'\u000f^!se\u0006L\bC\u0001\u001a\u001d'\u0011a\u0012q`#\u0011\u000f\t\u0005!q\u0001&K%6\u0011!1\u0001\u0006\u0004\u0005\u000b\t\u0015a\u0002:v]RLW.Z\u0005\u0005\u0005\u0013\u0011\u0019AA\tBEN$(/Y2u\rVt7\r^5p]J\"\"!a?\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a&\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000bI\u0013)Ba\u0006\t\u000b!{\u0002\u0019\u0001&\t\u000b9{\u0002\u0019\u0001&\u0002\u000fUt\u0017\r\u001d9msR!!Q\u0004B\u0015!\u0015\u0001%q\u0004B\u0012\u0013\r\u0011\t#\u0011\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000b\u0001\u0013)C\u0013&\n\u0007\t\u001d\u0012I\u0001\u0004UkBdWM\r\u0005\t\u0005W\u0001\u0013\u0011!a\u0001%\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005c\u0001B!!'\u00034%!!QGAN\u0005\u0019y%M[3di\u0002")
public class SortArray
extends BinaryExpression
implements ArraySortLike,
package.NullIntolerant,
scala.Serializable {
    private final Expression base;
    private final Expression ascendingOrder;
    private transient Comparator<Object> org$apache$spark$sql$catalyst$expressions$ArraySortLike$$lt;
    private transient Comparator<Object> org$apache$spark$sql$catalyst$expressions$ArraySortLike$$gt;
    private transient DataType elementType;
    private volatile transient byte bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(SortArray sortArray) {
        return SortArray$.MODULE$.unapply(sortArray);
    }

    public static Function1<Tuple2<Expression, Expression>, SortArray> tupled() {
        return SortArray$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, SortArray>> curried() {
        return SortArray$.MODULE$.curried();
    }

    @Override
    public boolean containsNull() {
        return ArraySortLike.containsNull$(this);
    }

    @Override
    public Object sortEval(Object array, boolean ascending) {
        return ArraySortLike.sortEval$(this, array, ascending);
    }

    @Override
    public String sortCodegen(CodegenContext ctx, ExprCode ev, String base, String order) {
        return ArraySortLike.sortCodegen$(this, ctx, ev, base, order);
    }

    private Comparator<Object> org$apache$spark$sql$catalyst$expressions$ArraySortLike$$lt$lzycompute() {
        SortArray sortArray = this;
        synchronized (sortArray) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$lt = ArraySortLike.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$lt$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$lt;
    }

    @Override
    public Comparator<Object> org$apache$spark$sql$catalyst$expressions$ArraySortLike$$lt() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$lt$lzycompute();
        }
        return this.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$lt;
    }

    private Comparator<Object> org$apache$spark$sql$catalyst$expressions$ArraySortLike$$gt$lzycompute() {
        SortArray sortArray = this;
        synchronized (sortArray) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$gt = ArraySortLike.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$gt$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$gt;
    }

    @Override
    public Comparator<Object> org$apache$spark$sql$catalyst$expressions$ArraySortLike$$gt() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$gt$lzycompute();
        }
        return this.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$gt;
    }

    private DataType elementType$lzycompute() {
        SortArray sortArray = this;
        synchronized (sortArray) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.elementType = ArraySortLike.elementType$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.elementType;
    }

    @Override
    public DataType elementType() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.elementType$lzycompute();
        }
        return this.elementType;
    }

    public Expression base() {
        return this.base;
    }

    public Expression ascendingOrder() {
        return this.ascendingOrder;
    }

    @Override
    public Expression left() {
        return this.base();
    }

    @Override
    public Expression right() {
        return this.ascendingOrder();
    }

    @Override
    public DataType dataType() {
        return this.base().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)ArrayType$.MODULE$, (List)new .colon.colon((Object)BooleanType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public Expression arrayExpression() {
        return this.base();
    }

    @Override
    public int nullOrder() {
        return ArraySortLike$NullOrder$.MODULE$.Least();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        boolean bl = false;
        ArrayType arrayType = null;
        DataType dataType = this.base().dataType();
        if (dataType instanceof ArrayType) {
            bl = true;
            arrayType = (ArrayType)dataType;
            DataType dt = arrayType.elementType();
            if (RowOrdering$.MODULE$.isOrderable(dt)) {
                Expression expression = this.ascendingOrder();
                if (expression instanceof Literal) {
                    Literal literal = (Literal)expression;
                    DataType dataType2 = literal.dataType();
                    if (literal.value() instanceof Boolean && BooleanType$.MODULE$.equals(dataType2)) {
                        return TypeCheckResult$TypeCheckSuccess$.MODULE$;
                    }
                }
                return new TypeCheckResult.TypeCheckFailure("Sort order in second argument requires a boolean literal.");
            }
        }
        if (bl) {
            DataType dt = arrayType.elementType();
            String dtSimple = dt.catalogString();
            return new TypeCheckResult.TypeCheckFailure(new StringBuilder(63).append(this.prettyName()).append(" does not support sorting array of type ").append(dtSimple).append(" which is not orderable").toString());
        }
        return new TypeCheckResult.TypeCheckFailure(new StringBuilder(27).append(this.prettyName()).append(" only supports array input.").toString());
    }

    @Override
    public Object nullSafeEval(Object array, Object ascending) {
        return this.sortEval(array, BoxesRunTime.unboxToBoolean((Object)ascending));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(b, order) -> this.sortCodegen(ctx, ev, (String)b, (String)order));
    }

    @Override
    public String prettyName() {
        return "sort_array";
    }

    @Override
    public SortArray withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public SortArray copy(Expression base, Expression ascendingOrder) {
        return new SortArray(base, ascendingOrder);
    }

    public Expression copy$default$1() {
        return this.base();
    }

    public Expression copy$default$2() {
        return this.ascendingOrder();
    }

    @Override
    public String productPrefix() {
        return "SortArray";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.base();
            }
            case 1: {
                return this.ascendingOrder();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SortArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SortArray)) return false;
        boolean bl = true;
        if (!bl) return false;
        SortArray sortArray = (SortArray)x$1;
        Expression expression = this.base();
        Expression expression2 = sortArray.base();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.ascendingOrder();
        Expression expression4 = sortArray.ascendingOrder();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!sortArray.canEqual(this)) return false;
        return true;
    }

    public SortArray(Expression base, Expression ascendingOrder) {
        this.base = base;
        this.ascendingOrder = ascendingOrder;
        ExpectsInputTypes.$init$(this);
        ArraySortLike.$init$(this);
    }

    public SortArray(Expression e) {
        this(e, Literal$.MODULE$.apply(BoxesRunTime.boxToBoolean((boolean)true)));
    }
}

