/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.UnresolvedSeed$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionWithRandomSeed;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Nondeterministic;
import org.apache.spark.sql.catalyst.expressions.Shuffle$;
import org.apache.spark.sql.catalyst.expressions.Stateful;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.RandomIndicesGenerator;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(array) - Returns a random permutation of the given array.", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 20, 3, 5));\n       [3,1,5,20]\n      > SELECT _FUNC_(array(1, 20, null, 3));\n       [20,null,3,1]\n  ", note="\n    The function is non-deterministic.\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\t]c\u0001\u0002\u0014(\u0001RB\u0001b\u0013\u0001\u0003\u0016\u0004%\t\u0001\u0014\u0005\t!\u0002\u0011\t\u0012)A\u0005\u001b\"A\u0011\u000b\u0001BK\u0002\u0013\u0005!\u000b\u0003\u0005Z\u0001\tE\t\u0015!\u0003T\u0011\u0015Q\u0006\u0001\"\u0001\\\u0011\u0015Q\u0006\u0001\"\u0001`\u0011\u0015\t\u0007\u0001\"\u0011M\u0011\u0015\u0011\u0007\u0001\"\u0011d\u0011!1\u0007\u0001#b\u0001\n\u0003:\u0007\"B6\u0001\t\u0003b\u0007BB@\u0001\t\u0003\n\t\u0001\u0003\u0006\u0002\n\u0001A)\u0019!C\u0001\u0003\u0003A1\"a\u0005\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0016!9\u00111\u0005\u0001\u0005R\u0005\u0015\u0002bBA\u001c\u0001\u0011E\u0013\u0011\b\u0005\b\u0003\u001b\u0002A\u0011KA(\u0011\u001d\tY\u0007\u0001C\u0005\u0003[Bq!a\"\u0001\t\u0003\nI\tC\u0004\u0002\f\u0002!\t%!$\t\u0013\u0005M\u0005!!A\u0005\u0002\u0005U\u0005\"CAN\u0001E\u0005I\u0011AAO\u0011%\t\u0019\fAI\u0001\n\u0003\t)\fC\u0005\u0002:\u0002\t\t\u0011\"\u0011\u0002<\"I\u00111\u001a\u0001\u0002\u0002\u0013\u0005\u0011Q\u001a\u0005\n\u0003\u001f\u0004\u0011\u0011!C\u0001\u0003#D\u0011\"a6\u0001\u0003\u0003%\t%!7\t\u0013\u0005\u001d\b!!A\u0005\u0002\u0005%\b\"CAw\u0001\u0005\u0005I\u0011IAx\u000f%\u0011IbJA\u0001\u0012\u0003\u0011YB\u0002\u0005'O\u0005\u0005\t\u0012\u0001B\u000f\u0011\u0019Qf\u0004\"\u0001\u0003,!I!Q\u0006\u0010\u0002\u0002\u0013\u0015#q\u0006\u0005\n\u0005cq\u0012\u0011!CA\u0005gA\u0011B!\u000f\u001f#\u0003%\t!!.\t\u0013\tmb$!A\u0005\u0002\nu\u0002\"\u0003B&=E\u0005I\u0011AA[\u0011%\u0011iEHA\u0001\n\u0013\u0011yEA\u0004TQV4g\r\\3\u000b\u0005!J\u0013aC3yaJ,7o]5p]NT!AK\u0016\u0002\u0011\r\fG/\u00197zgRT!\u0001L\u0017\u0002\u0007M\fHN\u0003\u0002/_\u0005)1\u000f]1sW*\u0011\u0001'M\u0001\u0007CB\f7\r[3\u000b\u0003I\n1a\u001c:h\u0007\u0001\u0019r\u0001A\u001b:y}\u0012\u0005\n\u0005\u00027o5\tq%\u0003\u00029O\tyQK\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u00027u%\u00111h\n\u0002\u0012\u000bb\u0004Xm\u0019;t\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bC\u0001\u001c>\u0013\tqtE\u0001\u0005Ti\u0006$XMZ;m!\t1\u0004)\u0003\u0002BO\tAR\t\u001f9sKN\u001c\u0018n\u001c8XSRD'+\u00198e_6\u001cV-\u001a3\u0011\u0005\r3U\"\u0001#\u000b\u0003\u0015\u000bQa]2bY\u0006L!a\u0012#\u0003\u000fA\u0013x\u000eZ;diB\u00111)S\u0005\u0003\u0015\u0012\u0013AbU3sS\u0006d\u0017N_1cY\u0016\fQa\u00195jY\u0012,\u0012!\u0014\t\u0003m9K!aT\u0014\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0004dQ&dG\rI\u0001\u000be\u0006tGm\\7TK\u0016$W#A*\u0011\u0007\r#f+\u0003\u0002V\t\n1q\n\u001d;j_:\u0004\"aQ,\n\u0005a#%\u0001\u0002'p]\u001e\f1B]1oI>l7+Z3eA\u00051A(\u001b8jiz\"2\u0001X/_!\t1\u0004\u0001C\u0003L\u000b\u0001\u0007Q\nC\u0004R\u000bA\u0005\t\u0019A*\u0015\u0005q\u0003\u0007\"B&\u0007\u0001\u0004i\u0015AD:fK\u0012,\u0005\u0010\u001d:fgNLwN\\\u0001\fo&$\bNT3x'\u0016,G\r\u0006\u0002]I\")Q\r\u0003a\u0001-\u0006!1/Z3e\u0003!\u0011Xm]8mm\u0016$W#\u00015\u0011\u0005\rK\u0017B\u00016E\u0005\u001d\u0011un\u001c7fC:\f!\"\u001b8qkR$\u0016\u0010]3t+\u0005i\u0007c\u00018ws:\u0011q\u000e\u001e\b\u0003aNl\u0011!\u001d\u0006\u0003eN\na\u0001\u0010:p_Rt\u0014\"A#\n\u0005U$\u0015a\u00029bG.\fw-Z\u0005\u0003ob\u00141aU3r\u0015\t)H\t\u0005\u0002{{6\t1P\u0003\u0002}W\u0005)A/\u001f9fg&\u0011ap\u001f\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f\u0001\u0002Z1uCRK\b/Z\u000b\u0003\u0003\u0007\u00012A_A\u0003\u0013\r\t9a\u001f\u0002\t\t\u0006$\u0018\rV=qK\u0006YQ\r\\3nK:$H+\u001f9fQ\ra\u0011Q\u0002\t\u0004\u0007\u0006=\u0011bAA\t\t\nIAO]1og&,g\u000e^\u0001\u0007e\u0006tGm\\7\u0011\t\u0005]\u0011QD\u0007\u0003\u00033Q1!a\u0007*\u0003\u0011)H/\u001b7\n\t\u0005}\u0011\u0011\u0004\u0002\u0017%\u0006tGm\\7J]\u0012L7-Z:HK:,'/\u0019;pe\"\u001aQ\"!\u0004\u0002%%t\u0017\u000e^5bY&TX-\u00138uKJt\u0017\r\u001c\u000b\u0005\u0003O\ti\u0003E\u0002D\u0003SI1!a\u000bE\u0005\u0011)f.\u001b;\t\u000f\u0005=b\u00021\u0001\u00022\u0005q\u0001/\u0019:uSRLwN\\%oI\u0016D\bcA\"\u00024%\u0019\u0011Q\u0007#\u0003\u0007%sG/\u0001\u0007fm\u0006d\u0017J\u001c;fe:\fG\u000e\u0006\u0003\u0002<\u0005\u0005\u0003cA\"\u0002>%\u0019\u0011q\b#\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002D=\u0001\r!!\u0012\u0002\u000b%t\u0007/\u001e;\u0011\t\u0005\u001d\u0013\u0011J\u0007\u0002S%\u0019\u00111J\u0015\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\nI><UM\\\"pI\u0016$b!!\u0015\u0002^\u0005\u001d\u0004\u0003BA*\u00033j!!!\u0016\u000b\u0007\u0005]s%A\u0004d_\u0012,w-\u001a8\n\t\u0005m\u0013Q\u000b\u0002\t\u000bb\u0004(oQ8eK\"9\u0011q\f\tA\u0002\u0005\u0005\u0014aA2uqB!\u00111KA2\u0013\u0011\t)'!\u0016\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"9\u0011\u0011\u000e\tA\u0002\u0005E\u0013AA3w\u0003M\u0019\b.\u001e4gY\u0016\f%O]1z\u0007>$WmR3o)!\ty'a \u0002\u0002\u0006\r\u0005\u0003BA9\u0003srA!a\u001d\u0002vA\u0011\u0001\u000fR\u0005\u0004\u0003o\"\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002|\u0005u$AB*ue&twMC\u0002\u0002x\u0011Cq!a\u0018\u0012\u0001\u0004\t\t\u0007C\u0004\u0002jE\u0001\r!!\u0015\t\u000f\u0005\u0015\u0015\u00031\u0001\u0002p\u0005I1\r[5mI:\u000bW.Z\u0001\nMJ,7\u000f[\"paf$\u0012\u0001X\u0001\u0015o&$\bNT3x\u0007\"LG\u000eZ%oi\u0016\u0014h.\u00197\u0015\u0007q\u000by\t\u0003\u0004\u0002\u0012N\u0001\r!T\u0001\t]\u0016<8\t[5mI\u0006!1m\u001c9z)\u0015a\u0016qSAM\u0011\u001dYE\u0003%AA\u00025Cq!\u0015\u000b\u0011\u0002\u0003\u00071+\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005}%fA'\u0002\".\u0012\u00111\u0015\t\u0005\u0003K\u000by+\u0004\u0002\u0002(*!\u0011\u0011VAV\u0003%)hn\u00195fG.,GMC\u0002\u0002.\u0012\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t\t,a*\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005]&fA*\u0002\"\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!0\u0011\t\u0005}\u0016\u0011Z\u0007\u0003\u0003\u0003TA!a1\u0002F\u0006!A.\u00198h\u0015\t\t9-\u0001\u0003kCZ\f\u0017\u0002BA>\u0003\u0003\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\r\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111HAj\u0011%\t).GA\u0001\u0002\u0004\t\t$A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u00037\u0004b!!8\u0002d\u0006mRBAAp\u0015\r\t\t\u000fR\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAs\u0003?\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019\u0001.a;\t\u0013\u0005U7$!AA\u0002\u0005m\u0012AB3rk\u0006d7\u000fF\u0002i\u0003cD\u0011\"!6\u001d\u0003\u0003\u0005\r!a\u000f)/\u0001\t)0a?\u0002~\n\u0005!1\u0001B\u0004\u0005\u0013\u0011iAa\u0004\u0003\u0014\tU\u0001c\u0001\u001c\u0002x&\u0019\u0011\u0011`\u0014\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011q`\u0001A?\u001a+fjQ0)CJ\u0014\u0018-_\u0015![\u0001\u0012V\r^;s]N\u0004\u0013\r\t:b]\u0012|W\u000e\t9fe6,H/\u0019;j_:\u0004sN\u001a\u0011uQ\u0016\u0004s-\u001b<f]\u0002\n'O]1z]\u0005AQ\r_1na2,7/\t\u0002\u0003\u0006\u0005\t\u0019C\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015beJ\f\u0017\u0010K\u0019-AI\u0002D\u0006I\u001a-AUJ\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\g1\nD&\u000e\u00173auS\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u0019:sCfD\u0013\u0007\f\u00113a1\u0002c.\u001e7mY\u0001\u001a\u0014&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!7J\u0002DF\\;mY2\u001aD&M/\u000bA\u0001\nAA\\8uK\u0006\u0012!1B\u0001+\u0015\u0001\u0002\u0003\u0005\t+iK\u00022WO\\2uS>t\u0007%[:!]>tW\u0006Z3uKJl\u0017N\\5ti&\u001cgF\u0003\u0011!\u0003\u00159'o\\;qC\t\u0011\t\"A\u0006beJ\f\u0017p\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017E\u0001B\f\u0003\u0015\u0011d\u0006\u000e\u00181\u0003\u001d\u0019\u0006.\u001e4gY\u0016\u0004\"A\u000e\u0010\u0014\ty\u0011y\u0002\u0013\t\b\u0005C\u00119#T*]\u001b\t\u0011\u0019CC\u0002\u0003&\u0011\u000bqA];oi&lW-\u0003\u0003\u0003*\t\r\"!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011!1D\u0001\ti>\u001cFO]5oOR\u0011\u0011QX\u0001\u0006CB\u0004H.\u001f\u000b\u00069\nU\"q\u0007\u0005\u0006\u0017\u0006\u0002\r!\u0014\u0005\b#\u0006\u0002\n\u00111\u0001T\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005\u007f\u00119\u0005\u0005\u0003D)\n\u0005\u0003#B\"\u0003D5\u001b\u0016b\u0001B#\t\n1A+\u001e9mKJB\u0001B!\u0013$\u0003\u0003\u0005\r\u0001X\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B)!\u0011\tyLa\u0015\n\t\tU\u0013\u0011\u0019\u0002\u0007\u001f\nTWm\u0019;")
public class Shuffle
extends UnaryExpression
implements ExpectsInputTypes,
Stateful,
ExpressionWithRandomSeed,
scala.Serializable {
    private boolean resolved;
    private transient DataType elementType;
    private final Expression child;
    private final Option<Object> randomSeed;
    private transient RandomIndicesGenerator random;
    private final Seq<Enumeration.Value> nodePatterns;
    private boolean deterministic;
    private transient boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Object> $lessinit$greater$default$2() {
        return Shuffle$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<Object>>> unapply(Shuffle shuffle) {
        return Shuffle$.MODULE$.unapply(shuffle);
    }

    public static Option<Object> apply$default$2() {
        return Shuffle$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple2<Expression, Option<Object>>, Shuffle> tupled() {
        return Shuffle$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Object>, Shuffle>> curried() {
        return Shuffle$.MODULE$.curried();
    }

    @Override
    public boolean fastEquals(TreeNode<?> other) {
        return Stateful.fastEquals$(this, other);
    }

    @Override
    public final boolean foldable() {
        return Nondeterministic.foldable$(this);
    }

    @Override
    public final void initialize(int partitionIndex) {
        Nondeterministic.initialize$(this, partitionIndex);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Nondeterministic.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Nondeterministic.eval$default$1$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$ExpressionWithRandomSeed$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    private boolean deterministic$lzycompute() {
        Shuffle shuffle = this;
        synchronized (shuffle) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.deterministic = Nondeterministic.deterministic$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.deterministic;
    }

    @Override
    public final boolean deterministic() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.deterministic$lzycompute();
        }
        return this.deterministic;
    }

    @Override
    public boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized() {
        return this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized_$eq(boolean x$1) {
        this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized = x$1;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public Option<Object> randomSeed() {
        return this.randomSeed;
    }

    @Override
    public Expression seedExpression() {
        return (Expression)this.randomSeed().map((Function1 & Serializable & scala.Serializable)v -> Literal$.MODULE$.apply(v)).getOrElse((Function0 & Serializable & scala.Serializable)() -> UnresolvedSeed$.MODULE$);
    }

    @Override
    public Shuffle withNewSeed(long seed) {
        Some x$1 = new Some((Object)BoxesRunTime.boxToLong((long)seed));
        Expression x$2 = this.copy$default$1();
        return this.copy(x$2, (Option<Object>)x$1);
    }

    private boolean resolved$lzycompute() {
        Shuffle shuffle = this;
        synchronized (shuffle) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.resolved = this.childrenResolved() && this.checkInputDataTypes().isSuccess() && this.randomSeed().isDefined();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)ArrayType$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return this.child().dataType();
    }

    private DataType elementType$lzycompute() {
        Shuffle shuffle = this;
        synchronized (shuffle) {
            if (!this.bitmap$trans$0) {
                this.elementType = ((ArrayType)this.dataType()).elementType();
                this.bitmap$trans$0 = true;
            }
        }
        return this.elementType;
    }

    public DataType elementType() {
        if (!this.bitmap$trans$0) {
            return this.elementType$lzycompute();
        }
        return this.elementType;
    }

    @Override
    public void initializeInternal(int partitionIndex) {
        this.random = new RandomIndicesGenerator(BoxesRunTime.unboxToLong((Object)this.randomSeed().get()) + (long)partitionIndex);
    }

    @Override
    public Object evalInternal(InternalRow input) {
        Object value = this.child().eval(input);
        if (value == null) {
            return null;
        }
        ArrayData source = (ArrayData)value;
        int numElements = source.numElements();
        int[] indices = this.random.getNextIndices(numElements);
        return new GenericArrayData(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(indices)).map((Function1 & Serializable & scala.Serializable)x$26 -> source.get(BoxesRunTime.unboxToInt((Object)x$26), this.elementType()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Object())));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> this.shuffleArrayCodeGen(ctx, ev, (String)c));
    }

    private String shuffleArrayCodeGen(CodegenContext ctx, ExprCode ev, String childName) {
        String randomClass;
        String x$1 = randomClass = RandomIndicesGenerator.class.getName();
        String x$2 = "rand";
        boolean x$3 = true;
        Function1<String, String> x$4 = ctx.addMutableState$default$3();
        boolean x$5 = ctx.addMutableState$default$5();
        String rand = ctx.addMutableState(x$1, x$2, x$4, x$3, x$5);
        ctx.addPartitionInitializationStatement(new StringBuilder(28).append(rand).append(" = new ").append(randomClass).append("(").append(this.randomSeed().get()).append("L + partitionIndex);").toString());
        String numElements = ctx.freshName("numElements");
        String arrayData = ctx.freshName("arrayData");
        String indices = ctx.freshName("indices");
        String i = ctx.freshName("i");
        String initialization = CodeGenerator$.MODULE$.createArrayData(arrayData, this.elementType(), numElements, new StringBuilder(9).append(" ").append(this.prettyName()).append(" failed.").toString());
        String assignment = CodeGenerator$.MODULE$.createArrayAssignment(arrayData, this.elementType(), childName, i, new StringBuilder(2).append(indices).append("[").append(i).append("]").toString(), ((ArrayType)this.dataType()).containsNull());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(150).append("\n       |int ").append(numElements).append(" = ").append(childName).append(".numElements();\n       |int[] ").append(indices).append(" = ").append(rand).append(".getNextIndices(").append(numElements).append(");\n       |").append(initialization).append("\n       |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(numElements).append("; ").append(i).append("++) {\n       |  ").append(assignment).append("\n       |}\n       |").append(ev.value()).append(" = ").append(arrayData).append(";\n     ").toString())).stripMargin();
    }

    @Override
    public Shuffle freshCopy() {
        return new Shuffle(this.child(), this.randomSeed());
    }

    @Override
    public Shuffle withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    public Shuffle copy(Expression child, Option<Object> randomSeed) {
        return new Shuffle(child, randomSeed);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Option<Object> copy$default$2() {
        return this.randomSeed();
    }

    @Override
    public String productPrefix() {
        return "Shuffle";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return this.randomSeed();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Shuffle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Shuffle)) return false;
        boolean bl = true;
        if (!bl) return false;
        Shuffle shuffle = (Shuffle)x$1;
        Expression expression = this.child();
        Expression expression2 = shuffle.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Object> option = this.randomSeed();
        Option<Object> option2 = shuffle.randomSeed();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!shuffle.canEqual(this)) return false;
        return true;
    }

    public Shuffle(Expression child, Option<Object> randomSeed) {
        this.child = child;
        this.randomSeed = randomSeed;
        ExpectsInputTypes.$init$(this);
        Nondeterministic.$init$(this);
        Stateful.$init$(this);
        ExpressionWithRandomSeed.$init$(this);
    }

    public Shuffle(Expression child) {
        this(child, (Option<Object>)None$.MODULE$);
    }
}

