/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.LeafExpression;
import org.apache.spark.sql.catalyst.expressions.MonotonicallyIncreasingID$;
import org.apache.spark.sql.catalyst.expressions.Nondeterministic;
import org.apache.spark.sql.catalyst.expressions.Stateful;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_() - Returns monotonically increasing 64-bit integers. The generated ID is guaranteed\n      to be monotonically increasing and unique, but not consecutive. The current implementation\n      puts the partition ID in the upper 31 bits, and the lower 33 bits represent the record number\n      within each partition. The assumption is that the data frame has less than 1 billion\n      partitions, and each partition has less than 8 billion records.\n      The function is non-deterministic because its result depends on partition IDs.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_();\n       0\n  ", since="1.4.0", group="misc_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005Me\u0001\u0002\u000e\u001c\u0001\"BQ!\u000f\u0001\u0005\u0002iB\u0011\u0002\u0010\u0001A\u0002\u0003\u0005\u000b\u0015B\u001f\t\u0013\u0011\u0003\u0001\u0019!A!B\u0013i\u0004\"\u0002$\u0001\t#:\u0005\"\u0002)\u0001\t\u0003\n\u0006\"B+\u0001\t\u00032\u0006\"B/\u0001\t#r\u0006\"B3\u0001\t\u00032\u0007\"\u0002;\u0001\t\u0003*\b\"\u0002\u0011\u0001\t\u0003*\bBBA\u0002\u0001\u0011\u0005#\b\u0003\u0005\u0002\u0006\u0001\t\t\u0011\"\u0001;\u0011%\t9\u0001AA\u0001\n\u0003\nI\u0001C\u0005\u0002\u001a\u0001\t\t\u0011\"\u0001\u0002\u001c!I\u0011Q\u0004\u0001\u0002\u0002\u0013\u0005\u0011q\u0004\u0005\n\u0003W\u0001\u0011\u0011!C!\u0003[A\u0011\"a\u000f\u0001\u0003\u0003%\t!!\u0010\t\u0013\u0005\u0005\u0003!!A\u0005B\u0005\rs!CA47\u0005\u0005\t\u0012AA5\r!Q2$!A\t\u0002\u0005-\u0004BB\u001d\u0015\t\u0003\tI\bC\u0005\u0002|Q\t\t\u0011\"\u0012\u0002~!A\u0011q\u0010\u000b\u0002\u0002\u0013\u0005%\bC\u0005\u0002\u0002R\t\t\u0011\"!\u0002\u0004\"I\u0011\u0011\u0012\u000b\u0002\u0002\u0013%\u00111\u0012\u0002\u001a\u001b>tw\u000e^8oS\u000e\fG\u000e\\=J]\u000e\u0014X-Y:j]\u001eLEI\u0003\u0002\u001d;\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tqr$\u0001\u0005dCR\fG._:u\u0015\t\u0001\u0013%A\u0002tc2T!AI\u0012\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0011*\u0013AB1qC\u000eDWMC\u0001'\u0003\ry'oZ\u0002\u0001'\u0015\u0001\u0011&\f\u00197!\tQ3&D\u0001\u001c\u0013\ta3D\u0001\bMK\u00064W\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005)r\u0013BA\u0018\u001c\u0005!\u0019F/\u0019;fMVd\u0007CA\u00195\u001b\u0005\u0011$\"A\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0012$a\u0002)s_\u0012,8\r\u001e\t\u0003c]J!\u0001\u000f\u001a\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\rqJg.\u001b;?)\u0005Y\u0004C\u0001\u0016\u0001\u0003\u0015\u0019w.\u001e8u!\t\td(\u0003\u0002@e\t!Aj\u001c8hQ\t\u0011\u0011\t\u0005\u00022\u0005&\u00111I\r\u0002\niJ\fgn]5f]R\fQ\u0002]1si&$\u0018n\u001c8NCN\\\u0007FA\u0002B\u0003IIg.\u001b;jC2L'0Z%oi\u0016\u0014h.\u00197\u0015\u0005![\u0005CA\u0019J\u0013\tQ%G\u0001\u0003V]&$\b\"\u0002'\u0005\u0001\u0004i\u0015A\u00049beRLG/[8o\u0013:$W\r\u001f\t\u0003c9K!a\u0014\u001a\u0003\u0007%sG/\u0001\u0005ok2d\u0017M\u00197f+\u0005\u0011\u0006CA\u0019T\u0013\t!&GA\u0004C_>dW-\u00198\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012a\u0016\t\u00031nk\u0011!\u0017\u0006\u00035~\tQ\u0001^=qKNL!\u0001X-\u0003\u0011\u0011\u000bG/\u0019+za\u0016\fA\"\u001a<bY&sG/\u001a:oC2$\"!P0\t\u000b\u0001<\u0001\u0019A1\u0002\u000b%t\u0007/\u001e;\u0011\u0005\t\u001cW\"A\u000f\n\u0005\u0011l\"aC%oi\u0016\u0014h.\u00197S_^\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\u0007\u001dl'\u000f\u0005\u0002iW6\t\u0011N\u0003\u0002k7\u000591m\u001c3fO\u0016t\u0017B\u00017j\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007\"\u00028\t\u0001\u0004y\u0017aA2uqB\u0011\u0001\u000e]\u0005\u0003c&\u0014abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0003t\u0011\u0001\u0007q-\u0001\u0002fm\u0006Aan\u001c3f\u001d\u0006lW-F\u0001w!\t9hP\u0004\u0002yyB\u0011\u0011PM\u0007\u0002u*\u00111pJ\u0001\u0007yI|w\u000e\u001e \n\u0005u\u0014\u0014A\u0002)sK\u0012,g-C\u0002\u0000\u0003\u0003\u0011aa\u0015;sS:<'BA?3\u0003%1'/Z:i\u0007>\u0004\u00180\u0001\u0003d_BL\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\fA!\u0011QBA\f\u001b\t\tyA\u0003\u0003\u0002\u0012\u0005M\u0011\u0001\u00027b]\u001eT!!!\u0006\u0002\t)\fg/Y\u0005\u0004\u007f\u0006=\u0011\u0001\u00049s_\u0012,8\r^!sSRLX#A'\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011EA\u0014!\r\t\u00141E\u0005\u0004\u0003K\u0011$aA!os\"A\u0011\u0011F\b\u0002\u0002\u0003\u0007Q*A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003_\u0001b!!\r\u00028\u0005\u0005RBAA\u001a\u0015\r\t)DM\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u001d\u0003g\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019!+a\u0010\t\u0013\u0005%\u0012#!AA\u0002\u0005\u0005\u0012AB3rk\u0006d7\u000fF\u0002S\u0003\u000bB\u0011\"!\u000b\u0013\u0003\u0003\u0005\r!!\t)'\u0001\tI%a\u0014\u0002R\u0005U\u0013qKA.\u0003;\n\t'a\u0019\u0011\u0007)\nY%C\u0002\u0002Nm\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002T\u0005!iD\u0003\u0011!A\u0001zf)\u0016(D?\"J\u0003%\f\u0011SKR,(O\\:![>tw\u000e^8oS\u000e\fG\u000e\\=!S:\u001c'/Z1tS:<\u0007E\u000e\u001b.E&$\b%\u001b8uK\u001e,'o\u001d\u0018!)\",\u0007eZ3oKJ\fG/\u001a3!\u0013\u0012\u0003\u0013n\u001d\u0011hk\u0006\u0014\u0018M\u001c;fK\u0012T\u0001\u0005\t\u0011!A\u0001\"x\u000e\t2fA5|gn\u001c;p]&\u001c\u0017\r\u001c7zA%t7M]3bg&tw\rI1oI\u0002*h.[9vK2\u0002#-\u001e;!]>$\beY8og\u0016\u001cW\u000f^5wK:\u0002C\u000b[3!GV\u0014(/\u001a8uA%l\u0007\u000f\\3nK:$\u0018\r^5p]*\u0001\u0003\u0005\t\u0011!AA,Ho\u001d\u0011uQ\u0016\u0004\u0003/\u0019:uSRLwN\u001c\u0011J\t\u0002Jg\u000e\t;iK\u0002*\b\u000f]3sAM\n\u0004EY5ug2\u0002\u0013M\u001c3!i\",\u0007\u0005\\8xKJ\u00043g\r\u0011cSR\u001c\bE]3qe\u0016\u001cXM\u001c;!i\",\u0007E]3d_J$\u0007E\\;nE\u0016\u0014(\u0002\t\u0011!A\u0001\u0002s/\u001b;iS:\u0004S-Y2iAA\f'\u000f^5uS>tg\u0006\t+iK\u0002\n7o];naRLwN\u001c\u0011jg\u0002\"\b.\u0019;!i\",\u0007\u0005Z1uC\u00022'/Y7fA!\f7\u000f\t7fgN\u0004C\u000f[1oAE\u0002#-\u001b7mS>t'\u0002\t\u0011!A\u0001\u0002\u0003/\u0019:uSRLwN\\:-A\u0005tG\rI3bG\"\u0004\u0003/\u0019:uSRLwN\u001c\u0011iCN\u0004C.Z:tAQD\u0017M\u001c\u00119A\tLG\u000e\\5p]\u0002\u0012XmY8sINt#\u0002\t\u0011!A\u0001\u0002C\u000b[3!MVt7\r^5p]\u0002J7\u000f\t8p]6\"W\r^3s[&t\u0017n\u001d;jG\u0002\u0012WmY1vg\u0016\u0004\u0013\u000e^:!e\u0016\u001cX\u000f\u001c;!I\u0016\u0004XM\u001c3tA=t\u0007\u0005]1si&$\u0018n\u001c8!\u0013\u0012\u001bhF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA-\u0003MR\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!a)\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002`\u0005)\u0011G\f\u001b/a\u0005)qM]8va\u0006\u0012\u0011QM\u0001\u000b[&\u001c8m\u00184v]\u000e\u001c\u0018!G'p]>$xN\\5dC2d\u00170\u00138de\u0016\f7/\u001b8h\u0013\u0012\u0003\"A\u000b\u000b\u0014\tQ\tiG\u000e\t\u0006\u0003_\n)hO\u0007\u0003\u0003cR1!a\u001d3\u0003\u001d\u0011XO\u001c;j[\u0016LA!a\u001e\u0002r\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u0019\u0015\u0005\u0005%\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005-\u0011!B1qa2L\u0018aB;oCB\u0004H.\u001f\u000b\u0004%\u0006\u0015\u0005\u0002CAD1\u0005\u0005\t\u0019A\u001e\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCAAG!\u0011\ti!a$\n\t\u0005E\u0015q\u0002\u0002\u0007\u001f\nTWm\u0019;")
public class MonotonicallyIncreasingID
extends LeafExpression
implements Stateful,
Serializable {
    private transient long count;
    private transient long partitionMask;
    private boolean deterministic;
    private transient boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    private volatile boolean bitmap$0;

    public static boolean unapply(MonotonicallyIncreasingID monotonicallyIncreasingID) {
        return MonotonicallyIncreasingID$.MODULE$.unapply(monotonicallyIncreasingID);
    }

    @Override
    public boolean fastEquals(TreeNode<?> other) {
        return Stateful.fastEquals$(this, other);
    }

    @Override
    public final boolean foldable() {
        return Nondeterministic.foldable$(this);
    }

    @Override
    public final void initialize(int partitionIndex) {
        Nondeterministic.initialize$(this, partitionIndex);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Nondeterministic.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Nondeterministic.eval$default$1$(this);
    }

    private boolean deterministic$lzycompute() {
        MonotonicallyIncreasingID monotonicallyIncreasingID = this;
        synchronized (monotonicallyIncreasingID) {
            if (!this.bitmap$0) {
                this.deterministic = Nondeterministic.deterministic$(this);
                this.bitmap$0 = true;
            }
        }
        return this.deterministic;
    }

    @Override
    public final boolean deterministic() {
        if (!this.bitmap$0) {
            return this.deterministic$lzycompute();
        }
        return this.deterministic;
    }

    @Override
    public boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized() {
        return this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized_$eq(boolean x$1) {
        this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized = x$1;
    }

    @Override
    public void initializeInternal(int partitionIndex) {
        this.count = 0L;
        this.partitionMask = (long)partitionIndex << 33;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    public long evalInternal(InternalRow input) {
        long currentCount = this.count++;
        return this.partitionMask + currentCount;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String countTerm = ctx.addMutableState("long", "count", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String partitionMaskTerm = "partitionMask";
        ctx.addImmutableStateIfNotExists("long", partitionMaskTerm, ctx.addImmutableStateIfNotExists$default$3());
        ctx.addPartitionInitializationStatement(new StringBuilder(6).append(countTerm).append(" = 0L;").toString());
        ctx.addPartitionInitializationStatement(new StringBuilder(33).append(partitionMaskTerm).append(" = ((long) partitionIndex) << 33;").toString());
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      final ", " ", " = ", " + ", ";\n      ", "++;"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), partitionMaskTerm, countTerm, countTerm})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public String nodeName() {
        return "monotonically_increasing_id";
    }

    @Override
    public String sql() {
        return new StringBuilder(2).append(this.prettyName()).append("()").toString();
    }

    @Override
    public MonotonicallyIncreasingID freshCopy() {
        return new MonotonicallyIncreasingID();
    }

    public MonotonicallyIncreasingID copy() {
        return new MonotonicallyIncreasingID();
    }

    @Override
    public String productPrefix() {
        return "MonotonicallyIncreasingID";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MonotonicallyIncreasingID;
    }

    public boolean equals(Object x$1) {
        Object object = x$1;
        return object instanceof MonotonicallyIncreasingID && ((MonotonicallyIncreasingID)x$1).canEqual(this);
    }

    public MonotonicallyIncreasingID() {
        Nondeterministic.$init$(this);
        Stateful.$init$(this);
    }
}

