/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.JsonObjectKeys$;
import org.apache.spark.sql.catalyst.expressions.SharedFactory$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(json_object) - Returns all the keys of the outermost JSON object as an array.", arguments="\n    Arguments:\n      * json_object - A JSON object. If a valid JSON object is given, all the keys of the outermost\n          object will be returned as an array. If it is any other valid JSON string, an invalid JSON\n          string or an empty string, the function returns null.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('{}');\n        []\n      > SELECT _FUNC_('{\"key\": \"value\"}');\n        [\"key\"]\n      > SELECT _FUNC_('{\"f1\":\"abc\",\"f2\":{\"f3\":\"a\", \"f4\":\"b\"}}');\n        [\"f1\",\"f2\"]\n  ", group="json_funcs", since="3.1.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\rh\u0001\u0002\u000e\u001c\u0001\"B\u0001b\u0010\u0001\u0003\u0016\u0004%\t\u0001\u0011\u0005\t\t\u0002\u0011\t\u0012)A\u0005\u0003\")Q\t\u0001C\u0001\r\")\u0011\n\u0001C!\u0015\")Q\f\u0001C!=\")q\f\u0001C!A\")A\r\u0001C!K\")a\u000e\u0001C!_\")\u0011\u0010\u0001C\u0005u\"9\u0011\u0011\u0005\u0001\u0005R\u0005\r\u0002\"CA\u0015\u0001\u0005\u0005I\u0011AA\u0016\u0011%\ty\u0003AI\u0001\n\u0003\t\t\u0004C\u0005\u0002H\u0001\t\t\u0011\"\u0011\u0002J!I\u0011\u0011\f\u0001\u0002\u0002\u0013\u0005\u00111\f\u0005\n\u0003G\u0002\u0011\u0011!C\u0001\u0003KB\u0011\"a\u001b\u0001\u0003\u0003%\t%!\u001c\t\u0013\u0005m\u0004!!A\u0005\u0002\u0005u\u0004\"CAA\u0001\u0005\u0005I\u0011IAB\u000f%\tikGA\u0001\u0012\u0003\tyK\u0002\u0005\u001b7\u0005\u0005\t\u0012AAY\u0011\u0019)E\u0003\"\u0001\u0002@\"I\u0011\u0011\u0019\u000b\u0002\u0002\u0013\u0015\u00131\u0019\u0005\n\u0003\u000b$\u0012\u0011!CA\u0003\u000fD\u0011\"a3\u0015\u0003\u0003%\t)!4\t\u0013\u0005eG#!A\u0005\n\u0005m'A\u0004&t_:|%M[3di.+\u0017p\u001d\u0006\u00039u\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011adH\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0001%I\u0001\u0004gFd'B\u0001\u0012$\u0003\u0015\u0019\b/\u0019:l\u0015\t!S%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002M\u0005\u0019qN]4\u0004\u0001M1\u0001!K\u00174mq\u0002\"AK\u0016\u000e\u0003mI!\u0001L\u000e\u0003\u001fUs\u0017M]=FqB\u0014Xm]:j_:\u0004\"AL\u0019\u000e\u0003=R!\u0001M\u000e\u0002\u000f\r|G-Z4f]&\u0011!g\f\u0002\u0010\u0007>$WmZ3o\r\u0006dGNY1dWB\u0011!\u0006N\u0005\u0003km\u0011\u0011#\u0012=qK\u000e$8/\u00138qkR$\u0016\u0010]3t!\t9$(D\u00019\u0015\u0005I\u0014!B:dC2\f\u0017BA\u001e9\u0005\u001d\u0001&o\u001c3vGR\u0004\"aN\u001f\n\u0005yB$\u0001D*fe&\fG.\u001b>bE2,\u0017!B2iS2$W#A!\u0011\u0005)\u0012\u0015BA\"\u001c\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0007G\"LG\u000e\u001a\u0011\u0002\rqJg.\u001b;?)\t9\u0005\n\u0005\u0002+\u0001!)qh\u0001a\u0001\u0003\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003-\u00032\u0001\u0014+X\u001d\ti%K\u0004\u0002O#6\tqJ\u0003\u0002QO\u00051AH]8pizJ\u0011!O\u0005\u0003'b\nq\u0001]1dW\u0006<W-\u0003\u0002V-\n\u00191+Z9\u000b\u0005MC\u0004C\u0001-\\\u001b\u0005I&B\u0001. \u0003\u0015!\u0018\u0010]3t\u0013\ta\u0016L\u0001\u0005ECR\fG+\u001f9f\u0003!!\u0017\r^1UsB,W#A,\u0002\u00119,H\u000e\\1cY\u0016,\u0012!\u0019\t\u0003o\tL!a\u0019\u001d\u0003\u000f\t{w\u000e\\3b]\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003\u0019\u0004\"aZ6\u000f\u0005!L\u0007C\u0001(9\u0013\tQ\u0007(\u0001\u0004Qe\u0016$WMZ\u0005\u0003Y6\u0014aa\u0015;sS:<'B\u000169\u0003\u0011)g/\u00197\u0015\u0005A\u001c\bCA\u001cr\u0013\t\u0011\bHA\u0002B]fDq\u0001\u001e\u0005\u0011\u0002\u0003\u0007Q/A\u0003j]B,H\u000f\u0005\u0002wo6\tQ$\u0003\u0002y;\tY\u0011J\u001c;fe:\fGNU8x\u0003-9W\r\u001e&t_:\\U-_:\u0015\u000bm\f\u0019!a\b\u0011\u0005q|X\"A?\u000b\u0005yl\u0012\u0001B;uS2L1!!\u0001~\u0005A9UM\\3sS\u000e\f%O]1z\t\u0006$\u0018\rC\u0004\u0002\u0006%\u0001\r!a\u0002\u0002\rA\f'o]3s!\u0011\tI!a\u0007\u000e\u0005\u0005-!\u0002BA\u0007\u0003\u001f\tAaY8sK*!\u0011\u0011CA\n\u0003\u001dQ\u0017mY6t_:TA!!\u0006\u0002\u0018\u0005Ia-Y:uKJDX\u000e\u001c\u0006\u0003\u00033\t1aY8n\u0013\u0011\ti\"a\u0003\u0003\u0015)\u001bxN\u001c)beN,'\u000fC\u0003u\u0013\u0001\u0007Q/\u0001\u000bxSRDg*Z<DQ&dG-\u00138uKJt\u0017\r\u001c\u000b\u0004\u000f\u0006\u0015\u0002BBA\u0014\u0015\u0001\u0007\u0011)\u0001\u0005oK^\u001c\u0005.\u001b7e\u0003\u0011\u0019w\u000e]=\u0015\u0007\u001d\u000bi\u0003C\u0004@\u0017A\u0005\t\u0019A!\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u0007\u0016\u0004\u0003\u0006U2FAA\u001c!\u0011\tI$a\u0011\u000e\u0005\u0005m\"\u0002BA\u001f\u0003\u007f\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0005\u0003(\u0001\u0006b]:|G/\u0019;j_:LA!!\u0012\u0002<\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tY\u0005\u0005\u0003\u0002N\u0005]SBAA(\u0015\u0011\t\t&a\u0015\u0002\t1\fgn\u001a\u0006\u0003\u0003+\nAA[1wC&\u0019A.a\u0014\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005u\u0003cA\u001c\u0002`%\u0019\u0011\u0011\r\u001d\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007A\f9\u0007C\u0005\u0002j=\t\t\u00111\u0001\u0002^\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u001c\u0011\u000b\u0005E\u0014q\u000f9\u000e\u0005\u0005M$bAA;q\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005e\u00141\u000f\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002b\u0003\u007fB\u0001\"!\u001b\u0012\u0003\u0003\u0005\r\u0001]\u0001\u0007KF,\u0018\r\\:\u0015\u0007\u0005\f)\t\u0003\u0005\u0002jI\t\t\u00111\u0001qQ]\u0001\u0011\u0011RAH\u0003#\u000b)*a&\u0002\u001c\u0006u\u0015\u0011UAR\u0003O\u000bI\u000bE\u0002+\u0003\u0017K1!!$\u001c\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a%\u0002)~3UKT\"`Q)\u001cxN\\0pE*,7\r^\u0015![\u0001\u0012V\r^;s]N\u0004\u0013\r\u001c7!i\",\u0007e[3zg\u0002zg\r\t;iK\u0002zW\u000f^3s[>\u001cH\u000f\t&T\u001f:\u0003sN\u00196fGR\u0004\u0013m\u001d\u0011b]\u0002\n'O]1z]\u0005I\u0011M]4v[\u0016tGo]\u0011\u0003\u00033\u000b!q\u0007\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+A)\u001cxN\\0pE*,7\r\u001e\u0011.A\u0005\u0003#jU(OA=\u0014'.Z2u]\u0001Je\rI1!m\u0006d\u0017\u000e\u001a\u0011K'>s\u0005e\u001c2kK\u000e$\b%[:!O&4XM\u001c\u0017!C2d\u0007\u0005\u001e5fA-,\u0017p\u001d\u0011pM\u0002\"\b.\u001a\u0011pkR,'/\\8ti*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I8cU\u0016\u001cG\u000fI<jY2\u0004#-\u001a\u0011sKR,(O\\3eA\u0005\u001c\b%\u00198!CJ\u0014\u0018-\u001f\u0018!\u0013\u001a\u0004\u0013\u000e\u001e\u0011jg\u0002\ng.\u001f\u0011pi\",'\u000f\t<bY&$\u0007ES*P\u001d\u0002\u001aHO]5oO2\u0002\u0013M\u001c\u0011j]Z\fG.\u001b3!\u0015N{eJ\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!AM$(/\u001b8hA=\u0014\b%\u00198!K6\u0004H/\u001f\u0011tiJLgn\u001a\u0017!i\",\u0007EZ;oGRLwN\u001c\u0011sKR,(O\\:!]VdGN\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002 \u0006\t\u0019J\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(wv<\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!7vS\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ>#W\u0016L(E\u000f\u0011#m\u0006dW/\u001a\u0012~O%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005I.#W\u0016L(%\u0018\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)Om\u0014c-\r\u0012;E\u0005\u00147M\t\u0017#MJ\u0012#h\u001f\u0012gg\tR$%\u0019\u0012-A\t2GG\t\u001e#E\njXpJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001Z&EZ\u0019#Y\t2'GI/\u000bA\u0001\nQa\u001a:pkB\f#!!*\u0002\u0015)\u001cxN\\0gk:\u001c7/A\u0003tS:\u001cW-\t\u0002\u0002,\u0006)1GL\u0019/a\u0005q!j]8o\u001f\nTWm\u0019;LKf\u001c\bC\u0001\u0016\u0015'\u0011!\u00121\u0017\u001f\u0011\r\u0005U\u00161X!H\u001b\t\t9LC\u0002\u0002:b\nqA];oi&lW-\u0003\u0003\u0002>\u0006]&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocQ\u0011\u0011qV\u0001\ti>\u001cFO]5oOR\u0011\u00111J\u0001\u0006CB\u0004H.\u001f\u000b\u0004\u000f\u0006%\u0007\"B \u0018\u0001\u0004\t\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003\u001f\f)\u000e\u0005\u00038\u0003#\f\u0015bAAjq\t1q\n\u001d;j_:D\u0001\"a6\u0019\u0003\u0003\u0005\raR\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!8\u0011\t\u00055\u0013q\\\u0005\u0005\u0003C\fyE\u0001\u0004PE*,7\r\u001e")
public class JsonObjectKeys
extends UnaryExpression
implements CodegenFallback,
ExpectsInputTypes,
scala.Serializable {
    private final Expression child;

    public static Option<Expression> unapply(JsonObjectKeys jsonObjectKeys) {
        return JsonObjectKeys$.MODULE$.unapply(jsonObjectKeys);
    }

    public static <A> Function1<Expression, A> andThen(Function1<JsonObjectKeys, A> function1) {
        return JsonObjectKeys$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, JsonObjectKeys> compose(Function1<A, Expression> function1) {
        return JsonObjectKeys$.MODULE$.compose(function1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)new .colon.colon((Object)StringType$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return ArrayType$.MODULE$.apply(StringType$.MODULE$);
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public String prettyName() {
        return "json_object_keys";
    }

    @Override
    public Object eval(InternalRow input) {
        Object object;
        block7: {
            Object object2 = new Object();
            try {
                UTF8String json = (UTF8String)this.child().eval(input);
                if (json == null) {
                    return null;
                }
                try {
                    object = Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> CreateJacksonParser$.MODULE$.utf8String(SharedFactory$.MODULE$.jsonFactory(), json), (Function1 & Serializable & scala.Serializable)parser -> {
                        block3: {
                            block2: {
                                if (parser.nextToken() == null) break block2;
                                JsonToken jsonToken = parser.currentToken();
                                JsonToken jsonToken2 = JsonToken.START_OBJECT;
                                if (!(jsonToken == null ? jsonToken2 != null : !jsonToken.equals(jsonToken2))) break block3;
                            }
                            throw new NonLocalReturnControl(object2, null);
                        }
                        return this.getJsonKeys((JsonParser)parser, input);
                    });
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof JsonProcessingException ? true : throwable2 instanceof IOException) {
                        object = null;
                        break block7;
                    }
                    throw throwable;
                }
            }
            catch (NonLocalReturnControl ex) {
                if (ex.key() == object2) {
                    object = ex.value();
                }
                throw ex;
            }
        }
        return object;
    }

    private GenericArrayData getJsonKeys(JsonParser parser, InternalRow input) {
        ArrayBuffer arrayBufferOfKeys = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        while (parser.nextValue() != null && parser.currentName() != null) {
            arrayBufferOfKeys.$plus$eq((Object)UTF8String.fromString((String)parser.getCurrentName()));
            parser.skipChildren();
        }
        return new GenericArrayData(arrayBufferOfKeys.toArray(ClassTag$.MODULE$.apply(UTF8String.class)));
    }

    @Override
    public JsonObjectKeys withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public JsonObjectKeys copy(Expression child) {
        return new JsonObjectKeys(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "JsonObjectKeys";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof JsonObjectKeys;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof JsonObjectKeys)) return false;
        boolean bl = true;
        if (!bl) return false;
        JsonObjectKeys jsonObjectKeys = (JsonObjectKeys)x$1;
        Expression expression = this.child();
        Expression expression2 = jsonObjectKeys.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!jsonObjectKeys.canEqual(this)) return false;
        return true;
    }

    public JsonObjectKeys(Expression child) {
        this.child = child;
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
    }
}

