/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.CatalystTypeConverters;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$BooleanConverter$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$ByteConverter$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$DateConverter$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$DoubleConverter$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$FloatConverter$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$InstantConverter$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$IntConverter$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$LocalDateConverter$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$LongConverter$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$ShortConverter$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$StringConverter$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$TimestampConverter$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$TimestampNTZConverter$;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.math.BigDecimal;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public final class CatalystTypeConverters$ {
    public static CatalystTypeConverters$ MODULE$;

    static {
        new CatalystTypeConverters$();
    }

    public boolean isPrimitive(DataType dataType) {
        DataType dataType2 = dataType;
        if (BooleanType$.MODULE$.equals(dataType2)) {
            return true;
        }
        if (ByteType$.MODULE$.equals(dataType2)) {
            return true;
        }
        if (ShortType$.MODULE$.equals(dataType2)) {
            return true;
        }
        if (IntegerType$.MODULE$.equals(dataType2)) {
            return true;
        }
        if (LongType$.MODULE$.equals(dataType2)) {
            return true;
        }
        if (FloatType$.MODULE$.equals(dataType2)) {
            return true;
        }
        return DoubleType$.MODULE$.equals(dataType2);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public CatalystTypeConverters.CatalystTypeConverter<Object, Object, Object> org$apache$spark$sql$catalyst$CatalystTypeConverters$$getConverterForType(DataType dataType) {
        block29: {
            block35: {
                block34: {
                    block33: {
                        block32: {
                            block31: {
                                block30: {
                                    block28: {
                                        var4_2 = false;
                                        var5_3 = null;
                                        var6_4 = false;
                                        var7_5 = null;
                                        var8_6 = dataType;
                                        if (!(var8_6 instanceof UserDefinedType)) break block28;
                                        var9_7 = (UserDefinedType)var8_6;
                                        v0 /* !! */  = new CatalystTypeConverters.UDTConverter<Object>(var9_7);
                                        break block29;
                                    }
                                    if (!(var8_6 instanceof ArrayType)) break block30;
                                    var10_8 = (ArrayType)var8_6;
                                    v0 /* !! */  = new CatalystTypeConverters.ArrayConverter(var10_8.elementType());
                                    break block29;
                                }
                                if (!(var8_6 instanceof MapType)) break block31;
                                var11_9 = (MapType)var8_6;
                                v0 /* !! */  = new CatalystTypeConverters.MapConverter(var11_9.keyType(), var11_9.valueType());
                                break block29;
                            }
                            if (!(var8_6 instanceof StructType)) break block32;
                            var12_10 = (StructType)var8_6;
                            v0 /* !! */  = new CatalystTypeConverters.StructConverter(var12_10);
                            break block29;
                        }
                        if (!StringType$.MODULE$.equals(var8_6)) break block33;
                        v0 /* !! */  = CatalystTypeConverters$StringConverter$.MODULE$;
                        break block29;
                    }
                    if (!DateType$.MODULE$.equals(var8_6)) break block34;
                    var4_2 = true;
                    var5_3 = var8_6;
                    if (!SQLConf$.MODULE$.get().datetimeJava8ApiEnabled()) break block34;
                    v0 /* !! */  = CatalystTypeConverters$LocalDateConverter$.MODULE$;
                    break block29;
                }
                if (!var4_2) break block35;
                v0 /* !! */  = CatalystTypeConverters$DateConverter$.MODULE$;
                break block29;
            }
            if (!TimestampType$.MODULE$.equals(var8_6)) ** GOTO lbl-1000
            var6_4 = true;
            var7_5 = var8_6;
            if (SQLConf$.MODULE$.get().datetimeJava8ApiEnabled()) {
                v0 /* !! */  = CatalystTypeConverters$InstantConverter$.MODULE$;
            } else if (var6_4) {
                v0 /* !! */  = CatalystTypeConverters$TimestampConverter$.MODULE$;
            } else if (TimestampNTZType$.MODULE$.equals(var8_6)) {
                v0 /* !! */  = CatalystTypeConverters$TimestampNTZConverter$.MODULE$;
            } else if (var8_6 instanceof DecimalType) {
                var13_11 = (DecimalType)var8_6;
                v0 /* !! */  = new CatalystTypeConverters.DecimalConverter(var13_11);
            } else if (BooleanType$.MODULE$.equals(var8_6)) {
                v0 /* !! */  = CatalystTypeConverters$BooleanConverter$.MODULE$;
            } else if (ByteType$.MODULE$.equals(var8_6)) {
                v0 /* !! */  = CatalystTypeConverters$ByteConverter$.MODULE$;
            } else if (ShortType$.MODULE$.equals(var8_6)) {
                v0 /* !! */  = CatalystTypeConverters$ShortConverter$.MODULE$;
            } else if (IntegerType$.MODULE$.equals(var8_6)) {
                v0 /* !! */  = CatalystTypeConverters$IntConverter$.MODULE$;
            } else if (LongType$.MODULE$.equals(var8_6)) {
                v0 /* !! */  = CatalystTypeConverters$LongConverter$.MODULE$;
            } else if (FloatType$.MODULE$.equals(var8_6)) {
                v0 /* !! */  = CatalystTypeConverters$FloatConverter$.MODULE$;
            } else if (DoubleType$.MODULE$.equals(var8_6)) {
                v0 /* !! */  = CatalystTypeConverters$DoubleConverter$.MODULE$;
            } else if (var8_6 instanceof DayTimeIntervalType) {
                var14_12 = (DayTimeIntervalType)var8_6;
                endField = var14_12.endField();
                v0 /* !! */  = new CatalystTypeConverters.DurationConverter(endField);
            } else if (var8_6 instanceof YearMonthIntervalType) {
                var16_14 = (YearMonthIntervalType)var8_6;
                endField = var16_14.endField();
                v0 /* !! */  = new CatalystTypeConverters.PeriodConverter(endField);
            } else if (var8_6 != null) {
                var18_16 = var8_6;
                v0 /* !! */  = new CatalystTypeConverters.IdentityConverter(var18_16);
            } else {
                throw new MatchError((Object)var8_6);
            }
        }
        converter = v0 /* !! */ ;
        return converter;
    }

    public Function1<Object, Object> createToCatalystConverter(DataType dataType) {
        if (this.isPrimitive(dataType)) {
            return (Function1 & Serializable & scala.Serializable)maybeScalaValue -> CatalystTypeConverters$.convert$1(maybeScalaValue);
        }
        CatalystTypeConverters.CatalystTypeConverter<Object, Object, Object> catalystTypeConverter = this.org$apache$spark$sql$catalyst$CatalystTypeConverters$$getConverterForType(dataType);
        return (Function1 & Serializable & scala.Serializable)maybeScalaValue -> catalystTypeConverter.toCatalyst(maybeScalaValue);
    }

    public Function1<Object, Object> createToScalaConverter(DataType dataType) {
        if (this.isPrimitive(dataType)) {
            return (Function1 & Serializable & scala.Serializable)x -> Predef$.MODULE$.identity(x);
        }
        CatalystTypeConverters.CatalystTypeConverter<Object, Object, Object> catalystTypeConverter = this.org$apache$spark$sql$catalyst$CatalystTypeConverters$$getConverterForType(dataType);
        return (Function1 & Serializable & scala.Serializable)catalystValue -> catalystTypeConverter.toScala(catalystValue);
    }

    public Object convertToCatalyst(Object a2) {
        Object object = a2;
        if (object instanceof String) {
            String string = (String)object;
            return CatalystTypeConverters$StringConverter$.MODULE$.toCatalyst(string);
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return CatalystTypeConverters$DateConverter$.MODULE$.toCatalyst(date);
        }
        if (object instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object;
            return CatalystTypeConverters$LocalDateConverter$.MODULE$.toCatalyst(localDate);
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            return CatalystTypeConverters$TimestampConverter$.MODULE$.toCatalyst(timestamp);
        }
        if (object instanceof Instant) {
            Instant instant = (Instant)object;
            return CatalystTypeConverters$InstantConverter$.MODULE$.toCatalyst(instant);
        }
        if (object instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object;
            if (Utils$.MODULE$.isTesting()) {
                return CatalystTypeConverters$TimestampNTZConverter$.MODULE$.toCatalyst(localDateTime);
            }
        }
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            return new CatalystTypeConverters.DecimalConverter(new DecimalType(bigDecimal.precision(), bigDecimal.scale())).toCatalyst(bigDecimal);
        }
        if (object instanceof java.math.BigDecimal) {
            java.math.BigDecimal bigDecimal = (java.math.BigDecimal)object;
            return new CatalystTypeConverters.DecimalConverter(new DecimalType(bigDecimal.precision(), bigDecimal.scale())).toCatalyst(bigDecimal);
        }
        if (object instanceof Seq) {
            Seq seq = (Seq)object;
            return new GenericArrayData((Object[])((TraversableOnce)seq.map((Function1 & Serializable & scala.Serializable)a -> MODULE$.convertToCatalyst(a), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Any()));
        }
        if (object instanceof Row) {
            Row row = (Row)object;
            return InternalRow$.MODULE$.apply((Seq<Object>)((Seq)row.toSeq().map((Function1 & Serializable & scala.Serializable)a -> MODULE$.convertToCatalyst(a), Seq$.MODULE$.canBuildFrom())));
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            return byArray;
        }
        if (object instanceof char[]) {
            char[] cArray = (char[])object;
            return CatalystTypeConverters$StringConverter$.MODULE$.toCatalyst(cArray);
        }
        if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
            Object object2 = object;
            return new GenericArrayData((Object[])Predef$.MODULE$.genericArrayOps(object2).map((Function1 & Serializable & scala.Serializable)a -> MODULE$.convertToCatalyst(a), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any())));
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return ArrayBasedMapData$.MODULE$.apply(map, (Function1<Object, Object>)(Function1 & Serializable & scala.Serializable)key -> MODULE$.convertToCatalyst(key), (Function1<Object, Object>)(Function1 & Serializable & scala.Serializable)value -> MODULE$.convertToCatalyst(value));
        }
        if (object instanceof Duration) {
            Duration duration = (Duration)object;
            return new CatalystTypeConverters.DurationConverter(DayTimeIntervalType$.MODULE$.SECOND()).toCatalyst(duration);
        }
        if (object instanceof Period) {
            Period period = (Period)object;
            return new CatalystTypeConverters.PeriodConverter(YearMonthIntervalType$.MODULE$.MONTH()).toCatalyst(period);
        }
        return object;
    }

    public Object convertToScala(Object catalystValue, DataType dataType) {
        return this.createToScalaConverter(dataType).apply(catalystValue);
    }

    private static final Object convert$1(Object maybeScalaValue) {
        Object object = maybeScalaValue;
        if (object instanceof Option) {
            Option option = (Option)object;
            return option.orNull(Predef$.MODULE$.$conforms());
        }
        return maybeScalaValue;
    }

    private CatalystTypeConverters$() {
        MODULE$ = this;
    }
}

