/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.util;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.analysis.package$;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.util.SchemaUtils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001q2Aa\u0001\u0003\u0001\u001f!)A\u0003\u0001C\u0001+!)\u0001\u0004\u0001C\u00053\t\u00012k\u00195f[\u0006,F/\u001b7t'VLG/\u001a\u0006\u0003\u000b\u0019\tA!\u001e;jY*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0003#Ii\u0011\u0001C\u0005\u0003'!\u0011Qb\u00159be.4UO\\*vSR,\u0017A\u0002\u001fj]&$h\bF\u0001\u0017!\t9\u0002!D\u0001\u0005\u0003!\u0011Xm]8mm\u0016\u0014HC\u0001\u000e5!\tY\u0012G\u0004\u0002\u001d]9\u0011Qd\u000b\b\u0003=%r!a\b\u0015\u000f\u0005\u0001:cBA\u0011'\u001d\t\u0011S%D\u0001$\u0015\t!c\"\u0001\u0004=e>|GOP\u0005\u0002\u001b%\u00111\u0002D\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005)2\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\u00051j\u0013\u0001C1oC2L8/[:\u000b\u0005)2\u0011BA\u00181\u0003\u001d\u0001\u0018mY6bO\u0016T!\u0001L\u0017\n\u0005I\u001a$\u0001\u0003*fg>dg/\u001a:\u000b\u0005=\u0002\u0004\"B\u001b\u0003\u0001\u00041\u0014!F2bg\u0016\u001cVM\\:ji&4X-\u00118bYf\u001c\u0018n\u001d\t\u0003oij\u0011\u0001\u000f\u0006\u0002s\u0005)1oY1mC&\u00111\b\u000f\u0002\b\u0005>|G.Z1o\u0001")
public class SchemaUtilsSuite
extends SparkFunSuite {
    private Function2<String, String, Object> resolver(boolean caseSensitiveAnalysis) {
        if (caseSensitiveAnalysis) {
            return package$.MODULE$.caseSensitiveResolution();
        }
        return package$.MODULE$.caseInsensitiveResolution();
    }

    private final void checkExceptionCases$1(String schemaStr, Seq duplicatedColumns, boolean caseSensitive$1) {
        String msg;
        String expectedErrorMsg = new StringBuilder(47).append("Found duplicate column(s) in SchemaUtilsSuite: ").append(((TraversableOnce)((TraversableLike)duplicatedColumns.sorted((Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(2).append("`").append(c.toLowerCase(Locale.ROOT)).append("`").toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).toString();
        StructType schema = StructType$.MODULE$.fromDDL(schemaStr);
        String $org_scalatest_assert_macro_left = msg = ((AnalysisException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> SchemaUtils$.MODULE$.checkSchemaColumnNameDuplication((DataType)schema, "in SchemaUtilsSuite", caseSensitive$1), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("SchemaUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46))).getMessage();
        String $org_scalatest_assert_macro_right = expectedErrorMsg;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SchemaUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        String $org_scalatest_assert_macro_left2 = msg = ((AnalysisException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> SchemaUtils$.MODULE$.checkColumnNameDuplication((Seq)schema.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Seq$.MODULE$.canBuildFrom()), "in SchemaUtilsSuite", this.resolver(caseSensitive$1)), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("SchemaUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51))).getMessage();
        String $org_scalatest_assert_macro_right2 = expectedErrorMsg;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SchemaUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        String $org_scalatest_assert_macro_left3 = msg = ((AnalysisException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> SchemaUtils$.MODULE$.checkColumnNameDuplication((Seq)schema.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name(), Seq$.MODULE$.canBuildFrom()), "in SchemaUtilsSuite", caseSensitive$1), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("SchemaUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56))).getMessage();
        String $org_scalatest_assert_macro_right3 = expectedErrorMsg;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SchemaUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
    }

    public static final /* synthetic */ void $anonfun$new$1(SchemaUtilsSuite $this, Tuple3 x0$1) {
        Tuple3 tuple3 = x0$1;
        if (tuple3 != null) {
            boolean caseSensitive = BoxesRunTime.unboxToBoolean((Object)tuple3._1());
            Tuple2 tuple2 = (Tuple2)tuple3._2();
            Tuple2 tuple22 = (Tuple2)tuple3._3();
            if (tuple2 != null) {
                String a0 = (String)tuple2._1();
                String a1 = (String)tuple2._2();
                if (tuple22 != null) {
                    String b0 = (String)tuple22._1();
                    String b1 = (String)tuple22._2();
                    String testType = caseSensitive ? "case-sensitive" : "case-insensitive";
                    $this.test(new StringBuilder(39).append("Check column name duplication in ").append(testType).append(" cases").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        String string = a0;
                        $this.checkExceptionCases$1(new StringBuilder(17).append(a0).append(" INT, b INT, ").append(a1).append(" INT").toString(), (Seq)Nil$.MODULE$.$colon$colon((Object)string), caseSensitive);
                        String string2 = a0;
                        $this.checkExceptionCases$1(new StringBuilder(23).append(a0).append(" INT, b INT, ").append(a1).append(" INT, ").append(a0).append(" INT").toString(), (Seq)Nil$.MODULE$.$colon$colon((Object)string2), caseSensitive);
                        String string3 = b0;
                        String string4 = a0;
                        $this.checkExceptionCases$1(new StringBuilder(28).append(a0).append(" INT, ").append(b0).append(" INT, ").append(a1).append(" INT, ").append(a0).append(" INT, ").append(b1).append(" INT").toString(), (Seq)Nil$.MODULE$.$colon$colon((Object)string4).$colon$colon((Object)string3), caseSensitive);
                    }, new Position("SchemaUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
                    return;
                }
            }
        }
        throw new MatchError((Object)tuple3);
    }

    private final void checkNoExceptionCases$1(String schemaStr, boolean caseSensitive) {
        StructType schema = StructType$.MODULE$.fromDDL(schemaStr);
        SchemaUtils$.MODULE$.checkSchemaColumnNameDuplication((DataType)schema, "in SchemaUtilsSuite", caseSensitive);
        SchemaUtils$.MODULE$.checkColumnNameDuplication((Seq)schema.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.name(), Seq$.MODULE$.canBuildFrom()), "in SchemaUtilsSuite", this.resolver(caseSensitive));
        SchemaUtils$.MODULE$.checkColumnNameDuplication((Seq)schema.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.name(), Seq$.MODULE$.canBuildFrom()), "in SchemaUtilsSuite", caseSensitive);
    }

    public SchemaUtilsSuite() {
        ((IterableLike)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)new Tuple2((Object)"a", (Object)"a"), (Object)new Tuple2((Object)"b", (Object)"b")), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new Tuple2((Object)"a", (Object)"A"), (Object)new Tuple2((Object)"b", (Object)"B")), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SchemaUtilsSuite.$anonfun$new$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
        this.test("Check no exception thrown for valid schemas", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkNoExceptionCases$1("a INT, b INT, c INT", true);
            this.checkNoExceptionCases$1("Aa INT, b INT, aA INT", true);
            this.checkNoExceptionCases$1("a INT, b INT, c INT", false);
        }, new Position("SchemaUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        this.test("SPARK-32431: duplicated fields in nested schemas", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            StructType schemaA = new StructType().add("LowerCase", (DataType)LongType$.MODULE$).add("camelcase", (DataType)LongType$.MODULE$).add("CamelCase", (DataType)LongType$.MODULE$);
            StructType schemaB = new StructType().add("f1", (DataType)LongType$.MODULE$).add("StructColumn1", (DataType)schemaA);
            StructType schemaC = new StructType().add("f2", (DataType)LongType$.MODULE$).add("StructColumn2", (DataType)schemaB);
            StructType schemaD = new StructType().add("f3", (DataType)ArrayType$.MODULE$.apply((DataType)schemaC));
            MapType schemaE = MapType$.MODULE$.apply((DataType)LongType$.MODULE$, (DataType)schemaD);
            MapType schemaF = MapType$.MODULE$.apply((DataType)schemaD, (DataType)LongType$.MODULE$);
            ((IterableLike)new .colon.colon((Object)schemaA, (List)new .colon.colon((Object)schemaB, (List)new .colon.colon((Object)schemaC, (List)new .colon.colon((Object)schemaD, (List)new .colon.colon((Object)schemaE, (List)new .colon.colon((Object)schemaF, (List)Nil$.MODULE$))))))).foreach((Function1 & Serializable & scala.Serializable)schema -> {
                String msg;
                String $org_scalatest_assert_macro_left = msg = ((AnalysisException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> SchemaUtils$.MODULE$.checkSchemaColumnNameDuplication(schema, "in SchemaUtilsSuite", false), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("SchemaUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102))).getMessage();
                String $org_scalatest_assert_macro_right = "Found duplicate column(s) in SchemaUtilsSuite: `camelcase`";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SchemaUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
            });
        }, new Position("SchemaUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
    }
}

