/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.parser;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.time.ZoneId;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.SQLKeywordUtils;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.internal.SQLConf$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001m2AAB\u0004\u0001)!)Q\u0004\u0001C\u0001=!9\u0011\u0005\u0001b\u0001\n\u0003\u0011\u0003BB\u0019\u0001A\u0003%1\u0005C\u00043\u0001\t\u0007I\u0011A\u001a\t\ri\u0002\u0001\u0015!\u00035\u0005i!\u0016M\u00197f\u0013\u0012,g\u000e^5gS\u0016\u0014\b+\u0019:tKJ\u001cV/\u001b;f\u0015\tA\u0011\"\u0001\u0004qCJ\u001cXM\u001d\u0006\u0003\u0015-\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u00195\t1a]9m\u0015\tqq\"A\u0003ta\u0006\u00148N\u0003\u0002\u0011#\u00051\u0011\r]1dQ\u0016T\u0011AE\u0001\u0004_J<7\u0001A\n\u0004\u0001UI\u0002C\u0001\f\u0018\u001b\u0005i\u0011B\u0001\r\u000e\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011!dG\u0007\u0002\u0013%\u0011A$\u0003\u0002\u0010'Fc5*Z=x_J$W\u000b^5mg\u00061A(\u001b8jiz\"\u0012a\b\t\u0003A\u0001i\u0011aB\u0001\u0017Q&4XMT8o%\u0016\u001cXM\u001d<fI.+\u0017p^8sIV\t1\u0005E\u0002%O%j\u0011!\n\u0006\u0002M\u0005)1oY1mC&\u0011\u0001&\n\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003U=j\u0011a\u000b\u0006\u0003Y5\nA\u0001\\1oO*\ta&\u0001\u0003kCZ\f\u0017B\u0001\u0019,\u0005\u0019\u0019FO]5oO\u00069\u0002.\u001b<f\u001d>t'+Z:feZ,GmS3zo>\u0014H\rI\u0001\u001dQ&4Xm\u0015;sS\u000e$hj\u001c8SKN,'O^3e\u0017\u0016Lxo\u001c:e+\u0005!\u0004cA\u001b9S5\taG\u0003\u00028K\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005e2$aA*fc\u0006i\u0002.\u001b<f'R\u0014\u0018n\u0019;O_:\u0014Vm]3sm\u0016$7*Z=x_J$\u0007\u0005")
public class TableIdentifierParserSuite
extends SparkFunSuite
implements SQLKeywordUtils {
    private final String[] hiveNonReservedKeyword;
    private final Seq<String> hiveStrictNonReservedKeyword;
    private final String[] sqlSyntaxDefs;
    private final String[][] keywordsInDoc;
    private final Map<String, Seq<String>> symbolsToExpandIntoDifferentLiterals;
    private final Set<String> allCandidateKeywords;
    private final Set<String> nonReservedKeywordsInAnsiMode;
    private final Set<String> reservedKeywordsInAnsiMode;
    private final Set<String> nonReservedKeywordsInDefaultMode;
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public /* synthetic */ Path org$apache$spark$sql$catalyst$SQLKeywordUtils$$super$getWorkspaceFilePath(String first, Seq more) {
        return super.getWorkspaceFilePath(first, more);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    @Override
    public String[] sqlSyntaxDefs() {
        return this.sqlSyntaxDefs;
    }

    @Override
    public String[][] keywordsInDoc() {
        return this.keywordsInDoc;
    }

    @Override
    public Map<String, Seq<String>> symbolsToExpandIntoDifferentLiterals() {
        return this.symbolsToExpandIntoDifferentLiterals;
    }

    @Override
    public Set<String> allCandidateKeywords() {
        return this.allCandidateKeywords;
    }

    @Override
    public Set<String> nonReservedKeywordsInAnsiMode() {
        return this.nonReservedKeywordsInAnsiMode;
    }

    @Override
    public Set<String> reservedKeywordsInAnsiMode() {
        return this.reservedKeywordsInAnsiMode;
    }

    @Override
    public Set<String> nonReservedKeywordsInDefaultMode() {
        return this.nonReservedKeywordsInDefaultMode;
    }

    @Override
    public void org$apache$spark$sql$catalyst$SQLKeywordUtils$_setter_$sqlSyntaxDefs_$eq(String[] x$1) {
        this.sqlSyntaxDefs = x$1;
    }

    @Override
    public void org$apache$spark$sql$catalyst$SQLKeywordUtils$_setter_$keywordsInDoc_$eq(String[][] x$1) {
        this.keywordsInDoc = x$1;
    }

    @Override
    public void org$apache$spark$sql$catalyst$SQLKeywordUtils$_setter_$symbolsToExpandIntoDifferentLiterals_$eq(Map<String, Seq<String>> x$1) {
        this.symbolsToExpandIntoDifferentLiterals = x$1;
    }

    @Override
    public void org$apache$spark$sql$catalyst$SQLKeywordUtils$_setter_$allCandidateKeywords_$eq(Set<String> x$1) {
        this.allCandidateKeywords = x$1;
    }

    @Override
    public void org$apache$spark$sql$catalyst$SQLKeywordUtils$_setter_$nonReservedKeywordsInAnsiMode_$eq(Set<String> x$1) {
        this.nonReservedKeywordsInAnsiMode = x$1;
    }

    @Override
    public void org$apache$spark$sql$catalyst$SQLKeywordUtils$_setter_$reservedKeywordsInAnsiMode_$eq(Set<String> x$1) {
        this.reservedKeywordsInAnsiMode = x$1;
    }

    @Override
    public void org$apache$spark$sql$catalyst$SQLKeywordUtils$_setter_$nonReservedKeywordsInDefaultMode_$eq(Set<String> x$1) {
        this.nonReservedKeywordsInDefaultMode = x$1;
    }

    private String sparkHome$lzycompute() {
        TableIdentifierParserSuite tableIdentifierParserSuite = this;
        synchronized (tableIdentifierParserSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    public String[] hiveNonReservedKeyword() {
        return this.hiveNonReservedKeyword;
    }

    public Seq<String> hiveStrictNonReservedKeyword() {
        return this.hiveStrictNonReservedKeyword;
    }

    public TableIdentifierParserSuite() {
        SQLHelper.$init$(this);
        SQLKeywordUtils.$init$(this);
        this.hiveNonReservedKeyword = (String[])((Object[])new String[]{"add", "admin", "after", "all", "alter", "analyze", "any", "archive", "array", "as", "asc", "at", "authorization", "autocommit", "before", "between", "bigint", "binary", "boolean", "both", "bucket", "buckets", "by", "cascade", "change", "cluster", "clustered", "clusterstatus", "collection", "columns", "comment", "compact", "compactions", "compute", "concatenate", "continue", "cost", "create", "cube", "current_date", "current_timestamp", "cursor", "data", "databases", "date", "datetime", "day", "dbproperties", "decimal", "deferred", "defined", "delete", "delimited", "dependency", "desc", "describe", "directories", "directory", "disable", "distribute", "double", "drop", "enable", "escaped", "exclusive", "exists", "explain", "export", "external", "extract", "false", "fetch", "fields", "file", "fileformat", "first", "float", "for", "format", "formatted", "functions", "grant", "group", "grouping", "hold_ddltime", "hour", "idxproperties", "ignore", "import", "in", "index", "indexes", "inpath", "inputdriver", "inputformat", "insert", "int", "into", "is", "isolation", "items", "jar", "key_type", "keys", "last", "lateral", "leading", "level", "like", "limit", "lines", "load", "local", "location", "lock", "locks", "logical", "long", "mapjoin", "materialized", "metadata", "minus", "minute", "month", "msck", "no_drop", "none", "noscan", "null", "nulls", "of", "offline", "offset", "option", "order", "out", "outer", "outputdriver", "outputformat", "overwrite", "owner", "partition", "partitioned", "partitions", "percent", "pivot", "plus", "position", "pretty", "principals", "procedure", "protection", "purge", "query", "range", "read", "readonly", "reads", "rebuild", "recordreader", "recordwriter", "regexp", "reload", "rename", "repair", "replace", "replication", "restrict", "revoke", "rewrite", "rlike", "role", "roles", "rollup", "row", "rows", "schemas", "second", "serde", "serdeproperties", "server", "set", "sets", "shared", "show", "show_database", "skewed", "smallint", "snapshot", "sort", "sorted", "ssl", "statistics", "stored", "streamtable", "string", "struct", "table", "tables", "tblproperties", "temporary", "terminated", "timestamp", "tinyint", "to", "touch", "trailing", "transaction", "transactions", "trigger", "trim", "true", "truncate", "unarchive", "undo", "uniontype", "unlock", "unset", "unsigned", "update", "uri", "use", "user", "utc", "utctimestamp", "values", "view", "views", "while", "with", "work", "write", "year"});
        this.hiveStrictNonReservedKeyword = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"anti", "cross", "database", "except", "from", "full", "having", "inner", "intersect", "join", "left", "natural", "not", "on", "right", "select", "semi", "table", "to", "union", "where", "with"}));
        this.test("table identifier", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(TableIdentifier$.MODULE$.apply("q"));
            TableIdentifier $org_scalatest_assert_macro_right = CatalystSqlParser$.MODULE$.parseTableIdentifier("q");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new TableIdentifier("q", Option$.MODULE$.apply((Object)"d")));
            TableIdentifier $org_scalatest_assert_macro_right2 = CatalystSqlParser$.MODULE$.parseTableIdentifier("d.q");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 290));
            ((IterableLike)new .colon.colon((Object)"", (List)new .colon.colon((Object)"d.q.g", (List)new .colon.colon((Object)"t:", (List)new .colon.colon((Object)"${some.var.x}", (List)new .colon.colon((Object)"tab:1", (List)Nil$.MODULE$)))))).foreach((Function1 & Serializable & scala.Serializable)identifier -> (ParseException)this.intercept((Function0 & Serializable & scala.Serializable)() -> CatalystSqlParser$.MODULE$.parseTableIdentifier(identifier), ClassTag$.MODULE$.apply(ParseException.class), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294)));
        }, new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 287));
        this.test("quoted identifiers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new TableIdentifier("z", (Option)new Some((Object)"x.y")));
            TableIdentifier $org_scalatest_assert_macro_right = CatalystSqlParser$.MODULE$.parseTableIdentifier("`x.y`.z");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new TableIdentifier("y.z", (Option)new Some((Object)"x")));
            TableIdentifier $org_scalatest_assert_macro_right2 = CatalystSqlParser$.MODULE$.parseTableIdentifier("x.`y.z`");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 300));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new TableIdentifier("z", (Option)new Some((Object)"`x.y`")));
            TableIdentifier $org_scalatest_assert_macro_right3 = CatalystSqlParser$.MODULE$.parseTableIdentifier("```x.y```.z");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 301));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(new TableIdentifier("`y.z`", (Option)new Some((Object)"x")));
            TableIdentifier $org_scalatest_assert_macro_right4 = CatalystSqlParser$.MODULE$.parseTableIdentifier("x.```y.z```");
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 302));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(new TableIdentifier("x.y.z", (Option)None$.MODULE$));
            TableIdentifier $org_scalatest_assert_macro_right5 = CatalystSqlParser$.MODULE$.parseTableIdentifier("`x.y.z`");
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 303));
        }, new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 298));
        this.test("table identifier - reserved/non-reserved keywords if ANSI mode enabled", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ANSI_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENFORCE_RESERVED_KEYWORDS().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.reservedKeywordsInAnsiMode().foreach((Function1 & Serializable & scala.Serializable)keyword -> {
                    String errMsg;
                    String $org_scalatest_assert_macro_left = errMsg = ((ParseException)this.intercept((Function0 & Serializable & scala.Serializable)() -> CatalystSqlParser$.MODULE$.parseTableIdentifier(keyword), ClassTag$.MODULE$.apply(ParseException.class), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310))).getMessage();
                    String $org_scalatest_assert_macro_right = "Syntax error at or near";
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 313));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(TableIdentifier$.MODULE$.apply(keyword));
                    TableIdentifier $org_scalatest_assert_macro_right2 = CatalystSqlParser$.MODULE$.parseTableIdentifier(new StringBuilder(2).append("`").append((String)keyword).append("`").toString());
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new TableIdentifier(keyword, Option$.MODULE$.apply((Object)"db")));
                    TableIdentifier $org_scalatest_assert_macro_right3 = CatalystSqlParser$.MODULE$.parseTableIdentifier(new StringBuilder(5).append("db.`").append((String)keyword).append("`").toString());
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 315));
                });
                this.nonReservedKeywordsInAnsiMode().foreach((Function1 & Serializable & scala.Serializable)keyword -> {
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(TableIdentifier$.MODULE$.apply(keyword));
                    TableIdentifier $org_scalatest_assert_macro_right = CatalystSqlParser$.MODULE$.parseTableIdentifier(String.valueOf(keyword));
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new TableIdentifier(keyword, Option$.MODULE$.apply((Object)"db")));
                    TableIdentifier $org_scalatest_assert_macro_right2 = CatalystSqlParser$.MODULE$.parseTableIdentifier(new StringBuilder(3).append("db.").append((String)keyword).toString());
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 319));
                });
            });
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ANSI_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ENFORCE_RESERVED_KEYWORDS().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.reservedKeywordsInAnsiMode().foreach((Function1 & Serializable & scala.Serializable)keyword -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(TableIdentifier$.MODULE$.apply(keyword));
                TableIdentifier $org_scalatest_assert_macro_right = CatalystSqlParser$.MODULE$.parseTableIdentifier(String.valueOf(keyword));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 327));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new TableIdentifier(keyword, Option$.MODULE$.apply((Object)"db")));
                TableIdentifier $org_scalatest_assert_macro_right2 = CatalystSqlParser$.MODULE$.parseTableIdentifier(new StringBuilder(3).append("db.").append((String)keyword).toString());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 328));
            }));
        }, new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306));
        this.test("table identifier - strict keywords", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.hiveStrictNonReservedKeyword().foreach((Function1 & Serializable & scala.Serializable)keyword -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(TableIdentifier$.MODULE$.apply(keyword));
            TableIdentifier $org_scalatest_assert_macro_right = CatalystSqlParser$.MODULE$.parseTableIdentifier(keyword);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(TableIdentifier$.MODULE$.apply(keyword));
            TableIdentifier $org_scalatest_assert_macro_right2 = CatalystSqlParser$.MODULE$.parseTableIdentifier(new StringBuilder(2).append("`").append((String)keyword).append("`").toString());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 337));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new TableIdentifier(keyword, Option$.MODULE$.apply((Object)"db")));
            TableIdentifier $org_scalatest_assert_macro_right3 = CatalystSqlParser$.MODULE$.parseTableIdentifier(new StringBuilder(5).append("db.`").append((String)keyword).append("`").toString());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 338));
        }), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
        this.test("table identifier - non reserved keywords", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.hiveNonReservedKeyword())).foreach((Function1 & Serializable & scala.Serializable)nonReserved -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(TableIdentifier$.MODULE$.apply(nonReserved));
            TableIdentifier $org_scalatest_assert_macro_right = CatalystSqlParser$.MODULE$.parseTableIdentifier(nonReserved);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 345));
        }), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342));
        this.test("SPARK-17364 table identifier - contains number", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TableIdentifier $org_scalatest_assert_macro_left = CatalystSqlParser$.MODULE$.parseTableIdentifier("123_");
            TableIdentifier $org_scalatest_assert_macro_right = TableIdentifier$.MODULE$.apply("123_");
            TableIdentifier tableIdentifier = $org_scalatest_assert_macro_left;
            TableIdentifier tableIdentifier2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(tableIdentifier != null ? !tableIdentifier.equals(tableIdentifier2) : tableIdentifier2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 350));
            TableIdentifier $org_scalatest_assert_macro_left2 = CatalystSqlParser$.MODULE$.parseTableIdentifier("1a.123_");
            TableIdentifier $org_scalatest_assert_macro_right2 = new TableIdentifier("123_", (Option)new Some((Object)"1a"));
            TableIdentifier tableIdentifier3 = $org_scalatest_assert_macro_left2;
            TableIdentifier tableIdentifier4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(tableIdentifier3 != null ? !tableIdentifier3.equals(tableIdentifier4) : tableIdentifier4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 351));
            TableIdentifier $org_scalatest_assert_macro_left3 = CatalystSqlParser$.MODULE$.parseTableIdentifier("a.123A");
            TableIdentifier $org_scalatest_assert_macro_right3 = new TableIdentifier("123A", (Option)new Some((Object)"a"));
            TableIdentifier tableIdentifier5 = $org_scalatest_assert_macro_left3;
            TableIdentifier tableIdentifier6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(tableIdentifier5 != null ? !tableIdentifier5.equals(tableIdentifier6) : tableIdentifier6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 353));
            TableIdentifier $org_scalatest_assert_macro_left4 = CatalystSqlParser$.MODULE$.parseTableIdentifier("a.123E3_LIST");
            TableIdentifier $org_scalatest_assert_macro_right4 = new TableIdentifier("123E3_LIST", (Option)new Some((Object)"a"));
            TableIdentifier tableIdentifier7 = $org_scalatest_assert_macro_left4;
            TableIdentifier tableIdentifier8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(tableIdentifier7 != null ? !tableIdentifier7.equals(tableIdentifier8) : tableIdentifier8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 355));
            TableIdentifier $org_scalatest_assert_macro_left5 = CatalystSqlParser$.MODULE$.parseTableIdentifier("a.123D_LIST");
            TableIdentifier $org_scalatest_assert_macro_right5 = new TableIdentifier("123D_LIST", (Option)new Some((Object)"a"));
            TableIdentifier tableIdentifier9 = $org_scalatest_assert_macro_left5;
            TableIdentifier tableIdentifier10 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(tableIdentifier9 != null ? !tableIdentifier9.equals(tableIdentifier10) : tableIdentifier10 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357));
            TableIdentifier $org_scalatest_assert_macro_left6 = CatalystSqlParser$.MODULE$.parseTableIdentifier("a.123BD_LIST");
            TableIdentifier $org_scalatest_assert_macro_right6 = new TableIdentifier("123BD_LIST", (Option)new Some((Object)"a"));
            TableIdentifier tableIdentifier11 = $org_scalatest_assert_macro_left6;
            TableIdentifier tableIdentifier12 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(tableIdentifier11 != null ? !tableIdentifier11.equals(tableIdentifier12) : tableIdentifier12 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 359));
        }, new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 349));
        this.test("SPARK-17832 table identifier - contains backtick", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TableIdentifier complexName = new TableIdentifier("`weird`table`name", (Option)new Some((Object)"`d`b`1"));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(complexName);
            TableIdentifier $org_scalatest_assert_macro_right = CatalystSqlParser$.MODULE$.parseTableIdentifier("```d``b``1`.```weird``table``name`");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(complexName);
            TableIdentifier $org_scalatest_assert_macro_right2 = CatalystSqlParser$.MODULE$.parseTableIdentifier(complexName.quotedString());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 365));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> CatalystSqlParser$.MODULE$.parseTableIdentifier(complexName.unquotedString()), ClassTag$.MODULE$.apply(ParseException.class), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366));
            TableIdentifier complexName2 = new TableIdentifier("x``y", (Option)new Some((Object)"d``b"));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(complexName2);
            TableIdentifier $org_scalatest_assert_macro_right3 = CatalystSqlParser$.MODULE$.parseTableIdentifier(complexName2.quotedString());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 369));
        }, new Position("TableIdentifierParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 362));
    }
}

