/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.BitwiseAnd;
import org.apache.spark.sql.catalyst.expressions.BitwiseAnd$;
import org.apache.spark.sql.catalyst.expressions.BitwiseGet;
import org.apache.spark.sql.catalyst.expressions.BitwiseGet$;
import org.apache.spark.sql.catalyst.expressions.BitwiseNot;
import org.apache.spark.sql.catalyst.expressions.BitwiseNot$;
import org.apache.spark.sql.catalyst.expressions.BitwiseOr;
import org.apache.spark.sql.catalyst.expressions.BitwiseOr$;
import org.apache.spark.sql.catalyst.expressions.BitwiseXor;
import org.apache.spark.sql.catalyst.expressions.BitwiseXor$;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionEvalHelper;
import org.apache.spark.sql.catalyst.expressions.IntegralLiteralTestUtils$;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypeTestUtils$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.scalacheck.Arbitrary;
import org.scalacheck.Gen;
import org.scalacheck.Shrink;
import org.scalacheck.Test;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.enablers.WheneverAsserting;
import org.scalatest.prop.Configuration;
import org.scalatest.prop.Configuration$MaxDiscardedFactor$;
import org.scalatest.prop.Configuration$MinSize$;
import org.scalatest.prop.Configuration$MinSuccessful$;
import org.scalatest.prop.Configuration$PropertyCheckConfiguration$;
import org.scalatest.prop.Configuration$SizeRange$;
import org.scalatest.prop.Configuration$Workers$;
import org.scalatest.prop.Whenever;
import org.scalatestplus.scalacheck.CheckerAsserting;
import org.scalatestplus.scalacheck.ScalaCheckConfiguration;
import org.scalatestplus.scalacheck.ScalaCheckDrivenPropertyChecks;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.Function5;
import scala.Function6;
import scala.Option;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001q1AAA\u0002\u0001!!)\u0011\u0004\u0001C\u00015\t9\")\u001b;xSN,W\t\u001f9sKN\u001c\u0018n\u001c8t'VLG/\u001a\u0006\u0003\t\u0015\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011aaB\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0001\"C\u0001\u0004gFd'B\u0001\u0006\f\u0003\u0015\u0019\b/\u0019:l\u0015\taQ\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001d\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!E\u000b\u0011\u0005I\u0019R\"A\u0005\n\u0005QI!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u0017/5\t1!\u0003\u0002\u0019\u0007\t!R\t\u001f9sKN\u001c\u0018n\u001c8Fm\u0006d\u0007*\u001a7qKJ\fa\u0001P5oSRtD#A\u000e\u0011\u0005Y\u0001\u0001")
public class BitwiseExpressionsSuite
extends SparkFunSuite
implements ExpressionEvalHelper {
    private String sparkHome;
    private volatile Configuration$PropertyCheckConfiguration$ PropertyCheckConfiguration$module;
    private volatile Configuration$MinSuccessful$ MinSuccessful$module;
    private volatile Configuration$MaxDiscardedFactor$ MaxDiscardedFactor$module;
    private volatile Configuration$MinSize$ MinSize$module;
    private volatile Configuration$SizeRange$ SizeRange$module;
    private volatile Configuration$Workers$ Workers$module;
    private final Configuration.PropertyCheckConfiguration generatorDrivenConfig;
    private volatile boolean bitmap$0;

    @Override
    public InternalRow create_row(Seq<Object> values) {
        return ExpressionEvalHelper.create_row$(this, values);
    }

    @Override
    public ArrayBasedMapData create_map(Seq<Tuple2<?, ?>> entries) {
        return ExpressionEvalHelper.create_map$(this, entries);
    }

    @Override
    public ArrayBasedMapData create_map(Seq<?> keys, Seq<?> values) {
        return ExpressionEvalHelper.create_map$(this, keys, values);
    }

    @Override
    public void checkEvaluation(Function0<Expression> expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluation$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluation$default$3() {
        return ExpressionEvalHelper.checkEvaluation$default$3$(this);
    }

    @Override
    public boolean checkResult(Object result, Object expected, Expression expression) {
        return ExpressionEvalHelper.checkResult$(this, result, expected, expression);
    }

    @Override
    public boolean checkResult(Object result, Object expected, DataType exprDataType, boolean exprNullable) {
        return ExpressionEvalHelper.checkResult$(this, result, expected, exprDataType, exprNullable);
    }

    @Override
    public <T extends Throwable> void checkExceptionInExpression(Function0<Expression> expression, String expectedErrMsg, ClassTag<T> evidence$1) {
        ExpressionEvalHelper.checkExceptionInExpression$(this, expression, expectedErrMsg, evidence$1);
    }

    @Override
    public <T extends Throwable> void checkExceptionInExpression(Function0<Expression> expression, InternalRow inputRow, String expectedErrMsg, ClassTag<T> evidence$2) {
        ExpressionEvalHelper.checkExceptionInExpression$(this, expression, inputRow, expectedErrMsg, evidence$2);
    }

    @Override
    public Object evaluateWithoutCodegen(Expression expression, InternalRow inputRow) {
        return ExpressionEvalHelper.evaluateWithoutCodegen$(this, expression, inputRow);
    }

    @Override
    public InternalRow evaluateWithoutCodegen$default$2() {
        return ExpressionEvalHelper.evaluateWithoutCodegen$default$2$(this);
    }

    @Override
    public void checkEvaluationWithoutCodegen(Expression expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluationWithoutCodegen$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluationWithoutCodegen$default$3() {
        return ExpressionEvalHelper.checkEvaluationWithoutCodegen$default$3$(this);
    }

    @Override
    public void checkEvaluationWithMutableProjection(Function0<Expression> expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluationWithMutableProjection$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluationWithMutableProjection$default$3() {
        return ExpressionEvalHelper.checkEvaluationWithMutableProjection$default$3$(this);
    }

    @Override
    public Object evaluateWithMutableProjection(Function0<Expression> expression, InternalRow inputRow) {
        return ExpressionEvalHelper.evaluateWithMutableProjection$(this, expression, inputRow);
    }

    @Override
    public InternalRow evaluateWithMutableProjection$default$2() {
        return ExpressionEvalHelper.evaluateWithMutableProjection$default$2$(this);
    }

    @Override
    public void checkEvaluationWithUnsafeProjection(Expression expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluationWithUnsafeProjection$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluationWithUnsafeProjection$default$3() {
        return ExpressionEvalHelper.checkEvaluationWithUnsafeProjection$default$3$(this);
    }

    @Override
    public InternalRow evaluateWithUnsafeProjection(Expression expression, InternalRow inputRow) {
        return ExpressionEvalHelper.evaluateWithUnsafeProjection$(this, expression, inputRow);
    }

    @Override
    public InternalRow evaluateWithUnsafeProjection$default$2() {
        return ExpressionEvalHelper.evaluateWithUnsafeProjection$default$2$(this);
    }

    @Override
    public void checkEvaluationWithOptimization(Expression expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluationWithOptimization$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluationWithOptimization$default$3() {
        return ExpressionEvalHelper.checkEvaluationWithOptimization$default$3$(this);
    }

    @Override
    public void checkDoubleEvaluation(Function0<Expression> expression, TripleEqualsSupport.Spread<Object> expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkDoubleEvaluation$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkDoubleEvaluation$default$3() {
        return ExpressionEvalHelper.checkDoubleEvaluation$default$3$(this);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegen(Function1<Expression, Expression> c, DataType dataType) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$(this, c, dataType);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegenAllowingException(Function1<Expression, Expression> c, DataType dataType) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegenAllowingException$(this, c, dataType);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegen(Function2<Expression, Expression, Expression> c, DataType dataType1, DataType dataType2) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$((ExpressionEvalHelper)this, c, dataType1, dataType2);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegenAllowingException(Function2<Expression, Expression, Expression> c, DataType dataType1, DataType dataType2) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegenAllowingException$(this, c, dataType1, dataType2);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegen(Function3<Expression, Expression, Expression, Expression> c, DataType dataType1, DataType dataType2, DataType dataType3) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$(this, c, dataType1, dataType2, dataType3);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegen(Function1<Seq<Expression>, Expression> c, DataType dataType, int minNumElements) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$((ExpressionEvalHelper)this, c, dataType, minNumElements);
    }

    @Override
    public int checkConsistencyBetweenInterpretedAndCodegen$default$3() {
        return ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$default$3$(this);
    }

    @Override
    public void cmpInterpretWithCodegen(InternalRow inputRow, Expression expr, boolean exceptionAllowed) {
        ExpressionEvalHelper.cmpInterpretWithCodegen$(this, inputRow, expr, exceptionAllowed);
    }

    @Override
    public boolean cmpInterpretWithCodegen$default$3() {
        return ExpressionEvalHelper.cmpInterpretWithCodegen$default$3$(this);
    }

    @Override
    public void testBothCodegenAndInterpreted(String name, Function0<BoxedUnit> f) {
        ExpressionEvalHelper.testBothCodegenAndInterpreted$(this, name, f);
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$(this);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    public ScalaCheckDrivenPropertyChecks.ConfiguredPropertyCheck forAll(Seq<Configuration.PropertyCheckConfigParam> configParams) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, configParams);
    }

    public <A, ASSERTION> Object forAll(Function1<A, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, ASSERTION> Object forAll(String nameA, Seq<Configuration.PropertyCheckConfigParam> configParams, Function1<A, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, ASSERTION> Object forAll(Gen<A> genA, Seq<Configuration.PropertyCheckConfigParam> configParams, Function1<A, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Seq<Configuration.PropertyCheckConfigParam> configParams, Function1<A, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, ASSERTION> Object forAll(Function2<A, B, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, ASSERTION> Object forAll(String nameA, String nameB, Seq<Configuration.PropertyCheckConfigParam> configParams, Function2<A, B, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, (String)nameB, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Seq<Configuration.PropertyCheckConfigParam> configParams, Function2<A, B, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, genB, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Seq<Configuration.PropertyCheckConfigParam> configParams, Function2<A, B, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, genAndNameB, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, ASSERTION> Object forAll(Function3<A, B, C, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, ASSERTION> Object forAll(String nameA, String nameB, String nameC, Seq<Configuration.PropertyCheckConfigParam> configParams, Function3<A, B, C, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, (String)nameB, (String)nameC, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Gen<C> genC, Seq<Configuration.PropertyCheckConfigParam> configParams, Function3<A, B, C, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, genB, genC, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Tuple2<Gen<C>, String> genAndNameC, Seq<Configuration.PropertyCheckConfigParam> configParams, Function3<A, B, C, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, genAndNameB, genAndNameC, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, ASSERTION> Object forAll(Function4<A, B, C, D, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, ASSERTION> Object forAll(String nameA, String nameB, String nameC, String nameD, Seq<Configuration.PropertyCheckConfigParam> configParams, Function4<A, B, C, D, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, (String)nameB, (String)nameC, (String)nameD, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Gen<C> genC, Gen<D> genD, Seq<Configuration.PropertyCheckConfigParam> configParams, Function4<A, B, C, D, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, genB, genC, genD, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Tuple2<Gen<C>, String> genAndNameC, Tuple2<Gen<D>, String> genAndNameD, Seq<Configuration.PropertyCheckConfigParam> configParams, Function4<A, B, C, D, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, genAndNameB, genAndNameC, genAndNameD, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, ASSERTION> Object forAll(Function5<A, B, C, D, E, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, Arbitrary<E> arbE, Shrink<E> shrE, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, arbE, shrE, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, ASSERTION> Object forAll(String nameA, String nameB, String nameC, String nameD, String nameE, Seq<Configuration.PropertyCheckConfigParam> configParams, Function5<A, B, C, D, E, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, Arbitrary<E> arbE, Shrink<E> shrE, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, (String)nameB, (String)nameC, (String)nameD, (String)nameE, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, arbE, shrE, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Gen<C> genC, Gen<D> genD, Gen<E> genE, Seq<Configuration.PropertyCheckConfigParam> configParams, Function5<A, B, C, D, E, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, Shrink<E> shrE, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, genB, genC, genD, genE, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, shrE, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Tuple2<Gen<C>, String> genAndNameC, Tuple2<Gen<D>, String> genAndNameD, Tuple2<Gen<E>, String> genAndNameE, Seq<Configuration.PropertyCheckConfigParam> configParams, Function5<A, B, C, D, E, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, Shrink<E> shrE, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, genAndNameB, genAndNameC, genAndNameD, genAndNameE, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, shrE, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, F, ASSERTION> Object forAll(Function6<A, B, C, D, E, F, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, Arbitrary<E> arbE, Shrink<E> shrE, Arbitrary<F> arbF, Shrink<F> shrF, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, arbE, shrE, arbF, shrF, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, F, ASSERTION> Object forAll(String nameA, String nameB, String nameC, String nameD, String nameE, String nameF, Seq<Configuration.PropertyCheckConfigParam> configParams, Function6<A, B, C, D, E, F, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, Arbitrary<E> arbE, Shrink<E> shrE, Arbitrary<F> arbF, Shrink<F> shrF, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, (String)nameB, (String)nameC, (String)nameD, (String)nameE, (String)nameF, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, arbE, shrE, arbF, shrF, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, F, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Gen<C> genC, Gen<D> genD, Gen<E> genE, Gen<F> genF, Seq<Configuration.PropertyCheckConfigParam> configParams, Function6<A, B, C, D, E, F, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, Shrink<E> shrE, Shrink<F> shrF, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, genB, genC, genD, genE, genF, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, shrE, shrF, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, F, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Tuple2<Gen<C>, String> genAndNameC, Tuple2<Gen<D>, String> genAndNameD, Tuple2<Gen<E>, String> genAndNameE, Tuple2<Gen<F>, String> genAndNameF, Seq<Configuration.PropertyCheckConfigParam> configParams, Function6<A, B, C, D, E, F, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, Shrink<E> shrE, Shrink<F> shrF, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, genAndNameB, genAndNameC, genAndNameD, genAndNameE, genAndNameF, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, shrE, shrF, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public Test.Parameters getScalaCheckParams(Seq<Configuration.PropertyCheckConfigParam> configParams, Configuration.PropertyCheckConfiguration config) {
        return ScalaCheckConfiguration.getScalaCheckParams$((ScalaCheckConfiguration)this, configParams, (Configuration.PropertyCheckConfiguration)config);
    }

    public Configuration.MinSuccessful minSuccessful(int value) {
        return Configuration.minSuccessful$((Configuration)this, (int)value);
    }

    public Configuration.MaxDiscardedFactor maxDiscardedFactor(double value) {
        return Configuration.maxDiscardedFactor$((Configuration)this, (double)value);
    }

    public Configuration.MinSize minSize(int value) {
        return Configuration.minSize$((Configuration)this, (int)value);
    }

    public Configuration.SizeRange sizeRange(int value) {
        return Configuration.sizeRange$((Configuration)this, (int)value);
    }

    public Configuration.Workers workers(int value) {
        return Configuration.workers$((Configuration)this, (int)value);
    }

    public Configuration.Parameter getParameter(Seq<Configuration.PropertyCheckConfigParam> configParams, Configuration.PropertyCheckConfiguration config) {
        return Configuration.getParameter$((Configuration)this, configParams, (Configuration.PropertyCheckConfiguration)config);
    }

    public <T> Object whenever(boolean condition, Function0<T> fun, WheneverAsserting<T> wa) {
        return Whenever.whenever$((Whenever)this, (boolean)condition, fun, wa);
    }

    private String sparkHome$lzycompute() {
        BitwiseExpressionsSuite bitwiseExpressionsSuite = this;
        synchronized (bitwiseExpressionsSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    public Configuration$PropertyCheckConfiguration$ PropertyCheckConfiguration() {
        if (this.PropertyCheckConfiguration$module == null) {
            this.PropertyCheckConfiguration$lzycompute$1();
        }
        return this.PropertyCheckConfiguration$module;
    }

    public Configuration$MinSuccessful$ MinSuccessful() {
        if (this.MinSuccessful$module == null) {
            this.MinSuccessful$lzycompute$1();
        }
        return this.MinSuccessful$module;
    }

    public Configuration$MaxDiscardedFactor$ MaxDiscardedFactor() {
        if (this.MaxDiscardedFactor$module == null) {
            this.MaxDiscardedFactor$lzycompute$1();
        }
        return this.MaxDiscardedFactor$module;
    }

    public Configuration$MinSize$ MinSize() {
        if (this.MinSize$module == null) {
            this.MinSize$lzycompute$1();
        }
        return this.MinSize$module;
    }

    public Configuration$SizeRange$ SizeRange() {
        if (this.SizeRange$module == null) {
            this.SizeRange$lzycompute$1();
        }
        return this.SizeRange$module;
    }

    public Configuration$Workers$ Workers() {
        if (this.Workers$module == null) {
            this.Workers$lzycompute$1();
        }
        return this.Workers$module;
    }

    public Configuration.PropertyCheckConfiguration generatorDrivenConfig() {
        return this.generatorDrivenConfig;
    }

    public void org$scalatest$prop$Configuration$_setter_$generatorDrivenConfig_$eq(Configuration.PropertyCheckConfiguration x$1) {
        this.generatorDrivenConfig = x$1;
    }

    private final void PropertyCheckConfiguration$lzycompute$1() {
        BitwiseExpressionsSuite bitwiseExpressionsSuite = this;
        synchronized (bitwiseExpressionsSuite) {
            if (this.PropertyCheckConfiguration$module == null) {
                this.PropertyCheckConfiguration$module = new Configuration$PropertyCheckConfiguration$((Configuration)this);
            }
        }
    }

    private final void MinSuccessful$lzycompute$1() {
        BitwiseExpressionsSuite bitwiseExpressionsSuite = this;
        synchronized (bitwiseExpressionsSuite) {
            if (this.MinSuccessful$module == null) {
                this.MinSuccessful$module = new Configuration$MinSuccessful$((Configuration)this);
            }
        }
    }

    private final void MaxDiscardedFactor$lzycompute$1() {
        BitwiseExpressionsSuite bitwiseExpressionsSuite = this;
        synchronized (bitwiseExpressionsSuite) {
            if (this.MaxDiscardedFactor$module == null) {
                this.MaxDiscardedFactor$module = new Configuration$MaxDiscardedFactor$((Configuration)this);
            }
        }
    }

    private final void MinSize$lzycompute$1() {
        BitwiseExpressionsSuite bitwiseExpressionsSuite = this;
        synchronized (bitwiseExpressionsSuite) {
            if (this.MinSize$module == null) {
                this.MinSize$module = new Configuration$MinSize$((Configuration)this);
            }
        }
    }

    private final void SizeRange$lzycompute$1() {
        BitwiseExpressionsSuite bitwiseExpressionsSuite = this;
        synchronized (bitwiseExpressionsSuite) {
            if (this.SizeRange$module == null) {
                this.SizeRange$module = new Configuration$SizeRange$((Configuration)this);
            }
        }
    }

    private final void Workers$lzycompute$1() {
        BitwiseExpressionsSuite bitwiseExpressionsSuite = this;
        synchronized (bitwiseExpressionsSuite) {
            if (this.Workers$module == null) {
                this.Workers$module = new Configuration$Workers$((Configuration)this);
            }
        }
    }

    private final void check$1(Object input, Object expected) {
        BitwiseNot expr = new BitwiseNot((Expression)Literal$.MODULE$.apply(input));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(expr.dataType());
        DataType $org_scalatest_assert_macro_right = Literal$.MODULE$.apply(input).dataType();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BitwiseExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32));
        this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> expr, expected, this.checkEvaluation$default$3());
    }

    private final void check$2(Object input1, Object input2, Object expected) {
        BitwiseAnd expr = new BitwiseAnd((Expression)Literal$.MODULE$.apply(input1), (Expression)Literal$.MODULE$.apply(input2));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(expr.dataType());
        DataType $org_scalatest_assert_macro_right = Literal$.MODULE$.apply(input1).dataType();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BitwiseExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> expr, expected, this.checkEvaluation$default$3());
    }

    private final void check$3(Object input1, Object input2, Object expected) {
        BitwiseOr expr = new BitwiseOr((Expression)Literal$.MODULE$.apply(input1), (Expression)Literal$.MODULE$.apply(input2));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(expr.dataType());
        DataType $org_scalatest_assert_macro_right = Literal$.MODULE$.apply(input1).dataType();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BitwiseExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> expr, expected, this.checkEvaluation$default$3());
    }

    private final void check$4(Object input1, Object input2, Object expected) {
        BitwiseXor expr = new BitwiseXor((Expression)Literal$.MODULE$.apply(input1), (Expression)Literal$.MODULE$.apply(input2));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(expr.dataType());
        DataType $org_scalatest_assert_macro_right = Literal$.MODULE$.apply(input1).dataType();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BitwiseExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
        this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> expr, expected, this.checkEvaluation$default$3());
    }

    public BitwiseExpressionsSuite() {
        Whenever.$init$((Whenever)this);
        Configuration.$init$((Configuration)this);
        ScalaCheckConfiguration.$init$((ScalaCheckConfiguration)this);
        ScalaCheckDrivenPropertyChecks.$init$((ScalaCheckDrivenPropertyChecks)this);
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLHelper.$init$(this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        PlanTestBase.$init$(this);
        ExpressionEvalHelper.$init$(this);
        this.test("BitwiseNOT", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.check$1(BoxesRunTime.boxToByte((byte)((byte)1)), BoxesRunTime.boxToByte((byte)(~((byte)1))));
            this.check$1(BoxesRunTime.boxToShort((short)((short)1000)), BoxesRunTime.boxToShort((short)(~((short)1000))));
            this.check$1(BoxesRunTime.boxToInteger((int)1000000), BoxesRunTime.boxToInteger((int)(~1000000)));
            this.check$1(BoxesRunTime.boxToLong((long)123456789123L), BoxesRunTime.boxToLong((long)(0x1CBE991A83L ^ 0xFFFFFFFFFFFFFFFFL)));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new BitwiseNot((Expression)Literal$.MODULE$.create(null, (DataType)IntegerType$.MODULE$)), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new BitwiseNot((Expression)IntegralLiteralTestUtils$.MODULE$.positiveShortLit()), BoxesRunTime.boxToShort((short)(~IntegralLiteralTestUtils$.MODULE$.positiveShort())), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new BitwiseNot((Expression)IntegralLiteralTestUtils$.MODULE$.negativeShortLit()), BoxesRunTime.boxToShort((short)(~IntegralLiteralTestUtils$.MODULE$.negativeShort())), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new BitwiseNot((Expression)IntegralLiteralTestUtils$.MODULE$.positiveIntLit()), BoxesRunTime.boxToInteger((int)(~IntegralLiteralTestUtils$.MODULE$.positiveInt())), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new BitwiseNot((Expression)IntegralLiteralTestUtils$.MODULE$.negativeIntLit()), BoxesRunTime.boxToInteger((int)(~IntegralLiteralTestUtils$.MODULE$.negativeInt())), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new BitwiseNot((Expression)IntegralLiteralTestUtils$.MODULE$.positiveLongLit()), BoxesRunTime.boxToLong((long)(IntegralLiteralTestUtils$.MODULE$.positiveLong() ^ 0xFFFFFFFFFFFFFFFFL)), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new BitwiseNot((Expression)IntegralLiteralTestUtils$.MODULE$.negativeLongLit()), BoxesRunTime.boxToLong((long)(IntegralLiteralTestUtils$.MODULE$.negativeLong() ^ 0xFFFFFFFFFFFFFFFFL)), this.checkEvaluation$default$3());
            DataTypeTestUtils$.MODULE$.integralType().foreach((Function1 & Serializable & scala.Serializable)dt -> {
                this.checkConsistencyBetweenInterpretedAndCodegen((Function1<Expression, Expression>)BitwiseNot$.MODULE$, (DataType)dt);
                return BoxedUnit.UNIT;
            });
        }, new Position("BitwiseExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 29));
        this.test("BitwiseAnd", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.check$2(BoxesRunTime.boxToByte((byte)((byte)1)), BoxesRunTime.boxToByte((byte)((byte)2)), BoxesRunTime.boxToByte((byte)((byte)((byte)1 & (byte)2))));
            this.check$2(BoxesRunTime.boxToShort((short)((short)1000)), BoxesRunTime.boxToShort((short)((short)2)), BoxesRunTime.boxToShort((short)((short)((short)1000 & (short)2))));
            this.check$2(BoxesRunTime.boxToInteger((int)1000000), BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)0));
            this.check$2(BoxesRunTime.boxToLong((long)123456789123L), BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToLong((long)1L));
            Literal nullLit = Literal$.MODULE$.create(null, (DataType)IntegerType$.MODULE$);
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new BitwiseAnd((Expression)nullLit, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new BitwiseAnd((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), (Expression)nullLit), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new BitwiseAnd((Expression)nullLit, (Expression)nullLit), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new BitwiseAnd((Expression)IntegralLiteralTestUtils$.MODULE$.positiveShortLit(), (Expression)IntegralLiteralTestUtils$.MODULE$.negativeShortLit()), BoxesRunTime.boxToShort((short)((short)(IntegralLiteralTestUtils$.MODULE$.positiveShort() & IntegralLiteralTestUtils$.MODULE$.negativeShort()))), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new BitwiseAnd((Expression)IntegralLiteralTestUtils$.MODULE$.positiveIntLit(), (Expression)IntegralLiteralTestUtils$.MODULE$.negativeIntLit()), BoxesRunTime.boxToInteger((int)(IntegralLiteralTestUtils$.MODULE$.positiveInt() & IntegralLiteralTestUtils$.MODULE$.negativeInt())), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new BitwiseAnd((Expression)IntegralLiteralTestUtils$.MODULE$.positiveLongLit(), (Expression)IntegralLiteralTestUtils$.MODULE$.negativeLongLit()), BoxesRunTime.boxToLong((long)(IntegralLiteralTestUtils$.MODULE$.positiveLong() & IntegralLiteralTestUtils$.MODULE$.negativeLong())), this.checkEvaluation$default$3());
            DataTypeTestUtils$.MODULE$.integralType().foreach((Function1 & Serializable & scala.Serializable)dt -> {
                this.checkConsistencyBetweenInterpretedAndCodegen((Function2<Expression, Expression, Expression>)BitwiseAnd$.MODULE$, (DataType)dt, (DataType)dt);
                return BoxedUnit.UNIT;
            });
        }, new Position("BitwiseExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        this.test("BitwiseOr", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.check$3(BoxesRunTime.boxToByte((byte)((byte)1)), BoxesRunTime.boxToByte((byte)((byte)2)), BoxesRunTime.boxToByte((byte)((byte)((byte)1 | (byte)2))));
            this.check$3(BoxesRunTime.boxToShort((short)((short)1000)), BoxesRunTime.boxToShort((short)((short)2)), BoxesRunTime.boxToShort((short)((short)((short)1000 | (short)2))));
            this.check$3(BoxesRunTime.boxToInteger((int)1000000), BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)1000004));
            this.check$3(BoxesRunTime.boxToLong((long)123456789123L), BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToLong((long)123456789127L));
            Literal nullLit = Literal$.MODULE$.create(null, (DataType)IntegerType$.MODULE$);
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new BitwiseOr((Expression)nullLit, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new BitwiseOr((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), (Expression)nullLit), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new BitwiseOr((Expression)nullLit, (Expression)nullLit), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new BitwiseOr((Expression)IntegralLiteralTestUtils$.MODULE$.positiveShortLit(), (Expression)IntegralLiteralTestUtils$.MODULE$.negativeShortLit()), BoxesRunTime.boxToShort((short)((short)(IntegralLiteralTestUtils$.MODULE$.positiveShort() | IntegralLiteralTestUtils$.MODULE$.negativeShort()))), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new BitwiseOr((Expression)IntegralLiteralTestUtils$.MODULE$.positiveIntLit(), (Expression)IntegralLiteralTestUtils$.MODULE$.negativeIntLit()), BoxesRunTime.boxToInteger((int)(IntegralLiteralTestUtils$.MODULE$.positiveInt() | IntegralLiteralTestUtils$.MODULE$.negativeInt())), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new BitwiseOr((Expression)IntegralLiteralTestUtils$.MODULE$.positiveLongLit(), (Expression)IntegralLiteralTestUtils$.MODULE$.negativeLongLit()), BoxesRunTime.boxToLong((long)(IntegralLiteralTestUtils$.MODULE$.positiveLong() | IntegralLiteralTestUtils$.MODULE$.negativeLong())), this.checkEvaluation$default$3());
            DataTypeTestUtils$.MODULE$.integralType().foreach((Function1 & Serializable & scala.Serializable)dt -> {
                this.checkConsistencyBetweenInterpretedAndCodegen((Function2<Expression, Expression, Expression>)BitwiseOr$.MODULE$, (DataType)dt, (DataType)dt);
                return BoxedUnit.UNIT;
            });
        }, new Position("BitwiseExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        this.test("BitwiseXor", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.check$4(BoxesRunTime.boxToByte((byte)((byte)1)), BoxesRunTime.boxToByte((byte)((byte)2)), BoxesRunTime.boxToByte((byte)((byte)((byte)1 ^ (byte)2))));
            this.check$4(BoxesRunTime.boxToShort((short)((short)1000)), BoxesRunTime.boxToShort((short)((short)2)), BoxesRunTime.boxToShort((short)((short)((short)1000 ^ (short)2))));
            this.check$4(BoxesRunTime.boxToInteger((int)1000000), BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)1000004));
            this.check$4(BoxesRunTime.boxToLong((long)123456789123L), BoxesRunTime.boxToLong((long)5L), BoxesRunTime.boxToLong((long)123456789126L));
            Literal nullLit = Literal$.MODULE$.create(null, (DataType)IntegerType$.MODULE$);
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new BitwiseXor((Expression)nullLit, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new BitwiseXor((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), (Expression)nullLit), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new BitwiseXor((Expression)nullLit, (Expression)nullLit), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new BitwiseXor((Expression)IntegralLiteralTestUtils$.MODULE$.positiveShortLit(), (Expression)IntegralLiteralTestUtils$.MODULE$.negativeShortLit()), BoxesRunTime.boxToShort((short)((short)(IntegralLiteralTestUtils$.MODULE$.positiveShort() ^ IntegralLiteralTestUtils$.MODULE$.negativeShort()))), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new BitwiseXor((Expression)IntegralLiteralTestUtils$.MODULE$.positiveIntLit(), (Expression)IntegralLiteralTestUtils$.MODULE$.negativeIntLit()), BoxesRunTime.boxToInteger((int)(IntegralLiteralTestUtils$.MODULE$.positiveInt() ^ IntegralLiteralTestUtils$.MODULE$.negativeInt())), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new BitwiseXor((Expression)IntegralLiteralTestUtils$.MODULE$.positiveLongLit(), (Expression)IntegralLiteralTestUtils$.MODULE$.negativeLongLit()), BoxesRunTime.boxToLong((long)(IntegralLiteralTestUtils$.MODULE$.positiveLong() ^ IntegralLiteralTestUtils$.MODULE$.negativeLong())), this.checkEvaluation$default$3());
            DataTypeTestUtils$.MODULE$.integralType().foreach((Function1 & Serializable & scala.Serializable)dt -> {
                this.checkConsistencyBetweenInterpretedAndCodegen((Function2<Expression, Expression, Expression>)BitwiseXor$.MODULE$, (DataType)dt, (DataType)dt);
                return BoxedUnit.UNIT;
            });
        }, new Position("BitwiseExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
        this.test("BitGet", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Literal nullLongLiteral = Literal$.MODULE$.create(null, (DataType)LongType$.MODULE$);
            Literal nullIntLiteral = Literal$.MODULE$.create(null, (DataType)IntegerType$.MODULE$);
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new BitwiseGet((Expression)nullLongLiteral, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new BitwiseGet((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)11L)), (Expression)nullIntLiteral), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new BitwiseGet((Expression)nullLongLiteral, (Expression)nullIntLiteral), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new BitwiseGet((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)11L)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3))), BoxesRunTime.boxToByte((byte)((byte)1)), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new BitwiseGet((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)11L)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2))), BoxesRunTime.boxToByte((byte)((byte)0)), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new BitwiseGet((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)11L)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))), BoxesRunTime.boxToByte((byte)((byte)1)), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new BitwiseGet((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)11L)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0))), BoxesRunTime.boxToByte((byte)((byte)1)), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new BitwiseGet((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)11L)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)63))), BoxesRunTime.boxToByte((byte)((byte)0)), this.checkEvaluation$default$3());
            InternalRow row1 = this.create_row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)11L), BoxesRunTime.boxToInteger((int)-1)}));
            InternalRow row2 = this.create_row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)11L), BoxesRunTime.boxToInteger((int)64)}));
            InternalRow row3 = this.create_row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToInteger((int)32)}));
            InternalRow row4 = this.create_row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)((short)11)), BoxesRunTime.boxToInteger((int)16)}));
            InternalRow row5 = this.create_row((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)((byte)11)), BoxesRunTime.boxToInteger((int)16)}));
            BoundReference tl = package.expressions$.MODULE$.DslAttribute(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "t")).long()).at(0);
            BoundReference ti = package.expressions$.MODULE$.DslAttribute(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "t")).int()).at(0);
            BoundReference ts = package.expressions$.MODULE$.DslAttribute(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "t")).short()).at(0);
            BoundReference tb = package.expressions$.MODULE$.DslAttribute(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "t")).byte()).at(0);
            BoundReference p = package.expressions$.MODULE$.DslAttribute(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "p")).int()).at(1);
            BitwiseGet expr = new BitwiseGet((Expression)tl, (Expression)p);
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> expr, row1, "Invalid bit position: -1 is less than zero", ClassTag$.MODULE$.apply(IllegalArgumentException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> expr, row2, "Invalid bit position: 64 exceeds the bit upper limit", ClassTag$.MODULE$.apply(IllegalArgumentException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new BitwiseGet((Expression)ti, (Expression)p), row3, "Invalid bit position: 32 exceeds the bit upper limit", ClassTag$.MODULE$.apply(IllegalArgumentException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new BitwiseGet((Expression)ts, (Expression)p), row4, "Invalid bit position: 16 exceeds the bit upper limit", ClassTag$.MODULE$.apply(IllegalArgumentException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable & scala.Serializable)() -> new BitwiseGet((Expression)tb, (Expression)p), row5, "Invalid bit position: 16 exceeds the bit upper limit", ClassTag$.MODULE$.apply(IllegalArgumentException.class));
            DataTypeTestUtils$.MODULE$.integralType().foreach((Function1 & Serializable & scala.Serializable)dt -> {
                this.checkConsistencyBetweenInterpretedAndCodegenAllowingException((Function2<Expression, Expression, Expression>)BitwiseGet$.MODULE$, (DataType)dt, (DataType)IntegerType$.MODULE$);
                return BoxedUnit.UNIT;
            });
        }, new Position("BitwiseExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
    }
}

