/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.analysis.SimpleAnalyzer$;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Add;
import org.apache.spark.sql.catalyst.expressions.Add$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.BRound;
import org.apache.spark.sql.catalyst.expressions.BitwiseAnd;
import org.apache.spark.sql.catalyst.expressions.BitwiseNot;
import org.apache.spark.sql.catalyst.expressions.BitwiseOr;
import org.apache.spark.sql.catalyst.expressions.BitwiseXor;
import org.apache.spark.sql.catalyst.expressions.CaseKeyWhen$;
import org.apache.spark.sql.catalyst.expressions.CaseWhen;
import org.apache.spark.sql.catalyst.expressions.CaseWhen$;
import org.apache.spark.sql.catalyst.expressions.Coalesce;
import org.apache.spark.sql.catalyst.expressions.CreateArray$;
import org.apache.spark.sql.catalyst.expressions.CreateMap$;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStruct;
import org.apache.spark.sql.catalyst.expressions.Divide;
import org.apache.spark.sql.catalyst.expressions.Divide$;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Explode;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Greatest$;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.Least$;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Multiply;
import org.apache.spark.sql.catalyst.expressions.Multiply$;
import org.apache.spark.sql.catalyst.expressions.Murmur3Hash;
import org.apache.spark.sql.catalyst.expressions.PosExplode;
import org.apache.spark.sql.catalyst.expressions.Remainder;
import org.apache.spark.sql.catalyst.expressions.Remainder$;
import org.apache.spark.sql.catalyst.expressions.Round;
import org.apache.spark.sql.catalyst.expressions.Subtract;
import org.apache.spark.sql.catalyst.expressions.Subtract$;
import org.apache.spark.sql.catalyst.expressions.XxHash64;
import org.apache.spark.sql.catalyst.expressions.aggregate.Average;
import org.apache.spark.sql.catalyst.expressions.aggregate.Average$;
import org.apache.spark.sql.catalyst.expressions.aggregate.BoolAnd;
import org.apache.spark.sql.catalyst.expressions.aggregate.BoolOr;
import org.apache.spark.sql.catalyst.expressions.aggregate.Max;
import org.apache.spark.sql.catalyst.expressions.aggregate.Min;
import org.apache.spark.sql.catalyst.expressions.aggregate.Sum;
import org.apache.spark.sql.catalyst.expressions.aggregate.Sum$;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001A3Aa\u0002\u0005\u0001+!)\u0001\u0005\u0001C\u0001C!9A\u0005\u0001b\u0001\n\u0003)\u0003B\u0002\u0017\u0001A\u0003%a\u0005C\u0003.\u0001\u0011\u0005a\u0006C\u0003K\u0001\u0011\u00051\nC\u0003N\u0001\u0011\u0005aJA\u000eFqB\u0014Xm]:j_:$\u0016\u0010]3DQ\u0016\u001c7.\u001b8h'VLG/\u001a\u0006\u0003\u0013)\t\u0001\"\u00198bYf\u001c\u0018n\u001d\u0006\u0003\u00171\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u001b9\t1a]9m\u0015\ty\u0001#A\u0003ta\u0006\u00148N\u0003\u0002\u0012%\u00051\u0011\r]1dQ\u0016T\u0011aE\u0001\u0004_J<7\u0001A\n\u0004\u0001YQ\u0002CA\f\u0019\u001b\u0005q\u0011BA\r\u000f\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u00111DH\u0007\u00029)\u0011QDC\u0001\u0006a2\fgn]\u0005\u0003?q\u0011\u0011bU)M\u0011\u0016d\u0007/\u001a:\u0002\rqJg.\u001b;?)\u0005\u0011\u0003CA\u0012\u0001\u001b\u0005A\u0011\u0001\u0004;fgR\u0014V\r\\1uS>tW#\u0001\u0014\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0005%b\u0012a\u00027pO&\u001c\u0017\r\\\u0005\u0003W!\u0012Q\u0002T8dC2\u0014V\r\\1uS>t\u0017!\u0004;fgR\u0014V\r\\1uS>t\u0007%A\u0006bgN,'\u000f^#se>\u0014HcA\u00186{A\u0011\u0001gM\u0007\u0002c)\t!'A\u0003tG\u0006d\u0017-\u0003\u00025c\t!QK\\5u\u0011\u00151D\u00011\u00018\u0003\u0011)\u0007\u0010\u001d:\u0011\u0005aZT\"A\u001d\u000b\u0005iR\u0011aC3yaJ,7o]5p]NL!\u0001P\u001d\u0003\u0015\u0015C\bO]3tg&|g\u000eC\u0003?\t\u0001\u0007q(\u0001\u0007feJ|'/T3tg\u0006<W\r\u0005\u0002A\u000f:\u0011\u0011)\u0012\t\u0003\u0005Fj\u0011a\u0011\u0006\u0003\tR\ta\u0001\u0010:p_Rt\u0014B\u0001$2\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001*\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0019\u000b\u0014!D1tg\u0016\u0014HoU;dG\u0016\u001c8\u000f\u0006\u00020\u0019\")a'\u0002a\u0001o\u0005a\u0012m]:feR,%O]8s\r>\u0014H)\u001b4gKJLgn\u001a+za\u0016\u001cHCA\u0018P\u0011\u00151d\u00011\u00018\u0001")
public class ExpressionTypeCheckingSuite
extends SparkFunSuite
implements SQLHelper {
    private final LocalRelation testRelation;
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    private String sparkHome$lzycompute() {
        ExpressionTypeCheckingSuite expressionTypeCheckingSuite = this;
        synchronized (expressionTypeCheckingSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    public LocalRelation testRelation() {
        return this.testRelation;
    }

    public void assertError(Expression expr, String errorMessage) {
        AnalysisException e = (AnalysisException)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.assertSuccess(expr), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42)));
        String $org_scalatest_assert_macro_left = e.getMessage();
        String $org_scalatest_assert_macro_right = new StringBuilder(44).append("cannot resolve '").append(expr.sql()).append("' due to data type mismatch:").toString();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        String $org_scalatest_assert_macro_left2 = e.getMessage();
        String $org_scalatest_assert_macro_right2 = errorMessage;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
    }

    public void assertSuccess(Expression expr) {
        LogicalPlan analyzed = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression(expr).as("c")}))).analyze();
        SimpleAnalyzer$.MODULE$.checkAnalysis(analyzed);
    }

    public void assertErrorForDifferingTypes(Expression expr) {
        this.assertError(expr, new StringBuilder(21).append("differing types in '").append(expr.sql()).append("'").toString());
    }

    public static final /* synthetic */ void $anonfun$new$12(ExpressionTypeCheckingSuite $this, Function1 operator) {
        $this.assertError((Expression)operator.apply((Object)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), (List)Nil$.MODULE$)), "requires at least two arguments");
        $this.assertError((Expression)operator.apply((Object)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField")), (List)Nil$.MODULE$))), "should all have the same type");
        $this.assertError((Expression)operator.apply((Object)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField")), (List)Nil$.MODULE$))), "does not support ordering");
    }

    public ExpressionTypeCheckingSuite() {
        SQLHelper.$init$(this);
        this.testRelation = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "intField")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "stringField")).string(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")).boolean(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "decimalField")).decimal(8, 0), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "arrayField")).array((DataType)StringType$.MODULE$), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "mapField")).map((DataType)StringType$.MODULE$, (DataType)LongType$.MODULE$)}));
        this.test("check types for unary arithmetic", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.assertError((Expression)new BitwiseNot((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField"))), "requires integral type"), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        this.test("check types for binary arithmetic", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertSuccess((Expression)new Add((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField")), Add$.MODULE$.apply$default$3()));
            this.assertSuccess((Expression)new Subtract((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField")), Subtract$.MODULE$.apply$default$3()));
            this.assertSuccess((Expression)new Multiply((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField")), Multiply$.MODULE$.apply$default$3()));
            this.assertSuccess((Expression)new Divide((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField")), Divide$.MODULE$.apply$default$3()));
            this.assertSuccess((Expression)new Remainder((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField")), Remainder$.MODULE$.apply$default$3()));
            this.assertErrorForDifferingTypes((Expression)new Add((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), Add$.MODULE$.apply$default$3()));
            this.assertErrorForDifferingTypes((Expression)new Subtract((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), Subtract$.MODULE$.apply$default$3()));
            this.assertErrorForDifferingTypes((Expression)new Multiply((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), Multiply$.MODULE$.apply$default$3()));
            this.assertErrorForDifferingTypes((Expression)new Divide((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), Divide$.MODULE$.apply$default$3()));
            this.assertErrorForDifferingTypes((Expression)new Remainder((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), Remainder$.MODULE$.apply$default$3()));
            this.assertErrorForDifferingTypes((Expression)new BitwiseAnd((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField"))));
            this.assertErrorForDifferingTypes((Expression)new BitwiseOr((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField"))));
            this.assertErrorForDifferingTypes((Expression)new BitwiseXor((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField"))));
            this.assertError((Expression)new Add((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), Add$.MODULE$.apply$default$3()), "requires (numeric or interval day to second or interval year to month or interval) type");
            this.assertError((Expression)new Subtract((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), Subtract$.MODULE$.apply$default$3()), "requires (numeric or interval day to second or interval year to month or interval) type");
            this.assertError((Expression)new Multiply((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), Multiply$.MODULE$.apply$default$3()), "requires numeric type");
            this.assertError((Expression)new Divide((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), Divide$.MODULE$.apply$default$3()), "requires (double or decimal) type");
            this.assertError((Expression)new Remainder((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), Remainder$.MODULE$.apply$default$3()), "requires numeric type");
            this.assertError((Expression)new BitwiseAnd((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField"))), "requires integral type");
            this.assertError((Expression)new BitwiseOr((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField"))), "requires integral type");
            this.assertError((Expression)new BitwiseXor((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField"))), "requires integral type");
        }, new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        this.test("check types for predicates", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertSuccess((Expression)new EqualTo((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField"))));
            this.assertSuccess((Expression)new EqualNullSafe((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField"))));
            this.assertSuccess((Expression)new LessThan((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField"))));
            this.assertSuccess((Expression)new LessThanOrEqual((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField"))));
            this.assertSuccess((Expression)new GreaterThan((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField"))));
            this.assertSuccess((Expression)new GreaterThanOrEqual((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField"))));
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ANSI_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.assertSuccess((Expression)new EqualTo((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField"))));
                this.assertSuccess((Expression)new EqualNullSafe((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField"))));
            });
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ANSI_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.assertError((Expression)new EqualTo((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField"))), "differing types");
                this.assertError((Expression)new EqualNullSafe((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField"))), "differing types");
            });
            this.assertErrorForDifferingTypes((Expression)new EqualTo((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField"))));
            this.assertErrorForDifferingTypes((Expression)new EqualNullSafe((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField"))));
            this.assertErrorForDifferingTypes((Expression)new LessThan((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField"))));
            this.assertErrorForDifferingTypes((Expression)new LessThanOrEqual((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField"))));
            this.assertErrorForDifferingTypes((Expression)new GreaterThan((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField"))));
            this.assertErrorForDifferingTypes((Expression)new GreaterThanOrEqual((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField"))));
            this.assertError((Expression)new EqualTo((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField"))), "EqualTo does not support ordering on type map");
            this.assertError((Expression)new EqualNullSafe((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField"))), "EqualNullSafe does not support ordering on type map");
            this.assertError((Expression)new LessThan((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField"))), "LessThan does not support ordering on type map");
            this.assertError((Expression)new LessThanOrEqual((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField"))), "LessThanOrEqual does not support ordering on type map");
            this.assertError((Expression)new GreaterThan((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField"))), "GreaterThan does not support ordering on type map");
            this.assertError((Expression)new GreaterThanOrEqual((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField"))), "GreaterThanOrEqual does not support ordering on type map");
            this.assertError((Expression)new If((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField"))), "type of predicate expression in If should be boolean");
            this.assertErrorForDifferingTypes((Expression)new If((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField"))));
            this.assertError((Expression)new CaseWhen((Seq)new .colon.colon((Object)new Tuple2((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")).attr(), (Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "intField")).attr()), (List)new .colon.colon((Object)new Tuple2((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")).attr(), (Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "mapField")).attr()), (List)Nil$.MODULE$)), CaseWhen$.MODULE$.apply$default$2()), "THEN and ELSE expressions should all be same type or coercible to a common type");
            this.assertError((Expression)CaseKeyWhen$.MODULE$.apply((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField")), (List)Nil$.MODULE$))))), "THEN and ELSE expressions should all be same type or coercible to a common type");
            this.assertError((Expression)new CaseWhen((Seq)new .colon.colon((Object)new Tuple2((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")).attr(), (Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "intField")).attr()), (List)new .colon.colon((Object)new Tuple2((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "intField")).attr(), (Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "intField")).attr()), (List)Nil$.MODULE$)), CaseWhen$.MODULE$.apply$default$2()), "WHEN expressions in CaseWhen should all be boolean type");
        }, new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
        this.test("check types for aggregates", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertSuccess((Expression)new Sum((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField")), Sum$.MODULE$.apply$default$2()));
            this.assertSuccess((Expression)new Average((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField")), Average$.MODULE$.apply$default$2()));
            this.assertSuccess((Expression)new Min((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "arrayField"))));
            this.assertSuccess((Expression)new BoolAnd((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField"))));
            this.assertSuccess((Expression)new BoolOr((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField"))));
            this.assertError((Expression)new Min((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField"))), "min does not support ordering on type");
            this.assertError((Expression)new Max((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField"))), "max does not support ordering on type");
            this.assertError((Expression)new Sum((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), Sum$.MODULE$.apply$default$2()), "function sum requires numeric or interval types");
            this.assertError((Expression)new Average((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), Average$.MODULE$.apply$default$2()), "function average requires numeric or interval types");
        }, new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
        this.test("check types for others", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertError((Expression)CreateArray$.MODULE$.apply((Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), (List)Nil$.MODULE$))), "input to function array should all be the same type");
            this.assertError((Expression)new Coalesce((Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), (List)Nil$.MODULE$))), "input to function coalesce should all be the same type");
            this.assertError((Expression)new Coalesce((Seq)Nil$.MODULE$), "function coalesce requires at least one argument");
            this.assertError((Expression)new Murmur3Hash((Seq)Nil$.MODULE$), "function hash requires at least one argument");
            this.assertError((Expression)new XxHash64((Seq)Nil$.MODULE$), "function xxhash64 requires at least one argument");
            this.assertError((Expression)new Explode((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField"))), "input to function explode should be array or map type");
            this.assertError((Expression)new PosExplode((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField"))), "input to function explode should be array or map type");
        }, new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
        this.test("check types for CreateNamedStruct", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertError((Expression)new CreateNamedStruct((Seq)new .colon.colon((Object)package.expressions$.MODULE$.stringToLiteral("a"), (List)new .colon.colon((Object)package.expressions$.MODULE$.stringToLiteral("b"), (List)new .colon.colon((Object)package.expressions$.MODULE$.doubleToLiteral(2.0), (List)Nil$.MODULE$)))), "even number of arguments");
            this.assertError((Expression)new CreateNamedStruct((Seq)new .colon.colon((Object)package.expressions$.MODULE$.intToLiteral(1), (List)new .colon.colon((Object)package.expressions$.MODULE$.stringToLiteral("a"), (List)new .colon.colon((Object)package.expressions$.MODULE$.stringToLiteral("b"), (List)new .colon.colon((Object)package.expressions$.MODULE$.doubleToLiteral(2.0), (List)Nil$.MODULE$))))), "Only foldable string expressions are allowed to appear at odd position");
            this.assertError((Expression)new CreateNamedStruct((Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslAttribute(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).string()).at(0), (List)new .colon.colon((Object)package.expressions$.MODULE$.stringToLiteral("a"), (List)new .colon.colon((Object)package.expressions$.MODULE$.stringToLiteral("b"), (List)new .colon.colon((Object)package.expressions$.MODULE$.doubleToLiteral(2.0), (List)Nil$.MODULE$))))), "Only foldable string expressions are allowed to appear at odd position");
            this.assertError((Expression)new CreateNamedStruct((Seq)new .colon.colon((Object)Literal$.MODULE$.create(null, (DataType)StringType$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.stringToLiteral("a"), (List)Nil$.MODULE$))), "Field name should not be null");
        }, new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
        this.test("check types for CreateMap", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertError((Expression)CreateMap$.MODULE$.apply((Seq)new .colon.colon((Object)package.expressions$.MODULE$.stringToLiteral("a"), (List)new .colon.colon((Object)package.expressions$.MODULE$.stringToLiteral("b"), (List)new .colon.colon((Object)package.expressions$.MODULE$.doubleToLiteral(2.0), (List)Nil$.MODULE$)))), "even number of arguments");
            this.assertError((Expression)CreateMap$.MODULE$.apply((Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField")), (List)Nil$.MODULE$))))), "keys of function map should all be the same type");
            this.assertError((Expression)CreateMap$.MODULE$.apply((Seq)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField")), (List)new .colon.colon((Object)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), (List)Nil$.MODULE$))))), "values of function map should all be the same type");
        }, new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
        this.test("check types for ROUND/BROUND", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertSuccess((Expression)new Round((Expression)Literal$.MODULE$.apply(null), (Expression)Literal$.MODULE$.apply(null)));
            this.assertSuccess((Expression)new Round((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))));
            this.assertError((Expression)new Round((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField"))), "Only foldable Expression is allowed");
            this.assertError((Expression)new Round((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField"))), "requires int type");
            this.assertError((Expression)new Round((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField"))), "requires int type");
            this.assertError((Expression)new Round((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField"))), "requires numeric type");
            this.assertSuccess((Expression)new BRound((Expression)Literal$.MODULE$.apply(null), (Expression)Literal$.MODULE$.apply(null)));
            this.assertSuccess((Expression)new BRound((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))));
            this.assertError((Expression)new BRound((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField"))), "Only foldable Expression is allowed");
            this.assertError((Expression)new BRound((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField"))), "requires int type");
            this.assertError((Expression)new BRound((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField"))), "requires int type");
            this.assertError((Expression)new BRound((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField"))), "requires numeric type");
        }, new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
        this.test("check types for Greatest/Least", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)Greatest$.MODULE$, (List)new .colon.colon((Object)Least$.MODULE$, (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)operator -> {
            ExpressionTypeCheckingSuite.$anonfun$new$12(this, operator);
            return BoxedUnit.UNIT;
        }), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
    }
}

