/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.encoders.ExamplePoint;
import org.apache.spark.sql.catalyst.encoders.ExamplePointUDT;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ObjectType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.json4s.JsonAST;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001e3Aa\u0002\u0005\u0001#!)a\u0003\u0001C\u0001/!9!\u0004\u0001b\u0001\n\u0013Y\u0002B\u0002\u0012\u0001A\u0003%A\u0004C\u0003$\u0001\u0011%A\u0005C\u0003$\u0001\u0011%\u0011\u000bC\u0003V\u0001\u0011%aK\u0001\u0007S_^T5o\u001c8Tk&$XM\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111\u0003F\u0007\u0002\u0015%\u0011QC\u0003\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0002\rqJg.\u001b;?)\u0005A\u0002CA\r\u0001\u001b\u0005A\u0011AB:dQ\u0016l\u0017-F\u0001\u001d!\ti\u0002%D\u0001\u001f\u0015\ty\u0002\"A\u0003usB,7/\u0003\u0002\"=\tQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u000fM\u001c\u0007.Z7bA\u0005AA/Z:u\u0015N|g\u000eF\u0003&Waj$\t\u0005\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsE\u0001\u0003V]&$\b\"\u0002\u0017\u0005\u0001\u0004i\u0013\u0001\u00028b[\u0016\u0004\"AL\u001b\u000f\u0005=\u001a\u0004C\u0001\u0019(\u001b\u0005\t$B\u0001\u001a\u0011\u0003\u0019a$o\\8u}%\u0011AgJ\u0001\u0007!J,G-\u001a4\n\u0005Y:$AB*ue&twM\u0003\u00025O!)\u0011\b\u0002a\u0001u\u0005)a/\u00197vKB\u0011aeO\u0005\u0003y\u001d\u00121!\u00118z\u0011\u0015qD\u00011\u0001@\u0003\t!G\u000f\u0005\u0002\u001e\u0001&\u0011\u0011I\b\u0002\t\t\u0006$\u0018\rV=qK\")1\t\u0002a\u0001\t\u0006AQ\r\u001f9fGR,G\r\u0005\u0002F\u001d:\u0011ai\u0013\b\u0003\u000f&s!\u0001\r%\n\u0003=I!A\u0013\b\u0002\r)\u001cxN\u001c\u001bt\u0013\taU*A\u0004Kg>t\u0017i\u0015+\u000b\u0005)s\u0011BA(Q\u0005\u0019Qe+\u00197vK*\u0011A*\u0014\u000b\u0005KI\u001bF\u000bC\u0003:\u000b\u0001\u0007!\bC\u0003?\u000b\u0001\u0007q\bC\u0003D\u000b\u0001\u0007A)\u0001\u0007uKN$(j]8o\u001dVdG\u000eF\u0002&/bCQA\u0010\u0004A\u0002}BQa\u0011\u0004A\u0002\u0011\u0003")
public class RowJsonSuite
extends SparkFunSuite {
    private final StructType schema = new StructType().add("c1", "string").add("c2", (DataType)IntegerType$.MODULE$);

    private StructType schema() {
        return this.schema;
    }

    private void testJson(String name, Object value, DataType dt, JsonAST.JValue expected) {
        this.test(name, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            GenericRowWithSchema row = new GenericRowWithSchema(new Object[]{value}, new StructType().add("a", dt));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(row.jsonValue());
            JsonAST.JObject $org_scalatest_assert_macro_right = JsonAST.JObject$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)expected)}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowJsonSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
        }, new Position("RowJsonSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
    }

    private void testJson(Object value, DataType dt, JsonAST.JValue expected) {
        this.testJson(new StringBuilder(1).append(dt).append(" ").append(value).toString(), value, dt, expected);
    }

    private void testJsonNull(DataType dt, JsonAST.JValue expected) {
        this.testJson(null, dt, (JsonAST.JValue)JsonAST.JNull$.MODULE$);
    }

    public RowJsonSuite() {
        this.testJsonNull((DataType)IntegerType$.MODULE$, (JsonAST.JValue)JsonAST.JNull$.MODULE$);
        this.testJsonNull((DataType)FloatType$.MODULE$, (JsonAST.JValue)JsonAST.JNull$.MODULE$);
        this.testJsonNull((DataType)new ArrayType((DataType)DoubleType$.MODULE$, true), (JsonAST.JValue)JsonAST.JNull$.MODULE$);
        this.testJson(BoxesRunTime.boxToBoolean((boolean)true), (DataType)BooleanType$.MODULE$, (JsonAST.JValue)JsonAST.JBool$.MODULE$.apply(true));
        this.testJson(BoxesRunTime.boxToBoolean((boolean)false), (DataType)BooleanType$.MODULE$, (JsonAST.JValue)JsonAST.JBool$.MODULE$.apply(false));
        this.testJson(BoxesRunTime.boxToByte((byte)((byte)23)), (DataType)ByteType$.MODULE$, (JsonAST.JValue)new JsonAST.JLong(23L));
        this.testJson(BoxesRunTime.boxToByte((byte)((byte)-126)), (DataType)ByteType$.MODULE$, (JsonAST.JValue)new JsonAST.JLong(-126L));
        this.testJson(BoxesRunTime.boxToShort((short)((short)20281)), (DataType)ShortType$.MODULE$, (JsonAST.JValue)new JsonAST.JLong(20281L));
        this.testJson(BoxesRunTime.boxToShort((short)((short)-8752)), (DataType)ShortType$.MODULE$, (JsonAST.JValue)new JsonAST.JLong(-8752L));
        this.testJson(BoxesRunTime.boxToInteger((int)1078231987), (DataType)IntegerType$.MODULE$, (JsonAST.JValue)new JsonAST.JLong(1078231987L));
        this.testJson(BoxesRunTime.boxToInteger((int)-10), (DataType)IntegerType$.MODULE$, (JsonAST.JValue)new JsonAST.JLong(-10L));
        this.testJson(BoxesRunTime.boxToLong((long)139289832109874199L), (DataType)LongType$.MODULE$, (JsonAST.JValue)new JsonAST.JLong(139289832109874199L));
        this.testJson(BoxesRunTime.boxToLong((long)-7873748239973488L), (DataType)LongType$.MODULE$, (JsonAST.JValue)new JsonAST.JLong(-7873748239973488L));
        this.testJson(BoxesRunTime.boxToFloat((float)1.0232E11f), (DataType)FloatType$.MODULE$, (JsonAST.JValue)new JsonAST.JDouble(1.02319996928E11));
        this.testJson(BoxesRunTime.boxToFloat((float)9.7E-13f), (DataType)FloatType$.MODULE$, (JsonAST.JValue)new JsonAST.JDouble((double)9.7E-13f));
        this.testJson(BoxesRunTime.boxToDouble((double)3.891E98), (DataType)DoubleType$.MODULE$, (JsonAST.JValue)new JsonAST.JDouble(3.891E98));
        this.testJson(BoxesRunTime.boxToDouble((double)-780000.0), (DataType)DoubleType$.MODULE$, (JsonAST.JValue)new JsonAST.JDouble(-780000.0));
        this.testJson(package$.MODULE$.BigDecimal().apply("1092.88"), (DataType)new DecimalType(10, 2), (JsonAST.JValue)new JsonAST.JDecimal(package$.MODULE$.BigDecimal().apply("1092.88")));
        this.testJson(Decimal$.MODULE$.apply("782.0003"), (DataType)new DecimalType(7, 4), (JsonAST.JValue)new JsonAST.JDecimal(package$.MODULE$.BigDecimal().apply("782.0003")));
        this.testJson(new BigDecimal("-77.89"), (DataType)new DecimalType(4, 2), (JsonAST.JValue)new JsonAST.JDecimal(package$.MODULE$.BigDecimal().apply("-77.89")));
        this.testJson("hello world", (DataType)StringType$.MODULE$, (JsonAST.JValue)new JsonAST.JString("hello world"));
        this.testJson("BinaryType", new byte[]{(byte)97, (byte)98}, (DataType)BinaryType$.MODULE$, (JsonAST.JValue)new JsonAST.JString("YWI="));
        this.testJson(Date.valueOf("2019-04-22"), (DataType)DateType$.MODULE$, (JsonAST.JValue)new JsonAST.JString("2019-04-22"));
        this.testJson(LocalDate.of(2018, 5, 14), (DataType)DateType$.MODULE$, (JsonAST.JValue)new JsonAST.JString("2018-05-14"));
        this.testJson(Timestamp.valueOf("2017-01-06 10:22:03.00"), (DataType)TimestampType$.MODULE$, (JsonAST.JValue)new JsonAST.JString("2017-01-06 10:22:03"));
        this.testJson(Timestamp.valueOf("2017-05-30 10:22:03.00").toInstant(), (DataType)TimestampType$.MODULE$, (JsonAST.JValue)new JsonAST.JString("2017-05-30 10:22:03"));
        JsonAST.JLong jLong = new JsonAST.JLong(1L);
        JsonAST.JNull$ jNull$ = JsonAST.JNull$.MODULE$;
        JsonAST.JLong jLong2 = new JsonAST.JLong(77L);
        this.testJson("ArrayType(LongType,true)", new Object[]{BoxesRunTime.boxToLong((long)1L), null, BoxesRunTime.boxToLong((long)77L)}, (DataType)new ArrayType((DataType)LongType$.MODULE$, true), (JsonAST.JValue)new JsonAST.JArray(Nil$.MODULE$.$colon$colon((Object)jLong2).$colon$colon((Object)jNull$).$colon$colon((Object)jLong)));
        JsonAST.JLong jLong3 = new JsonAST.JLong(1L);
        JsonAST.JLong jLong4 = new JsonAST.JLong(-2L);
        JsonAST.JLong jLong5 = new JsonAST.JLong(3L);
        this.testJson(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, -2, 3})), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), (JsonAST.JValue)new JsonAST.JArray(Nil$.MODULE$.$colon$colon((Object)jLong5).$colon$colon((Object)jLong4).$colon$colon((Object)jLong3)));
        this.testJson(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"b"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)"d"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"e"), null)})), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$, true), (JsonAST.JValue)JsonAST.JObject$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)new JsonAST.JString("b")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)new JsonAST.JString("d")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"e"), (Object)JsonAST.JNull$.MODULE$)})));
        JsonAST.JObject jObject = JsonAST.JObject$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key"), (Object)new JsonAST.JLong(1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)new JsonAST.JString("b"))}));
        JsonAST.JObject jObject2 = JsonAST.JObject$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key"), (Object)new JsonAST.JLong(2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)new JsonAST.JString("d"))}));
        JsonAST.JObject jObject3 = JsonAST.JObject$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key"), (Object)new JsonAST.JLong(3L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)JsonAST.JNull$.MODULE$)}));
        this.testJson(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"b"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"d"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), null)})), (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true), (JsonAST.JValue)new JsonAST.JArray(Nil$.MODULE$.$colon$colon((Object)jObject3).$colon$colon((Object)jObject2).$colon$colon((Object)jObject)));
        this.testJson(new GenericRowWithSchema(new Object[]{"1", BoxesRunTime.boxToInteger((int)2)}, this.schema()), (DataType)this.schema(), (JsonAST.JValue)JsonAST.JObject$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c1"), (Object)new JsonAST.JString("1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c2"), (Object)new JsonAST.JLong(2L))})));
        JsonAST.JDouble jDouble = new JsonAST.JDouble(3.4);
        JsonAST.JDouble jDouble2 = new JsonAST.JDouble(8.98);
        this.testJson("UDT", new ExamplePoint(3.4, 8.98), (DataType)new ExamplePointUDT(), (JsonAST.JValue)new JsonAST.JArray(Nil$.MODULE$.$colon$colon((Object)jDouble2).$colon$colon((Object)jDouble)));
        this.test("no schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            IllegalArgumentException e = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a"})).jsonValue(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RowJsonSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = "requires a non-null schema";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowJsonSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        }, new Position("RowJsonSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
        this.test("unsupported type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            IllegalArgumentException e = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> {
                GenericRowWithSchema row = new GenericRowWithSchema(new Object[]{new Tuple2.mcII.sp(1, 2)}, new StructType().add("a", (DataType)new ObjectType(Tuple2.class)));
                return row.jsonValue();
            }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RowJsonSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = "Failed to convert value";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowJsonSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
        }, new Position("RowJsonSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
    }
}

