/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.types;

import org.apache.spark.annotation.Stable;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

@Stable
public final class DecimalType$
extends AbstractDataType
implements Serializable {
    public static DecimalType$ MODULE$;
    private final int MAX_PRECISION;
    private final int MAX_SCALE;
    private final DecimalType SYSTEM_DEFAULT;
    private final DecimalType USER_DEFAULT;
    private final int MINIMUM_ADJUSTED_SCALE;
    private final DecimalType BooleanDecimal;
    private final DecimalType ByteDecimal;
    private final DecimalType ShortDecimal;
    private final DecimalType IntDecimal;
    private final DecimalType LongDecimal;
    private final DecimalType FloatDecimal;
    private final DecimalType DoubleDecimal;
    private final DecimalType BigIntDecimal;

    static {
        new DecimalType$();
    }

    public int MAX_PRECISION() {
        return this.MAX_PRECISION;
    }

    public int MAX_SCALE() {
        return this.MAX_SCALE;
    }

    public DecimalType SYSTEM_DEFAULT() {
        return this.SYSTEM_DEFAULT;
    }

    public DecimalType USER_DEFAULT() {
        return this.USER_DEFAULT;
    }

    public int MINIMUM_ADJUSTED_SCALE() {
        return this.MINIMUM_ADJUSTED_SCALE;
    }

    public DecimalType BooleanDecimal() {
        return this.BooleanDecimal;
    }

    public DecimalType ByteDecimal() {
        return this.ByteDecimal;
    }

    public DecimalType ShortDecimal() {
        return this.ShortDecimal;
    }

    public DecimalType IntDecimal() {
        return this.IntDecimal;
    }

    public DecimalType LongDecimal() {
        return this.LongDecimal;
    }

    public DecimalType FloatDecimal() {
        return this.FloatDecimal;
    }

    public DecimalType DoubleDecimal() {
        return this.DoubleDecimal;
    }

    public DecimalType BigIntDecimal() {
        return this.BigIntDecimal;
    }

    public DecimalType forType(DataType dataType) {
        DataType dataType2 = dataType;
        if (ByteType$.MODULE$.equals(dataType2)) {
            return this.ByteDecimal();
        }
        if (ShortType$.MODULE$.equals(dataType2)) {
            return this.ShortDecimal();
        }
        if (IntegerType$.MODULE$.equals(dataType2)) {
            return this.IntDecimal();
        }
        if (LongType$.MODULE$.equals(dataType2)) {
            return this.LongDecimal();
        }
        if (FloatType$.MODULE$.equals(dataType2)) {
            return this.FloatDecimal();
        }
        if (DoubleType$.MODULE$.equals(dataType2)) {
            return this.DoubleDecimal();
        }
        throw new MatchError((Object)dataType2);
    }

    public DecimalType fromLiteral(Literal literal) {
        Object object = literal.value();
        if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            return this.fromDecimal(Decimal$.MODULE$.apply(scala.package$.MODULE$.BigDecimal().apply((int)s)));
        }
        if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            return this.fromDecimal(Decimal$.MODULE$.apply(scala.package$.MODULE$.BigDecimal().apply(n)));
        }
        if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            return this.fromDecimal(Decimal$.MODULE$.apply(scala.package$.MODULE$.BigDecimal().apply(l)));
        }
        return this.forType(literal.dataType());
    }

    public DecimalType fromDecimal(Decimal d) {
        return new DecimalType(d.precision(), d.scale());
    }

    public DecimalType bounded(int precision, int scale) {
        return new DecimalType(package$.MODULE$.min(precision, this.MAX_PRECISION()), package$.MODULE$.min(scale, this.MAX_SCALE()));
    }

    public void checkNegativeScale(int scale) {
        if (scale < 0 && !SQLConf$.MODULE$.get().allowNegativeScaleOfDecimalEnabled()) {
            throw QueryCompilationErrors$.MODULE$.negativeScaleNotAllowedError(scale);
        }
    }

    public DecimalType adjustPrecisionScale(int precision, int scale) {
        this.checkNegativeScale(scale);
        Predef$.MODULE$.assert(precision >= scale);
        if (precision <= this.MAX_PRECISION()) {
            return new DecimalType(precision, scale);
        }
        if (scale < 0) {
            return new DecimalType(this.MAX_PRECISION(), scale);
        }
        int intDigits = precision - scale;
        int minScaleValue = Math.min(scale, this.MINIMUM_ADJUSTED_SCALE());
        int adjustedScale = Math.max(this.MAX_PRECISION() - intDigits, minScaleValue);
        return new DecimalType(this.MAX_PRECISION(), adjustedScale);
    }

    @Override
    public DataType defaultConcreteType() {
        return this.SYSTEM_DEFAULT();
    }

    @Override
    public boolean acceptsType(DataType other) {
        return other instanceof DecimalType;
    }

    @Override
    public String simpleString() {
        return "decimal";
    }

    public boolean is32BitDecimalType(DataType dt) {
        DataType dataType = dt;
        if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            return decimalType.precision() <= Decimal$.MODULE$.MAX_INT_DIGITS();
        }
        return false;
    }

    public boolean is64BitDecimalType(DataType dt) {
        DataType dataType = dt;
        if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            return decimalType.precision() <= Decimal$.MODULE$.MAX_LONG_DIGITS();
        }
        return false;
    }

    public boolean isByteArrayDecimalType(DataType dt) {
        DataType dataType = dt;
        if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            return decimalType.precision() > Decimal$.MODULE$.MAX_LONG_DIGITS();
        }
        return false;
    }

    public boolean unapply(DataType t) {
        return t instanceof DecimalType;
    }

    public boolean unapply(Expression e) {
        return e.dataType() instanceof DecimalType;
    }

    public DecimalType apply(int precision, int scale) {
        return new DecimalType(precision, scale);
    }

    public Option<Tuple2<Object, Object>> unapply(DecimalType x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2.mcII.sp(x$0.precision(), x$0.scale()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DecimalType$() {
        MODULE$ = this;
        this.MAX_PRECISION = 38;
        this.MAX_SCALE = 38;
        this.SYSTEM_DEFAULT = new DecimalType(this.MAX_PRECISION(), 18);
        this.USER_DEFAULT = new DecimalType(10, 0);
        this.MINIMUM_ADJUSTED_SCALE = 6;
        this.BooleanDecimal = new DecimalType(1, 0);
        this.ByteDecimal = new DecimalType(3, 0);
        this.ShortDecimal = new DecimalType(5, 0);
        this.IntDecimal = new DecimalType(10, 0);
        this.LongDecimal = new DecimalType(20, 0);
        this.FloatDecimal = new DecimalType(14, 7);
        this.DoubleDecimal = new DecimalType(30, 15);
        this.BigIntDecimal = new DecimalType(38, 0);
    }
}

