/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.RowOrdering$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.types.AnsiIntervalType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class TypeUtils$ {
    public static TypeUtils$ MODULE$;

    static {
        new TypeUtils$();
    }

    public TypeCheckResult checkForNumericExpr(DataType dt, String caller) {
        block3: {
            block2: {
                if (dt instanceof NumericType) break block2;
                DataType dataType = dt;
                NullType$ nullType$ = NullType$.MODULE$;
                if (dataType != null ? !dataType.equals(nullType$) : nullType$ != null) break block3;
            }
            return TypeCheckResult$TypeCheckSuccess$.MODULE$;
        }
        return new TypeCheckResult.TypeCheckFailure(new StringBuilder(29).append(caller).append(" requires numeric types, not ").append(dt.catalogString()).toString());
    }

    public TypeCheckResult checkForOrderingExpr(DataType dt, String caller) {
        if (RowOrdering$.MODULE$.isOrderable(dt)) {
            return TypeCheckResult$TypeCheckSuccess$.MODULE$;
        }
        return new TypeCheckResult.TypeCheckFailure(new StringBuilder(35).append(caller).append(" does not support ordering on type ").append(dt.catalogString()).toString());
    }

    public TypeCheckResult checkForSameTypeInputExpr(Seq<DataType> types, String caller) {
        if (TypeCoercion$.MODULE$.haveSameType(types)) {
            return TypeCheckResult$TypeCheckSuccess$.MODULE$;
        }
        return new TypeCheckResult.TypeCheckFailure(new StringBuilder(48).append("input to ").append(caller).append(" should all be the same type, but it's ").append(((TraversableOnce)types.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.catalogString(), Seq$.MODULE$.canBuildFrom())).mkString("[", ", ", "]")).toString());
    }

    public TypeCheckResult checkForMapKeyType(DataType keyType) {
        if (keyType.existsRecursively((Function1<DataType, Object>)(Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TypeUtils$.$anonfun$checkForMapKeyType$1(x$2)))) {
            return new TypeCheckResult.TypeCheckFailure("The key of map cannot be/contain map.");
        }
        return TypeCheckResult$TypeCheckSuccess$.MODULE$;
    }

    public TypeCheckResult checkForAnsiIntervalOrNumericType(DataType dt, String funcName) {
        DataType dataType = dt;
        if (dataType instanceof AnsiIntervalType ? true : NullType$.MODULE$.equals(dataType)) {
            return TypeCheckResult$TypeCheckSuccess$.MODULE$;
        }
        if (dataType instanceof NumericType) {
            return TypeCheckResult$TypeCheckSuccess$.MODULE$;
        }
        return new TypeCheckResult.TypeCheckFailure(new StringBuilder(50).append("function ").append(funcName).append(" requires numeric or interval types, not ").append(dataType.catalogString()).toString());
    }

    public Numeric<Object> getNumeric(DataType t, boolean exactNumericRequired) {
        if (exactNumericRequired) {
            return ((NumericType)t).exactNumeric();
        }
        return ((NumericType)t).numeric();
    }

    public boolean getNumeric$default$2() {
        return false;
    }

    public Ordering<Object> getInterpretedOrdering(DataType t) {
        DataType dataType;
        while (true) {
            if ((dataType = t) instanceof AtomicType) {
                AtomicType atomicType = (AtomicType)dataType;
                return atomicType.ordering();
            }
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                return arrayType.interpretedOrdering();
            }
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                return structType.interpretedOrdering();
            }
            if (!(dataType instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType;
            t = userDefinedType.sqlType();
        }
        throw new MatchError((Object)dataType);
    }

    public boolean typeWithProperEquals(DataType dataType) {
        DataType dataType2 = dataType;
        if (BinaryType$.MODULE$.equals(dataType2)) {
            return false;
        }
        return dataType2 instanceof AtomicType;
    }

    public void failWithIntervalType(DataType dataType) {
        this.invokeOnceForInterval(dataType, false, (Function0<BoxedUnit>)(Function0 & Serializable & scala.Serializable)() -> {
            throw QueryCompilationErrors$.MODULE$.cannotUseIntervalTypeInTableSchemaError();
        });
    }

    public void invokeOnceForInterval(DataType dataType2, boolean forbidAnsiIntervals, Function0<BoxedUnit> f) {
        if (dataType2.existsRecursively((Function1<DataType, Object>)(Function1 & Serializable & scala.Serializable)dataType -> BoxesRunTime.boxToBoolean((boolean)TypeUtils$.isInterval$1(dataType, forbidAnsiIntervals)))) {
            f.apply$mcV$sp();
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$checkForMapKeyType$1(DataType x$2) {
        return x$2 instanceof MapType;
    }

    private static final boolean isInterval$1(DataType dataType, boolean forbidAnsiIntervals$1) {
        DataType dataType2 = dataType;
        if (dataType2 instanceof AnsiIntervalType) {
            return forbidAnsiIntervals$1;
        }
        return CalendarIntervalType$.MODULE$.equals(dataType2);
    }

    private TypeUtils$() {
        MODULE$ = this;
    }
}

