/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.expressions.ArrayTransform;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStruct;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GetStructField;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction$;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.MapFromArrays;
import org.apache.spark.sql.catalyst.expressions.MapKeys;
import org.apache.spark.sql.catalyst.expressions.MapValues;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable$;
import org.apache.spark.sql.catalyst.expressions.StringRPad;
import org.apache.spark.sql.catalyst.expressions.StringRPad$;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke$;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.util.CharVarcharCodegenUtils;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.VarcharType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class CharVarcharUtils$
implements Logging {
    public static CharVarcharUtils$ MODULE$;
    private final String CHAR_VARCHAR_TYPE_STRING_METADATA_KEY;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new CharVarcharUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String CHAR_VARCHAR_TYPE_STRING_METADATA_KEY() {
        return this.CHAR_VARCHAR_TYPE_STRING_METADATA_KEY;
    }

    public StructType replaceCharVarcharWithStringInSchema(StructType st) {
        return StructType$.MODULE$.apply((Seq<StructField>)((Seq)st.map((Function1 & Serializable & scala.Serializable)field -> {
            if (MODULE$.hasCharVarchar(field.dataType())) {
                Metadata metadata = new MetadataBuilder().withMetadata(field.metadata()).putString(MODULE$.CHAR_VARCHAR_TYPE_STRING_METADATA_KEY(), field.dataType().catalogString()).build();
                DataType x$1 = MODULE$.replaceCharVarcharWithString(field.dataType());
                Metadata x$2 = metadata;
                String x$3 = field.copy$default$1();
                boolean x$4 = field.copy$default$3();
                return field.copy(x$3, x$1, x$4, x$2);
            }
            return field;
        }, Seq$.MODULE$.canBuildFrom())));
    }

    public boolean hasCharVarchar(DataType dt) {
        return dt.existsRecursively((Function1<DataType, Object>)(Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)CharVarcharUtils$.$anonfun$hasCharVarchar$1(f)));
    }

    public DataType failIfHasCharVarchar(DataType dt) {
        if (!SQLConf$.MODULE$.get().charVarcharAsString() && this.hasCharVarchar(dt)) {
            throw QueryCompilationErrors$.MODULE$.charOrVarcharTypeAsStringUnsupportedError();
        }
        return this.replaceCharVarcharWithString(dt);
    }

    public DataType replaceCharVarcharWithString(DataType dt) {
        DataType dataType = dt;
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType et = arrayType.elementType();
            boolean nullable = arrayType.containsNull();
            return new ArrayType(this.replaceCharVarcharWithString(et), nullable);
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType kt = mapType.keyType();
            DataType vt = mapType.valueType();
            boolean nullable = mapType.valueContainsNull();
            return new MapType(this.replaceCharVarcharWithString(kt), this.replaceCharVarcharWithString(vt), nullable);
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            return new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).map((Function1 & Serializable & scala.Serializable)field -> {
                DataType x$1 = MODULE$.replaceCharVarcharWithString(field.dataType());
                String x$2 = field.copy$default$1();
                boolean x$3 = field.copy$default$3();
                Metadata x$4 = field.copy$default$4();
                return field.copy(x$2, x$1, x$3, x$4);
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        }
        if (dataType instanceof CharType) {
            return StringType$.MODULE$;
        }
        if (dataType instanceof VarcharType) {
            return StringType$.MODULE$;
        }
        return dt;
    }

    public DataType replaceCharWithVarchar(DataType dt) {
        DataType dataType = dt;
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType et = arrayType.elementType();
            boolean nullable = arrayType.containsNull();
            return new ArrayType(this.replaceCharWithVarchar(et), nullable);
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType kt = mapType.keyType();
            DataType vt = mapType.valueType();
            boolean nullable = mapType.valueContainsNull();
            return new MapType(this.replaceCharWithVarchar(kt), this.replaceCharWithVarchar(vt), nullable);
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            return new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).map((Function1 & Serializable & scala.Serializable)field -> {
                DataType x$1 = MODULE$.replaceCharWithVarchar(field.dataType());
                String x$2 = field.copy$default$1();
                boolean x$3 = field.copy$default$3();
                Metadata x$4 = field.copy$default$4();
                return field.copy(x$2, x$1, x$3, x$4);
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        }
        if (dataType instanceof CharType) {
            CharType charType = (CharType)dataType;
            int length = charType.length();
            return new VarcharType(length);
        }
        return dt;
    }

    public DataType replaceCharVarcharWithStringForCast(DataType dt) {
        if (SQLConf$.MODULE$.get().charVarcharAsString()) {
            return this.replaceCharVarcharWithString(dt);
        }
        if (this.hasCharVarchar(dt)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(255).append("The Spark cast operator does not support char/varchar type and simply treats them as string type. Please use string type directly to avoid confusion. Otherwise,").append(" you can set ").append(SQLConf$.MODULE$.LEGACY_CHAR_VARCHAR_AS_STRING().key()).append(" to true, so that Spark treat").append(" them as string type as same as Spark 3.0 and earlier").toString());
            return this.replaceCharVarcharWithString(dt);
        }
        return dt;
    }

    public AttributeReference cleanAttrMetadata(AttributeReference attr) {
        Metadata cleaned = new MetadataBuilder().withMetadata(attr.metadata()).remove(this.CHAR_VARCHAR_TYPE_STRING_METADATA_KEY()).build();
        return attr.withMetadata(cleaned);
    }

    public Option<String> getRawTypeString(Metadata metadata) {
        if (metadata.contains(this.CHAR_VARCHAR_TYPE_STRING_METADATA_KEY())) {
            return new Some((Object)metadata.getString(this.CHAR_VARCHAR_TYPE_STRING_METADATA_KEY()));
        }
        return None$.MODULE$;
    }

    public Option<DataType> getRawType(Metadata metadata) {
        return this.getRawTypeString(metadata).map((Function1 & Serializable & scala.Serializable)sqlText -> CatalystSqlParser$.MODULE$.parseDataType((String)sqlText));
    }

    public StructType getRawSchema(StructType schema) {
        Seq fields = (Seq)schema.map((Function1 & Serializable & scala.Serializable)field -> (StructField)MODULE$.getRawType(field.metadata()).map((Function1 & Serializable & scala.Serializable)dt -> {
            DataType x$1 = dt;
            String x$2 = field.copy$default$1();
            boolean x$3 = field.copy$default$3();
            Metadata x$4 = field.copy$default$4();
            return field.copy(x$2, x$1, x$3, x$4);
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> field), Seq$.MODULE$.canBuildFrom());
        return StructType$.MODULE$.apply((Seq<StructField>)fields);
    }

    public StructType getRawSchema(StructType schema, SQLConf conf) {
        Seq fields = (Seq)schema.map((Function1 & Serializable & scala.Serializable)field -> (StructField)MODULE$.getRawType(field.metadata()).map((Function1 & Serializable & scala.Serializable)dt -> {
            if (BoxesRunTime.unboxToBoolean((Object)conf.getConf(SQLConf$.MODULE$.CHAR_AS_VARCHAR()))) {
                Metadata metadata = new MetadataBuilder().withMetadata(field.metadata()).remove(MODULE$.CHAR_VARCHAR_TYPE_STRING_METADATA_KEY()).build();
                DataType x$1 = MODULE$.replaceCharWithVarchar((DataType)dt);
                Metadata x$2 = metadata;
                String x$3 = field.copy$default$1();
                boolean x$4 = field.copy$default$3();
                return field.copy(x$3, x$1, x$4, x$2);
            }
            DataType x$5 = dt;
            String x$6 = field.copy$default$1();
            boolean x$7 = field.copy$default$3();
            Metadata x$8 = field.copy$default$4();
            return field.copy(x$6, x$5, x$7, x$8);
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> field), Seq$.MODULE$.canBuildFrom());
        return StructType$.MODULE$.apply((Seq<StructField>)fields);
    }

    public Expression stringLengthCheck(Expression expr, Attribute targetAttr) {
        return (Expression)this.getRawType(targetAttr.metadata()).map((Function1 & Serializable & scala.Serializable)rawType -> MODULE$.stringLengthCheck(expr, (DataType)rawType)).getOrElse((Function0 & Serializable & scala.Serializable)() -> expr);
    }

    public Expression stringLengthCheck(Expression expr, DataType dt) {
        DataType dataType = dt;
        if (dataType instanceof CharType) {
            CharType charType = (CharType)dataType;
            int length = charType.length();
            Class<CharVarcharCodegenUtils> x$1 = CharVarcharCodegenUtils.class;
            StringType$ x$2 = StringType$.MODULE$;
            String x$3 = "charTypeWriteSideCheck";
            Expression expression = expr;
            Literal literal = Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)length));
            List x$4 = Nil$.MODULE$.$colon$colon((Object)literal).$colon$colon((Object)expression);
            boolean x$5 = false;
            Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
            boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
            boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
            return new StaticInvoke(x$1, x$2, x$3, (Seq<Expression>)x$4, x$6, x$7, x$5, x$8);
        }
        if (dataType instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)dataType;
            int length = varcharType.length();
            Class<CharVarcharCodegenUtils> x$9 = CharVarcharCodegenUtils.class;
            StringType$ x$10 = StringType$.MODULE$;
            String x$11 = "varcharTypeWriteSideCheck";
            Expression expression = expr;
            Literal literal = Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)length));
            List x$12 = Nil$.MODULE$.$colon$colon((Object)literal).$colon$colon((Object)expression);
            boolean x$13 = false;
            Seq<AbstractDataType> x$14 = StaticInvoke$.MODULE$.apply$default$5();
            boolean x$15 = StaticInvoke$.MODULE$.apply$default$6();
            boolean x$16 = StaticInvoke$.MODULE$.apply$default$8();
            return new StaticInvoke(x$9, x$10, x$11, (Seq<Expression>)x$12, x$14, x$15, x$13, x$16);
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            CreateNamedStruct struct = new CreateNamedStruct((Seq<Expression>)((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    StructField f = (StructField)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    return (Seq)new .colon.colon((Object)Literal$.MODULE$.apply(f.name()), (List)new .colon.colon((Object)MODULE$.stringLengthCheck((Expression)new GetStructField(expr, i, (Option<String>)new Some((Object)f.name())), f.dataType()), (List)Nil$.MODULE$));
                }
                throw new MatchError((Object)tuple2);
            }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
            if (expr.nullable()) {
                return new If(new IsNull(expr), new Literal(null, struct.dataType()), struct);
            }
            return struct;
        }
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType et = arrayType.elementType();
            boolean containsNull = arrayType.containsNull();
            return this.stringLengthCheckInArray(expr, et, containsNull);
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType kt = mapType.keyType();
            DataType vt = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            Expression newKeys = this.stringLengthCheckInArray(new MapKeys(expr), kt, false);
            Expression newValues = this.stringLengthCheckInArray(new MapValues(expr), vt, valueContainsNull);
            return new MapFromArrays(newKeys, newValues);
        }
        return expr;
    }

    private Expression stringLengthCheckInArray(Expression arr, DataType et, boolean containsNull) {
        NamedLambdaVariable param = new NamedLambdaVariable("x", this.replaceCharVarcharWithString(et), containsNull, NamedLambdaVariable$.MODULE$.apply$default$4(), NamedLambdaVariable$.MODULE$.apply$default$5());
        LambdaFunction func = new LambdaFunction(this.stringLengthCheck((Expression)param, et), (Seq<NamedExpression>)((Seq)new .colon.colon((Object)param, (List)Nil$.MODULE$)), LambdaFunction$.MODULE$.apply$default$3());
        return new ArrayTransform(arr, func);
    }

    public Seq<Expression> addPaddingInStringComparison(Seq<Attribute> attrs2) {
        Seq rawTypes = (Seq)attrs2.map((Function1 & Serializable & scala.Serializable)attr -> MODULE$.getRawType(attr.metadata()), Seq$.MODULE$.canBuildFrom());
        if (rawTypes.exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isEmpty()))) {
            return attrs2;
        }
        DataType typeWithTargetCharLength = (DataType)((TraversableOnce)rawTypes.map((Function1 & Serializable & scala.Serializable)x$6 -> (DataType)x$6.get(), Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(type1, type2) -> MODULE$.typeWithWiderCharLength((DataType)type1, (DataType)type2));
        return (Seq)((TraversableLike)attrs2.zip((GenIterable)rawTypes.map((Function1 & Serializable & scala.Serializable)x$7 -> (DataType)x$7.get(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Attribute attr = (Attribute)tuple2._1();
                DataType rawType = (DataType)tuple2._2();
                return (Expression)MODULE$.padCharToTargetLength(attr, rawType, typeWithTargetCharLength).getOrElse((Function0 & Serializable & scala.Serializable)() -> attr);
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
    }

    private DataType typeWithWiderCharLength(DataType type1, DataType type2) {
        Tuple2 tuple2 = new Tuple2((Object)type1, (Object)type2);
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType2 = (DataType)tuple2._2();
            if (dataType instanceof CharType) {
                CharType charType = (CharType)dataType;
                int len1 = charType.length();
                if (dataType2 instanceof CharType) {
                    CharType charType2 = (CharType)dataType2;
                    int len2 = charType2.length();
                    return new CharType(package$.MODULE$.max(len1, len2));
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType3 = (DataType)tuple2._2();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructField[] fields1 = structType.fields();
                if (dataType3 instanceof StructType) {
                    StructType structType2 = (StructType)dataType3;
                    StructField[] fields2 = structType2.fields();
                    Predef$.MODULE$.assert(fields1.length == fields2.length);
                    return new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields1)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])fields2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 != null) {
                            StructField left = (StructField)tuple2._1();
                            StructField right = (StructField)tuple2._2();
                            return new StructField("", MODULE$.typeWithWiderCharLength(left.dataType(), right.dataType()), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                        }
                        throw new MatchError((Object)tuple2);
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType4 = (DataType)tuple2._2();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType et1 = arrayType.elementType();
                if (dataType4 instanceof ArrayType) {
                    ArrayType arrayType2 = (ArrayType)dataType4;
                    DataType et2 = arrayType2.elementType();
                    return ArrayType$.MODULE$.apply(this.typeWithWiderCharLength(et1, et2));
                }
            }
        }
        return NullType$.MODULE$;
    }

    private Option<Expression> padCharToTargetLength(Expression expr, DataType rawType, DataType typeWithTargetCharLength) {
        Tuple2 tuple2 = new Tuple2((Object)rawType, (Object)typeWithTargetCharLength);
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType2 = (DataType)tuple2._2();
            if (dataType instanceof CharType) {
                CharType charType;
                int target;
                CharType charType2 = (CharType)dataType;
                int len = charType2.length();
                if (dataType2 instanceof CharType && (target = (charType = (CharType)dataType2).length()) > len) {
                    return new Some((Object)new StringRPad(expr, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)target)), StringRPad$.MODULE$.apply$default$3()));
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType3 = (DataType)tuple2._2();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructField[] fields = structType.fields();
                if (dataType3 instanceof StructType) {
                    StructType structType2 = (StructType)dataType3;
                    StructField[] targets = structType2.fields();
                    Predef$.MODULE$.assert(fields.length == targets.length);
                    boolean needPadding = false;
                    ArrayBuffer createStructExprs = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
                    for (int i = 0; i < fields.length; ++i) {
                        StructField field = fields[i];
                        GetStructField fieldExpr = new GetStructField(expr, i, (Option<String>)new Some((Object)field.name()));
                        Option<Expression> padded2 = this.padCharToTargetLength(fieldExpr, field.dataType(), targets[i].dataType());
                        needPadding = padded2.isDefined();
                        createStructExprs.$plus$eq((Object)Literal$.MODULE$.apply(field.name()));
                        createStructExprs.$plus$eq(padded2.getOrElse((Function0 & Serializable & scala.Serializable)() -> fieldExpr));
                    }
                    if (needPadding) {
                        return new Some((Object)new CreateNamedStruct((Seq<Expression>)createStructExprs.toSeq()));
                    }
                    return None$.MODULE$;
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType4 = (DataType)tuple2._2();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType et = arrayType.elementType();
                boolean containsNull = arrayType.containsNull();
                if (dataType4 instanceof ArrayType) {
                    ArrayType arrayType2 = (ArrayType)dataType4;
                    DataType target = arrayType2.elementType();
                    NamedLambdaVariable param = new NamedLambdaVariable("x", this.replaceCharVarcharWithString(et), containsNull, NamedLambdaVariable$.MODULE$.apply$default$4(), NamedLambdaVariable$.MODULE$.apply$default$5());
                    return this.padCharToTargetLength(param, et, target).map((Function1 & Serializable & scala.Serializable)padded -> {
                        LambdaFunction func = new LambdaFunction((Expression)padded, (Seq<NamedExpression>)((Seq)new .colon.colon((Object)param, (List)Nil$.MODULE$)), LambdaFunction$.MODULE$.apply$default$3());
                        return new ArrayTransform(expr, func);
                    });
                }
            }
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$hasCharVarchar$1(DataType f) {
        return f instanceof CharType || f instanceof VarcharType;
    }

    private CharVarcharUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.CHAR_VARCHAR_TYPE_STRING_METADATA_KEY = "__CHAR_VARCHAR_TYPE_STRING";
    }
}

