/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.plans.logical;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.MultiInstanceRelation;
import org.apache.spark.sql.catalyst.expressions.Ascending$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap$;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.Descending$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.SortDirection;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SortOrder$;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat$;
import org.apache.spark.sql.catalyst.plans.logical.Histogram;
import org.apache.spark.sql.catalyst.plans.logical.HistogramBin;
import org.apache.spark.sql.catalyst.plans.logical.LeafNode;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Range$;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.plans.logical.Statistics$;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.types.LongType$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple6;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ExpressionDescription(usage="\n    _FUNC_(start: long, end: long, step: long, numSlices: integer)\n    _FUNC_(start: long, end: long, step: long)\n    _FUNC_(start: long, end: long)\n    _FUNC_(end: long)", examples="\n    Examples:\n      > SELECT * FROM _FUNC_(1);\n        +---+\n        | id|\n        +---+\n        |  0|\n        +---+\n      > SELECT * FROM _FUNC_(0, 2);\n        +---+\n        |id |\n        +---+\n        |0  |\n        |1  |\n        +---+\n      > SELECT * FROM _FUNC_(0, 4, 2);\n        +---+\n        |id |\n        +---+\n        |0  |\n        |2  |\n        +---+\n  ", since="2.0.0", group="table_funcs")
@ScalaSignature(bytes="\u0006\u0001\tew!\u0002\u001e<\u0011\u0003Qe!\u0002'<\u0011\u0003i\u0005\"B,\u0002\t\u0003A\u0006\"B-\u0002\t\u0003Q\u0006b\u0002B4\u0003\u0011\u0005\u0011\u0011\u0001\u0005\b\u0005S\nA\u0011\u0002B6\u0011\u001d\u0011\u0019(\u0001C\u0005\u0005kBqA!(\u0002\t\u0003\u0011y\nC\u0004\u0003$\u0006!\tA!*\t\u0011e\u000b\u0011\u0011!CA\u0005SC\u0011Ba.\u0002#\u0003%\t!!>\t\u0013\te\u0016!%A\u0005\u0002\u0005m\b\"\u0003B^\u0003\u0005\u0005I\u0011\u0011B_\u0011%\u0011Y-AI\u0001\n\u0003\t)\u0010C\u0005\u0003N\u0006\t\n\u0011\"\u0001\u0002|\"I!qZ\u0001\u0002\u0002\u0013%!\u0011\u001b\u0004\u0005\u0019n\u0002E\f\u0003\u0005m!\tU\r\u0011\"\u0001n\u0011!\t\bC!E!\u0002\u0013q\u0007\u0002\u0003:\u0011\u0005+\u0007I\u0011A7\t\u0011M\u0004\"\u0011#Q\u0001\n9D\u0001\u0002\u001e\t\u0003\u0016\u0004%\t!\u001c\u0005\tkB\u0011\t\u0012)A\u0005]\"Aa\u000f\u0005BK\u0002\u0013\u0005q\u000f\u0003\u0005\u007f!\tE\t\u0015!\u0003y\u0011%y\bC!f\u0001\n\u0003\n\t\u0001\u0003\u0006\u0002(A\u0011\t\u0012)A\u0005\u0003\u0007A!\"!\u000b\u0011\u0005+\u0007I\u0011IA\u0016\u0011)\t\u0019\u0004\u0005B\tB\u0003%\u0011Q\u0006\u0005\u0007/B!\t!!\u000e\t\r]\u0003B\u0011AA\"\u0011\u00199\u0006\u0003\"\u0001\u0002T!1q\u000b\u0005C\u0001\u00037Baa\u0016\t\u0005\u0002\u0005\u0005\u0004\"CA3!\t\u0007I\u0011AA4\u0011!\ty\u0007\u0005Q\u0001\n\u0005%\u0004bBA9!\u0011\u0005\u00111\u000f\u0005\b\u0003\u000b\u0003B\u0011IAD\u0011\u001d\tI\t\u0005C!\u0003\u0017Cq!!%\u0011\t\u0003\n\u0019\nC\u0004\u0002\u0018B!\t%a%\t\u000f\u0005e\u0005\u0003\"\u0011\u0002\u001c\"9\u00111\u0015\t\u0005\n\u0005\u0015\u0006bBAW!\u0011%\u0011q\u0016\u0005\b\u0003k\u0003B\u0011IA\\\u0011%\t\t\rEA\u0001\n\u0003\t\u0019\rC\u0005\u0002RB\t\n\u0011\"\u0001\u0002T\"I\u0011\u0011\u001e\t\u0012\u0002\u0013\u0005\u00111\u001b\u0005\n\u0003W\u0004\u0012\u0013!C\u0001\u0003'D\u0011\"!<\u0011#\u0003%\t!a<\t\u0013\u0005M\b#%A\u0005\u0002\u0005U\b\"CA}!E\u0005I\u0011AA~\u0011%\ty\u0010EA\u0001\n\u0003\u0012\t\u0001C\u0005\u0003\u0012A\t\t\u0011\"\u0001\u0003\u0014!I!Q\u0003\t\u0002\u0002\u0013\u0005!q\u0003\u0005\n\u0005G\u0001\u0012\u0011!C!\u0005KA\u0011Ba\r\u0011\u0003\u0003%\tA!\u000e\t\u0013\te\u0002#!A\u0005B\tm\u0012!\u0002*b]\u001e,'B\u0001\u001f>\u0003\u001dawnZ5dC2T!AP \u0002\u000bAd\u0017M\\:\u000b\u0005\u0001\u000b\u0015\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\t\u001b\u0015aA:rY*\u0011A)R\u0001\u0006gB\f'o\u001b\u0006\u0003\r\u001e\u000ba!\u00199bG\",'\"\u0001%\u0002\u0007=\u0014xm\u0001\u0001\u0011\u0005-\u000bQ\"A\u001e\u0003\u000bI\u000bgnZ3\u0014\u0007\u0005qE\u000b\u0005\u0002P%6\t\u0001KC\u0001R\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0006K\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001fVK!A\u0016)\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\rqJg.\u001b;?)\u0005Q\u0015!B1qa2LH#C.\u0003`\t\u0005$1\rB3!\tY\u0005c\u0005\u0004\u0011;\u0002\u001c\u0017\u000e\u0016\t\u0003\u0017zK!aX\u001e\u0003\u00171{w-[2bYBc\u0017M\u001c\t\u0003\u0017\u0006L!AY\u001e\u0003\u00111+\u0017M\u001a(pI\u0016\u0004\"\u0001Z4\u000e\u0003\u0015T!AZ \u0002\u0011\u0005t\u0017\r\\=tSNL!\u0001[3\u0003+5+H\u000e^5J]N$\u0018M\\2f%\u0016d\u0017\r^5p]B\u0011qJ[\u0005\u0003WB\u0013q\u0001\u0015:pIV\u001cG/A\u0003ti\u0006\u0014H/F\u0001o!\tyu.\u0003\u0002q!\n!Aj\u001c8h\u0003\u0019\u0019H/\u0019:uA\u0005\u0019QM\u001c3\u0002\t\u0015tG\rI\u0001\u0005gR,\u0007/A\u0003ti\u0016\u0004\b%A\u0005ok6\u001cF.[2fgV\t\u0001\u0010E\u0002PsnL!A\u001f)\u0003\r=\u0003H/[8o!\tyE0\u0003\u0002~!\n\u0019\u0011J\u001c;\u0002\u00159,Xn\u00157jG\u0016\u001c\b%\u0001\u0004pkR\u0004X\u000f^\u000b\u0003\u0003\u0007\u0001b!!\u0002\u0002\u0016\u0005ma\u0002BA\u0004\u0003#qA!!\u0003\u0002\u00105\u0011\u00111\u0002\u0006\u0004\u0003\u001bI\u0015A\u0002\u001fs_>$h(C\u0001R\u0013\r\t\u0019\u0002U\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9\"!\u0007\u0003\u0007M+\u0017OC\u0002\u0002\u0014A\u0003B!!\b\u0002$5\u0011\u0011q\u0004\u0006\u0004\u0003Cy\u0014aC3yaJ,7o]5p]NLA!!\n\u0002 \tI\u0011\t\u001e;sS\n,H/Z\u0001\b_V$\b/\u001e;!\u0003-I7o\u0015;sK\u0006l\u0017N\\4\u0016\u0005\u00055\u0002cA(\u00020%\u0019\u0011\u0011\u0007)\u0003\u000f\t{w\u000e\\3b]\u0006a\u0011n]*ue\u0016\fW.\u001b8hAQi1,a\u000e\u0002:\u0005m\u0012QHA \u0003\u0003BQ\u0001\\\u000fA\u00029DQA]\u000fA\u00029DQ\u0001^\u000fA\u00029DQA^\u000fA\u0002aD\u0001b`\u000f\u0011\u0002\u0003\u0007\u00111\u0001\u0005\n\u0003Si\u0002\u0013!a\u0001\u0003[!\u0012bWA#\u0003\u001b\ny%!\u0015\t\r1t\u0002\u0019AA$!\u0011\ti\"!\u0013\n\t\u0005-\u0013q\u0004\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007B\u0002:\u001f\u0001\u0004\t9\u0005\u0003\u0004u=\u0001\u0007\u0011q\t\u0005\u0007mz\u0001\r!a\u0012\u0015\u000fm\u000b)&a\u0016\u0002Z!1An\ba\u0001\u0003\u000fBaA]\u0010A\u0002\u0005\u001d\u0003B\u0002; \u0001\u0004\t9\u0005F\u0003\\\u0003;\ny\u0006\u0003\u0004mA\u0001\u0007\u0011q\t\u0005\u0007e\u0002\u0002\r!a\u0012\u0015\u0007m\u000b\u0019\u0007\u0003\u0004sC\u0001\u0007\u0011qI\u0001\f]VlW\t\\3nK:$8/\u0006\u0002\u0002jA!\u0011QAA6\u0013\u0011\ti'!\u0007\u0003\r\tKw-\u00138u\u00031qW/\\#mK6,g\u000e^:!\u0003\u0015!xnU)M)\t\t)\b\u0005\u0003\u0002x\u0005}d\u0002BA=\u0003w\u00022!!\u0003Q\u0013\r\ti\bU\u0001\u0007!J,G-\u001a4\n\t\u0005\u0005\u00151\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005u\u0004+A\u0006oK^Len\u001d;b]\u000e,G#A.\u0002\u0019MLW\u000e\u001d7f'R\u0014\u0018N\\4\u0015\t\u0005U\u0014Q\u0012\u0005\u0007\u0003\u001f3\u0003\u0019A>\u0002\u00135\f\u0007PR5fY\u0012\u001c\u0018aB7bqJ{wo]\u000b\u0003\u0003+\u00032aT=o\u0003Mi\u0017\r\u001f*poN\u0004VM\u001d)beRLG/[8o\u00031\u0019w.\u001c9vi\u0016\u001cF/\u0019;t)\t\ti\nE\u0002L\u0003?K1!!)<\u0005)\u0019F/\u0019;jgRL7m]\u0001\u001bG>l\u0007/\u001e;f\u0011&\u001cHo\\4sC6\u001cF/\u0019;jgRL7m\u001d\u000b\u0003\u0003O\u00032aSAU\u0013\r\tYk\u000f\u0002\n\u0011&\u001cHo\\4sC6\fQbZ3u%\u0006tw-\u001a,bYV,Gc\u00018\u00022\"1\u00111W\u0016A\u0002m\fQ!\u001b8eKb\fab\\;uaV$xJ\u001d3fe&tw-\u0006\u0002\u0002:B1\u0011QAA\u000b\u0003w\u0003B!!\b\u0002>&!\u0011qXA\u0010\u0005%\u0019vN\u001d;Pe\u0012,'/\u0001\u0003d_BLH#D.\u0002F\u0006\u001d\u0017\u0011ZAf\u0003\u001b\fy\rC\u0004m[A\u0005\t\u0019\u00018\t\u000fIl\u0003\u0013!a\u0001]\"9A/\fI\u0001\u0002\u0004q\u0007b\u0002<.!\u0003\u0005\r\u0001\u001f\u0005\t\u007f6\u0002\n\u00111\u0001\u0002\u0004!I\u0011\u0011F\u0017\u0011\u0002\u0003\u0007\u0011QF\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t)NK\u0002o\u0003/\\#!!7\u0011\t\u0005m\u0017Q]\u0007\u0003\u0003;TA!a8\u0002b\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003G\u0004\u0016AC1o]>$\u0018\r^5p]&!\u0011q]Ao\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nabY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0002r*\u001a\u00010a6\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u0011q\u001f\u0016\u0005\u0003\u0007\t9.\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\u0005u(\u0006BA\u0017\u0003/\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B\u0002!\u0011\u0011)Aa\u0004\u000e\u0005\t\u001d!\u0002\u0002B\u0005\u0005\u0017\tA\u0001\\1oO*\u0011!QB\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0002\n\u001d\u0011\u0001\u00049s_\u0012,8\r^!sSRLX#A>\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!\u0011\u0004B\u0010!\ry%1D\u0005\u0004\u0005;\u0001&aA!os\"A!\u0011\u0005\u001c\u0002\u0002\u0003\u000710A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005O\u0001bA!\u000b\u00030\teQB\u0001B\u0016\u0015\r\u0011i\u0003U\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\u0019\u0005W\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011Q\u0006B\u001c\u0011%\u0011\t\u0003OA\u0001\u0002\u0004\u0011I\"\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003[\u0011i\u0004C\u0005\u0003\"e\n\t\u00111\u0001\u0003\u001a!\u001a\u0002C!\u0011\u0003H\t%#Q\nB(\u0005'\u0012)F!\u0017\u0003\\A!\u0011Q\u0004B\"\u0013\u0011\u0011)%a\b\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012!1J\u0001\u0002X)\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015ti\u0006\u0014HO\u000f\u0011m_:<G\u0006I3oIj\u0002Cn\u001c8hY\u0001\u001aH/\u001a9;A1|gn\u001a\u0017!]Vl7\u000b\\5dKNT\u0004%\u001b8uK\u001e,'/\u000b\u0006!A\u0001\u0002sLR+O\u0007~C3\u000f^1sij\u0002Cn\u001c8hY\u0001*g\u000e\u001a\u001e!Y>tw\r\f\u0011ti\u0016\u0004(\b\t7p]\u001eL#\u0002\t\u0011!A}3UKT\"`QM$\u0018M\u001d;;A1|gn\u001a\u0017!K:$'\b\t7p]\u001eL#\u0002\t\u0011!A}3UKT\"`Q\u0015tGM\u000f\u0011m_:<\u0017&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\u0011\t&\u0001Bl\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002R\u0003E\u0012*P\u001b\u0002zf)\u0016(D?\"\n\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!W5jSf\u000b\u0006!A\u0001\u0002\u0003\u0005\t\u0011!y\u0002JG\r \u0006!A\u0001\u0002\u0003\u0005\t\u0011!W5jSf\u000b\u0006!A\u0001\u0002\u0003\u0005\t\u0011!y\u0002\u0002\u0003\u0007 \u0006!A\u0001\u0002\u0003\u0005\t\u0011!W5jSf\u000b\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!U\u00012%kT'!?\u001a+fjQ0)a1\u0002#'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!A-jS&L\u0016\u000bA\u0001\u0002\u0003\u0005\t\u0011!AqLG\r\t?\u000bA\u0001\u0002\u0003\u0005\t\u0011!A-jS&L\u0016\u000bA\u0001\u0002\u0003\u0005\t\u0011!Aq\u0004\u0004\u0005\t?\u000bA\u0001\u0002\u0003\u0005\t\u0011!Aq\f\u0004\u0005\t?\u000bA\u0001\u0002\u0003\u0005\t\u0011!A-jS&L\u0016\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA)\u0002cIU(NA}3UKT\"`QAb\u0003\u0005\u000e\u0017!e%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005I\u0016.[5Z#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t?jI\u0002b(\u0002\t\u0011!A\u0001\u0002\u0003\u0005I\u0016.[5Z#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t?1A\u0001b(\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t?3A\u0001b(\u0002\t\u0011!A\u0001\u0002\u0003\u0005I\u0016.[5Z#\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\t]\u0013!\u0002\u001a/a9\u0002\u0014!B4s_V\u0004\u0018E\u0001B/\u0003-!\u0018M\u00197f?\u001a,hnY:\t\u000b1\u001c\u0001\u0019\u00018\t\u000bI\u001c\u0001\u0019\u00018\t\u000bQ\u001c\u0001\u0019\u00018\t\u000bY\u001c\u0001\u0019A>\u0002\u001d\u001d,GoT;uaV$\u0018\t\u001e;sg\u0006aA/\u001f9f\u0007>,'oY5p]V\u0011!Q\u000e\t\u0004I\n=\u0014b\u0001B9K\n\u0001B+\u001f9f\u0007>,'oY5p]\n\u000b7/Z\u0001\fG\u0006\u001cH/\u00118e\u000bZ\fG.\u0006\u0003\u0003x\tuDC\u0002B=\u0005\u0013\u0013i\t\u0005\u0003\u0003|\tuD\u0002\u0001\u0003\b\u0005\u007f2!\u0019\u0001BA\u0005\u0005!\u0016\u0003\u0002BB\u00053\u00012a\u0014BC\u0013\r\u00119\t\u0015\u0002\b\u001d>$\b.\u001b8h\u0011\u001d\u0011YI\u0002a\u0001\u0003\u000f\n!\"\u001a=qe\u0016\u001c8/[8o\u0011\u001d\u0011yI\u0002a\u0001\u0005#\u000b\u0001\u0002Z1uCRK\b/\u001a\t\u0005\u0005'\u0013I*\u0004\u0002\u0003\u0016*\u0019!qS!\u0002\u000bQL\b/Z:\n\t\tm%Q\u0013\u0002\t\t\u0006$\u0018\rV=qK\u00061Ao\u001c'p]\u001e$2A\u001cBQ\u0011\u001d\u0011Yi\u0002a\u0001\u0003\u000f\nQ\u0001^8J]R$2a\u001fBT\u0011\u001d\u0011Y\t\u0003a\u0001\u0003\u000f\"Rb\u0017BV\u0005[\u0013yK!-\u00034\nU\u0006\"\u00027\n\u0001\u0004q\u0007\"\u0002:\n\u0001\u0004q\u0007\"\u0002;\n\u0001\u0004q\u0007\"\u0002<\n\u0001\u0004A\b\u0002C@\n!\u0003\u0005\r!a\u0001\t\u0013\u0005%\u0012\u0002%AA\u0002\u00055\u0012aD1qa2LH\u0005Z3gCVdG\u000fJ\u001b\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIY\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003@\n\u001d\u0007\u0003B(z\u0005\u0003\u00042b\u0014Bb]:t\u00070a\u0001\u0002.%\u0019!Q\u0019)\u0003\rQ+\b\u000f\\37\u0011!\u0011I\rDA\u0001\u0002\u0004Y\u0016a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u00122\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa5\u0011\t\t\u0015!Q[\u0005\u0005\u0005/\u00149A\u0001\u0004PE*,7\r\u001e")
public class Range
extends LogicalPlan
implements LeafNode,
MultiInstanceRelation,
scala.Serializable {
    private final long start;
    private final long end;
    private final long step;
    private final Option<Object> numSlices;
    private final Seq<Attribute> output;
    private final boolean isStreaming;
    private final BigInt numElements;

    public static boolean $lessinit$greater$default$6() {
        return Range$.MODULE$.$lessinit$greater$default$6();
    }

    public static Seq<Attribute> $lessinit$greater$default$5() {
        return Range$.MODULE$.$lessinit$greater$default$5();
    }

    public static Option<Tuple6<Object, Object, Object, Option<Object>, Seq<Attribute>, Object>> unapply(Range range) {
        return Range$.MODULE$.unapply(range);
    }

    public static boolean apply$default$6() {
        return Range$.MODULE$.apply$default$6();
    }

    public static Seq<Attribute> apply$default$5() {
        return Range$.MODULE$.apply$default$5();
    }

    public static int toInt(Expression expression) {
        return Range$.MODULE$.toInt(expression);
    }

    public static long toLong(Expression expression) {
        return Range$.MODULE$.toLong(expression);
    }

    public static Seq<Attribute> getOutputAttrs() {
        return Range$.MODULE$.getOutputAttrs();
    }

    @Override
    public AttributeSet producedAttributes() {
        return LeafNode.producedAttributes$(this);
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return LeafLike.children$(this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$(this, newChildren);
    }

    public long start() {
        return this.start;
    }

    public long end() {
        return this.end;
    }

    public long step() {
        return this.step;
    }

    public Option<Object> numSlices() {
        return this.numSlices;
    }

    @Override
    public Seq<Attribute> output() {
        return this.output;
    }

    @Override
    public boolean isStreaming() {
        return this.isStreaming;
    }

    public BigInt numElements() {
        return this.numElements;
    }

    public String toSQL() {
        if (this.numSlices().isDefined()) {
            return new StringBuilder(34).append("SELECT id AS `").append(((NamedExpression)this.output().head()).name()).append("` FROM range(").append(this.start()).append(", ").append(this.end()).append(", ").append(this.step()).append(", ").append(this.numSlices().get()).append(")").toString();
        }
        return new StringBuilder(32).append("SELECT id AS `").append(((NamedExpression)this.output().head()).name()).append("` FROM range(").append(this.start()).append(", ").append(this.end()).append(", ").append(this.step()).append(")").toString();
    }

    @Override
    public Range newInstance() {
        Seq x$1 = (Seq)this.output().map((Function1 & Serializable & scala.Serializable)x$37 -> x$37.newInstance(), Seq$.MODULE$.canBuildFrom());
        long x$2 = this.copy$default$1();
        long x$3 = this.copy$default$2();
        long x$4 = this.copy$default$3();
        Option<Object> x$5 = this.copy$default$4();
        boolean x$6 = this.copy$default$6();
        return this.copy(x$2, x$3, x$4, x$5, (Seq<Attribute>)x$1, x$6);
    }

    @Override
    public String simpleString(int maxFields) {
        return new StringBuilder(26).append("Range (").append(this.start()).append(", ").append(this.end()).append(", step=").append(this.step()).append(", splits=").append(this.numSlices()).append(")").toString();
    }

    @Override
    public Option<Object> maxRows() {
        if (this.numElements().isValidLong()) {
            return new Some((Object)BoxesRunTime.boxToLong((long)this.numElements().toLong()));
        }
        return None$.MODULE$;
    }

    @Override
    public Option<Object> maxRowsPerPartition() {
        if (this.numSlices().isDefined()) {
            BigInt m = this.numElements().$div(BigInt$.MODULE$.int2bigInt(BoxesRunTime.unboxToInt((Object)this.numSlices().get())));
            if (!BoxesRunTime.equalsNumObject((Number)this.numElements().$percent(BigInt$.MODULE$.int2bigInt(BoxesRunTime.unboxToInt((Object)this.numSlices().get()))), (Object)BoxesRunTime.boxToInteger((int)0))) {
                m = m.$plus(BigInt$.MODULE$.int2bigInt(1));
            }
            if (m.isValidLong()) {
                return new Some((Object)BoxesRunTime.boxToLong((long)m.toLong()));
            }
            return this.maxRows();
        }
        return this.maxRows();
    }

    @Override
    public Statistics computeStats() {
        Tuple2 tuple2;
        if (BoxesRunTime.equalsNumObject((Number)this.numElements(), (Object)BoxesRunTime.boxToInteger((int)0))) {
            return new Statistics(BigInt$.MODULE$.int2bigInt(0), (Option<BigInt>)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), Statistics$.MODULE$.apply$default$3(), Statistics$.MODULE$.apply$default$4());
        }
        Tuple2 tuple22 = tuple2 = this.step() > 0L ? new Tuple2((Object)BoxesRunTime.boxToLong((long)this.start()), (Object)BigInt$.MODULE$.long2bigInt(this.start()).$plus(this.numElements().$minus(BigInt$.MODULE$.int2bigInt(1)).$times(BigInt$.MODULE$.long2bigInt(this.step())))) : new Tuple2((Object)BigInt$.MODULE$.long2bigInt(this.start()).$plus(this.numElements().$minus(BigInt$.MODULE$.int2bigInt(1)).$times(BigInt$.MODULE$.long2bigInt(this.step()))), (Object)BoxesRunTime.boxToLong((long)this.start()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object minVal = tuple2._1();
        Object maxVal = tuple2._2();
        Tuple2 tuple23 = new Tuple2(minVal, maxVal);
        Object minVal2 = tuple23._1();
        Object maxVal2 = tuple23._2();
        None$ histogram = this.conf().histogramEnabled() ? new Some((Object)this.computeHistogramStatistics()) : None$.MODULE$;
        Some x$1 = new Some((Object)this.numElements());
        Some x$2 = new Some(maxVal2);
        Some x$3 = new Some(minVal2);
        Some x$4 = new Some((Object)BigInt$.MODULE$.int2bigInt(0));
        Some x$5 = new Some((Object)BoxesRunTime.boxToLong((long)LongType$.MODULE$.defaultSize()));
        Some x$6 = new Some((Object)BoxesRunTime.boxToLong((long)LongType$.MODULE$.defaultSize()));
        None$ x$7 = histogram;
        int x$8 = ColumnStat$.MODULE$.apply$default$8();
        ColumnStat colStat = new ColumnStat((Option<BigInt>)x$1, (Option<Object>)x$3, (Option<Object>)x$2, (Option<BigInt>)x$4, (Option<Object>)x$5, (Option<Object>)x$6, (Option<Histogram>)x$7, x$8);
        return new Statistics(BigInt$.MODULE$.int2bigInt(LongType$.MODULE$.defaultSize()).$times(this.numElements()), (Option<BigInt>)new Some((Object)this.numElements()), AttributeMap$.MODULE$.apply((Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.output().head()), (Object)colStat), (List)Nil$.MODULE$)), Statistics$.MODULE$.apply$default$4());
    }

    private Histogram computeHistogramStatistics() {
        int numBins = this.conf().histogramNumBins();
        double height = this.numElements().toDouble() / (double)numBins;
        double[] percentileArray = (double[])((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), numBins).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> (double)i * height, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
        double lowerIndexInitial = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(percentileArray)).head());
        long lowerBinValueInitial = this.getRangeValue(0);
        Tuple3 tuple3 = (Tuple3)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(percentileArray)).tail())).foldLeft((Object)new Tuple3((Object)BoxesRunTime.boxToDouble((double)lowerIndexInitial), (Object)BoxesRunTime.boxToLong((long)lowerBinValueInitial), (Object)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> Range.$anonfun$computeHistogramStatistics$2(this, x0$1, BoxesRunTime.unboxToDouble((Object)x1$1)));
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Seq binArray = (Seq)tuple3._3();
        Seq binArray2 = binArray;
        return new Histogram(height, (HistogramBin[])binArray2.toArray(ClassTag$.MODULE$.apply(HistogramBin.class)));
    }

    private long getRangeValue(int index) {
        Predef$.MODULE$.assert(index >= 0, (Function0 & Serializable & scala.Serializable)() -> "index must be greater than and equal to 0");
        if (this.step() < 0L) {
            return this.start() + (this.numElements().toLong() - (long)index - 1L) * this.step();
        }
        return this.start() + (long)index * this.step();
    }

    @Override
    public Seq<SortOrder> outputOrdering() {
        SortDirection order = this.step() > 0L ? Ascending$.MODULE$ : Descending$.MODULE$;
        return (Seq)this.output().map((Function1 & Serializable & scala.Serializable)a -> SortOrder$.MODULE$.apply((Expression)a, order, SortOrder$.MODULE$.apply$default$3()), Seq$.MODULE$.canBuildFrom());
    }

    public Range copy(long start, long end, long step, Option<Object> numSlices, Seq<Attribute> output, boolean isStreaming) {
        return new Range(start, end, step, numSlices, output, isStreaming);
    }

    public long copy$default$1() {
        return this.start();
    }

    public long copy$default$2() {
        return this.end();
    }

    public long copy$default$3() {
        return this.step();
    }

    public Option<Object> copy$default$4() {
        return this.numSlices();
    }

    public Seq<Attribute> copy$default$5() {
        return this.output();
    }

    public boolean copy$default$6() {
        return this.isStreaming();
    }

    @Override
    public String productPrefix() {
        return "Range";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return BoxesRunTime.boxToLong((long)this.start());
            }
            case 1: {
                return BoxesRunTime.boxToLong((long)this.end());
            }
            case 2: {
                return BoxesRunTime.boxToLong((long)this.step());
            }
            case 3: {
                return this.numSlices();
            }
            case 4: {
                return this.output();
            }
            case 5: {
                return BoxesRunTime.boxToBoolean((boolean)this.isStreaming());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Range;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Range)) return false;
        boolean bl = true;
        if (!bl) return false;
        Range range = (Range)x$1;
        if (this.start() != range.start()) return false;
        if (this.end() != range.end()) return false;
        if (this.step() != range.step()) return false;
        Option<Object> option = this.numSlices();
        Option<Object> option2 = range.numSlices();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Seq<Attribute> seq = this.output();
        Seq<Attribute> seq2 = range.output();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (this.isStreaming() != range.isStreaming()) return false;
        if (!range.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ Tuple3 $anonfun$computeHistogramStatistics$2(Range $this, Tuple3 x0$1, double x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)BoxesRunTime.boxToDouble((double)x1$1));
        if (tuple2 != null) {
            Tuple3 tuple3 = (Tuple3)tuple2._1();
            double upperIndex = tuple2._2$mcD$sp();
            if (tuple3 != null) {
                double lowerIndex = BoxesRunTime.unboxToDouble((Object)tuple3._1());
                long lowerBinValue = BoxesRunTime.unboxToLong((Object)tuple3._2());
                Seq binAr = (Seq)tuple3._3();
                int upperIndexPos = (int)scala.math.package$.MODULE$.ceil(upperIndex) - 1;
                int lowerIndexPos = (int)scala.math.package$.MODULE$.ceil(lowerIndex) - 1;
                long upperBinValue = $this.getRangeValue(scala.math.package$.MODULE$.max(upperIndexPos, 0));
                int ndv = scala.math.package$.MODULE$.max(upperIndexPos - lowerIndexPos, 1);
                return new Tuple3((Object)BoxesRunTime.boxToDouble((double)upperIndex), (Object)BoxesRunTime.boxToLong((long)upperBinValue), binAr.$colon$plus((Object)new HistogramBin(lowerBinValue, upperBinValue, ndv), Seq$.MODULE$.canBuildFrom()));
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public Range(long start, long end, long step, Option<Object> numSlices, Seq<Attribute> output, boolean isStreaming) {
        this.start = start;
        this.end = end;
        this.step = step;
        this.numSlices = numSlices;
        this.output = output;
        this.isStreaming = isStreaming;
        LeafLike.$init$(this);
        LeafNode.$init$(this);
        Predef$.MODULE$.require(step != 0L, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("step (").append(this.step()).append(") cannot be 0").toString());
        BigInt safeStart = package$.MODULE$.BigInt().apply(start);
        BigInt safeEnd = package$.MODULE$.BigInt().apply(end);
        this.numElements = BoxesRunTime.equalsNumObject((Number)safeEnd.$minus(safeStart).$percent(BigInt$.MODULE$.long2bigInt(step)), (Object)BoxesRunTime.boxToInteger((int)0)) || safeEnd.$greater((Object)safeStart) != step > 0L ? safeEnd.$minus(safeStart).$div(BigInt$.MODULE$.long2bigInt(step)) : safeEnd.$minus(safeStart).$div(BigInt$.MODULE$.long2bigInt(step)).$plus(BigInt$.MODULE$.int2bigInt(1));
    }

    public Range(Expression start, Expression end, Expression step, Expression numSlices) {
        this(Range$.MODULE$.toLong(start), Range$.MODULE$.toLong(end), Range$.MODULE$.toLong(step), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)Range$.MODULE$.toInt(numSlices))), Range$.MODULE$.$lessinit$greater$default$5(), Range$.MODULE$.$lessinit$greater$default$6());
    }

    public Range(Expression start, Expression end, Expression step) {
        this(Range$.MODULE$.toLong(start), Range$.MODULE$.toLong(end), Range$.MODULE$.toLong(step), (Option<Object>)None$.MODULE$, Range$.MODULE$.$lessinit$greater$default$5(), Range$.MODULE$.$lessinit$greater$default$6());
    }

    public Range(Expression start, Expression end) {
        this(start, end, Literal$.MODULE$.create(BoxesRunTime.boxToLong((long)1L), LongType$.MODULE$));
    }

    public Range(Expression end) {
        this(Literal$.MODULE$.create(BoxesRunTime.boxToLong((long)0L), LongType$.MODULE$), end);
    }
}

