/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import java.io.CharConversionException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.MalformedInputException;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonUtils$;
import org.apache.spark.sql.catalyst.json.JsonInferSchema$;
import org.apache.spark.sql.catalyst.util.DropMalformedMode$;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.ParseMode;
import org.apache.spark.sql.catalyst.util.PermissiveMode$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.util.control.Exception$;

@ScalaSignature(bytes="\u0006\u0001\u0005Mg!\u0002\r\u001a\u0001u)\u0003\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\t\u000bU\u0002A\u0011\u0001\u001c\t\u000fe\u0002!\u0019!C\u0005u!1\u0011\u000b\u0001Q\u0001\nmBqA\u0015\u0001C\u0002\u0013%1\u000b\u0003\u0004[\u0001\u0001\u0006I\u0001\u0016\u0005\b7\u0002\u0011\r\u0011\"\u0003T\u0011\u0019a\u0006\u0001)A\u0005)\")Q\f\u0001C\u0005=\")!\u0010\u0001C\u0001w\"9\u0011q\t\u0001\u0005\u0002\u0005%\u0003\u0002CA+\u0001\u0011\u00051$a\u0016\b\u000f\u0005\u0005\u0014\u0004#\u0001\u0002d\u00191\u0001$\u0007E\u0001\u0003KBa!\u000e\b\u0005\u0002\u0005\u001d\u0004\"CA5\u001d\t\u0007I\u0011AA6\u0011!\t\u0019H\u0004Q\u0001\n\u00055\u0004bBAI\u001d\u0011\u0005\u00111\u0013\u0005\b\u0003KsA\u0011AAT\u0011\u001d\t9L\u0004C\u0001\u0003sC\u0001\"!1\u000fA\u0003%\u0011q\u0014\u0005\b\u0003\u0007tA\u0011AAc\u0011%\tyMDA\u0001\n\u0013\t\tNA\bKg>t\u0017J\u001c4feN\u001b\u0007.Z7b\u0015\tQ2$\u0001\u0003kg>t'B\u0001\u000f\u001e\u0003!\u0019\u0017\r^1msN$(B\u0001\u0010 \u0003\r\u0019\u0018\u000f\u001c\u0006\u0003A\u0005\nQa\u001d9be.T!AI\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0013aA8sON\u0019\u0001A\n\u0017\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0003\r\u0005s\u0017PU3g!\t9S&\u0003\u0002/Q\ta1+\u001a:jC2L'0\u00192mK\u00069q\u000e\u001d;j_:\u001c8\u0001\u0001\t\u0003eMj\u0011!G\u0005\u0003ie\u00111BS*P\u001d>\u0003H/[8og\u00061A(\u001b8jiz\"\"a\u000e\u001d\u0011\u0005I\u0002\u0001\"B\u0018\u0003\u0001\u0004\t\u0014!\u00043fG&l\u0017\r\u001c)beN,'/F\u0001<!\u00119CHP%\n\u0005uB#!\u0003$v]\u000e$\u0018n\u001c82!\tydI\u0004\u0002A\tB\u0011\u0011\tK\u0007\u0002\u0005*\u00111\tM\u0001\u0007yI|w\u000e\u001e \n\u0005\u0015C\u0013A\u0002)sK\u0012,g-\u0003\u0002H\u0011\n11\u000b\u001e:j]\u001eT!!\u0012\u0015\u0011\u0005){U\"A&\u000b\u00051k\u0015\u0001B7bi\"T\u0011AT\u0001\u0005U\u00064\u0018-\u0003\u0002Q\u0017\nQ!)[4EK\u000eLW.\u00197\u0002\u001d\u0011,7-[7bYB\u000b'o]3sA\u0005\u0011B/[7fgR\fW\u000e\u001d$pe6\fG\u000f^3s+\u0005!\u0006CA+Y\u001b\u00051&BA,\u001c\u0003\u0011)H/\u001b7\n\u0005e3&A\u0005+j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;uKJ\f1\u0003^5nKN$\u0018-\u001c9G_Jl\u0017\r\u001e;fe\u0002\nQ\u0003^5nKN$\u0018-\u001c9O)j3uN]7biR,'/\u0001\fuS6,7\u000f^1na:#&LR8s[\u0006$H/\u001a:!\u0003mA\u0017M\u001c3mK*\u001bxN\\#se>\u00148OQ=QCJ\u001cX-T8eKR!q\f[7p!\r9\u0003MY\u0005\u0003C\"\u0012aa\u00149uS>t\u0007CA2g\u001b\u0005!'BA3\u001e\u0003\u0015!\u0018\u0010]3t\u0013\t9GM\u0001\u0006TiJ,8\r\u001e+za\u0016DQ![\u0005A\u0002)\f\u0011\u0002]1sg\u0016lu\u000eZ3\u0011\u0005U[\u0017B\u00017W\u0005%\u0001\u0016M]:f\u001b>$W\rC\u0003o\u0013\u0001\u0007a(A\rd_2,XN\u001c(b[\u0016|emQ8seV\u0004HOU3d_J$\u0007\"\u00029\n\u0001\u0004\t\u0018!A3\u0011\u0005I<hBA:v\u001d\t\tE/C\u0001*\u0013\t1\b&A\u0004qC\u000e\\\u0017mZ3\n\u0005aL(!\u0003+ie><\u0018M\u00197f\u0015\t1\b&A\u0003j]\u001a,'/F\u0002}\u0003\u001b!BAY?\u0002 !)!D\u0003a\u0001}B)q0!\u0002\u0002\n5\u0011\u0011\u0011\u0001\u0006\u0004\u0003\u0007y\u0012a\u0001:eI&!\u0011qAA\u0001\u0005\r\u0011F\t\u0012\t\u0005\u0003\u0017\ti\u0001\u0004\u0001\u0005\u000f\u0005=!B1\u0001\u0002\u0012\t\tA+\u0005\u0003\u0002\u0014\u0005e\u0001cA\u0014\u0002\u0016%\u0019\u0011q\u0003\u0015\u0003\u000f9{G\u000f[5oOB\u0019q%a\u0007\n\u0007\u0005u\u0001FA\u0002B]fDq!!\t\u000b\u0001\u0004\t\u0019#\u0001\u0007de\u0016\fG/\u001a)beN,'\u000fE\u0005(\u0003K\tI#!\u0003\u0002B%\u0019\u0011q\u0005\u0015\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004\u0003BA\u0016\u0003{i!!!\f\u000b\t\u0005=\u0012\u0011G\u0001\u0005G>\u0014XM\u0003\u0003\u00024\u0005U\u0012a\u00026bG.\u001cxN\u001c\u0006\u0005\u0003o\tI$A\u0005gCN$XM\u001d=nY*\u0011\u00111H\u0001\u0004G>l\u0017\u0002BA \u0003[\u00111BS:p]\u001a\u000b7\r^8ssB!\u00111FA\"\u0013\u0011\t)%!\f\u0003\u0015)\u001bxN\u001c)beN,'/\u0001\u0006j]\u001a,'OR5fY\u0012$B!a\u0013\u0002RA\u00191-!\u0014\n\u0007\u0005=CM\u0001\u0005ECR\fG+\u001f9f\u0011\u001d\t\u0019f\u0003a\u0001\u0003\u0003\na\u0001]1sg\u0016\u0014\u0018\u0001E2b]>t\u0017nY1mSj,G+\u001f9f)\u0019\tI&a\u0017\u0002`A!q\u0005YA&\u0011\u001d\ti\u0006\u0004a\u0001\u0003\u0017\n1\u0001\u001e9f\u0011\u0015yC\u00021\u00012\u0003=Q5o\u001c8J]\u001a,'oU2iK6\f\u0007C\u0001\u001a\u000f'\rqa\u0005\f\u000b\u0003\u0003G\nQc\u001d;sk\u000e$h)[3mI\u000e{W\u000e]1sCR|'/\u0006\u0002\u0002nI1\u0011qNA;\u0003\u00033a!!\u001d\u0012\u0001\u00055$\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0014AF:ueV\u001cGOR5fY\u0012\u001cu.\u001c9be\u0006$xN\u001d\u0011\u0011\t\u0005]\u0014QP\u0007\u0003\u0003sR1!a\u001fN\u0003\u0011a\u0017M\\4\n\t\u0005}\u0014\u0011\u0010\u0002\u0007\u001f\nTWm\u0019;\u0011\r\u0005\r\u0015qQAF\u001b\t\t)I\u0003\u0002X\u001b&!\u0011\u0011RAC\u0005)\u0019u.\u001c9be\u0006$xN\u001d\t\u0004G\u00065\u0015bAAHI\nY1\u000b\u001e:vGR4\u0015.\u001a7e\u0003!I7oU8si\u0016$G\u0003BAK\u00037\u00032aJAL\u0013\r\tI\n\u000b\u0002\b\u0005>|G.Z1o\u0011\u001d\tiJ\u0005a\u0001\u0003?\u000b1!\u0019:s!\u00159\u0013\u0011UAF\u0013\r\t\u0019\u000b\u000b\u0002\u0006\u0003J\u0014\u0018-_\u0001\u0011o&$\bnQ8seV\u0004HOR5fY\u0012$\u0012BYAU\u0003[\u000b\t,!.\t\r\u0005-6\u00031\u0001c\u0003\u0019\u0019HO];di\"9\u0011qV\nA\u0002\u0005-\u0013!B8uQ\u0016\u0014\bBBAZ'\u0001\u0007a(\u0001\u000ed_2,XN\u001c(b[\u0016|emQ8seV\u0004HOU3d_J$7\u000fC\u0003j'\u0001\u0007!.\u0001\nd_6\u0004\u0018\r^5cY\u0016\u0014vn\u001c;UsB,GCBA^\u0003{\u000by\fE\u0005(\u0003K\tY%a\u0013\u0002L!1\u00111\u0017\u000bA\u0002yBQ!\u001b\u000bA\u0002)\fQ#Z7qif\u001cFO];di\u001aKW\r\u001c3BeJ\f\u00170\u0001\bd_6\u0004\u0018\r^5cY\u0016$\u0016\u0010]3\u0015\r\u0005-\u0013qYAf\u0011\u001d\tIM\u0006a\u0001\u0003\u0017\n!\u0001^\u0019\t\u000f\u00055g\u00031\u0001\u0002L\u0005\u0011AOM\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002v\u0001")
public class JsonInferSchema
implements scala.Serializable {
    private final JSONOptions options;
    private final Function1<String, BigDecimal> decimalParser;
    private final TimestampFormatter timestampFormatter;
    private final TimestampFormatter timestampNTZFormatter;

    public static DataType compatibleType(DataType dataType, DataType dataType2) {
        return JsonInferSchema$.MODULE$.compatibleType(dataType, dataType2);
    }

    public static Function2<DataType, DataType, DataType> compatibleRootType(String string, ParseMode parseMode) {
        return JsonInferSchema$.MODULE$.compatibleRootType(string, parseMode);
    }

    public static StructType withCorruptField(StructType structType, DataType dataType, String string, ParseMode parseMode) {
        return JsonInferSchema$.MODULE$.withCorruptField(structType, dataType, string, parseMode);
    }

    public static boolean isSorted(StructField[] structFieldArray) {
        return JsonInferSchema$.MODULE$.isSorted(structFieldArray);
    }

    public static Comparator<StructField> structFieldComparator() {
        return JsonInferSchema$.MODULE$.structFieldComparator();
    }

    private Function1<String, BigDecimal> decimalParser() {
        return this.decimalParser;
    }

    private TimestampFormatter timestampFormatter() {
        return this.timestampFormatter;
    }

    private TimestampFormatter timestampNTZFormatter() {
        return this.timestampNTZFormatter;
    }

    private Option<StructType> handleJsonErrorsByParseMode(ParseMode parseMode, String columnNameOfCorruptRecord, Throwable e) {
        ParseMode parseMode2 = parseMode;
        if (PermissiveMode$.MODULE$.equals(parseMode2)) {
            return new Some((Object)StructType$.MODULE$.apply((Seq<StructField>)((Seq)new .colon.colon((Object)new StructField(columnNameOfCorruptRecord, StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))));
        }
        if (DropMalformedMode$.MODULE$.equals(parseMode2)) {
            return None$.MODULE$;
        }
        if (FailFastMode$.MODULE$.equals(parseMode2)) {
            throw QueryExecutionErrors$.MODULE$.malformedRecordsDetectedInSchemaInferenceError(e);
        }
        throw new MatchError((Object)parseMode2);
    }

    public <T> StructType infer(RDD<T> json, Function2<JsonFactory, T, JsonParser> createParser) {
        ParseMode parseMode = this.options.parseMode();
        String columnNameOfCorruptRecord = this.options.columnNameOfCorruptRecord();
        Function2<DataType, DataType, DataType> typeMerger = JsonInferSchema$.MODULE$.compatibleRootType(columnNameOfCorruptRecord, parseMode);
        RDD mergedTypesFromPartitions = json.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            JsonFactory factory = $this.options.buildJsonFactory();
            return iter.flatMap((Function1 & Serializable & scala.Serializable)row -> {
                Iterable iterable;
                try {
                    iterable = Option$.MODULE$.option2Iterable((Option)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> (JsonParser)createParser.apply((Object)factory, row), (Function1 & Serializable & scala.Serializable)parser -> {
                        parser.nextToken();
                        return new Some((Object)this.inferField((JsonParser)parser));
                    }));
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof RuntimeException ? true : (throwable2 instanceof JsonProcessingException ? true : throwable2 instanceof MalformedInputException)) {
                        iterable = Option$.MODULE$.option2Iterable(this.handleJsonErrorsByParseMode(parseMode, columnNameOfCorruptRecord, throwable2));
                    }
                    if (throwable2 instanceof CharConversionException) {
                        CharConversionException charConversionException = (CharConversionException)throwable2;
                        if ($this.options.encoding().isEmpty()) {
                            String msg = new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString("JSON parser cannot handle a character in its input.\n                |Specifying encoding as an input option explicitly might help to resolve the issue.\n                |")).stripMargin()).append(charConversionException.getMessage()).toString();
                            CharConversionException wrappedCharException = new CharConversionException(msg);
                            wrappedCharException.initCause(charConversionException);
                            iterable = Option$.MODULE$.option2Iterable(this.handleJsonErrorsByParseMode(parseMode, columnNameOfCorruptRecord, wrappedCharException));
                        }
                    }
                    throw throwable;
                }
                return iterable;
            }).reduceOption(typeMerger).iterator();
        }, json.mapPartitions$default$2(), ClassTag$.MODULE$.apply(DataType.class));
        SQLConf existingConf = SQLConf$.MODULE$.get();
        ObjectRef rootType = ObjectRef.create((Object)StructType$.MODULE$.apply((Seq<StructField>)Nil$.MODULE$));
        Function1 & Serializable & scala.Serializable foldPartition = (Function1 & Serializable & scala.Serializable)iter -> (DataType)iter.fold((Object)StructType$.MODULE$.apply((Seq<StructField>)Nil$.MODULE$), typeMerger);
        Function2 & Serializable & scala.Serializable mergeResult = (Function2 & Serializable & scala.Serializable)(index, taskResult) -> {
            rootType.elem = (DataType)SQLConf$.MODULE$.withExistingConf(existingConf, (Function0 & Serializable & scala.Serializable)() -> (DataType)typeMerger$1.apply((Object)((DataType)rootType$1.elem), (Object)taskResult));
            return BoxedUnit.UNIT;
        };
        json.sparkContext().runJob(mergedTypesFromPartitions, (Function1)foldPartition, (Function2)mergeResult, ClassTag$.MODULE$.apply(DataType.class));
        return (StructType)Option$.MODULE$.option2Iterable(this.canonicalizeType((DataType)rootType.elem, this.options)).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JsonInferSchema.$anonfun$infer$8(x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> StructType$.MODULE$.apply((Seq<StructField>)Nil$.MODULE$));
    }

    public DataType inferField(JsonParser parser) {
        boolean bl = false;
        JsonToken jsonToken = null;
        JsonToken jsonToken2 = parser.getCurrentToken();
        if (jsonToken2 == null ? true : JsonToken.VALUE_NULL.equals(jsonToken2)) {
            return NullType$.MODULE$;
        }
        if (JsonToken.FIELD_NAME.equals(jsonToken2)) {
            parser.nextToken();
            return this.inferField(parser);
        }
        if (JsonToken.VALUE_STRING.equals(jsonToken2)) {
            bl = true;
            jsonToken = jsonToken2;
            if (parser.getTextLength() < 1) {
                return NullType$.MODULE$;
            }
        }
        if (bl) {
            LazyRef decimalTry$lzy = new LazyRef();
            String field = parser.getText();
            if (this.options.prefersDecimal() && this.decimalTry$1(decimalTry$lzy, field).isDefined()) {
                return (DataType)this.decimalTry$1(decimalTry$lzy, field).get();
            }
            if (this.options.inferTimestamp() && this.timestampNTZFormatter().parseWithoutTimeZoneOptional(field, false).isDefined()) {
                return SQLConf$.MODULE$.get().timestampType();
            }
            if (this.options.inferTimestamp() && this.timestampFormatter().parseOptional(field).isDefined()) {
                return TimestampType$.MODULE$;
            }
            return StringType$.MODULE$;
        }
        if (JsonToken.START_OBJECT.equals(jsonToken2)) {
            ArrayBuilder builder = Array$.MODULE$.newBuilder(ClassTag$.MODULE$.apply(StructField.class));
            while (JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_OBJECT)) {
                builder.$plus$eq((Object)new StructField(parser.getCurrentName(), this.inferField(parser), true, StructField$.MODULE$.apply$default$4()));
            }
            StructField[] fields = (StructField[])builder.result();
            Arrays.sort((Object[])fields, JsonInferSchema$.MODULE$.structFieldComparator());
            return new StructType(fields);
        }
        if (JsonToken.START_ARRAY.equals(jsonToken2)) {
            DataType elementType = NullType$.MODULE$;
            while (JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_ARRAY)) {
                elementType = JsonInferSchema$.MODULE$.compatibleType(elementType, this.inferField(parser));
            }
            return ArrayType$.MODULE$.apply(elementType);
        }
        if ((JsonToken.VALUE_NUMBER_INT.equals(jsonToken2) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken2)) && this.options.primitivesAsString()) {
            return StringType$.MODULE$;
        }
        if ((JsonToken.VALUE_TRUE.equals(jsonToken2) ? true : JsonToken.VALUE_FALSE.equals(jsonToken2)) && this.options.primitivesAsString()) {
            return StringType$.MODULE$;
        }
        if (JsonToken.VALUE_NUMBER_INT.equals(jsonToken2) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken2)) {
            JsonParser.NumberType numberType = parser.getNumberType();
            if (JsonParser.NumberType.INT.equals(numberType) ? true : JsonParser.NumberType.LONG.equals(numberType)) {
                return LongType$.MODULE$;
            }
            if (JsonParser.NumberType.BIG_INTEGER.equals(numberType) ? true : JsonParser.NumberType.BIG_DECIMAL.equals(numberType)) {
                BigDecimal v = parser.getDecimalValue();
                if (Math.max(v.precision(), v.scale()) <= DecimalType$.MODULE$.MAX_PRECISION()) {
                    return new DecimalType(Math.max(v.precision(), v.scale()), v.scale());
                }
                return DoubleType$.MODULE$;
            }
            if ((JsonParser.NumberType.FLOAT.equals(numberType) ? true : JsonParser.NumberType.DOUBLE.equals(numberType)) && this.options.prefersDecimal()) {
                BigDecimal v = parser.getDecimalValue();
                if (Math.max(v.precision(), v.scale()) <= DecimalType$.MODULE$.MAX_PRECISION()) {
                    return new DecimalType(Math.max(v.precision(), v.scale()), v.scale());
                }
                return DoubleType$.MODULE$;
            }
            if (JsonParser.NumberType.FLOAT.equals(numberType) ? true : JsonParser.NumberType.DOUBLE.equals(numberType)) {
                return DoubleType$.MODULE$;
            }
            throw new MatchError((Object)numberType);
        }
        if (JsonToken.VALUE_TRUE.equals(jsonToken2) ? true : JsonToken.VALUE_FALSE.equals(jsonToken2)) {
            return BooleanType$.MODULE$;
        }
        throw QueryExecutionErrors$.MODULE$.malformedJSONError();
    }

    public Option<DataType> canonicalizeType(DataType tpe, JSONOptions options) {
        DataType dataType = tpe;
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            return this.canonicalizeType(arrayType.elementType(), options).map((Function1 & Serializable & scala.Serializable)t -> arrayType.copy((DataType)t, arrayType.copy$default$2()));
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            StructField[] canonicalFields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)JsonInferSchema.$anonfun$canonicalizeType$2(x$2))))).flatMap((Function1 & Serializable & scala.Serializable)f -> Option$.MODULE$.option2Iterable(this.canonicalizeType(f.dataType(), options).map((Function1 & Serializable & scala.Serializable)t -> {
                DataType x$1 = t;
                String x$2 = f.copy$default$1();
                boolean x$3 = f.copy$default$3();
                Metadata x$4 = f.copy$default$4();
                return f.copy(x$2, x$1, x$3, x$4);
            })), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])canonicalFields)).isEmpty()) {
                return None$.MODULE$;
            }
            return new Some((Object)new StructType(canonicalFields));
        }
        if (NullType$.MODULE$.equals(dataType)) {
            if (options.dropFieldIfAllNull()) {
                return None$.MODULE$;
            }
            return new Some((Object)StringType$.MODULE$);
        }
        return new Some((Object)dataType);
    }

    public static final /* synthetic */ boolean $anonfun$infer$8(DataType x$1) {
        return x$1 instanceof StructType;
    }

    private final /* synthetic */ Option decimalTry$lzycompute$1(LazyRef decimalTry$lzy$1, String field$1) {
        Option option;
        LazyRef lazyRef = decimalTry$lzy$1;
        synchronized (lazyRef) {
            option = decimalTry$lzy$1.initialized() ? (Option)decimalTry$lzy$1.value() : (Option)decimalTry$lzy$1.initialize((Object)Exception$.MODULE$.allCatch().opt((Function0 & Serializable & scala.Serializable)() -> {
                BigDecimal bigDecimal = (BigDecimal)this.decimalParser().apply((Object)field$1);
                return new DecimalType(bigDecimal.precision(), bigDecimal.scale());
            }));
        }
        return option;
    }

    private final Option decimalTry$1(LazyRef decimalTry$lzy$1, String field$1) {
        if (decimalTry$lzy$1.initialized()) {
            return (Option)decimalTry$lzy$1.value();
        }
        return this.decimalTry$lzycompute$1(decimalTry$lzy$1, field$1);
    }

    public static final /* synthetic */ boolean $anonfun$canonicalizeType$2(StructField x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2.name())).nonEmpty();
    }

    public JsonInferSchema(JSONOptions options) {
        this.options = options;
        this.decimalParser = ExprUtils$.MODULE$.getDecimalParser(options.locale());
        this.timestampFormatter = TimestampFormatter$.MODULE$.apply(options.timestampFormatInRead(), options.zoneId(), options.locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true);
        this.timestampNTZFormatter = TimestampFormatter$.MODULE$.apply(options.timestampNTZFormatInRead(), options.zoneId(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true, true);
    }
}

