/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.BinaryArithmetic;
import org.apache.spark.sql.catalyst.expressions.DivModLike;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.IntegralDivide$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.math.Integral;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Divide `expr1` by `expr2`. It returns NULL if an operand is NULL or `expr2` is 0. The result is casted to long.", examples="\n    Examples:\n      > SELECT 3 _FUNC_ 2;\n       1\n      > SELECT INTERVAL '1-1' YEAR TO MONTH _FUNC_ INTERVAL '-1' MONTH;\n       -13\n  ", since="3.0.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0001\u00055h\u0001\u0002\u0014(\u0001RB\u0001\"\u0012\u0001\u0003\u0016\u0004%\tA\u0012\u0005\t\u0015\u0002\u0011\t\u0012)A\u0005\u000f\"A1\n\u0001BK\u0002\u0013\u0005a\t\u0003\u0005M\u0001\tE\t\u0015!\u0003H\u0011!i\u0005A!f\u0001\n\u0003q\u0005\u0002\u0003*\u0001\u0005#\u0005\u000b\u0011B(\t\u000bM\u0003A\u0011\u0001+\t\u000bM\u0003A\u0011A-\t\u000bq\u0003A\u0011\t(\t\u000bu\u0003A\u0011\t0\t\u000b\u0015\u0004A\u0011\t4\t\u000b)\u0004A\u0011I6\t\u000b]\u0004A\u0011I6\t\u000ba\u0004A\u0011I=\t\u000bq\u0004A\u0011I6\t\u0011u\u0004\u0001R1A\u0005\nyDq!a\u0003\u0001\t\u0003\ni\u0001C\u0004\u0002\u0014\u0001!\t&!\u0006\t\u0013\u0005}\u0001!!A\u0005\u0002\u0005\u0005\u0002\"CA\u0015\u0001E\u0005I\u0011AA\u0016\u0011%\t\t\u0005AI\u0001\n\u0003\tY\u0003C\u0005\u0002D\u0001\t\n\u0011\"\u0001\u0002F!I\u0011\u0011\n\u0001\u0002\u0002\u0013\u0005\u00131\n\u0005\n\u00037\u0002\u0011\u0011!C\u0001\u0003;B\u0011\"!\u001a\u0001\u0003\u0003%\t!a\u001a\t\u0013\u00055\u0004!!A\u0005B\u0005=\u0004\"CA?\u0001\u0005\u0005I\u0011AA@\u0011%\t\u0019\tAA\u0001\n\u0003\n)iB\u0005\u0002*\u001e\n\t\u0011#\u0001\u0002,\u001aAaeJA\u0001\u0012\u0003\ti\u000b\u0003\u0004T=\u0011\u0005\u00111\u0018\u0005\n\u0003{s\u0012\u0011!C#\u0003\u007fC\u0011\"!1\u001f\u0003\u0003%\t)a1\t\u0013\u0005-g$%A\u0005\u0002\u0005\u0015\u0003\"CAg=\u0005\u0005I\u0011QAh\u0011%\t\tOHI\u0001\n\u0003\t)\u0005C\u0005\u0002dz\t\t\u0011\"\u0003\u0002f\nq\u0011J\u001c;fOJ\fG\u000eR5wS\u0012,'B\u0001\u0015*\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005)Z\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u00051j\u0013aA:rY*\u0011afL\u0001\u0006gB\f'o\u001b\u0006\u0003aE\na!\u00199bG\",'\"\u0001\u001a\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001)\u0014\b\u0010\"\u0011\u0005Y:T\"A\u0014\n\u0005a:#\u0001\u0005\"j]\u0006\u0014\u00180\u0011:ji\"lW\r^5d!\t1$(\u0003\u0002<O\tQA)\u001b<N_\u0012d\u0015n[3\u0011\u0005u\u0002U\"\u0001 \u000b\u0003}\nQa]2bY\u0006L!!\u0011 \u0003\u000fA\u0013x\u000eZ;diB\u0011QhQ\u0005\u0003\tz\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fA\u0001\\3giV\tq\t\u0005\u00027\u0011&\u0011\u0011j\n\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017!\u00027fMR\u0004\u0013!\u0002:jO\"$\u0018A\u0002:jO\"$\b%A\u0006gC&dwJ\\#se>\u0014X#A(\u0011\u0005u\u0002\u0016BA)?\u0005\u001d\u0011un\u001c7fC:\fABZ1jY>sWI\u001d:pe\u0002\na\u0001P5oSRtD\u0003B+W/b\u0003\"A\u000e\u0001\t\u000b\u0015;\u0001\u0019A$\t\u000b-;\u0001\u0019A$\t\u000f5;\u0001\u0013!a\u0001\u001fR\u0019QKW.\t\u000b\u0015C\u0001\u0019A$\t\u000b-C\u0001\u0019A$\u0002'\rDWmY6ESZLG-Z(wKJ4Gn\\<\u0002\u0013%t\u0007/\u001e;UsB,W#A0\u0011\u0005\u0001\u001cW\"A1\u000b\u0005\t\\\u0013!\u0002;za\u0016\u001c\u0018B\u00013b\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0005eCR\fG+\u001f9f+\u00059\u0007C\u00011i\u0013\tI\u0017M\u0001\u0005ECR\fG+\u001f9f\u0003\u0019\u0019\u00180\u001c2pYV\tA\u000e\u0005\u0002ni:\u0011aN\u001d\t\u0003_zj\u0011\u0001\u001d\u0006\u0003cN\na\u0001\u0010:p_Rt\u0014BA:?\u0003\u0019\u0001&/\u001a3fM&\u0011QO\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Mt\u0014!\u00043fG&l\u0017\r\\'fi\"|G-\u0001\reK\u000eLW.\u00197U_\u0012\u000bG/\u0019+za\u0016\u001cu\u000eZ3HK:$\"\u0001\u001c>\t\u000bmt\u0001\u0019\u00017\u0002\u001b\u0011,7-[7bYJ+7/\u001e7u\u0003-\u0019\u0018\u000f\\(qKJ\fGo\u001c:\u0002\u0007\u0011Lg/F\u0001\u0000!%i\u0014\u0011AA\u0003\u0003\u000b\t)!C\u0002\u0002\u0004y\u0012\u0011BR;oGRLwN\u001c\u001a\u0011\u0007u\n9!C\u0002\u0002\ny\u00121!\u00118z\u00035)g/\u00197Pa\u0016\u0014\u0018\r^5p]R1\u0011QAA\b\u0003#Aa!R\tA\u0002\u0005\u0015\u0001BB&\u0012\u0001\u0004\t)!A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR)Q+a\u0006\u0002\u001c!1\u0011\u0011\u0004\nA\u0002\u001d\u000bqA\\3x\u0019\u00164G\u000f\u0003\u0004\u0002\u001eI\u0001\raR\u0001\t]\u0016<(+[4ii\u0006!1m\u001c9z)\u001d)\u00161EA\u0013\u0003OAq!R\n\u0011\u0002\u0003\u0007q\tC\u0004L'A\u0005\t\u0019A$\t\u000f5\u001b\u0002\u0013!a\u0001\u001f\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u0017U\r9\u0015qF\u0016\u0003\u0003c\u0001B!a\r\u0002>5\u0011\u0011Q\u0007\u0006\u0005\u0003o\tI$A\u0005v]\u000eDWmY6fI*\u0019\u00111\b \u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002@\u0005U\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003\u000fR3aTA\u0018\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\n\t\u0005\u0003\u001f\nI&\u0004\u0002\u0002R)!\u00111KA+\u0003\u0011a\u0017M\\4\u000b\u0005\u0005]\u0013\u0001\u00026bm\u0006L1!^A)\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ty\u0006E\u0002>\u0003CJ1!a\u0019?\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t)!!\u001b\t\u0013\u0005-\u0014$!AA\u0002\u0005}\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002rA1\u00111OA=\u0003\u000bi!!!\u001e\u000b\u0007\u0005]d(\u0001\u0006d_2dWm\u0019;j_:LA!a\u001f\u0002v\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\ry\u0015\u0011\u0011\u0005\n\u0003WZ\u0012\u0011!a\u0001\u0003\u000b\ta!Z9vC2\u001cHcA(\u0002\b\"I\u00111\u000e\u000f\u0002\u0002\u0003\u0007\u0011Q\u0001\u0015\u0014\u0001\u0005-\u0015\u0011SAJ\u0003/\u000bI*!(\u0002 \u0006\r\u0016Q\u0015\t\u0004m\u00055\u0015bAAHO\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAK\u0003\u0005%Q\r\u001f9sc\u0001zf)\u0016(D?\u0002*\u0007\u0010\u001d:3A5\u0002C)\u001b<jI\u0016\u0004\u0003-\u001a=qeF\u0002\u0007EY=!A\u0016D\bO\u001d\u001aa]\u0001JE\u000f\t:fiV\u0014hn\u001d\u0011O+2c\u0005%\u001b4!C:\u0004s\u000e]3sC:$\u0007%[:!\u001dVcE\nI8sA\u0001,\u0007\u0010\u001d:3A\u0002J7\u000f\t\u0019/AQCW\r\t:fgVdG\u000fI5tA\r\f7\u000f^3eAQ|\u0007\u0005\\8oO:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u00037\u000b\u0011\u0011\u0003\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!g\u0001zf)\u0016(D?\u0002\u00124H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA%sE+\u0012*W\u00032\u0003s%M\u00172O\u0001JV)\u0011*!)>\u0003Sj\u0014(U\u0011\u0002zf)\u0016(D?\u0002Je\nV#S-\u0006c\u0005eJ\u00172O\u0001juJ\u0014+Iw)\u0001\u0003\u0005\t\u0011!A\u0001j\u0013g\r\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011\u0011U\u0001\u0006g9\u0002d\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003O\u000b!\"\\1uQ~3WO\\2t\u00039Ie\u000e^3he\u0006dG)\u001b<jI\u0016\u0004\"A\u000e\u0010\u0014\ty\tyK\u0011\t\t\u0003c\u000b9lR$P+6\u0011\u00111\u0017\u0006\u0004\u0003ks\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003s\u000b\u0019LA\tBEN$(/Y2u\rVt7\r^5p]N\"\"!a+\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u0014\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000fU\u000b)-a2\u0002J\")Q)\ta\u0001\u000f\")1*\ta\u0001\u000f\"9Q*\tI\u0001\u0002\u0004y\u0015aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0002\u000fUt\u0017\r\u001d9msR!\u0011\u0011[Ao!\u0015i\u00141[Al\u0013\r\t)N\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0011\ru\nInR$P\u0013\r\tYN\u0010\u0002\u0007)V\u0004H.Z\u001a\t\u0011\u0005}7%!AA\u0002U\u000b1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t9\u000f\u0005\u0003\u0002P\u0005%\u0018\u0002BAv\u0003#\u0012aa\u00142kK\u000e$\b")
public class IntegralDivide
extends BinaryArithmetic
implements DivModLike {
    private Function2<Object, Object, Object> div;
    private final Expression left;
    private final Expression right;
    private final boolean failOnError;
    private Function1<Object, Object> org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero;
    private volatile byte bitmap$0;

    public static boolean $lessinit$greater$default$3() {
        return IntegralDivide$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Object>> unapply(IntegralDivide integralDivide) {
        return IntegralDivide$.MODULE$.unapply(integralDivide);
    }

    public static boolean apply$default$3() {
        return IntegralDivide$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Object>, IntegralDivide> tupled() {
        return IntegralDivide$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Object, IntegralDivide>>> curried() {
        return IntegralDivide$.MODULE$.curried();
    }

    @Override
    public boolean nullable() {
        return DivModLike.nullable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return DivModLike.eval$(this, input);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return DivModLike.doGenCode$(this, ctx, ev);
    }

    private Function1<Object, Object> org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero$lzycompute() {
        IntegralDivide integralDivide = this;
        synchronized (integralDivide) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero = DivModLike.org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero;
    }

    @Override
    public Function1<Object, Object> org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero$lzycompute();
        }
        return this.org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public boolean checkDivideOverflow() {
        DataType dataType = this.left().dataType();
        return LongType$.MODULE$.equals(dataType) && this.failOnError();
    }

    @Override
    public AbstractDataType inputType() {
        return TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{LongType$.MODULE$, DecimalType$.MODULE$, YearMonthIntervalType$.MODULE$, DayTimeIntervalType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public String symbol() {
        return "/";
    }

    @Override
    public String decimalMethod() {
        return "quot";
    }

    @Override
    public String decimalToDataTypeCodeGen(String decimalResult) {
        return new StringBuilder(9).append(decimalResult).append(".toLong()").toString();
    }

    @Override
    public String sqlOperator() {
        return "div";
    }

    private Function2<Object, Object, Object> div$lzycompute() {
        IntegralDivide integralDivide = this;
        synchronized (integralDivide) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Integral<Object> integral;
                DataType dataType = this.left().dataType();
                if (dataType instanceof IntegralType) {
                    IntegralType integralType = (IntegralType)dataType;
                    integral = integralType.integral();
                } else if (dataType instanceof DecimalType) {
                    DecimalType decimalType = (DecimalType)dataType;
                    integral = decimalType.asIntegral();
                } else if (dataType instanceof YearMonthIntervalType) {
                    integral = IntegerType$.MODULE$.integral();
                } else if (dataType instanceof DayTimeIntervalType) {
                    integral = LongType$.MODULE$.integral();
                } else {
                    throw new MatchError((Object)dataType);
                }
                Integral<Object> integral2 = integral;
                this.div = (Function2 & Serializable & scala.Serializable)(x, y) -> {
                    Object res = integral2.quot(x, y);
                    if (res == null) {
                        return null;
                    }
                    return BoxesRunTime.boxToLong((long)integral2.toLong(res));
                };
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.div;
    }

    private Function2<Object, Object, Object> div() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.div$lzycompute();
        }
        return this.div;
    }

    @Override
    public Object evalOperation(Object left, Object right) {
        return this.div().apply(left, right);
    }

    @Override
    public IntegralDivide withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public IntegralDivide copy(Expression left, Expression right, boolean failOnError) {
        return new IntegralDivide(left, right, failOnError);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public boolean copy$default$3() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "IntegralDivide";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
            case 2: {
                return BoxesRunTime.boxToBoolean((boolean)this.failOnError());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof IntegralDivide;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof IntegralDivide)) return false;
        boolean bl = true;
        if (!bl) return false;
        IntegralDivide integralDivide = (IntegralDivide)x$1;
        Expression expression = this.left();
        Expression expression2 = integralDivide.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = integralDivide.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (this.failOnError() != integralDivide.failOnError()) return false;
        if (!integralDivide.canEqual(this)) return false;
        return true;
    }

    public IntegralDivide(Expression left, Expression right, boolean failOnError) {
        this.left = left;
        this.right = right;
        this.failOnError = failOnError;
        DivModLike.$init$(this);
    }

    public IntegralDivide(Expression left, Expression right) {
        this(left, right, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

