/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import java.util.Locale;
import org.apache.spark.sql.catalyst.expressions.CreateMap;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class ExprUtils$ {
    public static ExprUtils$ MODULE$;

    static {
        new ExprUtils$();
    }

    public DataType evalTypeExpr(Expression exp) {
        if (exp.foldable()) {
            UTF8String uTF8String;
            Object object = exp.eval(exp.eval$default$1());
            if (object instanceof UTF8String && (uTF8String = (UTF8String)object) != null) {
                DataType dataType = DataType$.MODULE$.fromDDL(uTF8String.toString());
                return CharVarcharUtils$.MODULE$.failIfHasCharVarchar(dataType);
            }
            throw QueryCompilationErrors$.MODULE$.invalidSchemaStringError(exp);
        }
        throw QueryCompilationErrors$.MODULE$.schemaNotFoldableError(exp);
    }

    public StructType evalSchemaExpr(Expression exp) {
        DataType dataType = this.evalTypeExpr(exp);
        if (!(dataType instanceof StructType)) {
            throw QueryCompilationErrors$.MODULE$.schemaIsNotStructTypeError(dataType);
        }
        return (StructType)dataType;
    }

    public Map<String, String> convertToMapData(Expression exp) {
        boolean bl = false;
        CreateMap createMap = null;
        Expression expression = exp;
        if (expression instanceof CreateMap) {
            bl = true;
            createMap = (CreateMap)expression;
            if (createMap.dataType().acceptsType(new MapType(StringType$.MODULE$, StringType$.MODULE$, false))) {
                ArrayBasedMapData arrayMap = (ArrayBasedMapData)createMap.eval(createMap.eval$default$1());
                return (Map)ArrayBasedMapData$.MODULE$.toScalaMap(arrayMap).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        Object key = tuple2._1();
                        Object value = tuple2._2();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key.toString()), (Object)value.toString());
                    }
                    throw new MatchError((Object)tuple2);
                }, Map$.MODULE$.canBuildFrom());
            }
        }
        if (bl) {
            throw QueryCompilationErrors$.MODULE$.keyValueInMapNotStringError(createMap);
        }
        throw QueryCompilationErrors$.MODULE$.nonMapFunctionNotAllowedError();
    }

    public void verifyColumnNameOfCorruptRecord(StructType schema, String columnNameOfCorruptRecord) {
        schema.getFieldIndex(columnNameOfCorruptRecord).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)corruptFieldIndex -> {
            StructField f = schema.apply(corruptFieldIndex);
            DataType dataType = f.dataType();
            StringType$ stringType$ = StringType$.MODULE$;
            if ((dataType != null ? !dataType.equals(stringType$) : stringType$ != null) || !f.nullable()) {
                throw QueryCompilationErrors$.MODULE$.invalidFieldTypeForCorruptRecordError();
            }
        });
    }

    public Function1<String, BigDecimal> getDecimalParser(Locale locale) {
        Locale locale2 = locale;
        Locale locale3 = Locale.US;
        if (!(locale2 != null ? !((Object)locale2).equals(locale3) : locale3 != null)) {
            return (Function1 & Serializable & scala.Serializable)s -> new BigDecimal(s.replaceAll(",", ""));
        }
        DecimalFormat decimalFormat = new DecimalFormat("", new DecimalFormatSymbols(locale));
        decimalFormat.setParseBigDecimal(true);
        return (Function1 & Serializable & scala.Serializable)s -> {
            ParsePosition pos = new ParsePosition(0);
            BigDecimal result = (BigDecimal)decimalFormat.parse((String)s, pos);
            if (pos.getIndex() != s.length() || pos.getErrorIndex() != -1) {
                throw QueryExecutionErrors$.MODULE$.cannotParseDecimalError();
            }
            return result;
        };
    }

    public Option<Throwable> checkJsonSchema(DataType schema) {
        if (schema.existsRecursively((Function1<DataType, Object>)(Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ExprUtils$.$anonfun$checkJsonSchema$1(x0$1)))) {
            return new Some((Object)QueryCompilationErrors$.MODULE$.invalidJsonSchema(schema));
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$checkJsonSchema$1(DataType x0$1) {
        DataType dataType = x0$1;
        if (dataType instanceof MapType) {
            DataType keyType;
            MapType mapType = (MapType)dataType;
            DataType dataType2 = keyType = mapType.keyType();
            StringType$ stringType$ = StringType$.MODULE$;
            if (dataType2 == null ? stringType$ != null : !dataType2.equals(stringType$)) {
                return true;
            }
        }
        return false;
    }

    private ExprUtils$() {
        MODULE$ = this;
    }
}

