/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.ArrayPosition$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(array, element) - Returns the (1-based) index of the first element of the array as long.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array(3, 2, 1), 1);\n       3\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\t-a\u0001\u0002\u0010 \u00012B\u0001\u0002\u0012\u0001\u0003\u0016\u0004%\t!\u0012\u0005\t\u0013\u0002\u0011\t\u0012)A\u0005\r\"A!\n\u0001BK\u0002\u0013\u0005Q\t\u0003\u0005L\u0001\tE\t\u0015!\u0003G\u0011\u0015a\u0005\u0001\"\u0001N\u0011!\t\u0006\u0001#b\u0001\n\u0013\u0011\u0006\"B3\u0001\t\u00032\u0007\"B7\u0001\t\u0003r\u0007\"B;\u0001\t\u00032\b\"B?\u0001\t\u0003r\bbBA\u0004\u0001\u0011\u0005\u0013\u0011\u0002\u0005\b\u00037\u0001A\u0011IA\u000f\u0011\u001d\tI\u0004\u0001C)\u0003wA\u0011\"!\u0012\u0001\u0003\u0003%\t!a\u0012\t\u0013\u00055\u0003!%A\u0005\u0002\u0005=\u0003\"CA3\u0001E\u0005I\u0011AA(\u0011%\t9\u0007AA\u0001\n\u0003\nI\u0007C\u0005\u0002z\u0001\t\t\u0011\"\u0001\u0002|!I\u00111\u0011\u0001\u0002\u0002\u0013\u0005\u0011Q\u0011\u0005\n\u0003\u0017\u0003\u0011\u0011!C!\u0003\u001bC\u0011\"a'\u0001\u0003\u0003%\t!!(\t\u0013\u0005\u001d\u0006!!A\u0005B\u0005%v!CAg?\u0005\u0005\t\u0012AAh\r!qr$!A\t\u0002\u0005E\u0007B\u0002'\u0019\t\u0003\ty\u000eC\u0005\u0002bb\t\t\u0011\"\u0012\u0002d\"I\u0011Q\u001d\r\u0002\u0002\u0013\u0005\u0015q\u001d\u0005\n\u0003[D\u0012\u0011!CA\u0003_D\u0011B!\u0001\u0019\u0003\u0003%IAa\u0001\u0003\u001b\u0005\u0013(/Y=Q_NLG/[8o\u0015\t\u0001\u0013%A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0012$\u0003!\u0019\u0017\r^1msN$(B\u0001\u0013&\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003M\u001d\nQa\u001d9be.T!\u0001K\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0013aA8sO\u000e\u00011C\u0002\u0001.cQZ\u0014\t\u0005\u0002/_5\tq$\u0003\u00021?\t\u0001\")\u001b8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003]IJ!aM\u0010\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"!\u000e\u001d\u000f\u000592\u0014BA\u001c \u0003\u001d\u0001\u0018mY6bO\u0016L!!\u000f\u001e\u0003\u001d9+H\u000e\\%oi>dWM]1oi*\u0011qg\b\t\u0003y}j\u0011!\u0010\u0006\u0002}\u0005)1oY1mC&\u0011\u0001)\u0010\u0002\b!J|G-^2u!\ta$)\u0003\u0002D{\ta1+\u001a:jC2L'0\u00192mK\u0006!A.\u001a4u+\u00051\u0005C\u0001\u0018H\u0013\tAuD\u0001\u0006FqB\u0014Xm]:j_:\fQ\u0001\\3gi\u0002\nQA]5hQR\faA]5hQR\u0004\u0013A\u0002\u001fj]&$h\bF\u0002O\u001fB\u0003\"A\f\u0001\t\u000b\u0011+\u0001\u0019\u0001$\t\u000b)+\u0001\u0019\u0001$\u0002\u0011=\u0014H-\u001a:j]\u001e,\u0012a\u0015\t\u0004)nsfBA+[\u001d\t1\u0016,D\u0001X\u0015\tA6&\u0001\u0004=e>|GOP\u0005\u0002}%\u0011q'P\u0005\u00039v\u0013\u0001b\u0014:eKJLgn\u001a\u0006\u0003ou\u0002\"\u0001P0\n\u0005\u0001l$aA!os\"\u0012aA\u0019\t\u0003y\rL!\u0001Z\u001f\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003\u001d\u0004\"\u0001[6\u000e\u0003%T!A[\u0012\u0002\u000bQL\b/Z:\n\u00051L'\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001p!\r!\u0006O]\u0005\u0003cv\u00131aU3r!\tA7/\u0003\u0002uS\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0002oB\u0011\u0001p_\u0007\u0002s*\u0011!0I\u0001\tC:\fG._:jg&\u0011A0\u001f\u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\u0006aa.\u001e7m'\u00064W-\u0012<bYR!al`A\u0002\u0011\u0019\t\tA\u0003a\u0001=\u0006\u0019\u0011M\u001d:\t\r\u0005\u0015!\u00021\u0001_\u0003\u00151\u0018\r\\;f\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u0003\u0017\u0001B!!\u0004\u0002\u00169!\u0011qBA\t!\t1V(C\u0002\u0002\u0014u\na\u0001\u0015:fI\u00164\u0017\u0002BA\f\u00033\u0011aa\u0015;sS:<'bAA\n{\u0005IAm\\$f]\u000e{G-\u001a\u000b\u0007\u0003?\tY#!\u000e\u0011\t\u0005\u0005\u0012qE\u0007\u0003\u0003GQ1!!\n \u0003\u001d\u0019w\u000eZ3hK:LA!!\u000b\u0002$\tAQ\t\u001f9s\u0007>$W\rC\u0004\u0002.1\u0001\r!a\f\u0002\u0007\r$\b\u0010\u0005\u0003\u0002\"\u0005E\u0012\u0002BA\u001a\u0003G\u0011abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u000281\u0001\r!a\b\u0002\u0005\u00154\u0018aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\u0015q\u0015QHA!\u0011\u0019\ty$\u0004a\u0001\r\u00069a.Z<MK\u001a$\bBBA\"\u001b\u0001\u0007a)\u0001\u0005oK^\u0014\u0016n\u001a5u\u0003\u0011\u0019w\u000e]=\u0015\u000b9\u000bI%a\u0013\t\u000f\u0011s\u0001\u0013!a\u0001\r\"9!J\u0004I\u0001\u0002\u00041\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003#R3ARA*W\t\t)\u0006\u0005\u0003\u0002X\u0005\u0005TBAA-\u0015\u0011\tY&!\u0018\u0002\u0013Ut7\r[3dW\u0016$'bAA0{\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\r\u0014\u0011\f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005-\u0004\u0003BA7\u0003oj!!a\u001c\u000b\t\u0005E\u00141O\u0001\u0005Y\u0006twM\u0003\u0002\u0002v\u0005!!.\u0019<b\u0013\u0011\t9\"a\u001c\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005u\u0004c\u0001\u001f\u0002\u0000%\u0019\u0011\u0011Q\u001f\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007y\u000b9\tC\u0005\u0002\nN\t\t\u00111\u0001\u0002~\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a$\u0011\u000b\u0005E\u0015q\u00130\u000e\u0005\u0005M%bAAK{\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005e\u00151\u0013\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002 \u0006\u0015\u0006c\u0001\u001f\u0002\"&\u0019\u00111U\u001f\u0003\u000f\t{w\u000e\\3b]\"A\u0011\u0011R\u000b\u0002\u0002\u0003\u0007a,\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003?\u000bY\u000b\u0003\u0005\u0002\nZ\t\t\u00111\u0001_QM\u0001\u0011qVA[\u0003o\u000bY,!0\u0002B\u0006\r\u0017qYAe!\rq\u0013\u0011W\u0005\u0004\u0003g{\"!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003s\u000bqM\u0003\u0011!A\u0001zf)\u0016(D?\"\n'O]1zY\u0001*G.Z7f]RL\u0003%\f\u0011SKR,(O\\:!i\",\u0007\u0005K\u0019.E\u0006\u001cX\rZ\u0015!S:$W\r\u001f\u0011pM\u0002\"\b.\u001a\u0011gSJ\u001cH\u000fI3mK6,g\u000e\u001e\u0011pM\u0002\"\b.\u001a\u0011beJ\f\u0017\u0010I1tA1|gn\u001a\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003\u007f\u000bAI\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015beJ\f\u0017\u0010K\u001a-AIb\u0003%M\u0015-AEJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u001a\u000bA\u0001\nQa\u001a:pkB\f#!!2\u0002\u0017\u0005\u0014(/Y=`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0003\u0017\fQA\r\u00185]A\nQ\"\u0011:sCf\u0004vn]5uS>t\u0007C\u0001\u0018\u0019'\u0011A\u00121[!\u0011\u000f\u0005U\u00171\u001c$G\u001d6\u0011\u0011q\u001b\u0006\u0004\u00033l\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003;\f9NA\tBEN$(/Y2u\rVt7\r^5p]J\"\"!a4\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u001b\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b9\u000bI/a;\t\u000b\u0011[\u0002\u0019\u0001$\t\u000b)[\u0002\u0019\u0001$\u0002\u000fUt\u0017\r\u001d9msR!\u0011\u0011_A\u007f!\u0015a\u00141_A|\u0013\r\t)0\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000bq\nIP\u0012$\n\u0007\u0005mXH\u0001\u0004UkBdWM\r\u0005\t\u0003\u007fd\u0012\u0011!a\u0001\u001d\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005\u000b\u0001B!!\u001c\u0003\b%!!\u0011BA8\u0005\u0019y%M[3di\u0002")
public class ArrayPosition
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private transient Ordering<Object> ordering;
    private final Expression left;
    private final Expression right;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ArrayPosition arrayPosition) {
        return ArrayPosition$.MODULE$.unapply(arrayPosition);
    }

    public static Function1<Tuple2<Expression, Expression>, ArrayPosition> tupled() {
        return ArrayPosition$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ArrayPosition>> curried() {
        return ArrayPosition$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    private Ordering<Object> ordering$lzycompute() {
        ArrayPosition arrayPosition = this;
        synchronized (arrayPosition) {
            if (!this.bitmap$trans$0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.right().dataType());
                this.bitmap$trans$0 = true;
            }
        }
        return this.ordering;
    }

    private Ordering<Object> ordering() {
        if (!this.bitmap$trans$0) {
            return this.ordering$lzycompute();
        }
        return this.ordering;
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType e1 = arrayType.elementType();
                boolean hasNull = arrayType.containsNull();
                Option option = (Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)e1, (Object)e2);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    DataType dt = (DataType)some.value();
                    return (Seq)new .colon.colon((Object)new ArrayType(dt, hasNull), (List)new .colon.colon((Object)dt, (List)Nil$.MODULE$));
                }
                return (Seq)Nil$.MODULE$;
            }
        }
        return (Seq)Nil$.MODULE$;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 != null) {
            ArrayType arrayType;
            DataType e1;
            DataType dataType = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (dataType instanceof ArrayType && (e1 = (arrayType = (ArrayType)dataType).elementType()).sameType(e2)) {
                return TypeUtils$.MODULE$.checkForOrderingExpr(e2, new StringBuilder(9).append("function ").append(this.prettyName()).toString());
            }
        }
        return new TypeCheckResult.TypeCheckFailure(new StringBuilder(95).append("Input to function ").append(this.prettyName()).append(" should have ").append("been ").append(ArrayType$.MODULE$.simpleString()).append(" followed by a value with same element type, but it's ").append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString());
    }

    @Override
    public Object nullSafeEval(Object arr, Object value) {
        Object object;
        Object object2 = new Object();
        try {
            ((ArrayData)arr).foreach(this.right().dataType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(i, v) -> {
                ArrayPosition.$anonfun$nullSafeEval$4(this, value, object2, BoxesRunTime.unboxToInt((Object)i), v);
                return BoxedUnit.UNIT;
            });
            object = BoxesRunTime.boxToLong((long)0L);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object2) {
                object = ex.value();
            }
            throw ex;
        }
        return object;
    }

    @Override
    public String prettyName() {
        return "array_position";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(arr, value) -> {
            String pos = ctx.freshName("arrayPosition");
            String i = ctx.freshName("i");
            String getValue = CodeGenerator$.MODULE$.getValue((String)arr, this.right().dataType(), i);
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(207).append("\n         |int ").append(pos).append(" = 0;\n         |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append((String)arr).append(".numElements(); ").append(i).append(" ++) {\n         |  if (!").append((String)arr).append(".isNullAt(").append(i).append(") && ").append(ctx.genEqual(this.right().dataType(), (String)value, getValue)).append(") {\n         |    ").append(pos).append(" = ").append(i).append(" + 1;\n         |    break;\n         |  }\n         |}\n         |").append(ev.value()).append(" = (long) ").append(pos).append(";\n       ").toString())).stripMargin();
        });
    }

    @Override
    public ArrayPosition withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public ArrayPosition copy(Expression left, Expression right) {
        return new ArrayPosition(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ArrayPosition";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayPosition;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayPosition)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayPosition arrayPosition = (ArrayPosition)x$1;
        Expression expression = this.left();
        Expression expression2 = arrayPosition.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = arrayPosition.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arrayPosition.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$nullSafeEval$4(ArrayPosition $this, Object value$2, Object nonLocalReturnKey4$1, int i, Object v) {
        if (v != null && $this.ordering().equiv(v, value$2)) {
            throw new NonLocalReturnControl.mcJ.sp(nonLocalReturnKey4$1, (long)(i + 1));
        }
    }

    public ArrayPosition(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

