/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ArrayJoin$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.UTF8StringBuilder;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(array, delimiter[, nullReplacement]) - Concatenates the elements of the given array\n      using the delimiter and an optional string to replace nulls. If no value is set for\n      nullReplacement, any null value is filtered.", examples="\n    Examples:\n      > SELECT _FUNC_(array('hello', 'world'), ' ');\n       hello world\n      > SELECT _FUNC_(array('hello', null ,'world'), ' ');\n       hello world\n      > SELECT _FUNC_(array('hello', null ,'world'), ' ', ',');\n       hello , world\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\t-b\u0001B\u0013'\u0001NB\u0001\u0002\u0012\u0001\u0003\u0016\u0004%\t!\u0012\u0005\t\r\u0002\u0011\t\u0012)A\u0005i!Aq\t\u0001BK\u0002\u0013\u0005Q\t\u0003\u0005I\u0001\tE\t\u0015!\u00035\u0011!I\u0005A!f\u0001\n\u0003Q\u0005\u0002\u0003(\u0001\u0005#\u0005\u000b\u0011B&\t\u000b=\u0003A\u0011\u0001)\t\u000b=\u0003A\u0011A+\t\u000b=\u0003A\u0011\u0001-\t\u000bq\u0003A\u0011I/\t\u000bA\u0004A\u0011I9\t\u000bM\u0004A\u0011\u000b;\t\u000bi\u0004A\u0011I>\t\u000b}\u0004A\u0011I>\t\u000f\u0005\u0005\u0001\u0001\"\u0011\u0002\u0004!9\u0011q\u0003\u0001\u0005R\u0005e\u0001bBA\u001b\u0001\u0011%\u0011q\u0007\u0005\b\u0003/\u0002A\u0011IA-\u0011\u001d\t\t\u0007\u0001C!\u0003GB\u0011\"!\u001a\u0001\u0003\u0003%\t!a\u001a\t\u0013\u0005=\u0004!%A\u0005\u0002\u0005E\u0004\"CAD\u0001E\u0005I\u0011AA9\u0011%\tI\tAI\u0001\n\u0003\tY\tC\u0005\u0002\u0010\u0002\t\t\u0011\"\u0011\u0002\u0012\"I\u0011\u0011\u0015\u0001\u0002\u0002\u0013\u0005\u00111\u0015\u0005\n\u0003W\u0003\u0011\u0011!C\u0001\u0003[C\u0011\"a-\u0001\u0003\u0003%\t%!.\t\u0013\u0005\r\u0007!!A\u0005\u0002\u0005\u0015\u0007\"CAe\u0001\u0005\u0005I\u0011IAf\u000f%\tyOJA\u0001\u0012\u0003\t\tP\u0002\u0005&M\u0005\u0005\t\u0012AAz\u0011\u0019yu\u0004\"\u0001\u0003\u0002!I!1A\u0010\u0002\u0002\u0013\u0015#Q\u0001\u0005\n\u0005\u000fy\u0012\u0011!CA\u0005\u0013A\u0011B!\u0005 \u0003\u0003%\tIa\u0005\t\u0013\t\u0005r$!A\u0005\n\t\r\"!C!se\u0006L(j\\5o\u0015\t9\u0003&A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0015+\u0003!\u0019\u0017\r^1msN$(BA\u0016-\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003[9\nQa\u001d9be.T!a\f\u0019\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0014aA8sO\u000e\u00011#\u0002\u00015qm\n\u0005CA\u001b7\u001b\u00051\u0013BA\u001c'\u0005))\u0005\u0010\u001d:fgNLwN\u001c\t\u0003keJ!A\u000f\u0014\u0003#\u0015C\b/Z2ug&s\u0007/\u001e;UsB,7\u000f\u0005\u0002=\u007f5\tQHC\u0001?\u0003\u0015\u00198-\u00197b\u0013\t\u0001UHA\u0004Qe>$Wo\u0019;\u0011\u0005q\u0012\u0015BA\">\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0015\t'O]1z+\u0005!\u0014AB1se\u0006L\b%A\u0005eK2LW.\u001b;fe\u0006QA-\u001a7j[&$XM\u001d\u0011\u0002\u001f9,H\u000e\u001c*fa2\f7-Z7f]R,\u0012a\u0013\t\u0004y1#\u0014BA'>\u0005\u0019y\u0005\u000f^5p]\u0006\u0001b.\u001e7m%\u0016\u0004H.Y2f[\u0016tG\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\tE\u00136\u000b\u0016\t\u0003k\u0001AQ\u0001R\u0004A\u0002QBQaR\u0004A\u0002QBQ!S\u0004A\u0002-#2!\u0015,X\u0011\u0015!\u0005\u00021\u00015\u0011\u00159\u0005\u00021\u00015)\u0011\t\u0016LW.\t\u000b\u0011K\u0001\u0019\u0001\u001b\t\u000b\u001dK\u0001\u0019\u0001\u001b\t\u000b%K\u0001\u0019\u0001\u001b\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001_!\ryvM\u001b\b\u0003A\u0016t!!\u00193\u000e\u0003\tT!a\u0019\u001a\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0014B\u00014>\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001[5\u0003\u0007M+\u0017O\u0003\u0002g{A\u00111N\\\u0007\u0002Y*\u0011QNK\u0001\u0006if\u0004Xm]\u0005\u0003_2\u0014\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0011\rD\u0017\u000e\u001c3sK:,\u0012A\u001d\t\u0004?\u001e$\u0014aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\t!T\u000fC\u0003w\u0019\u0001\u0007q/A\u0006oK^\u001c\u0005.\u001b7ee\u0016t\u0007cA0yi%\u0011\u00110\u001b\u0002\u000b\u0013:$W\r_3e'\u0016\f\u0018\u0001\u00038vY2\f'\r\\3\u0016\u0003q\u0004\"\u0001P?\n\u0005yl$a\u0002\"p_2,\u0017M\\\u0001\tM>dG-\u00192mK\u0006!QM^1m)\u0011\t)!a\u0003\u0011\u0007q\n9!C\u0002\u0002\nu\u00121!\u00118z\u0011%\tia\u0004I\u0001\u0002\u0004\ty!A\u0003j]B,H\u000f\u0005\u0003\u0002\u0012\u0005MQ\"\u0001\u0015\n\u0007\u0005U\u0001FA\u0006J]R,'O\\1m%><\u0018!\u00033p\u000f\u0016t7i\u001c3f)\u0019\tY\"a\n\u00022A!\u0011QDA\u0012\u001b\t\tyBC\u0002\u0002\"\u0019\nqaY8eK\u001e,g.\u0003\u0003\u0002&\u0005}!\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005%\u0002\u00031\u0001\u0002,\u0005\u00191\r\u001e=\u0011\t\u0005u\u0011QF\u0005\u0005\u0003_\tyB\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005M\u0002\u00031\u0001\u0002\u001c\u0005\u0011QM^\u0001\u001cO\u0016t7i\u001c3f\r>\u0014\u0018I\u001d:bs\u0006sG\rR3mS6LG/\u001a:\u0015\u0011\u0005e\u0012\u0011JA&\u0003\u001b\u0002B!a\u000f\u0002D9!\u0011QHA !\t\tW(C\u0002\u0002Bu\na\u0001\u0015:fI\u00164\u0017\u0002BA#\u0003\u000f\u0012aa\u0015;sS:<'bAA!{!9\u0011\u0011F\tA\u0002\u0005-\u0002bBA\u001a#\u0001\u0007\u00111\u0004\u0005\b\u0003\u001f\n\u0002\u0019AA)\u0003!qW\u000f\u001c7Fm\u0006d\u0007c\u0003\u001f\u0002T\u0005e\u0012\u0011HA\u001d\u0003sI1!!\u0016>\u0005%1UO\\2uS>t7'\u0001\u0005eCR\fG+\u001f9f+\t\tY\u0006E\u0002l\u0003;J1!a\u0018m\u0005!!\u0015\r^1UsB,\u0017A\u00039sKR$\u0018PT1nKV\u0011\u0011\u0011H\u0001\u0005G>\u0004\u0018\u0010F\u0004R\u0003S\nY'!\u001c\t\u000f\u0011#\u0002\u0013!a\u0001i!9q\t\u0006I\u0001\u0002\u0004!\u0004bB%\u0015!\u0003\u0005\raS\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\u0019HK\u00025\u0003kZ#!a\u001e\u0011\t\u0005e\u00141Q\u0007\u0003\u0003wRA!! \u0002\u0000\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0003k\u0014AC1o]>$\u0018\r^5p]&!\u0011QQA>\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!!$+\u0007-\u000b)(A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003'\u0003B!!&\u0002 6\u0011\u0011q\u0013\u0006\u0005\u00033\u000bY*\u0001\u0003mC:<'BAAO\u0003\u0011Q\u0017M^1\n\t\u0005\u0015\u0013qS\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003K\u00032\u0001PAT\u0013\r\tI+\u0010\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u000b\ty\u000bC\u0005\u00022j\t\t\u00111\u0001\u0002&\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a.\u0011\r\u0005e\u0016qXA\u0003\u001b\t\tYLC\u0002\u0002>v\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t-a/\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004y\u0006\u001d\u0007\"CAY9\u0005\u0005\t\u0019AA\u0003\u0003\u0019)\u0017/^1mgR\u0019A0!4\t\u0013\u0005EV$!AA\u0002\u0005\u0015\u0001f\u0005\u0001\u0002R\u0006]\u0017\u0011\\Ao\u0003?\f\u0019/!:\u0002j\u0006-\bcA\u001b\u0002T&\u0019\u0011Q\u001b\u0014\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u00111\\\u0001\u0002Z*\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015beJ\f\u0017\u0010\f\u0011eK2LW.\u001b;fenc\u0003E\\;mYJ+\u0007\u000f\\1dK6,g\u000e^/*A5\u00023i\u001c8dCR,g.\u0019;fg\u0002\"\b.\u001a\u0011fY\u0016lWM\u001c;tA=4\u0007\u0005\u001e5fA\u001dLg/\u001a8!CJ\u0014\u0018-\u001f\u0006!A\u0001\u0002\u0003\u0005I;tS:<\u0007\u0005\u001e5fA\u0011,G.[7ji\u0016\u0014\b%\u00198eA\u0005t\u0007e\u001c9uS>t\u0017\r\u001c\u0011tiJLgn\u001a\u0011u_\u0002\u0012X\r\u001d7bG\u0016\u0004c.\u001e7mg:\u0002\u0013J\u001a\u0011o_\u00022\u0018\r\\;fA%\u001c\be]3uA\u0019|'O\u0003\u0011!A\u0001\u0002\u0003E\\;mYJ+\u0007\u000f\\1dK6,g\u000e\u001e\u0017!C:L\bE\\;mY\u00022\u0018\r\\;fA%\u001c\bEZ5mi\u0016\u0014X\r\u001a\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!9\u0002\u0003sT\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u0019:sCfDs\u0005[3mY><C\u0006I\u0014x_JdGmJ\u0015-A\u001d\u0002s%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!Q\u0016dGn\u001c\u0011x_JdGM\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015beJ\f\u0017\u0010K\u0014iK2dwn\n\u0017!]VdG\u000e\t\u0017(o>\u0014H\u000eZ\u0014*Y\u0001:\u0003eJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A!,G\u000e\\8!o>\u0014H\u000e\u001a\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u0015(Q\u0016dGn\\\u0014-A9,H\u000e\u001c\u0011-O]|'\u000f\u001c3(S1\u0002s\u0005I\u0014-A\u001dbs%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!Q\u0016dGn\u001c\u0011-A]|'\u000f\u001c3\u000bA\u0001\nQa\u001a:pkB\f#!a:\u0002\u0017\u0005\u0014(/Y=`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0003[\fQA\r\u00185]A\n\u0011\"\u0011:sCfTu.\u001b8\u0011\u0005Uz2\u0003B\u0010\u0002v\u0006\u0003\u0002\"a>\u0002~R\"4*U\u0007\u0003\u0003sT1!a?>\u0003\u001d\u0011XO\u001c;j[\u0016LA!a@\u0002z\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0015\u0005\u0005E\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005M\u0015!B1qa2LHcB)\u0003\f\t5!q\u0002\u0005\u0006\t\n\u0002\r\u0001\u000e\u0005\u0006\u000f\n\u0002\r\u0001\u000e\u0005\u0006\u0013\n\u0002\raS\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011)B!\b\u0011\tqb%q\u0003\t\u0007y\teA\u0007N&\n\u0007\tmQH\u0001\u0004UkBdWm\r\u0005\t\u0005?\u0019\u0013\u0011!a\u0001#\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005K\u0001B!!&\u0003(%!!\u0011FAL\u0005\u0019y%M[3di\u0002")
public class ArrayJoin
extends Expression
implements ExpectsInputTypes,
scala.Serializable {
    private final Expression array;
    private final Expression delimiter;
    private final Option<Expression> nullReplacement;

    public static Option<Tuple3<Expression, Expression, Option<Expression>>> unapply(ArrayJoin arrayJoin) {
        return ArrayJoin$.MODULE$.unapply(arrayJoin);
    }

    public static Function1<Tuple3<Expression, Expression, Option<Expression>>, ArrayJoin> tupled() {
        return ArrayJoin$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<Expression>, ArrayJoin>>> curried() {
        return ArrayJoin$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression array() {
        return this.array;
    }

    public Expression delimiter() {
        return this.delimiter;
    }

    public Option<Expression> nullReplacement() {
        return this.nullReplacement;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        if (this.nullReplacement().isDefined()) {
            return (Seq)new .colon.colon((Object)ArrayType$.MODULE$.apply(StringType$.MODULE$), (List)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)Nil$.MODULE$)));
        }
        return (Seq)new .colon.colon((Object)ArrayType$.MODULE$.apply(StringType$.MODULE$), (List)new .colon.colon((Object)StringType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public Seq<Expression> children() {
        if (this.nullReplacement().isDefined()) {
            return (Seq)new .colon.colon((Object)this.array(), (List)new .colon.colon((Object)this.delimiter(), (List)new .colon.colon((Object)((Expression)this.nullReplacement().get()), (List)Nil$.MODULE$)));
        }
        return (Seq)new .colon.colon((Object)this.array(), (List)new .colon.colon((Object)this.delimiter(), (List)Nil$.MODULE$));
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        if (this.nullReplacement().isDefined()) {
            return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1), (Option<Expression>)new Some(newChildren.apply(2)));
        }
        return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1), this.copy$default$3());
    }

    @Override
    public boolean nullable() {
        return this.children().exists((Function1 & Serializable & scala.Serializable)x$34 -> BoxesRunTime.boxToBoolean((boolean)x$34.nullable()));
    }

    @Override
    public boolean foldable() {
        return this.children().forall((Function1 & Serializable & scala.Serializable)x$35 -> BoxesRunTime.boxToBoolean((boolean)x$35.foldable()));
    }

    @Override
    public Object eval(InternalRow input) {
        Function1 & Serializable & scala.Serializable intersect;
        Object arrayEval = this.array().eval(input);
        if (arrayEval == null) {
            return null;
        }
        Object delimiterEval = this.delimiter().eval(input);
        if (delimiterEval == null) {
            return null;
        }
        Option nullReplacementEval = this.nullReplacement().map((Function1 & Serializable & scala.Serializable)x$36 -> x$36.eval(input));
        if (nullReplacementEval.contains(null)) {
            return null;
        }
        UTF8StringBuilder buffer = new UTF8StringBuilder();
        BooleanRef firstItem = BooleanRef.create((boolean)true);
        Option option = nullReplacementEval;
        if (option instanceof Some) {
            Some some = (Some)option;
            Object rep = some.value();
            intersect = (Function1 & Serializable & scala.Serializable)prependDelimiter -> BoxesRunTime.boxToBoolean((boolean)ArrayJoin.$anonfun$eval$8(buffer, delimiterEval, rep, BoxesRunTime.unboxToBoolean((Object)prependDelimiter)));
        } else if (None$.MODULE$.equals(option)) {
            intersect = (Function1 & Serializable & scala.Serializable)x$37 -> BoxesRunTime.boxToBoolean((boolean)ArrayJoin.$anonfun$eval$9(BoxesRunTime.unboxToBoolean((Object)x$37)));
        } else {
            throw new MatchError((Object)option);
        }
        Function1 & Serializable & scala.Serializable nullHandling = intersect;
        ((ArrayData)arrayEval).foreach(StringType$.MODULE$, (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$38, item) -> {
            ArrayJoin.$anonfun$eval$10(nullHandling, firstItem, buffer, delimiterEval, BoxesRunTime.unboxToInt((Object)x$38), item);
            return BoxedUnit.UNIT;
        });
        return buffer.build();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String string;
        Option<Expression> option = this.nullReplacement();
        if (option instanceof Some) {
            Some some = (Some)option;
            Expression replacement = (Expression)some.value();
            ExprCode replacementGen = replacement.genCode(ctx);
            Function3 & Serializable & scala.Serializable nullHandling = (Function3 & Serializable & scala.Serializable)(buffer, delimiter, firstItem) -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(127).append("\n             |if (!").append((String)firstItem).append(") {\n             |  ").append((String)buffer).append(".append(").append((String)delimiter).append(");\n             |}\n             |").append((String)buffer).append(".append(").append(replacementGen.value()).append(");\n             |").append((String)firstItem).append(" = false;\n           ").toString())).stripMargin();
            String execCode = replacement.nullable() ? ctx.nullSafeExec(replacement.nullable(), ExprValue$.MODULE$.exprValueToString(replacementGen.isNull()), this.genCodeForArrayAndDelimiter(ctx, ev, (Function3<String, String, String, String>)nullHandling)) : this.genCodeForArrayAndDelimiter(ctx, ev, (Function3<String, String, String, String>)nullHandling);
            string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(36).append("\n           |").append(replacementGen.code()).append("\n           |").append(execCode).append("\n         ").toString())).stripMargin();
        } else if (None$.MODULE$.equals(option)) {
            string = this.genCodeForArrayAndDelimiter(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(x$39, x$40, x$41) -> "// nulls are ignored");
        } else {
            throw new MatchError(option);
        }
        String code = string;
        if (this.nullable()) {
            return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |boolean ", " = true;\n           |UTF8String ", " = null;\n           |", "\n         "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), code})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
        }
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |UTF8String ", " = null;\n           |", "\n         "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.value(), code})).stripMargin(), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    private String genCodeForArrayAndDelimiter(CodegenContext ctx, ExprCode ev, Function3<String, String, String, String> nullEval) {
        ExprCode arrayGen = this.array().genCode(ctx);
        ExprCode delimiterGen = this.delimiter().genCode(ctx);
        String buffer = ctx.freshName("buffer");
        String bufferClass = UTF8StringBuilder.class.getName();
        String i = ctx.freshName("i");
        String firstItem = ctx.freshName("firstItem");
        String resultCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(331).append("\n         |").append(bufferClass).append(" ").append(buffer).append(" = new ").append(bufferClass).append("();\n         |boolean ").append(firstItem).append(" = true;\n         |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(arrayGen.value()).append(".numElements(); ").append(i).append(" ++) {\n         |  if (").append(arrayGen.value()).append(".isNullAt(").append(i).append(")) {\n         |    ").append(nullEval.apply((Object)buffer, (Object)ExprValue$.MODULE$.exprValueToString(delimiterGen.value()), (Object)firstItem)).append("\n         |  } else {\n         |    if (!").append(firstItem).append(") {\n         |      ").append(buffer).append(".append(").append(delimiterGen.value()).append(");\n         |    }\n         |    ").append(buffer).append(".append(").append(CodeGenerator$.MODULE$.getValue(ExprValue$.MODULE$.exprValueToString(arrayGen.value()), StringType$.MODULE$, i)).append(");\n         |    ").append(firstItem).append(" = false;\n         |  }\n         |}\n         |").append(ev.value()).append(" = ").append(buffer).append(".build();").toString())).stripMargin();
        if (this.array().nullable() || this.delimiter().nullable()) {
            return Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)arrayGen.code()), ctx.nullSafeExec(this.array().nullable(), ExprValue$.MODULE$.exprValueToString(arrayGen.isNull()), Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)delimiterGen.code()), ctx.nullSafeExec(this.delimiter().nullable(), ExprValue$.MODULE$.exprValueToString(delimiterGen.isNull()), new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(39).append("\n             |").append(ev.isNull()).append(" = false;\n             |").append(resultCode).toString())).stripMargin()))));
        }
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(33).append("\n         |").append(arrayGen.code()).append("\n         |").append(delimiterGen.code()).append("\n         |").append(resultCode).toString())).stripMargin();
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "array_join";
    }

    public ArrayJoin copy(Expression array, Expression delimiter, Option<Expression> nullReplacement) {
        return new ArrayJoin(array, delimiter, nullReplacement);
    }

    public Expression copy$default$1() {
        return this.array();
    }

    public Expression copy$default$2() {
        return this.delimiter();
    }

    public Option<Expression> copy$default$3() {
        return this.nullReplacement();
    }

    @Override
    public String productPrefix() {
        return "ArrayJoin";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.array();
            }
            case 1: {
                return this.delimiter();
            }
            case 2: {
                return this.nullReplacement();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayJoin;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayJoin)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayJoin arrayJoin = (ArrayJoin)x$1;
        Expression expression = this.array();
        Expression expression2 = arrayJoin.array();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.delimiter();
        Expression expression4 = arrayJoin.delimiter();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<Expression> option = this.nullReplacement();
        Option<Expression> option2 = arrayJoin.nullReplacement();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!arrayJoin.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$eval$8(UTF8StringBuilder buffer$1, Object delimiterEval$1, Object rep$1, boolean prependDelimiter) {
        if (!prependDelimiter) {
            buffer$1.append((UTF8String)delimiterEval$1);
        }
        buffer$1.append((UTF8String)rep$1);
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$eval$9(boolean x$37) {
        return false;
    }

    public static final /* synthetic */ void $anonfun$eval$10(Function1 nullHandling$1, BooleanRef firstItem$1, UTF8StringBuilder buffer$1, Object delimiterEval$1, int x$38, Object item) {
        if (item == null) {
            if (BoxesRunTime.unboxToBoolean((Object)nullHandling$1.apply((Object)BoxesRunTime.boxToBoolean((boolean)firstItem$1.elem)))) {
                firstItem$1.elem = false;
                return;
            }
            return;
        }
        if (!firstItem$1.elem) {
            buffer$1.append((UTF8String)delimiterEval$1);
        }
        buffer$1.append((UTF8String)item);
        firstItem$1.elem = false;
    }

    public ArrayJoin(Expression array, Expression delimiter, Option<Expression> nullReplacement) {
        this.array = array;
        this.delimiter = delimiter;
        this.nullReplacement = nullReplacement;
        ExpectsInputTypes.$init$(this);
    }

    public ArrayJoin(Expression array, Expression delimiter) {
        this(array, delimiter, (Option<Expression>)None$.MODULE$);
    }

    public ArrayJoin(Expression array, Expression delimiter, Expression nullReplacement) {
        this(array, delimiter, (Option<Expression>)new Some((Object)nullReplacement));
    }
}

