/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.DatabaseAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchDatabaseException;
import org.apache.spark.sql.catalyst.analysis.NoSuchPartitionException;
import org.apache.spark.sql.catalyst.analysis.NoSuchPartitionsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.PartitionAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.PartitionsAlreadyExistException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.CatalogFunction;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalog;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogUtils$;
import org.apache.spark.sql.catalyst.catalog.FunctionResource;
import org.apache.spark.sql.catalyst.catalog.InMemoryCatalog$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.util.StringUtils$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0011-a\u0001\u0002'N\u0001iC\u0001\"\u001a\u0001\u0003\u0002\u0003\u0006IA\u001a\u0005\tU\u0002\u0011\t\u0011)A\u0005W\")!\u000f\u0001C\u0001g\u001a!q\u000f\u0001\u0003y\u0011!IHA!a\u0001\n\u0003Q\b\u0002\u0003@\u0005\u0005\u0003\u0007I\u0011A@\t\u0013\u0005-AA!A!B\u0013Y\bB\u0002:\u0005\t\u0003\ti\u0001C\u0005\u0002\u0016\u0011\u0001\r\u0011\"\u0001\u0002\u0018!I\u0011Q\b\u0003A\u0002\u0013\u0005\u0011q\b\u0005\t\u0003\u0007\"\u0001\u0015)\u0003\u0002\u001a\u00191\u0011Q\t\u0001\u0005\u0003\u000fB!\"!\u0013\r\u0005\u0003\u0007I\u0011AA&\u0011)\t\u0019\u0006\u0004BA\u0002\u0013\u0005\u0011Q\u000b\u0005\u000b\u00033b!\u0011!Q!\n\u00055\u0003B\u0002:\r\t\u0003\tY\u0006C\u0005\u0002b1\u0011\r\u0011\"\u0001\u0002d!A\u0011Q\u0010\u0007!\u0002\u0013\t)\u0007C\u0005\u0002\u00001\u0011\r\u0011\"\u0001\u0002\u0002\"A\u00111\u0012\u0007!\u0002\u0013\t\u0019\t\u0003\u0005O\u0001\t\u0007I\u0011BAG\u0011!\t\t\n\u0001Q\u0001\n\u0005=\u0005bBAJ\u0001\u0011%\u0011Q\u0013\u0005\b\u0003K\u0003A\u0011BAT\u0011\u001d\ti\u000b\u0001C\u0005\u0003_Cq!a3\u0001\t\u0013\ti\rC\u0004\u0002V\u0002!I!a6\t\u000f\u0005m\b\u0001\"\u0003\u0002~\"9\u0011Q\u001b\u0001\u0005\n\t\u0005\u0001b\u0002B\u0005\u0001\u0011\u0005#1\u0002\u0005\b\u0005+\u0001A\u0011\tB\f\u0011\u001d\u0011\u0019\u0003\u0001C!\u0005KAqA!\u000b\u0001\t\u0003\u0012Y\u0003C\u0004\u00030\u0001!\tE!\r\t\u000f\tU\u0002\u0001\"\u0011\u00038!9!Q\u0007\u0001\u0005B\tm\u0002b\u0002B!\u0001\u0011\u0005#1\t\u0005\b\u0005\u000f\u0002A\u0011\tB%\u0011\u001d\u0011\t\u0006\u0001C!\u0005'BqAa\u0018\u0001\t\u0003\u0012\t\u0007C\u0004\u0003n\u0001!\tEa\u001c\t\u000f\tM\u0004\u0001\"\u0011\u0003v!9!1\u0012\u0001\u0005B\t5\u0005b\u0002BR\u0001\u0011\u0005#Q\u0015\u0005\b\u0005W\u0003A\u0011\tBW\u0011\u001d\u0011)\f\u0001C!\u0005oCqA!0\u0001\t\u0003\u0012y\fC\u0004\u0003>\u0002!\tEa1\t\u000f\t%\u0007\u0001\"\u0011\u0003L\"9!\u0011\u001b\u0001\u0005B\tM\u0007b\u0002Bs\u0001\u0011\u0005#q\u001d\u0005\b\u0005w\u0004A\u0011\tB\u007f\u0011\u001d\u0019)\u0002\u0001C!\u0007/Aqaa\t\u0001\t\u0003\u001a)\u0003C\u0004\u00046\u0001!\tea\u000e\t\u000f\r\u0015\u0003\u0001\"\u0011\u0004H!91\u0011\u000b\u0001\u0005B\rM\u0003bBB/\u0001\u0011\u00053q\f\u0005\b\u0007S\u0002A\u0011IB6\u0011%\u0019)\bAI\u0001\n\u0003\u00199\bC\u0004\u0004\u000e\u0002!\tea$\t\u0013\re\u0005!%A\u0005\u0002\r]\u0004bBBN\u0001\u0011\u00053Q\u0014\u0005\b\u0007s\u0003A\u0011IB^\u0011\u001d\u0019\u0019\r\u0001C!\u0007\u000bDqa!4\u0001\t\u0003\u001ay\rC\u0004\u0004V\u0002!\tea6\t\u000f\r}\u0007\u0001\"\u0011\u0004b\"91q\u001d\u0001\u0005B\r%\bbBBx\u0001\u0011\u00053\u0011_\u0004\n\u0007ol\u0015\u0011!E\u0001\u0007s4\u0001\u0002T'\u0002\u0002#\u000511 \u0005\u0007e\"#\ta!@\t\u0013\r}\b*%A\u0005\u0002\u0011\u0005\u0001\"\u0003C\u0003\u0011F\u0005I\u0011\u0001C\u0004\u0005=Ie.T3n_JL8)\u0019;bY><'B\u0001(P\u0003\u001d\u0019\u0017\r^1m_\u001eT!\u0001U)\u0002\u0011\r\fG/\u00197zgRT!AU*\u0002\u0007M\fHN\u0003\u0002U+\u0006)1\u000f]1sW*\u0011akV\u0001\u0007CB\f7\r[3\u000b\u0003a\u000b1a\u001c:h\u0007\u0001\u00192\u0001A.b!\tav,D\u0001^\u0015\u0005q\u0016!B:dC2\f\u0017B\u00011^\u0005\u0019\te.\u001f*fMB\u0011!mY\u0007\u0002\u001b&\u0011A-\u0014\u0002\u0010\u000bb$XM\u001d8bY\u000e\u000bG/\u00197pO\u0006!1m\u001c8g!\t9\u0007.D\u0001T\u0013\tI7KA\u0005Ta\u0006\u00148nQ8oM\u0006a\u0001.\u00193p_B\u001cuN\u001c4jOB\u0011A\u000e]\u0007\u0002[*\u0011QM\u001c\u0006\u0003_V\u000ba\u0001[1e_>\u0004\u0018BA9n\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u00061A(\u001b8jiz\"2\u0001^;w!\t\u0011\u0007\u0001C\u0004f\u0007A\u0005\t\u0019\u00014\t\u000f)\u001c\u0001\u0013!a\u0001W\nIA+\u00192mK\u0012+7oY\n\u0003\tm\u000bQ\u0001^1cY\u0016,\u0012a\u001f\t\u0003ErL!!`'\u0003\u0019\r\u000bG/\u00197pOR\u000b'\r\\3\u0002\u0013Q\f'\r\\3`I\u0015\fH\u0003BA\u0001\u0003\u000f\u00012\u0001XA\u0002\u0013\r\t)!\u0018\u0002\u0005+:LG\u000f\u0003\u0005\u0002\n\u0019\t\t\u00111\u0001|\u0003\rAH%M\u0001\u0007i\u0006\u0014G.\u001a\u0011\u0015\t\u0005=\u00111\u0003\t\u0004\u0003#!Q\"\u0001\u0001\t\u000beD\u0001\u0019A>\u0002\u0015A\f'\u000f^5uS>t7/\u0006\u0002\u0002\u001aAA\u00111DA\u0013\u0003S\t9$\u0004\u0002\u0002\u001e)!\u0011qDA\u0011\u0003\u001diW\u000f^1cY\u0016T1!a\t^\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003O\tiBA\u0004ICNDW*\u00199\u0011\t\u0005-\u0012\u0011\u0007\b\u0004E\u00065\u0012bAA\u0018\u001b\u0006a1)\u0019;bY><G+\u001f9fg&!\u00111GA\u001b\u0005I!\u0016M\u00197f!\u0006\u0014H/\u001b;j_:\u001c\u0006/Z2\u000b\u0007\u0005=R\nE\u0002c\u0003sI1!a\u000fN\u0005U\u0019\u0015\r^1m_\u001e$\u0016M\u00197f!\u0006\u0014H/\u001b;j_:\fa\u0002]1si&$\u0018n\u001c8t?\u0012*\u0017\u000f\u0006\u0003\u0002\u0002\u0005\u0005\u0003\"CA\u0005\u0015\u0005\u0005\t\u0019AA\r\u0003-\u0001\u0018M\u001d;ji&|gn\u001d\u0011\u0003\u0019\u0011\u000bG/\u00192bg\u0016$Um]2\u0014\u00051Y\u0016A\u00013c+\t\ti\u0005E\u0002c\u0003\u001fJ1!!\u0015N\u0005=\u0019\u0015\r^1m_\u001e$\u0015\r^1cCN,\u0017A\u00023c?\u0012*\u0017\u000f\u0006\u0003\u0002\u0002\u0005]\u0003\"CA\u0005\u001d\u0005\u0005\t\u0019AA'\u0003\r!'\r\t\u000b\u0005\u0003;\ny\u0006E\u0002\u0002\u00121Aq!!\u0013\u0011\u0001\u0004\ti%\u0001\u0004uC\ndWm]\u000b\u0003\u0003K\u0002\u0002\"a\u0007\u0002&\u0005\u001d\u0014q\u0002\t\u0005\u0003S\n9H\u0004\u0003\u0002l\u0005M\u0004cAA7;6\u0011\u0011q\u000e\u0006\u0004\u0003cJ\u0016A\u0002\u001fs_>$h(C\u0002\u0002vu\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA=\u0003w\u0012aa\u0015;sS:<'bAA;;\u00069A/\u00192mKN\u0004\u0013!\u00034v]\u000e$\u0018n\u001c8t+\t\t\u0019\t\u0005\u0005\u0002\u001c\u0005\u0015\u0012qMAC!\r\u0011\u0017qQ\u0005\u0004\u0003\u0013k%aD\"bi\u0006dwn\u001a$v]\u000e$\u0018n\u001c8\u0002\u0015\u0019,hn\u0019;j_:\u001c\b%\u0006\u0002\u0002\u0010BA\u00111DA\u0013\u0003O\ni&\u0001\u0005dCR\fGn\\4!\u0003=\u0001\u0018M\u001d;ji&|g.\u0012=jgR\u001cH\u0003CAL\u0003;\u000by*!)\u0011\u0007q\u000bI*C\u0002\u0002\u001cv\u0013qAQ8pY\u0016\fg\u000eC\u0004\u0002J]\u0001\r!a\u001a\t\re<\u0002\u0019AA4\u0011\u001d\t\u0019k\u0006a\u0001\u0003S\tAa\u001d9fG\u0006)\"/Z9vSJ,G+\u00192mK:{G/\u0012=jgR\u001cHCBA\u0001\u0003S\u000bY\u000bC\u0004\u0002Ja\u0001\r!a\u001a\t\reD\u0002\u0019AA4\u0003Y\u0011X-];je\u0016\u0004\u0016M\u001d;ji&|gn]#ySN$H\u0003CA\u0001\u0003c\u000b\u0019,!.\t\u000f\u0005%\u0013\u00041\u0001\u0002h!1\u00110\u0007a\u0001\u0003OBq!a.\u001a\u0001\u0004\tI,A\u0003ta\u0016\u001c7\u000f\u0005\u0004\u0002<\u0006\u0015\u0017\u0011\u0006\b\u0005\u0003{\u000b\tM\u0004\u0003\u0002n\u0005}\u0016\"\u00010\n\u0007\u0005\rW,A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u001d\u0017\u0011\u001a\u0002\u0004'\u0016\f(bAAb;\u0006I\"/Z9vSJ,\u0007+\u0019:uSRLwN\\:O_R,\u00050[:u)!\t\t!a4\u0002R\u0006M\u0007bBA%5\u0001\u0007\u0011q\r\u0005\u0007sj\u0001\r!a\u001a\t\u000f\u0005]&\u00041\u0001\u0002:\u00061Bo\\\"bi\u0006dwn\u001a)beRLG/[8o'B,7-\u0006\u0002\u0002ZB9A,a7\u0002`\u0006}\u0017bAAo;\nIa)\u001e8di&|g.\r\t\u0005\u0003C\f\tD\u0004\u0003\u0002d\u00065b\u0002BAs\u0003stA!a:\u0002x:!\u0011\u0011^A{\u001d\u0011\tY/a=\u000f\t\u00055\u0018\u0011\u001f\b\u0005\u0003[\ny/C\u0001Y\u0013\t1v+\u0003\u0002U+&\u0011!kU\u0005\u0003!FK!AT(\u0002/Q|7)\u0019;bY><\u0007+\u0019:uSRLwN\\*qK\u000e\u001cH\u0003BA]\u0003\u007fDq!a.\u001d\u0001\u0004\tI\f\u0006\u0003\u0003\u0004\t\u0015\u0001CBA^\u0003\u000b\f9\u0004C\u0004\u0003\bu\u0001\rAa\u0001\u0002\u000bA\f'\u000f^:\u0002\u001d\r\u0014X-\u0019;f\t\u0006$\u0018MY1tKR1\u0011\u0011\u0001B\u0007\u0005#AqAa\u0004\u001f\u0001\u0004\ti%\u0001\u0007eE\u0012+g-\u001b8ji&|g\u000eC\u0004\u0003\u0014y\u0001\r!a&\u0002\u001d%<gn\u001c:f\u0013\u001a,\u00050[:ug\u0006aAM]8q\t\u0006$\u0018MY1tKRA\u0011\u0011\u0001B\r\u00057\u0011y\u0002C\u0004\u0002J}\u0001\r!a\u001a\t\u000f\tuq\u00041\u0001\u0002\u0018\u0006\t\u0012n\u001a8pe\u0016LeMT8u\u000bbL7\u000f^:\t\u000f\t\u0005r\u00041\u0001\u0002\u0018\u000691-Y:dC\u0012,\u0017!D1mi\u0016\u0014H)\u0019;bE\u0006\u001cX\r\u0006\u0003\u0002\u0002\t\u001d\u0002b\u0002B\bA\u0001\u0007\u0011QJ\u0001\fO\u0016$H)\u0019;bE\u0006\u001cX\r\u0006\u0003\u0002N\t5\u0002bBA%C\u0001\u0007\u0011qM\u0001\u000fI\u0006$\u0018MY1tK\u0016C\u0018n\u001d;t)\u0011\t9Ja\r\t\u000f\u0005%#\u00051\u0001\u0002h\u0005iA.[:u\t\u0006$\u0018MY1tKN$\"A!\u000f\u0011\r\u0005m\u0016QYA4)\u0011\u0011ID!\u0010\t\u000f\t}B\u00051\u0001\u0002h\u00059\u0001/\u0019;uKJt\u0017AE:fi\u000e+(O]3oi\u0012\u000bG/\u00192bg\u0016$B!!\u0001\u0003F!9\u0011\u0011J\u0013A\u0002\u0005\u001d\u0014aC2sK\u0006$X\rV1cY\u0016$b!!\u0001\u0003L\t=\u0003B\u0002B'M\u0001\u000710A\buC\ndW\rR3gS:LG/[8o\u0011\u001d\u0011\u0019B\na\u0001\u0003/\u000b\u0011\u0002\u001a:paR\u000b'\r\\3\u0015\u0015\u0005\u0005!Q\u000bB,\u00053\u0012Y\u0006C\u0004\u0002J\u001d\u0002\r!a\u001a\t\re<\u0003\u0019AA4\u0011\u001d\u0011ib\na\u0001\u0003/CqA!\u0018(\u0001\u0004\t9*A\u0003qkJ<W-A\u0006sK:\fW.\u001a+bE2,G\u0003CA\u0001\u0005G\u0012)G!\u001b\t\u000f\u0005%\u0003\u00061\u0001\u0002h!9!q\r\u0015A\u0002\u0005\u001d\u0014aB8mI:\u000bW.\u001a\u0005\b\u0005WB\u0003\u0019AA4\u0003\u001dqWm\u001e(b[\u0016\f!\"\u00197uKJ$\u0016M\u00197f)\u0011\t\tA!\u001d\t\r\t5\u0013\u00061\u0001|\u0003Q\tG\u000e^3s)\u0006\u0014G.\u001a#bi\u0006\u001c6\r[3nCRA\u0011\u0011\u0001B<\u0005s\u0012Y\bC\u0004\u0002J)\u0002\r!a\u001a\t\reT\u0003\u0019AA4\u0011\u001d\u0011iH\u000ba\u0001\u0005\u007f\nQB\\3x\t\u0006$\u0018mU2iK6\f\u0007\u0003\u0002BA\u0005\u000fk!Aa!\u000b\u0007\t\u0015\u0015+A\u0003usB,7/\u0003\u0003\u0003\n\n\r%AC*ueV\u001cG\u000fV=qK\u0006y\u0011\r\u001c;feR\u000b'\r\\3Ti\u0006$8\u000f\u0006\u0005\u0002\u0002\t=%\u0011\u0013BJ\u0011\u001d\tIe\u000ba\u0001\u0003OBa!_\u0016A\u0002\u0005\u001d\u0004b\u0002BKW\u0001\u0007!qS\u0001\u0006gR\fGo\u001d\t\u00069\ne%QT\u0005\u0004\u00057k&AB(qi&|g\u000eE\u0002c\u0005?K1A!)N\u0005E\u0019\u0015\r^1m_\u001e\u001cF/\u0019;jgRL7m]\u0001\tO\u0016$H+\u00192mKR)1Pa*\u0003*\"9\u0011\u0011\n\u0017A\u0002\u0005\u001d\u0004BB=-\u0001\u0004\t9'A\bhKR$\u0016M\u00197fg\nKh*Y7f)\u0019\u0011yK!-\u00034B)\u00111XAcw\"9\u0011\u0011J\u0017A\u0002\u0005\u001d\u0004bBA1[\u0001\u0007!\u0011H\u0001\fi\u0006\u0014G.Z#ySN$8\u000f\u0006\u0004\u0002\u0018\ne&1\u0018\u0005\b\u0003\u0013r\u0003\u0019AA4\u0011\u0019Ih\u00061\u0001\u0002h\u0005QA.[:u)\u0006\u0014G.Z:\u0015\t\te\"\u0011\u0019\u0005\b\u0003\u0013z\u0003\u0019AA4)\u0019\u0011ID!2\u0003H\"9\u0011\u0011\n\u0019A\u0002\u0005\u001d\u0004b\u0002B a\u0001\u0007\u0011qM\u0001\nY&\u001cHOV5foN$bA!\u000f\u0003N\n=\u0007bBA%c\u0001\u0007\u0011q\r\u0005\b\u0005\u007f\t\u0004\u0019AA4\u0003%aw.\u00193UC\ndW\r\u0006\u0007\u0002\u0002\tU'q\u001bBm\u0005;\u0014\t\u000fC\u0004\u0002JI\u0002\r!a\u001a\t\re\u0014\u0004\u0019AA4\u0011\u001d\u0011YN\ra\u0001\u0003O\n\u0001\u0002\\8bIB\u000bG\u000f\u001b\u0005\b\u0005?\u0014\u0004\u0019AAL\u0003-I7o\u0014<fe^\u0014\u0018\u000e^3\t\u000f\t\r(\u00071\u0001\u0002\u0018\u0006Q\u0011n]*sG2{7-\u00197\u0002\u001b1|\u0017\r\u001a)beRLG/[8o)A\t\tA!;\u0003l\n5(q\u001eBz\u0005k\u0014I\u0010C\u0004\u0002JM\u0002\r!a\u001a\t\re\u001c\u0004\u0019AA4\u0011\u001d\u0011Yn\ra\u0001\u0003OBqA!=4\u0001\u0004\tI#A\u0005qCJ$\u0018\u000e^5p]\"9!q\\\u001aA\u0002\u0005]\u0005b\u0002B|g\u0001\u0007\u0011qS\u0001\u0012S:DWM]5u)\u0006\u0014G.Z*qK\u000e\u001c\bb\u0002Brg\u0001\u0007\u0011qS\u0001\u0016Y>\fG\rR=oC6L7\rU1si&$\u0018n\u001c8t)9\t\tAa@\u0004\u0002\r\r1QAB\u0004\u0007\u0017Aq!!\u00135\u0001\u0004\t9\u0007\u0003\u0004zi\u0001\u0007\u0011q\r\u0005\b\u00057$\u0004\u0019AA4\u0011\u001d\u0011\t\u0010\u000ea\u0001\u0003SAqa!\u00035\u0001\u0004\t9*A\u0004sKBd\u0017mY3\t\u000f\r5A\u00071\u0001\u0004\u0010\u0005)a.^7E!B\u0019Al!\u0005\n\u0007\rMQLA\u0002J]R\f\u0001c\u0019:fCR,\u0007+\u0019:uSRLwN\\:\u0015\u0015\u0005\u00051\u0011DB\u000e\u0007;\u0019\t\u0003C\u0004\u0002JU\u0002\r!a\u001a\t\re,\u0004\u0019AA4\u0011\u001d\u0019y\"\u000ea\u0001\u0005\u0007\t\u0001B\\3x!\u0006\u0014Ho\u001d\u0005\b\u0005')\u0004\u0019AAL\u00039!'o\u001c9QCJ$\u0018\u000e^5p]N$b\"!\u0001\u0004(\r%21FB\u0017\u0007_\u0019\t\u0004C\u0004\u0002JY\u0002\r!a\u001a\t\re4\u0004\u0019AA4\u0011\u001d\u00119A\u000ea\u0001\u0003sCqA!\b7\u0001\u0004\t9\nC\u0004\u0003^Y\u0002\r!a&\t\u000f\rMb\u00071\u0001\u0002\u0018\u0006Q!/\u001a;bS:$\u0015\r^1\u0002!I,g.Y7f!\u0006\u0014H/\u001b;j_:\u001cHCCA\u0001\u0007s\u0019Yd!\u0010\u0004B!9\u0011\u0011J\u001cA\u0002\u0005\u001d\u0004BB=8\u0001\u0004\t9\u0007C\u0004\u0004@]\u0002\r!!/\u0002\u0013\u0019\u0014x.\\*qK\u000e\u001c\bbBB\"o\u0001\u0007\u0011\u0011X\u0001\bi>\u001c\u0006/Z2t\u0003=\tG\u000e^3s!\u0006\u0014H/\u001b;j_:\u001cH\u0003CA\u0001\u0007\u0013\u001aYe!\u0014\t\u000f\u0005%\u0003\b1\u0001\u0002h!1\u0011\u0010\u000fa\u0001\u0003OBqaa\u00149\u0001\u0004\u0011\u0019!\u0001\u0006bYR,'\u000fU1siN\fAbZ3u!\u0006\u0014H/\u001b;j_:$\u0002\"a\u000e\u0004V\r]3\u0011\f\u0005\b\u0003\u0013J\u0004\u0019AA4\u0011\u0019I\u0018\b1\u0001\u0002h!911L\u001dA\u0002\u0005%\u0012\u0001\u00039beR\u001c\u0006/Z2\u0002%\u001d,G\u000fU1si&$\u0018n\u001c8PaRLwN\u001c\u000b\t\u0007C\u001a\u0019g!\u001a\u0004hA)AL!'\u00028!9\u0011\u0011\n\u001eA\u0002\u0005\u001d\u0004BB=;\u0001\u0004\t9\u0007C\u0004\u0004\\i\u0002\r!!\u000b\u0002%1L7\u000f\u001e)beRLG/[8o\u001d\u0006lWm\u001d\u000b\t\u0005s\u0019iga\u001c\u0004r!9\u0011\u0011J\u001eA\u0002\u0005\u001d\u0004BB=<\u0001\u0004\t9\u0007C\u0005\u0004\\m\u0002\n\u00111\u0001\u0004tA)AL!'\u0002*\u0005aB.[:u!\u0006\u0014H/\u001b;j_:t\u0015-\\3tI\u0011,g-Y;mi\u0012\u001aTCAB=U\u0011\u0019\u0019ha\u001f,\u0005\ru\u0004\u0003BB@\u0007\u0013k!a!!\u000b\t\r\r5QQ\u0001\nk:\u001c\u0007.Z2lK\u0012T1aa\"^\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007\u0017\u001b\tIA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fa\u0002\\5tiB\u000b'\u000f^5uS>t7\u000f\u0006\u0005\u0003\u0004\rE51SBK\u0011\u001d\tI%\u0010a\u0001\u0003OBa!_\u001fA\u0002\u0005\u001d\u0004\"CBL{A\u0005\t\u0019AB:\u0003-\u0001\u0018M\u001d;jC2\u001c\u0006/Z2\u000211L7\u000f\u001e)beRLG/[8og\u0012\"WMZ1vYR$3'\u0001\fmSN$\b+\u0019:uSRLwN\\:Cs\u001aKG\u000e^3s))\u0011\u0019aa(\u0004\"\u000e\r6Q\u0017\u0005\b\u0003\u0013z\u0004\u0019AA4\u0011\u0019Ix\b1\u0001\u0002h!91QU A\u0002\r\u001d\u0016A\u00039sK\u0012L7-\u0019;fgB1\u00111XAc\u0007S\u0003Baa+\u000426\u00111Q\u0016\u0006\u0004\u0007_{\u0015aC3yaJ,7o]5p]NLAaa-\u0004.\nQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u000f\r]v\b1\u0001\u0002h\u0005\tB-\u001a4bk2$H+[7f5>tW-\u00133\u0002\u001d\r\u0014X-\u0019;f\rVt7\r^5p]R1\u0011\u0011AB_\u0007\u007fCq!!\u0013A\u0001\u0004\t9\u0007C\u0004\u0004B\u0002\u0003\r!!\"\u0002\t\u0019,hnY\u0001\rIJ|\u0007OR;oGRLwN\u001c\u000b\u0007\u0003\u0003\u00199m!3\t\u000f\u0005%\u0013\t1\u0001\u0002h!911Z!A\u0002\u0005\u001d\u0014\u0001\u00034v]\u000et\u0015-\\3\u0002\u001b\u0005dG/\u001a:Gk:\u001cG/[8o)\u0019\t\ta!5\u0004T\"9\u0011\u0011\n\"A\u0002\u0005\u001d\u0004bBBa\u0005\u0002\u0007\u0011QQ\u0001\u000fe\u0016t\u0017-\\3Gk:\u001cG/[8o)!\t\ta!7\u0004\\\u000eu\u0007bBA%\u0007\u0002\u0007\u0011q\r\u0005\b\u0005O\u001a\u0005\u0019AA4\u0011\u001d\u0011Yg\u0011a\u0001\u0003O\n1bZ3u\rVt7\r^5p]R1\u0011QQBr\u0007KDq!!\u0013E\u0001\u0004\t9\u0007C\u0004\u0004L\u0012\u0003\r!a\u001a\u0002\u001d\u0019,hn\u0019;j_:,\u00050[:ugR1\u0011qSBv\u0007[Dq!!\u0013F\u0001\u0004\t9\u0007C\u0004\u0004L\u0016\u0003\r!a\u001a\u0002\u001b1L7\u000f\u001e$v]\u000e$\u0018n\u001c8t)\u0019\u0011Ida=\u0004v\"9\u0011\u0011\n$A\u0002\u0005\u001d\u0004b\u0002B \r\u0002\u0007\u0011qM\u0001\u0010\u0013:lU-\\8ss\u000e\u000bG/\u00197pOB\u0011!\rS\n\u0003\u0011n#\"a!?\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t!\u0019AK\u0002g\u0007w\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012TC\u0001C\u0005U\rY71\u0010")
public class InMemoryCatalog
implements ExternalCatalog {
    private final Configuration hadoopConfig;
    private final HashMap<String, DatabaseDesc> catalog;

    public static Configuration $lessinit$greater$default$2() {
        return InMemoryCatalog$.MODULE$.$lessinit$greater$default$2();
    }

    public static SparkConf $lessinit$greater$default$1() {
        return InMemoryCatalog$.MODULE$.$lessinit$greater$default$1();
    }

    @Override
    public void requireDbExists(String db) {
        ExternalCatalog.requireDbExists$(this, db);
    }

    @Override
    public void requireTableExists(String db, String table) {
        ExternalCatalog.requireTableExists$(this, db, table);
    }

    @Override
    public void requireFunctionExists(String db, String funcName) {
        ExternalCatalog.requireFunctionExists$(this, db, funcName);
    }

    @Override
    public void requireFunctionNotExists(String db, String funcName) {
        ExternalCatalog.requireFunctionNotExists$(this, db, funcName);
    }

    private HashMap<String, DatabaseDesc> catalog() {
        return this.catalog;
    }

    private boolean partitionExists(String db, String table, Map<String, String> spec) {
        this.requireTableExists(db, table);
        return ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().contains(spec);
    }

    private void requireTableNotExists(String db, String table) {
        if (this.tableExists(db, table)) {
            throw new TableAlreadyExistsException(db, table);
        }
    }

    private void requirePartitionsExist(String db, String table, Seq<Map<String, String>> specs) {
        specs.foreach((Function1 & Serializable & scala.Serializable)s -> {
            InMemoryCatalog.$anonfun$requirePartitionsExist$1(this, db, table, s);
            return BoxedUnit.UNIT;
        });
    }

    private void requirePartitionsNotExist(String db, String table, Seq<Map<String, String>> specs) {
        specs.foreach((Function1 & Serializable & scala.Serializable)s -> {
            InMemoryCatalog.$anonfun$requirePartitionsNotExist$1(this, db, table, s);
            return BoxedUnit.UNIT;
        });
    }

    private Function1<Map<String, String>, Map<String, String>> toCatalogPartitionSpec() {
        return (Function1 & Serializable & scala.Serializable)x$1 -> ExternalCatalogUtils$.MODULE$.convertNullPartitionValues((Map<String, String>)x$1);
    }

    private Seq<Map<String, String>> toCatalogPartitionSpecs(Seq<Map<String, String>> specs) {
        return (Seq)specs.map(this.toCatalogPartitionSpec(), Seq$.MODULE$.canBuildFrom());
    }

    private Seq<CatalogTablePartition> toCatalogPartitionSpec(Seq<CatalogTablePartition> parts) {
        return (Seq)parts.map((Function1 & Serializable & scala.Serializable)part -> part.copy((Map<String, String>)((Map)this.toCatalogPartitionSpec().apply(part.spec())), part.copy$default$2(), part.copy$default$3(), part.copy$default$4(), part.copy$default$5(), part.copy$default$6()), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public void createDatabase(CatalogDatabase dbDefinition, boolean ignoreIfExists) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            BoxedUnit boxedUnit;
            if (this.catalog().contains((Object)dbDefinition.name())) {
                if (!ignoreIfExists) {
                    throw new DatabaseAlreadyExistsException(dbDefinition.name());
                }
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.liftedTree1$1(dbDefinition);
                Map x$1 = dbDefinition.properties().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"owner"), (Object)Utils$.MODULE$.getCurrentUserName())})));
                String x$2 = dbDefinition.copy$default$1();
                String x$3 = dbDefinition.copy$default$2();
                URI x$4 = dbDefinition.copy$default$3();
                CatalogDatabase newDb = dbDefinition.copy(x$2, x$3, x$4, (Map<String, String>)x$1);
                boxedUnit = this.catalog().put((Object)dbDefinition.name(), (Object)new DatabaseDesc(this, newDb));
            }
        }
    }

    @Override
    public void dropDatabase(String db, boolean ignoreIfNotExists, boolean cascade) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            BoxedUnit boxedUnit;
            if (this.catalog().contains((Object)db)) {
                if (!cascade && (((DatabaseDesc)this.catalog().apply((Object)db)).tables().nonEmpty() || ((DatabaseDesc)this.catalog().apply((Object)db)).functions().nonEmpty())) {
                    throw QueryCompilationErrors$.MODULE$.cannotDropNonemptyDatabaseError(db);
                }
                CatalogDatabase dbDefinition = ((DatabaseDesc)this.catalog().apply((Object)db)).db();
                this.liftedTree2$1(dbDefinition);
                boxedUnit = this.catalog().remove((Object)db);
            } else {
                if (!ignoreIfNotExists) {
                    throw new NoSuchDatabaseException(db);
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    @Override
    public synchronized void alterDatabase(CatalogDatabase dbDefinition) {
        this.requireDbExists(dbDefinition.name());
        ((DatabaseDesc)this.catalog().apply((Object)dbDefinition.name())).db_$eq(dbDefinition);
    }

    @Override
    public synchronized CatalogDatabase getDatabase(String db) {
        this.requireDbExists(db);
        return ((DatabaseDesc)this.catalog().apply((Object)db)).db();
    }

    @Override
    public synchronized boolean databaseExists(String db) {
        return this.catalog().contains((Object)db);
    }

    @Override
    public synchronized Seq<String> listDatabases() {
        return (Seq)this.catalog().keySet().toSeq().sorted((Ordering)Ordering.String$.MODULE$);
    }

    @Override
    public synchronized Seq<String> listDatabases(String pattern) {
        return StringUtils$.MODULE$.filterPattern(this.listDatabases(), pattern);
    }

    @Override
    public void setCurrentDatabase(String db) {
    }

    @Override
    public void createTable(CatalogTable tableDefinition, boolean ignoreIfExists) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            BoxedUnit boxedUnit;
            Predef$.MODULE$.assert(tableDefinition.identifier().database().isDefined());
            String db = (String)tableDefinition.identifier().database().get();
            this.requireDbExists(db);
            String table = tableDefinition.identifier().table();
            if (this.tableExists(db, table)) {
                if (!ignoreIfExists) {
                    throw new TableAlreadyExistsException(db, table);
                }
                boxedUnit = BoxedUnit.UNIT;
            } else {
                Map tableProp;
                CatalogTable catalogTable;
                boolean needDefaultTableLocation;
                CatalogTableType catalogTableType = tableDefinition.tableType();
                CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
                boolean bl = !(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null) && tableDefinition.storage().locationUri().isEmpty() ? true : (needDefaultTableLocation = false);
                if (needDefaultTableLocation) {
                    Path defaultTableLocation = new Path(new Path(((DatabaseDesc)this.catalog().apply((Object)db)).db().locationUri()), table);
                    this.liftedTree3$1(defaultTableLocation, table);
                    catalogTable = tableDefinition.withNewStorage((Option<URI>)new Some((Object)defaultTableLocation.toUri()), tableDefinition.withNewStorage$default$2(), tableDefinition.withNewStorage$default$3(), tableDefinition.withNewStorage$default$4(), tableDefinition.withNewStorage$default$5(), tableDefinition.withNewStorage$default$6());
                } else {
                    catalogTable = tableDefinition;
                }
                CatalogTable tableWithLocation = catalogTable;
                Map x$1 = tableProp = (Map)tableWithLocation.properties().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)InMemoryCatalog.$anonfun$createTable$1(x$2)));
                TableIdentifier x$22 = tableWithLocation.copy$default$1();
                CatalogTableType x$3 = tableWithLocation.copy$default$2();
                CatalogStorageFormat x$4 = tableWithLocation.copy$default$3();
                StructType x$5 = tableWithLocation.copy$default$4();
                Option<String> x$6 = tableWithLocation.copy$default$5();
                Seq<String> x$7 = tableWithLocation.copy$default$6();
                Option<BucketSpec> x$8 = tableWithLocation.copy$default$7();
                String x$9 = tableWithLocation.copy$default$8();
                long x$10 = tableWithLocation.copy$default$9();
                long x$11 = tableWithLocation.copy$default$10();
                String x$12 = tableWithLocation.copy$default$11();
                Option<CatalogStatistics> x$13 = tableWithLocation.copy$default$13();
                Option<String> x$14 = tableWithLocation.copy$default$14();
                Option<String> x$15 = tableWithLocation.copy$default$15();
                Seq<String> x$16 = tableWithLocation.copy$default$16();
                boolean x$17 = tableWithLocation.copy$default$17();
                boolean x$18 = tableWithLocation.copy$default$18();
                Map<String, String> x$19 = tableWithLocation.copy$default$19();
                Option<String> x$20 = tableWithLocation.copy$default$20();
                boxedUnit = ((DatabaseDesc)this.catalog().apply((Object)db)).tables().put((Object)table, (Object)new TableDesc(this, tableWithLocation.copy(x$22, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, (Map<String, String>)x$1, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20)));
            }
        }
    }

    @Override
    public void dropTable(String db, String table, boolean ignoreIfNotExists, boolean purge) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            BoxedUnit boxedUnit;
            this.requireDbExists(db);
            if (this.tableExists(db, table)) {
                Object object;
                CatalogTable tableMeta = this.getTable(db, table);
                CatalogTableType catalogTableType = tableMeta.tableType();
                CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
                if (!(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null)) {
                    Seq locationAllParts = (Seq)((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().values().toSeq().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.location(), Seq$.MODULE$.canBuildFrom());
                    locationAllParts.foreach((Function1 & Serializable & scala.Serializable)loc -> BoxesRunTime.boxToBoolean((boolean)InMemoryCatalog.$anonfun$dropTable$2(this, loc)));
                    Predef$.MODULE$.assert(tableMeta.storage().locationUri().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Managed table should always have table location, as we will assign a default location to it if it doesn't have one.");
                    Path dir = new Path(tableMeta.location());
                    object = BoxesRunTime.boxToBoolean((boolean)this.liftedTree4$1(dir, table));
                } else {
                    object = BoxedUnit.UNIT;
                }
                boxedUnit = ((DatabaseDesc)this.catalog().apply((Object)db)).tables().remove((Object)table);
            } else {
                if (!ignoreIfNotExists) {
                    throw new NoSuchTableException(db, table);
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    @Override
    public void renameTable(String db, String oldName, String newName) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireTableExists(db, oldName);
            this.requireTableNotExists(db, newName);
            TableDesc oldDesc = (TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)oldName);
            CatalogTable qual$1 = oldDesc.table();
            TableIdentifier x$1 = new TableIdentifier(newName, (Option<String>)new Some((Object)db));
            CatalogTableType x$2 = qual$1.copy$default$2();
            CatalogStorageFormat x$3 = qual$1.copy$default$3();
            StructType x$4 = qual$1.copy$default$4();
            Option<String> x$5 = qual$1.copy$default$5();
            Seq<String> x$6 = qual$1.copy$default$6();
            Option<BucketSpec> x$7 = qual$1.copy$default$7();
            String x$8 = qual$1.copy$default$8();
            long x$9 = qual$1.copy$default$9();
            long x$10 = qual$1.copy$default$10();
            String x$11 = qual$1.copy$default$11();
            Map<String, String> x$12 = qual$1.copy$default$12();
            Option<CatalogStatistics> x$13 = qual$1.copy$default$13();
            Option<String> x$14 = qual$1.copy$default$14();
            Option<String> x$15 = qual$1.copy$default$15();
            Seq<String> x$16 = qual$1.copy$default$16();
            boolean x$17 = qual$1.copy$default$17();
            boolean x$18 = qual$1.copy$default$18();
            Map<String, String> x$19 = qual$1.copy$default$19();
            Option<String> x$20 = qual$1.copy$default$20();
            oldDesc.table_$eq(qual$1.copy(x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20));
            CatalogTableType catalogTableType = oldDesc.table().tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
            if (!(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null)) {
                Predef$.MODULE$.assert(oldDesc.table().storage().locationUri().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Managed table should always have table location, as we will assign a default location to it if it doesn't have one.");
                Path oldDir = new Path(oldDesc.table().location());
                Path newDir = new Path(new Path(((DatabaseDesc)this.catalog().apply((Object)db)).db().locationUri()), newName);
                this.liftedTree5$1(oldDir, newDir, oldName, newName);
                CatalogTable qual$2 = oldDesc.table();
                Some x$21 = new Some((Object)newDir.toUri());
                Option<String> x$22 = qual$2.withNewStorage$default$2();
                Option<String> x$23 = qual$2.withNewStorage$default$3();
                boolean x$24 = qual$2.withNewStorage$default$4();
                Option<String> x$25 = qual$2.withNewStorage$default$5();
                Map<String, String> x$26 = qual$2.withNewStorage$default$6();
                oldDesc.table_$eq(qual$2.withNewStorage((Option<URI>)x$21, x$22, x$23, x$24, x$25, x$26));
                HashMap newPartitions = (HashMap)oldDesc.partitions().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        Map spec = (Map)tuple2._1();
                        CatalogTablePartition partition = (CatalogTablePartition)tuple2._2();
                        CatalogStorageFormat storage = partition.storage();
                        Option newLocationUri = storage.locationUri().map((Function1 & Serializable & scala.Serializable)uri -> new Path(uri.toString().replace(oldDir.toString(), newDir.toString())).toUri());
                        CatalogStorageFormat x$27 = storage.copy((Option<URI>)newLocationUri, storage.copy$default$2(), storage.copy$default$3(), storage.copy$default$4(), storage.copy$default$5(), storage.copy$default$6());
                        Map<String, String> x$28 = partition.copy$default$1();
                        Map<String, String> x$29 = partition.copy$default$3();
                        long x$30 = partition.copy$default$4();
                        long x$31 = partition.copy$default$5();
                        Option<CatalogStatistics> x$32 = partition.copy$default$6();
                        CatalogTablePartition newPartition = partition.copy(x$28, x$27, x$29, x$30, x$31, x$32);
                        return new Tuple2((Object)spec, (Object)newPartition);
                    }
                    throw new MatchError((Object)tuple2);
                }, HashMap$.MODULE$.canBuildFrom());
                oldDesc.partitions_$eq((HashMap<Map<String, String>, CatalogTablePartition>)newPartitions);
            }
            ((DatabaseDesc)this.catalog().apply((Object)db)).tables().put((Object)newName, (Object)oldDesc);
            ((DatabaseDesc)this.catalog().apply((Object)db)).tables().remove((Object)oldName);
        }
    }

    @Override
    public synchronized void alterTable(CatalogTable tableDefinition) {
        Map updatedProperties;
        Predef$.MODULE$.assert(tableDefinition.identifier().database().isDefined());
        String db = (String)tableDefinition.identifier().database().get();
        this.requireTableExists(db, tableDefinition.identifier().table());
        Map x$1 = updatedProperties = (Map)tableDefinition.properties().filter((Function1 & Serializable & scala.Serializable)kv -> BoxesRunTime.boxToBoolean((boolean)InMemoryCatalog.$anonfun$alterTable$1(kv)));
        TableIdentifier x$2 = tableDefinition.copy$default$1();
        CatalogTableType x$3 = tableDefinition.copy$default$2();
        CatalogStorageFormat x$4 = tableDefinition.copy$default$3();
        StructType x$5 = tableDefinition.copy$default$4();
        Option<String> x$6 = tableDefinition.copy$default$5();
        Seq<String> x$7 = tableDefinition.copy$default$6();
        Option<BucketSpec> x$8 = tableDefinition.copy$default$7();
        String x$9 = tableDefinition.copy$default$8();
        long x$10 = tableDefinition.copy$default$9();
        long x$11 = tableDefinition.copy$default$10();
        String x$12 = tableDefinition.copy$default$11();
        Option<CatalogStatistics> x$13 = tableDefinition.copy$default$13();
        Option<String> x$14 = tableDefinition.copy$default$14();
        Option<String> x$15 = tableDefinition.copy$default$15();
        Seq<String> x$16 = tableDefinition.copy$default$16();
        boolean x$17 = tableDefinition.copy$default$17();
        boolean x$18 = tableDefinition.copy$default$18();
        Map<String, String> x$19 = tableDefinition.copy$default$19();
        Option<String> x$20 = tableDefinition.copy$default$20();
        CatalogTable newTableDefinition = tableDefinition.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, (Map<String, String>)x$1, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)tableDefinition.identifier().table())).table_$eq(newTableDefinition);
    }

    @Override
    public synchronized void alterTableDataSchema(String db, String table, StructType newDataSchema) {
        StructType newSchema;
        this.requireTableExists(db, table);
        CatalogTable origTable = ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).table();
        StructType x$1 = newSchema = StructType$.MODULE$.apply((Seq<StructField>)((Seq)newDataSchema.$plus$plus(origTable.partitionSchema(), Seq$.MODULE$.canBuildFrom())));
        TableIdentifier x$2 = origTable.copy$default$1();
        CatalogTableType x$3 = origTable.copy$default$2();
        CatalogStorageFormat x$4 = origTable.copy$default$3();
        Option<String> x$5 = origTable.copy$default$5();
        Seq<String> x$6 = origTable.copy$default$6();
        Option<BucketSpec> x$7 = origTable.copy$default$7();
        String x$8 = origTable.copy$default$8();
        long x$9 = origTable.copy$default$9();
        long x$10 = origTable.copy$default$10();
        String x$11 = origTable.copy$default$11();
        Map<String, String> x$12 = origTable.copy$default$12();
        Option<CatalogStatistics> x$13 = origTable.copy$default$13();
        Option<String> x$14 = origTable.copy$default$14();
        Option<String> x$15 = origTable.copy$default$15();
        Seq<String> x$16 = origTable.copy$default$16();
        boolean x$17 = origTable.copy$default$17();
        boolean x$18 = origTable.copy$default$18();
        Map<String, String> x$19 = origTable.copy$default$19();
        Option<String> x$20 = origTable.copy$default$20();
        ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).table_$eq(origTable.copy(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20));
    }

    @Override
    public synchronized void alterTableStats(String db, String table, Option<CatalogStatistics> stats) {
        this.requireTableExists(db, table);
        CatalogTable origTable = ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).table();
        Option<CatalogStatistics> x$1 = stats;
        TableIdentifier x$2 = origTable.copy$default$1();
        CatalogTableType x$3 = origTable.copy$default$2();
        CatalogStorageFormat x$4 = origTable.copy$default$3();
        StructType x$5 = origTable.copy$default$4();
        Option<String> x$6 = origTable.copy$default$5();
        Seq<String> x$7 = origTable.copy$default$6();
        Option<BucketSpec> x$8 = origTable.copy$default$7();
        String x$9 = origTable.copy$default$8();
        long x$10 = origTable.copy$default$9();
        long x$11 = origTable.copy$default$10();
        String x$12 = origTable.copy$default$11();
        Map<String, String> x$13 = origTable.copy$default$12();
        Option<String> x$14 = origTable.copy$default$14();
        Option<String> x$15 = origTable.copy$default$15();
        Seq<String> x$16 = origTable.copy$default$16();
        boolean x$17 = origTable.copy$default$17();
        boolean x$18 = origTable.copy$default$18();
        Map<String, String> x$19 = origTable.copy$default$19();
        Option<String> x$20 = origTable.copy$default$20();
        ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).table_$eq(origTable.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$1, x$14, x$15, x$16, x$17, x$18, x$19, x$20));
    }

    @Override
    public synchronized CatalogTable getTable(String db, String table) {
        this.requireTableExists(db, table);
        return ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).table();
    }

    @Override
    public Seq<CatalogTable> getTablesByName(String db, Seq<String> tables) {
        this.requireDbExists(db);
        HashMap<String, TableDesc> hashMap = ((DatabaseDesc)this.catalog().apply((Object)db)).tables();
        return (Seq)((TraversableLike)tables.flatMap((Function1 & Serializable & scala.Serializable)key -> Option$.MODULE$.option2Iterable(hashMap.get(key)), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.table(), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public synchronized boolean tableExists(String db, String table) {
        return this.catalog().contains((Object)db) && ((DatabaseDesc)this.catalog().apply((Object)db)).tables().contains((Object)table);
    }

    @Override
    public synchronized Seq<String> listTables(String db) {
        this.requireDbExists(db);
        return (Seq)((DatabaseDesc)this.catalog().apply((Object)db)).tables().keySet().toSeq().sorted((Ordering)Ordering.String$.MODULE$);
    }

    @Override
    public synchronized Seq<String> listTables(String db, String pattern) {
        return StringUtils$.MODULE$.filterPattern(this.listTables(db), pattern);
    }

    @Override
    public synchronized Seq<String> listViews(String db, String pattern) {
        this.requireDbExists(db);
        Set views = ((HashMap)((DatabaseDesc)this.catalog().apply((Object)db)).tables().filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)InMemoryCatalog.$anonfun$listViews$1(x$5)))).keySet();
        return StringUtils$.MODULE$.filterPattern((Seq<String>)((Seq)views.toSeq().sorted((Ordering)Ordering.String$.MODULE$)), pattern);
    }

    @Override
    public void loadTable(String db, String table, String loadPath, boolean isOverwrite, boolean isSrcLocal) {
        throw QueryExecutionErrors$.MODULE$.methodNotImplementedError("loadTable");
    }

    @Override
    public void loadPartition(String db, String table, String loadPath, Map<String, String> partition, boolean isOverwrite, boolean inheritTableSpecs, boolean isSrcLocal) {
        throw QueryExecutionErrors$.MODULE$.methodNotImplementedError("loadPartition");
    }

    @Override
    public void loadDynamicPartitions(String db, String table, String loadPath, Map<String, String> partition, boolean replace, int numDP) {
        throw QueryExecutionErrors$.MODULE$.methodNotImplementedError("loadDynamicPartitions");
    }

    @Override
    public synchronized void createPartitions(String db, String table, Seq<CatalogTablePartition> newParts, boolean ignoreIfExists) {
        Seq dupSpecs;
        this.requireTableExists(db, table);
        HashMap<Map<String, String>, CatalogTablePartition> existingParts = ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions();
        Seq<CatalogTablePartition> parts = this.toCatalogPartitionSpec(newParts);
        if (!ignoreIfExists && (dupSpecs = (Seq)parts.collect((PartialFunction)new scala.Serializable(null, existingParts){
            public static final long serialVersionUID = 0L;
            private final HashMap existingParts$1;

            public final <A1 extends CatalogTablePartition, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (this.existingParts$1.contains(A1.spec())) {
                    return (B1)A1.spec();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(CatalogTablePartition x1) {
                CatalogTablePartition catalogTablePartition = x1;
                return this.existingParts$1.contains(catalogTablePartition.spec());
            }
            {
                this.existingParts$1 = existingParts$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).nonEmpty()) {
            throw new PartitionsAlreadyExistException(db, table, (Seq<Map<String, String>>)dupSpecs);
        }
        CatalogTable tableMeta = this.getTable(db, table);
        Seq<String> partitionColumnNames = tableMeta.partitionColumnNames();
        Path tablePath = new Path(tableMeta.location());
        parts.foreach((Function1 & Serializable & scala.Serializable)p -> {
            Path partitionPath = (Path)p.storage().locationUri().map((Function1 & Serializable & scala.Serializable)x$6 -> new Path(x$6)).getOrElse((Function0 & Serializable & scala.Serializable)() -> ExternalCatalogUtils$.MODULE$.generatePartitionPath(p.spec(), partitionColumnNames, tablePath));
            try {
                FileSystem fs = tablePath.getFileSystem($this.hadoopConfig);
                Object object = !fs.exists(partitionPath) ? BoxesRunTime.boxToBoolean((boolean)fs.mkdirs(partitionPath)) : BoxedUnit.UNIT;
            }
            catch (IOException e) {
                throw QueryExecutionErrors$.MODULE$.unableToCreatePartitionPathError(partitionPath, e);
            }
            CatalogStorageFormat x$1 = p.storage().copy((Option<URI>)new Some((Object)partitionPath.toUri()), p.storage().copy$default$2(), p.storage().copy$default$3(), p.storage().copy$default$4(), p.storage().copy$default$5(), p.storage().copy$default$6());
            Map<String, String> x$2 = p.copy$default$1();
            Map<String, String> x$3 = p.copy$default$3();
            long x$4 = p.copy$default$4();
            long x$5 = p.copy$default$5();
            Option<CatalogStatistics> x$62 = p.copy$default$6();
            return existingParts.put(p.spec(), (Object)p.copy(x$2, x$1, x$3, x$4, x$5, x$62));
        });
    }

    @Override
    public synchronized void dropPartitions(String db, String table, Seq<Map<String, String>> parts, boolean ignoreIfNotExists, boolean purge, boolean retainData) {
        boolean bl;
        Seq missingSpecs;
        this.requireTableExists(db, table);
        HashMap<Map<String, String>, CatalogTablePartition> existingParts = ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions();
        Seq<Map<String, String>> partSpecs = this.toCatalogPartitionSpecs(parts);
        if (!ignoreIfNotExists && (missingSpecs = (Seq)partSpecs.collect((PartialFunction)new scala.Serializable(null, existingParts){
            public static final long serialVersionUID = 0L;
            private final HashMap existingParts$2;

            public final <A1 extends Map<String, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (!this.existingParts$2.contains(A1)) {
                    return (B1)A1;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Map<String, String> x1) {
                Map<String, String> map = x1;
                return !this.existingParts$2.contains(map);
            }
            {
                this.existingParts$2 = existingParts$2;
            }
        }, Seq$.MODULE$.canBuildFrom())).nonEmpty()) {
            throw new NoSuchPartitionsException(db, table, (Seq<Map<String, String>>)missingSpecs);
        }
        if (retainData) {
            bl = false;
        } else {
            CatalogTableType catalogTableType = this.getTable(db, table).tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
            bl = !(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null);
        }
        boolean shouldRemovePartitionLocation = bl;
        partSpecs.foreach((Function1 & Serializable & scala.Serializable)p -> {
            Object object;
            if (existingParts.contains(p) && shouldRemovePartitionLocation) {
                boolean bl;
                Path partitionPath = new Path(((CatalogTablePartition)existingParts.apply(p)).location());
                try {
                    FileSystem fs = partitionPath.getFileSystem($this.hadoopConfig);
                    bl = fs.delete(partitionPath, true);
                }
                catch (IOException e) {
                    throw QueryExecutionErrors$.MODULE$.unableToDeletePartitionPathError(partitionPath, e);
                }
                object = BoxesRunTime.boxToBoolean((boolean)bl);
            } else {
                object = BoxedUnit.UNIT;
            }
            return existingParts.remove(p);
        });
    }

    @Override
    public synchronized void renamePartitions(String db, String table, Seq<Map<String, String>> fromSpecs, Seq<Map<String, String>> toSpecs) {
        Seq<Map<String, String>> specs = this.toCatalogPartitionSpecs(fromSpecs);
        Seq<Map<String, String>> newSpecs = this.toCatalogPartitionSpecs(toSpecs);
        Predef$.MODULE$.require(specs.size() == newSpecs.size(), (Function0 & Serializable & scala.Serializable)() -> "number of old and new partition specs differ");
        this.requirePartitionsExist(db, table, specs);
        this.requirePartitionsNotExist(db, table, newSpecs);
        CatalogTable tableMeta = this.getTable(db, table);
        Seq<String> partitionColumnNames = tableMeta.partitionColumnNames();
        Path tablePath = new Path(tableMeta.location());
        CatalogTableType catalogTableType = this.getTable(db, table).tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
        boolean shouldUpdatePartitionLocation = !(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null);
        HashMap<Map<String, String>, CatalogTablePartition> existingParts = ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions();
        ((IterableLike)specs.zip(newSpecs, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                CatalogTablePartition catalogTablePartition;
                Map oldSpec = (Map)tuple2._1();
                Map newSpec = (Map)tuple2._2();
                CatalogTablePartition oldPartition = this.getPartition(db, table, (Map<String, String>)oldSpec);
                if (shouldUpdatePartitionLocation) {
                    Path oldPartPath = new Path(oldPartition.location());
                    Path newPartPath = ExternalCatalogUtils$.MODULE$.generatePartitionPath((Map<String, String>)newSpec, partitionColumnNames, tablePath);
                    try {
                        FileSystem fs = tablePath.getFileSystem($this.hadoopConfig);
                        fs.mkdirs(newPartPath);
                        if (!fs.rename(oldPartPath, newPartPath)) {
                            throw new IOException(new StringBuilder(48).append("Renaming partition path from ").append(oldPartPath).append(" to ").append(newPartPath).append(" returned false").toString());
                        }
                    }
                    catch (IOException e) {
                        throw QueryExecutionErrors$.MODULE$.unableToRenamePartitionPathError(oldPartPath, e);
                    }
                    catalogTablePartition = oldPartition.copy((Map<String, String>)newSpec, oldPartition.storage().copy((Option<URI>)new Some((Object)newPartPath.toUri()), oldPartition.storage().copy$default$2(), oldPartition.storage().copy$default$3(), oldPartition.storage().copy$default$4(), oldPartition.storage().copy$default$5(), oldPartition.storage().copy$default$6()), oldPartition.copy$default$3(), oldPartition.copy$default$4(), oldPartition.copy$default$5(), oldPartition.copy$default$6());
                } else {
                    catalogTablePartition = oldPartition.copy((Map<String, String>)newSpec, oldPartition.copy$default$2(), oldPartition.copy$default$3(), oldPartition.copy$default$4(), oldPartition.copy$default$5(), oldPartition.copy$default$6());
                }
                CatalogTablePartition newPartition = catalogTablePartition;
                existingParts.remove((Object)oldSpec);
                return existingParts.put((Object)newSpec, (Object)newPartition);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    @Override
    public synchronized void alterPartitions(String db, String table, Seq<CatalogTablePartition> alterParts) {
        Seq<CatalogTablePartition> parts = this.toCatalogPartitionSpec(alterParts);
        this.requirePartitionsExist(db, table, (Seq<Map<String, String>>)((Seq)parts.map((Function1 & Serializable & scala.Serializable)p -> p.spec(), Seq$.MODULE$.canBuildFrom())));
        parts.foreach((Function1 & Serializable & scala.Serializable)p -> ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().put(p.spec(), p));
    }

    @Override
    public synchronized CatalogTablePartition getPartition(String db, String table, Map<String, String> partSpec) {
        Map spec = (Map)this.toCatalogPartitionSpec().apply(partSpec);
        this.requirePartitionsExist(db, table, (Seq<Map<String, String>>)((Seq)new .colon.colon((Object)spec, (List)Nil$.MODULE$)));
        return (CatalogTablePartition)((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().apply((Object)spec);
    }

    @Override
    public synchronized Option<CatalogTablePartition> getPartitionOption(String db, String table, Map<String, String> partSpec) {
        Map spec = (Map)this.toCatalogPartitionSpec().apply(partSpec);
        if (!this.partitionExists(db, table, (Map<String, String>)spec)) {
            return None$.MODULE$;
        }
        return Option$.MODULE$.apply(((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().apply((Object)spec));
    }

    @Override
    public synchronized Seq<String> listPartitionNames(String db, String table, Option<Map<String, String>> partSpec) {
        Seq<String> partitionColumnNames = this.getTable(db, table).partitionColumnNames();
        Option partialSpec = partSpec.map(this.toCatalogPartitionSpec());
        return (Seq)((SeqLike)this.listPartitions(db, table, (Option<Map<String, String>>)partialSpec).map((Function1 & Serializable & scala.Serializable)partition -> ((TraversableOnce)partitionColumnNames.map((Function1 & Serializable & scala.Serializable)name -> {
            String partValue = partition.spec().apply(name) == null ? ExternalCatalogUtils$.MODULE$.DEFAULT_PARTITION_NAME() : ExternalCatalogUtils$.MODULE$.escapePathName((String)partition.spec().apply(name));
            return new StringBuilder(1).append(ExternalCatalogUtils$.MODULE$.escapePathName((String)name)).append("=").append(partValue).toString();
        }, Seq$.MODULE$.canBuildFrom())).mkString("/"), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$);
    }

    @Override
    public Option<Map<String, String>> listPartitionNames$default$3() {
        return None$.MODULE$;
    }

    @Override
    public synchronized Seq<CatalogTablePartition> listPartitions(String db, String table, Option<Map<String, String>> partialSpec) {
        this.requireTableExists(db, table);
        Option option = partialSpec.map(this.toCatalogPartitionSpec());
        if (None$.MODULE$.equals(option)) {
            return ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().values().toSeq();
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Map partial = (Map)some.value();
            return (Seq)((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().toSeq().collect((PartialFunction)new scala.Serializable(null, partial){
                public static final long serialVersionUID = 0L;
                private final Map partial$1;

                public final <A1 extends Tuple2<Map<String, String>, CatalogTablePartition>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 != null) {
                        Map spec = (Map)A1._1();
                        CatalogTablePartition partition = (CatalogTablePartition)A1._2();
                        if (ExternalCatalogUtils$.MODULE$.isPartialPartitionSpec((Map<String, String>)this.partial$1, (Map<String, String>)spec)) {
                            return (B1)partition;
                        }
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Tuple2<Map<String, String>, CatalogTablePartition> x1) {
                    Map spec;
                    Tuple2<Map<String, String>, CatalogTablePartition> tuple2 = x1;
                    return tuple2 != null && ExternalCatalogUtils$.MODULE$.isPartialPartitionSpec((Map<String, String>)this.partial$1, (Map<String, String>)(spec = (Map)tuple2._1()));
                }
                {
                    this.partial$1 = partial$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
        }
        throw new MatchError((Object)option);
    }

    @Override
    public Option<Map<String, String>> listPartitions$default$3() {
        return None$.MODULE$;
    }

    @Override
    public Seq<CatalogTablePartition> listPartitionsByFilter(String db, String table, Seq<Expression> predicates, String defaultTimeZoneId) {
        CatalogTable catalogTable = this.getTable(db, table);
        Seq<CatalogTablePartition> allPartitions = this.listPartitions(db, table, this.listPartitions$default$3());
        return ExternalCatalogUtils$.MODULE$.prunePartitionsByFilter(catalogTable, allPartitions, predicates, defaultTimeZoneId);
    }

    @Override
    public void createFunction(String db, CatalogFunction func) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireDbExists(db);
            this.requireFunctionNotExists(db, func.identifier().funcName());
            ((DatabaseDesc)this.catalog().apply((Object)db)).functions().put((Object)func.identifier().funcName(), (Object)func);
        }
    }

    @Override
    public void dropFunction(String db, String funcName) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireFunctionExists(db, funcName);
            ((DatabaseDesc)this.catalog().apply((Object)db)).functions().remove((Object)funcName);
        }
    }

    @Override
    public void alterFunction(String db, CatalogFunction func) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireDbExists(db);
            this.requireFunctionExists(db, func.identifier().funcName());
            ((DatabaseDesc)this.catalog().apply((Object)db)).functions().put((Object)func.identifier().funcName(), (Object)func);
        }
    }

    @Override
    public void renameFunction(String db, String oldName, String newName) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireFunctionExists(db, oldName);
            this.requireFunctionNotExists(db, newName);
            CatalogFunction qual$1 = this.getFunction(db, oldName);
            FunctionIdentifier x$1 = new FunctionIdentifier(newName, (Option<String>)new Some((Object)db));
            String x$2 = qual$1.copy$default$2();
            Seq<FunctionResource> x$3 = qual$1.copy$default$3();
            CatalogFunction newFunc = qual$1.copy(x$1, x$2, x$3);
            ((DatabaseDesc)this.catalog().apply((Object)db)).functions().remove((Object)oldName);
            ((DatabaseDesc)this.catalog().apply((Object)db)).functions().put((Object)newName, (Object)newFunc);
        }
    }

    @Override
    public synchronized CatalogFunction getFunction(String db, String funcName) {
        this.requireFunctionExists(db, funcName);
        return (CatalogFunction)((DatabaseDesc)this.catalog().apply((Object)db)).functions().apply((Object)funcName);
    }

    @Override
    public synchronized boolean functionExists(String db, String funcName) {
        this.requireDbExists(db);
        return ((DatabaseDesc)this.catalog().apply((Object)db)).functions().contains((Object)funcName);
    }

    @Override
    public synchronized Seq<String> listFunctions(String db, String pattern) {
        this.requireDbExists(db);
        return StringUtils$.MODULE$.filterPattern((Seq<String>)((DatabaseDesc)this.catalog().apply((Object)db)).functions().keysIterator().toSeq(), pattern);
    }

    public static final /* synthetic */ void $anonfun$requirePartitionsExist$1(InMemoryCatalog $this, String db$1, String table$1, Map s) {
        if (!$this.partitionExists(db$1, table$1, (Map<String, String>)s)) {
            throw new NoSuchPartitionException(db$1, table$1, (Map<String, String>)s);
        }
    }

    public static final /* synthetic */ void $anonfun$requirePartitionsNotExist$1(InMemoryCatalog $this, String db$2, String table$2, Map s) {
        if ($this.partitionExists(db$2, table$2, (Map<String, String>)s)) {
            throw new PartitionAlreadyExistsException(db$2, table$2, (Map<String, String>)s);
        }
    }

    private final /* synthetic */ boolean liftedTree1$1(CatalogDatabase dbDefinition$1) {
        boolean bl;
        try {
            Path location = new Path(dbDefinition$1.locationUri());
            FileSystem fs = location.getFileSystem(this.hadoopConfig);
            bl = fs.mkdirs(location);
        }
        catch (IOException e) {
            throw QueryExecutionErrors$.MODULE$.unableToCreateDatabaseAsFailedToCreateDirectoryError(dbDefinition$1, e);
        }
        return bl;
    }

    private final /* synthetic */ boolean liftedTree2$1(CatalogDatabase dbDefinition$2) {
        boolean bl;
        try {
            Path location = new Path(dbDefinition$2.locationUri());
            FileSystem fs = location.getFileSystem(this.hadoopConfig);
            bl = fs.delete(location, true);
        }
        catch (IOException e) {
            throw QueryExecutionErrors$.MODULE$.unableToDropDatabaseAsFailedToDeleteDirectoryError(dbDefinition$2, e);
        }
        return bl;
    }

    private final /* synthetic */ boolean liftedTree3$1(Path defaultTableLocation$1, String table$3) {
        boolean bl;
        try {
            FileSystem fs = defaultTableLocation$1.getFileSystem(this.hadoopConfig);
            bl = fs.mkdirs(defaultTableLocation$1);
        }
        catch (IOException e) {
            throw QueryExecutionErrors$.MODULE$.unableToCreateTableAsFailedToCreateDirectoryError(table$3, defaultTableLocation$1, e);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$createTable$1(Tuple2 x$2) {
        Object object = x$2._1();
        String string = "comment";
        return object == null ? string != null : !object.equals(string);
    }

    public static final /* synthetic */ boolean $anonfun$dropTable$2(InMemoryCatalog $this, URI loc) {
        boolean bl;
        Path partitionPath = new Path(loc);
        try {
            FileSystem fs = partitionPath.getFileSystem($this.hadoopConfig);
            bl = fs.delete(partitionPath, true);
        }
        catch (IOException e) {
            throw QueryExecutionErrors$.MODULE$.unableToDeletePartitionPathError(partitionPath, e);
        }
        return bl;
    }

    private final /* synthetic */ boolean liftedTree4$1(Path dir$1, String table$4) {
        boolean bl;
        try {
            FileSystem fs = dir$1.getFileSystem(this.hadoopConfig);
            bl = fs.delete(dir$1, true);
        }
        catch (IOException e) {
            throw QueryExecutionErrors$.MODULE$.unableToDropTableAsFailedToDeleteDirectoryError(table$4, dir$1, e);
        }
        return bl;
    }

    private final /* synthetic */ boolean liftedTree5$1(Path oldDir$1, Path newDir$1, String oldName$1, String newName$1) {
        boolean bl;
        try {
            FileSystem fs = oldDir$1.getFileSystem(this.hadoopConfig);
            bl = fs.rename(oldDir$1, newDir$1);
        }
        catch (IOException e) {
            throw QueryExecutionErrors$.MODULE$.unableToRenameTableAsFailedToRenameDirectoryError(oldName$1, newName$1, oldDir$1, e);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$alterTable$1(Tuple2 kv) {
        Object object = kv._1();
        String string = "comment";
        return object == null ? string != null : !object.equals(string);
    }

    public static final /* synthetic */ boolean $anonfun$listViews$1(Tuple2 x$5) {
        CatalogTableType catalogTableType = ((TableDesc)x$5._2()).table().tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        return !(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null);
    }

    public InMemoryCatalog(SparkConf conf, Configuration hadoopConfig) {
        this.hadoopConfig = hadoopConfig;
        ExternalCatalog.$init$(this);
        this.catalog = new HashMap();
    }

    private class DatabaseDesc {
        private CatalogDatabase db;
        private final HashMap<String, TableDesc> tables;
        private final HashMap<String, CatalogFunction> functions;
        public final /* synthetic */ InMemoryCatalog $outer;

        public CatalogDatabase db() {
            return this.db;
        }

        public void db_$eq(CatalogDatabase x$1) {
            this.db = x$1;
        }

        public HashMap<String, TableDesc> tables() {
            return this.tables;
        }

        public HashMap<String, CatalogFunction> functions() {
            return this.functions;
        }

        public /* synthetic */ InMemoryCatalog org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$DatabaseDesc$$$outer() {
            return this.$outer;
        }

        public DatabaseDesc(InMemoryCatalog $outer, CatalogDatabase db) {
            this.db = db;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.tables = new HashMap();
            this.functions = new HashMap();
        }
    }

    private class TableDesc {
        private CatalogTable table;
        private HashMap<Map<String, String>, CatalogTablePartition> partitions;
        public final /* synthetic */ InMemoryCatalog $outer;

        public CatalogTable table() {
            return this.table;
        }

        public void table_$eq(CatalogTable x$1) {
            this.table = x$1;
        }

        public HashMap<Map<String, String>, CatalogTablePartition> partitions() {
            return this.partitions;
        }

        public void partitions_$eq(HashMap<Map<String, String>, CatalogTablePartition> x$1) {
            this.partitions = x$1;
        }

        public /* synthetic */ InMemoryCatalog org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$TableDesc$$$outer() {
            return this.$outer;
        }

        public TableDesc(InMemoryCatalog $outer, CatalogTable table) {
            this.table = table;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.partitions = new HashMap();
        }
    }
}

